/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaoboleto.cresol;

import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.EnderecoPessoa;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.UnidadeFederacao;
import br.com.elotech.tributos.domain.cnab240.CNAB240CodigoEspecieTitulo;
import br.com.elotech.tributos.domain.cnab240.CNAB240CodigoJuros;
import br.com.elotech.tributos.domain.cnab240.CNAB240CodigoMulta;
import br.com.elotech.tributos.domain.cnab240.ParametroCNAB240;
import br.com.elotech.tributos.enums.integracaoboleto.cresol.TipoJurosCresol;
import br.com.elotech.tributos.enums.integracaoboleto.cresol.TipoMultaCresol;
import br.com.elotech.tributos.enums.integracaoboleto.cresol.TipoPessoaCresol;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public class EmissaoBoletoCresolDTO {
    private Long idEspecie;
    private Long docPagador;
    private String pagadorNome;
    private String pagadorEndereco;
    private String pagadorBairro;
    private Long pagadorCep;
    private String pagadorCidade;
    private String pagadorUf;
    private String nossoNumero;
    private String numeroDocumento;
    private String dtVencimento;
    private String dtDocumento;
    private BigDecimal valorNominal;
    private Long tipoPagador;
    @JsonProperty(value="cdTipoJuros")
    private TipoJurosCresol tipoJuros;
    private BigDecimal valorJuros;
    @JsonProperty(value="cdTipoMulta")
    private TipoMultaCresol tipoMulta;
    private BigDecimal valorMulta;

    public static EmissaoBoletoCresolDTO from(Bloqueto boleto, ParametroCNAB240 parametroCNAB240) {
        EmissaoBoletoCresolDTO emissaoBoletoCresolDTO = new EmissaoBoletoCresolDTO();
        emissaoBoletoCresolDTO.setIdEspecie((Long)Optional.ofNullable(parametroCNAB240).map(ParametroCNAB240::getIdEspecieTitulo).map(CNAB240CodigoEspecieTitulo::getId).orElse(null));
        if (Objects.isNull(boleto)) {
            return emissaoBoletoCresolDTO;
        }
        Pessoa pessoa = boleto.getPessoa();
        EnderecoPessoa enderecoPessoa = pessoa.getEnderecoPrincipal();
        emissaoBoletoCresolDTO.setDocPagador(Long.valueOf(Long.parseLong(pessoa.getCnpjCpf())));
        emissaoBoletoCresolDTO.setPagadorNome(pessoa.getNome());
        emissaoBoletoCresolDTO.setPagadorEndereco((String)Optional.ofNullable(enderecoPessoa).map(EnderecoPessoa::getLogradouro).map(Logradouro::getDescricao).orElse(null));
        emissaoBoletoCresolDTO.setPagadorBairro((String)Optional.ofNullable(enderecoPessoa).map(EnderecoPessoa::getBairro).map(Bairro::getDescricao).orElse(null));
        emissaoBoletoCresolDTO.setPagadorCep((Long)Optional.ofNullable(enderecoPessoa).map(EnderecoPessoa::getCep).orElse(null));
        emissaoBoletoCresolDTO.setPagadorCidade((String)Optional.ofNullable(enderecoPessoa).map(EnderecoPessoa::getCidade).map(Cidade::getDescricao).orElse(null));
        emissaoBoletoCresolDTO.setPagadorUf((String)Optional.ofNullable(enderecoPessoa).map(EnderecoPessoa::getUnidadeFederacao).map(UnidadeFederacao::getUnidadeFederacao).map(String::toUpperCase).orElse(null));
        emissaoBoletoCresolDTO.setNumeroDocumento(boleto.getNossoNumero());
        emissaoBoletoCresolDTO.setNossoNumero(boleto.getNossoNumero());
        emissaoBoletoCresolDTO.setDtVencimento(boleto.getDataVencimento().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        emissaoBoletoCresolDTO.setDtDocumento(boleto.getDataEmissao().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        emissaoBoletoCresolDTO.setValorNominal(boleto.getValorBloqueto());
        emissaoBoletoCresolDTO.setTipoPagador(TipoPessoa.FISICA.equals((Object)pessoa.getTipoPessoa()) ? TipoPessoaCresol.FISICA.getValue() : TipoPessoaCresol.JURIDICA.getValue());
        emissaoBoletoCresolDTO.setTipoJuros(Optional.ofNullable(parametroCNAB240).map(ParametroCNAB240::getCodigoJuros).map(CNAB240CodigoJuros::getId).map(TipoJurosCresol::findByCodigo).orElse(TipoJurosCresol.ISENTO));
        emissaoBoletoCresolDTO.setValorJuros((BigDecimal)Optional.ofNullable(parametroCNAB240).map(ParametroCNAB240::getValorJurosDiaTaxa).orElse(null));
        emissaoBoletoCresolDTO.setTipoMulta(Optional.ofNullable(parametroCNAB240).map(ParametroCNAB240::getCodigoMulta).map(CNAB240CodigoMulta::getId).map(TipoMultaCresol::findByCodigo).orElse(TipoMultaCresol.ISENTO));
        emissaoBoletoCresolDTO.setValorMulta((BigDecimal)Optional.ofNullable(parametroCNAB240).map(ParametroCNAB240::getValorPercentualMulta).orElse(null));
        return emissaoBoletoCresolDTO;
    }

    @Generated
    public EmissaoBoletoCresolDTO() {
    }

    @Generated
    public Long getIdEspecie() {
        return this.idEspecie;
    }

    @Generated
    public Long getDocPagador() {
        return this.docPagador;
    }

    @Generated
    public String getPagadorNome() {
        return this.pagadorNome;
    }

    @Generated
    public String getPagadorEndereco() {
        return this.pagadorEndereco;
    }

    @Generated
    public String getPagadorBairro() {
        return this.pagadorBairro;
    }

    @Generated
    public Long getPagadorCep() {
        return this.pagadorCep;
    }

    @Generated
    public String getPagadorCidade() {
        return this.pagadorCidade;
    }

    @Generated
    public String getPagadorUf() {
        return this.pagadorUf;
    }

    @Generated
    public String getNossoNumero() {
        return this.nossoNumero;
    }

    @Generated
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Generated
    public String getDtVencimento() {
        return this.dtVencimento;
    }

    @Generated
    public String getDtDocumento() {
        return this.dtDocumento;
    }

    @Generated
    public BigDecimal getValorNominal() {
        return this.valorNominal;
    }

    @Generated
    public Long getTipoPagador() {
        return this.tipoPagador;
    }

    @Generated
    public TipoJurosCresol getTipoJuros() {
        return this.tipoJuros;
    }

    @Generated
    public BigDecimal getValorJuros() {
        return this.valorJuros;
    }

    @Generated
    public TipoMultaCresol getTipoMulta() {
        return this.tipoMulta;
    }

    @Generated
    public BigDecimal getValorMulta() {
        return this.valorMulta;
    }

    @Generated
    public void setIdEspecie(Long idEspecie) {
        this.idEspecie = idEspecie;
    }

    @Generated
    public void setDocPagador(Long docPagador) {
        this.docPagador = docPagador;
    }

    @Generated
    public void setPagadorNome(String pagadorNome) {
        this.pagadorNome = pagadorNome;
    }

    @Generated
    public void setPagadorEndereco(String pagadorEndereco) {
        this.pagadorEndereco = pagadorEndereco;
    }

    @Generated
    public void setPagadorBairro(String pagadorBairro) {
        this.pagadorBairro = pagadorBairro;
    }

    @Generated
    public void setPagadorCep(Long pagadorCep) {
        this.pagadorCep = pagadorCep;
    }

    @Generated
    public void setPagadorCidade(String pagadorCidade) {
        this.pagadorCidade = pagadorCidade;
    }

    @Generated
    public void setPagadorUf(String pagadorUf) {
        this.pagadorUf = pagadorUf;
    }

    @Generated
    public void setNossoNumero(String nossoNumero) {
        this.nossoNumero = nossoNumero;
    }

    @Generated
    public void setNumeroDocumento(String numeroDocumento) {
        this.numeroDocumento = numeroDocumento;
    }

    @Generated
    public void setDtVencimento(String dtVencimento) {
        this.dtVencimento = dtVencimento;
    }

    @Generated
    public void setDtDocumento(String dtDocumento) {
        this.dtDocumento = dtDocumento;
    }

    @Generated
    public void setValorNominal(BigDecimal valorNominal) {
        this.valorNominal = valorNominal;
    }

    @Generated
    public void setTipoPagador(Long tipoPagador) {
        this.tipoPagador = tipoPagador;
    }

    @JsonProperty(value="cdTipoJuros")
    @Generated
    public void setTipoJuros(TipoJurosCresol tipoJuros) {
        this.tipoJuros = tipoJuros;
    }

    @Generated
    public void setValorJuros(BigDecimal valorJuros) {
        this.valorJuros = valorJuros;
    }

    @JsonProperty(value="cdTipoMulta")
    @Generated
    public void setTipoMulta(TipoMultaCresol tipoMulta) {
        this.tipoMulta = tipoMulta;
    }

    @Generated
    public void setValorMulta(BigDecimal valorMulta) {
        this.valorMulta = valorMulta;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmissaoBoletoCresolDTO)) {
            return false;
        }
        EmissaoBoletoCresolDTO other = (EmissaoBoletoCresolDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idEspecie = this.getIdEspecie();
        Long other$idEspecie = other.getIdEspecie();
        if (this$idEspecie == null ? other$idEspecie != null : !((Object)this$idEspecie).equals(other$idEspecie)) {
            return false;
        }
        Long this$docPagador = this.getDocPagador();
        Long other$docPagador = other.getDocPagador();
        if (this$docPagador == null ? other$docPagador != null : !((Object)this$docPagador).equals(other$docPagador)) {
            return false;
        }
        Long this$pagadorCep = this.getPagadorCep();
        Long other$pagadorCep = other.getPagadorCep();
        if (this$pagadorCep == null ? other$pagadorCep != null : !((Object)this$pagadorCep).equals(other$pagadorCep)) {
            return false;
        }
        Long this$tipoPagador = this.getTipoPagador();
        Long other$tipoPagador = other.getTipoPagador();
        if (this$tipoPagador == null ? other$tipoPagador != null : !((Object)this$tipoPagador).equals(other$tipoPagador)) {
            return false;
        }
        String this$pagadorNome = this.getPagadorNome();
        String other$pagadorNome = other.getPagadorNome();
        if (this$pagadorNome == null ? other$pagadorNome != null : !this$pagadorNome.equals(other$pagadorNome)) {
            return false;
        }
        String this$pagadorEndereco = this.getPagadorEndereco();
        String other$pagadorEndereco = other.getPagadorEndereco();
        if (this$pagadorEndereco == null ? other$pagadorEndereco != null : !this$pagadorEndereco.equals(other$pagadorEndereco)) {
            return false;
        }
        String this$pagadorBairro = this.getPagadorBairro();
        String other$pagadorBairro = other.getPagadorBairro();
        if (this$pagadorBairro == null ? other$pagadorBairro != null : !this$pagadorBairro.equals(other$pagadorBairro)) {
            return false;
        }
        String this$pagadorCidade = this.getPagadorCidade();
        String other$pagadorCidade = other.getPagadorCidade();
        if (this$pagadorCidade == null ? other$pagadorCidade != null : !this$pagadorCidade.equals(other$pagadorCidade)) {
            return false;
        }
        String this$pagadorUf = this.getPagadorUf();
        String other$pagadorUf = other.getPagadorUf();
        if (this$pagadorUf == null ? other$pagadorUf != null : !this$pagadorUf.equals(other$pagadorUf)) {
            return false;
        }
        String this$nossoNumero = this.getNossoNumero();
        String other$nossoNumero = other.getNossoNumero();
        if (this$nossoNumero == null ? other$nossoNumero != null : !this$nossoNumero.equals(other$nossoNumero)) {
            return false;
        }
        String this$numeroDocumento = this.getNumeroDocumento();
        String other$numeroDocumento = other.getNumeroDocumento();
        if (this$numeroDocumento == null ? other$numeroDocumento != null : !this$numeroDocumento.equals(other$numeroDocumento)) {
            return false;
        }
        String this$dtVencimento = this.getDtVencimento();
        String other$dtVencimento = other.getDtVencimento();
        if (this$dtVencimento == null ? other$dtVencimento != null : !this$dtVencimento.equals(other$dtVencimento)) {
            return false;
        }
        String this$dtDocumento = this.getDtDocumento();
        String other$dtDocumento = other.getDtDocumento();
        if (this$dtDocumento == null ? other$dtDocumento != null : !this$dtDocumento.equals(other$dtDocumento)) {
            return false;
        }
        BigDecimal this$valorNominal = this.getValorNominal();
        BigDecimal other$valorNominal = other.getValorNominal();
        if (this$valorNominal == null ? other$valorNominal != null : !((Object)this$valorNominal).equals(other$valorNominal)) {
            return false;
        }
        TipoJurosCresol this$tipoJuros = this.getTipoJuros();
        TipoJurosCresol other$tipoJuros = other.getTipoJuros();
        if (this$tipoJuros == null ? other$tipoJuros != null : !this$tipoJuros.equals(other$tipoJuros)) {
            return false;
        }
        BigDecimal this$valorJuros = this.getValorJuros();
        BigDecimal other$valorJuros = other.getValorJuros();
        if (this$valorJuros == null ? other$valorJuros != null : !((Object)this$valorJuros).equals(other$valorJuros)) {
            return false;
        }
        TipoMultaCresol this$tipoMulta = this.getTipoMulta();
        TipoMultaCresol other$tipoMulta = other.getTipoMulta();
        if (this$tipoMulta == null ? other$tipoMulta != null : !this$tipoMulta.equals(other$tipoMulta)) {
            return false;
        }
        BigDecimal this$valorMulta = this.getValorMulta();
        BigDecimal other$valorMulta = other.getValorMulta();
        return !(this$valorMulta == null ? other$valorMulta != null : !((Object)this$valorMulta).equals(other$valorMulta));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EmissaoBoletoCresolDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idEspecie = this.getIdEspecie();
        result = result * 59 + ($idEspecie == null ? 43 : ((Object)$idEspecie).hashCode());
        Long $docPagador = this.getDocPagador();
        result = result * 59 + ($docPagador == null ? 43 : ((Object)$docPagador).hashCode());
        Long $pagadorCep = this.getPagadorCep();
        result = result * 59 + ($pagadorCep == null ? 43 : ((Object)$pagadorCep).hashCode());
        Long $tipoPagador = this.getTipoPagador();
        result = result * 59 + ($tipoPagador == null ? 43 : ((Object)$tipoPagador).hashCode());
        String $pagadorNome = this.getPagadorNome();
        result = result * 59 + ($pagadorNome == null ? 43 : $pagadorNome.hashCode());
        String $pagadorEndereco = this.getPagadorEndereco();
        result = result * 59 + ($pagadorEndereco == null ? 43 : $pagadorEndereco.hashCode());
        String $pagadorBairro = this.getPagadorBairro();
        result = result * 59 + ($pagadorBairro == null ? 43 : $pagadorBairro.hashCode());
        String $pagadorCidade = this.getPagadorCidade();
        result = result * 59 + ($pagadorCidade == null ? 43 : $pagadorCidade.hashCode());
        String $pagadorUf = this.getPagadorUf();
        result = result * 59 + ($pagadorUf == null ? 43 : $pagadorUf.hashCode());
        String $nossoNumero = this.getNossoNumero();
        result = result * 59 + ($nossoNumero == null ? 43 : $nossoNumero.hashCode());
        String $numeroDocumento = this.getNumeroDocumento();
        result = result * 59 + ($numeroDocumento == null ? 43 : $numeroDocumento.hashCode());
        String $dtVencimento = this.getDtVencimento();
        result = result * 59 + ($dtVencimento == null ? 43 : $dtVencimento.hashCode());
        String $dtDocumento = this.getDtDocumento();
        result = result * 59 + ($dtDocumento == null ? 43 : $dtDocumento.hashCode());
        BigDecimal $valorNominal = this.getValorNominal();
        result = result * 59 + ($valorNominal == null ? 43 : ((Object)$valorNominal).hashCode());
        TipoJurosCresol $tipoJuros = this.getTipoJuros();
        result = result * 59 + ($tipoJuros == null ? 43 : $tipoJuros.hashCode());
        BigDecimal $valorJuros = this.getValorJuros();
        result = result * 59 + ($valorJuros == null ? 43 : ((Object)$valorJuros).hashCode());
        TipoMultaCresol $tipoMulta = this.getTipoMulta();
        result = result * 59 + ($tipoMulta == null ? 43 : $tipoMulta.hashCode());
        BigDecimal $valorMulta = this.getValorMulta();
        result = result * 59 + ($valorMulta == null ? 43 : ((Object)$valorMulta).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EmissaoBoletoCresolDTO(idEspecie=" + this.getIdEspecie() + ", docPagador=" + this.getDocPagador() + ", pagadorNome=" + this.getPagadorNome() + ", pagadorEndereco=" + this.getPagadorEndereco() + ", pagadorBairro=" + this.getPagadorBairro() + ", pagadorCep=" + this.getPagadorCep() + ", pagadorCidade=" + this.getPagadorCidade() + ", pagadorUf=" + this.getPagadorUf() + ", nossoNumero=" + this.getNossoNumero() + ", numeroDocumento=" + this.getNumeroDocumento() + ", dtVencimento=" + this.getDtVencimento() + ", dtDocumento=" + this.getDtDocumento() + ", valorNominal=" + String.valueOf(this.getValorNominal()) + ", tipoPagador=" + this.getTipoPagador() + ", tipoJuros=" + String.valueOf(this.getTipoJuros()) + ", valorJuros=" + String.valueOf(this.getValorJuros()) + ", tipoMulta=" + String.valueOf(this.getTipoMulta()) + ", valorMulta=" + String.valueOf(this.getValorMulta()) + ")";
    }
}

