/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaoboleto.bradesco;

import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.EnderecoPessoa;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.dto.integracaoboleto.bradesco.CalendarioQrCodeBradescoDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bradesco.DevedorBradescoDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bradesco.GerarQrCodePixBradescoRequestDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bradesco.InfoAdcionaisQrCodeBradescoDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bradesco.ValorQrCodeBradescoDTO;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GerarQrCodePixBradescoRequestDTO {
    private static final String FORMATO_VALOR_DECIMAL = "#00000000000000.00";
    private static final String CODIGO_DE_BARRAS = "codbarra";
    private DevedorBradescoDTO devedor;
    private String chave;
    private ValorQrCodeBradescoDTO valor;
    private CalendarioQrCodeBradescoDTO calendario;
    private List<InfoAdcionaisQrCodeBradescoDTO> infoAdicionais;
    private String solicitacaoPagador;

    public static GerarQrCodePixBradescoRequestDTO from(Bloqueto boleto) {
        Pessoa pessoa = boleto.getPessoa();
        EnderecoPessoa enderecoPrincipal = pessoa.getEnderecoPrincipal();
        if (StringUtils.isBlank((CharSequence)pessoa.getCnpjCpfSemMascara())) {
            throw new EloValidationException("CPF/CNPJ \u00e9 obrigat\u00f3rio para para a gera\u00e7\u00e3o de pix para o Bradesco: ID da Pessoa " + pessoa.getId());
        }
        DevedorBradescoDTO devedor = DevedorBradescoDTO.builder().cpf(TipoPessoa.FISICA.equals((Object)pessoa.getTipoPessoa()) ? pessoa.getCnpjCpfSemMascara() : null).cnpj(TipoPessoa.JURIDICA.equals((Object)pessoa.getTipoPessoa()) ? pessoa.getCnpjCpfSemMascara() : null).nome(pessoa.getNome()).cep(Optional.ofNullable(enderecoPrincipal).map(EnderecoPessoa::getCep).map(cep -> StringUtils.leftPad((String)cep.toString(), (int)8, (String)"0")).orElse("")).cidade(Optional.ofNullable(enderecoPrincipal).map(EnderecoPessoa::getCidade).map(Cidade::getDescricao).orElse("")).uf(Optional.ofNullable(enderecoPrincipal).map(EnderecoPessoa::getCidade).map(Cidade::getUnidadeFederacao).orElse("")).logradouro(Optional.ofNullable(enderecoPrincipal).map(EnderecoPessoa::getLogradouro).map(Logradouro::getDescricao).orElse("")).build();
        ValorQrCodeBradescoDTO valor = ValorQrCodeBradescoDTO.builder().original(GerarQrCodePixBradescoRequestDTO.formatarDecimalFormat((BigDecimal)boleto.getValorBloqueto())).build();
        CalendarioQrCodeBradescoDTO calendario = CalendarioQrCodeBradescoDTO.builder().dataDeVencimento(boleto.getDataVencimento().toString()).validadeAposVencimento(Integer.valueOf(0)).build();
        List infoAdicionais = InfoAdcionaisQrCodeBradescoDTO.builder().nome("codbarra").valor(boleto.getCodigoBarras()).build().toList();
        return GerarQrCodePixBradescoRequestDTO.builder().calendario(calendario).devedor(devedor).valor(valor).chave(boleto.getModeloBloqueto().getConvenio().getChavePix()).infoAdicionais(infoAdicionais).build();
    }

    public static String formatarDecimalFormat(BigDecimal valor) {
        DecimalFormat valueFormatter = new DecimalFormat("#00000000000000.00");
        valueFormatter.getDecimalFormatSymbols().setDecimalSeparator(',');
        return valueFormatter.format(valor).replace(",", "");
    }

    @Generated
    GerarQrCodePixBradescoRequestDTO(DevedorBradescoDTO devedor, String chave, ValorQrCodeBradescoDTO valor, CalendarioQrCodeBradescoDTO calendario, List<InfoAdcionaisQrCodeBradescoDTO> infoAdicionais, String solicitacaoPagador) {
        this.devedor = devedor;
        this.chave = chave;
        this.valor = valor;
        this.calendario = calendario;
        this.infoAdicionais = infoAdicionais;
        this.solicitacaoPagador = solicitacaoPagador;
    }

    @Generated
    public static GerarQrCodePixBradescoRequestDTOBuilder builder() {
        return new GerarQrCodePixBradescoRequestDTOBuilder();
    }

    @Generated
    public DevedorBradescoDTO getDevedor() {
        return this.devedor;
    }

    @Generated
    public String getChave() {
        return this.chave;
    }

    @Generated
    public ValorQrCodeBradescoDTO getValor() {
        return this.valor;
    }

    @Generated
    public CalendarioQrCodeBradescoDTO getCalendario() {
        return this.calendario;
    }

    @Generated
    public List<InfoAdcionaisQrCodeBradescoDTO> getInfoAdicionais() {
        return this.infoAdicionais;
    }

    @Generated
    public String getSolicitacaoPagador() {
        return this.solicitacaoPagador;
    }

    @Generated
    public void setDevedor(DevedorBradescoDTO devedor) {
        this.devedor = devedor;
    }

    @Generated
    public void setChave(String chave) {
        this.chave = chave;
    }

    @Generated
    public void setValor(ValorQrCodeBradescoDTO valor) {
        this.valor = valor;
    }

    @Generated
    public void setCalendario(CalendarioQrCodeBradescoDTO calendario) {
        this.calendario = calendario;
    }

    @Generated
    public void setInfoAdicionais(List<InfoAdcionaisQrCodeBradescoDTO> infoAdicionais) {
        this.infoAdicionais = infoAdicionais;
    }

    @Generated
    public void setSolicitacaoPagador(String solicitacaoPagador) {
        this.solicitacaoPagador = solicitacaoPagador;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GerarQrCodePixBradescoRequestDTO)) {
            return false;
        }
        GerarQrCodePixBradescoRequestDTO other = (GerarQrCodePixBradescoRequestDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        DevedorBradescoDTO this$devedor = this.getDevedor();
        DevedorBradescoDTO other$devedor = other.getDevedor();
        if (this$devedor == null ? other$devedor != null : !this$devedor.equals(other$devedor)) {
            return false;
        }
        String this$chave = this.getChave();
        String other$chave = other.getChave();
        if (this$chave == null ? other$chave != null : !this$chave.equals(other$chave)) {
            return false;
        }
        ValorQrCodeBradescoDTO this$valor = this.getValor();
        ValorQrCodeBradescoDTO other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !this$valor.equals(other$valor)) {
            return false;
        }
        CalendarioQrCodeBradescoDTO this$calendario = this.getCalendario();
        CalendarioQrCodeBradescoDTO other$calendario = other.getCalendario();
        if (this$calendario == null ? other$calendario != null : !this$calendario.equals(other$calendario)) {
            return false;
        }
        List this$infoAdicionais = this.getInfoAdicionais();
        List other$infoAdicionais = other.getInfoAdicionais();
        if (this$infoAdicionais == null ? other$infoAdicionais != null : !((Object)this$infoAdicionais).equals(other$infoAdicionais)) {
            return false;
        }
        String this$solicitacaoPagador = this.getSolicitacaoPagador();
        String other$solicitacaoPagador = other.getSolicitacaoPagador();
        return !(this$solicitacaoPagador == null ? other$solicitacaoPagador != null : !this$solicitacaoPagador.equals(other$solicitacaoPagador));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GerarQrCodePixBradescoRequestDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DevedorBradescoDTO $devedor = this.getDevedor();
        result = result * 59 + ($devedor == null ? 43 : $devedor.hashCode());
        String $chave = this.getChave();
        result = result * 59 + ($chave == null ? 43 : $chave.hashCode());
        ValorQrCodeBradescoDTO $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : $valor.hashCode());
        CalendarioQrCodeBradescoDTO $calendario = this.getCalendario();
        result = result * 59 + ($calendario == null ? 43 : $calendario.hashCode());
        List $infoAdicionais = this.getInfoAdicionais();
        result = result * 59 + ($infoAdicionais == null ? 43 : ((Object)$infoAdicionais).hashCode());
        String $solicitacaoPagador = this.getSolicitacaoPagador();
        result = result * 59 + ($solicitacaoPagador == null ? 43 : $solicitacaoPagador.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GerarQrCodePixBradescoRequestDTO(devedor=" + String.valueOf(this.getDevedor()) + ", chave=" + this.getChave() + ", valor=" + String.valueOf(this.getValor()) + ", calendario=" + String.valueOf(this.getCalendario()) + ", infoAdicionais=" + String.valueOf(this.getInfoAdicionais()) + ", solicitacaoPagador=" + this.getSolicitacaoPagador() + ")";
    }
}

