/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaoboleto.bradesco;

import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Agencia;
import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.ContaBancaria;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.EnderecoPessoa;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.UnidadeFederacao;
import br.com.elotech.tributos.domain.cnab240.CNAB240CodigoEspecieTitulo;
import br.com.elotech.tributos.domain.cnab240.ParametroCNAB240;
import br.com.elotech.tributos.dto.integracaoboleto.bradesco.EmissaoBoletoBradescoHibridoDTO;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class EmissaoBoletoBradescoHibridoDTO {
    private static final Long TIPO_JUROS_VALOR_FIXO = 1L;
    private static final Long TIPO_JUROS_PERCENTUAL = 2L;
    private static final Long TIPO_MULTA_VALOR_FIXO = 1L;
    private static final Long TIPO_MULTA_PERCENTUAL = 2L;
    private static final Long TIPO_DESCONTO_VALOR_FIXO = 1L;
    private static final Long TIPO_DESCONTO_PERCENTUAL = 2L;
    private static final Integer LIMITE_CARACTERES_LOGRADOURO = 39;
    private static final String TIPO_ACESSO_FIXO_BOLETO_REGISTRADO = "2";
    private static final String TIPO_PRAZO_DIAS_UTEIS = "2";
    private static final String TIPO_DOCUMENTO_CPF = "1";
    private static final String TIPO_DOCUMENTO_CNPJ = "2";
    private static final String TIPO_REGISTRO_QRCODE = "1";
    private static final String TIPO_REGISTRO_ENTRADA = "1";
    private static final String TIPO_REGISTRO_TITULO = "001";
    private static final String VALOR = "1";
    private static final String PORCENTAGEM = "2";
    private static final String USUARIO_API_SERVICO = "APISERVIC";
    private static final String FILIAL_CNPJ_BENEFICIARIO = "0001";
    private static final String TIPO_VENCIMENTO = "0";
    private static final String TIPO_MOEDA = "00006";
    private static final String ACEITA_SACADO = "N";
    private static final String BOLETO_CLIENTE_EMITE = "2";
    private static final String PAGAMENTO_PARCIAL = "S";
    private static final String QTD_PAG_PARCIAL = "000";
    private static final String REGISTRO_QRCODE = "S";
    private static final String SEM_INCIDENCIA = "0";
    private static final String COM_INCIDENCIA = "1";
    private static final String VALOR_NUMERICO_OPCIONAL = "0";
    private static final String VALOR_TEXTO_OPCIONAL = "";
    private static final String FORMATO_VALOR_DECIMAL = "#00000000000000.00";
    private static final DateTimeFormatter PATTERN_DATA = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private static final BigDecimal FATOR_CONVERSAO_CENTAVOS = new BigDecimal("100");
    @JsonProperty(value="ctitloCobrCdent")
    private String nossoNumero;
    private String registrarTitulo;
    private String codUsuario;
    @JsonProperty(value="nroCpfCnpjBenef")
    private String cpfCnpjBeneficiarioRaiz;
    @JsonProperty(value="filCpfCnpjBenef")
    private String filialCpfCnpjBenefiario;
    @JsonProperty(value="digCpfCnpjBenef")
    private String digitoCpfCnpjBeneficiario;
    private String tipoAcesso;
    @JsonProperty(value="cpssoaJuridContr")
    private String codigoPessoaContrato;
    @JsonProperty(value="ctpoContrNegoc")
    private String tipoContrato;
    @JsonProperty(value="nseqContrNegoc")
    private String numeroSequenciaContrato;
    @JsonProperty(value="cidtfdProdCobr")
    private String carteira;
    @JsonProperty(value="cnegocCobr")
    private String codigoNegociacaoCobranca;
    private String filler;
    private String codigoBanco;
    @JsonProperty(value="eNseqContrNegoc")
    private String numeroContratoNegociacao;
    private String tipoRegistro;
    @JsonProperty(value="cprodtServcOper")
    private String codigoProdutoCobranca;
    @JsonProperty(value="ctitloCliCdent")
    private String seuNumero;
    @JsonProperty(value="demisTitloCobr")
    private String dataEmissaoTitulo;
    @JsonProperty(value="dvctoTitloCobr")
    private String dataVencimentoTitulo;
    @JsonProperty(value="cidtfdTpoVcto")
    private String identificadorVencimento;
    @JsonProperty(value="cindcdEconmMoeda")
    private String tipoMoeda;
    @JsonProperty(value="vnmnalTitloCobr")
    private String valorNominalTitulo;
    @JsonProperty(value="qmoedaNegocTitlo")
    private String quantidadeMoedaTitulo;
    @JsonProperty(value="cespceTitloCobr")
    private String especieTitulo;
    @JsonProperty(value="cindcdAceitSacdo")
    private String aceitaSacado;
    @JsonProperty(value="ctpoProteTitlo")
    private String tipoProtestoTitulo;
    @JsonProperty(value="ctpoPrzProte")
    private String qtdDiasPotestoPosVencimento;
    @JsonProperty(value="ctpoProteDecurs")
    private String tipoProtestoDecurso;
    @JsonProperty(value="ctpoPrzDecurs")
    private String diasDecursoProtesto;
    @JsonProperty(value="cctrlPartcTitlo")
    private String controleParticipante;
    @JsonProperty(value="cformaEmisPplta")
    private String formaEmissaoBoleto;
    @JsonProperty(value="cindcdPgtoParcial")
    private String indicadorPagamentoParcial;
    @JsonProperty(value="qtdePgtoParcial")
    private String quantidadePagamentoParcial;
    private String filler1;
    @JsonProperty(value="ptxJuroVcto")
    private String percentualJuros;
    @JsonProperty(value="vdiaJuroMora")
    private String valorDiaJuros;
    @JsonProperty(value="qdiaInicJuro")
    private String diasIncidenciaJuros;
    @JsonProperty(value="pmultaAplicVcto")
    private String percentualMulta;
    @JsonProperty(value="vmultaAtrsoPgto")
    private String valorMulta;
    @JsonProperty(value="qdiaInicMulta")
    private String diasIncidenciaMulta;
    @JsonProperty(value="pdescBonifPgto01")
    private String percentualDesconto1;
    @JsonProperty(value="vdescBonifPgto01")
    private String valorDesconto1;
    @JsonProperty(value="dlimDescBonif1")
    private String dataLimiteDesconto1;
    @JsonProperty(value="pdescBonifPgto02")
    private String percentualDesconto2;
    @JsonProperty(value="vdescBonifPgto02")
    private String valorDesconto2;
    @JsonProperty(value="dlimDescBonif2")
    private String dataLimiteDesconto2;
    @JsonProperty(value="pdescBonifPgto03")
    private String percentualDesconto3;
    @JsonProperty(value="vdescBonifPgto03")
    private String valorDesconto3;
    @JsonProperty(value="dlimDescBonif3")
    private String dataLimiteDesconto3;
    @JsonProperty(value="ctpoPrzCobr")
    private String tipoPrazoCobranca;
    @JsonProperty(value="pdescBonifPgto")
    private String percentualBonificacao;
    @JsonProperty(value="vdescBonifPgto")
    private String valorBonificacao;
    @JsonProperty(value="dlimBonifPgto")
    private String dlimBonifPgto;
    @JsonProperty(value="vabtmtTitloCobr")
    private String valorAbatimentoTitulo;
    @JsonProperty(value="viofPgtoTitlo")
    private String valorIOF;
    private String filler2;
    @JsonProperty(value="isacdoTitloCobr")
    private String nomeDevedor;
    @JsonProperty(value="elogdrSacdoTitlo")
    private String logradouroDevedor;
    @JsonProperty(value="enroLogdrSacdo")
    private String numeroLogradouroDevedor;
    @JsonProperty(value="ecomplLogdrSacdo")
    private String complementoLogradouroDevedor;
    @JsonProperty(value="ccepSacdoTitlo")
    private String cepDevedor;
    @JsonProperty(value="ccomplCepSacdo")
    private String complementoCepDevedor;
    @JsonProperty(value="ebairoLogdrSacdo")
    private String bairroDevedor;
    @JsonProperty(value="imunSacdoTitlo")
    private String municipioDevedor;
    @JsonProperty(value="csglUfSacdo")
    private String ufDevedor;
    @JsonProperty(value="indCpfCnpjSacdo")
    private String indicadorDocumentoDevedor;
    @JsonProperty(value="nroCpfCnpjSacdo")
    private String cpfCnpjDevedor;
    @JsonProperty(value="renderEletrSacdo")
    private String emailDevedor;
    @JsonProperty(value="cdddFoneSacdo")
    private String dddFoneDevedor;
    @JsonProperty(value="cfoneSacdoTitlo")
    private String foneDevedor;
    private String bancoDeb;
    private Long agenciaDeb;
    private Long agenciaDebDv;
    private Long contaDeb;
    @JsonProperty(value="bancoCentProt")
    private String bancoProtesto;
    @JsonProperty(value="agenciaDvCentPr")
    private String agenciaProtesto;
    @JsonProperty(value="isacdrAvalsTitlo")
    private String nomeSacadorAvalista;
    @JsonProperty(value="elogdrSacdrAvals")
    private String logradouroSacadorAvalista;
    @JsonProperty(value="ecomplLogdrSacdr")
    private String complementoLogradouroSacadorAvalista;
    @JsonProperty(value="ccepSacdrTitlo")
    private String cepSacadorAvalista;
    @JsonProperty(value="ccomplCepSacdr")
    private String complementoCepSacadorAvalista;
    @JsonProperty(value="ebairoLogdrSacdr")
    private String bairroSacadorAvalista;
    @JsonProperty(value="imunSacdrAvals")
    private String municipioSacadorAvalista;
    @JsonProperty(value="csglUfSacdr")
    private String ufSacadorAvalista;
    @JsonProperty(value="indCpfCnpjSacdr")
    private String indicadorTipoDocumentoSacador;
    @JsonProperty(value="nroCpfCnpjSacdr")
    private String numeroCpfCnpjSacador;
    @JsonProperty(value="renderEletrSacdr")
    private String emailSacador;
    @JsonProperty(value="cdddFoneSacdr")
    private String dddFoneSacador;
    private String enroLogdrSacdr;
    @JsonProperty(value="cfoneSacdrTitlo")
    private String foneSacadorAvalista;
    private String filler3;
    private String fase;
    @JsonProperty(value="cindcdCobrMisto")
    private String registroQrCode;
    @JsonProperty(value="ialiasAdsaoCta")
    private String chavePixBeneficiario;
    @JsonProperty(value="iconcPgtoSpi")
    private String txIdTitulo;
    @JsonProperty(value="caliasAdsaoCta")
    private String codigoErroGeracaoQrdCode;
    @JsonProperty(value="ilinkGeracQrcd")
    private String locationQrCode;
    @JsonProperty(value="wqrcdPdraoMercd")
    private String codigoEmvQrCode;
    private String validadeAposVencimento;
    private String filler4;
    private String idLoc;

    public static EmissaoBoletoBradescoHibridoDTO from(Bloqueto boleto, ParametroCNAB240 parametroCNAB240Bradesco) {
        Optional.ofNullable(parametroCNAB240Bradesco).orElseThrow(() -> new EloValidationException("Necess\u00e1rio configurar TRIBPARAMETROCNAB240 para o Bradesco"));
        Convenio convenio = boleto.getModeloBloqueto().getConvenio();
        Pessoa pessoa = boleto.getPessoa();
        EnderecoPessoa enderecoPessoa = pessoa.getEnderecoPrincipal();
        return EmissaoBoletoBradescoHibridoDTO.builder().nossoNumero(EmissaoBoletoBradescoHibridoDTO.formatarNossoNUmero((Bloqueto)boleto)).cpfCnpjBeneficiarioRaiz(EmissaoBoletoBradescoHibridoDTO.extrairCpfCnpjBeneficiario((Bloqueto)boleto)).filialCpfCnpjBenefiario("0001").digitoCpfCnpjBeneficiario(EmissaoBoletoBradescoHibridoDTO.getDigitosVerificadoresCnpj((String)boleto.getModeloBloqueto().getConvenio().getEntidadeRegistro().getCnpj())).carteira(convenio.getCarteira()).codigoNegociacaoCobranca(EmissaoBoletoBradescoHibridoDTO.getCodigoNegociacao((Convenio)convenio)).seuNumero(boleto.getCadastroGeral().getCadastroGeral().toString()).dataEmissaoTitulo(EmissaoBoletoBradescoHibridoDTO.formatarData((LocalDate)boleto.getDataEmissao())).dataVencimentoTitulo(EmissaoBoletoBradescoHibridoDTO.formatarData((LocalDate)boleto.getDataVencimento())).valorNominalTitulo(EmissaoBoletoBradescoHibridoDTO.formatarValoresCobrancaPix((BigDecimal)boleto.getValorBloqueto())).especieTitulo(EmissaoBoletoBradescoHibridoDTO.extrairEspecieTitulo((ParametroCNAB240)parametroCNAB240Bradesco)).build().builderJuros(parametroCNAB240Bradesco).builderMulta(parametroCNAB240Bradesco).builderDescontos(parametroCNAB240Bradesco, boleto).builderDevedor(boleto.getPessoa(), enderecoPessoa);
    }

    public static String getCodigoNegociacao(Convenio convenio) {
        String agenciaNegociacaoNumeros = Optional.ofNullable(convenio).map(Convenio::getContaBancaria).map(ContaBancaria::getAgencia).map(Agencia::getAgencia).map(agencia -> StringUtils.left((String)agencia.replaceAll("[^\\d]", ""), (int)4)).orElseThrow(() -> new EloValidationException("Ag\u00eancia n\u00e3o encontrada"));
        String contaBancariaNegociacaoNumeros = Optional.ofNullable(convenio).map(Convenio::getContaBancaria).map(ContaBancaria::getConta).map(conta -> StringUtils.leftPad((String)conta.replaceAll("[^\\d]", ""), (int)7, (String)"0")).orElseThrow(() -> new EloValidationException("Conta banc\u00e1ria n\u00e3o encontrada"));
        return (agenciaNegociacaoNumeros + "0000000" + contaBancariaNegociacaoNumeros).trim();
    }

    public EmissaoBoletoBradescoHibridoDTO builderJuros(ParametroCNAB240 parametroCNAB240Bradesco) {
        this.setPercentualJuros("0");
        this.setDiasIncidenciaJuros("0");
        this.setValorDiaJuros("0");
        if (Objects.nonNull(parametroCNAB240Bradesco) && Objects.nonNull(parametroCNAB240Bradesco.getCodigoJuros())) {
            if (TIPO_JUROS_PERCENTUAL.equals(parametroCNAB240Bradesco.getCodigoJuros().getId())) {
                String valorPercentualJuros = parametroCNAB240Bradesco.getValorJurosDiaTaxa().compareTo(BigDecimal.ZERO) > 0 ? EmissaoBoletoBradescoHibridoDTO.formatarJurosPercentual((BigDecimal)parametroCNAB240Bradesco.getValorJurosDiaTaxa()) : BigDecimal.ZERO.toString();
                this.setPercentualJuros(valorPercentualJuros);
                this.setDiasIncidenciaJuros("1");
            }
            if (TIPO_JUROS_VALOR_FIXO.equals(parametroCNAB240Bradesco.getCodigoJuros().getId())) {
                String valorDiaJurosFixo = parametroCNAB240Bradesco.getValorJurosDiaTaxa().compareTo(BigDecimal.ZERO) > 0 ? EmissaoBoletoBradescoHibridoDTO.formatarValoresCobrancaPix((BigDecimal)parametroCNAB240Bradesco.getValorJurosDiaTaxa()) : BigDecimal.ZERO.toString();
                this.setValorDiaJuros(valorDiaJurosFixo);
                this.setDiasIncidenciaJuros("1");
            }
        }
        return this;
    }

    public EmissaoBoletoBradescoHibridoDTO builderMulta(ParametroCNAB240 parametroCNAB240Bradesco) {
        this.setPercentualMulta("0");
        this.setDiasIncidenciaMulta("0");
        this.setValorMulta("0");
        if (Objects.nonNull(parametroCNAB240Bradesco) && Objects.nonNull(parametroCNAB240Bradesco.getCodigoMulta())) {
            if (TIPO_MULTA_PERCENTUAL.equals(parametroCNAB240Bradesco.getCodigoMulta().getId())) {
                String valorPercentualMulta = parametroCNAB240Bradesco.getValorPercentualMulta().compareTo(BigDecimal.ZERO) > 0 ? EmissaoBoletoBradescoHibridoDTO.formatarJurosPercentual((BigDecimal)parametroCNAB240Bradesco.getValorPercentualMulta()) : BigDecimal.ZERO.toString();
                this.setPercentualMulta(valorPercentualMulta);
                this.setDiasIncidenciaMulta("1");
            }
            if (TIPO_MULTA_VALOR_FIXO.equals(parametroCNAB240Bradesco.getCodigoMulta().getId())) {
                String valorFixoMulta = parametroCNAB240Bradesco.getValorPercentualMulta().compareTo(BigDecimal.ZERO) > 0 ? EmissaoBoletoBradescoHibridoDTO.formatarValoresCobrancaPix((BigDecimal)parametroCNAB240Bradesco.getValorPercentualMulta()) : BigDecimal.ZERO.toString();
                this.setValorMulta(valorFixoMulta);
                this.setDiasIncidenciaMulta("1");
            }
        }
        return this;
    }

    public EmissaoBoletoBradescoHibridoDTO builderDescontos(ParametroCNAB240 parametroCNAB240Bradesco, Bloqueto boleto) {
        this.setPercentualDesconto1("0");
        this.setValorDesconto1("0");
        this.setDataLimiteDesconto1(" ");
        this.setPercentualDesconto2("0");
        this.setValorDesconto2("0");
        this.setDataLimiteDesconto2(" ");
        this.setPercentualDesconto3("0");
        this.setValorDesconto3("0");
        this.setDataLimiteDesconto3(" ");
        if (Objects.nonNull(parametroCNAB240Bradesco) && Objects.nonNull(parametroCNAB240Bradesco.getCodigoDesconto())) {
            if (TIPO_DESCONTO_PERCENTUAL.equals(parametroCNAB240Bradesco.getCodigoDesconto().getCodigo())) {
                String valorPercentualDesconto = parametroCNAB240Bradesco.getValorPercentualDesconto().compareTo(BigDecimal.ZERO) > 0 ? EmissaoBoletoBradescoHibridoDTO.formatarJurosPercentual((BigDecimal)parametroCNAB240Bradesco.getValorPercentualDesconto()) : BigDecimal.ZERO.toString();
                this.setPercentualDesconto1(valorPercentualDesconto);
                this.setDataLimiteDesconto1(boleto.getDataVencimento().format(PATTERN_DATA));
            }
            if (TIPO_DESCONTO_VALOR_FIXO.equals(parametroCNAB240Bradesco.getCodigoDesconto().getCodigo())) {
                String valorFixoDesconto = parametroCNAB240Bradesco.getValorPercentualDesconto().compareTo(BigDecimal.ZERO) > 0 ? EmissaoBoletoBradescoHibridoDTO.formatarValoresCobrancaPix((BigDecimal)parametroCNAB240Bradesco.getValorPercentualDesconto()) : BigDecimal.ZERO.toString();
                this.setValorDesconto1(valorFixoDesconto);
                this.setDataLimiteDesconto1(boleto.getDataVencimento().format(PATTERN_DATA));
            }
        }
        return this;
    }

    public EmissaoBoletoBradescoHibridoDTO builderDevedor(Pessoa pessoa, EnderecoPessoa enderecoPessoa) {
        this.setNomeDevedor(pessoa.getNome());
        this.setLogradouroDevedor(Optional.ofNullable(enderecoPessoa).map(EnderecoPessoa::getLogradouro).map(Logradouro::getDescricao).map(descricao -> descricao.length() > LIMITE_CARACTERES_LOGRADOURO ? descricao.substring(0, LIMITE_CARACTERES_LOGRADOURO) : descricao).orElse(""));
        this.setNumeroLogradouroDevedor(Optional.ofNullable(enderecoPessoa).map(EnderecoPessoa::getNumero).orElse("0"));
        String cep = Optional.ofNullable(enderecoPessoa).map(EnderecoPessoa::getCep).map(String::valueOf).filter(c -> c != null && c.length() >= 5).orElse("00000000");
        this.setCepDevedor(cep.substring(0, 5));
        this.setComplementoCepDevedor(cep.length() > 5 ? cep.substring(5) : "0");
        this.setBairroDevedor(Optional.ofNullable(enderecoPessoa).map(EnderecoPessoa::getBairro).map(Bairro::getDescricao).orElse(""));
        this.setMunicipioDevedor(Optional.ofNullable(enderecoPessoa).map(EnderecoPessoa::getCidade).map(Cidade::getDescricao).orElse(""));
        this.setUfDevedor(Optional.ofNullable(enderecoPessoa).map(EnderecoPessoa::getUnidadeFederacao).map(UnidadeFederacao::getUnidadeFederacao).orElse(""));
        this.setIndicadorDocumentoDevedor(TipoPessoa.FISICA.equals((Object)pessoa.getTipoPessoa()) ? "1" : "2");
        this.setCpfCnpjDevedor(pessoa.getCnpjCpfSemMascara());
        return this;
    }

    public static String formatarJurosPercentual(BigDecimal valorPercentual) {
        if (valorPercentual == null) {
            throw new IllegalArgumentException("Valor percentual n\u00e3o pode ser nulo.");
        }
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        DecimalFormat df = new DecimalFormat("0.##", symbols);
        df.setGroupingUsed(false);
        return df.format(valorPercentual);
    }

    public static String formatarDecimalFormat(BigDecimal valor) {
        if (valor == null) {
            return "0.00";
        }
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        DecimalFormat decimalFormat = new DecimalFormat("0.00", symbols);
        decimalFormat.setGroupingUsed(false);
        return decimalFormat.format(valor);
    }

    private static String formatarValoresCobrancaPix(BigDecimal valor) {
        if (!Objects.nonNull(valor)) {
            return "0";
        }
        BigDecimal valorEmCentavos = valor.multiply(FATOR_CONVERSAO_CENTAVOS).setScale(0, RoundingMode.HALF_UP);
        return String.format("%03d", valorEmCentavos.toBigInteger());
    }

    public static String formatarData(LocalDate data) {
        return data.format(PATTERN_DATA);
    }

    private static String extrairEspecieTitulo(ParametroCNAB240 parametroCNAB240Bradesco) {
        String especieTitulo = Optional.ofNullable(parametroCNAB240Bradesco).map(ParametroCNAB240::getIdEspecieTitulo).map(CNAB240CodigoEspecieTitulo::getEspecieTitulo).map(String::valueOf).orElse("0");
        return "0" + especieTitulo;
    }

    public static String getDigitosVerificadoresCnpj(String cnpj) {
        if (cnpj == null) {
            throw new EloValidationException("CNPJ n\u00e3o pode ser nulo");
        }
        String numeros = cnpj.replaceAll("\\D", "");
        if (numeros.length() == 14) {
            return numeros.substring(numeros.length() - 2);
        }
        throw new EloValidationException("CNPJ deve ter 14 d\u00edgitos");
    }

    private static String formatarNossoNUmero(Bloqueto boleto) {
        String nossoNumero = Optional.ofNullable(boleto.getNossoNumero()).filter(n -> !n.isBlank()).orElseThrow(() -> new EloValidationException("Nosso n\u00famero \u00e9 obrigat\u00f3rio e n\u00e3o pode ser vazio."));
        return nossoNumero.length() >= 11 ? nossoNumero.substring(0, 11) : String.format("%011d", Long.parseLong(nossoNumero));
    }

    private static String extrairCpfCnpjBeneficiario(Bloqueto boleto) {
        return StringUtils.substring((String)boleto.getModeloBloqueto().getConvenio().getEntidadeRegistro().getCnpj(), (int)0, (int)8);
    }

    @Generated
    private static String $default$registrarTitulo() {
        return "1";
    }

    @Generated
    private static String $default$codUsuario() {
        return "APISERVIC";
    }

    @Generated
    private static String $default$tipoAcesso() {
        return "2";
    }

    @Generated
    private static String $default$codigoPessoaContrato() {
        return "0";
    }

    @Generated
    private static String $default$tipoContrato() {
        return "0";
    }

    @Generated
    private static String $default$numeroSequenciaContrato() {
        return "0";
    }

    @Generated
    private static String $default$filler() {
        return "";
    }

    @Generated
    private static String $default$codigoBanco() {
        return String.valueOf(Banco.CODIGO_BRADESCO);
    }

    @Generated
    private static String $default$numeroContratoNegociacao() {
        return "0";
    }

    @Generated
    private static String $default$tipoRegistro() {
        return "001";
    }

    @Generated
    private static String $default$codigoProdutoCobranca() {
        return "0";
    }

    @Generated
    private static String $default$identificadorVencimento() {
        return "0";
    }

    @Generated
    private static String $default$tipoMoeda() {
        return "00006";
    }

    @Generated
    private static String $default$quantidadeMoedaTitulo() {
        return "0";
    }

    @Generated
    private static String $default$aceitaSacado() {
        return "N";
    }

    @Generated
    private static String $default$tipoProtestoTitulo() {
        return "0";
    }

    @Generated
    private static String $default$qtdDiasPotestoPosVencimento() {
        return "0";
    }

    @Generated
    private static String $default$tipoProtestoDecurso() {
        return "0";
    }

    @Generated
    private static String $default$diasDecursoProtesto() {
        return "0";
    }

    @Generated
    private static String $default$controleParticipante() {
        return "0";
    }

    @Generated
    private static String $default$formaEmissaoBoleto() {
        return "2";
    }

    @Generated
    private static String $default$indicadorPagamentoParcial() {
        return "S";
    }

    @Generated
    private static String $default$quantidadePagamentoParcial() {
        return "000";
    }

    @Generated
    private static String $default$filler1() {
        return "";
    }

    @Generated
    private static String $default$tipoPrazoCobranca() {
        return "2";
    }

    @Generated
    private static String $default$percentualBonificacao() {
        return "0";
    }

    @Generated
    private static String $default$valorBonificacao() {
        return "0";
    }

    @Generated
    private static String $default$dlimBonifPgto() {
        return "";
    }

    @Generated
    private static String $default$valorAbatimentoTitulo() {
        return "0";
    }

    @Generated
    private static String $default$valorIOF() {
        return "0";
    }

    @Generated
    private static String $default$filler2() {
        return "";
    }

    @Generated
    private static String $default$complementoLogradouroDevedor() {
        return "";
    }

    @Generated
    private static String $default$emailDevedor() {
        return "";
    }

    @Generated
    private static String $default$dddFoneDevedor() {
        return "0";
    }

    @Generated
    private static String $default$foneDevedor() {
        return "0";
    }

    @Generated
    private static String $default$bancoDeb() {
        return "0";
    }

    @Generated
    private static Long $default$agenciaDeb() {
        return 0L;
    }

    @Generated
    private static Long $default$agenciaDebDv() {
        return 0L;
    }

    @Generated
    private static Long $default$contaDeb() {
        return 0L;
    }

    @Generated
    private static String $default$bancoProtesto() {
        return "0";
    }

    @Generated
    private static String $default$agenciaProtesto() {
        return "0";
    }

    @Generated
    private static String $default$nomeSacadorAvalista() {
        return "";
    }

    @Generated
    private static String $default$logradouroSacadorAvalista() {
        return "";
    }

    @Generated
    private static String $default$complementoLogradouroSacadorAvalista() {
        return "";
    }

    @Generated
    private static String $default$cepSacadorAvalista() {
        return "0";
    }

    @Generated
    private static String $default$complementoCepSacadorAvalista() {
        return "0";
    }

    @Generated
    private static String $default$bairroSacadorAvalista() {
        return "";
    }

    @Generated
    private static String $default$municipioSacadorAvalista() {
        return "";
    }

    @Generated
    private static String $default$ufSacadorAvalista() {
        return "";
    }

    @Generated
    private static String $default$indicadorTipoDocumentoSacador() {
        return "0";
    }

    @Generated
    private static String $default$numeroCpfCnpjSacador() {
        return "0";
    }

    @Generated
    private static String $default$emailSacador() {
        return "";
    }

    @Generated
    private static String $default$dddFoneSacador() {
        return "0";
    }

    @Generated
    private static String $default$enroLogdrSacdr() {
        return "0";
    }

    @Generated
    private static String $default$foneSacadorAvalista() {
        return "0";
    }

    @Generated
    private static String $default$filler3() {
        return "0";
    }

    @Generated
    private static String $default$fase() {
        return "1";
    }

    @Generated
    private static String $default$registroQrCode() {
        return "S";
    }

    @Generated
    private static String $default$chavePixBeneficiario() {
        return "";
    }

    @Generated
    private static String $default$txIdTitulo() {
        return "";
    }

    @Generated
    private static String $default$codigoErroGeracaoQrdCode() {
        return "";
    }

    @Generated
    private static String $default$locationQrCode() {
        return "";
    }

    @Generated
    private static String $default$codigoEmvQrCode() {
        return "";
    }

    @Generated
    private static String $default$validadeAposVencimento() {
        return "";
    }

    @Generated
    private static String $default$filler4() {
        return "";
    }

    @Generated
    private static String $default$idLoc() {
        return "";
    }

    @Generated
    public static EmissaoBoletoBradescoHibridoDTOBuilder builder() {
        return new EmissaoBoletoBradescoHibridoDTOBuilder();
    }

    @Generated
    public String getNossoNumero() {
        return this.nossoNumero;
    }

    @Generated
    public String getRegistrarTitulo() {
        return this.registrarTitulo;
    }

    @Generated
    public String getCodUsuario() {
        return this.codUsuario;
    }

    @Generated
    public String getCpfCnpjBeneficiarioRaiz() {
        return this.cpfCnpjBeneficiarioRaiz;
    }

    @Generated
    public String getFilialCpfCnpjBenefiario() {
        return this.filialCpfCnpjBenefiario;
    }

    @Generated
    public String getDigitoCpfCnpjBeneficiario() {
        return this.digitoCpfCnpjBeneficiario;
    }

    @Generated
    public String getTipoAcesso() {
        return this.tipoAcesso;
    }

    @Generated
    public String getCodigoPessoaContrato() {
        return this.codigoPessoaContrato;
    }

    @Generated
    public String getTipoContrato() {
        return this.tipoContrato;
    }

    @Generated
    public String getNumeroSequenciaContrato() {
        return this.numeroSequenciaContrato;
    }

    @Generated
    public String getCarteira() {
        return this.carteira;
    }

    @Generated
    public String getCodigoNegociacaoCobranca() {
        return this.codigoNegociacaoCobranca;
    }

    @Generated
    public String getFiller() {
        return this.filler;
    }

    @Generated
    public String getCodigoBanco() {
        return this.codigoBanco;
    }

    @Generated
    public String getNumeroContratoNegociacao() {
        return this.numeroContratoNegociacao;
    }

    @Generated
    public String getTipoRegistro() {
        return this.tipoRegistro;
    }

    @Generated
    public String getCodigoProdutoCobranca() {
        return this.codigoProdutoCobranca;
    }

    @Generated
    public String getSeuNumero() {
        return this.seuNumero;
    }

    @Generated
    public String getDataEmissaoTitulo() {
        return this.dataEmissaoTitulo;
    }

    @Generated
    public String getDataVencimentoTitulo() {
        return this.dataVencimentoTitulo;
    }

    @Generated
    public String getIdentificadorVencimento() {
        return this.identificadorVencimento;
    }

    @Generated
    public String getTipoMoeda() {
        return this.tipoMoeda;
    }

    @Generated
    public String getValorNominalTitulo() {
        return this.valorNominalTitulo;
    }

    @Generated
    public String getQuantidadeMoedaTitulo() {
        return this.quantidadeMoedaTitulo;
    }

    @Generated
    public String getEspecieTitulo() {
        return this.especieTitulo;
    }

    @Generated
    public String getAceitaSacado() {
        return this.aceitaSacado;
    }

    @Generated
    public String getTipoProtestoTitulo() {
        return this.tipoProtestoTitulo;
    }

    @Generated
    public String getQtdDiasPotestoPosVencimento() {
        return this.qtdDiasPotestoPosVencimento;
    }

    @Generated
    public String getTipoProtestoDecurso() {
        return this.tipoProtestoDecurso;
    }

    @Generated
    public String getDiasDecursoProtesto() {
        return this.diasDecursoProtesto;
    }

    @Generated
    public String getControleParticipante() {
        return this.controleParticipante;
    }

    @Generated
    public String getFormaEmissaoBoleto() {
        return this.formaEmissaoBoleto;
    }

    @Generated
    public String getIndicadorPagamentoParcial() {
        return this.indicadorPagamentoParcial;
    }

    @Generated
    public String getQuantidadePagamentoParcial() {
        return this.quantidadePagamentoParcial;
    }

    @Generated
    public String getFiller1() {
        return this.filler1;
    }

    @Generated
    public String getPercentualJuros() {
        return this.percentualJuros;
    }

    @Generated
    public String getValorDiaJuros() {
        return this.valorDiaJuros;
    }

    @Generated
    public String getDiasIncidenciaJuros() {
        return this.diasIncidenciaJuros;
    }

    @Generated
    public String getPercentualMulta() {
        return this.percentualMulta;
    }

    @Generated
    public String getValorMulta() {
        return this.valorMulta;
    }

    @Generated
    public String getDiasIncidenciaMulta() {
        return this.diasIncidenciaMulta;
    }

    @Generated
    public String getPercentualDesconto1() {
        return this.percentualDesconto1;
    }

    @Generated
    public String getValorDesconto1() {
        return this.valorDesconto1;
    }

    @Generated
    public String getDataLimiteDesconto1() {
        return this.dataLimiteDesconto1;
    }

    @Generated
    public String getPercentualDesconto2() {
        return this.percentualDesconto2;
    }

    @Generated
    public String getValorDesconto2() {
        return this.valorDesconto2;
    }

    @Generated
    public String getDataLimiteDesconto2() {
        return this.dataLimiteDesconto2;
    }

    @Generated
    public String getPercentualDesconto3() {
        return this.percentualDesconto3;
    }

    @Generated
    public String getValorDesconto3() {
        return this.valorDesconto3;
    }

    @Generated
    public String getDataLimiteDesconto3() {
        return this.dataLimiteDesconto3;
    }

    @Generated
    public String getTipoPrazoCobranca() {
        return this.tipoPrazoCobranca;
    }

    @Generated
    public String getPercentualBonificacao() {
        return this.percentualBonificacao;
    }

    @Generated
    public String getValorBonificacao() {
        return this.valorBonificacao;
    }

    @Generated
    public String getDlimBonifPgto() {
        return this.dlimBonifPgto;
    }

    @Generated
    public String getValorAbatimentoTitulo() {
        return this.valorAbatimentoTitulo;
    }

    @Generated
    public String getValorIOF() {
        return this.valorIOF;
    }

    @Generated
    public String getFiller2() {
        return this.filler2;
    }

    @Generated
    public String getNomeDevedor() {
        return this.nomeDevedor;
    }

    @Generated
    public String getLogradouroDevedor() {
        return this.logradouroDevedor;
    }

    @Generated
    public String getNumeroLogradouroDevedor() {
        return this.numeroLogradouroDevedor;
    }

    @Generated
    public String getComplementoLogradouroDevedor() {
        return this.complementoLogradouroDevedor;
    }

    @Generated
    public String getCepDevedor() {
        return this.cepDevedor;
    }

    @Generated
    public String getComplementoCepDevedor() {
        return this.complementoCepDevedor;
    }

    @Generated
    public String getBairroDevedor() {
        return this.bairroDevedor;
    }

    @Generated
    public String getMunicipioDevedor() {
        return this.municipioDevedor;
    }

    @Generated
    public String getUfDevedor() {
        return this.ufDevedor;
    }

    @Generated
    public String getIndicadorDocumentoDevedor() {
        return this.indicadorDocumentoDevedor;
    }

    @Generated
    public String getCpfCnpjDevedor() {
        return this.cpfCnpjDevedor;
    }

    @Generated
    public String getEmailDevedor() {
        return this.emailDevedor;
    }

    @Generated
    public String getDddFoneDevedor() {
        return this.dddFoneDevedor;
    }

    @Generated
    public String getFoneDevedor() {
        return this.foneDevedor;
    }

    @Generated
    public String getBancoDeb() {
        return this.bancoDeb;
    }

    @Generated
    public Long getAgenciaDeb() {
        return this.agenciaDeb;
    }

    @Generated
    public Long getAgenciaDebDv() {
        return this.agenciaDebDv;
    }

    @Generated
    public Long getContaDeb() {
        return this.contaDeb;
    }

    @Generated
    public String getBancoProtesto() {
        return this.bancoProtesto;
    }

    @Generated
    public String getAgenciaProtesto() {
        return this.agenciaProtesto;
    }

    @Generated
    public String getNomeSacadorAvalista() {
        return this.nomeSacadorAvalista;
    }

    @Generated
    public String getLogradouroSacadorAvalista() {
        return this.logradouroSacadorAvalista;
    }

    @Generated
    public String getComplementoLogradouroSacadorAvalista() {
        return this.complementoLogradouroSacadorAvalista;
    }

    @Generated
    public String getCepSacadorAvalista() {
        return this.cepSacadorAvalista;
    }

    @Generated
    public String getComplementoCepSacadorAvalista() {
        return this.complementoCepSacadorAvalista;
    }

    @Generated
    public String getBairroSacadorAvalista() {
        return this.bairroSacadorAvalista;
    }

    @Generated
    public String getMunicipioSacadorAvalista() {
        return this.municipioSacadorAvalista;
    }

    @Generated
    public String getUfSacadorAvalista() {
        return this.ufSacadorAvalista;
    }

    @Generated
    public String getIndicadorTipoDocumentoSacador() {
        return this.indicadorTipoDocumentoSacador;
    }

    @Generated
    public String getNumeroCpfCnpjSacador() {
        return this.numeroCpfCnpjSacador;
    }

    @Generated
    public String getEmailSacador() {
        return this.emailSacador;
    }

    @Generated
    public String getDddFoneSacador() {
        return this.dddFoneSacador;
    }

    @Generated
    public String getEnroLogdrSacdr() {
        return this.enroLogdrSacdr;
    }

    @Generated
    public String getFoneSacadorAvalista() {
        return this.foneSacadorAvalista;
    }

    @Generated
    public String getFiller3() {
        return this.filler3;
    }

    @Generated
    public String getFase() {
        return this.fase;
    }

    @Generated
    public String getRegistroQrCode() {
        return this.registroQrCode;
    }

    @Generated
    public String getChavePixBeneficiario() {
        return this.chavePixBeneficiario;
    }

    @Generated
    public String getTxIdTitulo() {
        return this.txIdTitulo;
    }

    @Generated
    public String getCodigoErroGeracaoQrdCode() {
        return this.codigoErroGeracaoQrdCode;
    }

    @Generated
    public String getLocationQrCode() {
        return this.locationQrCode;
    }

    @Generated
    public String getCodigoEmvQrCode() {
        return this.codigoEmvQrCode;
    }

    @Generated
    public String getValidadeAposVencimento() {
        return this.validadeAposVencimento;
    }

    @Generated
    public String getFiller4() {
        return this.filler4;
    }

    @Generated
    public String getIdLoc() {
        return this.idLoc;
    }

    @JsonProperty(value="ctitloCobrCdent")
    @Generated
    public void setNossoNumero(String nossoNumero) {
        this.nossoNumero = nossoNumero;
    }

    @Generated
    public void setRegistrarTitulo(String registrarTitulo) {
        this.registrarTitulo = registrarTitulo;
    }

    @Generated
    public void setCodUsuario(String codUsuario) {
        this.codUsuario = codUsuario;
    }

    @JsonProperty(value="nroCpfCnpjBenef")
    @Generated
    public void setCpfCnpjBeneficiarioRaiz(String cpfCnpjBeneficiarioRaiz) {
        this.cpfCnpjBeneficiarioRaiz = cpfCnpjBeneficiarioRaiz;
    }

    @JsonProperty(value="filCpfCnpjBenef")
    @Generated
    public void setFilialCpfCnpjBenefiario(String filialCpfCnpjBenefiario) {
        this.filialCpfCnpjBenefiario = filialCpfCnpjBenefiario;
    }

    @JsonProperty(value="digCpfCnpjBenef")
    @Generated
    public void setDigitoCpfCnpjBeneficiario(String digitoCpfCnpjBeneficiario) {
        this.digitoCpfCnpjBeneficiario = digitoCpfCnpjBeneficiario;
    }

    @Generated
    public void setTipoAcesso(String tipoAcesso) {
        this.tipoAcesso = tipoAcesso;
    }

    @JsonProperty(value="cpssoaJuridContr")
    @Generated
    public void setCodigoPessoaContrato(String codigoPessoaContrato) {
        this.codigoPessoaContrato = codigoPessoaContrato;
    }

    @JsonProperty(value="ctpoContrNegoc")
    @Generated
    public void setTipoContrato(String tipoContrato) {
        this.tipoContrato = tipoContrato;
    }

    @JsonProperty(value="nseqContrNegoc")
    @Generated
    public void setNumeroSequenciaContrato(String numeroSequenciaContrato) {
        this.numeroSequenciaContrato = numeroSequenciaContrato;
    }

    @JsonProperty(value="cidtfdProdCobr")
    @Generated
    public void setCarteira(String carteira) {
        this.carteira = carteira;
    }

    @JsonProperty(value="cnegocCobr")
    @Generated
    public void setCodigoNegociacaoCobranca(String codigoNegociacaoCobranca) {
        this.codigoNegociacaoCobranca = codigoNegociacaoCobranca;
    }

    @Generated
    public void setFiller(String filler) {
        this.filler = filler;
    }

    @Generated
    public void setCodigoBanco(String codigoBanco) {
        this.codigoBanco = codigoBanco;
    }

    @JsonProperty(value="eNseqContrNegoc")
    @Generated
    public void setNumeroContratoNegociacao(String numeroContratoNegociacao) {
        this.numeroContratoNegociacao = numeroContratoNegociacao;
    }

    @Generated
    public void setTipoRegistro(String tipoRegistro) {
        this.tipoRegistro = tipoRegistro;
    }

    @JsonProperty(value="cprodtServcOper")
    @Generated
    public void setCodigoProdutoCobranca(String codigoProdutoCobranca) {
        this.codigoProdutoCobranca = codigoProdutoCobranca;
    }

    @JsonProperty(value="ctitloCliCdent")
    @Generated
    public void setSeuNumero(String seuNumero) {
        this.seuNumero = seuNumero;
    }

    @JsonProperty(value="demisTitloCobr")
    @Generated
    public void setDataEmissaoTitulo(String dataEmissaoTitulo) {
        this.dataEmissaoTitulo = dataEmissaoTitulo;
    }

    @JsonProperty(value="dvctoTitloCobr")
    @Generated
    public void setDataVencimentoTitulo(String dataVencimentoTitulo) {
        this.dataVencimentoTitulo = dataVencimentoTitulo;
    }

    @JsonProperty(value="cidtfdTpoVcto")
    @Generated
    public void setIdentificadorVencimento(String identificadorVencimento) {
        this.identificadorVencimento = identificadorVencimento;
    }

    @JsonProperty(value="cindcdEconmMoeda")
    @Generated
    public void setTipoMoeda(String tipoMoeda) {
        this.tipoMoeda = tipoMoeda;
    }

    @JsonProperty(value="vnmnalTitloCobr")
    @Generated
    public void setValorNominalTitulo(String valorNominalTitulo) {
        this.valorNominalTitulo = valorNominalTitulo;
    }

    @JsonProperty(value="qmoedaNegocTitlo")
    @Generated
    public void setQuantidadeMoedaTitulo(String quantidadeMoedaTitulo) {
        this.quantidadeMoedaTitulo = quantidadeMoedaTitulo;
    }

    @JsonProperty(value="cespceTitloCobr")
    @Generated
    public void setEspecieTitulo(String especieTitulo) {
        this.especieTitulo = especieTitulo;
    }

    @JsonProperty(value="cindcdAceitSacdo")
    @Generated
    public void setAceitaSacado(String aceitaSacado) {
        this.aceitaSacado = aceitaSacado;
    }

    @JsonProperty(value="ctpoProteTitlo")
    @Generated
    public void setTipoProtestoTitulo(String tipoProtestoTitulo) {
        this.tipoProtestoTitulo = tipoProtestoTitulo;
    }

    @JsonProperty(value="ctpoPrzProte")
    @Generated
    public void setQtdDiasPotestoPosVencimento(String qtdDiasPotestoPosVencimento) {
        this.qtdDiasPotestoPosVencimento = qtdDiasPotestoPosVencimento;
    }

    @JsonProperty(value="ctpoProteDecurs")
    @Generated
    public void setTipoProtestoDecurso(String tipoProtestoDecurso) {
        this.tipoProtestoDecurso = tipoProtestoDecurso;
    }

    @JsonProperty(value="ctpoPrzDecurs")
    @Generated
    public void setDiasDecursoProtesto(String diasDecursoProtesto) {
        this.diasDecursoProtesto = diasDecursoProtesto;
    }

    @JsonProperty(value="cctrlPartcTitlo")
    @Generated
    public void setControleParticipante(String controleParticipante) {
        this.controleParticipante = controleParticipante;
    }

    @JsonProperty(value="cformaEmisPplta")
    @Generated
    public void setFormaEmissaoBoleto(String formaEmissaoBoleto) {
        this.formaEmissaoBoleto = formaEmissaoBoleto;
    }

    @JsonProperty(value="cindcdPgtoParcial")
    @Generated
    public void setIndicadorPagamentoParcial(String indicadorPagamentoParcial) {
        this.indicadorPagamentoParcial = indicadorPagamentoParcial;
    }

    @JsonProperty(value="qtdePgtoParcial")
    @Generated
    public void setQuantidadePagamentoParcial(String quantidadePagamentoParcial) {
        this.quantidadePagamentoParcial = quantidadePagamentoParcial;
    }

    @Generated
    public void setFiller1(String filler1) {
        this.filler1 = filler1;
    }

    @JsonProperty(value="ptxJuroVcto")
    @Generated
    public void setPercentualJuros(String percentualJuros) {
        this.percentualJuros = percentualJuros;
    }

    @JsonProperty(value="vdiaJuroMora")
    @Generated
    public void setValorDiaJuros(String valorDiaJuros) {
        this.valorDiaJuros = valorDiaJuros;
    }

    @JsonProperty(value="qdiaInicJuro")
    @Generated
    public void setDiasIncidenciaJuros(String diasIncidenciaJuros) {
        this.diasIncidenciaJuros = diasIncidenciaJuros;
    }

    @JsonProperty(value="pmultaAplicVcto")
    @Generated
    public void setPercentualMulta(String percentualMulta) {
        this.percentualMulta = percentualMulta;
    }

    @JsonProperty(value="vmultaAtrsoPgto")
    @Generated
    public void setValorMulta(String valorMulta) {
        this.valorMulta = valorMulta;
    }

    @JsonProperty(value="qdiaInicMulta")
    @Generated
    public void setDiasIncidenciaMulta(String diasIncidenciaMulta) {
        this.diasIncidenciaMulta = diasIncidenciaMulta;
    }

    @JsonProperty(value="pdescBonifPgto01")
    @Generated
    public void setPercentualDesconto1(String percentualDesconto1) {
        this.percentualDesconto1 = percentualDesconto1;
    }

    @JsonProperty(value="vdescBonifPgto01")
    @Generated
    public void setValorDesconto1(String valorDesconto1) {
        this.valorDesconto1 = valorDesconto1;
    }

    @JsonProperty(value="dlimDescBonif1")
    @Generated
    public void setDataLimiteDesconto1(String dataLimiteDesconto1) {
        this.dataLimiteDesconto1 = dataLimiteDesconto1;
    }

    @JsonProperty(value="pdescBonifPgto02")
    @Generated
    public void setPercentualDesconto2(String percentualDesconto2) {
        this.percentualDesconto2 = percentualDesconto2;
    }

    @JsonProperty(value="vdescBonifPgto02")
    @Generated
    public void setValorDesconto2(String valorDesconto2) {
        this.valorDesconto2 = valorDesconto2;
    }

    @JsonProperty(value="dlimDescBonif2")
    @Generated
    public void setDataLimiteDesconto2(String dataLimiteDesconto2) {
        this.dataLimiteDesconto2 = dataLimiteDesconto2;
    }

    @JsonProperty(value="pdescBonifPgto03")
    @Generated
    public void setPercentualDesconto3(String percentualDesconto3) {
        this.percentualDesconto3 = percentualDesconto3;
    }

    @JsonProperty(value="vdescBonifPgto03")
    @Generated
    public void setValorDesconto3(String valorDesconto3) {
        this.valorDesconto3 = valorDesconto3;
    }

    @JsonProperty(value="dlimDescBonif3")
    @Generated
    public void setDataLimiteDesconto3(String dataLimiteDesconto3) {
        this.dataLimiteDesconto3 = dataLimiteDesconto3;
    }

    @JsonProperty(value="ctpoPrzCobr")
    @Generated
    public void setTipoPrazoCobranca(String tipoPrazoCobranca) {
        this.tipoPrazoCobranca = tipoPrazoCobranca;
    }

    @JsonProperty(value="pdescBonifPgto")
    @Generated
    public void setPercentualBonificacao(String percentualBonificacao) {
        this.percentualBonificacao = percentualBonificacao;
    }

    @JsonProperty(value="vdescBonifPgto")
    @Generated
    public void setValorBonificacao(String valorBonificacao) {
        this.valorBonificacao = valorBonificacao;
    }

    @JsonProperty(value="dlimBonifPgto")
    @Generated
    public void setDlimBonifPgto(String dlimBonifPgto) {
        this.dlimBonifPgto = dlimBonifPgto;
    }

    @JsonProperty(value="vabtmtTitloCobr")
    @Generated
    public void setValorAbatimentoTitulo(String valorAbatimentoTitulo) {
        this.valorAbatimentoTitulo = valorAbatimentoTitulo;
    }

    @JsonProperty(value="viofPgtoTitlo")
    @Generated
    public void setValorIOF(String valorIOF) {
        this.valorIOF = valorIOF;
    }

    @Generated
    public void setFiller2(String filler2) {
        this.filler2 = filler2;
    }

    @JsonProperty(value="isacdoTitloCobr")
    @Generated
    public void setNomeDevedor(String nomeDevedor) {
        this.nomeDevedor = nomeDevedor;
    }

    @JsonProperty(value="elogdrSacdoTitlo")
    @Generated
    public void setLogradouroDevedor(String logradouroDevedor) {
        this.logradouroDevedor = logradouroDevedor;
    }

    @JsonProperty(value="enroLogdrSacdo")
    @Generated
    public void setNumeroLogradouroDevedor(String numeroLogradouroDevedor) {
        this.numeroLogradouroDevedor = numeroLogradouroDevedor;
    }

    @JsonProperty(value="ecomplLogdrSacdo")
    @Generated
    public void setComplementoLogradouroDevedor(String complementoLogradouroDevedor) {
        this.complementoLogradouroDevedor = complementoLogradouroDevedor;
    }

    @JsonProperty(value="ccepSacdoTitlo")
    @Generated
    public void setCepDevedor(String cepDevedor) {
        this.cepDevedor = cepDevedor;
    }

    @JsonProperty(value="ccomplCepSacdo")
    @Generated
    public void setComplementoCepDevedor(String complementoCepDevedor) {
        this.complementoCepDevedor = complementoCepDevedor;
    }

    @JsonProperty(value="ebairoLogdrSacdo")
    @Generated
    public void setBairroDevedor(String bairroDevedor) {
        this.bairroDevedor = bairroDevedor;
    }

    @JsonProperty(value="imunSacdoTitlo")
    @Generated
    public void setMunicipioDevedor(String municipioDevedor) {
        this.municipioDevedor = municipioDevedor;
    }

    @JsonProperty(value="csglUfSacdo")
    @Generated
    public void setUfDevedor(String ufDevedor) {
        this.ufDevedor = ufDevedor;
    }

    @JsonProperty(value="indCpfCnpjSacdo")
    @Generated
    public void setIndicadorDocumentoDevedor(String indicadorDocumentoDevedor) {
        this.indicadorDocumentoDevedor = indicadorDocumentoDevedor;
    }

    @JsonProperty(value="nroCpfCnpjSacdo")
    @Generated
    public void setCpfCnpjDevedor(String cpfCnpjDevedor) {
        this.cpfCnpjDevedor = cpfCnpjDevedor;
    }

    @JsonProperty(value="renderEletrSacdo")
    @Generated
    public void setEmailDevedor(String emailDevedor) {
        this.emailDevedor = emailDevedor;
    }

    @JsonProperty(value="cdddFoneSacdo")
    @Generated
    public void setDddFoneDevedor(String dddFoneDevedor) {
        this.dddFoneDevedor = dddFoneDevedor;
    }

    @JsonProperty(value="cfoneSacdoTitlo")
    @Generated
    public void setFoneDevedor(String foneDevedor) {
        this.foneDevedor = foneDevedor;
    }

    @Generated
    public void setBancoDeb(String bancoDeb) {
        this.bancoDeb = bancoDeb;
    }

    @Generated
    public void setAgenciaDeb(Long agenciaDeb) {
        this.agenciaDeb = agenciaDeb;
    }

    @Generated
    public void setAgenciaDebDv(Long agenciaDebDv) {
        this.agenciaDebDv = agenciaDebDv;
    }

    @Generated
    public void setContaDeb(Long contaDeb) {
        this.contaDeb = contaDeb;
    }

    @JsonProperty(value="bancoCentProt")
    @Generated
    public void setBancoProtesto(String bancoProtesto) {
        this.bancoProtesto = bancoProtesto;
    }

    @JsonProperty(value="agenciaDvCentPr")
    @Generated
    public void setAgenciaProtesto(String agenciaProtesto) {
        this.agenciaProtesto = agenciaProtesto;
    }

    @JsonProperty(value="isacdrAvalsTitlo")
    @Generated
    public void setNomeSacadorAvalista(String nomeSacadorAvalista) {
        this.nomeSacadorAvalista = nomeSacadorAvalista;
    }

    @JsonProperty(value="elogdrSacdrAvals")
    @Generated
    public void setLogradouroSacadorAvalista(String logradouroSacadorAvalista) {
        this.logradouroSacadorAvalista = logradouroSacadorAvalista;
    }

    @JsonProperty(value="ecomplLogdrSacdr")
    @Generated
    public void setComplementoLogradouroSacadorAvalista(String complementoLogradouroSacadorAvalista) {
        this.complementoLogradouroSacadorAvalista = complementoLogradouroSacadorAvalista;
    }

    @JsonProperty(value="ccepSacdrTitlo")
    @Generated
    public void setCepSacadorAvalista(String cepSacadorAvalista) {
        this.cepSacadorAvalista = cepSacadorAvalista;
    }

    @JsonProperty(value="ccomplCepSacdr")
    @Generated
    public void setComplementoCepSacadorAvalista(String complementoCepSacadorAvalista) {
        this.complementoCepSacadorAvalista = complementoCepSacadorAvalista;
    }

    @JsonProperty(value="ebairoLogdrSacdr")
    @Generated
    public void setBairroSacadorAvalista(String bairroSacadorAvalista) {
        this.bairroSacadorAvalista = bairroSacadorAvalista;
    }

    @JsonProperty(value="imunSacdrAvals")
    @Generated
    public void setMunicipioSacadorAvalista(String municipioSacadorAvalista) {
        this.municipioSacadorAvalista = municipioSacadorAvalista;
    }

    @JsonProperty(value="csglUfSacdr")
    @Generated
    public void setUfSacadorAvalista(String ufSacadorAvalista) {
        this.ufSacadorAvalista = ufSacadorAvalista;
    }

    @JsonProperty(value="indCpfCnpjSacdr")
    @Generated
    public void setIndicadorTipoDocumentoSacador(String indicadorTipoDocumentoSacador) {
        this.indicadorTipoDocumentoSacador = indicadorTipoDocumentoSacador;
    }

    @JsonProperty(value="nroCpfCnpjSacdr")
    @Generated
    public void setNumeroCpfCnpjSacador(String numeroCpfCnpjSacador) {
        this.numeroCpfCnpjSacador = numeroCpfCnpjSacador;
    }

    @JsonProperty(value="renderEletrSacdr")
    @Generated
    public void setEmailSacador(String emailSacador) {
        this.emailSacador = emailSacador;
    }

    @JsonProperty(value="cdddFoneSacdr")
    @Generated
    public void setDddFoneSacador(String dddFoneSacador) {
        this.dddFoneSacador = dddFoneSacador;
    }

    @Generated
    public void setEnroLogdrSacdr(String enroLogdrSacdr) {
        this.enroLogdrSacdr = enroLogdrSacdr;
    }

    @JsonProperty(value="cfoneSacdrTitlo")
    @Generated
    public void setFoneSacadorAvalista(String foneSacadorAvalista) {
        this.foneSacadorAvalista = foneSacadorAvalista;
    }

    @Generated
    public void setFiller3(String filler3) {
        this.filler3 = filler3;
    }

    @Generated
    public void setFase(String fase) {
        this.fase = fase;
    }

    @JsonProperty(value="cindcdCobrMisto")
    @Generated
    public void setRegistroQrCode(String registroQrCode) {
        this.registroQrCode = registroQrCode;
    }

    @JsonProperty(value="ialiasAdsaoCta")
    @Generated
    public void setChavePixBeneficiario(String chavePixBeneficiario) {
        this.chavePixBeneficiario = chavePixBeneficiario;
    }

    @JsonProperty(value="iconcPgtoSpi")
    @Generated
    public void setTxIdTitulo(String txIdTitulo) {
        this.txIdTitulo = txIdTitulo;
    }

    @JsonProperty(value="caliasAdsaoCta")
    @Generated
    public void setCodigoErroGeracaoQrdCode(String codigoErroGeracaoQrdCode) {
        this.codigoErroGeracaoQrdCode = codigoErroGeracaoQrdCode;
    }

    @JsonProperty(value="ilinkGeracQrcd")
    @Generated
    public void setLocationQrCode(String locationQrCode) {
        this.locationQrCode = locationQrCode;
    }

    @JsonProperty(value="wqrcdPdraoMercd")
    @Generated
    public void setCodigoEmvQrCode(String codigoEmvQrCode) {
        this.codigoEmvQrCode = codigoEmvQrCode;
    }

    @Generated
    public void setValidadeAposVencimento(String validadeAposVencimento) {
        this.validadeAposVencimento = validadeAposVencimento;
    }

    @Generated
    public void setFiller4(String filler4) {
        this.filler4 = filler4;
    }

    @Generated
    public void setIdLoc(String idLoc) {
        this.idLoc = idLoc;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmissaoBoletoBradescoHibridoDTO)) {
            return false;
        }
        EmissaoBoletoBradescoHibridoDTO other = (EmissaoBoletoBradescoHibridoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$agenciaDeb = this.getAgenciaDeb();
        Long other$agenciaDeb = other.getAgenciaDeb();
        if (this$agenciaDeb == null ? other$agenciaDeb != null : !((Object)this$agenciaDeb).equals(other$agenciaDeb)) {
            return false;
        }
        Long this$agenciaDebDv = this.getAgenciaDebDv();
        Long other$agenciaDebDv = other.getAgenciaDebDv();
        if (this$agenciaDebDv == null ? other$agenciaDebDv != null : !((Object)this$agenciaDebDv).equals(other$agenciaDebDv)) {
            return false;
        }
        Long this$contaDeb = this.getContaDeb();
        Long other$contaDeb = other.getContaDeb();
        if (this$contaDeb == null ? other$contaDeb != null : !((Object)this$contaDeb).equals(other$contaDeb)) {
            return false;
        }
        String this$nossoNumero = this.getNossoNumero();
        String other$nossoNumero = other.getNossoNumero();
        if (this$nossoNumero == null ? other$nossoNumero != null : !this$nossoNumero.equals(other$nossoNumero)) {
            return false;
        }
        String this$registrarTitulo = this.getRegistrarTitulo();
        String other$registrarTitulo = other.getRegistrarTitulo();
        if (this$registrarTitulo == null ? other$registrarTitulo != null : !this$registrarTitulo.equals(other$registrarTitulo)) {
            return false;
        }
        String this$codUsuario = this.getCodUsuario();
        String other$codUsuario = other.getCodUsuario();
        if (this$codUsuario == null ? other$codUsuario != null : !this$codUsuario.equals(other$codUsuario)) {
            return false;
        }
        String this$cpfCnpjBeneficiarioRaiz = this.getCpfCnpjBeneficiarioRaiz();
        String other$cpfCnpjBeneficiarioRaiz = other.getCpfCnpjBeneficiarioRaiz();
        if (this$cpfCnpjBeneficiarioRaiz == null ? other$cpfCnpjBeneficiarioRaiz != null : !this$cpfCnpjBeneficiarioRaiz.equals(other$cpfCnpjBeneficiarioRaiz)) {
            return false;
        }
        String this$filialCpfCnpjBenefiario = this.getFilialCpfCnpjBenefiario();
        String other$filialCpfCnpjBenefiario = other.getFilialCpfCnpjBenefiario();
        if (this$filialCpfCnpjBenefiario == null ? other$filialCpfCnpjBenefiario != null : !this$filialCpfCnpjBenefiario.equals(other$filialCpfCnpjBenefiario)) {
            return false;
        }
        String this$digitoCpfCnpjBeneficiario = this.getDigitoCpfCnpjBeneficiario();
        String other$digitoCpfCnpjBeneficiario = other.getDigitoCpfCnpjBeneficiario();
        if (this$digitoCpfCnpjBeneficiario == null ? other$digitoCpfCnpjBeneficiario != null : !this$digitoCpfCnpjBeneficiario.equals(other$digitoCpfCnpjBeneficiario)) {
            return false;
        }
        String this$tipoAcesso = this.getTipoAcesso();
        String other$tipoAcesso = other.getTipoAcesso();
        if (this$tipoAcesso == null ? other$tipoAcesso != null : !this$tipoAcesso.equals(other$tipoAcesso)) {
            return false;
        }
        String this$codigoPessoaContrato = this.getCodigoPessoaContrato();
        String other$codigoPessoaContrato = other.getCodigoPessoaContrato();
        if (this$codigoPessoaContrato == null ? other$codigoPessoaContrato != null : !this$codigoPessoaContrato.equals(other$codigoPessoaContrato)) {
            return false;
        }
        String this$tipoContrato = this.getTipoContrato();
        String other$tipoContrato = other.getTipoContrato();
        if (this$tipoContrato == null ? other$tipoContrato != null : !this$tipoContrato.equals(other$tipoContrato)) {
            return false;
        }
        String this$numeroSequenciaContrato = this.getNumeroSequenciaContrato();
        String other$numeroSequenciaContrato = other.getNumeroSequenciaContrato();
        if (this$numeroSequenciaContrato == null ? other$numeroSequenciaContrato != null : !this$numeroSequenciaContrato.equals(other$numeroSequenciaContrato)) {
            return false;
        }
        String this$carteira = this.getCarteira();
        String other$carteira = other.getCarteira();
        if (this$carteira == null ? other$carteira != null : !this$carteira.equals(other$carteira)) {
            return false;
        }
        String this$codigoNegociacaoCobranca = this.getCodigoNegociacaoCobranca();
        String other$codigoNegociacaoCobranca = other.getCodigoNegociacaoCobranca();
        if (this$codigoNegociacaoCobranca == null ? other$codigoNegociacaoCobranca != null : !this$codigoNegociacaoCobranca.equals(other$codigoNegociacaoCobranca)) {
            return false;
        }
        String this$filler = this.getFiller();
        String other$filler = other.getFiller();
        if (this$filler == null ? other$filler != null : !this$filler.equals(other$filler)) {
            return false;
        }
        String this$codigoBanco = this.getCodigoBanco();
        String other$codigoBanco = other.getCodigoBanco();
        if (this$codigoBanco == null ? other$codigoBanco != null : !this$codigoBanco.equals(other$codigoBanco)) {
            return false;
        }
        String this$numeroContratoNegociacao = this.getNumeroContratoNegociacao();
        String other$numeroContratoNegociacao = other.getNumeroContratoNegociacao();
        if (this$numeroContratoNegociacao == null ? other$numeroContratoNegociacao != null : !this$numeroContratoNegociacao.equals(other$numeroContratoNegociacao)) {
            return false;
        }
        String this$tipoRegistro = this.getTipoRegistro();
        String other$tipoRegistro = other.getTipoRegistro();
        if (this$tipoRegistro == null ? other$tipoRegistro != null : !this$tipoRegistro.equals(other$tipoRegistro)) {
            return false;
        }
        String this$codigoProdutoCobranca = this.getCodigoProdutoCobranca();
        String other$codigoProdutoCobranca = other.getCodigoProdutoCobranca();
        if (this$codigoProdutoCobranca == null ? other$codigoProdutoCobranca != null : !this$codigoProdutoCobranca.equals(other$codigoProdutoCobranca)) {
            return false;
        }
        String this$seuNumero = this.getSeuNumero();
        String other$seuNumero = other.getSeuNumero();
        if (this$seuNumero == null ? other$seuNumero != null : !this$seuNumero.equals(other$seuNumero)) {
            return false;
        }
        String this$dataEmissaoTitulo = this.getDataEmissaoTitulo();
        String other$dataEmissaoTitulo = other.getDataEmissaoTitulo();
        if (this$dataEmissaoTitulo == null ? other$dataEmissaoTitulo != null : !this$dataEmissaoTitulo.equals(other$dataEmissaoTitulo)) {
            return false;
        }
        String this$dataVencimentoTitulo = this.getDataVencimentoTitulo();
        String other$dataVencimentoTitulo = other.getDataVencimentoTitulo();
        if (this$dataVencimentoTitulo == null ? other$dataVencimentoTitulo != null : !this$dataVencimentoTitulo.equals(other$dataVencimentoTitulo)) {
            return false;
        }
        String this$identificadorVencimento = this.getIdentificadorVencimento();
        String other$identificadorVencimento = other.getIdentificadorVencimento();
        if (this$identificadorVencimento == null ? other$identificadorVencimento != null : !this$identificadorVencimento.equals(other$identificadorVencimento)) {
            return false;
        }
        String this$tipoMoeda = this.getTipoMoeda();
        String other$tipoMoeda = other.getTipoMoeda();
        if (this$tipoMoeda == null ? other$tipoMoeda != null : !this$tipoMoeda.equals(other$tipoMoeda)) {
            return false;
        }
        String this$valorNominalTitulo = this.getValorNominalTitulo();
        String other$valorNominalTitulo = other.getValorNominalTitulo();
        if (this$valorNominalTitulo == null ? other$valorNominalTitulo != null : !this$valorNominalTitulo.equals(other$valorNominalTitulo)) {
            return false;
        }
        String this$quantidadeMoedaTitulo = this.getQuantidadeMoedaTitulo();
        String other$quantidadeMoedaTitulo = other.getQuantidadeMoedaTitulo();
        if (this$quantidadeMoedaTitulo == null ? other$quantidadeMoedaTitulo != null : !this$quantidadeMoedaTitulo.equals(other$quantidadeMoedaTitulo)) {
            return false;
        }
        String this$especieTitulo = this.getEspecieTitulo();
        String other$especieTitulo = other.getEspecieTitulo();
        if (this$especieTitulo == null ? other$especieTitulo != null : !this$especieTitulo.equals(other$especieTitulo)) {
            return false;
        }
        String this$aceitaSacado = this.getAceitaSacado();
        String other$aceitaSacado = other.getAceitaSacado();
        if (this$aceitaSacado == null ? other$aceitaSacado != null : !this$aceitaSacado.equals(other$aceitaSacado)) {
            return false;
        }
        String this$tipoProtestoTitulo = this.getTipoProtestoTitulo();
        String other$tipoProtestoTitulo = other.getTipoProtestoTitulo();
        if (this$tipoProtestoTitulo == null ? other$tipoProtestoTitulo != null : !this$tipoProtestoTitulo.equals(other$tipoProtestoTitulo)) {
            return false;
        }
        String this$qtdDiasPotestoPosVencimento = this.getQtdDiasPotestoPosVencimento();
        String other$qtdDiasPotestoPosVencimento = other.getQtdDiasPotestoPosVencimento();
        if (this$qtdDiasPotestoPosVencimento == null ? other$qtdDiasPotestoPosVencimento != null : !this$qtdDiasPotestoPosVencimento.equals(other$qtdDiasPotestoPosVencimento)) {
            return false;
        }
        String this$tipoProtestoDecurso = this.getTipoProtestoDecurso();
        String other$tipoProtestoDecurso = other.getTipoProtestoDecurso();
        if (this$tipoProtestoDecurso == null ? other$tipoProtestoDecurso != null : !this$tipoProtestoDecurso.equals(other$tipoProtestoDecurso)) {
            return false;
        }
        String this$diasDecursoProtesto = this.getDiasDecursoProtesto();
        String other$diasDecursoProtesto = other.getDiasDecursoProtesto();
        if (this$diasDecursoProtesto == null ? other$diasDecursoProtesto != null : !this$diasDecursoProtesto.equals(other$diasDecursoProtesto)) {
            return false;
        }
        String this$controleParticipante = this.getControleParticipante();
        String other$controleParticipante = other.getControleParticipante();
        if (this$controleParticipante == null ? other$controleParticipante != null : !this$controleParticipante.equals(other$controleParticipante)) {
            return false;
        }
        String this$formaEmissaoBoleto = this.getFormaEmissaoBoleto();
        String other$formaEmissaoBoleto = other.getFormaEmissaoBoleto();
        if (this$formaEmissaoBoleto == null ? other$formaEmissaoBoleto != null : !this$formaEmissaoBoleto.equals(other$formaEmissaoBoleto)) {
            return false;
        }
        String this$indicadorPagamentoParcial = this.getIndicadorPagamentoParcial();
        String other$indicadorPagamentoParcial = other.getIndicadorPagamentoParcial();
        if (this$indicadorPagamentoParcial == null ? other$indicadorPagamentoParcial != null : !this$indicadorPagamentoParcial.equals(other$indicadorPagamentoParcial)) {
            return false;
        }
        String this$quantidadePagamentoParcial = this.getQuantidadePagamentoParcial();
        String other$quantidadePagamentoParcial = other.getQuantidadePagamentoParcial();
        if (this$quantidadePagamentoParcial == null ? other$quantidadePagamentoParcial != null : !this$quantidadePagamentoParcial.equals(other$quantidadePagamentoParcial)) {
            return false;
        }
        String this$filler1 = this.getFiller1();
        String other$filler1 = other.getFiller1();
        if (this$filler1 == null ? other$filler1 != null : !this$filler1.equals(other$filler1)) {
            return false;
        }
        String this$percentualJuros = this.getPercentualJuros();
        String other$percentualJuros = other.getPercentualJuros();
        if (this$percentualJuros == null ? other$percentualJuros != null : !this$percentualJuros.equals(other$percentualJuros)) {
            return false;
        }
        String this$valorDiaJuros = this.getValorDiaJuros();
        String other$valorDiaJuros = other.getValorDiaJuros();
        if (this$valorDiaJuros == null ? other$valorDiaJuros != null : !this$valorDiaJuros.equals(other$valorDiaJuros)) {
            return false;
        }
        String this$diasIncidenciaJuros = this.getDiasIncidenciaJuros();
        String other$diasIncidenciaJuros = other.getDiasIncidenciaJuros();
        if (this$diasIncidenciaJuros == null ? other$diasIncidenciaJuros != null : !this$diasIncidenciaJuros.equals(other$diasIncidenciaJuros)) {
            return false;
        }
        String this$percentualMulta = this.getPercentualMulta();
        String other$percentualMulta = other.getPercentualMulta();
        if (this$percentualMulta == null ? other$percentualMulta != null : !this$percentualMulta.equals(other$percentualMulta)) {
            return false;
        }
        String this$valorMulta = this.getValorMulta();
        String other$valorMulta = other.getValorMulta();
        if (this$valorMulta == null ? other$valorMulta != null : !this$valorMulta.equals(other$valorMulta)) {
            return false;
        }
        String this$diasIncidenciaMulta = this.getDiasIncidenciaMulta();
        String other$diasIncidenciaMulta = other.getDiasIncidenciaMulta();
        if (this$diasIncidenciaMulta == null ? other$diasIncidenciaMulta != null : !this$diasIncidenciaMulta.equals(other$diasIncidenciaMulta)) {
            return false;
        }
        String this$percentualDesconto1 = this.getPercentualDesconto1();
        String other$percentualDesconto1 = other.getPercentualDesconto1();
        if (this$percentualDesconto1 == null ? other$percentualDesconto1 != null : !this$percentualDesconto1.equals(other$percentualDesconto1)) {
            return false;
        }
        String this$valorDesconto1 = this.getValorDesconto1();
        String other$valorDesconto1 = other.getValorDesconto1();
        if (this$valorDesconto1 == null ? other$valorDesconto1 != null : !this$valorDesconto1.equals(other$valorDesconto1)) {
            return false;
        }
        String this$dataLimiteDesconto1 = this.getDataLimiteDesconto1();
        String other$dataLimiteDesconto1 = other.getDataLimiteDesconto1();
        if (this$dataLimiteDesconto1 == null ? other$dataLimiteDesconto1 != null : !this$dataLimiteDesconto1.equals(other$dataLimiteDesconto1)) {
            return false;
        }
        String this$percentualDesconto2 = this.getPercentualDesconto2();
        String other$percentualDesconto2 = other.getPercentualDesconto2();
        if (this$percentualDesconto2 == null ? other$percentualDesconto2 != null : !this$percentualDesconto2.equals(other$percentualDesconto2)) {
            return false;
        }
        String this$valorDesconto2 = this.getValorDesconto2();
        String other$valorDesconto2 = other.getValorDesconto2();
        if (this$valorDesconto2 == null ? other$valorDesconto2 != null : !this$valorDesconto2.equals(other$valorDesconto2)) {
            return false;
        }
        String this$dataLimiteDesconto2 = this.getDataLimiteDesconto2();
        String other$dataLimiteDesconto2 = other.getDataLimiteDesconto2();
        if (this$dataLimiteDesconto2 == null ? other$dataLimiteDesconto2 != null : !this$dataLimiteDesconto2.equals(other$dataLimiteDesconto2)) {
            return false;
        }
        String this$percentualDesconto3 = this.getPercentualDesconto3();
        String other$percentualDesconto3 = other.getPercentualDesconto3();
        if (this$percentualDesconto3 == null ? other$percentualDesconto3 != null : !this$percentualDesconto3.equals(other$percentualDesconto3)) {
            return false;
        }
        String this$valorDesconto3 = this.getValorDesconto3();
        String other$valorDesconto3 = other.getValorDesconto3();
        if (this$valorDesconto3 == null ? other$valorDesconto3 != null : !this$valorDesconto3.equals(other$valorDesconto3)) {
            return false;
        }
        String this$dataLimiteDesconto3 = this.getDataLimiteDesconto3();
        String other$dataLimiteDesconto3 = other.getDataLimiteDesconto3();
        if (this$dataLimiteDesconto3 == null ? other$dataLimiteDesconto3 != null : !this$dataLimiteDesconto3.equals(other$dataLimiteDesconto3)) {
            return false;
        }
        String this$tipoPrazoCobranca = this.getTipoPrazoCobranca();
        String other$tipoPrazoCobranca = other.getTipoPrazoCobranca();
        if (this$tipoPrazoCobranca == null ? other$tipoPrazoCobranca != null : !this$tipoPrazoCobranca.equals(other$tipoPrazoCobranca)) {
            return false;
        }
        String this$percentualBonificacao = this.getPercentualBonificacao();
        String other$percentualBonificacao = other.getPercentualBonificacao();
        if (this$percentualBonificacao == null ? other$percentualBonificacao != null : !this$percentualBonificacao.equals(other$percentualBonificacao)) {
            return false;
        }
        String this$valorBonificacao = this.getValorBonificacao();
        String other$valorBonificacao = other.getValorBonificacao();
        if (this$valorBonificacao == null ? other$valorBonificacao != null : !this$valorBonificacao.equals(other$valorBonificacao)) {
            return false;
        }
        String this$dlimBonifPgto = this.getDlimBonifPgto();
        String other$dlimBonifPgto = other.getDlimBonifPgto();
        if (this$dlimBonifPgto == null ? other$dlimBonifPgto != null : !this$dlimBonifPgto.equals(other$dlimBonifPgto)) {
            return false;
        }
        String this$valorAbatimentoTitulo = this.getValorAbatimentoTitulo();
        String other$valorAbatimentoTitulo = other.getValorAbatimentoTitulo();
        if (this$valorAbatimentoTitulo == null ? other$valorAbatimentoTitulo != null : !this$valorAbatimentoTitulo.equals(other$valorAbatimentoTitulo)) {
            return false;
        }
        String this$valorIOF = this.getValorIOF();
        String other$valorIOF = other.getValorIOF();
        if (this$valorIOF == null ? other$valorIOF != null : !this$valorIOF.equals(other$valorIOF)) {
            return false;
        }
        String this$filler2 = this.getFiller2();
        String other$filler2 = other.getFiller2();
        if (this$filler2 == null ? other$filler2 != null : !this$filler2.equals(other$filler2)) {
            return false;
        }
        String this$nomeDevedor = this.getNomeDevedor();
        String other$nomeDevedor = other.getNomeDevedor();
        if (this$nomeDevedor == null ? other$nomeDevedor != null : !this$nomeDevedor.equals(other$nomeDevedor)) {
            return false;
        }
        String this$logradouroDevedor = this.getLogradouroDevedor();
        String other$logradouroDevedor = other.getLogradouroDevedor();
        if (this$logradouroDevedor == null ? other$logradouroDevedor != null : !this$logradouroDevedor.equals(other$logradouroDevedor)) {
            return false;
        }
        String this$numeroLogradouroDevedor = this.getNumeroLogradouroDevedor();
        String other$numeroLogradouroDevedor = other.getNumeroLogradouroDevedor();
        if (this$numeroLogradouroDevedor == null ? other$numeroLogradouroDevedor != null : !this$numeroLogradouroDevedor.equals(other$numeroLogradouroDevedor)) {
            return false;
        }
        String this$complementoLogradouroDevedor = this.getComplementoLogradouroDevedor();
        String other$complementoLogradouroDevedor = other.getComplementoLogradouroDevedor();
        if (this$complementoLogradouroDevedor == null ? other$complementoLogradouroDevedor != null : !this$complementoLogradouroDevedor.equals(other$complementoLogradouroDevedor)) {
            return false;
        }
        String this$cepDevedor = this.getCepDevedor();
        String other$cepDevedor = other.getCepDevedor();
        if (this$cepDevedor == null ? other$cepDevedor != null : !this$cepDevedor.equals(other$cepDevedor)) {
            return false;
        }
        String this$complementoCepDevedor = this.getComplementoCepDevedor();
        String other$complementoCepDevedor = other.getComplementoCepDevedor();
        if (this$complementoCepDevedor == null ? other$complementoCepDevedor != null : !this$complementoCepDevedor.equals(other$complementoCepDevedor)) {
            return false;
        }
        String this$bairroDevedor = this.getBairroDevedor();
        String other$bairroDevedor = other.getBairroDevedor();
        if (this$bairroDevedor == null ? other$bairroDevedor != null : !this$bairroDevedor.equals(other$bairroDevedor)) {
            return false;
        }
        String this$municipioDevedor = this.getMunicipioDevedor();
        String other$municipioDevedor = other.getMunicipioDevedor();
        if (this$municipioDevedor == null ? other$municipioDevedor != null : !this$municipioDevedor.equals(other$municipioDevedor)) {
            return false;
        }
        String this$ufDevedor = this.getUfDevedor();
        String other$ufDevedor = other.getUfDevedor();
        if (this$ufDevedor == null ? other$ufDevedor != null : !this$ufDevedor.equals(other$ufDevedor)) {
            return false;
        }
        String this$indicadorDocumentoDevedor = this.getIndicadorDocumentoDevedor();
        String other$indicadorDocumentoDevedor = other.getIndicadorDocumentoDevedor();
        if (this$indicadorDocumentoDevedor == null ? other$indicadorDocumentoDevedor != null : !this$indicadorDocumentoDevedor.equals(other$indicadorDocumentoDevedor)) {
            return false;
        }
        String this$cpfCnpjDevedor = this.getCpfCnpjDevedor();
        String other$cpfCnpjDevedor = other.getCpfCnpjDevedor();
        if (this$cpfCnpjDevedor == null ? other$cpfCnpjDevedor != null : !this$cpfCnpjDevedor.equals(other$cpfCnpjDevedor)) {
            return false;
        }
        String this$emailDevedor = this.getEmailDevedor();
        String other$emailDevedor = other.getEmailDevedor();
        if (this$emailDevedor == null ? other$emailDevedor != null : !this$emailDevedor.equals(other$emailDevedor)) {
            return false;
        }
        String this$dddFoneDevedor = this.getDddFoneDevedor();
        String other$dddFoneDevedor = other.getDddFoneDevedor();
        if (this$dddFoneDevedor == null ? other$dddFoneDevedor != null : !this$dddFoneDevedor.equals(other$dddFoneDevedor)) {
            return false;
        }
        String this$foneDevedor = this.getFoneDevedor();
        String other$foneDevedor = other.getFoneDevedor();
        if (this$foneDevedor == null ? other$foneDevedor != null : !this$foneDevedor.equals(other$foneDevedor)) {
            return false;
        }
        String this$bancoDeb = this.getBancoDeb();
        String other$bancoDeb = other.getBancoDeb();
        if (this$bancoDeb == null ? other$bancoDeb != null : !this$bancoDeb.equals(other$bancoDeb)) {
            return false;
        }
        String this$bancoProtesto = this.getBancoProtesto();
        String other$bancoProtesto = other.getBancoProtesto();
        if (this$bancoProtesto == null ? other$bancoProtesto != null : !this$bancoProtesto.equals(other$bancoProtesto)) {
            return false;
        }
        String this$agenciaProtesto = this.getAgenciaProtesto();
        String other$agenciaProtesto = other.getAgenciaProtesto();
        if (this$agenciaProtesto == null ? other$agenciaProtesto != null : !this$agenciaProtesto.equals(other$agenciaProtesto)) {
            return false;
        }
        String this$nomeSacadorAvalista = this.getNomeSacadorAvalista();
        String other$nomeSacadorAvalista = other.getNomeSacadorAvalista();
        if (this$nomeSacadorAvalista == null ? other$nomeSacadorAvalista != null : !this$nomeSacadorAvalista.equals(other$nomeSacadorAvalista)) {
            return false;
        }
        String this$logradouroSacadorAvalista = this.getLogradouroSacadorAvalista();
        String other$logradouroSacadorAvalista = other.getLogradouroSacadorAvalista();
        if (this$logradouroSacadorAvalista == null ? other$logradouroSacadorAvalista != null : !this$logradouroSacadorAvalista.equals(other$logradouroSacadorAvalista)) {
            return false;
        }
        String this$complementoLogradouroSacadorAvalista = this.getComplementoLogradouroSacadorAvalista();
        String other$complementoLogradouroSacadorAvalista = other.getComplementoLogradouroSacadorAvalista();
        if (this$complementoLogradouroSacadorAvalista == null ? other$complementoLogradouroSacadorAvalista != null : !this$complementoLogradouroSacadorAvalista.equals(other$complementoLogradouroSacadorAvalista)) {
            return false;
        }
        String this$cepSacadorAvalista = this.getCepSacadorAvalista();
        String other$cepSacadorAvalista = other.getCepSacadorAvalista();
        if (this$cepSacadorAvalista == null ? other$cepSacadorAvalista != null : !this$cepSacadorAvalista.equals(other$cepSacadorAvalista)) {
            return false;
        }
        String this$complementoCepSacadorAvalista = this.getComplementoCepSacadorAvalista();
        String other$complementoCepSacadorAvalista = other.getComplementoCepSacadorAvalista();
        if (this$complementoCepSacadorAvalista == null ? other$complementoCepSacadorAvalista != null : !this$complementoCepSacadorAvalista.equals(other$complementoCepSacadorAvalista)) {
            return false;
        }
        String this$bairroSacadorAvalista = this.getBairroSacadorAvalista();
        String other$bairroSacadorAvalista = other.getBairroSacadorAvalista();
        if (this$bairroSacadorAvalista == null ? other$bairroSacadorAvalista != null : !this$bairroSacadorAvalista.equals(other$bairroSacadorAvalista)) {
            return false;
        }
        String this$municipioSacadorAvalista = this.getMunicipioSacadorAvalista();
        String other$municipioSacadorAvalista = other.getMunicipioSacadorAvalista();
        if (this$municipioSacadorAvalista == null ? other$municipioSacadorAvalista != null : !this$municipioSacadorAvalista.equals(other$municipioSacadorAvalista)) {
            return false;
        }
        String this$ufSacadorAvalista = this.getUfSacadorAvalista();
        String other$ufSacadorAvalista = other.getUfSacadorAvalista();
        if (this$ufSacadorAvalista == null ? other$ufSacadorAvalista != null : !this$ufSacadorAvalista.equals(other$ufSacadorAvalista)) {
            return false;
        }
        String this$indicadorTipoDocumentoSacador = this.getIndicadorTipoDocumentoSacador();
        String other$indicadorTipoDocumentoSacador = other.getIndicadorTipoDocumentoSacador();
        if (this$indicadorTipoDocumentoSacador == null ? other$indicadorTipoDocumentoSacador != null : !this$indicadorTipoDocumentoSacador.equals(other$indicadorTipoDocumentoSacador)) {
            return false;
        }
        String this$numeroCpfCnpjSacador = this.getNumeroCpfCnpjSacador();
        String other$numeroCpfCnpjSacador = other.getNumeroCpfCnpjSacador();
        if (this$numeroCpfCnpjSacador == null ? other$numeroCpfCnpjSacador != null : !this$numeroCpfCnpjSacador.equals(other$numeroCpfCnpjSacador)) {
            return false;
        }
        String this$emailSacador = this.getEmailSacador();
        String other$emailSacador = other.getEmailSacador();
        if (this$emailSacador == null ? other$emailSacador != null : !this$emailSacador.equals(other$emailSacador)) {
            return false;
        }
        String this$dddFoneSacador = this.getDddFoneSacador();
        String other$dddFoneSacador = other.getDddFoneSacador();
        if (this$dddFoneSacador == null ? other$dddFoneSacador != null : !this$dddFoneSacador.equals(other$dddFoneSacador)) {
            return false;
        }
        String this$enroLogdrSacdr = this.getEnroLogdrSacdr();
        String other$enroLogdrSacdr = other.getEnroLogdrSacdr();
        if (this$enroLogdrSacdr == null ? other$enroLogdrSacdr != null : !this$enroLogdrSacdr.equals(other$enroLogdrSacdr)) {
            return false;
        }
        String this$foneSacadorAvalista = this.getFoneSacadorAvalista();
        String other$foneSacadorAvalista = other.getFoneSacadorAvalista();
        if (this$foneSacadorAvalista == null ? other$foneSacadorAvalista != null : !this$foneSacadorAvalista.equals(other$foneSacadorAvalista)) {
            return false;
        }
        String this$filler3 = this.getFiller3();
        String other$filler3 = other.getFiller3();
        if (this$filler3 == null ? other$filler3 != null : !this$filler3.equals(other$filler3)) {
            return false;
        }
        String this$fase = this.getFase();
        String other$fase = other.getFase();
        if (this$fase == null ? other$fase != null : !this$fase.equals(other$fase)) {
            return false;
        }
        String this$registroQrCode = this.getRegistroQrCode();
        String other$registroQrCode = other.getRegistroQrCode();
        if (this$registroQrCode == null ? other$registroQrCode != null : !this$registroQrCode.equals(other$registroQrCode)) {
            return false;
        }
        String this$chavePixBeneficiario = this.getChavePixBeneficiario();
        String other$chavePixBeneficiario = other.getChavePixBeneficiario();
        if (this$chavePixBeneficiario == null ? other$chavePixBeneficiario != null : !this$chavePixBeneficiario.equals(other$chavePixBeneficiario)) {
            return false;
        }
        String this$txIdTitulo = this.getTxIdTitulo();
        String other$txIdTitulo = other.getTxIdTitulo();
        if (this$txIdTitulo == null ? other$txIdTitulo != null : !this$txIdTitulo.equals(other$txIdTitulo)) {
            return false;
        }
        String this$codigoErroGeracaoQrdCode = this.getCodigoErroGeracaoQrdCode();
        String other$codigoErroGeracaoQrdCode = other.getCodigoErroGeracaoQrdCode();
        if (this$codigoErroGeracaoQrdCode == null ? other$codigoErroGeracaoQrdCode != null : !this$codigoErroGeracaoQrdCode.equals(other$codigoErroGeracaoQrdCode)) {
            return false;
        }
        String this$locationQrCode = this.getLocationQrCode();
        String other$locationQrCode = other.getLocationQrCode();
        if (this$locationQrCode == null ? other$locationQrCode != null : !this$locationQrCode.equals(other$locationQrCode)) {
            return false;
        }
        String this$codigoEmvQrCode = this.getCodigoEmvQrCode();
        String other$codigoEmvQrCode = other.getCodigoEmvQrCode();
        if (this$codigoEmvQrCode == null ? other$codigoEmvQrCode != null : !this$codigoEmvQrCode.equals(other$codigoEmvQrCode)) {
            return false;
        }
        String this$validadeAposVencimento = this.getValidadeAposVencimento();
        String other$validadeAposVencimento = other.getValidadeAposVencimento();
        if (this$validadeAposVencimento == null ? other$validadeAposVencimento != null : !this$validadeAposVencimento.equals(other$validadeAposVencimento)) {
            return false;
        }
        String this$filler4 = this.getFiller4();
        String other$filler4 = other.getFiller4();
        if (this$filler4 == null ? other$filler4 != null : !this$filler4.equals(other$filler4)) {
            return false;
        }
        String this$idLoc = this.getIdLoc();
        String other$idLoc = other.getIdLoc();
        return !(this$idLoc == null ? other$idLoc != null : !this$idLoc.equals(other$idLoc));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EmissaoBoletoBradescoHibridoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $agenciaDeb = this.getAgenciaDeb();
        result = result * 59 + ($agenciaDeb == null ? 43 : ((Object)$agenciaDeb).hashCode());
        Long $agenciaDebDv = this.getAgenciaDebDv();
        result = result * 59 + ($agenciaDebDv == null ? 43 : ((Object)$agenciaDebDv).hashCode());
        Long $contaDeb = this.getContaDeb();
        result = result * 59 + ($contaDeb == null ? 43 : ((Object)$contaDeb).hashCode());
        String $nossoNumero = this.getNossoNumero();
        result = result * 59 + ($nossoNumero == null ? 43 : $nossoNumero.hashCode());
        String $registrarTitulo = this.getRegistrarTitulo();
        result = result * 59 + ($registrarTitulo == null ? 43 : $registrarTitulo.hashCode());
        String $codUsuario = this.getCodUsuario();
        result = result * 59 + ($codUsuario == null ? 43 : $codUsuario.hashCode());
        String $cpfCnpjBeneficiarioRaiz = this.getCpfCnpjBeneficiarioRaiz();
        result = result * 59 + ($cpfCnpjBeneficiarioRaiz == null ? 43 : $cpfCnpjBeneficiarioRaiz.hashCode());
        String $filialCpfCnpjBenefiario = this.getFilialCpfCnpjBenefiario();
        result = result * 59 + ($filialCpfCnpjBenefiario == null ? 43 : $filialCpfCnpjBenefiario.hashCode());
        String $digitoCpfCnpjBeneficiario = this.getDigitoCpfCnpjBeneficiario();
        result = result * 59 + ($digitoCpfCnpjBeneficiario == null ? 43 : $digitoCpfCnpjBeneficiario.hashCode());
        String $tipoAcesso = this.getTipoAcesso();
        result = result * 59 + ($tipoAcesso == null ? 43 : $tipoAcesso.hashCode());
        String $codigoPessoaContrato = this.getCodigoPessoaContrato();
        result = result * 59 + ($codigoPessoaContrato == null ? 43 : $codigoPessoaContrato.hashCode());
        String $tipoContrato = this.getTipoContrato();
        result = result * 59 + ($tipoContrato == null ? 43 : $tipoContrato.hashCode());
        String $numeroSequenciaContrato = this.getNumeroSequenciaContrato();
        result = result * 59 + ($numeroSequenciaContrato == null ? 43 : $numeroSequenciaContrato.hashCode());
        String $carteira = this.getCarteira();
        result = result * 59 + ($carteira == null ? 43 : $carteira.hashCode());
        String $codigoNegociacaoCobranca = this.getCodigoNegociacaoCobranca();
        result = result * 59 + ($codigoNegociacaoCobranca == null ? 43 : $codigoNegociacaoCobranca.hashCode());
        String $filler = this.getFiller();
        result = result * 59 + ($filler == null ? 43 : $filler.hashCode());
        String $codigoBanco = this.getCodigoBanco();
        result = result * 59 + ($codigoBanco == null ? 43 : $codigoBanco.hashCode());
        String $numeroContratoNegociacao = this.getNumeroContratoNegociacao();
        result = result * 59 + ($numeroContratoNegociacao == null ? 43 : $numeroContratoNegociacao.hashCode());
        String $tipoRegistro = this.getTipoRegistro();
        result = result * 59 + ($tipoRegistro == null ? 43 : $tipoRegistro.hashCode());
        String $codigoProdutoCobranca = this.getCodigoProdutoCobranca();
        result = result * 59 + ($codigoProdutoCobranca == null ? 43 : $codigoProdutoCobranca.hashCode());
        String $seuNumero = this.getSeuNumero();
        result = result * 59 + ($seuNumero == null ? 43 : $seuNumero.hashCode());
        String $dataEmissaoTitulo = this.getDataEmissaoTitulo();
        result = result * 59 + ($dataEmissaoTitulo == null ? 43 : $dataEmissaoTitulo.hashCode());
        String $dataVencimentoTitulo = this.getDataVencimentoTitulo();
        result = result * 59 + ($dataVencimentoTitulo == null ? 43 : $dataVencimentoTitulo.hashCode());
        String $identificadorVencimento = this.getIdentificadorVencimento();
        result = result * 59 + ($identificadorVencimento == null ? 43 : $identificadorVencimento.hashCode());
        String $tipoMoeda = this.getTipoMoeda();
        result = result * 59 + ($tipoMoeda == null ? 43 : $tipoMoeda.hashCode());
        String $valorNominalTitulo = this.getValorNominalTitulo();
        result = result * 59 + ($valorNominalTitulo == null ? 43 : $valorNominalTitulo.hashCode());
        String $quantidadeMoedaTitulo = this.getQuantidadeMoedaTitulo();
        result = result * 59 + ($quantidadeMoedaTitulo == null ? 43 : $quantidadeMoedaTitulo.hashCode());
        String $especieTitulo = this.getEspecieTitulo();
        result = result * 59 + ($especieTitulo == null ? 43 : $especieTitulo.hashCode());
        String $aceitaSacado = this.getAceitaSacado();
        result = result * 59 + ($aceitaSacado == null ? 43 : $aceitaSacado.hashCode());
        String $tipoProtestoTitulo = this.getTipoProtestoTitulo();
        result = result * 59 + ($tipoProtestoTitulo == null ? 43 : $tipoProtestoTitulo.hashCode());
        String $qtdDiasPotestoPosVencimento = this.getQtdDiasPotestoPosVencimento();
        result = result * 59 + ($qtdDiasPotestoPosVencimento == null ? 43 : $qtdDiasPotestoPosVencimento.hashCode());
        String $tipoProtestoDecurso = this.getTipoProtestoDecurso();
        result = result * 59 + ($tipoProtestoDecurso == null ? 43 : $tipoProtestoDecurso.hashCode());
        String $diasDecursoProtesto = this.getDiasDecursoProtesto();
        result = result * 59 + ($diasDecursoProtesto == null ? 43 : $diasDecursoProtesto.hashCode());
        String $controleParticipante = this.getControleParticipante();
        result = result * 59 + ($controleParticipante == null ? 43 : $controleParticipante.hashCode());
        String $formaEmissaoBoleto = this.getFormaEmissaoBoleto();
        result = result * 59 + ($formaEmissaoBoleto == null ? 43 : $formaEmissaoBoleto.hashCode());
        String $indicadorPagamentoParcial = this.getIndicadorPagamentoParcial();
        result = result * 59 + ($indicadorPagamentoParcial == null ? 43 : $indicadorPagamentoParcial.hashCode());
        String $quantidadePagamentoParcial = this.getQuantidadePagamentoParcial();
        result = result * 59 + ($quantidadePagamentoParcial == null ? 43 : $quantidadePagamentoParcial.hashCode());
        String $filler1 = this.getFiller1();
        result = result * 59 + ($filler1 == null ? 43 : $filler1.hashCode());
        String $percentualJuros = this.getPercentualJuros();
        result = result * 59 + ($percentualJuros == null ? 43 : $percentualJuros.hashCode());
        String $valorDiaJuros = this.getValorDiaJuros();
        result = result * 59 + ($valorDiaJuros == null ? 43 : $valorDiaJuros.hashCode());
        String $diasIncidenciaJuros = this.getDiasIncidenciaJuros();
        result = result * 59 + ($diasIncidenciaJuros == null ? 43 : $diasIncidenciaJuros.hashCode());
        String $percentualMulta = this.getPercentualMulta();
        result = result * 59 + ($percentualMulta == null ? 43 : $percentualMulta.hashCode());
        String $valorMulta = this.getValorMulta();
        result = result * 59 + ($valorMulta == null ? 43 : $valorMulta.hashCode());
        String $diasIncidenciaMulta = this.getDiasIncidenciaMulta();
        result = result * 59 + ($diasIncidenciaMulta == null ? 43 : $diasIncidenciaMulta.hashCode());
        String $percentualDesconto1 = this.getPercentualDesconto1();
        result = result * 59 + ($percentualDesconto1 == null ? 43 : $percentualDesconto1.hashCode());
        String $valorDesconto1 = this.getValorDesconto1();
        result = result * 59 + ($valorDesconto1 == null ? 43 : $valorDesconto1.hashCode());
        String $dataLimiteDesconto1 = this.getDataLimiteDesconto1();
        result = result * 59 + ($dataLimiteDesconto1 == null ? 43 : $dataLimiteDesconto1.hashCode());
        String $percentualDesconto2 = this.getPercentualDesconto2();
        result = result * 59 + ($percentualDesconto2 == null ? 43 : $percentualDesconto2.hashCode());
        String $valorDesconto2 = this.getValorDesconto2();
        result = result * 59 + ($valorDesconto2 == null ? 43 : $valorDesconto2.hashCode());
        String $dataLimiteDesconto2 = this.getDataLimiteDesconto2();
        result = result * 59 + ($dataLimiteDesconto2 == null ? 43 : $dataLimiteDesconto2.hashCode());
        String $percentualDesconto3 = this.getPercentualDesconto3();
        result = result * 59 + ($percentualDesconto3 == null ? 43 : $percentualDesconto3.hashCode());
        String $valorDesconto3 = this.getValorDesconto3();
        result = result * 59 + ($valorDesconto3 == null ? 43 : $valorDesconto3.hashCode());
        String $dataLimiteDesconto3 = this.getDataLimiteDesconto3();
        result = result * 59 + ($dataLimiteDesconto3 == null ? 43 : $dataLimiteDesconto3.hashCode());
        String $tipoPrazoCobranca = this.getTipoPrazoCobranca();
        result = result * 59 + ($tipoPrazoCobranca == null ? 43 : $tipoPrazoCobranca.hashCode());
        String $percentualBonificacao = this.getPercentualBonificacao();
        result = result * 59 + ($percentualBonificacao == null ? 43 : $percentualBonificacao.hashCode());
        String $valorBonificacao = this.getValorBonificacao();
        result = result * 59 + ($valorBonificacao == null ? 43 : $valorBonificacao.hashCode());
        String $dlimBonifPgto = this.getDlimBonifPgto();
        result = result * 59 + ($dlimBonifPgto == null ? 43 : $dlimBonifPgto.hashCode());
        String $valorAbatimentoTitulo = this.getValorAbatimentoTitulo();
        result = result * 59 + ($valorAbatimentoTitulo == null ? 43 : $valorAbatimentoTitulo.hashCode());
        String $valorIOF = this.getValorIOF();
        result = result * 59 + ($valorIOF == null ? 43 : $valorIOF.hashCode());
        String $filler2 = this.getFiller2();
        result = result * 59 + ($filler2 == null ? 43 : $filler2.hashCode());
        String $nomeDevedor = this.getNomeDevedor();
        result = result * 59 + ($nomeDevedor == null ? 43 : $nomeDevedor.hashCode());
        String $logradouroDevedor = this.getLogradouroDevedor();
        result = result * 59 + ($logradouroDevedor == null ? 43 : $logradouroDevedor.hashCode());
        String $numeroLogradouroDevedor = this.getNumeroLogradouroDevedor();
        result = result * 59 + ($numeroLogradouroDevedor == null ? 43 : $numeroLogradouroDevedor.hashCode());
        String $complementoLogradouroDevedor = this.getComplementoLogradouroDevedor();
        result = result * 59 + ($complementoLogradouroDevedor == null ? 43 : $complementoLogradouroDevedor.hashCode());
        String $cepDevedor = this.getCepDevedor();
        result = result * 59 + ($cepDevedor == null ? 43 : $cepDevedor.hashCode());
        String $complementoCepDevedor = this.getComplementoCepDevedor();
        result = result * 59 + ($complementoCepDevedor == null ? 43 : $complementoCepDevedor.hashCode());
        String $bairroDevedor = this.getBairroDevedor();
        result = result * 59 + ($bairroDevedor == null ? 43 : $bairroDevedor.hashCode());
        String $municipioDevedor = this.getMunicipioDevedor();
        result = result * 59 + ($municipioDevedor == null ? 43 : $municipioDevedor.hashCode());
        String $ufDevedor = this.getUfDevedor();
        result = result * 59 + ($ufDevedor == null ? 43 : $ufDevedor.hashCode());
        String $indicadorDocumentoDevedor = this.getIndicadorDocumentoDevedor();
        result = result * 59 + ($indicadorDocumentoDevedor == null ? 43 : $indicadorDocumentoDevedor.hashCode());
        String $cpfCnpjDevedor = this.getCpfCnpjDevedor();
        result = result * 59 + ($cpfCnpjDevedor == null ? 43 : $cpfCnpjDevedor.hashCode());
        String $emailDevedor = this.getEmailDevedor();
        result = result * 59 + ($emailDevedor == null ? 43 : $emailDevedor.hashCode());
        String $dddFoneDevedor = this.getDddFoneDevedor();
        result = result * 59 + ($dddFoneDevedor == null ? 43 : $dddFoneDevedor.hashCode());
        String $foneDevedor = this.getFoneDevedor();
        result = result * 59 + ($foneDevedor == null ? 43 : $foneDevedor.hashCode());
        String $bancoDeb = this.getBancoDeb();
        result = result * 59 + ($bancoDeb == null ? 43 : $bancoDeb.hashCode());
        String $bancoProtesto = this.getBancoProtesto();
        result = result * 59 + ($bancoProtesto == null ? 43 : $bancoProtesto.hashCode());
        String $agenciaProtesto = this.getAgenciaProtesto();
        result = result * 59 + ($agenciaProtesto == null ? 43 : $agenciaProtesto.hashCode());
        String $nomeSacadorAvalista = this.getNomeSacadorAvalista();
        result = result * 59 + ($nomeSacadorAvalista == null ? 43 : $nomeSacadorAvalista.hashCode());
        String $logradouroSacadorAvalista = this.getLogradouroSacadorAvalista();
        result = result * 59 + ($logradouroSacadorAvalista == null ? 43 : $logradouroSacadorAvalista.hashCode());
        String $complementoLogradouroSacadorAvalista = this.getComplementoLogradouroSacadorAvalista();
        result = result * 59 + ($complementoLogradouroSacadorAvalista == null ? 43 : $complementoLogradouroSacadorAvalista.hashCode());
        String $cepSacadorAvalista = this.getCepSacadorAvalista();
        result = result * 59 + ($cepSacadorAvalista == null ? 43 : $cepSacadorAvalista.hashCode());
        String $complementoCepSacadorAvalista = this.getComplementoCepSacadorAvalista();
        result = result * 59 + ($complementoCepSacadorAvalista == null ? 43 : $complementoCepSacadorAvalista.hashCode());
        String $bairroSacadorAvalista = this.getBairroSacadorAvalista();
        result = result * 59 + ($bairroSacadorAvalista == null ? 43 : $bairroSacadorAvalista.hashCode());
        String $municipioSacadorAvalista = this.getMunicipioSacadorAvalista();
        result = result * 59 + ($municipioSacadorAvalista == null ? 43 : $municipioSacadorAvalista.hashCode());
        String $ufSacadorAvalista = this.getUfSacadorAvalista();
        result = result * 59 + ($ufSacadorAvalista == null ? 43 : $ufSacadorAvalista.hashCode());
        String $indicadorTipoDocumentoSacador = this.getIndicadorTipoDocumentoSacador();
        result = result * 59 + ($indicadorTipoDocumentoSacador == null ? 43 : $indicadorTipoDocumentoSacador.hashCode());
        String $numeroCpfCnpjSacador = this.getNumeroCpfCnpjSacador();
        result = result * 59 + ($numeroCpfCnpjSacador == null ? 43 : $numeroCpfCnpjSacador.hashCode());
        String $emailSacador = this.getEmailSacador();
        result = result * 59 + ($emailSacador == null ? 43 : $emailSacador.hashCode());
        String $dddFoneSacador = this.getDddFoneSacador();
        result = result * 59 + ($dddFoneSacador == null ? 43 : $dddFoneSacador.hashCode());
        String $enroLogdrSacdr = this.getEnroLogdrSacdr();
        result = result * 59 + ($enroLogdrSacdr == null ? 43 : $enroLogdrSacdr.hashCode());
        String $foneSacadorAvalista = this.getFoneSacadorAvalista();
        result = result * 59 + ($foneSacadorAvalista == null ? 43 : $foneSacadorAvalista.hashCode());
        String $filler3 = this.getFiller3();
        result = result * 59 + ($filler3 == null ? 43 : $filler3.hashCode());
        String $fase = this.getFase();
        result = result * 59 + ($fase == null ? 43 : $fase.hashCode());
        String $registroQrCode = this.getRegistroQrCode();
        result = result * 59 + ($registroQrCode == null ? 43 : $registroQrCode.hashCode());
        String $chavePixBeneficiario = this.getChavePixBeneficiario();
        result = result * 59 + ($chavePixBeneficiario == null ? 43 : $chavePixBeneficiario.hashCode());
        String $txIdTitulo = this.getTxIdTitulo();
        result = result * 59 + ($txIdTitulo == null ? 43 : $txIdTitulo.hashCode());
        String $codigoErroGeracaoQrdCode = this.getCodigoErroGeracaoQrdCode();
        result = result * 59 + ($codigoErroGeracaoQrdCode == null ? 43 : $codigoErroGeracaoQrdCode.hashCode());
        String $locationQrCode = this.getLocationQrCode();
        result = result * 59 + ($locationQrCode == null ? 43 : $locationQrCode.hashCode());
        String $codigoEmvQrCode = this.getCodigoEmvQrCode();
        result = result * 59 + ($codigoEmvQrCode == null ? 43 : $codigoEmvQrCode.hashCode());
        String $validadeAposVencimento = this.getValidadeAposVencimento();
        result = result * 59 + ($validadeAposVencimento == null ? 43 : $validadeAposVencimento.hashCode());
        String $filler4 = this.getFiller4();
        result = result * 59 + ($filler4 == null ? 43 : $filler4.hashCode());
        String $idLoc = this.getIdLoc();
        result = result * 59 + ($idLoc == null ? 43 : $idLoc.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EmissaoBoletoBradescoHibridoDTO(nossoNumero=" + this.getNossoNumero() + ", registrarTitulo=" + this.getRegistrarTitulo() + ", codUsuario=" + this.getCodUsuario() + ", cpfCnpjBeneficiarioRaiz=" + this.getCpfCnpjBeneficiarioRaiz() + ", filialCpfCnpjBenefiario=" + this.getFilialCpfCnpjBenefiario() + ", digitoCpfCnpjBeneficiario=" + this.getDigitoCpfCnpjBeneficiario() + ", tipoAcesso=" + this.getTipoAcesso() + ", codigoPessoaContrato=" + this.getCodigoPessoaContrato() + ", tipoContrato=" + this.getTipoContrato() + ", numeroSequenciaContrato=" + this.getNumeroSequenciaContrato() + ", carteira=" + this.getCarteira() + ", codigoNegociacaoCobranca=" + this.getCodigoNegociacaoCobranca() + ", filler=" + this.getFiller() + ", codigoBanco=" + this.getCodigoBanco() + ", numeroContratoNegociacao=" + this.getNumeroContratoNegociacao() + ", tipoRegistro=" + this.getTipoRegistro() + ", codigoProdutoCobranca=" + this.getCodigoProdutoCobranca() + ", seuNumero=" + this.getSeuNumero() + ", dataEmissaoTitulo=" + this.getDataEmissaoTitulo() + ", dataVencimentoTitulo=" + this.getDataVencimentoTitulo() + ", identificadorVencimento=" + this.getIdentificadorVencimento() + ", tipoMoeda=" + this.getTipoMoeda() + ", valorNominalTitulo=" + this.getValorNominalTitulo() + ", quantidadeMoedaTitulo=" + this.getQuantidadeMoedaTitulo() + ", especieTitulo=" + this.getEspecieTitulo() + ", aceitaSacado=" + this.getAceitaSacado() + ", tipoProtestoTitulo=" + this.getTipoProtestoTitulo() + ", qtdDiasPotestoPosVencimento=" + this.getQtdDiasPotestoPosVencimento() + ", tipoProtestoDecurso=" + this.getTipoProtestoDecurso() + ", diasDecursoProtesto=" + this.getDiasDecursoProtesto() + ", controleParticipante=" + this.getControleParticipante() + ", formaEmissaoBoleto=" + this.getFormaEmissaoBoleto() + ", indicadorPagamentoParcial=" + this.getIndicadorPagamentoParcial() + ", quantidadePagamentoParcial=" + this.getQuantidadePagamentoParcial() + ", filler1=" + this.getFiller1() + ", percentualJuros=" + this.getPercentualJuros() + ", valorDiaJuros=" + this.getValorDiaJuros() + ", diasIncidenciaJuros=" + this.getDiasIncidenciaJuros() + ", percentualMulta=" + this.getPercentualMulta() + ", valorMulta=" + this.getValorMulta() + ", diasIncidenciaMulta=" + this.getDiasIncidenciaMulta() + ", percentualDesconto1=" + this.getPercentualDesconto1() + ", valorDesconto1=" + this.getValorDesconto1() + ", dataLimiteDesconto1=" + this.getDataLimiteDesconto1() + ", percentualDesconto2=" + this.getPercentualDesconto2() + ", valorDesconto2=" + this.getValorDesconto2() + ", dataLimiteDesconto2=" + this.getDataLimiteDesconto2() + ", percentualDesconto3=" + this.getPercentualDesconto3() + ", valorDesconto3=" + this.getValorDesconto3() + ", dataLimiteDesconto3=" + this.getDataLimiteDesconto3() + ", tipoPrazoCobranca=" + this.getTipoPrazoCobranca() + ", percentualBonificacao=" + this.getPercentualBonificacao() + ", valorBonificacao=" + this.getValorBonificacao() + ", dlimBonifPgto=" + this.getDlimBonifPgto() + ", valorAbatimentoTitulo=" + this.getValorAbatimentoTitulo() + ", valorIOF=" + this.getValorIOF() + ", filler2=" + this.getFiller2() + ", nomeDevedor=" + this.getNomeDevedor() + ", logradouroDevedor=" + this.getLogradouroDevedor() + ", numeroLogradouroDevedor=" + this.getNumeroLogradouroDevedor() + ", complementoLogradouroDevedor=" + this.getComplementoLogradouroDevedor() + ", cepDevedor=" + this.getCepDevedor() + ", complementoCepDevedor=" + this.getComplementoCepDevedor() + ", bairroDevedor=" + this.getBairroDevedor() + ", municipioDevedor=" + this.getMunicipioDevedor() + ", ufDevedor=" + this.getUfDevedor() + ", indicadorDocumentoDevedor=" + this.getIndicadorDocumentoDevedor() + ", cpfCnpjDevedor=" + this.getCpfCnpjDevedor() + ", emailDevedor=" + this.getEmailDevedor() + ", dddFoneDevedor=" + this.getDddFoneDevedor() + ", foneDevedor=" + this.getFoneDevedor() + ", bancoDeb=" + this.getBancoDeb() + ", agenciaDeb=" + this.getAgenciaDeb() + ", agenciaDebDv=" + this.getAgenciaDebDv() + ", contaDeb=" + this.getContaDeb() + ", bancoProtesto=" + this.getBancoProtesto() + ", agenciaProtesto=" + this.getAgenciaProtesto() + ", nomeSacadorAvalista=" + this.getNomeSacadorAvalista() + ", logradouroSacadorAvalista=" + this.getLogradouroSacadorAvalista() + ", complementoLogradouroSacadorAvalista=" + this.getComplementoLogradouroSacadorAvalista() + ", cepSacadorAvalista=" + this.getCepSacadorAvalista() + ", complementoCepSacadorAvalista=" + this.getComplementoCepSacadorAvalista() + ", bairroSacadorAvalista=" + this.getBairroSacadorAvalista() + ", municipioSacadorAvalista=" + this.getMunicipioSacadorAvalista() + ", ufSacadorAvalista=" + this.getUfSacadorAvalista() + ", indicadorTipoDocumentoSacador=" + this.getIndicadorTipoDocumentoSacador() + ", numeroCpfCnpjSacador=" + this.getNumeroCpfCnpjSacador() + ", emailSacador=" + this.getEmailSacador() + ", dddFoneSacador=" + this.getDddFoneSacador() + ", enroLogdrSacdr=" + this.getEnroLogdrSacdr() + ", foneSacadorAvalista=" + this.getFoneSacadorAvalista() + ", filler3=" + this.getFiller3() + ", fase=" + this.getFase() + ", registroQrCode=" + this.getRegistroQrCode() + ", chavePixBeneficiario=" + this.getChavePixBeneficiario() + ", txIdTitulo=" + this.getTxIdTitulo() + ", codigoErroGeracaoQrdCode=" + this.getCodigoErroGeracaoQrdCode() + ", locationQrCode=" + this.getLocationQrCode() + ", codigoEmvQrCode=" + this.getCodigoEmvQrCode() + ", validadeAposVencimento=" + (this.getValidadeAposVencimento() + ", filler4=" + this.getFiller4() + ", idLoc=" + this.getIdLoc() + ")");
    }

    @Generated
    public EmissaoBoletoBradescoHibridoDTO() {
        this.registrarTitulo = EmissaoBoletoBradescoHibridoDTO.$default$registrarTitulo();
        this.codUsuario = EmissaoBoletoBradescoHibridoDTO.$default$codUsuario();
        this.tipoAcesso = EmissaoBoletoBradescoHibridoDTO.$default$tipoAcesso();
        this.codigoPessoaContrato = EmissaoBoletoBradescoHibridoDTO.$default$codigoPessoaContrato();
        this.tipoContrato = EmissaoBoletoBradescoHibridoDTO.$default$tipoContrato();
        this.numeroSequenciaContrato = EmissaoBoletoBradescoHibridoDTO.$default$numeroSequenciaContrato();
        this.filler = EmissaoBoletoBradescoHibridoDTO.$default$filler();
        this.codigoBanco = EmissaoBoletoBradescoHibridoDTO.$default$codigoBanco();
        this.numeroContratoNegociacao = EmissaoBoletoBradescoHibridoDTO.$default$numeroContratoNegociacao();
        this.tipoRegistro = EmissaoBoletoBradescoHibridoDTO.$default$tipoRegistro();
        this.codigoProdutoCobranca = EmissaoBoletoBradescoHibridoDTO.$default$codigoProdutoCobranca();
        this.identificadorVencimento = EmissaoBoletoBradescoHibridoDTO.$default$identificadorVencimento();
        this.tipoMoeda = EmissaoBoletoBradescoHibridoDTO.$default$tipoMoeda();
        this.quantidadeMoedaTitulo = EmissaoBoletoBradescoHibridoDTO.$default$quantidadeMoedaTitulo();
        this.aceitaSacado = EmissaoBoletoBradescoHibridoDTO.$default$aceitaSacado();
        this.tipoProtestoTitulo = EmissaoBoletoBradescoHibridoDTO.$default$tipoProtestoTitulo();
        this.qtdDiasPotestoPosVencimento = EmissaoBoletoBradescoHibridoDTO.$default$qtdDiasPotestoPosVencimento();
        this.tipoProtestoDecurso = EmissaoBoletoBradescoHibridoDTO.$default$tipoProtestoDecurso();
        this.diasDecursoProtesto = EmissaoBoletoBradescoHibridoDTO.$default$diasDecursoProtesto();
        this.controleParticipante = EmissaoBoletoBradescoHibridoDTO.$default$controleParticipante();
        this.formaEmissaoBoleto = EmissaoBoletoBradescoHibridoDTO.$default$formaEmissaoBoleto();
        this.indicadorPagamentoParcial = EmissaoBoletoBradescoHibridoDTO.$default$indicadorPagamentoParcial();
        this.quantidadePagamentoParcial = EmissaoBoletoBradescoHibridoDTO.$default$quantidadePagamentoParcial();
        this.filler1 = EmissaoBoletoBradescoHibridoDTO.$default$filler1();
        this.tipoPrazoCobranca = EmissaoBoletoBradescoHibridoDTO.$default$tipoPrazoCobranca();
        this.percentualBonificacao = EmissaoBoletoBradescoHibridoDTO.$default$percentualBonificacao();
        this.valorBonificacao = EmissaoBoletoBradescoHibridoDTO.$default$valorBonificacao();
        this.dlimBonifPgto = EmissaoBoletoBradescoHibridoDTO.$default$dlimBonifPgto();
        this.valorAbatimentoTitulo = EmissaoBoletoBradescoHibridoDTO.$default$valorAbatimentoTitulo();
        this.valorIOF = EmissaoBoletoBradescoHibridoDTO.$default$valorIOF();
        this.filler2 = EmissaoBoletoBradescoHibridoDTO.$default$filler2();
        this.complementoLogradouroDevedor = EmissaoBoletoBradescoHibridoDTO.$default$complementoLogradouroDevedor();
        this.emailDevedor = EmissaoBoletoBradescoHibridoDTO.$default$emailDevedor();
        this.dddFoneDevedor = EmissaoBoletoBradescoHibridoDTO.$default$dddFoneDevedor();
        this.foneDevedor = EmissaoBoletoBradescoHibridoDTO.$default$foneDevedor();
        this.bancoDeb = EmissaoBoletoBradescoHibridoDTO.$default$bancoDeb();
        this.agenciaDeb = EmissaoBoletoBradescoHibridoDTO.$default$agenciaDeb();
        this.agenciaDebDv = EmissaoBoletoBradescoHibridoDTO.$default$agenciaDebDv();
        this.contaDeb = EmissaoBoletoBradescoHibridoDTO.$default$contaDeb();
        this.bancoProtesto = EmissaoBoletoBradescoHibridoDTO.$default$bancoProtesto();
        this.agenciaProtesto = EmissaoBoletoBradescoHibridoDTO.$default$agenciaProtesto();
        this.nomeSacadorAvalista = EmissaoBoletoBradescoHibridoDTO.$default$nomeSacadorAvalista();
        this.logradouroSacadorAvalista = EmissaoBoletoBradescoHibridoDTO.$default$logradouroSacadorAvalista();
        this.complementoLogradouroSacadorAvalista = EmissaoBoletoBradescoHibridoDTO.$default$complementoLogradouroSacadorAvalista();
        this.cepSacadorAvalista = EmissaoBoletoBradescoHibridoDTO.$default$cepSacadorAvalista();
        this.complementoCepSacadorAvalista = EmissaoBoletoBradescoHibridoDTO.$default$complementoCepSacadorAvalista();
        this.bairroSacadorAvalista = EmissaoBoletoBradescoHibridoDTO.$default$bairroSacadorAvalista();
        this.municipioSacadorAvalista = EmissaoBoletoBradescoHibridoDTO.$default$municipioSacadorAvalista();
        this.ufSacadorAvalista = EmissaoBoletoBradescoHibridoDTO.$default$ufSacadorAvalista();
        this.indicadorTipoDocumentoSacador = EmissaoBoletoBradescoHibridoDTO.$default$indicadorTipoDocumentoSacador();
        this.numeroCpfCnpjSacador = EmissaoBoletoBradescoHibridoDTO.$default$numeroCpfCnpjSacador();
        this.emailSacador = EmissaoBoletoBradescoHibridoDTO.$default$emailSacador();
        this.dddFoneSacador = EmissaoBoletoBradescoHibridoDTO.$default$dddFoneSacador();
        this.enroLogdrSacdr = EmissaoBoletoBradescoHibridoDTO.$default$enroLogdrSacdr();
        this.foneSacadorAvalista = EmissaoBoletoBradescoHibridoDTO.$default$foneSacadorAvalista();
        this.filler3 = EmissaoBoletoBradescoHibridoDTO.$default$filler3();
        this.fase = EmissaoBoletoBradescoHibridoDTO.$default$fase();
        this.registroQrCode = EmissaoBoletoBradescoHibridoDTO.$default$registroQrCode();
        this.chavePixBeneficiario = EmissaoBoletoBradescoHibridoDTO.$default$chavePixBeneficiario();
        this.txIdTitulo = EmissaoBoletoBradescoHibridoDTO.$default$txIdTitulo();
        this.codigoErroGeracaoQrdCode = EmissaoBoletoBradescoHibridoDTO.$default$codigoErroGeracaoQrdCode();
        this.locationQrCode = EmissaoBoletoBradescoHibridoDTO.$default$locationQrCode();
        this.codigoEmvQrCode = EmissaoBoletoBradescoHibridoDTO.$default$codigoEmvQrCode();
        this.validadeAposVencimento = EmissaoBoletoBradescoHibridoDTO.$default$validadeAposVencimento();
        this.filler4 = EmissaoBoletoBradescoHibridoDTO.$default$filler4();
        this.idLoc = EmissaoBoletoBradescoHibridoDTO.$default$idLoc();
    }

    @Generated
    public EmissaoBoletoBradescoHibridoDTO(String nossoNumero, String registrarTitulo, String codUsuario, String cpfCnpjBeneficiarioRaiz, String filialCpfCnpjBenefiario, String digitoCpfCnpjBeneficiario, String tipoAcesso, String codigoPessoaContrato, String tipoContrato, String numeroSequenciaContrato, String carteira, String codigoNegociacaoCobranca, String filler, String codigoBanco, String numeroContratoNegociacao, String tipoRegistro, String codigoProdutoCobranca, String seuNumero, String dataEmissaoTitulo, String dataVencimentoTitulo, String identificadorVencimento, String tipoMoeda, String valorNominalTitulo, String quantidadeMoedaTitulo, String especieTitulo, String aceitaSacado, String tipoProtestoTitulo, String qtdDiasPotestoPosVencimento, String tipoProtestoDecurso, String diasDecursoProtesto, String controleParticipante, String formaEmissaoBoleto, String indicadorPagamentoParcial, String quantidadePagamentoParcial, String filler1, String percentualJuros, String valorDiaJuros, String diasIncidenciaJuros, String percentualMulta, String valorMulta, String diasIncidenciaMulta, String percentualDesconto1, String valorDesconto1, String dataLimiteDesconto1, String percentualDesconto2, String valorDesconto2, String dataLimiteDesconto2, String percentualDesconto3, String valorDesconto3, String dataLimiteDesconto3, String tipoPrazoCobranca, String percentualBonificacao, String valorBonificacao, String dlimBonifPgto, String valorAbatimentoTitulo, String valorIOF, String filler2, String nomeDevedor, String logradouroDevedor, String numeroLogradouroDevedor, String complementoLogradouroDevedor, String cepDevedor, String complementoCepDevedor, String bairroDevedor, String municipioDevedor, String ufDevedor, String indicadorDocumentoDevedor, String cpfCnpjDevedor, String emailDevedor, String dddFoneDevedor, String foneDevedor, String bancoDeb, Long agenciaDeb, Long agenciaDebDv, Long contaDeb, String bancoProtesto, String agenciaProtesto, String nomeSacadorAvalista, String logradouroSacadorAvalista, String complementoLogradouroSacadorAvalista, String cepSacadorAvalista, String complementoCepSacadorAvalista, String bairroSacadorAvalista, String municipioSacadorAvalista, String ufSacadorAvalista, String indicadorTipoDocumentoSacador, String numeroCpfCnpjSacador, String emailSacador, String dddFoneSacador, String enroLogdrSacdr, String foneSacadorAvalista, String filler3, String fase, String registroQrCode, String chavePixBeneficiario, String txIdTitulo, String codigoErroGeracaoQrdCode, String locationQrCode, String codigoEmvQrCode, String validadeAposVencimento, String filler4, String idLoc) {
        this.nossoNumero = nossoNumero;
        this.registrarTitulo = registrarTitulo;
        this.codUsuario = codUsuario;
        this.cpfCnpjBeneficiarioRaiz = cpfCnpjBeneficiarioRaiz;
        this.filialCpfCnpjBenefiario = filialCpfCnpjBenefiario;
        this.digitoCpfCnpjBeneficiario = digitoCpfCnpjBeneficiario;
        this.tipoAcesso = tipoAcesso;
        this.codigoPessoaContrato = codigoPessoaContrato;
        this.tipoContrato = tipoContrato;
        this.numeroSequenciaContrato = numeroSequenciaContrato;
        this.carteira = carteira;
        this.codigoNegociacaoCobranca = codigoNegociacaoCobranca;
        this.filler = filler;
        this.codigoBanco = codigoBanco;
        this.numeroContratoNegociacao = numeroContratoNegociacao;
        this.tipoRegistro = tipoRegistro;
        this.codigoProdutoCobranca = codigoProdutoCobranca;
        this.seuNumero = seuNumero;
        this.dataEmissaoTitulo = dataEmissaoTitulo;
        this.dataVencimentoTitulo = dataVencimentoTitulo;
        this.identificadorVencimento = identificadorVencimento;
        this.tipoMoeda = tipoMoeda;
        this.valorNominalTitulo = valorNominalTitulo;
        this.quantidadeMoedaTitulo = quantidadeMoedaTitulo;
        this.especieTitulo = especieTitulo;
        this.aceitaSacado = aceitaSacado;
        this.tipoProtestoTitulo = tipoProtestoTitulo;
        this.qtdDiasPotestoPosVencimento = qtdDiasPotestoPosVencimento;
        this.tipoProtestoDecurso = tipoProtestoDecurso;
        this.diasDecursoProtesto = diasDecursoProtesto;
        this.controleParticipante = controleParticipante;
        this.formaEmissaoBoleto = formaEmissaoBoleto;
        this.indicadorPagamentoParcial = indicadorPagamentoParcial;
        this.quantidadePagamentoParcial = quantidadePagamentoParcial;
        this.filler1 = filler1;
        this.percentualJuros = percentualJuros;
        this.valorDiaJuros = valorDiaJuros;
        this.diasIncidenciaJuros = diasIncidenciaJuros;
        this.percentualMulta = percentualMulta;
        this.valorMulta = valorMulta;
        this.diasIncidenciaMulta = diasIncidenciaMulta;
        this.percentualDesconto1 = percentualDesconto1;
        this.valorDesconto1 = valorDesconto1;
        this.dataLimiteDesconto1 = dataLimiteDesconto1;
        this.percentualDesconto2 = percentualDesconto2;
        this.valorDesconto2 = valorDesconto2;
        this.dataLimiteDesconto2 = dataLimiteDesconto2;
        this.percentualDesconto3 = percentualDesconto3;
        this.valorDesconto3 = valorDesconto3;
        this.dataLimiteDesconto3 = dataLimiteDesconto3;
        this.tipoPrazoCobranca = tipoPrazoCobranca;
        this.percentualBonificacao = percentualBonificacao;
        this.valorBonificacao = valorBonificacao;
        this.dlimBonifPgto = dlimBonifPgto;
        this.valorAbatimentoTitulo = valorAbatimentoTitulo;
        this.valorIOF = valorIOF;
        this.filler2 = filler2;
        this.nomeDevedor = nomeDevedor;
        this.logradouroDevedor = logradouroDevedor;
        this.numeroLogradouroDevedor = numeroLogradouroDevedor;
        this.complementoLogradouroDevedor = complementoLogradouroDevedor;
        this.cepDevedor = cepDevedor;
        this.complementoCepDevedor = complementoCepDevedor;
        this.bairroDevedor = bairroDevedor;
        this.municipioDevedor = municipioDevedor;
        this.ufDevedor = ufDevedor;
        this.indicadorDocumentoDevedor = indicadorDocumentoDevedor;
        this.cpfCnpjDevedor = cpfCnpjDevedor;
        this.emailDevedor = emailDevedor;
        this.dddFoneDevedor = dddFoneDevedor;
        this.foneDevedor = foneDevedor;
        this.bancoDeb = bancoDeb;
        this.agenciaDeb = agenciaDeb;
        this.agenciaDebDv = agenciaDebDv;
        this.contaDeb = contaDeb;
        this.bancoProtesto = bancoProtesto;
        this.agenciaProtesto = agenciaProtesto;
        this.nomeSacadorAvalista = nomeSacadorAvalista;
        this.logradouroSacadorAvalista = logradouroSacadorAvalista;
        this.complementoLogradouroSacadorAvalista = complementoLogradouroSacadorAvalista;
        this.cepSacadorAvalista = cepSacadorAvalista;
        this.complementoCepSacadorAvalista = complementoCepSacadorAvalista;
        this.bairroSacadorAvalista = bairroSacadorAvalista;
        this.municipioSacadorAvalista = municipioSacadorAvalista;
        this.ufSacadorAvalista = ufSacadorAvalista;
        this.indicadorTipoDocumentoSacador = indicadorTipoDocumentoSacador;
        this.numeroCpfCnpjSacador = numeroCpfCnpjSacador;
        this.emailSacador = emailSacador;
        this.dddFoneSacador = dddFoneSacador;
        this.enroLogdrSacdr = enroLogdrSacdr;
        this.foneSacadorAvalista = foneSacadorAvalista;
        this.filler3 = filler3;
        this.fase = fase;
        this.registroQrCode = registroQrCode;
        this.chavePixBeneficiario = chavePixBeneficiario;
        this.txIdTitulo = txIdTitulo;
        this.codigoErroGeracaoQrdCode = codigoErroGeracaoQrdCode;
        this.locationQrCode = locationQrCode;
        this.codigoEmvQrCode = codigoEmvQrCode;
        this.validadeAposVencimento = validadeAposVencimento;
        this.filler4 = filler4;
        this.idLoc = idLoc;
    }
}

