/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.bbpay;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.EnderecoPessoa;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.UnidadeFederacao;
import br.com.elotech.tributos.domain.cnab240.CNAB240CodigoJuros;
import br.com.elotech.tributos.domain.cnab240.CNAB240CodigoMulta;
import br.com.elotech.tributos.domain.cnab240.ParametroCNAB240;
import br.com.elotech.tributos.dto.enums.FormaPagamentoSolicitacao;
import br.com.elotech.tributos.dto.enums.TipoValorBoleto;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.bbpay.DescontoBBPayDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.bbpay.DevedorBBPayDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.bbpay.FormaPagamentoBBPayDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.bbpay.GeralBBPayDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.bbpay.IntegracaoSolicitacaoBBPayDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.bbpay.RepasseBBPayDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.bbpay.RepasseReceboresBBPayDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.bbpay.RepasseReceboresRequestBBPayDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.bbpay.SolicitacaoBBPayRequestDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.bbpay.VencimentoBBPayDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.bbpay.enums.TipoRecebedor;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.bbpay.enums.TipoValorRepasse;
import br.com.elotech.tributos.service.integracaoboleto.bancodobrasil.BbUtilsService;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class SolicitacaoBBPayRequestDTO {
    private static Boolean PAGAMENTO_UNICO = true;
    private static final DateTimeFormatter DATETIMEFORMATTER_ANO_MES_DIA = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter DATETIMEFORMATTER_ANO_MES_DIA_HORA = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private GeralBBPayDTO geral;
    private DevedorBBPayDTO devedor;
    private VencimentoBBPayDTO vencimento;
    private List<FormaPagamentoBBPayDTO> formasPagamento;
    private RepasseBBPayDTO repasse;

    public static SolicitacaoBBPayRequestDTO from(IntegracaoSolicitacaoBBPayDTO integracaoSolicitacaoBBPay, Bloqueto boleto, ParametroCNAB240 parametroCNAB240BB) {
        Optional.ofNullable(boleto).orElseThrow(() -> new EloValidationException("N\u00e3o foi informado o bloqueto da solicita\u00e7\u00e3o"));
        Optional.ofNullable(boleto.getModeloBloqueto()).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrado um modelo de bloqueto para o boleto de ID: %s", boleto.getId())));
        Convenio convenio = Optional.ofNullable(boleto.getModeloBloqueto().getConvenio()).orElseThrow(() -> new EloValidationException(String.format("Dados de conv\u00eanio n\u00e3o encontrado para o boleto de ID: %s", boleto.getId())));
        Pessoa pessoa = Optional.ofNullable(boleto.getPessoa()).orElseThrow(() -> new EloValidationException(String.format("Pessoa n\u00e3o encontrada para o boleto de ID: %s", boleto.getId())));
        EnderecoPessoa endereco = Optional.ofNullable(pessoa).map(Pessoa::getEnderecoPrincipal).orElse(null);
        return SolicitacaoBBPayRequestDTO.builder().geral(GeralBBPayDTO.builder().numeroConvenio((Long)Optional.ofNullable(convenio.getNumeroConvenio()).map(Long::valueOf).orElse(null)).pagamentoUnico(PAGAMENTO_UNICO.booleanValue()).timestampLimiteSolicitacao(boleto.getDataLimitePagamento() != null ? boleto.getDataLimitePagamento().atTime(23, 59, 59).format(DATETIMEFORMATTER_ANO_MES_DIA_HORA) : null).valorSolicitacao(boleto.getValorBloqueto()).descricaoSolicitacao("Cobran\u00e7a BBPAY").codigoConciliacaoSolicitacao(boleto.getNossoNumero()).urlRetorno(null).build()).devedor(DevedorBBPayDTO.builder().tipoDocumento(Optional.ofNullable(pessoa).map(Pessoa::getCnpjCpfSemMascara).map(BbUtilsService::retornarCodigoDocumento).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi possivel identificar o tipo de documento da pessoa : %s", pessoa.getId())))).numeroDocumento(Long.valueOf(pessoa.getCnpjCpfSemMascara())).cep((Long)Optional.ofNullable(endereco).map(EnderecoPessoa::getCep).orElse(null)).endereco(SolicitacaoBBPayRequestDTO.montarEndereco((EnderecoPessoa)endereco)).bairro((String)Optional.ofNullable(endereco).map(EnderecoPessoa::getBairro).map(Bairro::getDescricao).orElse(null)).cidade((String)Optional.ofNullable(endereco).map(EnderecoPessoa::getCidade).map(Cidade::getDescricao).orElse(null)).uf(Optional.ofNullable(endereco).map(EnderecoPessoa::getUnidadeFederacao).map(UnidadeFederacao::getUnidadeFederacao).orElse(Optional.ofNullable(endereco).map(EnderecoPessoa::getCidade).map(Cidade::getUnidadeFederacao).orElse(null))).build()).vencimento(VencimentoBBPayDTO.builder().data(Optional.ofNullable(boleto.getDataVencimento()).map(dataVencimento -> dataVencimento.format(DATETIMEFORMATTER_ANO_MES_DIA)).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi informada a data de vencimento para o boleto de ID : %s", boleto.getId())))).multaPercentual(SolicitacaoBBPayRequestDTO.montarMulta((ParametroCNAB240)parametroCNAB240BB)).jurosPercentual(SolicitacaoBBPayRequestDTO.montarJuros((ParametroCNAB240)parametroCNAB240BB)).descontos(new ArrayList()).build()).formasPagamento(SolicitacaoBBPayRequestDTO.criarFormasPagamento()).repasse((RepasseBBPayDTO)Optional.ofNullable(integracaoSolicitacaoBBPay.getRepasses()).filter(repasses -> !repasses.isEmpty()).map(repasses -> RepasseBBPayDTO.builder().tipoValorRepasse(TipoValorRepasse.getDescricaoEnum((String)integracaoSolicitacaoBBPay.getTipoValorRepasse())).recebedores(SolicitacaoBBPayRequestDTO.montarRepasseRecebedores((List)repasses)).build()).orElse(null)).build();
    }

    public static BigDecimal montarMulta(ParametroCNAB240 parametrosCNAB240BB) {
        Long tipoMulta = Optional.ofNullable(parametrosCNAB240BB.getCodigoMulta()).map(CNAB240CodigoMulta::getId).orElse(0L);
        if (TipoValorBoleto.VALOR.getValue().equals(tipoMulta)) {
            throw new EloValidationException("Para o BBPAY a multa deve ser do tipo percentual");
        }
        return tipoMulta > 0L && TipoValorBoleto.PERCENTUAL.getValue().equals(tipoMulta) ? parametrosCNAB240BB.getValorPercentualMulta() : new BigDecimal(0);
    }

    public static BigDecimal montarJuros(ParametroCNAB240 parametrosCNAB240BB) {
        Long tipoJuros = Optional.ofNullable(parametrosCNAB240BB.getCodigoJuros()).map(CNAB240CodigoJuros::getId).orElse(0L);
        if (TipoValorBoleto.VALOR.getValue().equals(tipoJuros)) {
            throw new EloValidationException("Para o BBPAY o tipo de juros deve ser do tipo percentual");
        }
        return tipoJuros > 0L && TipoValorBoleto.PERCENTUAL.getValue().equals(tipoJuros) ? parametrosCNAB240BB.getValorJurosDiaTaxa() : new BigDecimal(0);
    }

    public static List<RepasseReceboresRequestBBPayDTO> montarRepasseRecebedores(List<RepasseReceboresBBPayDTO> repasseRecebores) {
        return repasseRecebores.stream().map(repasse -> RepasseReceboresRequestBBPayDTO.builder().identificadorRecebedor(repasse.getIdentificadorRecebedor()).tipoRecebedor(TipoRecebedor.getDescricaoEnum((String)repasse.getTipoRecebedor())).valorRepasse(repasse.getValorRepasse()).build()).collect(Collectors.toList());
    }

    public static List<FormaPagamentoBBPayDTO> criarFormasPagamento() {
        return Arrays.asList(FormaPagamentoBBPayDTO.builder().codigoTipoPagamento(FormaPagamentoSolicitacao.PIX.getValue()).quantidadeParcelas(Long.valueOf(1L)).build(), FormaPagamentoBBPayDTO.builder().codigoTipoPagamento(FormaPagamentoSolicitacao.BOLETO.getValue()).quantidadeParcelas(Long.valueOf(1L)).build());
    }

    public static List<DescontoBBPayDTO> montarDesconto(ParametroCNAB240 parametrosCNAB240BB, Bloqueto boleto) {
        ArrayList<DescontoBBPayDTO> listaDescontos = new ArrayList<DescontoBBPayDTO>();
        listaDescontos.add(SolicitacaoBBPayRequestDTO.builderDesconto((BigDecimal)parametrosCNAB240BB.getValorPercentualDesconto(), (String)boleto.getDataVencimento().format(DATETIMEFORMATTER_ANO_MES_DIA)));
        listaDescontos.add(SolicitacaoBBPayRequestDTO.builderDesconto((BigDecimal)parametrosCNAB240BB.getValorPercentualDesconto2(), null));
        listaDescontos.add(SolicitacaoBBPayRequestDTO.builderDesconto((BigDecimal)parametrosCNAB240BB.getValorPercentualDesconto3(), null));
        return listaDescontos;
    }

    private static DescontoBBPayDTO builderDesconto(BigDecimal valorDesconto, String dataLimite) {
        return DescontoBBPayDTO.builder().valorFixo(valorDesconto).dataLimite(dataLimite).build();
    }

    public static String montarEndereco(EnderecoPessoa enderecoPessoa) {
        if (Objects.nonNull(enderecoPessoa)) {
            String logradouroTipo = Optional.ofNullable(enderecoPessoa.getLogradouro()).map(Logradouro::getTipoLogradouroDescricao).orElse("");
            String logradouroDescricao = Optional.ofNullable(enderecoPessoa.getLogradouro()).map(Logradouro::getDescricao).orElse("");
            String numero = Optional.ofNullable(enderecoPessoa.getNumero()).orElse("");
            return StringUtils.normalizeSpace((String)String.format("%s %s %s %s", logradouroTipo, logradouroDescricao, numero, Optional.ofNullable(enderecoPessoa.getComplemento()).orElse("")));
        }
        return "";
    }

    @Generated
    SolicitacaoBBPayRequestDTO(GeralBBPayDTO geral, DevedorBBPayDTO devedor, VencimentoBBPayDTO vencimento, List<FormaPagamentoBBPayDTO> formasPagamento, RepasseBBPayDTO repasse) {
        this.geral = geral;
        this.devedor = devedor;
        this.vencimento = vencimento;
        this.formasPagamento = formasPagamento;
        this.repasse = repasse;
    }

    @Generated
    public static SolicitacaoBBPayRequestDTOBuilder builder() {
        return new SolicitacaoBBPayRequestDTOBuilder();
    }

    @Generated
    public GeralBBPayDTO getGeral() {
        return this.geral;
    }

    @Generated
    public DevedorBBPayDTO getDevedor() {
        return this.devedor;
    }

    @Generated
    public VencimentoBBPayDTO getVencimento() {
        return this.vencimento;
    }

    @Generated
    public List<FormaPagamentoBBPayDTO> getFormasPagamento() {
        return this.formasPagamento;
    }

    @Generated
    public RepasseBBPayDTO getRepasse() {
        return this.repasse;
    }

    @Generated
    public void setGeral(GeralBBPayDTO geral) {
        this.geral = geral;
    }

    @Generated
    public void setDevedor(DevedorBBPayDTO devedor) {
        this.devedor = devedor;
    }

    @Generated
    public void setVencimento(VencimentoBBPayDTO vencimento) {
        this.vencimento = vencimento;
    }

    @Generated
    public void setFormasPagamento(List<FormaPagamentoBBPayDTO> formasPagamento) {
        this.formasPagamento = formasPagamento;
    }

    @Generated
    public void setRepasse(RepasseBBPayDTO repasse) {
        this.repasse = repasse;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SolicitacaoBBPayRequestDTO)) {
            return false;
        }
        SolicitacaoBBPayRequestDTO other = (SolicitacaoBBPayRequestDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        GeralBBPayDTO this$geral = this.getGeral();
        GeralBBPayDTO other$geral = other.getGeral();
        if (this$geral == null ? other$geral != null : !this$geral.equals(other$geral)) {
            return false;
        }
        DevedorBBPayDTO this$devedor = this.getDevedor();
        DevedorBBPayDTO other$devedor = other.getDevedor();
        if (this$devedor == null ? other$devedor != null : !this$devedor.equals(other$devedor)) {
            return false;
        }
        VencimentoBBPayDTO this$vencimento = this.getVencimento();
        VencimentoBBPayDTO other$vencimento = other.getVencimento();
        if (this$vencimento == null ? other$vencimento != null : !this$vencimento.equals(other$vencimento)) {
            return false;
        }
        List this$formasPagamento = this.getFormasPagamento();
        List other$formasPagamento = other.getFormasPagamento();
        if (this$formasPagamento == null ? other$formasPagamento != null : !((Object)this$formasPagamento).equals(other$formasPagamento)) {
            return false;
        }
        RepasseBBPayDTO this$repasse = this.getRepasse();
        RepasseBBPayDTO other$repasse = other.getRepasse();
        return !(this$repasse == null ? other$repasse != null : !this$repasse.equals(other$repasse));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SolicitacaoBBPayRequestDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GeralBBPayDTO $geral = this.getGeral();
        result = result * 59 + ($geral == null ? 43 : $geral.hashCode());
        DevedorBBPayDTO $devedor = this.getDevedor();
        result = result * 59 + ($devedor == null ? 43 : $devedor.hashCode());
        VencimentoBBPayDTO $vencimento = this.getVencimento();
        result = result * 59 + ($vencimento == null ? 43 : $vencimento.hashCode());
        List $formasPagamento = this.getFormasPagamento();
        result = result * 59 + ($formasPagamento == null ? 43 : ((Object)$formasPagamento).hashCode());
        RepasseBBPayDTO $repasse = this.getRepasse();
        result = result * 59 + ($repasse == null ? 43 : $repasse.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SolicitacaoBBPayRequestDTO(geral=" + String.valueOf(this.getGeral()) + ", devedor=" + String.valueOf(this.getDevedor()) + ", vencimento=" + String.valueOf(this.getVencimento()) + ", formasPagamento=" + String.valueOf(this.getFormasPagamento()) + ", repasse=" + String.valueOf(this.getRepasse()) + ")";
    }
}

