/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil;

import br.com.elotech.tributos.dto.enums.TipoConvenioWebHook;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.DadosWebHookDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.bbpay.ConsultaDadosPagamentoBBPayResponseDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.bbpay.PagamentoBBPayResponseDTO;
import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class DadosWebHookDTO {
    private TipoConvenioWebHook tipoConvenioWebHook;
    private String endToEndId;
    private String codigoConciliacaoSolicitacao;
    private String txid;
    private String idCobranca;
    private String dataReferencia;
    private BigDecimal valorOriginal;
    private BigDecimal valorPago;
    private Long statusPagamento;
    private Long numeroConvenio;
    private Long totalRegistros;
    private String tokenPaginacao;

    public static List<DadosWebHookDTO> from(JsonNode jsonWebHook) {
        DadosWebHookDTO dados = null;
        if (jsonWebHook.has(TipoConvenioWebHook.BBPAY.getJsonTag())) {
            JsonNode dadosEvento = jsonWebHook.get(TipoConvenioWebHook.BBPAY.getJsonTag());
            if (dadosEvento != null) {
                dados = DadosWebHookDTO.builder().tipoConvenioWebHook(TipoConvenioWebHook.BBPAY).codigoConciliacaoSolicitacao(DadosWebHookDTO.getString((JsonNode)dadosEvento, (String)"codigoConciliacaoSolicitacao")).endToEndId(DadosWebHookDTO.getString((JsonNode)dadosEvento, (String)"e2eId")).dataReferencia(DadosWebHookDTO.getString((JsonNode)dadosEvento, (String)"timestampPagamento")).valorOriginal(DadosWebHookDTO.getBigDecimal((JsonNode)dadosEvento, (String)"valorOriginal")).valorPago(DadosWebHookDTO.getBigDecimal((JsonNode)dadosEvento, (String)"valorOriginal")).numeroConvenio(DadosWebHookDTO.getLong((JsonNode)dadosEvento, (String)"numeroConvenio")).statusPagamento(DadosWebHookDTO.getLong((JsonNode)dadosEvento, (String)"codigoEstadoPagamento")).build();
            }
            return Collections.singletonList(dados);
        }
        if (jsonWebHook.has(TipoConvenioWebHook.ARRECADACAO_INTEGRADA_PIX.getJsonTag()) && jsonWebHook.get(TipoConvenioWebHook.ARRECADACAO_INTEGRADA_PIX.getJsonTag()).isArray() && !jsonWebHook.get(TipoConvenioWebHook.ARRECADACAO_INTEGRADA_PIX.getJsonTag()).isEmpty()) {
            ArrayList<DadosWebHookDTO> arrecadacoes = new ArrayList<DadosWebHookDTO>();
            JsonNode pixNode = jsonWebHook.get(TipoConvenioWebHook.ARRECADACAO_INTEGRADA_PIX.getJsonTag());
            for (JsonNode item : pixNode) {
                dados = DadosWebHookDTO.builder().tipoConvenioWebHook(TipoConvenioWebHook.ARRECADACAO_INTEGRADA_PIX).txid(DadosWebHookDTO.getString((JsonNode)item, (String)"txid")).endToEndId(DadosWebHookDTO.getString((JsonNode)item, (String)"endToEndId")).dataReferencia(DadosWebHookDTO.getString((JsonNode)item, (String)"horario")).valorOriginal(DadosWebHookDTO.getBigDecimal((JsonNode)item.get("componentesValor").get("original"), (String)"valor")).valorPago(DadosWebHookDTO.getBigDecimal((JsonNode)item, (String)"valor")).build();
                arrecadacoes.add(dados);
            }
            return arrecadacoes;
        }
        if (jsonWebHook.isArray() && !jsonWebHook.isEmpty() && jsonWebHook.get(0).has(TipoConvenioWebHook.COBRANCA_BB.getJsonTag())) {
            ArrayList<DadosWebHookDTO> cobrancasWebHook = new ArrayList<DadosWebHookDTO>();
            for (JsonNode cobrancaNode : jsonWebHook) {
                dados = DadosWebHookDTO.builder().tipoConvenioWebHook(TipoConvenioWebHook.COBRANCA_BB).idCobranca(DadosWebHookDTO.getString((JsonNode)cobrancaNode, (String)"id")).valorOriginal(DadosWebHookDTO.getBigDecimal((JsonNode)cobrancaNode, (String)"valorOriginal")).valorPago(DadosWebHookDTO.getBigDecimal((JsonNode)cobrancaNode, (String)"valorPagoSacado")).numeroConvenio(DadosWebHookDTO.getLong((JsonNode)cobrancaNode, (String)"numeroConvenio")).statusPagamento(DadosWebHookDTO.getLong((JsonNode)cobrancaNode, (String)"codigoEstadoBaixaOperacional")).dataReferencia(DadosWebHookDTO.getString((JsonNode)cobrancaNode, (String)"dataLiquidacao")).build();
                cobrancasWebHook.add(dados);
            }
            return cobrancasWebHook;
        }
        return Collections.emptyList();
    }

    public static List<DadosWebHookDTO> fromResponsePagamentosBBPAY(PagamentoBBPayResponseDTO response) {
        return response.getListaPagamentos().stream().map(pagamento -> DadosWebHookDTO.fromDadosPagamentosBBPAY((ConsultaDadosPagamentoBBPayResponseDTO)pagamento, (Long)((Object)response.getTotalRegistros()), (String)response.getTokenPaginacao())).collect(Collectors.toList());
    }

    public static DadosWebHookDTO fromDadosPagamentosBBPAY(ConsultaDadosPagamentoBBPayResponseDTO pagamento, Long totalRegistros, String tokenPaginacao) {
        return DadosWebHookDTO.builder().numeroConvenio(null).tipoConvenioWebHook(TipoConvenioWebHook.BBPAY).statusPagamento(pagamento.getCodigoEstadoPagamento()).valorOriginal(pagamento.getValorOriginalPagamento()).valorPago(pagamento.getValorOriginalPagamento()).codigoConciliacaoSolicitacao(pagamento.getCodigoConciliacaoSolicitacao()).endToEndId(pagamento.getE2eId()).dataReferencia(pagamento.getTimestampPagamento()).totalRegistros(totalRegistros).tokenPaginacao(tokenPaginacao).build();
    }

    private static Long getLong(JsonNode jsonNode, String campo) {
        return jsonNode.hasNonNull(campo) ? Long.valueOf(jsonNode.get(campo).asLong()) : null;
    }

    private static String getString(JsonNode jsonNode, String campo) {
        return jsonNode.hasNonNull(campo) ? jsonNode.get(campo).asText() : null;
    }

    private static BigDecimal getBigDecimal(JsonNode jsonNode, String campo) {
        return jsonNode.hasNonNull(campo) ? new BigDecimal(jsonNode.get(campo).asText()) : null;
    }

    @Generated
    public static DadosWebHookDTOBuilder builder() {
        return new DadosWebHookDTOBuilder();
    }

    @Generated
    public TipoConvenioWebHook getTipoConvenioWebHook() {
        return this.tipoConvenioWebHook;
    }

    @Generated
    public String getEndToEndId() {
        return this.endToEndId;
    }

    @Generated
    public String getCodigoConciliacaoSolicitacao() {
        return this.codigoConciliacaoSolicitacao;
    }

    @Generated
    public String getTxid() {
        return this.txid;
    }

    @Generated
    public String getIdCobranca() {
        return this.idCobranca;
    }

    @Generated
    public String getDataReferencia() {
        return this.dataReferencia;
    }

    @Generated
    public BigDecimal getValorOriginal() {
        return this.valorOriginal;
    }

    @Generated
    public BigDecimal getValorPago() {
        return this.valorPago;
    }

    @Generated
    public Long getStatusPagamento() {
        return this.statusPagamento;
    }

    @Generated
    public Long getNumeroConvenio() {
        return this.numeroConvenio;
    }

    @Generated
    public Long getTotalRegistros() {
        return this.totalRegistros;
    }

    @Generated
    public String getTokenPaginacao() {
        return this.tokenPaginacao;
    }

    @Generated
    public DadosWebHookDTO(TipoConvenioWebHook tipoConvenioWebHook, String endToEndId, String codigoConciliacaoSolicitacao, String txid, String idCobranca, String dataReferencia, BigDecimal valorOriginal, BigDecimal valorPago, Long statusPagamento, Long numeroConvenio, Long totalRegistros, String tokenPaginacao) {
        this.tipoConvenioWebHook = tipoConvenioWebHook;
        this.endToEndId = endToEndId;
        this.codigoConciliacaoSolicitacao = codigoConciliacaoSolicitacao;
        this.txid = txid;
        this.idCobranca = idCobranca;
        this.dataReferencia = dataReferencia;
        this.valorOriginal = valorOriginal;
        this.valorPago = valorPago;
        this.statusPagamento = statusPagamento;
        this.numeroConvenio = numeroConvenio;
        this.totalRegistros = totalRegistros;
        this.tokenPaginacao = tokenPaginacao;
    }

    @Generated
    public DadosWebHookDTO() {
    }
}

