/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil;

import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.tributos.dto.integracaoboleto.ConsultaPixResponseDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.PagadorPixDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.QrCodePixBBErroDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class ConsultaPagCobrancaPixResponseBBDTO {
    private String endToEndId;
    private String txid;
    private BigDecimal valor;
    private String horario;
    private PagadorPixDTO pagador;
    private String codigoErroPagamento;
    private String textoErro;
    private String message;
    private List<QrCodePixBBErroDTO> erros;

    public ConsultaPixResponseDTO toConsultaPixResponseDTO() {
        ConsultaPixResponseDTO dto = new ConsultaPixResponseDTO();
        dto.setTxid(this.txid);
        dto.setChaveRecebedor(this.endToEndId);
        dto.setValorPagamento(this.valor);
        dto.setDataHoraPagamento(LocalDateTime.parse(this.horario, DateTimeFormatter.ISO_DATE_TIME));
        dto.setCpfCnpjPagador(this.pagador.getCpfCnpj());
        dto.setInfoLivrePagador(this.pagador.getNome());
        dto.setPago(SimNao.SIM.getSigla());
        dto.setPagamentoEncontrado(SimNao.SIM.getSigla());
        return dto;
    }

    @JsonIgnore
    public boolean hasErro() {
        return !CollectionUtils.isEmpty((Collection)this.erros) || !StringUtils.isEmpty((CharSequence)this.message);
    }

    @JsonIgnore
    public String getErrosConcatenado() {
        return Optional.ofNullable(this.message).orElseGet(() -> ((List)Optional.ofNullable(this.erros).orElse(new ArrayList())).stream().map(QrCodePixBBErroDTO::getMensagem).collect(Collectors.joining(",")));
    }

    @Generated
    public ConsultaPagCobrancaPixResponseBBDTO() {
    }

    @Generated
    public String getEndToEndId() {
        return this.endToEndId;
    }

    @Generated
    public String getTxid() {
        return this.txid;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public String getHorario() {
        return this.horario;
    }

    @Generated
    public PagadorPixDTO getPagador() {
        return this.pagador;
    }

    @Generated
    public String getCodigoErroPagamento() {
        return this.codigoErroPagamento;
    }

    @Generated
    public String getTextoErro() {
        return this.textoErro;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public List<QrCodePixBBErroDTO> getErros() {
        return this.erros;
    }

    @Generated
    public void setEndToEndId(String endToEndId) {
        this.endToEndId = endToEndId;
    }

    @Generated
    public void setTxid(String txid) {
        this.txid = txid;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setHorario(String horario) {
        this.horario = horario;
    }

    @Generated
    public void setPagador(PagadorPixDTO pagador) {
        this.pagador = pagador;
    }

    @Generated
    public void setCodigoErroPagamento(String codigoErroPagamento) {
        this.codigoErroPagamento = codigoErroPagamento;
    }

    @Generated
    public void setTextoErro(String textoErro) {
        this.textoErro = textoErro;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setErros(List<QrCodePixBBErroDTO> erros) {
        this.erros = erros;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsultaPagCobrancaPixResponseBBDTO)) {
            return false;
        }
        ConsultaPagCobrancaPixResponseBBDTO other = (ConsultaPagCobrancaPixResponseBBDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$endToEndId = this.getEndToEndId();
        String other$endToEndId = other.getEndToEndId();
        if (this$endToEndId == null ? other$endToEndId != null : !this$endToEndId.equals(other$endToEndId)) {
            return false;
        }
        String this$txid = this.getTxid();
        String other$txid = other.getTxid();
        if (this$txid == null ? other$txid != null : !this$txid.equals(other$txid)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor)) {
            return false;
        }
        String this$horario = this.getHorario();
        String other$horario = other.getHorario();
        if (this$horario == null ? other$horario != null : !this$horario.equals(other$horario)) {
            return false;
        }
        PagadorPixDTO this$pagador = this.getPagador();
        PagadorPixDTO other$pagador = other.getPagador();
        if (this$pagador == null ? other$pagador != null : !this$pagador.equals(other$pagador)) {
            return false;
        }
        String this$codigoErroPagamento = this.getCodigoErroPagamento();
        String other$codigoErroPagamento = other.getCodigoErroPagamento();
        if (this$codigoErroPagamento == null ? other$codigoErroPagamento != null : !this$codigoErroPagamento.equals(other$codigoErroPagamento)) {
            return false;
        }
        String this$textoErro = this.getTextoErro();
        String other$textoErro = other.getTextoErro();
        if (this$textoErro == null ? other$textoErro != null : !this$textoErro.equals(other$textoErro)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        List this$erros = this.getErros();
        List other$erros = other.getErros();
        return !(this$erros == null ? other$erros != null : !((Object)this$erros).equals(other$erros));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConsultaPagCobrancaPixResponseBBDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $endToEndId = this.getEndToEndId();
        result = result * 59 + ($endToEndId == null ? 43 : $endToEndId.hashCode());
        String $txid = this.getTxid();
        result = result * 59 + ($txid == null ? 43 : $txid.hashCode());
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        String $horario = this.getHorario();
        result = result * 59 + ($horario == null ? 43 : $horario.hashCode());
        PagadorPixDTO $pagador = this.getPagador();
        result = result * 59 + ($pagador == null ? 43 : $pagador.hashCode());
        String $codigoErroPagamento = this.getCodigoErroPagamento();
        result = result * 59 + ($codigoErroPagamento == null ? 43 : $codigoErroPagamento.hashCode());
        String $textoErro = this.getTextoErro();
        result = result * 59 + ($textoErro == null ? 43 : $textoErro.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        List $erros = this.getErros();
        result = result * 59 + ($erros == null ? 43 : ((Object)$erros).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ConsultaPagCobrancaPixResponseBBDTO(endToEndId=" + this.getEndToEndId() + ", txid=" + this.getTxid() + ", valor=" + String.valueOf(this.getValor()) + ", horario=" + this.getHorario() + ", pagador=" + String.valueOf(this.getPagador()) + ", codigoErroPagamento=" + this.getCodigoErroPagamento() + ", textoErro=" + this.getTextoErro() + ", message=" + this.getMessage() + ", erros=" + String.valueOf(this.getErros()) + ")";
    }
}

