/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaoboleto;

import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.util.MultiValueFilter;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class IntegracaoPixPagoLogFiltroDTO {
    private Long entidade;
    private Long idConvenio;
    private Long idContribuinte;
    private TipoCadastro tipoCadastro;
    private String nossoNumero;
    private String cadastroGeral;
    private String exercicioBloqueto;
    private String bloqueto;
    private String exercicioDebito;
    private String divida;
    private String subDivida;
    private String parcela;
    private String tributo;
    private LocalDateTime dataHoraProcessamentoInicial;
    private LocalDateTime dataHoraProcessamentoFinal;
    private LocalDate dataPagamentoInicial;
    private LocalDate dataPagamentoFinal;
    private LocalDate dataEmissaoInicial;
    private LocalDate dataEmissaoFinal;
    private LocalDate dataVencimentoInicial;
    private LocalDate dataVencimentoFinal;
    private static final String AND = " and ";
    private static final String PARAM_ENTIDADE = "entidade";
    private static final String ID_CONVENIO = "convenio";
    private static final String ID_CONTRIBUINTE = "contribuinte";
    private static final String TIPO_CADASTRO = "tipoCadastro";
    private static final String NOSSO_NUMERO = "nossoNumero";
    private static final String PARAM_TRIBUTO = "tributo";
    private static final String DATA_HORA_PROCESSAMENTO_INICIAL = "dataHoraProcessamentoInicial";
    private static final String DATA_HORA_PROCESSAMENTO_FINAL = "dataHoraProcessamentoFinal";
    private static final String DATA_PAGAMENTO_INICIAL = "dataPagamentoInicial";
    private static final String DATA_PAGAMENTO_FINAL = "dataPagamentoFinal";
    private static final String DATA_EMISSAO_INICIAL = "dataEmissaoInicial";
    private static final String DATA_EMISSAO_FINAL = "dataEmissaoFinal";
    private static final String DATA_VENCIMENTO_INICIAL = "dataVencimentoInicial";
    private static final String DATA_VENCIMENTO_FINAL = "dataVencimentoFinal";

    public String buildWhere() {
        StringBuilder where = new StringBuilder();
        this.appendEntidade(where);
        this.appendConvenio(where);
        this.appendContribuinte(where);
        this.appendTipoCadastro(where);
        this.appendCadastroGeral(where);
        this.appendNossoNumero(where);
        this.appendExercicioBloqueto(where);
        this.appendBloqueto(where);
        this.appendExercicioDebito(where);
        this.appendDivida(where);
        this.appendSubDivida(where);
        this.appendParcela(where);
        this.appendTributo(where);
        this.appendDataProcessamentoInicial(where);
        this.appendDataProcessamentoFinal(where);
        this.appendDataPagamentoInicial(where);
        this.appendDataPagamentoFinal(where);
        this.appendDataEmissaoInicial(where);
        this.appendDataEmissaoFinal(where);
        this.appendDataVencimentoInicial(where);
        this.appendDataVencimentoFinal(where);
        return where.toString();
    }

    public MapSqlParameterSource buildParams() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.addValueEntidade(params);
        this.addValueConvenio(params);
        this.addValueContribuinte(params);
        this.addValueTipoCadastro(params);
        this.addValueNossoNumero(params);
        this.addValueTributo(params);
        this.addValueDataHoraProcessamentoInicial(params);
        this.addValueDataHoraProcessamentoFinal(params);
        this.addValueDataPagamentoInicial(params);
        this.addValueDataPagamentoFinal(params);
        this.addValueDataEmissaoInicial(params);
        this.addValueDataEmissaoFinal(params);
        this.addValueDataVencimentoInicial(params);
        this.addValueDataVencimentoFinal(params);
        return params;
    }

    private String addAnd(String clause) {
        return AND + clause;
    }

    private void appendEntidade(StringBuilder where) {
        if (Objects.isNull(this.entidade)) {
            return;
        }
        where.append(this.addAnd(String.format("tribbloqueto.entidade = :%s", PARAM_ENTIDADE)));
    }

    private void appendConvenio(StringBuilder where) {
        if (Objects.isNull(this.idConvenio)) {
            return;
        }
        where.append(this.addAnd(String.format("tribconvenio.id = :%s", ID_CONVENIO)));
    }

    private void appendContribuinte(StringBuilder where) {
        if (Objects.isNull(this.idContribuinte)) {
            return;
        }
        where.append(this.addAnd(String.format("tribbloqueto.pessoa = :%s", ID_CONTRIBUINTE)));
    }

    private void appendTipoCadastro(StringBuilder where) {
        if (Objects.isNull(this.tipoCadastro)) {
            return;
        }
        where.append(this.addAnd(String.format("tribbloqueto.tipocadastro = :%s", TIPO_CADASTRO)));
    }

    private void appendNossoNumero(StringBuilder where) {
        if (StringUtils.isBlank((CharSequence)this.nossoNumero)) {
            return;
        }
        where.append(this.addAnd(String.format("tribbloqueto.nossonumero = :%s", NOSSO_NUMERO)));
    }

    private void appendCadastroGeral(StringBuilder where) {
        if (StringUtils.isBlank((CharSequence)this.cadastroGeral)) {
            return;
        }
        where.append(this.addAnd(MultiValueFilter.generateFilters((String)this.cadastroGeral, (String)"tribbloqueto.cadastrogeral")));
    }

    private void appendExercicioBloqueto(StringBuilder where) {
        if (StringUtils.isBlank((CharSequence)this.exercicioBloqueto)) {
            return;
        }
        where.append(this.addAnd(MultiValueFilter.generateFilters((String)this.exercicioBloqueto, (String)"tribbloqueto.exerciciobloqueto")));
    }

    private void appendBloqueto(StringBuilder where) {
        if (StringUtils.isBlank((CharSequence)this.bloqueto)) {
            return;
        }
        where.append(this.addAnd(MultiValueFilter.generateFilters((String)this.bloqueto, (String)"tribbloqueto.bloqueto")));
    }

    private void appendExercicioDebito(StringBuilder where) {
        if (StringUtils.isBlank((CharSequence)this.exercicioDebito)) {
            return;
        }
        where.append(this.addAnd(MultiValueFilter.generateFilters((String)this.exercicioDebito, (String)"tribdebitoparcelareceita.exercicio")));
    }

    private void appendDivida(StringBuilder where) {
        if (StringUtils.isBlank((CharSequence)this.divida)) {
            return;
        }
        where.append(this.addAnd(MultiValueFilter.generateFilters((String)this.divida, (String)"tribdebitoparcelareceita.guiarecolhimento")));
    }

    private void appendSubDivida(StringBuilder where) {
        if (StringUtils.isBlank((CharSequence)this.subDivida)) {
            return;
        }
        where.append(this.addAnd(MultiValueFilter.generateFilters((String)this.subDivida, (String)"tribdebitoparcelareceita.subdivida")));
    }

    private void appendParcela(StringBuilder where) {
        if (StringUtils.isBlank((CharSequence)this.parcela)) {
            return;
        }
        where.append(this.addAnd(MultiValueFilter.generateFilters((String)this.parcela, (String)"tribdebitoparcelareceita.parcela")));
    }

    private void appendTributo(StringBuilder where) {
        if (StringUtils.isBlank((CharSequence)this.tributo)) {
            return;
        }
        where.append(this.addAnd(String.format("tribdebitoparcelareceita.receita = :%s", PARAM_TRIBUTO)));
    }

    private void appendDataProcessamentoInicial(StringBuilder where) {
        if (Objects.isNull(this.dataHoraProcessamentoInicial)) {
            return;
        }
        where.append(this.addAnd(String.format("integracaopixpagolog.dataintegracao >= :%s", DATA_HORA_PROCESSAMENTO_INICIAL)));
    }

    private void appendDataProcessamentoFinal(StringBuilder where) {
        if (Objects.isNull(this.dataHoraProcessamentoFinal)) {
            return;
        }
        where.append(this.addAnd(String.format("integracaopixpagolog.dataintegracao <= :%s", DATA_HORA_PROCESSAMENTO_FINAL)));
    }

    private void appendDataPagamentoInicial(StringBuilder where) {
        if (Objects.isNull(this.dataPagamentoInicial)) {
            return;
        }
        where.append(this.addAnd(String.format("tribpagamento.datalancamento >= :%s", DATA_PAGAMENTO_INICIAL)));
    }

    private void appendDataPagamentoFinal(StringBuilder where) {
        if (Objects.isNull(this.dataPagamentoFinal)) {
            return;
        }
        where.append(this.addAnd(String.format("tribpagamento.datalancamento <= :%s", DATA_PAGAMENTO_FINAL)));
    }

    private void appendDataEmissaoInicial(StringBuilder where) {
        if (Objects.isNull(this.dataEmissaoInicial)) {
            return;
        }
        where.append(this.addAnd(String.format("tribbloqueto.dataemissao >= :%s", DATA_EMISSAO_INICIAL)));
    }

    private void appendDataEmissaoFinal(StringBuilder where) {
        if (Objects.isNull(this.dataEmissaoFinal)) {
            return;
        }
        where.append(this.addAnd(String.format("tribbloqueto.dataemissao <= :%s", DATA_EMISSAO_FINAL)));
    }

    private void appendDataVencimentoInicial(StringBuilder where) {
        if (Objects.isNull(this.dataVencimentoInicial)) {
            return;
        }
        where.append(this.addAnd(String.format("tribbloqueto.datavencimento >= :%s", DATA_VENCIMENTO_INICIAL)));
    }

    private void appendDataVencimentoFinal(StringBuilder where) {
        if (Objects.isNull(this.dataVencimentoFinal)) {
            return;
        }
        where.append(this.addAnd(String.format("tribbloqueto.datavencimento <= :%s", DATA_VENCIMENTO_FINAL)));
    }

    private void addValueEntidade(MapSqlParameterSource params) {
        if (Objects.isNull(this.entidade)) {
            return;
        }
        params.addValue(PARAM_ENTIDADE, (Object)this.entidade);
    }

    private void addValueConvenio(MapSqlParameterSource params) {
        if (Objects.isNull(this.idConvenio)) {
            return;
        }
        params.addValue(ID_CONVENIO, (Object)this.idConvenio);
    }

    private void addValueContribuinte(MapSqlParameterSource params) {
        if (Objects.isNull(this.idContribuinte)) {
            return;
        }
        params.addValue(ID_CONTRIBUINTE, (Object)this.idContribuinte);
    }

    private void addValueTipoCadastro(MapSqlParameterSource params) {
        if (Objects.isNull(this.tipoCadastro)) {
            return;
        }
        params.addValue(TIPO_CADASTRO, (Object)this.tipoCadastro.getValue());
    }

    private void addValueNossoNumero(MapSqlParameterSource params) {
        if (StringUtils.isBlank((CharSequence)this.nossoNumero)) {
            return;
        }
        params.addValue(NOSSO_NUMERO, (Object)this.nossoNumero);
    }

    private void addValueTributo(MapSqlParameterSource params) {
        if (StringUtils.isBlank((CharSequence)this.tributo)) {
            return;
        }
        params.addValue(PARAM_TRIBUTO, (Object)this.tributo);
    }

    private void addValueDataHoraProcessamentoInicial(MapSqlParameterSource params) {
        if (Objects.isNull(this.dataHoraProcessamentoInicial)) {
            return;
        }
        params.addValue(DATA_HORA_PROCESSAMENTO_INICIAL, (Object)this.dataHoraProcessamentoInicial);
    }

    private void addValueDataHoraProcessamentoFinal(MapSqlParameterSource params) {
        if (Objects.isNull(this.dataHoraProcessamentoFinal)) {
            return;
        }
        params.addValue(DATA_HORA_PROCESSAMENTO_FINAL, (Object)this.dataHoraProcessamentoFinal);
    }

    private void addValueDataPagamentoInicial(MapSqlParameterSource params) {
        if (Objects.isNull(this.dataPagamentoInicial)) {
            return;
        }
        params.addValue(DATA_PAGAMENTO_INICIAL, (Object)this.dataPagamentoInicial);
    }

    private void addValueDataPagamentoFinal(MapSqlParameterSource params) {
        if (Objects.isNull(this.dataPagamentoFinal)) {
            return;
        }
        params.addValue(DATA_PAGAMENTO_FINAL, (Object)this.dataPagamentoFinal);
    }

    private void addValueDataEmissaoInicial(MapSqlParameterSource params) {
        if (Objects.isNull(this.dataEmissaoInicial)) {
            return;
        }
        params.addValue(DATA_EMISSAO_INICIAL, (Object)this.dataEmissaoInicial);
    }

    private void addValueDataEmissaoFinal(MapSqlParameterSource params) {
        if (Objects.isNull(this.dataEmissaoFinal)) {
            return;
        }
        params.addValue(DATA_EMISSAO_FINAL, (Object)this.dataEmissaoFinal);
    }

    private void addValueDataVencimentoInicial(MapSqlParameterSource params) {
        if (Objects.isNull(this.dataVencimentoInicial)) {
            return;
        }
        params.addValue(DATA_VENCIMENTO_INICIAL, (Object)this.dataVencimentoInicial);
    }

    private void addValueDataVencimentoFinal(MapSqlParameterSource params) {
        if (Objects.isNull(this.dataVencimentoFinal)) {
            return;
        }
        params.addValue(DATA_VENCIMENTO_FINAL, (Object)this.dataVencimentoFinal);
    }

    @Generated
    public IntegracaoPixPagoLogFiltroDTO() {
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getIdConvenio() {
        return this.idConvenio;
    }

    @Generated
    public Long getIdContribuinte() {
        return this.idContribuinte;
    }

    @Generated
    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public String getNossoNumero() {
        return this.nossoNumero;
    }

    @Generated
    public String getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getExercicioBloqueto() {
        return this.exercicioBloqueto;
    }

    @Generated
    public String getBloqueto() {
        return this.bloqueto;
    }

    @Generated
    public String getExercicioDebito() {
        return this.exercicioDebito;
    }

    @Generated
    public String getDivida() {
        return this.divida;
    }

    @Generated
    public String getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public String getParcela() {
        return this.parcela;
    }

    @Generated
    public String getTributo() {
        return this.tributo;
    }

    @Generated
    public LocalDateTime getDataHoraProcessamentoInicial() {
        return this.dataHoraProcessamentoInicial;
    }

    @Generated
    public LocalDateTime getDataHoraProcessamentoFinal() {
        return this.dataHoraProcessamentoFinal;
    }

    @Generated
    public LocalDate getDataPagamentoInicial() {
        return this.dataPagamentoInicial;
    }

    @Generated
    public LocalDate getDataPagamentoFinal() {
        return this.dataPagamentoFinal;
    }

    @Generated
    public LocalDate getDataEmissaoInicial() {
        return this.dataEmissaoInicial;
    }

    @Generated
    public LocalDate getDataEmissaoFinal() {
        return this.dataEmissaoFinal;
    }

    @Generated
    public LocalDate getDataVencimentoInicial() {
        return this.dataVencimentoInicial;
    }

    @Generated
    public LocalDate getDataVencimentoFinal() {
        return this.dataVencimentoFinal;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setIdConvenio(Long idConvenio) {
        this.idConvenio = idConvenio;
    }

    @Generated
    public void setIdContribuinte(Long idContribuinte) {
        this.idContribuinte = idContribuinte;
    }

    @Generated
    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setNossoNumero(String nossoNumero) {
        this.nossoNumero = nossoNumero;
    }

    @Generated
    public void setCadastroGeral(String cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setExercicioBloqueto(String exercicioBloqueto) {
        this.exercicioBloqueto = exercicioBloqueto;
    }

    @Generated
    public void setBloqueto(String bloqueto) {
        this.bloqueto = bloqueto;
    }

    @Generated
    public void setExercicioDebito(String exercicioDebito) {
        this.exercicioDebito = exercicioDebito;
    }

    @Generated
    public void setDivida(String divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(String subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setParcela(String parcela) {
        this.parcela = parcela;
    }

    @Generated
    public void setTributo(String tributo) {
        this.tributo = tributo;
    }

    @Generated
    public void setDataHoraProcessamentoInicial(LocalDateTime dataHoraProcessamentoInicial) {
        this.dataHoraProcessamentoInicial = dataHoraProcessamentoInicial;
    }

    @Generated
    public void setDataHoraProcessamentoFinal(LocalDateTime dataHoraProcessamentoFinal) {
        this.dataHoraProcessamentoFinal = dataHoraProcessamentoFinal;
    }

    @Generated
    public void setDataPagamentoInicial(LocalDate dataPagamentoInicial) {
        this.dataPagamentoInicial = dataPagamentoInicial;
    }

    @Generated
    public void setDataPagamentoFinal(LocalDate dataPagamentoFinal) {
        this.dataPagamentoFinal = dataPagamentoFinal;
    }

    @Generated
    public void setDataEmissaoInicial(LocalDate dataEmissaoInicial) {
        this.dataEmissaoInicial = dataEmissaoInicial;
    }

    @Generated
    public void setDataEmissaoFinal(LocalDate dataEmissaoFinal) {
        this.dataEmissaoFinal = dataEmissaoFinal;
    }

    @Generated
    public void setDataVencimentoInicial(LocalDate dataVencimentoInicial) {
        this.dataVencimentoInicial = dataVencimentoInicial;
    }

    @Generated
    public void setDataVencimentoFinal(LocalDate dataVencimentoFinal) {
        this.dataVencimentoFinal = dataVencimentoFinal;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntegracaoPixPagoLogFiltroDTO)) {
            return false;
        }
        IntegracaoPixPagoLogFiltroDTO other = (IntegracaoPixPagoLogFiltroDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$idConvenio = this.getIdConvenio();
        Long other$idConvenio = other.getIdConvenio();
        if (this$idConvenio == null ? other$idConvenio != null : !((Object)this$idConvenio).equals(other$idConvenio)) {
            return false;
        }
        Long this$idContribuinte = this.getIdContribuinte();
        Long other$idContribuinte = other.getIdContribuinte();
        if (this$idContribuinte == null ? other$idContribuinte != null : !((Object)this$idContribuinte).equals(other$idContribuinte)) {
            return false;
        }
        TipoCadastro this$tipoCadastro = this.getTipoCadastro();
        TipoCadastro other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !this$tipoCadastro.equals(other$tipoCadastro)) {
            return false;
        }
        String this$nossoNumero = this.getNossoNumero();
        String other$nossoNumero = other.getNossoNumero();
        if (this$nossoNumero == null ? other$nossoNumero != null : !this$nossoNumero.equals(other$nossoNumero)) {
            return false;
        }
        String this$cadastroGeral = this.getCadastroGeral();
        String other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        String this$exercicioBloqueto = this.getExercicioBloqueto();
        String other$exercicioBloqueto = other.getExercicioBloqueto();
        if (this$exercicioBloqueto == null ? other$exercicioBloqueto != null : !this$exercicioBloqueto.equals(other$exercicioBloqueto)) {
            return false;
        }
        String this$bloqueto = this.getBloqueto();
        String other$bloqueto = other.getBloqueto();
        if (this$bloqueto == null ? other$bloqueto != null : !this$bloqueto.equals(other$bloqueto)) {
            return false;
        }
        String this$exercicioDebito = this.getExercicioDebito();
        String other$exercicioDebito = other.getExercicioDebito();
        if (this$exercicioDebito == null ? other$exercicioDebito != null : !this$exercicioDebito.equals(other$exercicioDebito)) {
            return false;
        }
        String this$divida = this.getDivida();
        String other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !this$divida.equals(other$divida)) {
            return false;
        }
        String this$subDivida = this.getSubDivida();
        String other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !this$subDivida.equals(other$subDivida)) {
            return false;
        }
        String this$parcela = this.getParcela();
        String other$parcela = other.getParcela();
        if (this$parcela == null ? other$parcela != null : !this$parcela.equals(other$parcela)) {
            return false;
        }
        String this$tributo = this.getTributo();
        String other$tributo = other.getTributo();
        if (this$tributo == null ? other$tributo != null : !this$tributo.equals(other$tributo)) {
            return false;
        }
        LocalDateTime this$dataHoraProcessamentoInicial = this.getDataHoraProcessamentoInicial();
        LocalDateTime other$dataHoraProcessamentoInicial = other.getDataHoraProcessamentoInicial();
        if (this$dataHoraProcessamentoInicial == null ? other$dataHoraProcessamentoInicial != null : !((Object)this$dataHoraProcessamentoInicial).equals(other$dataHoraProcessamentoInicial)) {
            return false;
        }
        LocalDateTime this$dataHoraProcessamentoFinal = this.getDataHoraProcessamentoFinal();
        LocalDateTime other$dataHoraProcessamentoFinal = other.getDataHoraProcessamentoFinal();
        if (this$dataHoraProcessamentoFinal == null ? other$dataHoraProcessamentoFinal != null : !((Object)this$dataHoraProcessamentoFinal).equals(other$dataHoraProcessamentoFinal)) {
            return false;
        }
        LocalDate this$dataPagamentoInicial = this.getDataPagamentoInicial();
        LocalDate other$dataPagamentoInicial = other.getDataPagamentoInicial();
        if (this$dataPagamentoInicial == null ? other$dataPagamentoInicial != null : !((Object)this$dataPagamentoInicial).equals(other$dataPagamentoInicial)) {
            return false;
        }
        LocalDate this$dataPagamentoFinal = this.getDataPagamentoFinal();
        LocalDate other$dataPagamentoFinal = other.getDataPagamentoFinal();
        if (this$dataPagamentoFinal == null ? other$dataPagamentoFinal != null : !((Object)this$dataPagamentoFinal).equals(other$dataPagamentoFinal)) {
            return false;
        }
        LocalDate this$dataEmissaoInicial = this.getDataEmissaoInicial();
        LocalDate other$dataEmissaoInicial = other.getDataEmissaoInicial();
        if (this$dataEmissaoInicial == null ? other$dataEmissaoInicial != null : !((Object)this$dataEmissaoInicial).equals(other$dataEmissaoInicial)) {
            return false;
        }
        LocalDate this$dataEmissaoFinal = this.getDataEmissaoFinal();
        LocalDate other$dataEmissaoFinal = other.getDataEmissaoFinal();
        if (this$dataEmissaoFinal == null ? other$dataEmissaoFinal != null : !((Object)this$dataEmissaoFinal).equals(other$dataEmissaoFinal)) {
            return false;
        }
        LocalDate this$dataVencimentoInicial = this.getDataVencimentoInicial();
        LocalDate other$dataVencimentoInicial = other.getDataVencimentoInicial();
        if (this$dataVencimentoInicial == null ? other$dataVencimentoInicial != null : !((Object)this$dataVencimentoInicial).equals(other$dataVencimentoInicial)) {
            return false;
        }
        LocalDate this$dataVencimentoFinal = this.getDataVencimentoFinal();
        LocalDate other$dataVencimentoFinal = other.getDataVencimentoFinal();
        return !(this$dataVencimentoFinal == null ? other$dataVencimentoFinal != null : !((Object)this$dataVencimentoFinal).equals(other$dataVencimentoFinal));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IntegracaoPixPagoLogFiltroDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $idConvenio = this.getIdConvenio();
        result = result * 59 + ($idConvenio == null ? 43 : ((Object)$idConvenio).hashCode());
        Long $idContribuinte = this.getIdContribuinte();
        result = result * 59 + ($idContribuinte == null ? 43 : ((Object)$idContribuinte).hashCode());
        TipoCadastro $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : $tipoCadastro.hashCode());
        String $nossoNumero = this.getNossoNumero();
        result = result * 59 + ($nossoNumero == null ? 43 : $nossoNumero.hashCode());
        String $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        String $exercicioBloqueto = this.getExercicioBloqueto();
        result = result * 59 + ($exercicioBloqueto == null ? 43 : $exercicioBloqueto.hashCode());
        String $bloqueto = this.getBloqueto();
        result = result * 59 + ($bloqueto == null ? 43 : $bloqueto.hashCode());
        String $exercicioDebito = this.getExercicioDebito();
        result = result * 59 + ($exercicioDebito == null ? 43 : $exercicioDebito.hashCode());
        String $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : $divida.hashCode());
        String $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : $subDivida.hashCode());
        String $parcela = this.getParcela();
        result = result * 59 + ($parcela == null ? 43 : $parcela.hashCode());
        String $tributo = this.getTributo();
        result = result * 59 + ($tributo == null ? 43 : $tributo.hashCode());
        LocalDateTime $dataHoraProcessamentoInicial = this.getDataHoraProcessamentoInicial();
        result = result * 59 + ($dataHoraProcessamentoInicial == null ? 43 : ((Object)$dataHoraProcessamentoInicial).hashCode());
        LocalDateTime $dataHoraProcessamentoFinal = this.getDataHoraProcessamentoFinal();
        result = result * 59 + ($dataHoraProcessamentoFinal == null ? 43 : ((Object)$dataHoraProcessamentoFinal).hashCode());
        LocalDate $dataPagamentoInicial = this.getDataPagamentoInicial();
        result = result * 59 + ($dataPagamentoInicial == null ? 43 : ((Object)$dataPagamentoInicial).hashCode());
        LocalDate $dataPagamentoFinal = this.getDataPagamentoFinal();
        result = result * 59 + ($dataPagamentoFinal == null ? 43 : ((Object)$dataPagamentoFinal).hashCode());
        LocalDate $dataEmissaoInicial = this.getDataEmissaoInicial();
        result = result * 59 + ($dataEmissaoInicial == null ? 43 : ((Object)$dataEmissaoInicial).hashCode());
        LocalDate $dataEmissaoFinal = this.getDataEmissaoFinal();
        result = result * 59 + ($dataEmissaoFinal == null ? 43 : ((Object)$dataEmissaoFinal).hashCode());
        LocalDate $dataVencimentoInicial = this.getDataVencimentoInicial();
        result = result * 59 + ($dataVencimentoInicial == null ? 43 : ((Object)$dataVencimentoInicial).hashCode());
        LocalDate $dataVencimentoFinal = this.getDataVencimentoFinal();
        result = result * 59 + ($dataVencimentoFinal == null ? 43 : ((Object)$dataVencimentoFinal).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "IntegracaoPixPagoLogFiltroDTO(entidade=" + this.getEntidade() + ", idConvenio=" + this.getIdConvenio() + ", idContribuinte=" + this.getIdContribuinte() + ", tipoCadastro=" + String.valueOf(this.getTipoCadastro()) + ", nossoNumero=" + this.getNossoNumero() + ", cadastroGeral=" + this.getCadastroGeral() + ", exercicioBloqueto=" + this.getExercicioBloqueto() + ", bloqueto=" + this.getBloqueto() + ", exercicioDebito=" + this.getExercicioDebito() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ", parcela=" + this.getParcela() + ", tributo=" + this.getTributo() + ", dataHoraProcessamentoInicial=" + String.valueOf(this.getDataHoraProcessamentoInicial()) + ", dataHoraProcessamentoFinal=" + String.valueOf(this.getDataHoraProcessamentoFinal()) + ", dataPagamentoInicial=" + String.valueOf(this.getDataPagamentoInicial()) + ", dataPagamentoFinal=" + String.valueOf(this.getDataPagamentoFinal()) + ", dataEmissaoInicial=" + String.valueOf(this.getDataEmissaoInicial()) + ", dataEmissaoFinal=" + String.valueOf(this.getDataEmissaoFinal()) + ", dataVencimentoInicial=" + String.valueOf(this.getDataVencimentoInicial()) + ", dataVencimentoFinal=" + String.valueOf(this.getDataVencimentoFinal()) + ")";
    }
}

