/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.documento.peticao;

import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.util.DateUtils;
import br.com.elotech.tributos.util.MultiValueFilter;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class GeracaoLotePeticaoDTO {
    private TipoCadastro tipoCadastro;
    private String cadastroGeral;
    private Pessoa pessoa;
    private String numeroCertidao;
    private String anoCertidao;
    private LocalDate dataInicial;
    private LocalDate dataFinal;
    private Boolean ajuizarDebitos = Boolean.TRUE;
    private Boolean agruparPorContribuinte = Boolean.FALSE;
    private String cabecalho;
    private String rodape;
    private String observacao;
    private static final String START_AND_FILTER = " AND (";

    public Boolean isValid() {
        return ObjectUtils.anyNotNull((Object[])new Object[]{this.tipoCadastro, this.cadastroGeral, this.pessoa, this.numeroCertidao, this.anoCertidao, this.dataInicial, this.dataFinal});
    }

    public Boolean isDateValid() {
        if (Objects.isNull(this.dataInicial) && Objects.nonNull(this.dataFinal) || Objects.nonNull(this.dataInicial) && Objects.isNull(this.dataFinal)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public String filtro() {
        StringBuilder filtros = new StringBuilder();
        filtros.append(this.buildFiltroDebitoCdaIdentificacao());
        return filtros.toString();
    }

    private String buildFiltroDebitoCdaIdentificacao() {
        StringBuilder dtoParams = new StringBuilder();
        Optional.ofNullable(this.tipoCadastro).ifPresent(tipoCadastroFiltro -> dtoParams.append(START_AND_FILTER).append(String.format("cert.TIPOCADASTRO=%d", tipoCadastroFiltro.getValue())).append(")"));
        if (StringUtils.isNotBlank((String)this.cadastroGeral)) {
            dtoParams.append(START_AND_FILTER).append(MultiValueFilter.generateFilters((String)this.cadastroGeral, (String)"cert.CADASTROGERAL")).append(")");
        }
        Optional.ofNullable(this.pessoa).ifPresent(pessoaFiltro -> dtoParams.append(START_AND_FILTER).append(String.format("cert.PESSOA=%d", pessoaFiltro.getId())).append(")"));
        if (StringUtils.isNotBlank((String)this.numeroCertidao)) {
            dtoParams.append(START_AND_FILTER).append(MultiValueFilter.generateFilters((String)this.numeroCertidao, (String)"cert.DOCUMENTO")).append(")");
        }
        if (StringUtils.isNotBlank((String)this.anoCertidao)) {
            dtoParams.append(START_AND_FILTER).append(MultiValueFilter.generateFilters((String)this.anoCertidao, (String)"cert.EXERCICIO")).append(")");
        }
        if (this.isDateValid().booleanValue() && Objects.nonNull(this.dataInicial)) {
            dtoParams.append(START_AND_FILTER).append(String.format("cert.dataemissao between '%s' and '%s' )", DateUtils.localDateToString((LocalDate)this.dataInicial), DateUtils.localDateToString((LocalDate)this.dataFinal)));
        }
        return dtoParams.toString();
    }

    @Generated
    public GeracaoLotePeticaoDTO() {
    }

    @Generated
    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public String getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    @Generated
    public String getNumeroCertidao() {
        return this.numeroCertidao;
    }

    @Generated
    public String getAnoCertidao() {
        return this.anoCertidao;
    }

    @Generated
    public LocalDate getDataInicial() {
        return this.dataInicial;
    }

    @Generated
    public LocalDate getDataFinal() {
        return this.dataFinal;
    }

    @Generated
    public Boolean getAjuizarDebitos() {
        return this.ajuizarDebitos;
    }

    @Generated
    public Boolean getAgruparPorContribuinte() {
        return this.agruparPorContribuinte;
    }

    @Generated
    public String getCabecalho() {
        return this.cabecalho;
    }

    @Generated
    public String getRodape() {
        return this.rodape;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(String cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setNumeroCertidao(String numeroCertidao) {
        this.numeroCertidao = numeroCertidao;
    }

    @Generated
    public void setAnoCertidao(String anoCertidao) {
        this.anoCertidao = anoCertidao;
    }

    @Generated
    public void setDataInicial(LocalDate dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Generated
    public void setDataFinal(LocalDate dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Generated
    public void setAjuizarDebitos(Boolean ajuizarDebitos) {
        this.ajuizarDebitos = ajuizarDebitos;
    }

    @Generated
    public void setAgruparPorContribuinte(Boolean agruparPorContribuinte) {
        this.agruparPorContribuinte = agruparPorContribuinte;
    }

    @Generated
    public void setCabecalho(String cabecalho) {
        this.cabecalho = cabecalho;
    }

    @Generated
    public void setRodape(String rodape) {
        this.rodape = rodape;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeracaoLotePeticaoDTO)) {
            return false;
        }
        GeracaoLotePeticaoDTO other = (GeracaoLotePeticaoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$ajuizarDebitos = this.getAjuizarDebitos();
        Boolean other$ajuizarDebitos = other.getAjuizarDebitos();
        if (this$ajuizarDebitos == null ? other$ajuizarDebitos != null : !((Object)this$ajuizarDebitos).equals(other$ajuizarDebitos)) {
            return false;
        }
        Boolean this$agruparPorContribuinte = this.getAgruparPorContribuinte();
        Boolean other$agruparPorContribuinte = other.getAgruparPorContribuinte();
        if (this$agruparPorContribuinte == null ? other$agruparPorContribuinte != null : !((Object)this$agruparPorContribuinte).equals(other$agruparPorContribuinte)) {
            return false;
        }
        TipoCadastro this$tipoCadastro = this.getTipoCadastro();
        TipoCadastro other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !this$tipoCadastro.equals(other$tipoCadastro)) {
            return false;
        }
        String this$cadastroGeral = this.getCadastroGeral();
        String other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        Pessoa this$pessoa = this.getPessoa();
        Pessoa other$pessoa = other.getPessoa();
        if (this$pessoa == null ? other$pessoa != null : !this$pessoa.equals(other$pessoa)) {
            return false;
        }
        String this$numeroCertidao = this.getNumeroCertidao();
        String other$numeroCertidao = other.getNumeroCertidao();
        if (this$numeroCertidao == null ? other$numeroCertidao != null : !this$numeroCertidao.equals(other$numeroCertidao)) {
            return false;
        }
        String this$anoCertidao = this.getAnoCertidao();
        String other$anoCertidao = other.getAnoCertidao();
        if (this$anoCertidao == null ? other$anoCertidao != null : !this$anoCertidao.equals(other$anoCertidao)) {
            return false;
        }
        LocalDate this$dataInicial = this.getDataInicial();
        LocalDate other$dataInicial = other.getDataInicial();
        if (this$dataInicial == null ? other$dataInicial != null : !((Object)this$dataInicial).equals(other$dataInicial)) {
            return false;
        }
        LocalDate this$dataFinal = this.getDataFinal();
        LocalDate other$dataFinal = other.getDataFinal();
        if (this$dataFinal == null ? other$dataFinal != null : !((Object)this$dataFinal).equals(other$dataFinal)) {
            return false;
        }
        String this$cabecalho = this.getCabecalho();
        String other$cabecalho = other.getCabecalho();
        if (this$cabecalho == null ? other$cabecalho != null : !this$cabecalho.equals(other$cabecalho)) {
            return false;
        }
        String this$rodape = this.getRodape();
        String other$rodape = other.getRodape();
        if (this$rodape == null ? other$rodape != null : !this$rodape.equals(other$rodape)) {
            return false;
        }
        String this$observacao = this.getObservacao();
        String other$observacao = other.getObservacao();
        return !(this$observacao == null ? other$observacao != null : !this$observacao.equals(other$observacao));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GeracaoLotePeticaoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $ajuizarDebitos = this.getAjuizarDebitos();
        result = result * 59 + ($ajuizarDebitos == null ? 43 : ((Object)$ajuizarDebitos).hashCode());
        Boolean $agruparPorContribuinte = this.getAgruparPorContribuinte();
        result = result * 59 + ($agruparPorContribuinte == null ? 43 : ((Object)$agruparPorContribuinte).hashCode());
        TipoCadastro $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : $tipoCadastro.hashCode());
        String $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        Pessoa $pessoa = this.getPessoa();
        result = result * 59 + ($pessoa == null ? 43 : $pessoa.hashCode());
        String $numeroCertidao = this.getNumeroCertidao();
        result = result * 59 + ($numeroCertidao == null ? 43 : $numeroCertidao.hashCode());
        String $anoCertidao = this.getAnoCertidao();
        result = result * 59 + ($anoCertidao == null ? 43 : $anoCertidao.hashCode());
        LocalDate $dataInicial = this.getDataInicial();
        result = result * 59 + ($dataInicial == null ? 43 : ((Object)$dataInicial).hashCode());
        LocalDate $dataFinal = this.getDataFinal();
        result = result * 59 + ($dataFinal == null ? 43 : ((Object)$dataFinal).hashCode());
        String $cabecalho = this.getCabecalho();
        result = result * 59 + ($cabecalho == null ? 43 : $cabecalho.hashCode());
        String $rodape = this.getRodape();
        result = result * 59 + ($rodape == null ? 43 : $rodape.hashCode());
        String $observacao = this.getObservacao();
        result = result * 59 + ($observacao == null ? 43 : $observacao.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GeracaoLotePeticaoDTO(tipoCadastro=" + String.valueOf(this.getTipoCadastro()) + ", cadastroGeral=" + this.getCadastroGeral() + ", pessoa=" + String.valueOf(this.getPessoa()) + ", numeroCertidao=" + this.getNumeroCertidao() + ", anoCertidao=" + this.getAnoCertidao() + ", dataInicial=" + String.valueOf(this.getDataInicial()) + ", dataFinal=" + String.valueOf(this.getDataFinal()) + ", ajuizarDebitos=" + this.getAjuizarDebitos() + ", agruparPorContribuinte=" + this.getAgruparPorContribuinte() + ", cabecalho=" + this.getCabecalho() + ", rodape=" + this.getRodape() + ", observacao=" + this.getObservacao() + ")";
    }
}

