/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.dividaativa;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.dto.dividaativa.LivroDTO;
import br.com.elotech.tributos.util.MultiValueFilter;
import java.time.LocalDate;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;

public class FiltroGeraLivroDTO {
    private Long entidade;
    private Long exercicio;
    private Long tipoCadastro;
    @Length(max=100, message="Permitido no m\u00e1ximo 100 caracteres para o cadastro geral.")
    private @Length(max=100, message="Permitido no m\u00e1ximo 100 caracteres para o cadastro geral.") String cadastroGeral;
    @Length(max=100, message="Permitido no m\u00e1ximo 100 caracteres para o ano d\u00e9bito.")
    private @Length(max=100, message="Permitido no m\u00e1ximo 100 caracteres para o ano d\u00e9bito.") String exercicioDebito;
    @Length(max=100, message="Permitido no m\u00e1ximo 100 caracteres para a d\u00edvida.")
    private @Length(max=100, message="Permitido no m\u00e1ximo 100 caracteres para a d\u00edvida.") String divida;
    private String subDivida;
    private LocalDate parcelasVencidasAte;
    private LocalDate dataVencimentoInicial;
    private LocalDate dataVencimentoFinal;
    private LocalDate dataInscricao = LocalDate.now();
    private String parcelados;
    private String reparcelados;
    private Boolean debitosEmDividaAtiva = Boolean.FALSE;
    private Boolean debitosContestados = Boolean.FALSE;
    private Boolean novoLivro = Boolean.TRUE;
    private LivroDTO livro;
    private Boolean englobaParcelas = Boolean.FALSE;
    private String usuario;
    private Long numeroFolhaManual;
    private Long numeroInscricaoManual;

    private String addAND(String clausula) {
        return " AND " + clausula;
    }

    private void validaFiltro(Boolean inscricaoPorParcela) {
        if (Objects.isNull(this.entidade) && Objects.isNull(this.exercicio) && Objects.isNull(this.tipoCadastro) && StringUtils.isBlank((CharSequence)this.cadastroGeral) && StringUtils.isBlank((CharSequence)this.exercicioDebito) && StringUtils.isBlank((CharSequence)this.divida) && StringUtils.isBlank((CharSequence)this.subDivida) && Objects.isNull(this.parcelasVencidasAte) && Objects.isNull(this.dataVencimentoInicial) && Objects.isNull(this.dataVencimentoFinal) && StringUtils.isBlank((CharSequence)this.parcelados) && StringUtils.isBlank((CharSequence)this.reparcelados) && Objects.isNull(this.livro)) {
            throw new EloValidationException("\u00c9 necess\u00e1rio informar ao menos um filtro.");
        }
        if (Objects.isNull(this.dataInscricao)) {
            throw new EloValidationException("A data de Inscri\u00e7\u00e3o \u00e9 obrigat\u00f3ria.");
        }
        if (Objects.isNull(this.dataVencimentoInicial)) {
            throw new EloValidationException("A data de vencimento inicial \u00e9 obrigat\u00f3ria.");
        }
        if (Objects.isNull(this.dataVencimentoFinal)) {
            throw new EloValidationException("A data de vencimento final \u00e9 obrigat\u00f3ria.");
        }
        if (!this.novoLivro.booleanValue() && Objects.isNull(this.livro)) {
            throw new EloValidationException("O livro \u00e9 obrigat\u00f3rio.");
        }
        if (!inscricaoPorParcela.booleanValue() && Objects.isNull(this.parcelasVencidasAte)) {
            throw new EloValidationException("\u00c9 necess\u00e1rio preencher o campo 'Parcelas Vencidas at\u00e9'.");
        }
        if (this.englobaParcelas.booleanValue()) {
            if (inscricaoPorParcela.booleanValue()) {
                throw new EloValidationException("N\u00e3o \u00e9 permitido Englobar as parcelas do d\u00e9bito com a Inscri\u00e7\u00e3o por Parcela.");
            }
            throw new EloValidationException("Englobar d\u00e9bito n\u00e3o foi implementado!");
        }
    }

    private String getDataVencimentoInicialAndFinal() {
        return String.format("EXISTS (SELECT 1\n FROM TRIBDEBITOPARCELA X\n WHERE TD.ENTIDADE = X.ENTIDADE\n AND TD.EXERCICIO = X.EXERCICIO\n AND TD.TIPOCADASTRO = X.TIPOCADASTRO\n AND TD.CADASTROGERAL = X.CADASTROGERAL\n AND TD.GUIARECOLHIMENTO = X.GUIARECOLHIMENTO\n AND TD.SUBDIVIDA = X.SUBDIVIDA\n AND X.DATAVENCIMENTO BETWEEN '%s' AND '%s')\n", this.dataVencimentoInicial, this.dataVencimentoFinal);
    }

    private String getParcelasVencidasSql() {
        return String.format("(SELECT MAX(X.DATAVENCIMENTO) FROM TRIBDEBITOPARCELA X\n WHERE TD.ENTIDADE = X.ENTIDADE\n AND TD.EXERCICIO = X.EXERCICIO\n AND TD.TIPOCADASTRO = X.TIPOCADASTRO\n AND TD.CADASTROGERAL = X.CADASTROGERAL\n AND TD.GUIARECOLHIMENTO = X.GUIARECOLHIMENTO\n AND TD.SUBDIVIDA = X.SUBDIVIDA) <= '%s'\n", this.parcelasVencidasAte);
    }

    private String getDebitosContestadosSql() {
        return "EXISTS (SELECT 1\n FROM TRIBCONTENCIOSODEBITO TCD\n WHERE TCD.SITUACAO = 'A'\n AND TCD.ENTIDADE = TD.ENTIDADE\n AND TCD.EXERCICIO = TD.EXERCICIO\n AND TCD.TIPOCADASTRO = TD.TIPOCADASTRO\n AND TCD.CADASTROGERAL = TD.CADASTROGERAL\n AND TCD.GUIARECOLHIMENTO = TD.GUIARECOLHIMENTO\n AND TCD.SUBDIVIDA = TD.SUBDIVIDA)\n";
    }

    public String getFiltro(Boolean inscricaoPorParcela) {
        this.validaFiltro(inscricaoPorParcela);
        StringBuilder filtro = new StringBuilder();
        filtro.append(this.addAND(String.format("tdp.situacaolegal=%d", this.debitosEmDividaAtiva != false ? 1 : 0)));
        if (this.debitosContestados.booleanValue()) {
            filtro.append(this.addAND(this.getDebitosContestadosSql()));
        }
        if (Objects.nonNull(this.tipoCadastro)) {
            filtro.append(this.addAND(String.format("td.tipocadastro=%d", this.tipoCadastro)));
        }
        if (StringUtils.isNotBlank((CharSequence)this.cadastroGeral)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.cadastroGeral, (String)"td.cadastrogeral")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.exercicioDebito)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.exercicioDebito, (String)"td.exercicio")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.divida)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.divida, (String)"td.guiarecolhimento")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.subDivida)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.subDivida, (String)"td.subdivida")));
        }
        if (inscricaoPorParcela.booleanValue()) {
            filtro.append(this.addAND(String.format("tdp.datavencimento between '%s' and '%s'", this.dataVencimentoInicial, this.dataVencimentoFinal)));
        } else {
            filtro.append(this.addAND(this.getDataVencimentoInicialAndFinal()));
            if (Objects.nonNull(this.parcelasVencidasAte)) {
                filtro.append(this.addAND(this.getParcelasVencidasSql()));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.parcelados) && this.parcelados.equals("S")) {
            filtro.append(this.addAND("coalesce(td.parcelado,'N')='S'"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.reparcelados) && this.reparcelados.equals("S")) {
            filtro.append(this.addAND("coalesce(td.reparcelado,'N')='S'"));
        }
        return filtro.toString();
    }

    @Generated
    public FiltroGeraLivroDTO() {
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public String getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getExercicioDebito() {
        return this.exercicioDebito;
    }

    @Generated
    public String getDivida() {
        return this.divida;
    }

    @Generated
    public String getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public LocalDate getParcelasVencidasAte() {
        return this.parcelasVencidasAte;
    }

    @Generated
    public LocalDate getDataVencimentoInicial() {
        return this.dataVencimentoInicial;
    }

    @Generated
    public LocalDate getDataVencimentoFinal() {
        return this.dataVencimentoFinal;
    }

    @Generated
    public LocalDate getDataInscricao() {
        return this.dataInscricao;
    }

    @Generated
    public String getParcelados() {
        return this.parcelados;
    }

    @Generated
    public String getReparcelados() {
        return this.reparcelados;
    }

    @Generated
    public Boolean getDebitosEmDividaAtiva() {
        return this.debitosEmDividaAtiva;
    }

    @Generated
    public Boolean getDebitosContestados() {
        return this.debitosContestados;
    }

    @Generated
    public Boolean getNovoLivro() {
        return this.novoLivro;
    }

    @Generated
    public LivroDTO getLivro() {
        return this.livro;
    }

    @Generated
    public Boolean getEnglobaParcelas() {
        return this.englobaParcelas;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public Long getNumeroFolhaManual() {
        return this.numeroFolhaManual;
    }

    @Generated
    public Long getNumeroInscricaoManual() {
        return this.numeroInscricaoManual;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(String cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setExercicioDebito(String exercicioDebito) {
        this.exercicioDebito = exercicioDebito;
    }

    @Generated
    public void setDivida(String divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(String subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setParcelasVencidasAte(LocalDate parcelasVencidasAte) {
        this.parcelasVencidasAte = parcelasVencidasAte;
    }

    @Generated
    public void setDataVencimentoInicial(LocalDate dataVencimentoInicial) {
        this.dataVencimentoInicial = dataVencimentoInicial;
    }

    @Generated
    public void setDataVencimentoFinal(LocalDate dataVencimentoFinal) {
        this.dataVencimentoFinal = dataVencimentoFinal;
    }

    @Generated
    public void setDataInscricao(LocalDate dataInscricao) {
        this.dataInscricao = dataInscricao;
    }

    @Generated
    public void setParcelados(String parcelados) {
        this.parcelados = parcelados;
    }

    @Generated
    public void setReparcelados(String reparcelados) {
        this.reparcelados = reparcelados;
    }

    @Generated
    public void setDebitosEmDividaAtiva(Boolean debitosEmDividaAtiva) {
        this.debitosEmDividaAtiva = debitosEmDividaAtiva;
    }

    @Generated
    public void setDebitosContestados(Boolean debitosContestados) {
        this.debitosContestados = debitosContestados;
    }

    @Generated
    public void setNovoLivro(Boolean novoLivro) {
        this.novoLivro = novoLivro;
    }

    @Generated
    public void setLivro(LivroDTO livro) {
        this.livro = livro;
    }

    @Generated
    public void setEnglobaParcelas(Boolean englobaParcelas) {
        this.englobaParcelas = englobaParcelas;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setNumeroFolhaManual(Long numeroFolhaManual) {
        this.numeroFolhaManual = numeroFolhaManual;
    }

    @Generated
    public void setNumeroInscricaoManual(Long numeroInscricaoManual) {
        this.numeroInscricaoManual = numeroInscricaoManual;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiltroGeraLivroDTO)) {
            return false;
        }
        FiltroGeraLivroDTO other = (FiltroGeraLivroDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Boolean this$debitosEmDividaAtiva = this.getDebitosEmDividaAtiva();
        Boolean other$debitosEmDividaAtiva = other.getDebitosEmDividaAtiva();
        if (this$debitosEmDividaAtiva == null ? other$debitosEmDividaAtiva != null : !((Object)this$debitosEmDividaAtiva).equals(other$debitosEmDividaAtiva)) {
            return false;
        }
        Boolean this$debitosContestados = this.getDebitosContestados();
        Boolean other$debitosContestados = other.getDebitosContestados();
        if (this$debitosContestados == null ? other$debitosContestados != null : !((Object)this$debitosContestados).equals(other$debitosContestados)) {
            return false;
        }
        Boolean this$novoLivro = this.getNovoLivro();
        Boolean other$novoLivro = other.getNovoLivro();
        if (this$novoLivro == null ? other$novoLivro != null : !((Object)this$novoLivro).equals(other$novoLivro)) {
            return false;
        }
        Boolean this$englobaParcelas = this.getEnglobaParcelas();
        Boolean other$englobaParcelas = other.getEnglobaParcelas();
        if (this$englobaParcelas == null ? other$englobaParcelas != null : !((Object)this$englobaParcelas).equals(other$englobaParcelas)) {
            return false;
        }
        Long this$numeroFolhaManual = this.getNumeroFolhaManual();
        Long other$numeroFolhaManual = other.getNumeroFolhaManual();
        if (this$numeroFolhaManual == null ? other$numeroFolhaManual != null : !((Object)this$numeroFolhaManual).equals(other$numeroFolhaManual)) {
            return false;
        }
        Long this$numeroInscricaoManual = this.getNumeroInscricaoManual();
        Long other$numeroInscricaoManual = other.getNumeroInscricaoManual();
        if (this$numeroInscricaoManual == null ? other$numeroInscricaoManual != null : !((Object)this$numeroInscricaoManual).equals(other$numeroInscricaoManual)) {
            return false;
        }
        String this$cadastroGeral = this.getCadastroGeral();
        String other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        String this$exercicioDebito = this.getExercicioDebito();
        String other$exercicioDebito = other.getExercicioDebito();
        if (this$exercicioDebito == null ? other$exercicioDebito != null : !this$exercicioDebito.equals(other$exercicioDebito)) {
            return false;
        }
        String this$divida = this.getDivida();
        String other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !this$divida.equals(other$divida)) {
            return false;
        }
        String this$subDivida = this.getSubDivida();
        String other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !this$subDivida.equals(other$subDivida)) {
            return false;
        }
        LocalDate this$parcelasVencidasAte = this.getParcelasVencidasAte();
        LocalDate other$parcelasVencidasAte = other.getParcelasVencidasAte();
        if (this$parcelasVencidasAte == null ? other$parcelasVencidasAte != null : !((Object)this$parcelasVencidasAte).equals(other$parcelasVencidasAte)) {
            return false;
        }
        LocalDate this$dataVencimentoInicial = this.getDataVencimentoInicial();
        LocalDate other$dataVencimentoInicial = other.getDataVencimentoInicial();
        if (this$dataVencimentoInicial == null ? other$dataVencimentoInicial != null : !((Object)this$dataVencimentoInicial).equals(other$dataVencimentoInicial)) {
            return false;
        }
        LocalDate this$dataVencimentoFinal = this.getDataVencimentoFinal();
        LocalDate other$dataVencimentoFinal = other.getDataVencimentoFinal();
        if (this$dataVencimentoFinal == null ? other$dataVencimentoFinal != null : !((Object)this$dataVencimentoFinal).equals(other$dataVencimentoFinal)) {
            return false;
        }
        LocalDate this$dataInscricao = this.getDataInscricao();
        LocalDate other$dataInscricao = other.getDataInscricao();
        if (this$dataInscricao == null ? other$dataInscricao != null : !((Object)this$dataInscricao).equals(other$dataInscricao)) {
            return false;
        }
        String this$parcelados = this.getParcelados();
        String other$parcelados = other.getParcelados();
        if (this$parcelados == null ? other$parcelados != null : !this$parcelados.equals(other$parcelados)) {
            return false;
        }
        String this$reparcelados = this.getReparcelados();
        String other$reparcelados = other.getReparcelados();
        if (this$reparcelados == null ? other$reparcelados != null : !this$reparcelados.equals(other$reparcelados)) {
            return false;
        }
        LivroDTO this$livro = this.getLivro();
        LivroDTO other$livro = other.getLivro();
        if (this$livro == null ? other$livro != null : !this$livro.equals(other$livro)) {
            return false;
        }
        String this$usuario = this.getUsuario();
        String other$usuario = other.getUsuario();
        return !(this$usuario == null ? other$usuario != null : !this$usuario.equals(other$usuario));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FiltroGeraLivroDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Boolean $debitosEmDividaAtiva = this.getDebitosEmDividaAtiva();
        result = result * 59 + ($debitosEmDividaAtiva == null ? 43 : ((Object)$debitosEmDividaAtiva).hashCode());
        Boolean $debitosContestados = this.getDebitosContestados();
        result = result * 59 + ($debitosContestados == null ? 43 : ((Object)$debitosContestados).hashCode());
        Boolean $novoLivro = this.getNovoLivro();
        result = result * 59 + ($novoLivro == null ? 43 : ((Object)$novoLivro).hashCode());
        Boolean $englobaParcelas = this.getEnglobaParcelas();
        result = result * 59 + ($englobaParcelas == null ? 43 : ((Object)$englobaParcelas).hashCode());
        Long $numeroFolhaManual = this.getNumeroFolhaManual();
        result = result * 59 + ($numeroFolhaManual == null ? 43 : ((Object)$numeroFolhaManual).hashCode());
        Long $numeroInscricaoManual = this.getNumeroInscricaoManual();
        result = result * 59 + ($numeroInscricaoManual == null ? 43 : ((Object)$numeroInscricaoManual).hashCode());
        String $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        String $exercicioDebito = this.getExercicioDebito();
        result = result * 59 + ($exercicioDebito == null ? 43 : $exercicioDebito.hashCode());
        String $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : $divida.hashCode());
        String $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : $subDivida.hashCode());
        LocalDate $parcelasVencidasAte = this.getParcelasVencidasAte();
        result = result * 59 + ($parcelasVencidasAte == null ? 43 : ((Object)$parcelasVencidasAte).hashCode());
        LocalDate $dataVencimentoInicial = this.getDataVencimentoInicial();
        result = result * 59 + ($dataVencimentoInicial == null ? 43 : ((Object)$dataVencimentoInicial).hashCode());
        LocalDate $dataVencimentoFinal = this.getDataVencimentoFinal();
        result = result * 59 + ($dataVencimentoFinal == null ? 43 : ((Object)$dataVencimentoFinal).hashCode());
        LocalDate $dataInscricao = this.getDataInscricao();
        result = result * 59 + ($dataInscricao == null ? 43 : ((Object)$dataInscricao).hashCode());
        String $parcelados = this.getParcelados();
        result = result * 59 + ($parcelados == null ? 43 : $parcelados.hashCode());
        String $reparcelados = this.getReparcelados();
        result = result * 59 + ($reparcelados == null ? 43 : $reparcelados.hashCode());
        LivroDTO $livro = this.getLivro();
        result = result * 59 + ($livro == null ? 43 : $livro.hashCode());
        String $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : $usuario.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FiltroGeraLivroDTO(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", exercicioDebito=" + this.getExercicioDebito() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ", parcelasVencidasAte=" + String.valueOf(this.getParcelasVencidasAte()) + ", dataVencimentoInicial=" + String.valueOf(this.getDataVencimentoInicial()) + ", dataVencimentoFinal=" + String.valueOf(this.getDataVencimentoFinal()) + ", dataInscricao=" + String.valueOf(this.getDataInscricao()) + ", parcelados=" + this.getParcelados() + ", reparcelados=" + this.getReparcelados() + ", debitosEmDividaAtiva=" + this.getDebitosEmDividaAtiva() + ", debitosContestados=" + this.getDebitosContestados() + ", novoLivro=" + this.getNovoLivro() + ", livro=" + String.valueOf(this.getLivro()) + ", englobaParcelas=" + this.getEnglobaParcelas() + ", usuario=" + this.getUsuario() + ", numeroFolhaManual=" + this.getNumeroFolhaManual() + ", numeroInscricaoManual=" + this.getNumeroInscricaoManual() + ")";
    }
}

