/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.contencioso;

import br.com.elotech.tributos.domain.Ato;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Contencioso;
import br.com.elotech.tributos.domain.ContenciosoAto;
import br.com.elotech.tributos.domain.ContenciosoDebito;
import br.com.elotech.tributos.domain.ContenciosoSituacaoEnum;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.domain.SituacaoContenciosoDebito;
import br.com.elotech.tributos.domain.TipoContencioso;
import br.com.elotech.tributos.domain.contencioso.Parecerista;
import br.com.elotech.tributos.dto.contencioso.ContenciosoProcessoProtocoloDTO;
import br.com.elotech.tributos.dto.contencioso.TipoContenciosoResponseDTO;
import br.com.elotech.tributos.enums.SituacaoRecalculoContencioso;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class ContenciosoDebitosResponseDTO
implements Serializable {
    private Long id;
    private Long contenciosoId;
    private Long entidade;
    private Long exercicio;
    private LocalDate data;
    private Long instancia;
    @JsonIgnoreProperties(value={"cmcResponsavel"})
    private CadastroGeral cadastroGeral;
    private String situacao;
    private String situacaoDetalhada;
    private Parecerista parecerista;
    private String observacao;
    private String observacaoSegundaInstancia;
    private String situacaoContencioso;
    private ContenciosoProcessoProtocoloDTO processo;
    private ContenciosoProcessoProtocoloDTO processoSegundaInstancia;
    private List<ContenciosoDebito> debitos;
    private TipoContenciosoResponseDTO tipoContencioso;
    private String usuario;
    private SituacaoContenciosoDebito parecer;
    private LocalDate dataCancelamento;
    private MotivoDeducao motivoDeducao;
    private List<Ato> contenciosoAtos = new ArrayList();
    private String processoSei;
    private String processoSeiSegundaInstancia;
    private List<FormaPagamento> formasDePagamento = new ArrayList();

    public static ContenciosoDebitosResponseDTO of(Contencioso contencioso) {
        ContenciosoDebitosResponseDTO dto = new ContenciosoDebitosResponseDTO();
        dto.setId(contencioso.getId());
        dto.setData(contencioso.getData());
        dto.setUsuario(contencioso.getUsuario());
        dto.setContenciosoId(contencioso.getContenciosoId());
        dto.setEntidade(contencioso.getEntidade());
        dto.setExercicio(contencioso.getExercicio());
        dto.setInstancia(contencioso.getInstancia());
        dto.setObservacao(contencioso.getObservacao());
        dto.setObservacaoSegundaInstancia(contencioso.getObservacaoSegundaInstancia());
        dto.setTipoContencioso(TipoContenciosoResponseDTO.of((TipoContencioso)contencioso.getTipoContencioso()));
        dto.setParecerista(contencioso.getParecerista());
        dto.setCadastroGeral(contencioso.getCadastroGeral());
        Optional.ofNullable(contencioso.getSituacao()).ifPresent(situacao -> dto.setSituacao(situacao.getValue()));
        Optional.ofNullable(contencioso.getSituacaoContencioso()).ifPresent(situacaoContencioso -> dto.setSituacaoContencioso(situacaoContencioso.getValue()));
        dto.setDebitos(contencioso.getDebitos());
        dto.setProcessoSeiSegundaInstancia(contencioso.getProcessoSeiSegundaInstancia());
        dto.setContenciosoAtos(contencioso.getContenciosoAtos().stream().map(ContenciosoAto::getFundamentoLegal).collect(Collectors.toList()));
        dto.setProcesso(ContenciosoDebitosResponseDTO.builderProcesso((Contencioso)contencioso));
        dto.setProcessoSegundaInstancia(ContenciosoDebitosResponseDTO.builderProcessoSegundaInstancia((Contencioso)contencioso));
        dto.setProcessoSei(contencioso.getProcessoSei());
        dto.setProcessoSeiSegundaInstancia(contencioso.getProcessoSeiSegundaInstancia());
        dto.setObservacaoSegundaInstancia(contencioso.getObservacaoSegundaInstancia());
        dto.getDebitos().forEach(contenciosoDebito -> {
            LocalDate dataOriginal = contenciosoDebito.getDebito().getParcelas().stream().map(DebitoParcela::getDataVencimento).min(LocalDate::compareTo).get();
            contenciosoDebito.setDataPrimeiroVencimentoOriginal(dataOriginal);
            String cadastroGeral = contenciosoDebito.getDebito().getCadastroGeral().getCadastroGeral().toString();
            LocalDate data = LocalDate.of(LocalDate.now().getYear(), LocalDate.now().getMonth(), (int)ContenciosoDebitosResponseDTO.getDiaNovoVencimento((String)cadastroGeral));
            contenciosoDebito.setDataPrimeiroVencimento(data);
            if (SituacaoRecalculoContencioso.DEBITO_GERADO.equals((Object)contenciosoDebito.getSituacaoRecalculo()) && dto.getFormasDePagamento().isEmpty()) {
                contenciosoDebito.getDebitoRecalculo().getDivida().getFormasPagamentoRecalculo(contenciosoDebito.getDebitoRecalculo().getPrimeiraParcela().getDataVencimento()).forEach(formaPagamento -> dto.getFormasDePagamento().add(formaPagamento));
                Optional.ofNullable(contenciosoDebito.getDebitoRecalculo()).flatMap(debito -> debito.getParcelas().stream().min(Comparator.comparing(DebitoParcela::getDataVencimento))).ifPresent(parcela -> contenciosoDebito.setDataPrimeiroVencimento(parcela.getDataVencimento()));
            }
        });
        return dto;
    }

    private static Integer getDiaNovoVencimento(String cadastroGeral) {
        Integer digito = 0;
        Integer tamanho = cadastroGeral.length();
        if (tamanho >= 3) {
            digito = Integer.valueOf(cadastroGeral.substring(tamanho - 3, tamanho - 2));
        }
        if (digito == 0) {
            return 20;
        }
        return digito + 10;
    }

    public static ContenciosoProcessoProtocoloDTO builderProcesso(Contencioso contencioso) {
        return Optional.ofNullable(contencioso).filter(c -> c.getIdProcesso() != null && c.getExercicioProcesso() != null).map(c -> {
            ContenciosoProcessoProtocoloDTO dto = new ContenciosoProcessoProtocoloDTO();
            dto.setAno(c.getExercicioProcesso());
            dto.setNumero(c.getIdProcesso());
            return dto;
        }).orElse(null);
    }

    public static ContenciosoProcessoProtocoloDTO builderProcessoSegundaInstancia(Contencioso contencioso) {
        return Optional.ofNullable(contencioso).filter(c -> c.getIdProcessoSegundaInstancia() != null && c.getExercicioProcessoSegundaInstancia() != null).map(c -> {
            ContenciosoProcessoProtocoloDTO dto = new ContenciosoProcessoProtocoloDTO();
            dto.setAno(c.getExercicioProcessoSegundaInstancia());
            dto.setNumero(c.getIdProcessoSegundaInstancia());
            return dto;
        }).orElse(null);
    }

    public String getSituacaoDetalhada() {
        return Optional.ofNullable(ContenciosoSituacaoEnum.fromValue((String)this.situacao)).map(ContenciosoSituacaoEnum::getDescricao).orElse("");
    }

    public static ContenciosoDebitosResponseDTO atualizarParaSegundaInstancia(ContenciosoDebitosResponseDTO dto) {
        dto.setSituacao(ContenciosoSituacaoEnum.EM_SEGUNDA_INSTANCIA.getValue());
        dto.setInstancia(Long.valueOf(2L));
        return dto;
    }

    @Generated
    public ContenciosoDebitosResponseDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getContenciosoId() {
        return this.contenciosoId;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public LocalDate getData() {
        return this.data;
    }

    @Generated
    public Long getInstancia() {
        return this.instancia;
    }

    @Generated
    public CadastroGeral getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getSituacao() {
        return this.situacao;
    }

    @Generated
    public Parecerista getParecerista() {
        return this.parecerista;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public String getObservacaoSegundaInstancia() {
        return this.observacaoSegundaInstancia;
    }

    @Generated
    public String getSituacaoContencioso() {
        return this.situacaoContencioso;
    }

    @Generated
    public ContenciosoProcessoProtocoloDTO getProcesso() {
        return this.processo;
    }

    @Generated
    public ContenciosoProcessoProtocoloDTO getProcessoSegundaInstancia() {
        return this.processoSegundaInstancia;
    }

    @Generated
    public List<ContenciosoDebito> getDebitos() {
        return this.debitos;
    }

    @Generated
    public TipoContenciosoResponseDTO getTipoContencioso() {
        return this.tipoContencioso;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public SituacaoContenciosoDebito getParecer() {
        return this.parecer;
    }

    @Generated
    public LocalDate getDataCancelamento() {
        return this.dataCancelamento;
    }

    @Generated
    public MotivoDeducao getMotivoDeducao() {
        return this.motivoDeducao;
    }

    @Generated
    public List<Ato> getContenciosoAtos() {
        return this.contenciosoAtos;
    }

    @Generated
    public String getProcessoSei() {
        return this.processoSei;
    }

    @Generated
    public String getProcessoSeiSegundaInstancia() {
        return this.processoSeiSegundaInstancia;
    }

    @Generated
    public List<FormaPagamento> getFormasDePagamento() {
        return this.formasDePagamento;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setContenciosoId(Long contenciosoId) {
        this.contenciosoId = contenciosoId;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setData(LocalDate data) {
        this.data = data;
    }

    @Generated
    public void setInstancia(Long instancia) {
        this.instancia = instancia;
    }

    @JsonIgnoreProperties(value={"cmcResponsavel"})
    @Generated
    public void setCadastroGeral(CadastroGeral cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setSituacaoDetalhada(String situacaoDetalhada) {
        this.situacaoDetalhada = situacaoDetalhada;
    }

    @Generated
    public void setParecerista(Parecerista parecerista) {
        this.parecerista = parecerista;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setObservacaoSegundaInstancia(String observacaoSegundaInstancia) {
        this.observacaoSegundaInstancia = observacaoSegundaInstancia;
    }

    @Generated
    public void setSituacaoContencioso(String situacaoContencioso) {
        this.situacaoContencioso = situacaoContencioso;
    }

    @Generated
    public void setProcesso(ContenciosoProcessoProtocoloDTO processo) {
        this.processo = processo;
    }

    @Generated
    public void setProcessoSegundaInstancia(ContenciosoProcessoProtocoloDTO processoSegundaInstancia) {
        this.processoSegundaInstancia = processoSegundaInstancia;
    }

    @Generated
    public void setDebitos(List<ContenciosoDebito> debitos) {
        this.debitos = debitos;
    }

    @Generated
    public void setTipoContencioso(TipoContenciosoResponseDTO tipoContencioso) {
        this.tipoContencioso = tipoContencioso;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setParecer(SituacaoContenciosoDebito parecer) {
        this.parecer = parecer;
    }

    @Generated
    public void setDataCancelamento(LocalDate dataCancelamento) {
        this.dataCancelamento = dataCancelamento;
    }

    @Generated
    public void setMotivoDeducao(MotivoDeducao motivoDeducao) {
        this.motivoDeducao = motivoDeducao;
    }

    @Generated
    public void setContenciosoAtos(List<Ato> contenciosoAtos) {
        this.contenciosoAtos = contenciosoAtos;
    }

    @Generated
    public void setProcessoSei(String processoSei) {
        this.processoSei = processoSei;
    }

    @Generated
    public void setProcessoSeiSegundaInstancia(String processoSeiSegundaInstancia) {
        this.processoSeiSegundaInstancia = processoSeiSegundaInstancia;
    }

    @Generated
    public void setFormasDePagamento(List<FormaPagamento> formasDePagamento) {
        this.formasDePagamento = formasDePagamento;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContenciosoDebitosResponseDTO)) {
            return false;
        }
        ContenciosoDebitosResponseDTO other = (ContenciosoDebitosResponseDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$contenciosoId = this.getContenciosoId();
        Long other$contenciosoId = other.getContenciosoId();
        if (this$contenciosoId == null ? other$contenciosoId != null : !((Object)this$contenciosoId).equals(other$contenciosoId)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$instancia = this.getInstancia();
        Long other$instancia = other.getInstancia();
        if (this$instancia == null ? other$instancia != null : !((Object)this$instancia).equals(other$instancia)) {
            return false;
        }
        LocalDate this$data = this.getData();
        LocalDate other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        CadastroGeral this$cadastroGeral = this.getCadastroGeral();
        CadastroGeral other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        String this$situacao = this.getSituacao();
        String other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !this$situacao.equals(other$situacao)) {
            return false;
        }
        String this$situacaoDetalhada = this.getSituacaoDetalhada();
        String other$situacaoDetalhada = other.getSituacaoDetalhada();
        if (this$situacaoDetalhada == null ? other$situacaoDetalhada != null : !this$situacaoDetalhada.equals(other$situacaoDetalhada)) {
            return false;
        }
        Parecerista this$parecerista = this.getParecerista();
        Parecerista other$parecerista = other.getParecerista();
        if (this$parecerista == null ? other$parecerista != null : !this$parecerista.equals(other$parecerista)) {
            return false;
        }
        String this$observacao = this.getObservacao();
        String other$observacao = other.getObservacao();
        if (this$observacao == null ? other$observacao != null : !this$observacao.equals(other$observacao)) {
            return false;
        }
        String this$observacaoSegundaInstancia = this.getObservacaoSegundaInstancia();
        String other$observacaoSegundaInstancia = other.getObservacaoSegundaInstancia();
        if (this$observacaoSegundaInstancia == null ? other$observacaoSegundaInstancia != null : !this$observacaoSegundaInstancia.equals(other$observacaoSegundaInstancia)) {
            return false;
        }
        String this$situacaoContencioso = this.getSituacaoContencioso();
        String other$situacaoContencioso = other.getSituacaoContencioso();
        if (this$situacaoContencioso == null ? other$situacaoContencioso != null : !this$situacaoContencioso.equals(other$situacaoContencioso)) {
            return false;
        }
        ContenciosoProcessoProtocoloDTO this$processo = this.getProcesso();
        ContenciosoProcessoProtocoloDTO other$processo = other.getProcesso();
        if (this$processo == null ? other$processo != null : !this$processo.equals(other$processo)) {
            return false;
        }
        ContenciosoProcessoProtocoloDTO this$processoSegundaInstancia = this.getProcessoSegundaInstancia();
        ContenciosoProcessoProtocoloDTO other$processoSegundaInstancia = other.getProcessoSegundaInstancia();
        if (this$processoSegundaInstancia == null ? other$processoSegundaInstancia != null : !this$processoSegundaInstancia.equals(other$processoSegundaInstancia)) {
            return false;
        }
        List this$debitos = this.getDebitos();
        List other$debitos = other.getDebitos();
        if (this$debitos == null ? other$debitos != null : !((Object)this$debitos).equals(other$debitos)) {
            return false;
        }
        TipoContenciosoResponseDTO this$tipoContencioso = this.getTipoContencioso();
        TipoContenciosoResponseDTO other$tipoContencioso = other.getTipoContencioso();
        if (this$tipoContencioso == null ? other$tipoContencioso != null : !this$tipoContencioso.equals(other$tipoContencioso)) {
            return false;
        }
        String this$usuario = this.getUsuario();
        String other$usuario = other.getUsuario();
        if (this$usuario == null ? other$usuario != null : !this$usuario.equals(other$usuario)) {
            return false;
        }
        SituacaoContenciosoDebito this$parecer = this.getParecer();
        SituacaoContenciosoDebito other$parecer = other.getParecer();
        if (this$parecer == null ? other$parecer != null : !this$parecer.equals(other$parecer)) {
            return false;
        }
        LocalDate this$dataCancelamento = this.getDataCancelamento();
        LocalDate other$dataCancelamento = other.getDataCancelamento();
        if (this$dataCancelamento == null ? other$dataCancelamento != null : !((Object)this$dataCancelamento).equals(other$dataCancelamento)) {
            return false;
        }
        MotivoDeducao this$motivoDeducao = this.getMotivoDeducao();
        MotivoDeducao other$motivoDeducao = other.getMotivoDeducao();
        if (this$motivoDeducao == null ? other$motivoDeducao != null : !this$motivoDeducao.equals(other$motivoDeducao)) {
            return false;
        }
        List this$contenciosoAtos = this.getContenciosoAtos();
        List other$contenciosoAtos = other.getContenciosoAtos();
        if (this$contenciosoAtos == null ? other$contenciosoAtos != null : !((Object)this$contenciosoAtos).equals(other$contenciosoAtos)) {
            return false;
        }
        String this$processoSei = this.getProcessoSei();
        String other$processoSei = other.getProcessoSei();
        if (this$processoSei == null ? other$processoSei != null : !this$processoSei.equals(other$processoSei)) {
            return false;
        }
        String this$processoSeiSegundaInstancia = this.getProcessoSeiSegundaInstancia();
        String other$processoSeiSegundaInstancia = other.getProcessoSeiSegundaInstancia();
        if (this$processoSeiSegundaInstancia == null ? other$processoSeiSegundaInstancia != null : !this$processoSeiSegundaInstancia.equals(other$processoSeiSegundaInstancia)) {
            return false;
        }
        List this$formasDePagamento = this.getFormasDePagamento();
        List other$formasDePagamento = other.getFormasDePagamento();
        return !(this$formasDePagamento == null ? other$formasDePagamento != null : !((Object)this$formasDePagamento).equals(other$formasDePagamento));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ContenciosoDebitosResponseDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $contenciosoId = this.getContenciosoId();
        result = result * 59 + ($contenciosoId == null ? 43 : ((Object)$contenciosoId).hashCode());
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $instancia = this.getInstancia();
        result = result * 59 + ($instancia == null ? 43 : ((Object)$instancia).hashCode());
        LocalDate $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        CadastroGeral $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        String $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : $situacao.hashCode());
        String $situacaoDetalhada = this.getSituacaoDetalhada();
        result = result * 59 + ($situacaoDetalhada == null ? 43 : $situacaoDetalhada.hashCode());
        Parecerista $parecerista = this.getParecerista();
        result = result * 59 + ($parecerista == null ? 43 : $parecerista.hashCode());
        String $observacao = this.getObservacao();
        result = result * 59 + ($observacao == null ? 43 : $observacao.hashCode());
        String $observacaoSegundaInstancia = this.getObservacaoSegundaInstancia();
        result = result * 59 + ($observacaoSegundaInstancia == null ? 43 : $observacaoSegundaInstancia.hashCode());
        String $situacaoContencioso = this.getSituacaoContencioso();
        result = result * 59 + ($situacaoContencioso == null ? 43 : $situacaoContencioso.hashCode());
        ContenciosoProcessoProtocoloDTO $processo = this.getProcesso();
        result = result * 59 + ($processo == null ? 43 : $processo.hashCode());
        ContenciosoProcessoProtocoloDTO $processoSegundaInstancia = this.getProcessoSegundaInstancia();
        result = result * 59 + ($processoSegundaInstancia == null ? 43 : $processoSegundaInstancia.hashCode());
        List $debitos = this.getDebitos();
        result = result * 59 + ($debitos == null ? 43 : ((Object)$debitos).hashCode());
        TipoContenciosoResponseDTO $tipoContencioso = this.getTipoContencioso();
        result = result * 59 + ($tipoContencioso == null ? 43 : $tipoContencioso.hashCode());
        String $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : $usuario.hashCode());
        SituacaoContenciosoDebito $parecer = this.getParecer();
        result = result * 59 + ($parecer == null ? 43 : $parecer.hashCode());
        LocalDate $dataCancelamento = this.getDataCancelamento();
        result = result * 59 + ($dataCancelamento == null ? 43 : ((Object)$dataCancelamento).hashCode());
        MotivoDeducao $motivoDeducao = this.getMotivoDeducao();
        result = result * 59 + ($motivoDeducao == null ? 43 : $motivoDeducao.hashCode());
        List $contenciosoAtos = this.getContenciosoAtos();
        result = result * 59 + ($contenciosoAtos == null ? 43 : ((Object)$contenciosoAtos).hashCode());
        String $processoSei = this.getProcessoSei();
        result = result * 59 + ($processoSei == null ? 43 : $processoSei.hashCode());
        String $processoSeiSegundaInstancia = this.getProcessoSeiSegundaInstancia();
        result = result * 59 + ($processoSeiSegundaInstancia == null ? 43 : $processoSeiSegundaInstancia.hashCode());
        List $formasDePagamento = this.getFormasDePagamento();
        result = result * 59 + ($formasDePagamento == null ? 43 : ((Object)$formasDePagamento).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ContenciosoDebitosResponseDTO(id=" + this.getId() + ", contenciosoId=" + this.getContenciosoId() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", data=" + String.valueOf(this.getData()) + ", instancia=" + this.getInstancia() + ", cadastroGeral=" + String.valueOf(this.getCadastroGeral()) + ", situacao=" + this.getSituacao() + ", situacaoDetalhada=" + this.getSituacaoDetalhada() + ", parecerista=" + String.valueOf(this.getParecerista()) + ", observacao=" + this.getObservacao() + ", observacaoSegundaInstancia=" + this.getObservacaoSegundaInstancia() + ", situacaoContencioso=" + this.getSituacaoContencioso() + ", processo=" + String.valueOf(this.getProcesso()) + ", processoSegundaInstancia=" + String.valueOf(this.getProcessoSegundaInstancia()) + ", debitos=" + String.valueOf(this.getDebitos()) + ", tipoContencioso=" + String.valueOf(this.getTipoContencioso()) + ", usuario=" + this.getUsuario() + ", parecer=" + String.valueOf(this.getParecer()) + ", dataCancelamento=" + String.valueOf(this.getDataCancelamento()) + ", motivoDeducao=" + String.valueOf(this.getMotivoDeducao()) + ", contenciosoAtos=" + String.valueOf(this.getContenciosoAtos()) + ", processoSei=" + this.getProcessoSei() + ", processoSeiSegundaInstancia=" + this.getProcessoSeiSegundaInstancia() + ", formasDePagamento=" + String.valueOf(this.getFormasDePagamento()) + ")";
    }
}

