/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.contencioso;

import br.com.elotech.tributos.domain.ContenciosoDebito;
import br.com.elotech.tributos.domain.ContenciosoDebitoParcela;
import br.com.elotech.tributos.domain.DebitoTributo;
import br.com.elotech.tributos.dto.CancelamentoDebitoTributoDTO;
import br.com.elotech.tributos.dto.contencioso.ContenciosoDebitosIdDTO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public class ContenciosoDebitoDTO
implements Serializable {
    private ContenciosoDebitosIdDTO id;
    private String situacao;
    private String situacaoDetalhada;
    private Long idDebito;
    private List<ContenciosoDebitoParcela> parcelas = new ArrayList();
    private List<CancelamentoDebitoTributoDTO> parcelasParcial = new ArrayList();
    private List<DebitoTributo> tributos;
    private BigDecimal valorTotal;
    private Boolean selecionado = Boolean.FALSE;
    private String dividaDetalhada;

    public static ContenciosoDebitoDTO of(ContenciosoDebito contenciosoDebito) {
        ContenciosoDebitoDTO dto = new ContenciosoDebitoDTO();
        dto.setId(ContenciosoDebitosIdDTO.of((ContenciosoDebito)contenciosoDebito));
        dto.setSituacao(contenciosoDebito.getSituacao().getValue());
        dto.setSituacaoDetalhada(contenciosoDebito.getSituacaoDetalhada());
        dto.setIdDebito(contenciosoDebito.getIdDebito());
        dto.setParcelas(contenciosoDebito.getParcelas());
        dto.setTributos(contenciosoDebito.getTributos());
        dto.setValorTotal(contenciosoDebito.getValorTotal());
        dto.setDividaDetalhada(contenciosoDebito.getDividaDetalhada());
        return dto;
    }

    public boolean equalsToEntity(ContenciosoDebito entity) {
        return Objects.equals(this.getId().getIdContencioso(), entity.getId().getIdContencioso()) && Objects.equals(this.getId().getEntidade(), entity.getId().getEntidade()) && Objects.equals(this.getId().getExercicio(), entity.getId().getExercicio()) && Objects.equals(this.getId().getTipoCadastro(), entity.getId().getTipoCadastro().getValue()) && Objects.equals(this.getId().getCadastroGeral(), entity.getId().getCadastroGeral()) && Objects.equals(this.getId().getDivida(), entity.getId().getDivida()) && Objects.equals(this.getId().getSubDivida(), entity.getId().getSubDivida());
    }

    public Boolean isSelected() {
        return this.selecionado;
    }

    @Generated
    public ContenciosoDebitoDTO() {
    }

    @Generated
    public ContenciosoDebitosIdDTO getId() {
        return this.id;
    }

    @Generated
    public String getSituacao() {
        return this.situacao;
    }

    @Generated
    public String getSituacaoDetalhada() {
        return this.situacaoDetalhada;
    }

    @Generated
    public Long getIdDebito() {
        return this.idDebito;
    }

    @Generated
    public List<ContenciosoDebitoParcela> getParcelas() {
        return this.parcelas;
    }

    @Generated
    public List<CancelamentoDebitoTributoDTO> getParcelasParcial() {
        return this.parcelasParcial;
    }

    @Generated
    public List<DebitoTributo> getTributos() {
        return this.tributos;
    }

    @Generated
    public BigDecimal getValorTotal() {
        return this.valorTotal;
    }

    @Generated
    public Boolean getSelecionado() {
        return this.selecionado;
    }

    @Generated
    public String getDividaDetalhada() {
        return this.dividaDetalhada;
    }

    @Generated
    public void setId(ContenciosoDebitosIdDTO id) {
        this.id = id;
    }

    @Generated
    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setSituacaoDetalhada(String situacaoDetalhada) {
        this.situacaoDetalhada = situacaoDetalhada;
    }

    @Generated
    public void setIdDebito(Long idDebito) {
        this.idDebito = idDebito;
    }

    @Generated
    public void setParcelas(List<ContenciosoDebitoParcela> parcelas) {
        this.parcelas = parcelas;
    }

    @Generated
    public void setParcelasParcial(List<CancelamentoDebitoTributoDTO> parcelasParcial) {
        this.parcelasParcial = parcelasParcial;
    }

    @Generated
    public void setTributos(List<DebitoTributo> tributos) {
        this.tributos = tributos;
    }

    @Generated
    public void setValorTotal(BigDecimal valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Generated
    public void setSelecionado(Boolean selecionado) {
        this.selecionado = selecionado;
    }

    @Generated
    public void setDividaDetalhada(String dividaDetalhada) {
        this.dividaDetalhada = dividaDetalhada;
    }

    @Generated
    public String toString() {
        return "ContenciosoDebitoDTO(id=" + String.valueOf(this.getId()) + ", situacao=" + this.getSituacao() + ", situacaoDetalhada=" + this.getSituacaoDetalhada() + ", idDebito=" + this.getIdDebito() + ", parcelas=" + String.valueOf(this.getParcelas()) + ", parcelasParcial=" + String.valueOf(this.getParcelasParcial()) + ", tributos=" + String.valueOf(this.getTributos()) + ", valorTotal=" + String.valueOf(this.getValorTotal()) + ", selecionado=" + this.getSelecionado() + ", dividaDetalhada=" + this.getDividaDetalhada() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContenciosoDebitoDTO)) {
            return false;
        }
        ContenciosoDebitoDTO other = (ContenciosoDebitoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ContenciosoDebitosIdDTO this$id = this.getId();
        ContenciosoDebitosIdDTO other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ContenciosoDebitoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ContenciosoDebitosIdDTO $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

