/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.comunicadocadastro;

import br.com.elotech.tributos.dto.SituacaoNotificacaoComunicadoCadastro;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public record ComunicadoEfetividadeNotificacoesFilterDTO(LocalDate dataInicial, LocalDate dataFinal, SituacaoNotificacaoComunicadoCadastro situacaoNotificacao, Long tipoCadastro, Long cadastroGeral, String cnpjCpf) {
    private final LocalDate dataInicial;
    private final LocalDate dataFinal;
    private final SituacaoNotificacaoComunicadoCadastro situacaoNotificacao;
    private final Long tipoCadastro;
    private final Long cadastroGeral;
    private final String cnpjCpf;

    public ComunicadoEfetividadeNotificacoesFilterDTO(LocalDate dataInicial, LocalDate dataFinal, SituacaoNotificacaoComunicadoCadastro situacaoNotificacao, Long tipoCadastro, Long cadastroGeral, String cnpjCpf) {
        this.dataInicial = dataInicial;
        this.dataFinal = dataFinal;
        this.situacaoNotificacao = situacaoNotificacao;
        this.tipoCadastro = tipoCadastro;
        this.cadastroGeral = cadastroGeral;
        this.cnpjCpf = cnpjCpf;
    }

    public String buildFilter() {
        StringBuilder filter = new StringBuilder("where tc.datageracao between :dataInicial and :dataFinal ");
        if (Objects.nonNull(this.situacaoNotificacao)) {
            if (SituacaoNotificacaoComunicadoCadastro.NAO_ENVIADA.equals((Object)this.situacaoNotificacao)) {
                filter.append(" AND (tcc.situacaonotificacao = '").append(this.situacaoNotificacao.name()).append("' OR tcc.situacaonotificacao IS NULL)");
            } else {
                filter.append(" AND tcc.situacaonotificacao = '").append(this.situacaoNotificacao.name()).append("'");
            }
        }
        if (Objects.nonNull(this.tipoCadastro)) {
            filter.append(" AND tcc.tipoCadastro = ").append(this.tipoCadastro);
        }
        if (Objects.nonNull(this.cadastroGeral)) {
            filter.append(" AND tcc.cadastroGeral = ").append(this.cadastroGeral);
        }
        if (Objects.nonNull(this.cnpjCpf) && !this.cnpjCpf.isEmpty()) {
            filter.append(" AND p.cnpj_cpf = '").append(this.cnpjCpf).append("'");
        }
        return filter.toString();
    }

    public Object getDescricaoFiltro() {
        DateTimeFormatter DATE_FORMATTER = DateUtils.DATE_TIME_FORMATTER_FORMATO_BRASILEIRO_BARRAS;
        StringBuilder descricaoFiltro = new StringBuilder();
        descricaoFiltro.append("Data Inicial: ").append(this.dataInicial.format(DATE_FORMATTER)).append(" | ");
        descricaoFiltro.append("Data Final: ").append(this.dataFinal.format(DATE_FORMATTER)).append(" | ");
        if (Objects.nonNull(this.situacaoNotificacao)) {
            descricaoFiltro.append("Situa\u00e7\u00e3o Notifica\u00e7\u00e3o: ").append(this.situacaoNotificacao.name()).append(" | ");
        }
        if (Objects.nonNull(this.tipoCadastro)) {
            descricaoFiltro.append("Tipo Cadastro: ").append(this.tipoCadastro).append(" | ");
        }
        if (Objects.nonNull(this.cadastroGeral)) {
            descricaoFiltro.append("Cadastro Geral: ").append(this.cadastroGeral).append(" | ");
        }
        if (Objects.nonNull(this.cnpjCpf) && !this.cnpjCpf.isEmpty()) {
            descricaoFiltro.append("CNPJ/CPF: ").append(this.cnpjCpf).append(" | ");
        }
        return descricaoFiltro.toString();
    }

    public LocalDate dataInicial() {
        return this.dataInicial;
    }

    public LocalDate dataFinal() {
        return this.dataFinal;
    }

    public SituacaoNotificacaoComunicadoCadastro situacaoNotificacao() {
        return this.situacaoNotificacao;
    }

    public Long tipoCadastro() {
        return this.tipoCadastro;
    }

    public Long cadastroGeral() {
        return this.cadastroGeral;
    }

    public String cnpjCpf() {
        return this.cnpjCpf;
    }
}

