/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.cancelamento;

import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.domain.PagamentoNegociado;
import br.com.elotech.tributos.domain.TipoDeducao;
import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebito;
import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebitoPk;
import br.com.elotech.tributos.dto.CancelamentoDebitoParcelaDTO;
import br.com.elotech.tributos.dto.DadosPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.DebitoPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.contencioso.ContenciosoDebitosExararDTO;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import lombok.Generated;

public class CancelamentoParcelasFormDTO {
    @NotNull
    private Long entidade;
    @NotNull
    private Long exercicio;
    private String usuario;
    @NotNull
    private LocalDate dataCancelamento;
    private String motivo;
    @NotNull
    private MotivoDeducao motivoCancelamento;
    @NotNull
    private Long situacaoLegal;
    private Long idProcesso;
    private Long exercicioProcesso;
    @NotNull
    private TipoDeducao tipoDeducao;
    private Boolean porTributo = false;
    @Size(min=1)
    private @Size(min=1) List<CancelamentoDebitoParcelaDTO> parcelas = new ArrayList();
    private Boolean enviarEmail;
    private String mensagemEmail;
    private String processoSei;

    public CancelamentoDebito toEntity() {
        CancelamentoDebito cancelamentoDebito = new CancelamentoDebito();
        CancelamentoDebitoPk pk = new CancelamentoDebitoPk();
        pk.setEntidade(this.getEntidade());
        pk.setExercicio(this.getExercicio());
        cancelamentoDebito.setId(pk);
        cancelamentoDebito.setDataInclusao(LocalDate.now());
        cancelamentoDebito.setDataCancelamento(this.getDataCancelamento());
        cancelamentoDebito.setSituacaoLegal(this.getSituacaoLegal());
        cancelamentoDebito.setIdProcesso(this.getIdProcesso());
        cancelamentoDebito.setExercicioProcesso(this.getExercicioProcesso());
        cancelamentoDebito.setMotivoCancelamento(this.getMotivoCancelamento());
        cancelamentoDebito.setMotivo(this.getMotivo());
        cancelamentoDebito.setUsuario(this.getUsuario());
        cancelamentoDebito.setTipoDeducao(this.getTipoDeducao());
        cancelamentoDebito.setPorTributo(this.getPorTributo());
        cancelamentoDebito.setProcessoSei(this.getProcessoSei());
        return cancelamentoDebito;
    }

    public static CancelamentoParcelasFormDTO from(ContenciosoDebitosExararDTO dto) {
        CancelamentoParcelasFormDTO cancelamentoDebitosDTO = new CancelamentoParcelasFormDTO();
        cancelamentoDebitosDTO.setDataCancelamento(dto.getDataCancelamento());
        cancelamentoDebitosDTO.setEntidade(dto.getEntidade());
        cancelamentoDebitosDTO.setExercicio(dto.getExercicio());
        cancelamentoDebitosDTO.setUsuario(dto.getUsuario());
        cancelamentoDebitosDTO.setMotivoCancelamento(dto.getMotivoDeducao());
        Optional.ofNullable(dto.getMotivoDeducao()).map(MotivoDeducao::getTipoDeducao).ifPresent(arg_0 -> cancelamentoDebitosDTO.setTipoDeducao(arg_0));
        cancelamentoDebitosDTO.setMotivo(String.format("Exarado no Contencioso %d / %d", dto.getContenciosoId(), dto.getExercicio()));
        return cancelamentoDebitosDTO;
    }

    public static CancelamentoParcelasFormDTO from(DadosPagamentoNegociadoDTO dadosPagamento, DebitoPagamentoNegociadoDTO debitoParcial, PagamentoNegociado pagamentoNegociado) {
        CancelamentoParcelasFormDTO cancelamentoParcelasFormDTO = new CancelamentoParcelasFormDTO();
        cancelamentoParcelasFormDTO.setEntidade(debitoParcial.getEntidade());
        cancelamentoParcelasFormDTO.setExercicio(debitoParcial.getExercicio());
        cancelamentoParcelasFormDTO.setUsuario(dadosPagamento.getUsuario());
        cancelamentoParcelasFormDTO.setDataCancelamento(LocalDate.now());
        cancelamentoParcelasFormDTO.setMotivoCancelamento(dadosPagamento.getMotivo());
        cancelamentoParcelasFormDTO.setSituacaoLegal(Long.valueOf(debitoParcial.getSituacaoLegal().longValue()));
        Optional.ofNullable(dadosPagamento.getMotivo()).ifPresent(motivo -> cancelamentoParcelasFormDTO.setTipoDeducao(motivo.getTipoDeducao()));
        CancelamentoDebitoParcelaDTO debitoParcelaDTO = new CancelamentoDebitoParcelaDTO();
        debitoParcelaDTO.setIdDebito(debitoParcial.getIdDebito());
        debitoParcelaDTO.setEntidade(debitoParcial.getEntidade());
        debitoParcelaDTO.setExercicio(debitoParcial.getExercicio());
        debitoParcelaDTO.setTipoCadastro(debitoParcial.getTipoCadastro());
        debitoParcelaDTO.setCadastroGeral(debitoParcial.getCadastroGeral());
        debitoParcelaDTO.setDivida(debitoParcial.getDivida());
        debitoParcelaDTO.setSubDivida(debitoParcial.getSubDivida());
        debitoParcelaDTO.setParcela(debitoParcial.getParcela());
        debitoParcelaDTO.setObservacao(String.format("Parcela parcialmente baixada durante o pagamento negociado n\u00famero %s", pagamentoNegociado.getId()));
        cancelamentoParcelasFormDTO.getParcelas().add(debitoParcelaDTO);
        return cancelamentoParcelasFormDTO;
    }

    @Generated
    public CancelamentoParcelasFormDTO() {
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public LocalDate getDataCancelamento() {
        return this.dataCancelamento;
    }

    @Generated
    public String getMotivo() {
        return this.motivo;
    }

    @Generated
    public MotivoDeducao getMotivoCancelamento() {
        return this.motivoCancelamento;
    }

    @Generated
    public Long getSituacaoLegal() {
        return this.situacaoLegal;
    }

    @Generated
    public Long getIdProcesso() {
        return this.idProcesso;
    }

    @Generated
    public Long getExercicioProcesso() {
        return this.exercicioProcesso;
    }

    @Generated
    public TipoDeducao getTipoDeducao() {
        return this.tipoDeducao;
    }

    @Generated
    public Boolean getPorTributo() {
        return this.porTributo;
    }

    @Generated
    public List<CancelamentoDebitoParcelaDTO> getParcelas() {
        return this.parcelas;
    }

    @Generated
    public Boolean getEnviarEmail() {
        return this.enviarEmail;
    }

    @Generated
    public String getMensagemEmail() {
        return this.mensagemEmail;
    }

    @Generated
    public String getProcessoSei() {
        return this.processoSei;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setDataCancelamento(LocalDate dataCancelamento) {
        this.dataCancelamento = dataCancelamento;
    }

    @Generated
    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    @Generated
    public void setMotivoCancelamento(MotivoDeducao motivoCancelamento) {
        this.motivoCancelamento = motivoCancelamento;
    }

    @Generated
    public void setSituacaoLegal(Long situacaoLegal) {
        this.situacaoLegal = situacaoLegal;
    }

    @Generated
    public void setIdProcesso(Long idProcesso) {
        this.idProcesso = idProcesso;
    }

    @Generated
    public void setExercicioProcesso(Long exercicioProcesso) {
        this.exercicioProcesso = exercicioProcesso;
    }

    @Generated
    public void setTipoDeducao(TipoDeducao tipoDeducao) {
        this.tipoDeducao = tipoDeducao;
    }

    @Generated
    public void setPorTributo(Boolean porTributo) {
        this.porTributo = porTributo;
    }

    @Generated
    public void setParcelas(List<CancelamentoDebitoParcelaDTO> parcelas) {
        this.parcelas = parcelas;
    }

    @Generated
    public void setEnviarEmail(Boolean enviarEmail) {
        this.enviarEmail = enviarEmail;
    }

    @Generated
    public void setMensagemEmail(String mensagemEmail) {
        this.mensagemEmail = mensagemEmail;
    }

    @Generated
    public void setProcessoSei(String processoSei) {
        this.processoSei = processoSei;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CancelamentoParcelasFormDTO)) {
            return false;
        }
        CancelamentoParcelasFormDTO other = (CancelamentoParcelasFormDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$situacaoLegal = this.getSituacaoLegal();
        Long other$situacaoLegal = other.getSituacaoLegal();
        if (this$situacaoLegal == null ? other$situacaoLegal != null : !((Object)this$situacaoLegal).equals(other$situacaoLegal)) {
            return false;
        }
        Long this$idProcesso = this.getIdProcesso();
        Long other$idProcesso = other.getIdProcesso();
        if (this$idProcesso == null ? other$idProcesso != null : !((Object)this$idProcesso).equals(other$idProcesso)) {
            return false;
        }
        Long this$exercicioProcesso = this.getExercicioProcesso();
        Long other$exercicioProcesso = other.getExercicioProcesso();
        if (this$exercicioProcesso == null ? other$exercicioProcesso != null : !((Object)this$exercicioProcesso).equals(other$exercicioProcesso)) {
            return false;
        }
        Boolean this$porTributo = this.getPorTributo();
        Boolean other$porTributo = other.getPorTributo();
        if (this$porTributo == null ? other$porTributo != null : !((Object)this$porTributo).equals(other$porTributo)) {
            return false;
        }
        Boolean this$enviarEmail = this.getEnviarEmail();
        Boolean other$enviarEmail = other.getEnviarEmail();
        if (this$enviarEmail == null ? other$enviarEmail != null : !((Object)this$enviarEmail).equals(other$enviarEmail)) {
            return false;
        }
        String this$usuario = this.getUsuario();
        String other$usuario = other.getUsuario();
        if (this$usuario == null ? other$usuario != null : !this$usuario.equals(other$usuario)) {
            return false;
        }
        LocalDate this$dataCancelamento = this.getDataCancelamento();
        LocalDate other$dataCancelamento = other.getDataCancelamento();
        if (this$dataCancelamento == null ? other$dataCancelamento != null : !((Object)this$dataCancelamento).equals(other$dataCancelamento)) {
            return false;
        }
        String this$motivo = this.getMotivo();
        String other$motivo = other.getMotivo();
        if (this$motivo == null ? other$motivo != null : !this$motivo.equals(other$motivo)) {
            return false;
        }
        MotivoDeducao this$motivoCancelamento = this.getMotivoCancelamento();
        MotivoDeducao other$motivoCancelamento = other.getMotivoCancelamento();
        if (this$motivoCancelamento == null ? other$motivoCancelamento != null : !this$motivoCancelamento.equals(other$motivoCancelamento)) {
            return false;
        }
        TipoDeducao this$tipoDeducao = this.getTipoDeducao();
        TipoDeducao other$tipoDeducao = other.getTipoDeducao();
        if (this$tipoDeducao == null ? other$tipoDeducao != null : !this$tipoDeducao.equals(other$tipoDeducao)) {
            return false;
        }
        List this$parcelas = this.getParcelas();
        List other$parcelas = other.getParcelas();
        if (this$parcelas == null ? other$parcelas != null : !((Object)this$parcelas).equals(other$parcelas)) {
            return false;
        }
        String this$mensagemEmail = this.getMensagemEmail();
        String other$mensagemEmail = other.getMensagemEmail();
        if (this$mensagemEmail == null ? other$mensagemEmail != null : !this$mensagemEmail.equals(other$mensagemEmail)) {
            return false;
        }
        String this$processoSei = this.getProcessoSei();
        String other$processoSei = other.getProcessoSei();
        return !(this$processoSei == null ? other$processoSei != null : !this$processoSei.equals(other$processoSei));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CancelamentoParcelasFormDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $situacaoLegal = this.getSituacaoLegal();
        result = result * 59 + ($situacaoLegal == null ? 43 : ((Object)$situacaoLegal).hashCode());
        Long $idProcesso = this.getIdProcesso();
        result = result * 59 + ($idProcesso == null ? 43 : ((Object)$idProcesso).hashCode());
        Long $exercicioProcesso = this.getExercicioProcesso();
        result = result * 59 + ($exercicioProcesso == null ? 43 : ((Object)$exercicioProcesso).hashCode());
        Boolean $porTributo = this.getPorTributo();
        result = result * 59 + ($porTributo == null ? 43 : ((Object)$porTributo).hashCode());
        Boolean $enviarEmail = this.getEnviarEmail();
        result = result * 59 + ($enviarEmail == null ? 43 : ((Object)$enviarEmail).hashCode());
        String $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : $usuario.hashCode());
        LocalDate $dataCancelamento = this.getDataCancelamento();
        result = result * 59 + ($dataCancelamento == null ? 43 : ((Object)$dataCancelamento).hashCode());
        String $motivo = this.getMotivo();
        result = result * 59 + ($motivo == null ? 43 : $motivo.hashCode());
        MotivoDeducao $motivoCancelamento = this.getMotivoCancelamento();
        result = result * 59 + ($motivoCancelamento == null ? 43 : $motivoCancelamento.hashCode());
        TipoDeducao $tipoDeducao = this.getTipoDeducao();
        result = result * 59 + ($tipoDeducao == null ? 43 : $tipoDeducao.hashCode());
        List $parcelas = this.getParcelas();
        result = result * 59 + ($parcelas == null ? 43 : ((Object)$parcelas).hashCode());
        String $mensagemEmail = this.getMensagemEmail();
        result = result * 59 + ($mensagemEmail == null ? 43 : $mensagemEmail.hashCode());
        String $processoSei = this.getProcessoSei();
        result = result * 59 + ($processoSei == null ? 43 : $processoSei.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CancelamentoParcelasFormDTO(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", usuario=" + this.getUsuario() + ", dataCancelamento=" + String.valueOf(this.getDataCancelamento()) + ", motivo=" + this.getMotivo() + ", motivoCancelamento=" + String.valueOf(this.getMotivoCancelamento()) + ", situacaoLegal=" + this.getSituacaoLegal() + ", idProcesso=" + this.getIdProcesso() + ", exercicioProcesso=" + this.getExercicioProcesso() + ", tipoDeducao=" + String.valueOf(this.getTipoDeducao()) + ", porTributo=" + this.getPorTributo() + ", parcelas=" + String.valueOf(this.getParcelas()) + ", enviarEmail=" + this.getEnviarEmail() + ", mensagemEmail=" + this.getMensagemEmail() + ", processoSei=" + this.getProcessoSei() + ")";
    }
}

