/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.cadastroimobiliario;

import br.com.elotech.tributos.domain.ImobiliarioItbi;
import br.com.elotech.tributos.dto.cadastroimobiliario.ProprietarioTransmissaoDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class HistoricoTransmissaoDTO {
    private LocalDate data;
    private BigDecimal valorTotal;
    private Long numeroItbi;
    private Long numeroDebito;
    private List<ProprietarioTransmissaoDTO> proprietarios;

    public static HistoricoTransmissaoDTO from(ImobiliarioItbi imobiliarioItbi, Long numeroDebito) {
        HistoricoTransmissaoDTO historicoTransmissaoDTO = new HistoricoTransmissaoDTO();
        historicoTransmissaoDTO.setData(imobiliarioItbi.getDataLancamento());
        historicoTransmissaoDTO.setNumeroItbi(imobiliarioItbi.getCodigoItbi());
        historicoTransmissaoDTO.setNumeroDebito(numeroDebito);
        historicoTransmissaoDTO.setValorTotal(imobiliarioItbi.getValor());
        historicoTransmissaoDTO.setProprietarios(imobiliarioItbi.getProprietarios().stream().map(ProprietarioTransmissaoDTO::from).collect(Collectors.toList()));
        return historicoTransmissaoDTO;
    }

    @Generated
    public HistoricoTransmissaoDTO() {
    }

    @Generated
    public LocalDate getData() {
        return this.data;
    }

    @Generated
    public BigDecimal getValorTotal() {
        return this.valorTotal;
    }

    @Generated
    public Long getNumeroItbi() {
        return this.numeroItbi;
    }

    @Generated
    public Long getNumeroDebito() {
        return this.numeroDebito;
    }

    @Generated
    public List<ProprietarioTransmissaoDTO> getProprietarios() {
        return this.proprietarios;
    }

    @Generated
    public void setData(LocalDate data) {
        this.data = data;
    }

    @Generated
    public void setValorTotal(BigDecimal valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Generated
    public void setNumeroItbi(Long numeroItbi) {
        this.numeroItbi = numeroItbi;
    }

    @Generated
    public void setNumeroDebito(Long numeroDebito) {
        this.numeroDebito = numeroDebito;
    }

    @Generated
    public void setProprietarios(List<ProprietarioTransmissaoDTO> proprietarios) {
        this.proprietarios = proprietarios;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HistoricoTransmissaoDTO)) {
            return false;
        }
        HistoricoTransmissaoDTO other = (HistoricoTransmissaoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$numeroItbi = this.getNumeroItbi();
        Long other$numeroItbi = other.getNumeroItbi();
        if (this$numeroItbi == null ? other$numeroItbi != null : !((Object)this$numeroItbi).equals(other$numeroItbi)) {
            return false;
        }
        Long this$numeroDebito = this.getNumeroDebito();
        Long other$numeroDebito = other.getNumeroDebito();
        if (this$numeroDebito == null ? other$numeroDebito != null : !((Object)this$numeroDebito).equals(other$numeroDebito)) {
            return false;
        }
        LocalDate this$data = this.getData();
        LocalDate other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        BigDecimal this$valorTotal = this.getValorTotal();
        BigDecimal other$valorTotal = other.getValorTotal();
        if (this$valorTotal == null ? other$valorTotal != null : !((Object)this$valorTotal).equals(other$valorTotal)) {
            return false;
        }
        List this$proprietarios = this.getProprietarios();
        List other$proprietarios = other.getProprietarios();
        return !(this$proprietarios == null ? other$proprietarios != null : !((Object)this$proprietarios).equals(other$proprietarios));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HistoricoTransmissaoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $numeroItbi = this.getNumeroItbi();
        result = result * 59 + ($numeroItbi == null ? 43 : ((Object)$numeroItbi).hashCode());
        Long $numeroDebito = this.getNumeroDebito();
        result = result * 59 + ($numeroDebito == null ? 43 : ((Object)$numeroDebito).hashCode());
        LocalDate $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        BigDecimal $valorTotal = this.getValorTotal();
        result = result * 59 + ($valorTotal == null ? 43 : ((Object)$valorTotal).hashCode());
        List $proprietarios = this.getProprietarios();
        result = result * 59 + ($proprietarios == null ? 43 : ((Object)$proprietarios).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HistoricoTransmissaoDTO(data=" + String.valueOf(this.getData()) + ", valorTotal=" + String.valueOf(this.getValorTotal()) + ", numeroItbi=" + this.getNumeroItbi() + ", numeroDebito=" + this.getNumeroDebito() + ", proprietarios=" + String.valueOf(this.getProprietarios()) + ")";
    }
}

