/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.boleto;

import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.DebitoEmAbertoDTO;
import br.com.elotech.tributos.dto.SituacaoLegal;
import java.math.BigDecimal;
import java.time.LocalDate;
import lombok.Generated;

public class BoletoEspecialDebitoDTO {
    private TipoCadastro tipoCadastro;
    private Long cadastroGeral;
    private Long exercicio;
    private Long divida;
    private Long subDivida;
    private Long parcela;
    private String tributo;
    private Long idDebitoParcelaReceita;
    private Long idDebito;
    private LocalDate dataVencimento;
    private BigDecimal valorPrincipal = BigDecimal.ZERO;
    private BigDecimal valorMulta = BigDecimal.ZERO;
    private BigDecimal valorJuros = BigDecimal.ZERO;
    private BigDecimal valorCorrecao = BigDecimal.ZERO;
    private BigDecimal valorDescontoPrincipal = BigDecimal.ZERO;
    private BigDecimal valorDescontoMulta = BigDecimal.ZERO;
    private BigDecimal valorDescontoJuros = BigDecimal.ZERO;
    private BigDecimal valorDescontoCorrecao = BigDecimal.ZERO;
    private LocalDate dataLancamento;
    private LocalDate dataPrimeiraParcela;
    private Long formaCorrecao;
    private Boolean parcelado;
    private Boolean emiteBoleto;
    private Long tipoSituacaoParcela;
    private SituacaoLegal situacaoLegal;
    private BigDecimal valorOriginalDebito = BigDecimal.ZERO;

    public BigDecimal getValorDescontos() {
        return this.valorDescontoPrincipal.add(this.valorDescontoMulta).add(this.valorDescontoJuros).add(this.valorDescontoCorrecao);
    }

    public BigDecimal getValorTotalSemDesconto() {
        return this.valorPrincipal.add(this.valorMulta).add(this.valorJuros).add(this.valorCorrecao);
    }

    public BigDecimal getValorTotal() {
        return this.getValorTotalSemDesconto().subtract(this.getValorDescontos());
    }

    public Boolean sameCadastroGeral(BoletoEspecialDebitoDTO other) {
        return this.tipoCadastro.equals((Object)other.tipoCadastro) && this.cadastroGeral.equals(other.cadastroGeral);
    }

    public static BoletoEspecialDebitoDTO from(DebitoEmAbertoDTO debitoEmAbertoDTO) {
        BoletoEspecialDebitoDTO boletoEspecialDebitoDTO = new BoletoEspecialDebitoDTO();
        boletoEspecialDebitoDTO.tipoCadastro = TipoCadastro.fromValue((Long)debitoEmAbertoDTO.getTipoCadastro());
        boletoEspecialDebitoDTO.cadastroGeral = debitoEmAbertoDTO.getCadastroGeral();
        boletoEspecialDebitoDTO.exercicio = debitoEmAbertoDTO.getExercicio();
        boletoEspecialDebitoDTO.divida = debitoEmAbertoDTO.getDivida();
        boletoEspecialDebitoDTO.subDivida = debitoEmAbertoDTO.getSubDivida();
        boletoEspecialDebitoDTO.parcela = debitoEmAbertoDTO.getParcela();
        boletoEspecialDebitoDTO.tributo = debitoEmAbertoDTO.getTributo();
        boletoEspecialDebitoDTO.idDebitoParcelaReceita = debitoEmAbertoDTO.getIdDebitoParcelaReceita();
        boletoEspecialDebitoDTO.idDebito = debitoEmAbertoDTO.getIdDebito();
        boletoEspecialDebitoDTO.dataVencimento = debitoEmAbertoDTO.getDataVencimento();
        boletoEspecialDebitoDTO.valorPrincipal = debitoEmAbertoDTO.getValorPrincipal();
        boletoEspecialDebitoDTO.valorMulta = debitoEmAbertoDTO.getValorMulta();
        boletoEspecialDebitoDTO.valorJuros = debitoEmAbertoDTO.getValorJuros();
        boletoEspecialDebitoDTO.valorCorrecao = debitoEmAbertoDTO.getValorCorrecao();
        boletoEspecialDebitoDTO.valorDescontoPrincipal = debitoEmAbertoDTO.getValorDescontoPrincipal();
        boletoEspecialDebitoDTO.valorDescontoMulta = debitoEmAbertoDTO.getValorDescontoMulta();
        boletoEspecialDebitoDTO.valorDescontoJuros = debitoEmAbertoDTO.getValorDescontoJuros();
        boletoEspecialDebitoDTO.valorDescontoCorrecao = debitoEmAbertoDTO.getValorDescontoCorrecao();
        boletoEspecialDebitoDTO.dataLancamento = debitoEmAbertoDTO.getDataLancamento();
        boletoEspecialDebitoDTO.dataPrimeiraParcela = debitoEmAbertoDTO.getDataPrimeiraParcela();
        boletoEspecialDebitoDTO.formaCorrecao = debitoEmAbertoDTO.getFormaCorrecao();
        boletoEspecialDebitoDTO.parcelado = debitoEmAbertoDTO.getParcelado() != false || debitoEmAbertoDTO.getReparcelado() != false;
        boletoEspecialDebitoDTO.situacaoLegal = SituacaoLegal.fromValue((Integer)debitoEmAbertoDTO.getSituacaoLegal());
        boletoEspecialDebitoDTO.emiteBoleto = debitoEmAbertoDTO.getEmiteBoleto();
        boletoEspecialDebitoDTO.tipoSituacaoParcela = debitoEmAbertoDTO.getTipoSituacaoParcela();
        boletoEspecialDebitoDTO.valorOriginalDebito = debitoEmAbertoDTO.getValorOriginalDebito();
        return boletoEspecialDebitoDTO;
    }

    public BigDecimal getValorPrincipalComDesconto() {
        return this.valorPrincipal.subtract(this.valorDescontoPrincipal);
    }

    public BigDecimal getValorMultaComDesconto() {
        return this.valorMulta.subtract(this.valorDescontoMulta);
    }

    public BigDecimal getValorJurosComDesconto() {
        return this.valorJuros.subtract(this.valorDescontoJuros);
    }

    public BigDecimal getValorCorrecaoComDesconto() {
        return this.valorCorrecao.subtract(this.valorDescontoCorrecao);
    }

    @Generated
    public BoletoEspecialDebitoDTO() {
    }

    @Generated
    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getDivida() {
        return this.divida;
    }

    @Generated
    public Long getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public Long getParcela() {
        return this.parcela;
    }

    @Generated
    public String getTributo() {
        return this.tributo;
    }

    @Generated
    public Long getIdDebitoParcelaReceita() {
        return this.idDebitoParcelaReceita;
    }

    @Generated
    public Long getIdDebito() {
        return this.idDebito;
    }

    @Generated
    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public BigDecimal getValorPrincipal() {
        return this.valorPrincipal;
    }

    @Generated
    public BigDecimal getValorMulta() {
        return this.valorMulta;
    }

    @Generated
    public BigDecimal getValorJuros() {
        return this.valorJuros;
    }

    @Generated
    public BigDecimal getValorCorrecao() {
        return this.valorCorrecao;
    }

    @Generated
    public BigDecimal getValorDescontoPrincipal() {
        return this.valorDescontoPrincipal;
    }

    @Generated
    public BigDecimal getValorDescontoMulta() {
        return this.valorDescontoMulta;
    }

    @Generated
    public BigDecimal getValorDescontoJuros() {
        return this.valorDescontoJuros;
    }

    @Generated
    public BigDecimal getValorDescontoCorrecao() {
        return this.valorDescontoCorrecao;
    }

    @Generated
    public LocalDate getDataLancamento() {
        return this.dataLancamento;
    }

    @Generated
    public LocalDate getDataPrimeiraParcela() {
        return this.dataPrimeiraParcela;
    }

    @Generated
    public Long getFormaCorrecao() {
        return this.formaCorrecao;
    }

    @Generated
    public Boolean getParcelado() {
        return this.parcelado;
    }

    @Generated
    public Boolean getEmiteBoleto() {
        return this.emiteBoleto;
    }

    @Generated
    public Long getTipoSituacaoParcela() {
        return this.tipoSituacaoParcela;
    }

    @Generated
    public SituacaoLegal getSituacaoLegal() {
        return this.situacaoLegal;
    }

    @Generated
    public BigDecimal getValorOriginalDebito() {
        return this.valorOriginalDebito;
    }

    @Generated
    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setDivida(Long divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(Long subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setParcela(Long parcela) {
        this.parcela = parcela;
    }

    @Generated
    public void setTributo(String tributo) {
        this.tributo = tributo;
    }

    @Generated
    public void setIdDebitoParcelaReceita(Long idDebitoParcelaReceita) {
        this.idDebitoParcelaReceita = idDebitoParcelaReceita;
    }

    @Generated
    public void setIdDebito(Long idDebito) {
        this.idDebito = idDebito;
    }

    @Generated
    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Generated
    public void setValorPrincipal(BigDecimal valorPrincipal) {
        this.valorPrincipal = valorPrincipal;
    }

    @Generated
    public void setValorMulta(BigDecimal valorMulta) {
        this.valorMulta = valorMulta;
    }

    @Generated
    public void setValorJuros(BigDecimal valorJuros) {
        this.valorJuros = valorJuros;
    }

    @Generated
    public void setValorCorrecao(BigDecimal valorCorrecao) {
        this.valorCorrecao = valorCorrecao;
    }

    @Generated
    public void setValorDescontoPrincipal(BigDecimal valorDescontoPrincipal) {
        this.valorDescontoPrincipal = valorDescontoPrincipal;
    }

    @Generated
    public void setValorDescontoMulta(BigDecimal valorDescontoMulta) {
        this.valorDescontoMulta = valorDescontoMulta;
    }

    @Generated
    public void setValorDescontoJuros(BigDecimal valorDescontoJuros) {
        this.valorDescontoJuros = valorDescontoJuros;
    }

    @Generated
    public void setValorDescontoCorrecao(BigDecimal valorDescontoCorrecao) {
        this.valorDescontoCorrecao = valorDescontoCorrecao;
    }

    @Generated
    public void setDataLancamento(LocalDate dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    @Generated
    public void setDataPrimeiraParcela(LocalDate dataPrimeiraParcela) {
        this.dataPrimeiraParcela = dataPrimeiraParcela;
    }

    @Generated
    public void setFormaCorrecao(Long formaCorrecao) {
        this.formaCorrecao = formaCorrecao;
    }

    @Generated
    public void setParcelado(Boolean parcelado) {
        this.parcelado = parcelado;
    }

    @Generated
    public void setEmiteBoleto(Boolean emiteBoleto) {
        this.emiteBoleto = emiteBoleto;
    }

    @Generated
    public void setTipoSituacaoParcela(Long tipoSituacaoParcela) {
        this.tipoSituacaoParcela = tipoSituacaoParcela;
    }

    @Generated
    public void setSituacaoLegal(SituacaoLegal situacaoLegal) {
        this.situacaoLegal = situacaoLegal;
    }

    @Generated
    public void setValorOriginalDebito(BigDecimal valorOriginalDebito) {
        this.valorOriginalDebito = valorOriginalDebito;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BoletoEspecialDebitoDTO)) {
            return false;
        }
        BoletoEspecialDebitoDTO other = (BoletoEspecialDebitoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$divida = this.getDivida();
        Long other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !((Object)this$divida).equals(other$divida)) {
            return false;
        }
        Long this$subDivida = this.getSubDivida();
        Long other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !((Object)this$subDivida).equals(other$subDivida)) {
            return false;
        }
        Long this$parcela = this.getParcela();
        Long other$parcela = other.getParcela();
        if (this$parcela == null ? other$parcela != null : !((Object)this$parcela).equals(other$parcela)) {
            return false;
        }
        Long this$idDebitoParcelaReceita = this.getIdDebitoParcelaReceita();
        Long other$idDebitoParcelaReceita = other.getIdDebitoParcelaReceita();
        if (this$idDebitoParcelaReceita == null ? other$idDebitoParcelaReceita != null : !((Object)this$idDebitoParcelaReceita).equals(other$idDebitoParcelaReceita)) {
            return false;
        }
        Long this$idDebito = this.getIdDebito();
        Long other$idDebito = other.getIdDebito();
        if (this$idDebito == null ? other$idDebito != null : !((Object)this$idDebito).equals(other$idDebito)) {
            return false;
        }
        Long this$formaCorrecao = this.getFormaCorrecao();
        Long other$formaCorrecao = other.getFormaCorrecao();
        if (this$formaCorrecao == null ? other$formaCorrecao != null : !((Object)this$formaCorrecao).equals(other$formaCorrecao)) {
            return false;
        }
        Boolean this$parcelado = this.getParcelado();
        Boolean other$parcelado = other.getParcelado();
        if (this$parcelado == null ? other$parcelado != null : !((Object)this$parcelado).equals(other$parcelado)) {
            return false;
        }
        Boolean this$emiteBoleto = this.getEmiteBoleto();
        Boolean other$emiteBoleto = other.getEmiteBoleto();
        if (this$emiteBoleto == null ? other$emiteBoleto != null : !((Object)this$emiteBoleto).equals(other$emiteBoleto)) {
            return false;
        }
        Long this$tipoSituacaoParcela = this.getTipoSituacaoParcela();
        Long other$tipoSituacaoParcela = other.getTipoSituacaoParcela();
        if (this$tipoSituacaoParcela == null ? other$tipoSituacaoParcela != null : !((Object)this$tipoSituacaoParcela).equals(other$tipoSituacaoParcela)) {
            return false;
        }
        TipoCadastro this$tipoCadastro = this.getTipoCadastro();
        TipoCadastro other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !this$tipoCadastro.equals(other$tipoCadastro)) {
            return false;
        }
        String this$tributo = this.getTributo();
        String other$tributo = other.getTributo();
        if (this$tributo == null ? other$tributo != null : !this$tributo.equals(other$tributo)) {
            return false;
        }
        LocalDate this$dataVencimento = this.getDataVencimento();
        LocalDate other$dataVencimento = other.getDataVencimento();
        if (this$dataVencimento == null ? other$dataVencimento != null : !((Object)this$dataVencimento).equals(other$dataVencimento)) {
            return false;
        }
        BigDecimal this$valorPrincipal = this.getValorPrincipal();
        BigDecimal other$valorPrincipal = other.getValorPrincipal();
        if (this$valorPrincipal == null ? other$valorPrincipal != null : !((Object)this$valorPrincipal).equals(other$valorPrincipal)) {
            return false;
        }
        BigDecimal this$valorMulta = this.getValorMulta();
        BigDecimal other$valorMulta = other.getValorMulta();
        if (this$valorMulta == null ? other$valorMulta != null : !((Object)this$valorMulta).equals(other$valorMulta)) {
            return false;
        }
        BigDecimal this$valorJuros = this.getValorJuros();
        BigDecimal other$valorJuros = other.getValorJuros();
        if (this$valorJuros == null ? other$valorJuros != null : !((Object)this$valorJuros).equals(other$valorJuros)) {
            return false;
        }
        BigDecimal this$valorCorrecao = this.getValorCorrecao();
        BigDecimal other$valorCorrecao = other.getValorCorrecao();
        if (this$valorCorrecao == null ? other$valorCorrecao != null : !((Object)this$valorCorrecao).equals(other$valorCorrecao)) {
            return false;
        }
        BigDecimal this$valorDescontoPrincipal = this.getValorDescontoPrincipal();
        BigDecimal other$valorDescontoPrincipal = other.getValorDescontoPrincipal();
        if (this$valorDescontoPrincipal == null ? other$valorDescontoPrincipal != null : !((Object)this$valorDescontoPrincipal).equals(other$valorDescontoPrincipal)) {
            return false;
        }
        BigDecimal this$valorDescontoMulta = this.getValorDescontoMulta();
        BigDecimal other$valorDescontoMulta = other.getValorDescontoMulta();
        if (this$valorDescontoMulta == null ? other$valorDescontoMulta != null : !((Object)this$valorDescontoMulta).equals(other$valorDescontoMulta)) {
            return false;
        }
        BigDecimal this$valorDescontoJuros = this.getValorDescontoJuros();
        BigDecimal other$valorDescontoJuros = other.getValorDescontoJuros();
        if (this$valorDescontoJuros == null ? other$valorDescontoJuros != null : !((Object)this$valorDescontoJuros).equals(other$valorDescontoJuros)) {
            return false;
        }
        BigDecimal this$valorDescontoCorrecao = this.getValorDescontoCorrecao();
        BigDecimal other$valorDescontoCorrecao = other.getValorDescontoCorrecao();
        if (this$valorDescontoCorrecao == null ? other$valorDescontoCorrecao != null : !((Object)this$valorDescontoCorrecao).equals(other$valorDescontoCorrecao)) {
            return false;
        }
        LocalDate this$dataLancamento = this.getDataLancamento();
        LocalDate other$dataLancamento = other.getDataLancamento();
        if (this$dataLancamento == null ? other$dataLancamento != null : !((Object)this$dataLancamento).equals(other$dataLancamento)) {
            return false;
        }
        LocalDate this$dataPrimeiraParcela = this.getDataPrimeiraParcela();
        LocalDate other$dataPrimeiraParcela = other.getDataPrimeiraParcela();
        if (this$dataPrimeiraParcela == null ? other$dataPrimeiraParcela != null : !((Object)this$dataPrimeiraParcela).equals(other$dataPrimeiraParcela)) {
            return false;
        }
        SituacaoLegal this$situacaoLegal = this.getSituacaoLegal();
        SituacaoLegal other$situacaoLegal = other.getSituacaoLegal();
        if (this$situacaoLegal == null ? other$situacaoLegal != null : !this$situacaoLegal.equals(other$situacaoLegal)) {
            return false;
        }
        BigDecimal this$valorOriginalDebito = this.getValorOriginalDebito();
        BigDecimal other$valorOriginalDebito = other.getValorOriginalDebito();
        return !(this$valorOriginalDebito == null ? other$valorOriginalDebito != null : !((Object)this$valorOriginalDebito).equals(other$valorOriginalDebito));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BoletoEspecialDebitoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : ((Object)$divida).hashCode());
        Long $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : ((Object)$subDivida).hashCode());
        Long $parcela = this.getParcela();
        result = result * 59 + ($parcela == null ? 43 : ((Object)$parcela).hashCode());
        Long $idDebitoParcelaReceita = this.getIdDebitoParcelaReceita();
        result = result * 59 + ($idDebitoParcelaReceita == null ? 43 : ((Object)$idDebitoParcelaReceita).hashCode());
        Long $idDebito = this.getIdDebito();
        result = result * 59 + ($idDebito == null ? 43 : ((Object)$idDebito).hashCode());
        Long $formaCorrecao = this.getFormaCorrecao();
        result = result * 59 + ($formaCorrecao == null ? 43 : ((Object)$formaCorrecao).hashCode());
        Boolean $parcelado = this.getParcelado();
        result = result * 59 + ($parcelado == null ? 43 : ((Object)$parcelado).hashCode());
        Boolean $emiteBoleto = this.getEmiteBoleto();
        result = result * 59 + ($emiteBoleto == null ? 43 : ((Object)$emiteBoleto).hashCode());
        Long $tipoSituacaoParcela = this.getTipoSituacaoParcela();
        result = result * 59 + ($tipoSituacaoParcela == null ? 43 : ((Object)$tipoSituacaoParcela).hashCode());
        TipoCadastro $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : $tipoCadastro.hashCode());
        String $tributo = this.getTributo();
        result = result * 59 + ($tributo == null ? 43 : $tributo.hashCode());
        LocalDate $dataVencimento = this.getDataVencimento();
        result = result * 59 + ($dataVencimento == null ? 43 : ((Object)$dataVencimento).hashCode());
        BigDecimal $valorPrincipal = this.getValorPrincipal();
        result = result * 59 + ($valorPrincipal == null ? 43 : ((Object)$valorPrincipal).hashCode());
        BigDecimal $valorMulta = this.getValorMulta();
        result = result * 59 + ($valorMulta == null ? 43 : ((Object)$valorMulta).hashCode());
        BigDecimal $valorJuros = this.getValorJuros();
        result = result * 59 + ($valorJuros == null ? 43 : ((Object)$valorJuros).hashCode());
        BigDecimal $valorCorrecao = this.getValorCorrecao();
        result = result * 59 + ($valorCorrecao == null ? 43 : ((Object)$valorCorrecao).hashCode());
        BigDecimal $valorDescontoPrincipal = this.getValorDescontoPrincipal();
        result = result * 59 + ($valorDescontoPrincipal == null ? 43 : ((Object)$valorDescontoPrincipal).hashCode());
        BigDecimal $valorDescontoMulta = this.getValorDescontoMulta();
        result = result * 59 + ($valorDescontoMulta == null ? 43 : ((Object)$valorDescontoMulta).hashCode());
        BigDecimal $valorDescontoJuros = this.getValorDescontoJuros();
        result = result * 59 + ($valorDescontoJuros == null ? 43 : ((Object)$valorDescontoJuros).hashCode());
        BigDecimal $valorDescontoCorrecao = this.getValorDescontoCorrecao();
        result = result * 59 + ($valorDescontoCorrecao == null ? 43 : ((Object)$valorDescontoCorrecao).hashCode());
        LocalDate $dataLancamento = this.getDataLancamento();
        result = result * 59 + ($dataLancamento == null ? 43 : ((Object)$dataLancamento).hashCode());
        LocalDate $dataPrimeiraParcela = this.getDataPrimeiraParcela();
        result = result * 59 + ($dataPrimeiraParcela == null ? 43 : ((Object)$dataPrimeiraParcela).hashCode());
        SituacaoLegal $situacaoLegal = this.getSituacaoLegal();
        result = result * 59 + ($situacaoLegal == null ? 43 : $situacaoLegal.hashCode());
        BigDecimal $valorOriginalDebito = this.getValorOriginalDebito();
        result = result * 59 + ($valorOriginalDebito == null ? 43 : ((Object)$valorOriginalDebito).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BoletoEspecialDebitoDTO(tipoCadastro=" + String.valueOf(this.getTipoCadastro()) + ", cadastroGeral=" + this.getCadastroGeral() + ", exercicio=" + this.getExercicio() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ", parcela=" + this.getParcela() + ", tributo=" + this.getTributo() + ", idDebitoParcelaReceita=" + this.getIdDebitoParcelaReceita() + ", idDebito=" + this.getIdDebito() + ", dataVencimento=" + String.valueOf(this.getDataVencimento()) + ", valorPrincipal=" + String.valueOf(this.getValorPrincipal()) + ", valorMulta=" + String.valueOf(this.getValorMulta()) + ", valorJuros=" + String.valueOf(this.getValorJuros()) + ", valorCorrecao=" + String.valueOf(this.getValorCorrecao()) + ", valorDescontoPrincipal=" + String.valueOf(this.getValorDescontoPrincipal()) + ", valorDescontoMulta=" + String.valueOf(this.getValorDescontoMulta()) + ", valorDescontoJuros=" + String.valueOf(this.getValorDescontoJuros()) + ", valorDescontoCorrecao=" + String.valueOf(this.getValorDescontoCorrecao()) + ", dataLancamento=" + String.valueOf(this.getDataLancamento()) + ", dataPrimeiraParcela=" + String.valueOf(this.getDataPrimeiraParcela()) + ", formaCorrecao=" + this.getFormaCorrecao() + ", parcelado=" + this.getParcelado() + ", emiteBoleto=" + this.getEmiteBoleto() + ", tipoSituacaoParcela=" + this.getTipoSituacaoParcela() + ", situacaoLegal=" + String.valueOf(this.getSituacaoLegal()) + ", valorOriginalDebito=" + String.valueOf(this.getValorOriginalDebito()) + ")";
    }
}

