/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.atualizacaomonetariaparcelamento;

import br.com.elotech.tributos.domain.parcelamento.TipoAtualizacaoMonetaria;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public class AtualizacaoMonetariaParcelamentoParams {
    @NotNull
    private Long entidade;
    @NotNull
    private Long exercicio;
    @NotNull
    @Min(value=1L)
    @Max(value=12L)
    private @NotNull @Min(value=1L) @Max(value=12L) Long mes;
    private List<Long> idsParcelamento = new ArrayList();
    private List<Long> idsParamParcelamento = new ArrayList();
    private LocalDate dataLancamento;
    private LocalDate dataVencimento;
    private LocalDate dataReajuste;
    private LocalDate dataCorrecao;
    private LocalDateTime dataMovimentacao;
    private TipoAtualizacaoMonetaria tipo;
    private String observacao;
    private Boolean permiteAtualizacaoMensal = Boolean.FALSE;

    public void calcularDatas() {
        LocalDate dataLancamento = LocalDate.of(this.getExercicio().intValue(), this.getMes().intValue(), 1).plusMonths(1L).minusYears(1L);
        this.setDataLancamento(dataLancamento);
        this.setDataVencimento(LocalDate.of(this.getExercicio().intValue(), 1, 1));
        this.setDataReajuste(LocalDate.of(this.getExercicio().intValue(), this.getMes().intValue(), 1));
        this.setDataCorrecao(DateUtils.getLocalDateComUltimoDiaDoMes((LocalDate)LocalDate.of(this.getExercicio().intValue(), this.getMes().intValue(), 1)));
        this.setDataMovimentacao(LocalDateTime.now());
    }

    @Generated
    public AtualizacaoMonetariaParcelamentoParams() {
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getMes() {
        return this.mes;
    }

    @Generated
    public List<Long> getIdsParcelamento() {
        return this.idsParcelamento;
    }

    @Generated
    public List<Long> getIdsParamParcelamento() {
        return this.idsParamParcelamento;
    }

    @Generated
    public LocalDate getDataLancamento() {
        return this.dataLancamento;
    }

    @Generated
    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public LocalDate getDataReajuste() {
        return this.dataReajuste;
    }

    @Generated
    public LocalDate getDataCorrecao() {
        return this.dataCorrecao;
    }

    @Generated
    public LocalDateTime getDataMovimentacao() {
        return this.dataMovimentacao;
    }

    @Generated
    public TipoAtualizacaoMonetaria getTipo() {
        return this.tipo;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public Boolean getPermiteAtualizacaoMensal() {
        return this.permiteAtualizacaoMensal;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setMes(Long mes) {
        this.mes = mes;
    }

    @Generated
    public void setIdsParcelamento(List<Long> idsParcelamento) {
        this.idsParcelamento = idsParcelamento;
    }

    @Generated
    public void setIdsParamParcelamento(List<Long> idsParamParcelamento) {
        this.idsParamParcelamento = idsParamParcelamento;
    }

    @Generated
    public void setDataLancamento(LocalDate dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    @Generated
    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Generated
    public void setDataReajuste(LocalDate dataReajuste) {
        this.dataReajuste = dataReajuste;
    }

    @Generated
    public void setDataCorrecao(LocalDate dataCorrecao) {
        this.dataCorrecao = dataCorrecao;
    }

    @Generated
    public void setDataMovimentacao(LocalDateTime dataMovimentacao) {
        this.dataMovimentacao = dataMovimentacao;
    }

    @Generated
    public void setTipo(TipoAtualizacaoMonetaria tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setPermiteAtualizacaoMensal(Boolean permiteAtualizacaoMensal) {
        this.permiteAtualizacaoMensal = permiteAtualizacaoMensal;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AtualizacaoMonetariaParcelamentoParams)) {
            return false;
        }
        AtualizacaoMonetariaParcelamentoParams other = (AtualizacaoMonetariaParcelamentoParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$mes = this.getMes();
        Long other$mes = other.getMes();
        if (this$mes == null ? other$mes != null : !((Object)this$mes).equals(other$mes)) {
            return false;
        }
        Boolean this$permiteAtualizacaoMensal = this.getPermiteAtualizacaoMensal();
        Boolean other$permiteAtualizacaoMensal = other.getPermiteAtualizacaoMensal();
        if (this$permiteAtualizacaoMensal == null ? other$permiteAtualizacaoMensal != null : !((Object)this$permiteAtualizacaoMensal).equals(other$permiteAtualizacaoMensal)) {
            return false;
        }
        List this$idsParcelamento = this.getIdsParcelamento();
        List other$idsParcelamento = other.getIdsParcelamento();
        if (this$idsParcelamento == null ? other$idsParcelamento != null : !((Object)this$idsParcelamento).equals(other$idsParcelamento)) {
            return false;
        }
        List this$idsParamParcelamento = this.getIdsParamParcelamento();
        List other$idsParamParcelamento = other.getIdsParamParcelamento();
        if (this$idsParamParcelamento == null ? other$idsParamParcelamento != null : !((Object)this$idsParamParcelamento).equals(other$idsParamParcelamento)) {
            return false;
        }
        LocalDate this$dataLancamento = this.getDataLancamento();
        LocalDate other$dataLancamento = other.getDataLancamento();
        if (this$dataLancamento == null ? other$dataLancamento != null : !((Object)this$dataLancamento).equals(other$dataLancamento)) {
            return false;
        }
        LocalDate this$dataVencimento = this.getDataVencimento();
        LocalDate other$dataVencimento = other.getDataVencimento();
        if (this$dataVencimento == null ? other$dataVencimento != null : !((Object)this$dataVencimento).equals(other$dataVencimento)) {
            return false;
        }
        LocalDate this$dataReajuste = this.getDataReajuste();
        LocalDate other$dataReajuste = other.getDataReajuste();
        if (this$dataReajuste == null ? other$dataReajuste != null : !((Object)this$dataReajuste).equals(other$dataReajuste)) {
            return false;
        }
        LocalDate this$dataCorrecao = this.getDataCorrecao();
        LocalDate other$dataCorrecao = other.getDataCorrecao();
        if (this$dataCorrecao == null ? other$dataCorrecao != null : !((Object)this$dataCorrecao).equals(other$dataCorrecao)) {
            return false;
        }
        LocalDateTime this$dataMovimentacao = this.getDataMovimentacao();
        LocalDateTime other$dataMovimentacao = other.getDataMovimentacao();
        if (this$dataMovimentacao == null ? other$dataMovimentacao != null : !((Object)this$dataMovimentacao).equals(other$dataMovimentacao)) {
            return false;
        }
        TipoAtualizacaoMonetaria this$tipo = this.getTipo();
        TipoAtualizacaoMonetaria other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !this$tipo.equals(other$tipo)) {
            return false;
        }
        String this$observacao = this.getObservacao();
        String other$observacao = other.getObservacao();
        return !(this$observacao == null ? other$observacao != null : !this$observacao.equals(other$observacao));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AtualizacaoMonetariaParcelamentoParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $mes = this.getMes();
        result = result * 59 + ($mes == null ? 43 : ((Object)$mes).hashCode());
        Boolean $permiteAtualizacaoMensal = this.getPermiteAtualizacaoMensal();
        result = result * 59 + ($permiteAtualizacaoMensal == null ? 43 : ((Object)$permiteAtualizacaoMensal).hashCode());
        List $idsParcelamento = this.getIdsParcelamento();
        result = result * 59 + ($idsParcelamento == null ? 43 : ((Object)$idsParcelamento).hashCode());
        List $idsParamParcelamento = this.getIdsParamParcelamento();
        result = result * 59 + ($idsParamParcelamento == null ? 43 : ((Object)$idsParamParcelamento).hashCode());
        LocalDate $dataLancamento = this.getDataLancamento();
        result = result * 59 + ($dataLancamento == null ? 43 : ((Object)$dataLancamento).hashCode());
        LocalDate $dataVencimento = this.getDataVencimento();
        result = result * 59 + ($dataVencimento == null ? 43 : ((Object)$dataVencimento).hashCode());
        LocalDate $dataReajuste = this.getDataReajuste();
        result = result * 59 + ($dataReajuste == null ? 43 : ((Object)$dataReajuste).hashCode());
        LocalDate $dataCorrecao = this.getDataCorrecao();
        result = result * 59 + ($dataCorrecao == null ? 43 : ((Object)$dataCorrecao).hashCode());
        LocalDateTime $dataMovimentacao = this.getDataMovimentacao();
        result = result * 59 + ($dataMovimentacao == null ? 43 : ((Object)$dataMovimentacao).hashCode());
        TipoAtualizacaoMonetaria $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : $tipo.hashCode());
        String $observacao = this.getObservacao();
        result = result * 59 + ($observacao == null ? 43 : $observacao.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AtualizacaoMonetariaParcelamentoParams(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", mes=" + this.getMes() + ", idsParcelamento=" + String.valueOf(this.getIdsParcelamento()) + ", idsParamParcelamento=" + String.valueOf(this.getIdsParamParcelamento()) + ", dataLancamento=" + String.valueOf(this.getDataLancamento()) + ", dataVencimento=" + String.valueOf(this.getDataVencimento()) + ", dataReajuste=" + String.valueOf(this.getDataReajuste()) + ", dataCorrecao=" + String.valueOf(this.getDataCorrecao()) + ", dataMovimentacao=" + String.valueOf(this.getDataMovimentacao()) + ", tipo=" + String.valueOf(this.getTipo()) + ", observacao=" + this.getObservacao() + ", permiteAtualizacaoMensal=" + this.getPermiteAtualizacaoMensal() + ")";
    }
}

