/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.acrescimo;

import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.acrescimo.TipoJuros;
import br.com.elotech.tributos.domain.devolucaocredito.DevolucaoCreditoDebito;
import br.com.elotech.tributos.domain.documento.cda.LoteCdaItemDetalhe;
import br.com.elotech.tributos.dto.DebitoConstituidoItemDTO;
import br.com.elotech.tributos.dto.DebitoGeracaoDividaAtivaAvulsaDTO;
import br.com.elotech.tributos.dto.DebitoManualDTO;
import br.com.elotech.tributos.dto.DebitoManualParcelaDTO;
import br.com.elotech.tributos.dto.DebitoManualTributoDTO;
import br.com.elotech.tributos.dto.DividaDTO;
import br.com.elotech.tributos.dto.RastreamentoDebitoDTO;
import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.dto.acrescimo.AcrescimoCdaDTO;
import br.com.elotech.tributos.dto.acrescimo.AcrescimoDTO;
import br.com.elotech.tributos.dto.acrescimo.CalculaAcrescimoBaseDTO;
import br.com.elotech.tributos.dto.dividaativa.GeraLivroDebitoParcelaTributoDTO;
import br.com.elotech.tributos.util.DateUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class AcrescimoDTO {
    private BigDecimal valor = BigDecimal.ZERO;
    private BigDecimal valorOriginal = BigDecimal.ZERO;
    private BigDecimal valorCorrecao = BigDecimal.ZERO;
    private BigDecimal valorMulta = BigDecimal.ZERO;
    private BigDecimal valorJuros = BigDecimal.ZERO;
    private BigDecimal valorHonorario = BigDecimal.ZERO;
    private BigDecimal valorDescontoPrincipal = BigDecimal.ZERO;
    private BigDecimal valorDescontoCorrecao = BigDecimal.ZERO;
    private BigDecimal valorDescontoMulta = BigDecimal.ZERO;
    private BigDecimal valorDescontoJuros = BigDecimal.ZERO;
    private BigDecimal valorDescontoJurosFinan = BigDecimal.ZERO;
    private BigDecimal valorDesconto = BigDecimal.ZERO;
    private BigDecimal valorTotal = BigDecimal.ZERO;
    private BigDecimal descontoParcelamento = BigDecimal.ZERO;
    private BigDecimal descontoMultaParcelamento = BigDecimal.ZERO;
    private BigDecimal descontoJurosParcelamento = BigDecimal.ZERO;
    private BigDecimal descontoJurosFinanParcelamento = BigDecimal.ZERO;
    private Boolean valorParaPagamento = Boolean.FALSE;
    private Long entidade;
    private Long exercicio;
    private LocalDate dataReferencia;
    private LocalDate dataLancamento;
    private LocalDate dataVencimento;
    private LocalDate dataPrimeiraParcela;
    private LocalDate dataVencimentoOriginal;
    private LocalDate dataVencimentoBoleto;
    private LocalDate dataCorrecaoIgpm;
    private Boolean aplicaDescontoCotaUnica;
    private DividaDTO divida;
    private String tributo;
    private String classificacaoTributo;
    private Long classificacaoTipoTributo;
    private Long formaPagamento;
    private Long formaCorrecao;
    private SituacaoLegal situacaoLegal;
    private Boolean parcelado;
    private Boolean calculaValorDesconto = Boolean.TRUE;
    private Boolean ignorarIndiceCorrecaoNaoLocalizado = Boolean.FALSE;
    private Long idDebitoParcelaTributo;

    public static AcrescimoDTO of(LoteCdaItemDetalhe loteCdaItemDetalhe, Long formaPagamentoPadrao) {
        return AcrescimoDTO.builder().exercicio(loteCdaItemDetalhe.getParcelaTributo().getExercicio()).dataLancamento(loteCdaItemDetalhe.getParcelaTributo().getDebitoParcela().getDebito().getDataLancamento()).dataPrimeiraParcela(loteCdaItemDetalhe.getParcelaTributo().getDebitoParcela().getDebito().getDataPrimeiraParcela()).dataVencimento(loteCdaItemDetalhe.getParcelaTributo().getDebitoParcela().getDataVencimento()).dataCorrecaoIgpm(loteCdaItemDetalhe.getParcelaTributo().getDebitoParcela().getDebito().getDataCorrecaoIgpm()).formaCorrecao(loteCdaItemDetalhe.getParcelaTributo().getDebitoParcela().getDebito().getFormaCorrecao().getId()).parcelado(Boolean.valueOf(loteCdaItemDetalhe.getParcelaTributo().getDebitoParcela().getDebito().getParcelado() != false || loteCdaItemDetalhe.getParcelaTributo().getDebitoParcela().getDebito().getReparcelado() != false)).situacaoLegal(loteCdaItemDetalhe.getParcelaTributo().getDebitoParcela().getSituacaoLegal()).tributo(loteCdaItemDetalhe.getParcelaTributo().getTributo()).valor(loteCdaItemDetalhe.getParcelaTributo().getValor()).formaPagamento(formaPagamentoPadrao).divida(DividaDTO.of((Divida)loteCdaItemDetalhe.getParcelaTributo().getDebitoParcela().getDebito().getDivida())).build();
    }

    public static AcrescimoDTO of(DebitoParcelaTributo debitoParcelaTributo, Long formaPagamentoPadrao) {
        return AcrescimoDTO.builder().exercicio(debitoParcelaTributo.getExercicio()).dataLancamento(debitoParcelaTributo.getDebitoParcela().getDebito().getDataLancamento()).dataPrimeiraParcela(debitoParcelaTributo.getDebitoParcela().getDebito().getDataPrimeiraParcela()).dataVencimento(debitoParcelaTributo.getDebitoParcela().getDataVencimento()).dataCorrecaoIgpm(debitoParcelaTributo.getDebitoParcela().getDebito().getDataCorrecaoIgpm()).formaCorrecao(debitoParcelaTributo.getDebitoParcela().getDebito().getFormaCorrecao().getId()).parcelado(Boolean.valueOf(debitoParcelaTributo.getDebitoParcela().getDebito().getParcelado() != false || debitoParcelaTributo.getDebitoParcela().getDebito().getReparcelado() != false)).situacaoLegal(debitoParcelaTributo.getDebitoParcela().getSituacaoLegal()).tributo(debitoParcelaTributo.getTributo()).valor(debitoParcelaTributo.getValor()).formaPagamento(formaPagamentoPadrao).divida(DividaDTO.of((Divida)debitoParcelaTributo.getDebitoParcela().getDebito().getDivida())).build();
    }

    public static AcrescimoDTO of(DevolucaoCreditoDebito debito, LocalDate dataCorrecao, Long formaPagamento, Long formaCorrecao) {
        AcrescimoDTO acrescimo = AcrescimoDTO.of((DebitoParcelaTributo)debito.getDebitoParcelaTributo(), (Long)formaPagamento);
        acrescimo.setIdDebitoParcelaTributo(debito.getDebitoParcelaTributo().getId());
        acrescimo.setEntidade(debito.getDebitoParcelaTributo().getEntidade());
        acrescimo.setDataReferencia(dataCorrecao);
        acrescimo.setFormaCorrecao(formaCorrecao);
        acrescimo.setCalculaValorDesconto(Boolean.FALSE);
        acrescimo.setValor(debito.getValorDevolvido());
        return acrescimo;
    }

    public static AcrescimoDTO of(AcrescimoCdaDTO acrescimoCdaDTO, Long formaPagamentoPadrao, LocalDate dataReferencia) {
        DividaDTO dividaDTO = new DividaDTO();
        dividaDTO.setEntidade(acrescimoCdaDTO.getEntidade());
        dividaDTO.setExercicio(acrescimoCdaDTO.getExercicio());
        dividaDTO.setDivida(acrescimoCdaDTO.getIdDivida());
        return AcrescimoDTO.builder().entidade(acrescimoCdaDTO.getEntidade()).exercicio(acrescimoCdaDTO.getExercicio()).dataLancamento(acrescimoCdaDTO.getDataLancamento()).dataPrimeiraParcela(acrescimoCdaDTO.getDataPrimeiraParcela()).dataVencimento(acrescimoCdaDTO.getDataVencimento()).dataReferencia(dataReferencia).dataCorrecaoIgpm(acrescimoCdaDTO.getDataCorrecaoIgpm()).formaCorrecao(acrescimoCdaDTO.getFormaCorrecao()).parcelado(acrescimoCdaDTO.getParcelado()).situacaoLegal(acrescimoCdaDTO.getSituacaoLegal()).tributo(acrescimoCdaDTO.getTributo()).valor(acrescimoCdaDTO.getValor()).formaPagamento(formaPagamentoPadrao).divida(dividaDTO).calculaValorDesconto(acrescimoCdaDTO.getCalculaValorDesconto()).build();
    }

    public static AcrescimoDTO of(DebitoManualDTO debitoManualDTO, DebitoManualTributoDTO debitoTributo, Long formaPagamentoPadrao, Long entidade) {
        DividaDTO dividaDTO = new DividaDTO();
        dividaDTO.setEntidade(entidade);
        dividaDTO.setExercicio(debitoManualDTO.getExercicio());
        dividaDTO.setDivida(debitoManualDTO.getDivida());
        DebitoManualParcelaDTO debitoManualParcelaDTO = debitoManualDTO.getParcelas().stream().findFirst().orElse(new DebitoManualParcelaDTO());
        return AcrescimoDTO.builder().entidade(entidade).exercicio(debitoManualDTO.getExercicio()).dataLancamento(debitoManualDTO.getDataLancamento()).dataPrimeiraParcela(debitoManualParcelaDTO.getDataVencimento()).dataVencimento(debitoManualParcelaDTO.getDataVencimento()).dataReferencia(debitoManualDTO.getDataLancamento()).formaCorrecao(debitoManualDTO.getFormaCorrecao()).parcelado(Boolean.FALSE).situacaoLegal(SituacaoLegal.DIVIDA_ATIVA).tributo(debitoTributo.getTributo()).valor(debitoTributo.getValorTributo()).formaPagamento(formaPagamentoPadrao).divida(dividaDTO).calculaValorDesconto(Boolean.FALSE).build();
    }

    public static AcrescimoDTO of(GeraLivroDebitoParcelaTributoDTO livroParcelaTributoDTO, Divida divida, Long formaPagamentoPadrao) {
        return AcrescimoDTO.builder().entidade(livroParcelaTributoDTO.getEntidade()).exercicio(livroParcelaTributoDTO.getExercicio()).dataLancamento(livroParcelaTributoDTO.getDataLancamento()).dataPrimeiraParcela(livroParcelaTributoDTO.getDataPrimeiraParcela()).dataVencimento(livroParcelaTributoDTO.getDataVencimento()).dataCorrecaoIgpm(livroParcelaTributoDTO.getDataCorrecaoIgpm()).formaCorrecao(livroParcelaTributoDTO.getFormaCorrecao()).parcelado(Boolean.valueOf(livroParcelaTributoDTO.getParcelado() != false || livroParcelaTributoDTO.getReparcelado() != false)).situacaoLegal(SituacaoLegal.DIVIDA_ATIVA).tributo(livroParcelaTributoDTO.getTributo()).valor(livroParcelaTributoDTO.getValor()).formaPagamento(formaPagamentoPadrao).divida(DividaDTO.of((Divida)divida)).build();
    }

    public static AcrescimoDTO of(DebitoConstituidoItemDTO debitoConstituido, Long formaPagamentoPadrao, LocalDate dataReferencia) {
        DividaDTO divida = new DividaDTO();
        divida.setEntidade(debitoConstituido.getEntidade());
        divida.setExercicio(debitoConstituido.getExercicio());
        divida.setDivida(debitoConstituido.getDivida());
        return AcrescimoDTO.builder().valor(debitoConstituido.getValor()).valorJuros(debitoConstituido.getValorJuros()).valorMulta(debitoConstituido.getValorMulta()).valorCorrecao(debitoConstituido.getValorCorrecao()).entidade(debitoConstituido.getEntidade()).exercicio(debitoConstituido.getExercicio()).dataReferencia(dataReferencia).dataLancamento(debitoConstituido.getDataLancamento()).dataVencimento(debitoConstituido.getDataVencimento()).dataPrimeiraParcela(debitoConstituido.getDataPrimeiraParcela()).dataCorrecaoIgpm(debitoConstituido.getDataCorrecaoIgpm()).divida(divida).tributo(debitoConstituido.getTributo()).formaPagamento(formaPagamentoPadrao).formaCorrecao(debitoConstituido.getFormaCorrecao()).situacaoLegal(SituacaoLegal.fromValue((Integer)debitoConstituido.getSituacaoLegal().intValue())).parcelado(Boolean.valueOf(debitoConstituido.getParcelado() != false || debitoConstituido.getReparcelado() != false)).calculaValorDesconto(Boolean.FALSE).build();
    }

    public static AcrescimoDTO of(CalculaAcrescimoBaseDTO extratoDebitoDTO, Long formaPagamento, LocalDate dataReferencia, Boolean valorParaPagamento) {
        AcrescimoDTO acrescimoDTO = new AcrescimoDTO();
        acrescimoDTO.setValor(extratoDebitoDTO.getValorPrincipal());
        acrescimoDTO.setEntidade(extratoDebitoDTO.getEntidade());
        acrescimoDTO.setExercicio(extratoDebitoDTO.getExercicio());
        acrescimoDTO.setDataReferencia(dataReferencia);
        acrescimoDTO.setDataLancamento(extratoDebitoDTO.getDataLancamento());
        acrescimoDTO.setDataVencimento(extratoDebitoDTO.getDataVencimento());
        acrescimoDTO.setDataPrimeiraParcela(extratoDebitoDTO.getDataPrimeiraParcela());
        acrescimoDTO.setDataCorrecaoIgpm(extratoDebitoDTO.getDataCorrecaoIgpm());
        acrescimoDTO.setAplicaDescontoCotaUnica(extratoDebitoDTO.getAplicaDescontoCotaUnica());
        acrescimoDTO.setDescontoParcelamento(Optional.ofNullable(extratoDebitoDTO.getDescontoParcelamento()).orElse(BigDecimal.ZERO));
        acrescimoDTO.setDescontoMultaParcelamento(Optional.ofNullable(extratoDebitoDTO.getDescontoMultaParcelamento()).orElse(BigDecimal.ZERO));
        acrescimoDTO.setDescontoJurosParcelamento(Optional.ofNullable(extratoDebitoDTO.getDescontoJurosParcelamento()).orElse(BigDecimal.ZERO));
        acrescimoDTO.setDescontoJurosFinanParcelamento(Optional.ofNullable(extratoDebitoDTO.getDescontoJurosFinanParcelamento()).orElse(BigDecimal.ZERO));
        acrescimoDTO.setValorParaPagamento(valorParaPagamento);
        DividaDTO dividaDTO = new DividaDTO();
        dividaDTO.setDivida(extratoDebitoDTO.getDivida());
        acrescimoDTO.setDivida(dividaDTO);
        acrescimoDTO.setTributo(extratoDebitoDTO.getTributo());
        acrescimoDTO.setClassificacaoTributo(extratoDebitoDTO.getClassificacaoTributo());
        acrescimoDTO.setClassificacaoTipoTributo(extratoDebitoDTO.getClassificacaoTipoTributo());
        acrescimoDTO.setFormaPagamento(formaPagamento);
        acrescimoDTO.setFormaCorrecao(extratoDebitoDTO.getFormaCorrecao());
        acrescimoDTO.setSituacaoLegal(SituacaoLegal.fromValue((Integer)extratoDebitoDTO.getSituacaoLegal()));
        acrescimoDTO.setParcelado(Boolean.valueOf(extratoDebitoDTO.getParcelado() != false || extratoDebitoDTO.getReparcelado() != false));
        acrescimoDTO.setIgnorarIndiceCorrecaoNaoLocalizado(extratoDebitoDTO.getIgnorarIndiceCorrecaoNaoLocalizado());
        return acrescimoDTO;
    }

    public static AcrescimoDTO of(DebitoGeracaoDividaAtivaAvulsaDTO debito, Long formaPagamentoPadrao, DividaDTO dividaDTO) {
        return AcrescimoDTO.builder().exercicio(debito.getExercicio()).dataLancamento(debito.getDataLancamento()).dataPrimeiraParcela(debito.getDataPrimeiraParcela()).dataCorrecaoIgpm(debito.getDataCorrecaoIgpm()).dataVencimento(debito.getDataVencimento()).formaCorrecao(debito.getFormaCorrecao()).parcelado(debito.getParcelado()).situacaoLegal(debito.getSituacaoLegal()).tributo(debito.getReceita()).valor(debito.getValor()).formaPagamento(formaPagamentoPadrao).divida(dividaDTO).build();
    }

    public static AcrescimoDTO of(RastreamentoDebitoDTO debito, Long formaPagamentoPadrao, LocalDate dataReferencia) {
        DividaDTO dividaDTO = new DividaDTO();
        dividaDTO.setEntidade(debito.getEntidade());
        dividaDTO.setExercicio(debito.getExercicio());
        dividaDTO.setDivida(debito.getDivida());
        return AcrescimoDTO.builder().entidade(debito.getEntidade()).exercicio(debito.getExercicio()).dataReferencia(dataReferencia).dataLancamento(debito.getDataLancamento()).dataPrimeiraParcela(debito.getDataPrimeiraParcela()).dataCorrecaoIgpm(debito.getDataCorrecaoIgpm()).dataVencimento(debito.getDataVencimento()).formaCorrecao(debito.getFormaCorrecao()).parcelado(debito.getParcelado()).situacaoLegal(debito.getSituacaoLegal()).tributo(debito.getReceita()).valor(debito.getValor()).idDebitoParcelaTributo(debito.getIdDebitoParcelaTributo()).formaPagamento(formaPagamentoPadrao).divida(dividaDTO).calculaValorDesconto(Boolean.FALSE).build();
    }

    public BigDecimal getValorDesconto() {
        this.valorDesconto = this.valorDescontoPrincipal.add(this.valorDescontoCorrecao).add(this.valorDescontoMulta).add(this.valorDescontoJuros).add(this.valorDescontoJurosFinan);
        return this.valorDesconto;
    }

    public BigDecimal getValorTotal() {
        this.valorTotal = this.valor.add(this.valorCorrecao).add(this.valorMulta).add(this.valorJuros).add(this.valorHonorario).subtract(this.getValorDesconto());
        return this.valorTotal;
    }

    public LocalDate getDataBaseIndiceAcumulado(TipoJuros tipoJuros) {
        return Boolean.TRUE.equals(this.parcelado) && Objects.nonNull(this.dataPrimeiraParcela) ? (TipoJuros.UNICO_NA_PARCELA.equals((Object)tipoJuros) ? DateUtils.menorData((LocalDate[])new LocalDate[]{this.dataLancamento, this.dataPrimeiraParcela}) : this.dataPrimeiraParcela) : this.dataVencimento;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public AcrescimoDTO() {
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public BigDecimal getValorOriginal() {
        return this.valorOriginal;
    }

    @Generated
    public BigDecimal getValorCorrecao() {
        return this.valorCorrecao;
    }

    @Generated
    public BigDecimal getValorMulta() {
        return this.valorMulta;
    }

    @Generated
    public BigDecimal getValorJuros() {
        return this.valorJuros;
    }

    @Generated
    public BigDecimal getValorHonorario() {
        return this.valorHonorario;
    }

    @Generated
    public BigDecimal getValorDescontoPrincipal() {
        return this.valorDescontoPrincipal;
    }

    @Generated
    public BigDecimal getValorDescontoCorrecao() {
        return this.valorDescontoCorrecao;
    }

    @Generated
    public BigDecimal getValorDescontoMulta() {
        return this.valorDescontoMulta;
    }

    @Generated
    public BigDecimal getValorDescontoJuros() {
        return this.valorDescontoJuros;
    }

    @Generated
    public BigDecimal getValorDescontoJurosFinan() {
        return this.valorDescontoJurosFinan;
    }

    @Generated
    public BigDecimal getDescontoParcelamento() {
        return this.descontoParcelamento;
    }

    @Generated
    public BigDecimal getDescontoMultaParcelamento() {
        return this.descontoMultaParcelamento;
    }

    @Generated
    public BigDecimal getDescontoJurosParcelamento() {
        return this.descontoJurosParcelamento;
    }

    @Generated
    public BigDecimal getDescontoJurosFinanParcelamento() {
        return this.descontoJurosFinanParcelamento;
    }

    @Generated
    public Boolean getValorParaPagamento() {
        return this.valorParaPagamento;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public LocalDate getDataReferencia() {
        return this.dataReferencia;
    }

    @Generated
    public LocalDate getDataLancamento() {
        return this.dataLancamento;
    }

    @Generated
    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public LocalDate getDataPrimeiraParcela() {
        return this.dataPrimeiraParcela;
    }

    @Generated
    public LocalDate getDataVencimentoOriginal() {
        return this.dataVencimentoOriginal;
    }

    @Generated
    public LocalDate getDataVencimentoBoleto() {
        return this.dataVencimentoBoleto;
    }

    @Generated
    public LocalDate getDataCorrecaoIgpm() {
        return this.dataCorrecaoIgpm;
    }

    @Generated
    public Boolean getAplicaDescontoCotaUnica() {
        return this.aplicaDescontoCotaUnica;
    }

    @Generated
    public DividaDTO getDivida() {
        return this.divida;
    }

    @Generated
    public String getTributo() {
        return this.tributo;
    }

    @Generated
    public String getClassificacaoTributo() {
        return this.classificacaoTributo;
    }

    @Generated
    public Long getClassificacaoTipoTributo() {
        return this.classificacaoTipoTributo;
    }

    @Generated
    public Long getFormaPagamento() {
        return this.formaPagamento;
    }

    @Generated
    public Long getFormaCorrecao() {
        return this.formaCorrecao;
    }

    @Generated
    public SituacaoLegal getSituacaoLegal() {
        return this.situacaoLegal;
    }

    @Generated
    public Boolean getParcelado() {
        return this.parcelado;
    }

    @Generated
    public Boolean getCalculaValorDesconto() {
        return this.calculaValorDesconto;
    }

    @Generated
    public Boolean getIgnorarIndiceCorrecaoNaoLocalizado() {
        return this.ignorarIndiceCorrecaoNaoLocalizado;
    }

    @Generated
    public Long getIdDebitoParcelaTributo() {
        return this.idDebitoParcelaTributo;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setValorOriginal(BigDecimal valorOriginal) {
        this.valorOriginal = valorOriginal;
    }

    @Generated
    public void setValorCorrecao(BigDecimal valorCorrecao) {
        this.valorCorrecao = valorCorrecao;
    }

    @Generated
    public void setValorMulta(BigDecimal valorMulta) {
        this.valorMulta = valorMulta;
    }

    @Generated
    public void setValorJuros(BigDecimal valorJuros) {
        this.valorJuros = valorJuros;
    }

    @Generated
    public void setValorHonorario(BigDecimal valorHonorario) {
        this.valorHonorario = valorHonorario;
    }

    @Generated
    public void setValorDescontoPrincipal(BigDecimal valorDescontoPrincipal) {
        this.valorDescontoPrincipal = valorDescontoPrincipal;
    }

    @Generated
    public void setValorDescontoCorrecao(BigDecimal valorDescontoCorrecao) {
        this.valorDescontoCorrecao = valorDescontoCorrecao;
    }

    @Generated
    public void setValorDescontoMulta(BigDecimal valorDescontoMulta) {
        this.valorDescontoMulta = valorDescontoMulta;
    }

    @Generated
    public void setValorDescontoJuros(BigDecimal valorDescontoJuros) {
        this.valorDescontoJuros = valorDescontoJuros;
    }

    @Generated
    public void setValorDescontoJurosFinan(BigDecimal valorDescontoJurosFinan) {
        this.valorDescontoJurosFinan = valorDescontoJurosFinan;
    }

    @Generated
    public void setValorDesconto(BigDecimal valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    @Generated
    public void setValorTotal(BigDecimal valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Generated
    public void setDescontoParcelamento(BigDecimal descontoParcelamento) {
        this.descontoParcelamento = descontoParcelamento;
    }

    @Generated
    public void setDescontoMultaParcelamento(BigDecimal descontoMultaParcelamento) {
        this.descontoMultaParcelamento = descontoMultaParcelamento;
    }

    @Generated
    public void setDescontoJurosParcelamento(BigDecimal descontoJurosParcelamento) {
        this.descontoJurosParcelamento = descontoJurosParcelamento;
    }

    @Generated
    public void setDescontoJurosFinanParcelamento(BigDecimal descontoJurosFinanParcelamento) {
        this.descontoJurosFinanParcelamento = descontoJurosFinanParcelamento;
    }

    @Generated
    public void setValorParaPagamento(Boolean valorParaPagamento) {
        this.valorParaPagamento = valorParaPagamento;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setDataReferencia(LocalDate dataReferencia) {
        this.dataReferencia = dataReferencia;
    }

    @Generated
    public void setDataLancamento(LocalDate dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    @Generated
    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Generated
    public void setDataPrimeiraParcela(LocalDate dataPrimeiraParcela) {
        this.dataPrimeiraParcela = dataPrimeiraParcela;
    }

    @Generated
    public void setDataVencimentoOriginal(LocalDate dataVencimentoOriginal) {
        this.dataVencimentoOriginal = dataVencimentoOriginal;
    }

    @Generated
    public void setDataVencimentoBoleto(LocalDate dataVencimentoBoleto) {
        this.dataVencimentoBoleto = dataVencimentoBoleto;
    }

    @Generated
    public void setDataCorrecaoIgpm(LocalDate dataCorrecaoIgpm) {
        this.dataCorrecaoIgpm = dataCorrecaoIgpm;
    }

    @Generated
    public void setAplicaDescontoCotaUnica(Boolean aplicaDescontoCotaUnica) {
        this.aplicaDescontoCotaUnica = aplicaDescontoCotaUnica;
    }

    @Generated
    public void setDivida(DividaDTO divida) {
        this.divida = divida;
    }

    @Generated
    public void setTributo(String tributo) {
        this.tributo = tributo;
    }

    @Generated
    public void setClassificacaoTributo(String classificacaoTributo) {
        this.classificacaoTributo = classificacaoTributo;
    }

    @Generated
    public void setClassificacaoTipoTributo(Long classificacaoTipoTributo) {
        this.classificacaoTipoTributo = classificacaoTipoTributo;
    }

    @Generated
    public void setFormaPagamento(Long formaPagamento) {
        this.formaPagamento = formaPagamento;
    }

    @Generated
    public void setFormaCorrecao(Long formaCorrecao) {
        this.formaCorrecao = formaCorrecao;
    }

    @Generated
    public void setSituacaoLegal(SituacaoLegal situacaoLegal) {
        this.situacaoLegal = situacaoLegal;
    }

    @Generated
    public void setParcelado(Boolean parcelado) {
        this.parcelado = parcelado;
    }

    @Generated
    public void setCalculaValorDesconto(Boolean calculaValorDesconto) {
        this.calculaValorDesconto = calculaValorDesconto;
    }

    @Generated
    public void setIgnorarIndiceCorrecaoNaoLocalizado(Boolean ignorarIndiceCorrecaoNaoLocalizado) {
        this.ignorarIndiceCorrecaoNaoLocalizado = ignorarIndiceCorrecaoNaoLocalizado;
    }

    @Generated
    public void setIdDebitoParcelaTributo(Long idDebitoParcelaTributo) {
        this.idDebitoParcelaTributo = idDebitoParcelaTributo;
    }

    @Generated
    public String toString() {
        return "AcrescimoDTO(valor=" + String.valueOf(this.getValor()) + ", valorOriginal=" + String.valueOf(this.getValorOriginal()) + ", valorCorrecao=" + String.valueOf(this.getValorCorrecao()) + ", valorMulta=" + String.valueOf(this.getValorMulta()) + ", valorJuros=" + String.valueOf(this.getValorJuros()) + ", valorHonorario=" + String.valueOf(this.getValorHonorario()) + ", valorDescontoPrincipal=" + String.valueOf(this.getValorDescontoPrincipal()) + ", valorDescontoCorrecao=" + String.valueOf(this.getValorDescontoCorrecao()) + ", valorDescontoMulta=" + String.valueOf(this.getValorDescontoMulta()) + ", valorDescontoJuros=" + String.valueOf(this.getValorDescontoJuros()) + ", valorDescontoJurosFinan=" + String.valueOf(this.getValorDescontoJurosFinan()) + ", valorDesconto=" + String.valueOf(this.getValorDesconto()) + ", valorTotal=" + String.valueOf(this.getValorTotal()) + ", descontoParcelamento=" + String.valueOf(this.getDescontoParcelamento()) + ", descontoMultaParcelamento=" + String.valueOf(this.getDescontoMultaParcelamento()) + ", descontoJurosParcelamento=" + String.valueOf(this.getDescontoJurosParcelamento()) + ", descontoJurosFinanParcelamento=" + String.valueOf(this.getDescontoJurosFinanParcelamento()) + ", valorParaPagamento=" + this.getValorParaPagamento() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", dataReferencia=" + String.valueOf(this.getDataReferencia()) + ", dataLancamento=" + String.valueOf(this.getDataLancamento()) + ", dataVencimento=" + String.valueOf(this.getDataVencimento()) + ", dataPrimeiraParcela=" + String.valueOf(this.getDataPrimeiraParcela()) + ", dataVencimentoOriginal=" + String.valueOf(this.getDataVencimentoOriginal()) + ", dataVencimentoBoleto=" + String.valueOf(this.getDataVencimentoBoleto()) + ", dataCorrecaoIgpm=" + String.valueOf(this.getDataCorrecaoIgpm()) + ", aplicaDescontoCotaUnica=" + this.getAplicaDescontoCotaUnica() + ", divida=" + String.valueOf(this.getDivida()) + ", tributo=" + this.getTributo() + ", classificacaoTributo=" + this.getClassificacaoTributo() + ", classificacaoTipoTributo=" + this.getClassificacaoTipoTributo() + ", formaPagamento=" + this.getFormaPagamento() + ", formaCorrecao=" + this.getFormaCorrecao() + ", situacaoLegal=" + String.valueOf(this.getSituacaoLegal()) + ", parcelado=" + this.getParcelado() + ", calculaValorDesconto=" + this.getCalculaValorDesconto() + ", ignorarIndiceCorrecaoNaoLocalizado=" + this.getIgnorarIndiceCorrecaoNaoLocalizado() + ", idDebitoParcelaTributo=" + this.getIdDebitoParcelaTributo() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AcrescimoDTO)) {
            return false;
        }
        AcrescimoDTO other = (AcrescimoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$valorParaPagamento = this.getValorParaPagamento();
        Boolean other$valorParaPagamento = other.getValorParaPagamento();
        if (this$valorParaPagamento == null ? other$valorParaPagamento != null : !((Object)this$valorParaPagamento).equals(other$valorParaPagamento)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Boolean this$aplicaDescontoCotaUnica = this.getAplicaDescontoCotaUnica();
        Boolean other$aplicaDescontoCotaUnica = other.getAplicaDescontoCotaUnica();
        if (this$aplicaDescontoCotaUnica == null ? other$aplicaDescontoCotaUnica != null : !((Object)this$aplicaDescontoCotaUnica).equals(other$aplicaDescontoCotaUnica)) {
            return false;
        }
        Long this$classificacaoTipoTributo = this.getClassificacaoTipoTributo();
        Long other$classificacaoTipoTributo = other.getClassificacaoTipoTributo();
        if (this$classificacaoTipoTributo == null ? other$classificacaoTipoTributo != null : !((Object)this$classificacaoTipoTributo).equals(other$classificacaoTipoTributo)) {
            return false;
        }
        Long this$formaPagamento = this.getFormaPagamento();
        Long other$formaPagamento = other.getFormaPagamento();
        if (this$formaPagamento == null ? other$formaPagamento != null : !((Object)this$formaPagamento).equals(other$formaPagamento)) {
            return false;
        }
        Long this$formaCorrecao = this.getFormaCorrecao();
        Long other$formaCorrecao = other.getFormaCorrecao();
        if (this$formaCorrecao == null ? other$formaCorrecao != null : !((Object)this$formaCorrecao).equals(other$formaCorrecao)) {
            return false;
        }
        Boolean this$parcelado = this.getParcelado();
        Boolean other$parcelado = other.getParcelado();
        if (this$parcelado == null ? other$parcelado != null : !((Object)this$parcelado).equals(other$parcelado)) {
            return false;
        }
        Boolean this$calculaValorDesconto = this.getCalculaValorDesconto();
        Boolean other$calculaValorDesconto = other.getCalculaValorDesconto();
        if (this$calculaValorDesconto == null ? other$calculaValorDesconto != null : !((Object)this$calculaValorDesconto).equals(other$calculaValorDesconto)) {
            return false;
        }
        Boolean this$ignorarIndiceCorrecaoNaoLocalizado = this.getIgnorarIndiceCorrecaoNaoLocalizado();
        Boolean other$ignorarIndiceCorrecaoNaoLocalizado = other.getIgnorarIndiceCorrecaoNaoLocalizado();
        if (this$ignorarIndiceCorrecaoNaoLocalizado == null ? other$ignorarIndiceCorrecaoNaoLocalizado != null : !((Object)this$ignorarIndiceCorrecaoNaoLocalizado).equals(other$ignorarIndiceCorrecaoNaoLocalizado)) {
            return false;
        }
        Long this$idDebitoParcelaTributo = this.getIdDebitoParcelaTributo();
        Long other$idDebitoParcelaTributo = other.getIdDebitoParcelaTributo();
        if (this$idDebitoParcelaTributo == null ? other$idDebitoParcelaTributo != null : !((Object)this$idDebitoParcelaTributo).equals(other$idDebitoParcelaTributo)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor)) {
            return false;
        }
        BigDecimal this$valorOriginal = this.getValorOriginal();
        BigDecimal other$valorOriginal = other.getValorOriginal();
        if (this$valorOriginal == null ? other$valorOriginal != null : !((Object)this$valorOriginal).equals(other$valorOriginal)) {
            return false;
        }
        BigDecimal this$valorCorrecao = this.getValorCorrecao();
        BigDecimal other$valorCorrecao = other.getValorCorrecao();
        if (this$valorCorrecao == null ? other$valorCorrecao != null : !((Object)this$valorCorrecao).equals(other$valorCorrecao)) {
            return false;
        }
        BigDecimal this$valorMulta = this.getValorMulta();
        BigDecimal other$valorMulta = other.getValorMulta();
        if (this$valorMulta == null ? other$valorMulta != null : !((Object)this$valorMulta).equals(other$valorMulta)) {
            return false;
        }
        BigDecimal this$valorJuros = this.getValorJuros();
        BigDecimal other$valorJuros = other.getValorJuros();
        if (this$valorJuros == null ? other$valorJuros != null : !((Object)this$valorJuros).equals(other$valorJuros)) {
            return false;
        }
        BigDecimal this$valorHonorario = this.getValorHonorario();
        BigDecimal other$valorHonorario = other.getValorHonorario();
        if (this$valorHonorario == null ? other$valorHonorario != null : !((Object)this$valorHonorario).equals(other$valorHonorario)) {
            return false;
        }
        BigDecimal this$valorDescontoPrincipal = this.getValorDescontoPrincipal();
        BigDecimal other$valorDescontoPrincipal = other.getValorDescontoPrincipal();
        if (this$valorDescontoPrincipal == null ? other$valorDescontoPrincipal != null : !((Object)this$valorDescontoPrincipal).equals(other$valorDescontoPrincipal)) {
            return false;
        }
        BigDecimal this$valorDescontoCorrecao = this.getValorDescontoCorrecao();
        BigDecimal other$valorDescontoCorrecao = other.getValorDescontoCorrecao();
        if (this$valorDescontoCorrecao == null ? other$valorDescontoCorrecao != null : !((Object)this$valorDescontoCorrecao).equals(other$valorDescontoCorrecao)) {
            return false;
        }
        BigDecimal this$valorDescontoMulta = this.getValorDescontoMulta();
        BigDecimal other$valorDescontoMulta = other.getValorDescontoMulta();
        if (this$valorDescontoMulta == null ? other$valorDescontoMulta != null : !((Object)this$valorDescontoMulta).equals(other$valorDescontoMulta)) {
            return false;
        }
        BigDecimal this$valorDescontoJuros = this.getValorDescontoJuros();
        BigDecimal other$valorDescontoJuros = other.getValorDescontoJuros();
        if (this$valorDescontoJuros == null ? other$valorDescontoJuros != null : !((Object)this$valorDescontoJuros).equals(other$valorDescontoJuros)) {
            return false;
        }
        BigDecimal this$valorDescontoJurosFinan = this.getValorDescontoJurosFinan();
        BigDecimal other$valorDescontoJurosFinan = other.getValorDescontoJurosFinan();
        if (this$valorDescontoJurosFinan == null ? other$valorDescontoJurosFinan != null : !((Object)this$valorDescontoJurosFinan).equals(other$valorDescontoJurosFinan)) {
            return false;
        }
        BigDecimal this$valorDesconto = this.getValorDesconto();
        BigDecimal other$valorDesconto = other.getValorDesconto();
        if (this$valorDesconto == null ? other$valorDesconto != null : !((Object)this$valorDesconto).equals(other$valorDesconto)) {
            return false;
        }
        BigDecimal this$valorTotal = this.getValorTotal();
        BigDecimal other$valorTotal = other.getValorTotal();
        if (this$valorTotal == null ? other$valorTotal != null : !((Object)this$valorTotal).equals(other$valorTotal)) {
            return false;
        }
        BigDecimal this$descontoParcelamento = this.getDescontoParcelamento();
        BigDecimal other$descontoParcelamento = other.getDescontoParcelamento();
        if (this$descontoParcelamento == null ? other$descontoParcelamento != null : !((Object)this$descontoParcelamento).equals(other$descontoParcelamento)) {
            return false;
        }
        BigDecimal this$descontoMultaParcelamento = this.getDescontoMultaParcelamento();
        BigDecimal other$descontoMultaParcelamento = other.getDescontoMultaParcelamento();
        if (this$descontoMultaParcelamento == null ? other$descontoMultaParcelamento != null : !((Object)this$descontoMultaParcelamento).equals(other$descontoMultaParcelamento)) {
            return false;
        }
        BigDecimal this$descontoJurosParcelamento = this.getDescontoJurosParcelamento();
        BigDecimal other$descontoJurosParcelamento = other.getDescontoJurosParcelamento();
        if (this$descontoJurosParcelamento == null ? other$descontoJurosParcelamento != null : !((Object)this$descontoJurosParcelamento).equals(other$descontoJurosParcelamento)) {
            return false;
        }
        BigDecimal this$descontoJurosFinanParcelamento = this.getDescontoJurosFinanParcelamento();
        BigDecimal other$descontoJurosFinanParcelamento = other.getDescontoJurosFinanParcelamento();
        if (this$descontoJurosFinanParcelamento == null ? other$descontoJurosFinanParcelamento != null : !((Object)this$descontoJurosFinanParcelamento).equals(other$descontoJurosFinanParcelamento)) {
            return false;
        }
        LocalDate this$dataReferencia = this.getDataReferencia();
        LocalDate other$dataReferencia = other.getDataReferencia();
        if (this$dataReferencia == null ? other$dataReferencia != null : !((Object)this$dataReferencia).equals(other$dataReferencia)) {
            return false;
        }
        LocalDate this$dataLancamento = this.getDataLancamento();
        LocalDate other$dataLancamento = other.getDataLancamento();
        if (this$dataLancamento == null ? other$dataLancamento != null : !((Object)this$dataLancamento).equals(other$dataLancamento)) {
            return false;
        }
        LocalDate this$dataVencimento = this.getDataVencimento();
        LocalDate other$dataVencimento = other.getDataVencimento();
        if (this$dataVencimento == null ? other$dataVencimento != null : !((Object)this$dataVencimento).equals(other$dataVencimento)) {
            return false;
        }
        LocalDate this$dataPrimeiraParcela = this.getDataPrimeiraParcela();
        LocalDate other$dataPrimeiraParcela = other.getDataPrimeiraParcela();
        if (this$dataPrimeiraParcela == null ? other$dataPrimeiraParcela != null : !((Object)this$dataPrimeiraParcela).equals(other$dataPrimeiraParcela)) {
            return false;
        }
        LocalDate this$dataVencimentoOriginal = this.getDataVencimentoOriginal();
        LocalDate other$dataVencimentoOriginal = other.getDataVencimentoOriginal();
        if (this$dataVencimentoOriginal == null ? other$dataVencimentoOriginal != null : !((Object)this$dataVencimentoOriginal).equals(other$dataVencimentoOriginal)) {
            return false;
        }
        LocalDate this$dataVencimentoBoleto = this.getDataVencimentoBoleto();
        LocalDate other$dataVencimentoBoleto = other.getDataVencimentoBoleto();
        if (this$dataVencimentoBoleto == null ? other$dataVencimentoBoleto != null : !((Object)this$dataVencimentoBoleto).equals(other$dataVencimentoBoleto)) {
            return false;
        }
        LocalDate this$dataCorrecaoIgpm = this.getDataCorrecaoIgpm();
        LocalDate other$dataCorrecaoIgpm = other.getDataCorrecaoIgpm();
        if (this$dataCorrecaoIgpm == null ? other$dataCorrecaoIgpm != null : !((Object)this$dataCorrecaoIgpm).equals(other$dataCorrecaoIgpm)) {
            return false;
        }
        DividaDTO this$divida = this.getDivida();
        DividaDTO other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !this$divida.equals(other$divida)) {
            return false;
        }
        String this$tributo = this.getTributo();
        String other$tributo = other.getTributo();
        if (this$tributo == null ? other$tributo != null : !this$tributo.equals(other$tributo)) {
            return false;
        }
        String this$classificacaoTributo = this.getClassificacaoTributo();
        String other$classificacaoTributo = other.getClassificacaoTributo();
        if (this$classificacaoTributo == null ? other$classificacaoTributo != null : !this$classificacaoTributo.equals(other$classificacaoTributo)) {
            return false;
        }
        SituacaoLegal this$situacaoLegal = this.getSituacaoLegal();
        SituacaoLegal other$situacaoLegal = other.getSituacaoLegal();
        return !(this$situacaoLegal == null ? other$situacaoLegal != null : !this$situacaoLegal.equals(other$situacaoLegal));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AcrescimoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $valorParaPagamento = this.getValorParaPagamento();
        result = result * 59 + ($valorParaPagamento == null ? 43 : ((Object)$valorParaPagamento).hashCode());
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Boolean $aplicaDescontoCotaUnica = this.getAplicaDescontoCotaUnica();
        result = result * 59 + ($aplicaDescontoCotaUnica == null ? 43 : ((Object)$aplicaDescontoCotaUnica).hashCode());
        Long $classificacaoTipoTributo = this.getClassificacaoTipoTributo();
        result = result * 59 + ($classificacaoTipoTributo == null ? 43 : ((Object)$classificacaoTipoTributo).hashCode());
        Long $formaPagamento = this.getFormaPagamento();
        result = result * 59 + ($formaPagamento == null ? 43 : ((Object)$formaPagamento).hashCode());
        Long $formaCorrecao = this.getFormaCorrecao();
        result = result * 59 + ($formaCorrecao == null ? 43 : ((Object)$formaCorrecao).hashCode());
        Boolean $parcelado = this.getParcelado();
        result = result * 59 + ($parcelado == null ? 43 : ((Object)$parcelado).hashCode());
        Boolean $calculaValorDesconto = this.getCalculaValorDesconto();
        result = result * 59 + ($calculaValorDesconto == null ? 43 : ((Object)$calculaValorDesconto).hashCode());
        Boolean $ignorarIndiceCorrecaoNaoLocalizado = this.getIgnorarIndiceCorrecaoNaoLocalizado();
        result = result * 59 + ($ignorarIndiceCorrecaoNaoLocalizado == null ? 43 : ((Object)$ignorarIndiceCorrecaoNaoLocalizado).hashCode());
        Long $idDebitoParcelaTributo = this.getIdDebitoParcelaTributo();
        result = result * 59 + ($idDebitoParcelaTributo == null ? 43 : ((Object)$idDebitoParcelaTributo).hashCode());
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        BigDecimal $valorOriginal = this.getValorOriginal();
        result = result * 59 + ($valorOriginal == null ? 43 : ((Object)$valorOriginal).hashCode());
        BigDecimal $valorCorrecao = this.getValorCorrecao();
        result = result * 59 + ($valorCorrecao == null ? 43 : ((Object)$valorCorrecao).hashCode());
        BigDecimal $valorMulta = this.getValorMulta();
        result = result * 59 + ($valorMulta == null ? 43 : ((Object)$valorMulta).hashCode());
        BigDecimal $valorJuros = this.getValorJuros();
        result = result * 59 + ($valorJuros == null ? 43 : ((Object)$valorJuros).hashCode());
        BigDecimal $valorHonorario = this.getValorHonorario();
        result = result * 59 + ($valorHonorario == null ? 43 : ((Object)$valorHonorario).hashCode());
        BigDecimal $valorDescontoPrincipal = this.getValorDescontoPrincipal();
        result = result * 59 + ($valorDescontoPrincipal == null ? 43 : ((Object)$valorDescontoPrincipal).hashCode());
        BigDecimal $valorDescontoCorrecao = this.getValorDescontoCorrecao();
        result = result * 59 + ($valorDescontoCorrecao == null ? 43 : ((Object)$valorDescontoCorrecao).hashCode());
        BigDecimal $valorDescontoMulta = this.getValorDescontoMulta();
        result = result * 59 + ($valorDescontoMulta == null ? 43 : ((Object)$valorDescontoMulta).hashCode());
        BigDecimal $valorDescontoJuros = this.getValorDescontoJuros();
        result = result * 59 + ($valorDescontoJuros == null ? 43 : ((Object)$valorDescontoJuros).hashCode());
        BigDecimal $valorDescontoJurosFinan = this.getValorDescontoJurosFinan();
        result = result * 59 + ($valorDescontoJurosFinan == null ? 43 : ((Object)$valorDescontoJurosFinan).hashCode());
        BigDecimal $valorDesconto = this.getValorDesconto();
        result = result * 59 + ($valorDesconto == null ? 43 : ((Object)$valorDesconto).hashCode());
        BigDecimal $valorTotal = this.getValorTotal();
        result = result * 59 + ($valorTotal == null ? 43 : ((Object)$valorTotal).hashCode());
        BigDecimal $descontoParcelamento = this.getDescontoParcelamento();
        result = result * 59 + ($descontoParcelamento == null ? 43 : ((Object)$descontoParcelamento).hashCode());
        BigDecimal $descontoMultaParcelamento = this.getDescontoMultaParcelamento();
        result = result * 59 + ($descontoMultaParcelamento == null ? 43 : ((Object)$descontoMultaParcelamento).hashCode());
        BigDecimal $descontoJurosParcelamento = this.getDescontoJurosParcelamento();
        result = result * 59 + ($descontoJurosParcelamento == null ? 43 : ((Object)$descontoJurosParcelamento).hashCode());
        BigDecimal $descontoJurosFinanParcelamento = this.getDescontoJurosFinanParcelamento();
        result = result * 59 + ($descontoJurosFinanParcelamento == null ? 43 : ((Object)$descontoJurosFinanParcelamento).hashCode());
        LocalDate $dataReferencia = this.getDataReferencia();
        result = result * 59 + ($dataReferencia == null ? 43 : ((Object)$dataReferencia).hashCode());
        LocalDate $dataLancamento = this.getDataLancamento();
        result = result * 59 + ($dataLancamento == null ? 43 : ((Object)$dataLancamento).hashCode());
        LocalDate $dataVencimento = this.getDataVencimento();
        result = result * 59 + ($dataVencimento == null ? 43 : ((Object)$dataVencimento).hashCode());
        LocalDate $dataPrimeiraParcela = this.getDataPrimeiraParcela();
        result = result * 59 + ($dataPrimeiraParcela == null ? 43 : ((Object)$dataPrimeiraParcela).hashCode());
        LocalDate $dataVencimentoOriginal = this.getDataVencimentoOriginal();
        result = result * 59 + ($dataVencimentoOriginal == null ? 43 : ((Object)$dataVencimentoOriginal).hashCode());
        LocalDate $dataVencimentoBoleto = this.getDataVencimentoBoleto();
        result = result * 59 + ($dataVencimentoBoleto == null ? 43 : ((Object)$dataVencimentoBoleto).hashCode());
        LocalDate $dataCorrecaoIgpm = this.getDataCorrecaoIgpm();
        result = result * 59 + ($dataCorrecaoIgpm == null ? 43 : ((Object)$dataCorrecaoIgpm).hashCode());
        DividaDTO $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : $divida.hashCode());
        String $tributo = this.getTributo();
        result = result * 59 + ($tributo == null ? 43 : $tributo.hashCode());
        String $classificacaoTributo = this.getClassificacaoTributo();
        result = result * 59 + ($classificacaoTributo == null ? 43 : $classificacaoTributo.hashCode());
        SituacaoLegal $situacaoLegal = this.getSituacaoLegal();
        result = result * 59 + ($situacaoLegal == null ? 43 : $situacaoLegal.hashCode());
        return result;
    }
}

