/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.dto.SituacaoLegal;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public class RastreamentoDebitoDTO {
    private Long entidade;
    private Long exercicio;
    private Long idCadastro;
    private Long tipoCadastro;
    private Long cadastroGeral;
    private Long divida;
    private Long subDivida;
    private Long parcela;
    private LocalDate dataVencimento;
    private LocalDate dataVencimentoCotaUnica;
    private Long idContencioso;
    private Boolean recursoAdministrativo = false;
    private BigDecimal valor = BigDecimal.ZERO;
    private Boolean parcelado = false;
    private Boolean reparcelado = false;
    private LocalDate dataLancamento;
    private LocalDate dataPrimeiraParcela;
    private LocalDate dataCorrecaoIgpm;
    private Long formaCorrecao;
    private SituacaoLegal situacaoLegal;
    private String receita;
    private Long idDebitoParcelaTributo;

    public Boolean getVencido() {
        return Optional.ofNullable(this.dataVencimento).map(arg_0 -> this.isExpired(arg_0)).orElse(false);
    }

    public Boolean getAVencer() {
        return this.getVencido() == false;
    }

    private Boolean isExpired(LocalDate dataVencimento) {
        return LocalDate.now().isAfter(dataVencimento);
    }

    public Boolean existeParcelamento() {
        return this.parcelado != false || this.reparcelado != false;
    }

    public Boolean isVencimentoNoExercicio() {
        return Optional.ofNullable(this.dataVencimento).map(dt -> LocalDate.now().getYear() == dt.getYear()).orElse(false);
    }

    public Boolean isVencidoCotaUnica() {
        return Optional.ofNullable(this.dataVencimentoCotaUnica).map(arg_0 -> this.isExpired(arg_0)).orElse(false);
    }

    public boolean isAbertoPraCobranca() {
        return Objects.isNull(this.recursoAdministrativo) || this.recursoAdministrativo == false;
    }

    @Generated
    public RastreamentoDebitoDTO() {
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getIdCadastro() {
        return this.idCadastro;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getDivida() {
        return this.divida;
    }

    @Generated
    public Long getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public Long getParcela() {
        return this.parcela;
    }

    @Generated
    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public LocalDate getDataVencimentoCotaUnica() {
        return this.dataVencimentoCotaUnica;
    }

    @Generated
    public Long getIdContencioso() {
        return this.idContencioso;
    }

    @Generated
    public Boolean getRecursoAdministrativo() {
        return this.recursoAdministrativo;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public Boolean getParcelado() {
        return this.parcelado;
    }

    @Generated
    public Boolean getReparcelado() {
        return this.reparcelado;
    }

    @Generated
    public LocalDate getDataLancamento() {
        return this.dataLancamento;
    }

    @Generated
    public LocalDate getDataPrimeiraParcela() {
        return this.dataPrimeiraParcela;
    }

    @Generated
    public LocalDate getDataCorrecaoIgpm() {
        return this.dataCorrecaoIgpm;
    }

    @Generated
    public Long getFormaCorrecao() {
        return this.formaCorrecao;
    }

    @Generated
    public SituacaoLegal getSituacaoLegal() {
        return this.situacaoLegal;
    }

    @Generated
    public String getReceita() {
        return this.receita;
    }

    @Generated
    public Long getIdDebitoParcelaTributo() {
        return this.idDebitoParcelaTributo;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setIdCadastro(Long idCadastro) {
        this.idCadastro = idCadastro;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setDivida(Long divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(Long subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setParcela(Long parcela) {
        this.parcela = parcela;
    }

    @Generated
    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Generated
    public void setDataVencimentoCotaUnica(LocalDate dataVencimentoCotaUnica) {
        this.dataVencimentoCotaUnica = dataVencimentoCotaUnica;
    }

    @Generated
    public void setIdContencioso(Long idContencioso) {
        this.idContencioso = idContencioso;
    }

    @Generated
    public void setRecursoAdministrativo(Boolean recursoAdministrativo) {
        this.recursoAdministrativo = recursoAdministrativo;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setParcelado(Boolean parcelado) {
        this.parcelado = parcelado;
    }

    @Generated
    public void setReparcelado(Boolean reparcelado) {
        this.reparcelado = reparcelado;
    }

    @Generated
    public void setDataLancamento(LocalDate dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    @Generated
    public void setDataPrimeiraParcela(LocalDate dataPrimeiraParcela) {
        this.dataPrimeiraParcela = dataPrimeiraParcela;
    }

    @Generated
    public void setDataCorrecaoIgpm(LocalDate dataCorrecaoIgpm) {
        this.dataCorrecaoIgpm = dataCorrecaoIgpm;
    }

    @Generated
    public void setFormaCorrecao(Long formaCorrecao) {
        this.formaCorrecao = formaCorrecao;
    }

    @Generated
    public void setSituacaoLegal(SituacaoLegal situacaoLegal) {
        this.situacaoLegal = situacaoLegal;
    }

    @Generated
    public void setReceita(String receita) {
        this.receita = receita;
    }

    @Generated
    public void setIdDebitoParcelaTributo(Long idDebitoParcelaTributo) {
        this.idDebitoParcelaTributo = idDebitoParcelaTributo;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RastreamentoDebitoDTO)) {
            return false;
        }
        RastreamentoDebitoDTO other = (RastreamentoDebitoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$idCadastro = this.getIdCadastro();
        Long other$idCadastro = other.getIdCadastro();
        if (this$idCadastro == null ? other$idCadastro != null : !((Object)this$idCadastro).equals(other$idCadastro)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$divida = this.getDivida();
        Long other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !((Object)this$divida).equals(other$divida)) {
            return false;
        }
        Long this$subDivida = this.getSubDivida();
        Long other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !((Object)this$subDivida).equals(other$subDivida)) {
            return false;
        }
        Long this$parcela = this.getParcela();
        Long other$parcela = other.getParcela();
        if (this$parcela == null ? other$parcela != null : !((Object)this$parcela).equals(other$parcela)) {
            return false;
        }
        Long this$idContencioso = this.getIdContencioso();
        Long other$idContencioso = other.getIdContencioso();
        if (this$idContencioso == null ? other$idContencioso != null : !((Object)this$idContencioso).equals(other$idContencioso)) {
            return false;
        }
        Boolean this$recursoAdministrativo = this.getRecursoAdministrativo();
        Boolean other$recursoAdministrativo = other.getRecursoAdministrativo();
        if (this$recursoAdministrativo == null ? other$recursoAdministrativo != null : !((Object)this$recursoAdministrativo).equals(other$recursoAdministrativo)) {
            return false;
        }
        Boolean this$parcelado = this.getParcelado();
        Boolean other$parcelado = other.getParcelado();
        if (this$parcelado == null ? other$parcelado != null : !((Object)this$parcelado).equals(other$parcelado)) {
            return false;
        }
        Boolean this$reparcelado = this.getReparcelado();
        Boolean other$reparcelado = other.getReparcelado();
        if (this$reparcelado == null ? other$reparcelado != null : !((Object)this$reparcelado).equals(other$reparcelado)) {
            return false;
        }
        Long this$formaCorrecao = this.getFormaCorrecao();
        Long other$formaCorrecao = other.getFormaCorrecao();
        if (this$formaCorrecao == null ? other$formaCorrecao != null : !((Object)this$formaCorrecao).equals(other$formaCorrecao)) {
            return false;
        }
        Long this$idDebitoParcelaTributo = this.getIdDebitoParcelaTributo();
        Long other$idDebitoParcelaTributo = other.getIdDebitoParcelaTributo();
        if (this$idDebitoParcelaTributo == null ? other$idDebitoParcelaTributo != null : !((Object)this$idDebitoParcelaTributo).equals(other$idDebitoParcelaTributo)) {
            return false;
        }
        LocalDate this$dataVencimento = this.getDataVencimento();
        LocalDate other$dataVencimento = other.getDataVencimento();
        if (this$dataVencimento == null ? other$dataVencimento != null : !((Object)this$dataVencimento).equals(other$dataVencimento)) {
            return false;
        }
        LocalDate this$dataVencimentoCotaUnica = this.getDataVencimentoCotaUnica();
        LocalDate other$dataVencimentoCotaUnica = other.getDataVencimentoCotaUnica();
        if (this$dataVencimentoCotaUnica == null ? other$dataVencimentoCotaUnica != null : !((Object)this$dataVencimentoCotaUnica).equals(other$dataVencimentoCotaUnica)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor)) {
            return false;
        }
        LocalDate this$dataLancamento = this.getDataLancamento();
        LocalDate other$dataLancamento = other.getDataLancamento();
        if (this$dataLancamento == null ? other$dataLancamento != null : !((Object)this$dataLancamento).equals(other$dataLancamento)) {
            return false;
        }
        LocalDate this$dataPrimeiraParcela = this.getDataPrimeiraParcela();
        LocalDate other$dataPrimeiraParcela = other.getDataPrimeiraParcela();
        if (this$dataPrimeiraParcela == null ? other$dataPrimeiraParcela != null : !((Object)this$dataPrimeiraParcela).equals(other$dataPrimeiraParcela)) {
            return false;
        }
        LocalDate this$dataCorrecaoIgpm = this.getDataCorrecaoIgpm();
        LocalDate other$dataCorrecaoIgpm = other.getDataCorrecaoIgpm();
        if (this$dataCorrecaoIgpm == null ? other$dataCorrecaoIgpm != null : !((Object)this$dataCorrecaoIgpm).equals(other$dataCorrecaoIgpm)) {
            return false;
        }
        SituacaoLegal this$situacaoLegal = this.getSituacaoLegal();
        SituacaoLegal other$situacaoLegal = other.getSituacaoLegal();
        if (this$situacaoLegal == null ? other$situacaoLegal != null : !this$situacaoLegal.equals(other$situacaoLegal)) {
            return false;
        }
        String this$receita = this.getReceita();
        String other$receita = other.getReceita();
        return !(this$receita == null ? other$receita != null : !this$receita.equals(other$receita));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RastreamentoDebitoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $idCadastro = this.getIdCadastro();
        result = result * 59 + ($idCadastro == null ? 43 : ((Object)$idCadastro).hashCode());
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : ((Object)$divida).hashCode());
        Long $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : ((Object)$subDivida).hashCode());
        Long $parcela = this.getParcela();
        result = result * 59 + ($parcela == null ? 43 : ((Object)$parcela).hashCode());
        Long $idContencioso = this.getIdContencioso();
        result = result * 59 + ($idContencioso == null ? 43 : ((Object)$idContencioso).hashCode());
        Boolean $recursoAdministrativo = this.getRecursoAdministrativo();
        result = result * 59 + ($recursoAdministrativo == null ? 43 : ((Object)$recursoAdministrativo).hashCode());
        Boolean $parcelado = this.getParcelado();
        result = result * 59 + ($parcelado == null ? 43 : ((Object)$parcelado).hashCode());
        Boolean $reparcelado = this.getReparcelado();
        result = result * 59 + ($reparcelado == null ? 43 : ((Object)$reparcelado).hashCode());
        Long $formaCorrecao = this.getFormaCorrecao();
        result = result * 59 + ($formaCorrecao == null ? 43 : ((Object)$formaCorrecao).hashCode());
        Long $idDebitoParcelaTributo = this.getIdDebitoParcelaTributo();
        result = result * 59 + ($idDebitoParcelaTributo == null ? 43 : ((Object)$idDebitoParcelaTributo).hashCode());
        LocalDate $dataVencimento = this.getDataVencimento();
        result = result * 59 + ($dataVencimento == null ? 43 : ((Object)$dataVencimento).hashCode());
        LocalDate $dataVencimentoCotaUnica = this.getDataVencimentoCotaUnica();
        result = result * 59 + ($dataVencimentoCotaUnica == null ? 43 : ((Object)$dataVencimentoCotaUnica).hashCode());
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        LocalDate $dataLancamento = this.getDataLancamento();
        result = result * 59 + ($dataLancamento == null ? 43 : ((Object)$dataLancamento).hashCode());
        LocalDate $dataPrimeiraParcela = this.getDataPrimeiraParcela();
        result = result * 59 + ($dataPrimeiraParcela == null ? 43 : ((Object)$dataPrimeiraParcela).hashCode());
        LocalDate $dataCorrecaoIgpm = this.getDataCorrecaoIgpm();
        result = result * 59 + ($dataCorrecaoIgpm == null ? 43 : ((Object)$dataCorrecaoIgpm).hashCode());
        SituacaoLegal $situacaoLegal = this.getSituacaoLegal();
        result = result * 59 + ($situacaoLegal == null ? 43 : $situacaoLegal.hashCode());
        String $receita = this.getReceita();
        result = result * 59 + ($receita == null ? 43 : $receita.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RastreamentoDebitoDTO(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", idCadastro=" + this.getIdCadastro() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ", parcela=" + this.getParcela() + ", dataVencimento=" + String.valueOf(this.getDataVencimento()) + ", dataVencimentoCotaUnica=" + String.valueOf(this.getDataVencimentoCotaUnica()) + ", idContencioso=" + this.getIdContencioso() + ", recursoAdministrativo=" + this.getRecursoAdministrativo() + ", valor=" + String.valueOf(this.getValor()) + ", parcelado=" + this.getParcelado() + ", reparcelado=" + this.getReparcelado() + ", dataLancamento=" + String.valueOf(this.getDataLancamento()) + ", dataPrimeiraParcela=" + String.valueOf(this.getDataPrimeiraParcela()) + ", dataCorrecaoIgpm=" + String.valueOf(this.getDataCorrecaoIgpm()) + ", formaCorrecao=" + this.getFormaCorrecao() + ", situacaoLegal=" + String.valueOf(this.getSituacaoLegal()) + ", receita=" + this.getReceita() + ", idDebitoParcelaTributo=" + this.getIdDebitoParcelaTributo() + ")";
    }
}

