/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.console.validator.CpfCnpjValidator;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.RastreamentoConsultaDTO;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class RastreamentoConsultaDTO {
    private Long idCadastro;
    private Long idContribuinte;
    private TipoCadastro tipoCadastro;
    private Long cadastroGeral;
    private String cpfCnpj;
    private Boolean utilizaCorresponsavel;
    private Boolean somenteEmpresasAtivas;
    private Boolean ignorarCadastrosComCorresponsavel;
    private Boolean consideraCnpjRaiz;
    private Boolean consideraCadastroAvulso;
    private static final String IGNORAR_PESSOAS_CORRESPONSAVEIS = " and not exists(select 1 from tribViewProprietario tb2 where tb2.tipocadastro = tb.tipocadastro and tb2.cadastrogeral = tb.cadastrogeral and tb2.pessoa = tb.pessoa and tb2.coresponsavelprincipal = 'S') ";
    private static final String BY_ID_CADASTRO = " and (a.idKey = %d) ";
    private static final String BY_CPF = " and (b.cnpj_cpf = '%s' and b.tipopessoa = 'F') ";
    private static final String BY_CNPJ_CONSIDERA_RAIZ = " and (substr(b.cnpj_cpf, 1, 8) = '%s' and b.tipopessoa = 'J') ";
    private static final String BY_CNPJ = " and (b.cnpj_cpf = '%s' and b.tipopessoa = 'J') ";
    private static final String IGNORAR_CADASTROS_COM_CORRESPONSAVEL = " and not exists (select 1 from tribproprietario p where p.tipocadastro = a.tipocadastro and p.cadastrogeral = a.cadastrogeral and coalesce(p.coresponsavelprincipal, 'N') = 'S')";

    public boolean ignorarCadastrosComCorresponsavel() {
        return Objects.nonNull(this.ignorarCadastrosComCorresponsavel) && Boolean.TRUE.equals(this.ignorarCadastrosComCorresponsavel);
    }

    public String buildFiltroNaoUtilizaCorresponsavel() {
        if (Objects.nonNull(this.utilizaCorresponsavel) && Boolean.FALSE.equals(this.utilizaCorresponsavel)) {
            return " and not exists(select 1 from tribViewProprietario tb2 where tb2.tipocadastro = tb.tipocadastro and tb2.cadastrogeral = tb.cadastrogeral and tb2.pessoa = tb.pessoa and tb2.coresponsavelprincipal = 'S') ";
        }
        return "";
    }

    public String buildFilter() {
        StringBuilder filter = new StringBuilder();
        this.appendFiltroPorCadastro(filter);
        this.appendFiltroPorContribuinte(filter);
        return filter.toString();
    }

    public List<Long> getTiposCadastrosConsiderados() {
        if (Objects.nonNull(this.consideraCadastroAvulso) && Boolean.TRUE.equals(this.consideraCadastroAvulso)) {
            return Arrays.asList(TipoCadastro.IMOBILIARIO.getValue(), TipoCadastro.MOBILIARIO.getValue(), TipoCadastro.RURAL.getValue(), TipoCadastro.CEMITERIO.getValue(), TipoCadastro.AVULSO.getValue());
        }
        return Arrays.asList(TipoCadastro.IMOBILIARIO.getValue(), TipoCadastro.MOBILIARIO.getValue(), TipoCadastro.RURAL.getValue(), TipoCadastro.CEMITERIO.getValue());
    }

    private void appendFiltroPorCadastro(StringBuilder filter) {
        if (Objects.isNull(this.idCadastro)) {
            return;
        }
        filter.append(String.format(" and (a.idKey = %d) ", this.idCadastro));
    }

    private void appendFiltroPorContribuinte(StringBuilder filter) {
        if (StringUtils.isBlank((CharSequence)this.cpfCnpj)) {
            return;
        }
        this.appendFiltroCpfCnpj(filter);
        this.appendFiltroIgnorarCadastrosComCorresponsavel(filter);
    }

    private void appendFiltroCpfCnpj(StringBuilder filter) {
        if (CpfCnpjValidator.isValidCPF((String)this.cpfCnpj)) {
            filter.append(String.format(" and (b.cnpj_cpf = '%s' and b.tipopessoa = 'F') ", this.cpfCnpj));
            return;
        }
        if (Boolean.TRUE.equals(this.consideraCnpjRaiz)) {
            filter.append(String.format(" and (substr(b.cnpj_cpf, 1, 8) = '%s' and b.tipopessoa = 'J') ", this.cpfCnpj.substring(0, Math.min(8, this.cpfCnpj.length()))));
            return;
        }
        filter.append(String.format(" and (b.cnpj_cpf = '%s' and b.tipopessoa = 'J') ", this.cpfCnpj));
    }

    private void appendFiltroIgnorarCadastrosComCorresponsavel(StringBuilder filter) {
        if (this.ignorarCadastrosComCorresponsavel()) {
            filter.append(" and not exists (select 1 from tribproprietario p where p.tipocadastro = a.tipocadastro and p.cadastrogeral = a.cadastrogeral and coalesce(p.coresponsavelprincipal, 'N') = 'S')");
        }
    }

    @Generated
    private static Boolean $default$utilizaCorresponsavel() {
        return Boolean.FALSE;
    }

    @Generated
    private static Boolean $default$somenteEmpresasAtivas() {
        return Boolean.FALSE;
    }

    @Generated
    private static Boolean $default$ignorarCadastrosComCorresponsavel() {
        return Boolean.FALSE;
    }

    @Generated
    private static Boolean $default$consideraCnpjRaiz() {
        return Boolean.FALSE;
    }

    @Generated
    private static Boolean $default$consideraCadastroAvulso() {
        return Boolean.FALSE;
    }

    @Generated
    public static RastreamentoConsultaDTOBuilder builder() {
        return new RastreamentoConsultaDTOBuilder();
    }

    @Generated
    public Long getIdCadastro() {
        return this.idCadastro;
    }

    @Generated
    public Long getIdContribuinte() {
        return this.idContribuinte;
    }

    @Generated
    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getCpfCnpj() {
        return this.cpfCnpj;
    }

    @Generated
    public Boolean getUtilizaCorresponsavel() {
        return this.utilizaCorresponsavel;
    }

    @Generated
    public Boolean getSomenteEmpresasAtivas() {
        return this.somenteEmpresasAtivas;
    }

    @Generated
    public Boolean getIgnorarCadastrosComCorresponsavel() {
        return this.ignorarCadastrosComCorresponsavel;
    }

    @Generated
    public Boolean getConsideraCnpjRaiz() {
        return this.consideraCnpjRaiz;
    }

    @Generated
    public Boolean getConsideraCadastroAvulso() {
        return this.consideraCadastroAvulso;
    }

    @Generated
    public void setIdCadastro(Long idCadastro) {
        this.idCadastro = idCadastro;
    }

    @Generated
    public void setIdContribuinte(Long idContribuinte) {
        this.idContribuinte = idContribuinte;
    }

    @Generated
    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setCpfCnpj(String cpfCnpj) {
        this.cpfCnpj = cpfCnpj;
    }

    @Generated
    public void setUtilizaCorresponsavel(Boolean utilizaCorresponsavel) {
        this.utilizaCorresponsavel = utilizaCorresponsavel;
    }

    @Generated
    public void setSomenteEmpresasAtivas(Boolean somenteEmpresasAtivas) {
        this.somenteEmpresasAtivas = somenteEmpresasAtivas;
    }

    @Generated
    public void setIgnorarCadastrosComCorresponsavel(Boolean ignorarCadastrosComCorresponsavel) {
        this.ignorarCadastrosComCorresponsavel = ignorarCadastrosComCorresponsavel;
    }

    @Generated
    public void setConsideraCnpjRaiz(Boolean consideraCnpjRaiz) {
        this.consideraCnpjRaiz = consideraCnpjRaiz;
    }

    @Generated
    public void setConsideraCadastroAvulso(Boolean consideraCadastroAvulso) {
        this.consideraCadastroAvulso = consideraCadastroAvulso;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RastreamentoConsultaDTO)) {
            return false;
        }
        RastreamentoConsultaDTO other = (RastreamentoConsultaDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idCadastro = this.getIdCadastro();
        Long other$idCadastro = other.getIdCadastro();
        if (this$idCadastro == null ? other$idCadastro != null : !((Object)this$idCadastro).equals(other$idCadastro)) {
            return false;
        }
        Long this$idContribuinte = this.getIdContribuinte();
        Long other$idContribuinte = other.getIdContribuinte();
        if (this$idContribuinte == null ? other$idContribuinte != null : !((Object)this$idContribuinte).equals(other$idContribuinte)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Boolean this$utilizaCorresponsavel = this.getUtilizaCorresponsavel();
        Boolean other$utilizaCorresponsavel = other.getUtilizaCorresponsavel();
        if (this$utilizaCorresponsavel == null ? other$utilizaCorresponsavel != null : !((Object)this$utilizaCorresponsavel).equals(other$utilizaCorresponsavel)) {
            return false;
        }
        Boolean this$somenteEmpresasAtivas = this.getSomenteEmpresasAtivas();
        Boolean other$somenteEmpresasAtivas = other.getSomenteEmpresasAtivas();
        if (this$somenteEmpresasAtivas == null ? other$somenteEmpresasAtivas != null : !((Object)this$somenteEmpresasAtivas).equals(other$somenteEmpresasAtivas)) {
            return false;
        }
        Boolean this$ignorarCadastrosComCorresponsavel = this.getIgnorarCadastrosComCorresponsavel();
        Boolean other$ignorarCadastrosComCorresponsavel = other.getIgnorarCadastrosComCorresponsavel();
        if (this$ignorarCadastrosComCorresponsavel == null ? other$ignorarCadastrosComCorresponsavel != null : !((Object)this$ignorarCadastrosComCorresponsavel).equals(other$ignorarCadastrosComCorresponsavel)) {
            return false;
        }
        Boolean this$consideraCnpjRaiz = this.getConsideraCnpjRaiz();
        Boolean other$consideraCnpjRaiz = other.getConsideraCnpjRaiz();
        if (this$consideraCnpjRaiz == null ? other$consideraCnpjRaiz != null : !((Object)this$consideraCnpjRaiz).equals(other$consideraCnpjRaiz)) {
            return false;
        }
        Boolean this$consideraCadastroAvulso = this.getConsideraCadastroAvulso();
        Boolean other$consideraCadastroAvulso = other.getConsideraCadastroAvulso();
        if (this$consideraCadastroAvulso == null ? other$consideraCadastroAvulso != null : !((Object)this$consideraCadastroAvulso).equals(other$consideraCadastroAvulso)) {
            return false;
        }
        TipoCadastro this$tipoCadastro = this.getTipoCadastro();
        TipoCadastro other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !this$tipoCadastro.equals(other$tipoCadastro)) {
            return false;
        }
        String this$cpfCnpj = this.getCpfCnpj();
        String other$cpfCnpj = other.getCpfCnpj();
        return !(this$cpfCnpj == null ? other$cpfCnpj != null : !this$cpfCnpj.equals(other$cpfCnpj));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RastreamentoConsultaDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idCadastro = this.getIdCadastro();
        result = result * 59 + ($idCadastro == null ? 43 : ((Object)$idCadastro).hashCode());
        Long $idContribuinte = this.getIdContribuinte();
        result = result * 59 + ($idContribuinte == null ? 43 : ((Object)$idContribuinte).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Boolean $utilizaCorresponsavel = this.getUtilizaCorresponsavel();
        result = result * 59 + ($utilizaCorresponsavel == null ? 43 : ((Object)$utilizaCorresponsavel).hashCode());
        Boolean $somenteEmpresasAtivas = this.getSomenteEmpresasAtivas();
        result = result * 59 + ($somenteEmpresasAtivas == null ? 43 : ((Object)$somenteEmpresasAtivas).hashCode());
        Boolean $ignorarCadastrosComCorresponsavel = this.getIgnorarCadastrosComCorresponsavel();
        result = result * 59 + ($ignorarCadastrosComCorresponsavel == null ? 43 : ((Object)$ignorarCadastrosComCorresponsavel).hashCode());
        Boolean $consideraCnpjRaiz = this.getConsideraCnpjRaiz();
        result = result * 59 + ($consideraCnpjRaiz == null ? 43 : ((Object)$consideraCnpjRaiz).hashCode());
        Boolean $consideraCadastroAvulso = this.getConsideraCadastroAvulso();
        result = result * 59 + ($consideraCadastroAvulso == null ? 43 : ((Object)$consideraCadastroAvulso).hashCode());
        TipoCadastro $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : $tipoCadastro.hashCode());
        String $cpfCnpj = this.getCpfCnpj();
        result = result * 59 + ($cpfCnpj == null ? 43 : $cpfCnpj.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RastreamentoConsultaDTO(idCadastro=" + this.getIdCadastro() + ", idContribuinte=" + this.getIdContribuinte() + ", tipoCadastro=" + String.valueOf(this.getTipoCadastro()) + ", cadastroGeral=" + this.getCadastroGeral() + ", cpfCnpj=" + this.getCpfCnpj() + ", utilizaCorresponsavel=" + this.getUtilizaCorresponsavel() + ", somenteEmpresasAtivas=" + this.getSomenteEmpresasAtivas() + ", ignorarCadastrosComCorresponsavel=" + this.getIgnorarCadastrosComCorresponsavel() + ", consideraCnpjRaiz=" + this.getConsideraCnpjRaiz() + ", consideraCadastroAvulso=" + this.getConsideraCadastroAvulso() + ")";
    }

    @Generated
    public RastreamentoConsultaDTO() {
        this.utilizaCorresponsavel = RastreamentoConsultaDTO.$default$utilizaCorresponsavel();
        this.somenteEmpresasAtivas = RastreamentoConsultaDTO.$default$somenteEmpresasAtivas();
        this.ignorarCadastrosComCorresponsavel = RastreamentoConsultaDTO.$default$ignorarCadastrosComCorresponsavel();
        this.consideraCnpjRaiz = RastreamentoConsultaDTO.$default$consideraCnpjRaiz();
        this.consideraCadastroAvulso = RastreamentoConsultaDTO.$default$consideraCadastroAvulso();
    }

    @Generated
    public RastreamentoConsultaDTO(Long idCadastro, Long idContribuinte, TipoCadastro tipoCadastro, Long cadastroGeral, String cpfCnpj, Boolean utilizaCorresponsavel, Boolean somenteEmpresasAtivas, Boolean ignorarCadastrosComCorresponsavel, Boolean consideraCnpjRaiz, Boolean consideraCadastroAvulso) {
        this.idCadastro = idCadastro;
        this.idContribuinte = idContribuinte;
        this.tipoCadastro = tipoCadastro;
        this.cadastroGeral = cadastroGeral;
        this.cpfCnpj = cpfCnpj;
        this.utilizaCorresponsavel = utilizaCorresponsavel;
        this.somenteEmpresasAtivas = somenteEmpresasAtivas;
        this.ignorarCadastrosComCorresponsavel = ignorarCadastrosComCorresponsavel;
        this.consideraCnpjRaiz = consideraCnpjRaiz;
        this.consideraCadastroAvulso = consideraCadastroAvulso;
    }
}

