/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.Profissional;
import br.com.elotech.tributos.domain.ProfissionalId;
import br.com.elotech.tributos.domain.ProfissionalProfissao;
import br.com.elotech.tributos.dto.CboDTO;
import java.util.Optional;
import lombok.Generated;

public class ProfissionalDTO {
    private Long id;
    private String nome;
    private String profissao;
    private String cnpjCpf;
    private String carteira;
    private CboDTO cbo;

    public static ProfissionalDTO from(Pessoa pessoa) {
        ProfissionalDTO profissionalDTO = new ProfissionalDTO();
        profissionalDTO.setId(pessoa.getId());
        profissionalDTO.setNome(pessoa.getNome());
        profissionalDTO.setProfissao(pessoa.getAtividadePrincipal());
        profissionalDTO.setCnpjCpf(pessoa.getCnpjCpf());
        return profissionalDTO;
    }

    public static ProfissionalDTO from(Profissional profissional) {
        ProfissionalId id = profissional.getId();
        Pessoa pessoa = id.getPessoa();
        ProfissionalDTO dto = new ProfissionalDTO();
        dto.setId(pessoa.getId());
        dto.setNome(pessoa.getNome());
        dto.setCnpjCpf(pessoa.getCnpjCpf());
        dto.setProfissao(profissional.getDescricaoProfissaoPrincipal());
        dto.setCarteira((String)Optional.ofNullable(profissional.getProfissaoPrincipal()).map(ProfissionalProfissao::getNumeroCarteiraProfissional).orElse(null));
        dto.setCbo((CboDTO)Optional.ofNullable(profissional.getProfissaoPrincipal()).map(ProfissionalProfissao::getCbo).map(CboDTO::from).orElse(null));
        return dto;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public String getProfissao() {
        return this.profissao;
    }

    @Generated
    public String getCnpjCpf() {
        return this.cnpjCpf;
    }

    @Generated
    public String getCarteira() {
        return this.carteira;
    }

    @Generated
    public CboDTO getCbo() {
        return this.cbo;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setProfissao(String profissao) {
        this.profissao = profissao;
    }

    @Generated
    public void setCnpjCpf(String cnpjCpf) {
        this.cnpjCpf = cnpjCpf;
    }

    @Generated
    public void setCarteira(String carteira) {
        this.carteira = carteira;
    }

    @Generated
    public void setCbo(CboDTO cbo) {
        this.cbo = cbo;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProfissionalDTO)) {
            return false;
        }
        ProfissionalDTO other = (ProfissionalDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        String this$profissao = this.getProfissao();
        String other$profissao = other.getProfissao();
        if (this$profissao == null ? other$profissao != null : !this$profissao.equals(other$profissao)) {
            return false;
        }
        String this$cnpjCpf = this.getCnpjCpf();
        String other$cnpjCpf = other.getCnpjCpf();
        if (this$cnpjCpf == null ? other$cnpjCpf != null : !this$cnpjCpf.equals(other$cnpjCpf)) {
            return false;
        }
        String this$carteira = this.getCarteira();
        String other$carteira = other.getCarteira();
        if (this$carteira == null ? other$carteira != null : !this$carteira.equals(other$carteira)) {
            return false;
        }
        CboDTO this$cbo = this.getCbo();
        CboDTO other$cbo = other.getCbo();
        return !(this$cbo == null ? other$cbo != null : !this$cbo.equals(other$cbo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProfissionalDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        String $profissao = this.getProfissao();
        result = result * 59 + ($profissao == null ? 43 : $profissao.hashCode());
        String $cnpjCpf = this.getCnpjCpf();
        result = result * 59 + ($cnpjCpf == null ? 43 : $cnpjCpf.hashCode());
        String $carteira = this.getCarteira();
        result = result * 59 + ($carteira == null ? 43 : $carteira.hashCode());
        CboDTO $cbo = this.getCbo();
        result = result * 59 + ($cbo == null ? 43 : $cbo.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ProfissionalDTO(id=" + this.getId() + ", nome=" + this.getNome() + ", profissao=" + this.getProfissao() + ", cnpjCpf=" + this.getCnpjCpf() + ", carteira=" + this.getCarteira() + ", cbo=" + String.valueOf(this.getCbo()) + ")";
    }

    @Generated
    public ProfissionalDTO() {
    }

    @Generated
    public ProfissionalDTO(Long id, String nome, String profissao, String cnpjCpf, String carteira, CboDTO cbo) {
        this.id = id;
        this.nome = nome;
        this.profissao = profissao;
        this.cnpjCpf = cnpjCpf;
        this.carteira = carteira;
        this.cbo = cbo;
    }
}

