/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.dto.DadosPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.DebitoPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.FiltroPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.StatusPagamentoNegociado;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public class ParametrosPagamentoNegociadoDTO {
    private List<DebitoPagamentoNegociadoDTO> debitos = new ArrayList();
    private DadosPagamentoNegociadoDTO dadosPagamento;
    private FiltroPagamentoNegociadoDTO filtro;

    @JsonIgnore
    public Optional<DebitoPagamentoNegociadoDTO> getParcialmenteBaixados() {
        return this.getByStatus(StatusPagamentoNegociado.PARCIAL).stream().findFirst();
    }

    @JsonIgnore
    public List<DebitoPagamentoNegociadoDTO> getByStatus(StatusPagamentoNegociado status) {
        return this.debitos.stream().filter(debito -> debito.getStatus().equals((Object)status)).collect(Collectors.toList());
    }

    @JsonIgnore
    public String getParcelasWithCommaByDebito(Long idDebito) {
        return this.debitos.stream().filter(p -> Objects.equals(p.getIdDebito(), idDebito)).map(p -> String.valueOf(p.getParcela())).collect(Collectors.joining(", "));
    }

    @Generated
    public ParametrosPagamentoNegociadoDTO() {
    }

    @Generated
    public List<DebitoPagamentoNegociadoDTO> getDebitos() {
        return this.debitos;
    }

    @Generated
    public DadosPagamentoNegociadoDTO getDadosPagamento() {
        return this.dadosPagamento;
    }

    @Generated
    public FiltroPagamentoNegociadoDTO getFiltro() {
        return this.filtro;
    }

    @Generated
    public void setDebitos(List<DebitoPagamentoNegociadoDTO> debitos) {
        this.debitos = debitos;
    }

    @Generated
    public void setDadosPagamento(DadosPagamentoNegociadoDTO dadosPagamento) {
        this.dadosPagamento = dadosPagamento;
    }

    @Generated
    public void setFiltro(FiltroPagamentoNegociadoDTO filtro) {
        this.filtro = filtro;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParametrosPagamentoNegociadoDTO)) {
            return false;
        }
        ParametrosPagamentoNegociadoDTO other = (ParametrosPagamentoNegociadoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List this$debitos = this.getDebitos();
        List other$debitos = other.getDebitos();
        if (this$debitos == null ? other$debitos != null : !((Object)this$debitos).equals(other$debitos)) {
            return false;
        }
        DadosPagamentoNegociadoDTO this$dadosPagamento = this.getDadosPagamento();
        DadosPagamentoNegociadoDTO other$dadosPagamento = other.getDadosPagamento();
        if (this$dadosPagamento == null ? other$dadosPagamento != null : !this$dadosPagamento.equals(other$dadosPagamento)) {
            return false;
        }
        FiltroPagamentoNegociadoDTO this$filtro = this.getFiltro();
        FiltroPagamentoNegociadoDTO other$filtro = other.getFiltro();
        return !(this$filtro == null ? other$filtro != null : !this$filtro.equals(other$filtro));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ParametrosPagamentoNegociadoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List $debitos = this.getDebitos();
        result = result * 59 + ($debitos == null ? 43 : ((Object)$debitos).hashCode());
        DadosPagamentoNegociadoDTO $dadosPagamento = this.getDadosPagamento();
        result = result * 59 + ($dadosPagamento == null ? 43 : $dadosPagamento.hashCode());
        FiltroPagamentoNegociadoDTO $filtro = this.getFiltro();
        result = result * 59 + ($filtro == null ? 43 : $filtro.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ParametrosPagamentoNegociadoDTO(debitos=" + String.valueOf(this.getDebitos()) + ", dadosPagamento=" + String.valueOf(this.getDadosPagamento()) + ", filtro=" + String.valueOf(this.getFiltro()) + ")";
    }
}

