/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.domain.ParametroItbi;
import br.com.elotech.tributos.domain.ParametroItbiAliquota;
import br.com.elotech.tributos.domain.Tributo;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamento;
import br.com.elotech.tributos.domain.relatorio.Relatorio;
import br.com.elotech.tributos.enums.parametroitbi.TipoAliquotaItbi;
import br.com.elotech.tributos.enums.parametroitbi.TipoAplicacaoAliquotaItbi;
import br.com.elotech.tributos.util.ListUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class ParametroItbiDTO {
    private Long id;
    private String descricao;
    private Boolean ativo = Boolean.TRUE;
    private Long prazoPagamento;
    private Long prazoDeferimento;
    private Divida divida;
    private ParamParcelamento parametroParcelamento;
    private Tributo tributoPadrao;
    private BigDecimal aliquotaPadrao = BigDecimal.ZERO;
    private Tributo tributoAVista;
    private BigDecimal aliquotaAVista = BigDecimal.ZERO;
    private Tributo tributoFinanciado;
    private BigDecimal aliquotaFinanciado = BigDecimal.ZERO;
    private Tributo tributoAnuencia;
    private BigDecimal aliquotaAnuencia = BigDecimal.ZERO;
    private Boolean transfereTodasUnidades = Boolean.FALSE;
    private Boolean transfereSemPagamento = Boolean.FALSE;
    private Boolean informaProtocolo = Boolean.FALSE;
    private Boolean alteraDataRefenciaBoleto = Boolean.FALSE;
    private Boolean utilizaFormulaCalculo = Boolean.FALSE;
    private Boolean mostraAvisoDebito = Boolean.FALSE;
    private Boolean transfereSomenteResponsavel = Boolean.FALSE;
    private Boolean transfereAutomaticamente = Boolean.FALSE;
    private Relatorio modeloBoleto;
    private Relatorio modeloCarne;
    private Relatorio termoIsencao;
    private MotivoDeducao motivoDeducaoPadraoExercicio;
    private MotivoDeducao motivoDeducaoPadraoDividaAtiva;
    private Boolean utilizaAliquotaDiferenciadaTipoNormal = Boolean.FALSE;
    private TipoAplicacaoAliquotaItbi tipoAliquotaDiferenciadaNormal;
    private List<ParametroItbiAliquota> aliquotasNormal = new ArrayList();
    private Boolean utilizaAliquotaDiferenciadaTipoFinanciadoAVista = Boolean.FALSE;
    private TipoAplicacaoAliquotaItbi tipoAliquotaDiferenciadaFinanciadoAVista;
    private List<ParametroItbiAliquota> aliquotasFinanciadoAVista = new ArrayList();
    private Boolean utilizaAliquotaDiferenciadaTipoFinanciado = Boolean.FALSE;
    private TipoAplicacaoAliquotaItbi tipoAliquotaDiferenciadaFinanciado;
    private List<ParametroItbiAliquota> aliquotasFinanciado = new ArrayList();
    private Boolean usaAliquotaGeralFinanciado = Boolean.FALSE;
    private BigDecimal aliquotaGeralValorFinanciado = BigDecimal.ZERO;
    private BigDecimal aliquotaGeralAliquotaFinanciado = BigDecimal.ZERO;

    public static ParametroItbiDTO from(ParametroItbi parametro) {
        ParametroItbiDTO dto = new ParametroItbiDTO();
        dto.setId(parametro.getId());
        dto.setDescricao(parametro.getDescricao());
        dto.setAtivo(parametro.getAtivo());
        dto.setPrazoPagamento(parametro.getPrazoPagamento());
        dto.setPrazoDeferimento(parametro.getPrazoDeferimento());
        dto.setParametroParcelamento(parametro.getParametroParcelamento());
        dto.setAliquotaPadrao(parametro.getAliquotaPadrao());
        dto.setAliquotaAVista(parametro.getAliquotaAVista());
        dto.setAliquotaFinanciado(parametro.getAliquotaFinanciado());
        dto.setAliquotaAnuencia(parametro.getAliquotaAnuencia());
        dto.setTransfereTodasUnidades(parametro.getTransfereTodasUnidades());
        dto.setTransfereSemPagamento(parametro.getTransfereSemPagamento());
        dto.setInformaProtocolo(parametro.getInformaProtocolo());
        dto.setAlteraDataRefenciaBoleto(parametro.getAlteraDataRefenciaBoleto());
        dto.setUtilizaFormulaCalculo(parametro.getUtilizaFormulaCalculo());
        dto.setMostraAvisoDebito(parametro.getMostraAvisoDebito());
        dto.setTransfereSomenteResponsavel(parametro.getTransfereSomenteResponsavel());
        dto.setTransfereAutomaticamente(parametro.getTransfereAutomaticamente());
        dto.setModeloBoleto(parametro.getModeloBoleto());
        dto.setModeloCarne(parametro.getModeloCarne());
        dto.setTermoIsencao(parametro.getTermoIsencao());
        dto.setMotivoDeducaoPadraoDividaAtiva(parametro.getMotivoDeducaoPadraoDividaAtiva());
        dto.setMotivoDeducaoPadraoExercicio(parametro.getMotivoDeducaoPadraoExercicio());
        dto.setUtilizaAliquotaDiferenciadaTipoNormal(parametro.getUtilizaAliquotaDiferenciadaTipoNormal());
        dto.setTipoAliquotaDiferenciadaNormal(parametro.getTipoAliquotaDiferenciadaNormal());
        dto.setAliquotasNormal(parametro.getAliquotasNormal());
        dto.setUtilizaAliquotaDiferenciadaTipoFinanciadoAVista(parametro.getUtilizaAliquotaDiferenciadaTipoFinanciadoAVista());
        dto.setTipoAliquotaDiferenciadaFinanciadoAVista(parametro.getTipoAliquotaDiferenciadaFinanciadoAVista());
        dto.setAliquotasFinanciadoAVista(parametro.getAliquotasFinanciadoAVista());
        dto.setUtilizaAliquotaDiferenciadaTipoFinanciado(parametro.getUtilizaAliquotaDiferenciadaTipoFinanciado());
        dto.setTipoAliquotaDiferenciadaFinanciado(parametro.getTipoAliquotaDiferenciadaFinanciado());
        dto.setAliquotasFinanciado(parametro.getAliquotasFinanciado());
        dto.setUsaAliquotaGeralFinanciado(parametro.getUsaAliquotaGeralFinanciado());
        dto.setAliquotaGeralValorFinanciado(parametro.getAliquotaGeralValorFinanciado());
        dto.setAliquotaGeralAliquotaFinanciado(parametro.getAliquotaGeralAliquotaFinanciado());
        return dto;
    }

    public ParametroItbi toEntity(ParametroItbi parametroItbi) {
        parametroItbi.setDescricao(this.descricao);
        parametroItbi.setAtivo(this.ativo);
        parametroItbi.setPrazoPagamento(this.prazoPagamento);
        parametroItbi.setPrazoDeferimento(this.prazoDeferimento);
        parametroItbi.setDivida(this.divida.getDivida());
        parametroItbi.setParametroParcelamento(this.parametroParcelamento);
        parametroItbi.setTributoPadrao(this.tributoPadrao.getTributo());
        parametroItbi.setAliquotaPadrao(this.aliquotaPadrao);
        Optional.ofNullable(this.tributoAVista).map(Tributo::getTributo).ifPresent(arg_0 -> ((ParametroItbi)parametroItbi).setTributoAVista(arg_0));
        parametroItbi.setAliquotaAVista(this.aliquotaAVista);
        Optional.ofNullable(this.tributoFinanciado).map(Tributo::getTributo).ifPresent(arg_0 -> ((ParametroItbi)parametroItbi).setTributoFinanciado(arg_0));
        parametroItbi.setAliquotaFinanciado(this.aliquotaFinanciado);
        Optional.ofNullable(this.tributoAnuencia).map(Tributo::getTributo).ifPresent(arg_0 -> ((ParametroItbi)parametroItbi).setTributoAnuencia(arg_0));
        parametroItbi.setAliquotaAnuencia(this.aliquotaAnuencia);
        parametroItbi.setTransfereTodasUnidades(this.transfereTodasUnidades);
        parametroItbi.setTransfereSemPagamento(this.transfereSemPagamento);
        parametroItbi.setInformaProtocolo(this.informaProtocolo);
        parametroItbi.setAlteraDataRefenciaBoleto(this.alteraDataRefenciaBoleto);
        parametroItbi.setUtilizaFormulaCalculo(this.utilizaFormulaCalculo);
        parametroItbi.setMostraAvisoDebito(this.mostraAvisoDebito);
        parametroItbi.setTransfereSomenteResponsavel(this.transfereSomenteResponsavel);
        parametroItbi.setTransfereAutomaticamente(this.transfereAutomaticamente);
        parametroItbi.setModeloBoleto(this.modeloBoleto);
        parametroItbi.setModeloCarne(this.modeloCarne);
        parametroItbi.setTermoIsencao(this.termoIsencao);
        Optional.ofNullable(this.motivoDeducaoPadraoDividaAtiva).ifPresent(arg_0 -> ((ParametroItbi)parametroItbi).setMotivoDeducaoPadraoDividaAtiva(arg_0));
        Optional.ofNullable(this.motivoDeducaoPadraoExercicio).ifPresent(arg_0 -> ((ParametroItbi)parametroItbi).setMotivoDeducaoPadraoExercicio(arg_0));
        parametroItbi.setUtilizaAliquotaDiferenciadaTipoNormal(this.utilizaAliquotaDiferenciadaTipoNormal);
        parametroItbi.setTipoAliquotaDiferenciadaNormal(this.tipoAliquotaDiferenciadaNormal);
        parametroItbi.setUtilizaAliquotaDiferenciadaTipoFinanciadoAVista(this.utilizaAliquotaDiferenciadaTipoFinanciadoAVista);
        parametroItbi.setTipoAliquotaDiferenciadaFinanciadoAVista(this.tipoAliquotaDiferenciadaFinanciadoAVista);
        parametroItbi.setUtilizaAliquotaDiferenciadaTipoFinanciado(this.utilizaAliquotaDiferenciadaTipoFinanciado);
        parametroItbi.setTipoAliquotaDiferenciadaFinanciado(this.tipoAliquotaDiferenciadaFinanciado);
        this.getAliquotasNormal().forEach(aliquota -> aliquota.setTipoAliquota(TipoAliquotaItbi.NORMAL));
        this.getAliquotasFinanciadoAVista().forEach(aliquota -> aliquota.setTipoAliquota(TipoAliquotaItbi.FINANCIADO_A_VISTA));
        this.getAliquotasFinanciado().forEach(aliquota -> aliquota.setTipoAliquota(TipoAliquotaItbi.FINANCIADO));
        List mergedAliquotasNormal = ListUtils.merge((List)parametroItbi.getAliquotasNormal(), (List)this.aliquotasNormal, ParametroItbiAliquota::getId, ParametroItbiAliquota::merge);
        parametroItbi.getAliquotasNormal().clear();
        parametroItbi.getAliquotasNormal().addAll(mergedAliquotasNormal);
        List mergedAliquotasFinanciadoAvista = ListUtils.merge((List)parametroItbi.getAliquotasFinanciadoAVista(), (List)this.aliquotasFinanciadoAVista, ParametroItbiAliquota::getId, ParametroItbiAliquota::merge);
        parametroItbi.getAliquotasFinanciadoAVista().clear();
        parametroItbi.getAliquotasFinanciadoAVista().addAll(mergedAliquotasFinanciadoAvista);
        List mergedAliquotasFinanciado = ListUtils.merge((List)parametroItbi.getAliquotasFinanciado(), (List)this.aliquotasFinanciado, ParametroItbiAliquota::getId, ParametroItbiAliquota::merge);
        parametroItbi.getAliquotasFinanciado().clear();
        parametroItbi.getAliquotasFinanciado().addAll(mergedAliquotasFinanciado);
        parametroItbi.setUsaAliquotaGeralFinanciado(this.usaAliquotaGeralFinanciado);
        parametroItbi.setAliquotaGeralValorFinanciado(this.aliquotaGeralValorFinanciado);
        parametroItbi.setAliquotaGeralAliquotaFinanciado(this.aliquotaGeralAliquotaFinanciado);
        return parametroItbi;
    }

    public ParametroItbi toEntity() {
        ParametroItbi parametroItbi = this.toEntity(new ParametroItbi());
        parametroItbi.setId(this.id);
        return parametroItbi;
    }

    @Generated
    public ParametroItbiDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Boolean getAtivo() {
        return this.ativo;
    }

    @Generated
    public Long getPrazoPagamento() {
        return this.prazoPagamento;
    }

    @Generated
    public Long getPrazoDeferimento() {
        return this.prazoDeferimento;
    }

    @Generated
    public Divida getDivida() {
        return this.divida;
    }

    @Generated
    public ParamParcelamento getParametroParcelamento() {
        return this.parametroParcelamento;
    }

    @Generated
    public Tributo getTributoPadrao() {
        return this.tributoPadrao;
    }

    @Generated
    public BigDecimal getAliquotaPadrao() {
        return this.aliquotaPadrao;
    }

    @Generated
    public Tributo getTributoAVista() {
        return this.tributoAVista;
    }

    @Generated
    public BigDecimal getAliquotaAVista() {
        return this.aliquotaAVista;
    }

    @Generated
    public Tributo getTributoFinanciado() {
        return this.tributoFinanciado;
    }

    @Generated
    public BigDecimal getAliquotaFinanciado() {
        return this.aliquotaFinanciado;
    }

    @Generated
    public Tributo getTributoAnuencia() {
        return this.tributoAnuencia;
    }

    @Generated
    public BigDecimal getAliquotaAnuencia() {
        return this.aliquotaAnuencia;
    }

    @Generated
    public Boolean getTransfereTodasUnidades() {
        return this.transfereTodasUnidades;
    }

    @Generated
    public Boolean getTransfereSemPagamento() {
        return this.transfereSemPagamento;
    }

    @Generated
    public Boolean getInformaProtocolo() {
        return this.informaProtocolo;
    }

    @Generated
    public Boolean getAlteraDataRefenciaBoleto() {
        return this.alteraDataRefenciaBoleto;
    }

    @Generated
    public Boolean getUtilizaFormulaCalculo() {
        return this.utilizaFormulaCalculo;
    }

    @Generated
    public Boolean getMostraAvisoDebito() {
        return this.mostraAvisoDebito;
    }

    @Generated
    public Boolean getTransfereSomenteResponsavel() {
        return this.transfereSomenteResponsavel;
    }

    @Generated
    public Boolean getTransfereAutomaticamente() {
        return this.transfereAutomaticamente;
    }

    @Generated
    public Relatorio getModeloBoleto() {
        return this.modeloBoleto;
    }

    @Generated
    public Relatorio getModeloCarne() {
        return this.modeloCarne;
    }

    @Generated
    public Relatorio getTermoIsencao() {
        return this.termoIsencao;
    }

    @Generated
    public MotivoDeducao getMotivoDeducaoPadraoExercicio() {
        return this.motivoDeducaoPadraoExercicio;
    }

    @Generated
    public MotivoDeducao getMotivoDeducaoPadraoDividaAtiva() {
        return this.motivoDeducaoPadraoDividaAtiva;
    }

    @Generated
    public Boolean getUtilizaAliquotaDiferenciadaTipoNormal() {
        return this.utilizaAliquotaDiferenciadaTipoNormal;
    }

    @Generated
    public TipoAplicacaoAliquotaItbi getTipoAliquotaDiferenciadaNormal() {
        return this.tipoAliquotaDiferenciadaNormal;
    }

    @Generated
    public List<ParametroItbiAliquota> getAliquotasNormal() {
        return this.aliquotasNormal;
    }

    @Generated
    public Boolean getUtilizaAliquotaDiferenciadaTipoFinanciadoAVista() {
        return this.utilizaAliquotaDiferenciadaTipoFinanciadoAVista;
    }

    @Generated
    public TipoAplicacaoAliquotaItbi getTipoAliquotaDiferenciadaFinanciadoAVista() {
        return this.tipoAliquotaDiferenciadaFinanciadoAVista;
    }

    @Generated
    public List<ParametroItbiAliquota> getAliquotasFinanciadoAVista() {
        return this.aliquotasFinanciadoAVista;
    }

    @Generated
    public Boolean getUtilizaAliquotaDiferenciadaTipoFinanciado() {
        return this.utilizaAliquotaDiferenciadaTipoFinanciado;
    }

    @Generated
    public TipoAplicacaoAliquotaItbi getTipoAliquotaDiferenciadaFinanciado() {
        return this.tipoAliquotaDiferenciadaFinanciado;
    }

    @Generated
    public List<ParametroItbiAliquota> getAliquotasFinanciado() {
        return this.aliquotasFinanciado;
    }

    @Generated
    public Boolean getUsaAliquotaGeralFinanciado() {
        return this.usaAliquotaGeralFinanciado;
    }

    @Generated
    public BigDecimal getAliquotaGeralValorFinanciado() {
        return this.aliquotaGeralValorFinanciado;
    }

    @Generated
    public BigDecimal getAliquotaGeralAliquotaFinanciado() {
        return this.aliquotaGeralAliquotaFinanciado;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    @Generated
    public void setPrazoPagamento(Long prazoPagamento) {
        this.prazoPagamento = prazoPagamento;
    }

    @Generated
    public void setPrazoDeferimento(Long prazoDeferimento) {
        this.prazoDeferimento = prazoDeferimento;
    }

    @Generated
    public void setDivida(Divida divida) {
        this.divida = divida;
    }

    @Generated
    public void setParametroParcelamento(ParamParcelamento parametroParcelamento) {
        this.parametroParcelamento = parametroParcelamento;
    }

    @Generated
    public void setTributoPadrao(Tributo tributoPadrao) {
        this.tributoPadrao = tributoPadrao;
    }

    @Generated
    public void setAliquotaPadrao(BigDecimal aliquotaPadrao) {
        this.aliquotaPadrao = aliquotaPadrao;
    }

    @Generated
    public void setTributoAVista(Tributo tributoAVista) {
        this.tributoAVista = tributoAVista;
    }

    @Generated
    public void setAliquotaAVista(BigDecimal aliquotaAVista) {
        this.aliquotaAVista = aliquotaAVista;
    }

    @Generated
    public void setTributoFinanciado(Tributo tributoFinanciado) {
        this.tributoFinanciado = tributoFinanciado;
    }

    @Generated
    public void setAliquotaFinanciado(BigDecimal aliquotaFinanciado) {
        this.aliquotaFinanciado = aliquotaFinanciado;
    }

    @Generated
    public void setTributoAnuencia(Tributo tributoAnuencia) {
        this.tributoAnuencia = tributoAnuencia;
    }

    @Generated
    public void setAliquotaAnuencia(BigDecimal aliquotaAnuencia) {
        this.aliquotaAnuencia = aliquotaAnuencia;
    }

    @Generated
    public void setTransfereTodasUnidades(Boolean transfereTodasUnidades) {
        this.transfereTodasUnidades = transfereTodasUnidades;
    }

    @Generated
    public void setTransfereSemPagamento(Boolean transfereSemPagamento) {
        this.transfereSemPagamento = transfereSemPagamento;
    }

    @Generated
    public void setInformaProtocolo(Boolean informaProtocolo) {
        this.informaProtocolo = informaProtocolo;
    }

    @Generated
    public void setAlteraDataRefenciaBoleto(Boolean alteraDataRefenciaBoleto) {
        this.alteraDataRefenciaBoleto = alteraDataRefenciaBoleto;
    }

    @Generated
    public void setUtilizaFormulaCalculo(Boolean utilizaFormulaCalculo) {
        this.utilizaFormulaCalculo = utilizaFormulaCalculo;
    }

    @Generated
    public void setMostraAvisoDebito(Boolean mostraAvisoDebito) {
        this.mostraAvisoDebito = mostraAvisoDebito;
    }

    @Generated
    public void setTransfereSomenteResponsavel(Boolean transfereSomenteResponsavel) {
        this.transfereSomenteResponsavel = transfereSomenteResponsavel;
    }

    @Generated
    public void setTransfereAutomaticamente(Boolean transfereAutomaticamente) {
        this.transfereAutomaticamente = transfereAutomaticamente;
    }

    @Generated
    public void setModeloBoleto(Relatorio modeloBoleto) {
        this.modeloBoleto = modeloBoleto;
    }

    @Generated
    public void setModeloCarne(Relatorio modeloCarne) {
        this.modeloCarne = modeloCarne;
    }

    @Generated
    public void setTermoIsencao(Relatorio termoIsencao) {
        this.termoIsencao = termoIsencao;
    }

    @Generated
    public void setMotivoDeducaoPadraoExercicio(MotivoDeducao motivoDeducaoPadraoExercicio) {
        this.motivoDeducaoPadraoExercicio = motivoDeducaoPadraoExercicio;
    }

    @Generated
    public void setMotivoDeducaoPadraoDividaAtiva(MotivoDeducao motivoDeducaoPadraoDividaAtiva) {
        this.motivoDeducaoPadraoDividaAtiva = motivoDeducaoPadraoDividaAtiva;
    }

    @Generated
    public void setUtilizaAliquotaDiferenciadaTipoNormal(Boolean utilizaAliquotaDiferenciadaTipoNormal) {
        this.utilizaAliquotaDiferenciadaTipoNormal = utilizaAliquotaDiferenciadaTipoNormal;
    }

    @Generated
    public void setTipoAliquotaDiferenciadaNormal(TipoAplicacaoAliquotaItbi tipoAliquotaDiferenciadaNormal) {
        this.tipoAliquotaDiferenciadaNormal = tipoAliquotaDiferenciadaNormal;
    }

    @Generated
    public void setAliquotasNormal(List<ParametroItbiAliquota> aliquotasNormal) {
        this.aliquotasNormal = aliquotasNormal;
    }

    @Generated
    public void setUtilizaAliquotaDiferenciadaTipoFinanciadoAVista(Boolean utilizaAliquotaDiferenciadaTipoFinanciadoAVista) {
        this.utilizaAliquotaDiferenciadaTipoFinanciadoAVista = utilizaAliquotaDiferenciadaTipoFinanciadoAVista;
    }

    @Generated
    public void setTipoAliquotaDiferenciadaFinanciadoAVista(TipoAplicacaoAliquotaItbi tipoAliquotaDiferenciadaFinanciadoAVista) {
        this.tipoAliquotaDiferenciadaFinanciadoAVista = tipoAliquotaDiferenciadaFinanciadoAVista;
    }

    @Generated
    public void setAliquotasFinanciadoAVista(List<ParametroItbiAliquota> aliquotasFinanciadoAVista) {
        this.aliquotasFinanciadoAVista = aliquotasFinanciadoAVista;
    }

    @Generated
    public void setUtilizaAliquotaDiferenciadaTipoFinanciado(Boolean utilizaAliquotaDiferenciadaTipoFinanciado) {
        this.utilizaAliquotaDiferenciadaTipoFinanciado = utilizaAliquotaDiferenciadaTipoFinanciado;
    }

    @Generated
    public void setTipoAliquotaDiferenciadaFinanciado(TipoAplicacaoAliquotaItbi tipoAliquotaDiferenciadaFinanciado) {
        this.tipoAliquotaDiferenciadaFinanciado = tipoAliquotaDiferenciadaFinanciado;
    }

    @Generated
    public void setAliquotasFinanciado(List<ParametroItbiAliquota> aliquotasFinanciado) {
        this.aliquotasFinanciado = aliquotasFinanciado;
    }

    @Generated
    public void setUsaAliquotaGeralFinanciado(Boolean usaAliquotaGeralFinanciado) {
        this.usaAliquotaGeralFinanciado = usaAliquotaGeralFinanciado;
    }

    @Generated
    public void setAliquotaGeralValorFinanciado(BigDecimal aliquotaGeralValorFinanciado) {
        this.aliquotaGeralValorFinanciado = aliquotaGeralValorFinanciado;
    }

    @Generated
    public void setAliquotaGeralAliquotaFinanciado(BigDecimal aliquotaGeralAliquotaFinanciado) {
        this.aliquotaGeralAliquotaFinanciado = aliquotaGeralAliquotaFinanciado;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParametroItbiDTO)) {
            return false;
        }
        ParametroItbiDTO other = (ParametroItbiDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Boolean this$ativo = this.getAtivo();
        Boolean other$ativo = other.getAtivo();
        if (this$ativo == null ? other$ativo != null : !((Object)this$ativo).equals(other$ativo)) {
            return false;
        }
        Long this$prazoPagamento = this.getPrazoPagamento();
        Long other$prazoPagamento = other.getPrazoPagamento();
        if (this$prazoPagamento == null ? other$prazoPagamento != null : !((Object)this$prazoPagamento).equals(other$prazoPagamento)) {
            return false;
        }
        Long this$prazoDeferimento = this.getPrazoDeferimento();
        Long other$prazoDeferimento = other.getPrazoDeferimento();
        if (this$prazoDeferimento == null ? other$prazoDeferimento != null : !((Object)this$prazoDeferimento).equals(other$prazoDeferimento)) {
            return false;
        }
        Boolean this$transfereTodasUnidades = this.getTransfereTodasUnidades();
        Boolean other$transfereTodasUnidades = other.getTransfereTodasUnidades();
        if (this$transfereTodasUnidades == null ? other$transfereTodasUnidades != null : !((Object)this$transfereTodasUnidades).equals(other$transfereTodasUnidades)) {
            return false;
        }
        Boolean this$transfereSemPagamento = this.getTransfereSemPagamento();
        Boolean other$transfereSemPagamento = other.getTransfereSemPagamento();
        if (this$transfereSemPagamento == null ? other$transfereSemPagamento != null : !((Object)this$transfereSemPagamento).equals(other$transfereSemPagamento)) {
            return false;
        }
        Boolean this$informaProtocolo = this.getInformaProtocolo();
        Boolean other$informaProtocolo = other.getInformaProtocolo();
        if (this$informaProtocolo == null ? other$informaProtocolo != null : !((Object)this$informaProtocolo).equals(other$informaProtocolo)) {
            return false;
        }
        Boolean this$alteraDataRefenciaBoleto = this.getAlteraDataRefenciaBoleto();
        Boolean other$alteraDataRefenciaBoleto = other.getAlteraDataRefenciaBoleto();
        if (this$alteraDataRefenciaBoleto == null ? other$alteraDataRefenciaBoleto != null : !((Object)this$alteraDataRefenciaBoleto).equals(other$alteraDataRefenciaBoleto)) {
            return false;
        }
        Boolean this$utilizaFormulaCalculo = this.getUtilizaFormulaCalculo();
        Boolean other$utilizaFormulaCalculo = other.getUtilizaFormulaCalculo();
        if (this$utilizaFormulaCalculo == null ? other$utilizaFormulaCalculo != null : !((Object)this$utilizaFormulaCalculo).equals(other$utilizaFormulaCalculo)) {
            return false;
        }
        Boolean this$mostraAvisoDebito = this.getMostraAvisoDebito();
        Boolean other$mostraAvisoDebito = other.getMostraAvisoDebito();
        if (this$mostraAvisoDebito == null ? other$mostraAvisoDebito != null : !((Object)this$mostraAvisoDebito).equals(other$mostraAvisoDebito)) {
            return false;
        }
        Boolean this$transfereSomenteResponsavel = this.getTransfereSomenteResponsavel();
        Boolean other$transfereSomenteResponsavel = other.getTransfereSomenteResponsavel();
        if (this$transfereSomenteResponsavel == null ? other$transfereSomenteResponsavel != null : !((Object)this$transfereSomenteResponsavel).equals(other$transfereSomenteResponsavel)) {
            return false;
        }
        Boolean this$transfereAutomaticamente = this.getTransfereAutomaticamente();
        Boolean other$transfereAutomaticamente = other.getTransfereAutomaticamente();
        if (this$transfereAutomaticamente == null ? other$transfereAutomaticamente != null : !((Object)this$transfereAutomaticamente).equals(other$transfereAutomaticamente)) {
            return false;
        }
        Boolean this$utilizaAliquotaDiferenciadaTipoNormal = this.getUtilizaAliquotaDiferenciadaTipoNormal();
        Boolean other$utilizaAliquotaDiferenciadaTipoNormal = other.getUtilizaAliquotaDiferenciadaTipoNormal();
        if (this$utilizaAliquotaDiferenciadaTipoNormal == null ? other$utilizaAliquotaDiferenciadaTipoNormal != null : !((Object)this$utilizaAliquotaDiferenciadaTipoNormal).equals(other$utilizaAliquotaDiferenciadaTipoNormal)) {
            return false;
        }
        Boolean this$utilizaAliquotaDiferenciadaTipoFinanciadoAVista = this.getUtilizaAliquotaDiferenciadaTipoFinanciadoAVista();
        Boolean other$utilizaAliquotaDiferenciadaTipoFinanciadoAVista = other.getUtilizaAliquotaDiferenciadaTipoFinanciadoAVista();
        if (this$utilizaAliquotaDiferenciadaTipoFinanciadoAVista == null ? other$utilizaAliquotaDiferenciadaTipoFinanciadoAVista != null : !((Object)this$utilizaAliquotaDiferenciadaTipoFinanciadoAVista).equals(other$utilizaAliquotaDiferenciadaTipoFinanciadoAVista)) {
            return false;
        }
        Boolean this$utilizaAliquotaDiferenciadaTipoFinanciado = this.getUtilizaAliquotaDiferenciadaTipoFinanciado();
        Boolean other$utilizaAliquotaDiferenciadaTipoFinanciado = other.getUtilizaAliquotaDiferenciadaTipoFinanciado();
        if (this$utilizaAliquotaDiferenciadaTipoFinanciado == null ? other$utilizaAliquotaDiferenciadaTipoFinanciado != null : !((Object)this$utilizaAliquotaDiferenciadaTipoFinanciado).equals(other$utilizaAliquotaDiferenciadaTipoFinanciado)) {
            return false;
        }
        Boolean this$usaAliquotaGeralFinanciado = this.getUsaAliquotaGeralFinanciado();
        Boolean other$usaAliquotaGeralFinanciado = other.getUsaAliquotaGeralFinanciado();
        if (this$usaAliquotaGeralFinanciado == null ? other$usaAliquotaGeralFinanciado != null : !((Object)this$usaAliquotaGeralFinanciado).equals(other$usaAliquotaGeralFinanciado)) {
            return false;
        }
        String this$descricao = this.getDescricao();
        String other$descricao = other.getDescricao();
        if (this$descricao == null ? other$descricao != null : !this$descricao.equals(other$descricao)) {
            return false;
        }
        Divida this$divida = this.getDivida();
        Divida other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !this$divida.equals(other$divida)) {
            return false;
        }
        ParamParcelamento this$parametroParcelamento = this.getParametroParcelamento();
        ParamParcelamento other$parametroParcelamento = other.getParametroParcelamento();
        if (this$parametroParcelamento == null ? other$parametroParcelamento != null : !this$parametroParcelamento.equals(other$parametroParcelamento)) {
            return false;
        }
        Tributo this$tributoPadrao = this.getTributoPadrao();
        Tributo other$tributoPadrao = other.getTributoPadrao();
        if (this$tributoPadrao == null ? other$tributoPadrao != null : !this$tributoPadrao.equals(other$tributoPadrao)) {
            return false;
        }
        BigDecimal this$aliquotaPadrao = this.getAliquotaPadrao();
        BigDecimal other$aliquotaPadrao = other.getAliquotaPadrao();
        if (this$aliquotaPadrao == null ? other$aliquotaPadrao != null : !((Object)this$aliquotaPadrao).equals(other$aliquotaPadrao)) {
            return false;
        }
        Tributo this$tributoAVista = this.getTributoAVista();
        Tributo other$tributoAVista = other.getTributoAVista();
        if (this$tributoAVista == null ? other$tributoAVista != null : !this$tributoAVista.equals(other$tributoAVista)) {
            return false;
        }
        BigDecimal this$aliquotaAVista = this.getAliquotaAVista();
        BigDecimal other$aliquotaAVista = other.getAliquotaAVista();
        if (this$aliquotaAVista == null ? other$aliquotaAVista != null : !((Object)this$aliquotaAVista).equals(other$aliquotaAVista)) {
            return false;
        }
        Tributo this$tributoFinanciado = this.getTributoFinanciado();
        Tributo other$tributoFinanciado = other.getTributoFinanciado();
        if (this$tributoFinanciado == null ? other$tributoFinanciado != null : !this$tributoFinanciado.equals(other$tributoFinanciado)) {
            return false;
        }
        BigDecimal this$aliquotaFinanciado = this.getAliquotaFinanciado();
        BigDecimal other$aliquotaFinanciado = other.getAliquotaFinanciado();
        if (this$aliquotaFinanciado == null ? other$aliquotaFinanciado != null : !((Object)this$aliquotaFinanciado).equals(other$aliquotaFinanciado)) {
            return false;
        }
        Tributo this$tributoAnuencia = this.getTributoAnuencia();
        Tributo other$tributoAnuencia = other.getTributoAnuencia();
        if (this$tributoAnuencia == null ? other$tributoAnuencia != null : !this$tributoAnuencia.equals(other$tributoAnuencia)) {
            return false;
        }
        BigDecimal this$aliquotaAnuencia = this.getAliquotaAnuencia();
        BigDecimal other$aliquotaAnuencia = other.getAliquotaAnuencia();
        if (this$aliquotaAnuencia == null ? other$aliquotaAnuencia != null : !((Object)this$aliquotaAnuencia).equals(other$aliquotaAnuencia)) {
            return false;
        }
        Relatorio this$modeloBoleto = this.getModeloBoleto();
        Relatorio other$modeloBoleto = other.getModeloBoleto();
        if (this$modeloBoleto == null ? other$modeloBoleto != null : !this$modeloBoleto.equals(other$modeloBoleto)) {
            return false;
        }
        Relatorio this$modeloCarne = this.getModeloCarne();
        Relatorio other$modeloCarne = other.getModeloCarne();
        if (this$modeloCarne == null ? other$modeloCarne != null : !this$modeloCarne.equals(other$modeloCarne)) {
            return false;
        }
        Relatorio this$termoIsencao = this.getTermoIsencao();
        Relatorio other$termoIsencao = other.getTermoIsencao();
        if (this$termoIsencao == null ? other$termoIsencao != null : !this$termoIsencao.equals(other$termoIsencao)) {
            return false;
        }
        MotivoDeducao this$motivoDeducaoPadraoExercicio = this.getMotivoDeducaoPadraoExercicio();
        MotivoDeducao other$motivoDeducaoPadraoExercicio = other.getMotivoDeducaoPadraoExercicio();
        if (this$motivoDeducaoPadraoExercicio == null ? other$motivoDeducaoPadraoExercicio != null : !this$motivoDeducaoPadraoExercicio.equals(other$motivoDeducaoPadraoExercicio)) {
            return false;
        }
        MotivoDeducao this$motivoDeducaoPadraoDividaAtiva = this.getMotivoDeducaoPadraoDividaAtiva();
        MotivoDeducao other$motivoDeducaoPadraoDividaAtiva = other.getMotivoDeducaoPadraoDividaAtiva();
        if (this$motivoDeducaoPadraoDividaAtiva == null ? other$motivoDeducaoPadraoDividaAtiva != null : !this$motivoDeducaoPadraoDividaAtiva.equals(other$motivoDeducaoPadraoDividaAtiva)) {
            return false;
        }
        TipoAplicacaoAliquotaItbi this$tipoAliquotaDiferenciadaNormal = this.getTipoAliquotaDiferenciadaNormal();
        TipoAplicacaoAliquotaItbi other$tipoAliquotaDiferenciadaNormal = other.getTipoAliquotaDiferenciadaNormal();
        if (this$tipoAliquotaDiferenciadaNormal == null ? other$tipoAliquotaDiferenciadaNormal != null : !this$tipoAliquotaDiferenciadaNormal.equals(other$tipoAliquotaDiferenciadaNormal)) {
            return false;
        }
        List this$aliquotasNormal = this.getAliquotasNormal();
        List other$aliquotasNormal = other.getAliquotasNormal();
        if (this$aliquotasNormal == null ? other$aliquotasNormal != null : !((Object)this$aliquotasNormal).equals(other$aliquotasNormal)) {
            return false;
        }
        TipoAplicacaoAliquotaItbi this$tipoAliquotaDiferenciadaFinanciadoAVista = this.getTipoAliquotaDiferenciadaFinanciadoAVista();
        TipoAplicacaoAliquotaItbi other$tipoAliquotaDiferenciadaFinanciadoAVista = other.getTipoAliquotaDiferenciadaFinanciadoAVista();
        if (this$tipoAliquotaDiferenciadaFinanciadoAVista == null ? other$tipoAliquotaDiferenciadaFinanciadoAVista != null : !this$tipoAliquotaDiferenciadaFinanciadoAVista.equals(other$tipoAliquotaDiferenciadaFinanciadoAVista)) {
            return false;
        }
        List this$aliquotasFinanciadoAVista = this.getAliquotasFinanciadoAVista();
        List other$aliquotasFinanciadoAVista = other.getAliquotasFinanciadoAVista();
        if (this$aliquotasFinanciadoAVista == null ? other$aliquotasFinanciadoAVista != null : !((Object)this$aliquotasFinanciadoAVista).equals(other$aliquotasFinanciadoAVista)) {
            return false;
        }
        TipoAplicacaoAliquotaItbi this$tipoAliquotaDiferenciadaFinanciado = this.getTipoAliquotaDiferenciadaFinanciado();
        TipoAplicacaoAliquotaItbi other$tipoAliquotaDiferenciadaFinanciado = other.getTipoAliquotaDiferenciadaFinanciado();
        if (this$tipoAliquotaDiferenciadaFinanciado == null ? other$tipoAliquotaDiferenciadaFinanciado != null : !this$tipoAliquotaDiferenciadaFinanciado.equals(other$tipoAliquotaDiferenciadaFinanciado)) {
            return false;
        }
        List this$aliquotasFinanciado = this.getAliquotasFinanciado();
        List other$aliquotasFinanciado = other.getAliquotasFinanciado();
        if (this$aliquotasFinanciado == null ? other$aliquotasFinanciado != null : !((Object)this$aliquotasFinanciado).equals(other$aliquotasFinanciado)) {
            return false;
        }
        BigDecimal this$aliquotaGeralValorFinanciado = this.getAliquotaGeralValorFinanciado();
        BigDecimal other$aliquotaGeralValorFinanciado = other.getAliquotaGeralValorFinanciado();
        if (this$aliquotaGeralValorFinanciado == null ? other$aliquotaGeralValorFinanciado != null : !((Object)this$aliquotaGeralValorFinanciado).equals(other$aliquotaGeralValorFinanciado)) {
            return false;
        }
        BigDecimal this$aliquotaGeralAliquotaFinanciado = this.getAliquotaGeralAliquotaFinanciado();
        BigDecimal other$aliquotaGeralAliquotaFinanciado = other.getAliquotaGeralAliquotaFinanciado();
        return !(this$aliquotaGeralAliquotaFinanciado == null ? other$aliquotaGeralAliquotaFinanciado != null : !((Object)this$aliquotaGeralAliquotaFinanciado).equals(other$aliquotaGeralAliquotaFinanciado));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ParametroItbiDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Boolean $ativo = this.getAtivo();
        result = result * 59 + ($ativo == null ? 43 : ((Object)$ativo).hashCode());
        Long $prazoPagamento = this.getPrazoPagamento();
        result = result * 59 + ($prazoPagamento == null ? 43 : ((Object)$prazoPagamento).hashCode());
        Long $prazoDeferimento = this.getPrazoDeferimento();
        result = result * 59 + ($prazoDeferimento == null ? 43 : ((Object)$prazoDeferimento).hashCode());
        Boolean $transfereTodasUnidades = this.getTransfereTodasUnidades();
        result = result * 59 + ($transfereTodasUnidades == null ? 43 : ((Object)$transfereTodasUnidades).hashCode());
        Boolean $transfereSemPagamento = this.getTransfereSemPagamento();
        result = result * 59 + ($transfereSemPagamento == null ? 43 : ((Object)$transfereSemPagamento).hashCode());
        Boolean $informaProtocolo = this.getInformaProtocolo();
        result = result * 59 + ($informaProtocolo == null ? 43 : ((Object)$informaProtocolo).hashCode());
        Boolean $alteraDataRefenciaBoleto = this.getAlteraDataRefenciaBoleto();
        result = result * 59 + ($alteraDataRefenciaBoleto == null ? 43 : ((Object)$alteraDataRefenciaBoleto).hashCode());
        Boolean $utilizaFormulaCalculo = this.getUtilizaFormulaCalculo();
        result = result * 59 + ($utilizaFormulaCalculo == null ? 43 : ((Object)$utilizaFormulaCalculo).hashCode());
        Boolean $mostraAvisoDebito = this.getMostraAvisoDebito();
        result = result * 59 + ($mostraAvisoDebito == null ? 43 : ((Object)$mostraAvisoDebito).hashCode());
        Boolean $transfereSomenteResponsavel = this.getTransfereSomenteResponsavel();
        result = result * 59 + ($transfereSomenteResponsavel == null ? 43 : ((Object)$transfereSomenteResponsavel).hashCode());
        Boolean $transfereAutomaticamente = this.getTransfereAutomaticamente();
        result = result * 59 + ($transfereAutomaticamente == null ? 43 : ((Object)$transfereAutomaticamente).hashCode());
        Boolean $utilizaAliquotaDiferenciadaTipoNormal = this.getUtilizaAliquotaDiferenciadaTipoNormal();
        result = result * 59 + ($utilizaAliquotaDiferenciadaTipoNormal == null ? 43 : ((Object)$utilizaAliquotaDiferenciadaTipoNormal).hashCode());
        Boolean $utilizaAliquotaDiferenciadaTipoFinanciadoAVista = this.getUtilizaAliquotaDiferenciadaTipoFinanciadoAVista();
        result = result * 59 + ($utilizaAliquotaDiferenciadaTipoFinanciadoAVista == null ? 43 : ((Object)$utilizaAliquotaDiferenciadaTipoFinanciadoAVista).hashCode());
        Boolean $utilizaAliquotaDiferenciadaTipoFinanciado = this.getUtilizaAliquotaDiferenciadaTipoFinanciado();
        result = result * 59 + ($utilizaAliquotaDiferenciadaTipoFinanciado == null ? 43 : ((Object)$utilizaAliquotaDiferenciadaTipoFinanciado).hashCode());
        Boolean $usaAliquotaGeralFinanciado = this.getUsaAliquotaGeralFinanciado();
        result = result * 59 + ($usaAliquotaGeralFinanciado == null ? 43 : ((Object)$usaAliquotaGeralFinanciado).hashCode());
        String $descricao = this.getDescricao();
        result = result * 59 + ($descricao == null ? 43 : $descricao.hashCode());
        Divida $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : $divida.hashCode());
        ParamParcelamento $parametroParcelamento = this.getParametroParcelamento();
        result = result * 59 + ($parametroParcelamento == null ? 43 : $parametroParcelamento.hashCode());
        Tributo $tributoPadrao = this.getTributoPadrao();
        result = result * 59 + ($tributoPadrao == null ? 43 : $tributoPadrao.hashCode());
        BigDecimal $aliquotaPadrao = this.getAliquotaPadrao();
        result = result * 59 + ($aliquotaPadrao == null ? 43 : ((Object)$aliquotaPadrao).hashCode());
        Tributo $tributoAVista = this.getTributoAVista();
        result = result * 59 + ($tributoAVista == null ? 43 : $tributoAVista.hashCode());
        BigDecimal $aliquotaAVista = this.getAliquotaAVista();
        result = result * 59 + ($aliquotaAVista == null ? 43 : ((Object)$aliquotaAVista).hashCode());
        Tributo $tributoFinanciado = this.getTributoFinanciado();
        result = result * 59 + ($tributoFinanciado == null ? 43 : $tributoFinanciado.hashCode());
        BigDecimal $aliquotaFinanciado = this.getAliquotaFinanciado();
        result = result * 59 + ($aliquotaFinanciado == null ? 43 : ((Object)$aliquotaFinanciado).hashCode());
        Tributo $tributoAnuencia = this.getTributoAnuencia();
        result = result * 59 + ($tributoAnuencia == null ? 43 : $tributoAnuencia.hashCode());
        BigDecimal $aliquotaAnuencia = this.getAliquotaAnuencia();
        result = result * 59 + ($aliquotaAnuencia == null ? 43 : ((Object)$aliquotaAnuencia).hashCode());
        Relatorio $modeloBoleto = this.getModeloBoleto();
        result = result * 59 + ($modeloBoleto == null ? 43 : $modeloBoleto.hashCode());
        Relatorio $modeloCarne = this.getModeloCarne();
        result = result * 59 + ($modeloCarne == null ? 43 : $modeloCarne.hashCode());
        Relatorio $termoIsencao = this.getTermoIsencao();
        result = result * 59 + ($termoIsencao == null ? 43 : $termoIsencao.hashCode());
        MotivoDeducao $motivoDeducaoPadraoExercicio = this.getMotivoDeducaoPadraoExercicio();
        result = result * 59 + ($motivoDeducaoPadraoExercicio == null ? 43 : $motivoDeducaoPadraoExercicio.hashCode());
        MotivoDeducao $motivoDeducaoPadraoDividaAtiva = this.getMotivoDeducaoPadraoDividaAtiva();
        result = result * 59 + ($motivoDeducaoPadraoDividaAtiva == null ? 43 : $motivoDeducaoPadraoDividaAtiva.hashCode());
        TipoAplicacaoAliquotaItbi $tipoAliquotaDiferenciadaNormal = this.getTipoAliquotaDiferenciadaNormal();
        result = result * 59 + ($tipoAliquotaDiferenciadaNormal == null ? 43 : $tipoAliquotaDiferenciadaNormal.hashCode());
        List $aliquotasNormal = this.getAliquotasNormal();
        result = result * 59 + ($aliquotasNormal == null ? 43 : ((Object)$aliquotasNormal).hashCode());
        TipoAplicacaoAliquotaItbi $tipoAliquotaDiferenciadaFinanciadoAVista = this.getTipoAliquotaDiferenciadaFinanciadoAVista();
        result = result * 59 + ($tipoAliquotaDiferenciadaFinanciadoAVista == null ? 43 : $tipoAliquotaDiferenciadaFinanciadoAVista.hashCode());
        List $aliquotasFinanciadoAVista = this.getAliquotasFinanciadoAVista();
        result = result * 59 + ($aliquotasFinanciadoAVista == null ? 43 : ((Object)$aliquotasFinanciadoAVista).hashCode());
        TipoAplicacaoAliquotaItbi $tipoAliquotaDiferenciadaFinanciado = this.getTipoAliquotaDiferenciadaFinanciado();
        result = result * 59 + ($tipoAliquotaDiferenciadaFinanciado == null ? 43 : $tipoAliquotaDiferenciadaFinanciado.hashCode());
        List $aliquotasFinanciado = this.getAliquotasFinanciado();
        result = result * 59 + ($aliquotasFinanciado == null ? 43 : ((Object)$aliquotasFinanciado).hashCode());
        BigDecimal $aliquotaGeralValorFinanciado = this.getAliquotaGeralValorFinanciado();
        result = result * 59 + ($aliquotaGeralValorFinanciado == null ? 43 : ((Object)$aliquotaGeralValorFinanciado).hashCode());
        BigDecimal $aliquotaGeralAliquotaFinanciado = this.getAliquotaGeralAliquotaFinanciado();
        result = result * 59 + ($aliquotaGeralAliquotaFinanciado == null ? 43 : ((Object)$aliquotaGeralAliquotaFinanciado).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ParametroItbiDTO(id=" + this.getId() + ")";
    }
}

