/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.PagamentoNegociadoDebNovo;
import br.com.elotech.tributos.domain.PagamentoNegociadoDebOrigem;
import br.com.elotech.tributos.domain.SituacaoPagNegociadoNovo;
import br.com.elotech.tributos.enums.OperacoesPagamentoNegociado;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class PagamentoNegociadoDebitoDTO {
    private Long idDebito;
    private Long entidade;
    private Long exercicio;
    private Long tipoCadastro;
    private Long cadastroGeral;
    private Long subDivida;
    private Long parcela;
    private Long guiaRecolhimento;
    private String situacao;
    private BigDecimal valor = BigDecimal.ZERO;
    private BigDecimal totalDebito = BigDecimal.ZERO;

    public static PagamentoNegociadoDebitoDTO from(PagamentoNegociadoDebOrigem origem) {
        PagamentoNegociadoDebitoDTO dto = new PagamentoNegociadoDebitoDTO();
        Optional.ofNullable(origem.getId().getDebitoParcela()).map(DebitoParcela::getDebito).map(Debito::getId).ifPresent(arg_0 -> dto.setIdDebito(arg_0));
        Optional.ofNullable(origem.getValorTotal()).ifPresent(arg_0 -> dto.setValor(arg_0));
        Optional.ofNullable(origem.getTotalDebito()).ifPresent(arg_0 -> dto.setTotalDebito(arg_0));
        Optional.ofNullable(origem.getOperacao()).ifPresent(arg_0 -> dto.setSituacao(arg_0));
        Optional.ofNullable(origem.getId().getDebitoParcela()).map(DebitoParcela::getId).ifPresent(debitoParcelaId -> {
            dto.setEntidade(debitoParcelaId.getEntidade());
            dto.setExercicio(debitoParcelaId.getExercicio());
            dto.setTipoCadastro(debitoParcelaId.getTipoCadastro());
            dto.setCadastroGeral(debitoParcelaId.getCadastroGeral());
            dto.setSubDivida(debitoParcelaId.getSubDivida());
            dto.setParcela(debitoParcelaId.getParcela());
            dto.setGuiaRecolhimento(debitoParcelaId.getDivida());
        });
        return dto;
    }

    public static PagamentoNegociadoDebitoDTO from(PagamentoNegociadoDebNovo debito, List<PagamentoNegociadoDebitoDTO> debitosOrigem) {
        PagamentoNegociadoDebitoDTO dto = new PagamentoNegociadoDebitoDTO();
        Optional.ofNullable(debito.getDebitoNovo()).map(DebitoParcela::getDebito).map(Debito::getId).ifPresent(arg_0 -> dto.setIdDebito(arg_0));
        Optional.ofNullable(debito.getDebitoNovo()).map(DebitoParcela::getValorTotal).ifPresent(arg_0 -> dto.setValor(arg_0));
        Optional.ofNullable(debito.getSituacao()).ifPresent(situacao -> dto.setSituacao(situacao.toString()));
        Optional.ofNullable(debito.getDebitoNovo()).map(DebitoParcela::getId).ifPresent(debitoParcelaId -> {
            dto.setEntidade(debitoParcelaId.getEntidade());
            dto.setExercicio(debitoParcelaId.getExercicio());
            dto.setTipoCadastro(debitoParcelaId.getTipoCadastro());
            dto.setCadastroGeral(debitoParcelaId.getCadastroGeral());
            dto.setSubDivida(debitoParcelaId.getSubDivida());
            dto.setParcela(debitoParcelaId.getParcela());
            dto.setGuiaRecolhimento(debitoParcelaId.getDivida());
        });
        if (SituacaoPagNegociadoNovo.ABERTO.equals((Object)debito.getSituacao())) {
            for (PagamentoNegociadoDebitoDTO debitoOrigem : debitosOrigem) {
                if (!OperacoesPagamentoNegociado.DIVIDIR_DEBITO.getTipo().equals(debitoOrigem.getSituacao())) continue;
                dto.setTotalDebito(debitoOrigem.getValor().subtract(debitoOrigem.getTotalDebito()));
            }
        }
        return dto;
    }

    @Generated
    public PagamentoNegociadoDebitoDTO() {
    }

    @Generated
    public Long getIdDebito() {
        return this.idDebito;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public Long getParcela() {
        return this.parcela;
    }

    @Generated
    public Long getGuiaRecolhimento() {
        return this.guiaRecolhimento;
    }

    @Generated
    public String getSituacao() {
        return this.situacao;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public BigDecimal getTotalDebito() {
        return this.totalDebito;
    }

    @Generated
    public void setIdDebito(Long idDebito) {
        this.idDebito = idDebito;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setSubDivida(Long subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setParcela(Long parcela) {
        this.parcela = parcela;
    }

    @Generated
    public void setGuiaRecolhimento(Long guiaRecolhimento) {
        this.guiaRecolhimento = guiaRecolhimento;
    }

    @Generated
    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setTotalDebito(BigDecimal totalDebito) {
        this.totalDebito = totalDebito;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PagamentoNegociadoDebitoDTO)) {
            return false;
        }
        PagamentoNegociadoDebitoDTO other = (PagamentoNegociadoDebitoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idDebito = this.getIdDebito();
        Long other$idDebito = other.getIdDebito();
        if (this$idDebito == null ? other$idDebito != null : !((Object)this$idDebito).equals(other$idDebito)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$subDivida = this.getSubDivida();
        Long other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !((Object)this$subDivida).equals(other$subDivida)) {
            return false;
        }
        Long this$parcela = this.getParcela();
        Long other$parcela = other.getParcela();
        if (this$parcela == null ? other$parcela != null : !((Object)this$parcela).equals(other$parcela)) {
            return false;
        }
        Long this$guiaRecolhimento = this.getGuiaRecolhimento();
        Long other$guiaRecolhimento = other.getGuiaRecolhimento();
        if (this$guiaRecolhimento == null ? other$guiaRecolhimento != null : !((Object)this$guiaRecolhimento).equals(other$guiaRecolhimento)) {
            return false;
        }
        String this$situacao = this.getSituacao();
        String other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !this$situacao.equals(other$situacao)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor)) {
            return false;
        }
        BigDecimal this$totalDebito = this.getTotalDebito();
        BigDecimal other$totalDebito = other.getTotalDebito();
        return !(this$totalDebito == null ? other$totalDebito != null : !((Object)this$totalDebito).equals(other$totalDebito));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PagamentoNegociadoDebitoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idDebito = this.getIdDebito();
        result = result * 59 + ($idDebito == null ? 43 : ((Object)$idDebito).hashCode());
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : ((Object)$subDivida).hashCode());
        Long $parcela = this.getParcela();
        result = result * 59 + ($parcela == null ? 43 : ((Object)$parcela).hashCode());
        Long $guiaRecolhimento = this.getGuiaRecolhimento();
        result = result * 59 + ($guiaRecolhimento == null ? 43 : ((Object)$guiaRecolhimento).hashCode());
        String $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : $situacao.hashCode());
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        BigDecimal $totalDebito = this.getTotalDebito();
        result = result * 59 + ($totalDebito == null ? 43 : ((Object)$totalDebito).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PagamentoNegociadoDebitoDTO(idDebito=" + this.getIdDebito() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", subDivida=" + this.getSubDivida() + ", parcela=" + this.getParcela() + ", guiaRecolhimento=" + this.getGuiaRecolhimento() + ", situacao=" + this.getSituacao() + ", valor=" + String.valueOf(this.getValor()) + ", totalDebito=" + String.valueOf(this.getTotalDebito()) + ")";
    }
}

