/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.domain.PagamentoNegociado;
import br.com.elotech.tributos.domain.PagamentoNegociadoDebNovo;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.pagamento.PagamentoLoteId;
import br.com.elotech.tributos.dto.BoletoDTO;
import br.com.elotech.tributos.dto.PagamentoNegociadoDebitoDTO;
import br.com.elotech.tributos.dto.PagamentoNegociadoSituacaoEnum;
import br.com.elotech.tributos.enums.negociacaodebito.TipoNegociacao;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class PagamentoNegociadoDTO {
    private Long id;
    private LocalDate dataNegociacao;
    private String tipoCadastro;
    private String cadastroGeral;
    private BigDecimal valorNegociacao = BigDecimal.ZERO;
    private String situacao;
    private String observacao;
    private String nomeConvenio;
    private LocalDate dataCredito;
    private PagamentoLoteId lote;
    private String usuario;
    private List<PagamentoNegociadoDebitoDTO> debitosOrigem;
    private List<PagamentoNegociadoDebitoDTO> debitosNovos;
    private String usuarioCancelamento;
    private LocalDate dataCancelamento;
    private String motivoCancelamento;
    private Long motivoDesconto;
    private BoletoDTO boleto;
    private String processoSei;
    private String processoJudicial;
    private TipoNegociacao tipoNegociacao;

    public boolean isCancelado() {
        return PagamentoNegociadoSituacaoEnum.CANCELADO.getDescricao().equals(this.situacao);
    }

    public static PagamentoNegociadoDTO basicFrom(PagamentoNegociado pagamento) {
        PagamentoNegociadoDTO dto = new PagamentoNegociadoDTO();
        Optional.ofNullable(pagamento.getId()).ifPresent(arg_0 -> dto.setId(arg_0));
        Optional.ofNullable(pagamento.getDataNegociacao()).ifPresent(arg_0 -> dto.setDataNegociacao(arg_0));
        Optional.ofNullable(pagamento.getTipoCadastrofiltro()).ifPresent(arg_0 -> dto.setTipoCadastro(arg_0));
        Optional.ofNullable(pagamento.getCadastroGeralfiltro()).ifPresent(arg_0 -> dto.setCadastroGeral(arg_0));
        Optional.ofNullable(pagamento.getValorNegociado()).ifPresent(arg_0 -> dto.setValorNegociacao(arg_0));
        Optional.ofNullable(pagamento.getCancelado()).map(PagamentoNegociadoSituacaoEnum::getDescricao).ifPresent(arg_0 -> dto.setSituacao(arg_0));
        Optional.ofNullable(pagamento.getObservacao()).ifPresent(arg_0 -> dto.setObservacao(arg_0));
        Optional.ofNullable(pagamento.getConvenio()).ifPresent(convenio -> dto.setNomeConvenio(convenio.getDescricao()));
        Optional.ofNullable(pagamento.getDataCredito()).ifPresent(arg_0 -> dto.setDataCredito(arg_0));
        Optional.ofNullable(pagamento.getUsuario()).ifPresent(arg_0 -> dto.setUsuario(arg_0));
        Optional.ofNullable(pagamento.getTipoNegociacao()).ifPresent(arg_0 -> dto.setTipoNegociacao(arg_0));
        Optional.ofNullable(pagamento.getProcessoSei()).ifPresent(arg_0 -> dto.setProcessoSei(arg_0));
        Optional.ofNullable(pagamento.getProcessoJudicial()).ifPresent(arg_0 -> dto.setProcessoJudicial(arg_0));
        Optional.ofNullable(pagamento.getPagamentoGerado()).map(Pagamento::getLote).map(PagamentoLote::getId).ifPresent(arg_0 -> dto.setLote(arg_0));
        Optional.ofNullable(pagamento.getUsuarioCancelamento()).ifPresent(arg_0 -> dto.setUsuarioCancelamento(arg_0));
        Optional.ofNullable(pagamento.getDataCancelamento()).ifPresent(arg_0 -> dto.setDataCancelamento(arg_0));
        Optional.ofNullable(pagamento.getMotivoCancelamento()).ifPresent(arg_0 -> dto.setMotivoCancelamento(arg_0));
        Optional.ofNullable(pagamento.getMotivoDesconto()).ifPresent(arg_0 -> dto.setMotivoDesconto(arg_0));
        Optional.ofNullable(pagamento.getBoletoGerado()).ifPresent(b -> dto.setBoleto(BoletoDTO.from((Bloqueto)b)));
        return dto;
    }

    public static PagamentoNegociadoDTO completeFrom(PagamentoNegociado pagamento) {
        PagamentoNegociadoDTO dto = PagamentoNegociadoDTO.basicFrom((PagamentoNegociado)pagamento);
        dto.setDebitosOrigem(pagamento.getDebitosOrigem().stream().map(PagamentoNegociadoDebitoDTO::from).collect(Collectors.toList()));
        dto.setDebitosNovos(pagamento.getDebitosNovos().stream().map(debitos -> PagamentoNegociadoDebitoDTO.from((PagamentoNegociadoDebNovo)debitos, (List)dto.getDebitosOrigem())).collect(Collectors.toList()));
        return dto;
    }

    @Generated
    public PagamentoNegociadoDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public LocalDate getDataNegociacao() {
        return this.dataNegociacao;
    }

    @Generated
    public String getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public String getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public BigDecimal getValorNegociacao() {
        return this.valorNegociacao;
    }

    @Generated
    public String getSituacao() {
        return this.situacao;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public String getNomeConvenio() {
        return this.nomeConvenio;
    }

    @Generated
    public LocalDate getDataCredito() {
        return this.dataCredito;
    }

    @Generated
    public PagamentoLoteId getLote() {
        return this.lote;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public List<PagamentoNegociadoDebitoDTO> getDebitosOrigem() {
        return this.debitosOrigem;
    }

    @Generated
    public List<PagamentoNegociadoDebitoDTO> getDebitosNovos() {
        return this.debitosNovos;
    }

    @Generated
    public String getUsuarioCancelamento() {
        return this.usuarioCancelamento;
    }

    @Generated
    public LocalDate getDataCancelamento() {
        return this.dataCancelamento;
    }

    @Generated
    public String getMotivoCancelamento() {
        return this.motivoCancelamento;
    }

    @Generated
    public Long getMotivoDesconto() {
        return this.motivoDesconto;
    }

    @Generated
    public BoletoDTO getBoleto() {
        return this.boleto;
    }

    @Generated
    public String getProcessoSei() {
        return this.processoSei;
    }

    @Generated
    public String getProcessoJudicial() {
        return this.processoJudicial;
    }

    @Generated
    public TipoNegociacao getTipoNegociacao() {
        return this.tipoNegociacao;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setDataNegociacao(LocalDate dataNegociacao) {
        this.dataNegociacao = dataNegociacao;
    }

    @Generated
    public void setTipoCadastro(String tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(String cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setValorNegociacao(BigDecimal valorNegociacao) {
        this.valorNegociacao = valorNegociacao;
    }

    @Generated
    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setNomeConvenio(String nomeConvenio) {
        this.nomeConvenio = nomeConvenio;
    }

    @Generated
    public void setDataCredito(LocalDate dataCredito) {
        this.dataCredito = dataCredito;
    }

    @Generated
    public void setLote(PagamentoLoteId lote) {
        this.lote = lote;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setDebitosOrigem(List<PagamentoNegociadoDebitoDTO> debitosOrigem) {
        this.debitosOrigem = debitosOrigem;
    }

    @Generated
    public void setDebitosNovos(List<PagamentoNegociadoDebitoDTO> debitosNovos) {
        this.debitosNovos = debitosNovos;
    }

    @Generated
    public void setUsuarioCancelamento(String usuarioCancelamento) {
        this.usuarioCancelamento = usuarioCancelamento;
    }

    @Generated
    public void setDataCancelamento(LocalDate dataCancelamento) {
        this.dataCancelamento = dataCancelamento;
    }

    @Generated
    public void setMotivoCancelamento(String motivoCancelamento) {
        this.motivoCancelamento = motivoCancelamento;
    }

    @Generated
    public void setMotivoDesconto(Long motivoDesconto) {
        this.motivoDesconto = motivoDesconto;
    }

    @Generated
    public void setBoleto(BoletoDTO boleto) {
        this.boleto = boleto;
    }

    @Generated
    public void setProcessoSei(String processoSei) {
        this.processoSei = processoSei;
    }

    @Generated
    public void setProcessoJudicial(String processoJudicial) {
        this.processoJudicial = processoJudicial;
    }

    @Generated
    public void setTipoNegociacao(TipoNegociacao tipoNegociacao) {
        this.tipoNegociacao = tipoNegociacao;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PagamentoNegociadoDTO)) {
            return false;
        }
        PagamentoNegociadoDTO other = (PagamentoNegociadoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$motivoDesconto = this.getMotivoDesconto();
        Long other$motivoDesconto = other.getMotivoDesconto();
        if (this$motivoDesconto == null ? other$motivoDesconto != null : !((Object)this$motivoDesconto).equals(other$motivoDesconto)) {
            return false;
        }
        LocalDate this$dataNegociacao = this.getDataNegociacao();
        LocalDate other$dataNegociacao = other.getDataNegociacao();
        if (this$dataNegociacao == null ? other$dataNegociacao != null : !((Object)this$dataNegociacao).equals(other$dataNegociacao)) {
            return false;
        }
        String this$tipoCadastro = this.getTipoCadastro();
        String other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !this$tipoCadastro.equals(other$tipoCadastro)) {
            return false;
        }
        String this$cadastroGeral = this.getCadastroGeral();
        String other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        BigDecimal this$valorNegociacao = this.getValorNegociacao();
        BigDecimal other$valorNegociacao = other.getValorNegociacao();
        if (this$valorNegociacao == null ? other$valorNegociacao != null : !((Object)this$valorNegociacao).equals(other$valorNegociacao)) {
            return false;
        }
        String this$situacao = this.getSituacao();
        String other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !this$situacao.equals(other$situacao)) {
            return false;
        }
        String this$observacao = this.getObservacao();
        String other$observacao = other.getObservacao();
        if (this$observacao == null ? other$observacao != null : !this$observacao.equals(other$observacao)) {
            return false;
        }
        String this$nomeConvenio = this.getNomeConvenio();
        String other$nomeConvenio = other.getNomeConvenio();
        if (this$nomeConvenio == null ? other$nomeConvenio != null : !this$nomeConvenio.equals(other$nomeConvenio)) {
            return false;
        }
        LocalDate this$dataCredito = this.getDataCredito();
        LocalDate other$dataCredito = other.getDataCredito();
        if (this$dataCredito == null ? other$dataCredito != null : !((Object)this$dataCredito).equals(other$dataCredito)) {
            return false;
        }
        PagamentoLoteId this$lote = this.getLote();
        PagamentoLoteId other$lote = other.getLote();
        if (this$lote == null ? other$lote != null : !this$lote.equals(other$lote)) {
            return false;
        }
        String this$usuario = this.getUsuario();
        String other$usuario = other.getUsuario();
        if (this$usuario == null ? other$usuario != null : !this$usuario.equals(other$usuario)) {
            return false;
        }
        List this$debitosOrigem = this.getDebitosOrigem();
        List other$debitosOrigem = other.getDebitosOrigem();
        if (this$debitosOrigem == null ? other$debitosOrigem != null : !((Object)this$debitosOrigem).equals(other$debitosOrigem)) {
            return false;
        }
        List this$debitosNovos = this.getDebitosNovos();
        List other$debitosNovos = other.getDebitosNovos();
        if (this$debitosNovos == null ? other$debitosNovos != null : !((Object)this$debitosNovos).equals(other$debitosNovos)) {
            return false;
        }
        String this$usuarioCancelamento = this.getUsuarioCancelamento();
        String other$usuarioCancelamento = other.getUsuarioCancelamento();
        if (this$usuarioCancelamento == null ? other$usuarioCancelamento != null : !this$usuarioCancelamento.equals(other$usuarioCancelamento)) {
            return false;
        }
        LocalDate this$dataCancelamento = this.getDataCancelamento();
        LocalDate other$dataCancelamento = other.getDataCancelamento();
        if (this$dataCancelamento == null ? other$dataCancelamento != null : !((Object)this$dataCancelamento).equals(other$dataCancelamento)) {
            return false;
        }
        String this$motivoCancelamento = this.getMotivoCancelamento();
        String other$motivoCancelamento = other.getMotivoCancelamento();
        if (this$motivoCancelamento == null ? other$motivoCancelamento != null : !this$motivoCancelamento.equals(other$motivoCancelamento)) {
            return false;
        }
        BoletoDTO this$boleto = this.getBoleto();
        BoletoDTO other$boleto = other.getBoleto();
        if (this$boleto == null ? other$boleto != null : !this$boleto.equals(other$boleto)) {
            return false;
        }
        String this$processoSei = this.getProcessoSei();
        String other$processoSei = other.getProcessoSei();
        if (this$processoSei == null ? other$processoSei != null : !this$processoSei.equals(other$processoSei)) {
            return false;
        }
        String this$processoJudicial = this.getProcessoJudicial();
        String other$processoJudicial = other.getProcessoJudicial();
        if (this$processoJudicial == null ? other$processoJudicial != null : !this$processoJudicial.equals(other$processoJudicial)) {
            return false;
        }
        TipoNegociacao this$tipoNegociacao = this.getTipoNegociacao();
        TipoNegociacao other$tipoNegociacao = other.getTipoNegociacao();
        return !(this$tipoNegociacao == null ? other$tipoNegociacao != null : !this$tipoNegociacao.equals(other$tipoNegociacao));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PagamentoNegociadoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $motivoDesconto = this.getMotivoDesconto();
        result = result * 59 + ($motivoDesconto == null ? 43 : ((Object)$motivoDesconto).hashCode());
        LocalDate $dataNegociacao = this.getDataNegociacao();
        result = result * 59 + ($dataNegociacao == null ? 43 : ((Object)$dataNegociacao).hashCode());
        String $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : $tipoCadastro.hashCode());
        String $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        BigDecimal $valorNegociacao = this.getValorNegociacao();
        result = result * 59 + ($valorNegociacao == null ? 43 : ((Object)$valorNegociacao).hashCode());
        String $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : $situacao.hashCode());
        String $observacao = this.getObservacao();
        result = result * 59 + ($observacao == null ? 43 : $observacao.hashCode());
        String $nomeConvenio = this.getNomeConvenio();
        result = result * 59 + ($nomeConvenio == null ? 43 : $nomeConvenio.hashCode());
        LocalDate $dataCredito = this.getDataCredito();
        result = result * 59 + ($dataCredito == null ? 43 : ((Object)$dataCredito).hashCode());
        PagamentoLoteId $lote = this.getLote();
        result = result * 59 + ($lote == null ? 43 : $lote.hashCode());
        String $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : $usuario.hashCode());
        List $debitosOrigem = this.getDebitosOrigem();
        result = result * 59 + ($debitosOrigem == null ? 43 : ((Object)$debitosOrigem).hashCode());
        List $debitosNovos = this.getDebitosNovos();
        result = result * 59 + ($debitosNovos == null ? 43 : ((Object)$debitosNovos).hashCode());
        String $usuarioCancelamento = this.getUsuarioCancelamento();
        result = result * 59 + ($usuarioCancelamento == null ? 43 : $usuarioCancelamento.hashCode());
        LocalDate $dataCancelamento = this.getDataCancelamento();
        result = result * 59 + ($dataCancelamento == null ? 43 : ((Object)$dataCancelamento).hashCode());
        String $motivoCancelamento = this.getMotivoCancelamento();
        result = result * 59 + ($motivoCancelamento == null ? 43 : $motivoCancelamento.hashCode());
        BoletoDTO $boleto = this.getBoleto();
        result = result * 59 + ($boleto == null ? 43 : $boleto.hashCode());
        String $processoSei = this.getProcessoSei();
        result = result * 59 + ($processoSei == null ? 43 : $processoSei.hashCode());
        String $processoJudicial = this.getProcessoJudicial();
        result = result * 59 + ($processoJudicial == null ? 43 : $processoJudicial.hashCode());
        TipoNegociacao $tipoNegociacao = this.getTipoNegociacao();
        result = result * 59 + ($tipoNegociacao == null ? 43 : $tipoNegociacao.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PagamentoNegociadoDTO(id=" + this.getId() + ", dataNegociacao=" + String.valueOf(this.getDataNegociacao()) + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", valorNegociacao=" + String.valueOf(this.getValorNegociacao()) + ", situacao=" + this.getSituacao() + ", observacao=" + this.getObservacao() + ", nomeConvenio=" + this.getNomeConvenio() + ", dataCredito=" + String.valueOf(this.getDataCredito()) + ", lote=" + String.valueOf(this.getLote()) + ", usuario=" + this.getUsuario() + ", debitosOrigem=" + String.valueOf(this.getDebitosOrigem()) + ", debitosNovos=" + String.valueOf(this.getDebitosNovos()) + ", usuarioCancelamento=" + this.getUsuarioCancelamento() + ", dataCancelamento=" + String.valueOf(this.getDataCancelamento()) + ", motivoCancelamento=" + this.getMotivoCancelamento() + ", motivoDesconto=" + this.getMotivoDesconto() + ", boleto=" + String.valueOf(this.getBoleto()) + ", processoSei=" + this.getProcessoSei() + ", processoJudicial=" + this.getProcessoJudicial() + ", tipoNegociacao=" + String.valueOf(this.getTipoNegociacao()) + ")";
    }
}

