/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.fluent.dataset.DatasetRecord;
import br.com.elotech.tributos.dto.ImplantacaoSaldoImpressaoDTO;
import br.com.elotech.tributos.dto.ImplantacaoSaldoTributosReport;
import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.dto.simam.ImplantacaoSaldoContabilidadeGroupedDTO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class ImplantacaoSaldoReport
implements DatasetRecord {
    private String exercicio;
    private String usuarioGeracao;
    private String dataGeracao;
    private String dataReferencia;
    private BigDecimal valorTotal;
    private BigDecimal valorTotalEX;
    private BigDecimal valorTotalDA;
    private List<ImplantacaoSaldoTributosReport> tributosEX;
    private List<ImplantacaoSaldoTributosReport> tributosDA;

    public static ImplantacaoSaldoReport from(ImplantacaoSaldoImpressaoDTO dto) {
        ImplantacaoSaldoReport report = new ImplantacaoSaldoReport();
        Map<Long, List<ImplantacaoSaldoContabilidadeGroupedDTO>> receitas = dto.getDados().stream().collect(Collectors.groupingBy(ImplantacaoSaldoContabilidadeGroupedDTO::getSituacaoLegal));
        List receitasEX = receitas.getOrDefault(SituacaoLegal.NO_EXERCICIO.getCodigo(), new ArrayList());
        List receitasDA = receitas.getOrDefault(SituacaoLegal.DIVIDA_ATIVA.getCodigo(), new ArrayList());
        report.setValorTotalEX(receitasEX.stream().map(ImplantacaoSaldoContabilidadeGroupedDTO::getValor).reduce(BigDecimal.ZERO, BigDecimal::add));
        report.setValorTotalDA(receitasDA.stream().map(ImplantacaoSaldoContabilidadeGroupedDTO::getValor).reduce(BigDecimal.ZERO, BigDecimal::add));
        report.setValorTotal(report.getValorTotalEX().add(report.getValorTotalDA()));
        report.setTributosEX(ImplantacaoSaldoReport.getDadosTributos((List)receitasEX));
        report.setTributosDA(ImplantacaoSaldoReport.getDadosTributos((List)receitasDA));
        report.setExercicio(String.format("Exerc\u00edcio de %s", dto.getExercicio()));
        report.setUsuarioGeracao(dto.getUsuarioGeracao());
        report.setDataGeracao(dto.getDataGeracao());
        report.setDataReferencia(dto.getDataReferencia());
        return report;
    }

    private static List<ImplantacaoSaldoTributosReport> getDadosTributos(List<ImplantacaoSaldoContabilidadeGroupedDTO> receitas) {
        return receitas.stream().map(ImplantacaoSaldoTributosReport::new).collect(Collectors.toList());
    }

    @Generated
    public ImplantacaoSaldoReport() {
    }

    @Generated
    public String getExercicio() {
        return this.exercicio;
    }

    @Generated
    public String getUsuarioGeracao() {
        return this.usuarioGeracao;
    }

    @Generated
    public String getDataGeracao() {
        return this.dataGeracao;
    }

    @Generated
    public String getDataReferencia() {
        return this.dataReferencia;
    }

    @Generated
    public BigDecimal getValorTotal() {
        return this.valorTotal;
    }

    @Generated
    public BigDecimal getValorTotalEX() {
        return this.valorTotalEX;
    }

    @Generated
    public BigDecimal getValorTotalDA() {
        return this.valorTotalDA;
    }

    @Generated
    public List<ImplantacaoSaldoTributosReport> getTributosEX() {
        return this.tributosEX;
    }

    @Generated
    public List<ImplantacaoSaldoTributosReport> getTributosDA() {
        return this.tributosDA;
    }

    @Generated
    public void setExercicio(String exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setUsuarioGeracao(String usuarioGeracao) {
        this.usuarioGeracao = usuarioGeracao;
    }

    @Generated
    public void setDataGeracao(String dataGeracao) {
        this.dataGeracao = dataGeracao;
    }

    @Generated
    public void setDataReferencia(String dataReferencia) {
        this.dataReferencia = dataReferencia;
    }

    @Generated
    public void setValorTotal(BigDecimal valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Generated
    public void setValorTotalEX(BigDecimal valorTotalEX) {
        this.valorTotalEX = valorTotalEX;
    }

    @Generated
    public void setValorTotalDA(BigDecimal valorTotalDA) {
        this.valorTotalDA = valorTotalDA;
    }

    @Generated
    public void setTributosEX(List<ImplantacaoSaldoTributosReport> tributosEX) {
        this.tributosEX = tributosEX;
    }

    @Generated
    public void setTributosDA(List<ImplantacaoSaldoTributosReport> tributosDA) {
        this.tributosDA = tributosDA;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImplantacaoSaldoReport)) {
            return false;
        }
        ImplantacaoSaldoReport other = (ImplantacaoSaldoReport)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$exercicio = this.getExercicio();
        String other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !this$exercicio.equals(other$exercicio)) {
            return false;
        }
        String this$usuarioGeracao = this.getUsuarioGeracao();
        String other$usuarioGeracao = other.getUsuarioGeracao();
        if (this$usuarioGeracao == null ? other$usuarioGeracao != null : !this$usuarioGeracao.equals(other$usuarioGeracao)) {
            return false;
        }
        String this$dataGeracao = this.getDataGeracao();
        String other$dataGeracao = other.getDataGeracao();
        if (this$dataGeracao == null ? other$dataGeracao != null : !this$dataGeracao.equals(other$dataGeracao)) {
            return false;
        }
        String this$dataReferencia = this.getDataReferencia();
        String other$dataReferencia = other.getDataReferencia();
        if (this$dataReferencia == null ? other$dataReferencia != null : !this$dataReferencia.equals(other$dataReferencia)) {
            return false;
        }
        BigDecimal this$valorTotal = this.getValorTotal();
        BigDecimal other$valorTotal = other.getValorTotal();
        if (this$valorTotal == null ? other$valorTotal != null : !((Object)this$valorTotal).equals(other$valorTotal)) {
            return false;
        }
        BigDecimal this$valorTotalEX = this.getValorTotalEX();
        BigDecimal other$valorTotalEX = other.getValorTotalEX();
        if (this$valorTotalEX == null ? other$valorTotalEX != null : !((Object)this$valorTotalEX).equals(other$valorTotalEX)) {
            return false;
        }
        BigDecimal this$valorTotalDA = this.getValorTotalDA();
        BigDecimal other$valorTotalDA = other.getValorTotalDA();
        if (this$valorTotalDA == null ? other$valorTotalDA != null : !((Object)this$valorTotalDA).equals(other$valorTotalDA)) {
            return false;
        }
        List this$tributosEX = this.getTributosEX();
        List other$tributosEX = other.getTributosEX();
        if (this$tributosEX == null ? other$tributosEX != null : !((Object)this$tributosEX).equals(other$tributosEX)) {
            return false;
        }
        List this$tributosDA = this.getTributosDA();
        List other$tributosDA = other.getTributosDA();
        return !(this$tributosDA == null ? other$tributosDA != null : !((Object)this$tributosDA).equals(other$tributosDA));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ImplantacaoSaldoReport;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : $exercicio.hashCode());
        String $usuarioGeracao = this.getUsuarioGeracao();
        result = result * 59 + ($usuarioGeracao == null ? 43 : $usuarioGeracao.hashCode());
        String $dataGeracao = this.getDataGeracao();
        result = result * 59 + ($dataGeracao == null ? 43 : $dataGeracao.hashCode());
        String $dataReferencia = this.getDataReferencia();
        result = result * 59 + ($dataReferencia == null ? 43 : $dataReferencia.hashCode());
        BigDecimal $valorTotal = this.getValorTotal();
        result = result * 59 + ($valorTotal == null ? 43 : ((Object)$valorTotal).hashCode());
        BigDecimal $valorTotalEX = this.getValorTotalEX();
        result = result * 59 + ($valorTotalEX == null ? 43 : ((Object)$valorTotalEX).hashCode());
        BigDecimal $valorTotalDA = this.getValorTotalDA();
        result = result * 59 + ($valorTotalDA == null ? 43 : ((Object)$valorTotalDA).hashCode());
        List $tributosEX = this.getTributosEX();
        result = result * 59 + ($tributosEX == null ? 43 : ((Object)$tributosEX).hashCode());
        List $tributosDA = this.getTributosDA();
        result = result * 59 + ($tributosDA == null ? 43 : ((Object)$tributosDA).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ImplantacaoSaldoReport(exercicio=" + this.getExercicio() + ", usuarioGeracao=" + this.getUsuarioGeracao() + ", dataGeracao=" + this.getDataGeracao() + ", dataReferencia=" + this.getDataReferencia() + ", valorTotal=" + String.valueOf(this.getValorTotal()) + ", valorTotalEX=" + String.valueOf(this.getValorTotalEX()) + ", valorTotalDA=" + String.valueOf(this.getValorTotalDA()) + ", tributosEX=" + String.valueOf(this.getTributosEX()) + ", tributosDA=" + String.valueOf(this.getTributosDA()) + ")";
    }
}

