/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoDocumentoEnum;
import br.com.elotech.tributos.dto.AlvaraLocalizacaoDTO;
import br.com.elotech.tributos.dto.DocumentoCertidaoItemDTO;
import br.com.elotech.tributos.dto.DocumentoGenericoDTO;
import br.com.elotech.tributos.dto.FiltroProjetoDTO;
import br.com.elotech.tributos.util.FileUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public class GeracaoDocumentoDTO {
    private String requerenteNome;
    private String requerenteCpfCnpj;
    private TipoPessoa tipoPessoaRequerente;
    private Long idProcesso;
    private Long exercicioProcesso;
    private CadastroGeral cadastroGeral;
    private Long idTipoDocumento;
    private Long idFinalidade;
    private Pessoa pessoa;
    private String observacao;
    private String usuario;
    private Boolean web = Boolean.FALSE;
    private Boolean certidaoEspecial = Boolean.FALSE;
    private Long idSequenciaItbi;
    private FiltroProjetoDTO dadosProjeto;
    private String processoSei;
    private String codigoPgd;
    private LocalDate dataEmissao;
    private String numeroPrimeiroAlvara;
    private String anoEmissaoAlvara;
    private LocalDate dataPrimeiroAlvara;
    private String codigoPrancha;
    private BigDecimal areaAcrescimoOrDecrescimo;
    private List<DocumentoCertidaoItemDTO> documentoCertidaoItens = new ArrayList();
    private byte[] cabecalho;
    private byte[] rodape;
    private BigDecimal areaTotalConstruida;
    private Long solicitacaoAlvara;

    public static GeracaoDocumentoDTO from(AlvaraLocalizacaoDTO alvaraLocalizacaoDTO, CadastroGeral cadastroGeral) {
        GeracaoDocumentoDTO geracaoDocumentoDTO = new GeracaoDocumentoDTO();
        geracaoDocumentoDTO.setIdProcesso(alvaraLocalizacaoDTO.getIdProcesso());
        geracaoDocumentoDTO.setExercicioProcesso(alvaraLocalizacaoDTO.getExercicioProcesso());
        geracaoDocumentoDTO.setCadastroGeral(cadastroGeral);
        geracaoDocumentoDTO.setIdTipoDocumento(TipoDocumentoEnum.ALVARA_LOCALIZACAO.getValue());
        geracaoDocumentoDTO.setCabecalho(FileUtils.safeTextToBytes((String)alvaraLocalizacaoDTO.getCabecalho()));
        geracaoDocumentoDTO.setRodape(FileUtils.safeTextToBytes((String)alvaraLocalizacaoDTO.getRodape()));
        geracaoDocumentoDTO.setObservacao(alvaraLocalizacaoDTO.getObservacao());
        Optional.ofNullable(alvaraLocalizacaoDTO.getPessoa()).ifPresent(pessoa -> {
            geracaoDocumentoDTO.setRequerenteNome(pessoa.getNome());
            geracaoDocumentoDTO.setRequerenteCpfCnpj(pessoa.getCnpjCpf());
            geracaoDocumentoDTO.setTipoPessoaRequerente(pessoa.getTipoPessoa());
        });
        geracaoDocumentoDTO.setAreaTotalConstruida(alvaraLocalizacaoDTO.getAreaTotalConstruida());
        geracaoDocumentoDTO.setSolicitacaoAlvara(alvaraLocalizacaoDTO.getSolicitacaoAlvara());
        geracaoDocumentoDTO.setUsuario(alvaraLocalizacaoDTO.getUsuario());
        return geracaoDocumentoDTO;
    }

    public static GeracaoDocumentoDTO from(DocumentoGenericoDTO documentoGenericoDTO, Pessoa pessoa, TipoDocumentoEnum tipoDocumento) {
        GeracaoDocumentoDTO geracaoDocumentoDTO = new GeracaoDocumentoDTO();
        geracaoDocumentoDTO.setIdProcesso(documentoGenericoDTO.getIdProcesso());
        geracaoDocumentoDTO.setExercicioProcesso(documentoGenericoDTO.getExercicioProcesso());
        geracaoDocumentoDTO.setIdTipoDocumento(tipoDocumento.getValue());
        geracaoDocumentoDTO.setRequerenteNome(documentoGenericoDTO.getPessoaNome());
        geracaoDocumentoDTO.setRequerenteCpfCnpj(documentoGenericoDTO.getPessoaCpfCnpj());
        geracaoDocumentoDTO.setTipoPessoaRequerente(documentoGenericoDTO.getTipoPessoa());
        geracaoDocumentoDTO.setIdFinalidade(Objects.equals(documentoGenericoDTO.getFinalidade(), 0L) ? null : documentoGenericoDTO.getFinalidade());
        geracaoDocumentoDTO.setObservacao(documentoGenericoDTO.getObservacao());
        geracaoDocumentoDTO.setPessoa(pessoa);
        geracaoDocumentoDTO.setUsuario(documentoGenericoDTO.getUsuario());
        geracaoDocumentoDTO.setWeb(documentoGenericoDTO.getWeb());
        geracaoDocumentoDTO.setCertidaoEspecial(documentoGenericoDTO.getCertidaoEspecial());
        geracaoDocumentoDTO.setProcessoSei(documentoGenericoDTO.getProcessoSei());
        geracaoDocumentoDTO.setCodigoPgd(documentoGenericoDTO.getCodigoPgd());
        geracaoDocumentoDTO.setDataEmissao(documentoGenericoDTO.getDataEmissao());
        geracaoDocumentoDTO.setNumeroPrimeiroAlvara(documentoGenericoDTO.getNumeroPrimeiroAlvara());
        geracaoDocumentoDTO.setAnoEmissaoAlvara(documentoGenericoDTO.getAnoEmissaoAlvara());
        geracaoDocumentoDTO.setDataPrimeiroAlvara(documentoGenericoDTO.getDataPrimeiroAlvara());
        geracaoDocumentoDTO.setCodigoPrancha(documentoGenericoDTO.getCodigoPrancha());
        geracaoDocumentoDTO.setAreaAcrescimoOrDecrescimo(documentoGenericoDTO.getAreaAcrescimoOrDecrescimo());
        geracaoDocumentoDTO.setDocumentoCertidaoItens(documentoGenericoDTO.getDocumentoCertidaoItens());
        geracaoDocumentoDTO.setCabecalho(FileUtils.safeTextToBytes((String)documentoGenericoDTO.getCabecalho()));
        geracaoDocumentoDTO.setRodape(FileUtils.safeTextToBytes((String)documentoGenericoDTO.getRodape()));
        geracaoDocumentoDTO.setAreaTotalConstruida(documentoGenericoDTO.getAreaTotalConstruida());
        geracaoDocumentoDTO.setSolicitacaoAlvara(documentoGenericoDTO.getSolicitacaoAlvara());
        return geracaoDocumentoDTO;
    }

    public static GeracaoDocumentoDTO from(DocumentoGenericoDTO documentoGenericoDTO, CadastroGeral cadastroGeral, TipoDocumentoEnum tipoDocumento) {
        GeracaoDocumentoDTO geracaoDocumentoDTO = new GeracaoDocumentoDTO();
        geracaoDocumentoDTO.setIdProcesso(documentoGenericoDTO.getIdProcesso());
        geracaoDocumentoDTO.setExercicioProcesso(documentoGenericoDTO.getExercicioProcesso());
        geracaoDocumentoDTO.setIdTipoDocumento(tipoDocumento.getValue());
        geracaoDocumentoDTO.setRequerenteNome(documentoGenericoDTO.getPessoaNome());
        geracaoDocumentoDTO.setRequerenteCpfCnpj(documentoGenericoDTO.getPessoaCpfCnpj());
        geracaoDocumentoDTO.setTipoPessoaRequerente(documentoGenericoDTO.getTipoPessoa());
        geracaoDocumentoDTO.setIdFinalidade(Objects.equals(documentoGenericoDTO.getFinalidade(), 0L) ? null : documentoGenericoDTO.getFinalidade());
        geracaoDocumentoDTO.setObservacao(documentoGenericoDTO.getObservacao());
        geracaoDocumentoDTO.setCadastroGeral(cadastroGeral);
        geracaoDocumentoDTO.setUsuario(documentoGenericoDTO.getUsuario());
        geracaoDocumentoDTO.setWeb(documentoGenericoDTO.getWeb());
        geracaoDocumentoDTO.setCertidaoEspecial(documentoGenericoDTO.getCertidaoEspecial());
        geracaoDocumentoDTO.setIdSequenciaItbi(documentoGenericoDTO.getIdSequenciaItbi());
        Optional.ofNullable(documentoGenericoDTO.getDadosProjeto()).ifPresent(arg_0 -> geracaoDocumentoDTO.setDadosProjeto(arg_0));
        geracaoDocumentoDTO.setProcessoSei(documentoGenericoDTO.getProcessoSei());
        geracaoDocumentoDTO.setCodigoPgd(documentoGenericoDTO.getCodigoPgd());
        geracaoDocumentoDTO.setDataEmissao(documentoGenericoDTO.getDataEmissao());
        geracaoDocumentoDTO.setNumeroPrimeiroAlvara(documentoGenericoDTO.getNumeroPrimeiroAlvara());
        geracaoDocumentoDTO.setAnoEmissaoAlvara(documentoGenericoDTO.getAnoEmissaoAlvara());
        geracaoDocumentoDTO.setDataPrimeiroAlvara(documentoGenericoDTO.getDataPrimeiroAlvara());
        geracaoDocumentoDTO.setCodigoPrancha(documentoGenericoDTO.getCodigoPrancha());
        geracaoDocumentoDTO.setAreaAcrescimoOrDecrescimo(documentoGenericoDTO.getAreaAcrescimoOrDecrescimo());
        geracaoDocumentoDTO.setDocumentoCertidaoItens(documentoGenericoDTO.getDocumentoCertidaoItens());
        geracaoDocumentoDTO.setCabecalho(FileUtils.safeTextToBytes((String)documentoGenericoDTO.getCabecalho()));
        geracaoDocumentoDTO.setRodape(FileUtils.safeTextToBytes((String)documentoGenericoDTO.getRodape()));
        geracaoDocumentoDTO.setAreaTotalConstruida(documentoGenericoDTO.getAreaTotalConstruida());
        geracaoDocumentoDTO.setSolicitacaoAlvara(documentoGenericoDTO.getSolicitacaoAlvara());
        return geracaoDocumentoDTO;
    }

    @Generated
    public GeracaoDocumentoDTO() {
    }

    @Generated
    public String getRequerenteNome() {
        return this.requerenteNome;
    }

    @Generated
    public String getRequerenteCpfCnpj() {
        return this.requerenteCpfCnpj;
    }

    @Generated
    public TipoPessoa getTipoPessoaRequerente() {
        return this.tipoPessoaRequerente;
    }

    @Generated
    public Long getIdProcesso() {
        return this.idProcesso;
    }

    @Generated
    public Long getExercicioProcesso() {
        return this.exercicioProcesso;
    }

    @Generated
    public CadastroGeral getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getIdTipoDocumento() {
        return this.idTipoDocumento;
    }

    @Generated
    public Long getIdFinalidade() {
        return this.idFinalidade;
    }

    @Generated
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public Boolean getWeb() {
        return this.web;
    }

    @Generated
    public Boolean getCertidaoEspecial() {
        return this.certidaoEspecial;
    }

    @Generated
    public Long getIdSequenciaItbi() {
        return this.idSequenciaItbi;
    }

    @Generated
    public FiltroProjetoDTO getDadosProjeto() {
        return this.dadosProjeto;
    }

    @Generated
    public String getProcessoSei() {
        return this.processoSei;
    }

    @Generated
    public String getCodigoPgd() {
        return this.codigoPgd;
    }

    @Generated
    public LocalDate getDataEmissao() {
        return this.dataEmissao;
    }

    @Generated
    public String getNumeroPrimeiroAlvara() {
        return this.numeroPrimeiroAlvara;
    }

    @Generated
    public String getAnoEmissaoAlvara() {
        return this.anoEmissaoAlvara;
    }

    @Generated
    public LocalDate getDataPrimeiroAlvara() {
        return this.dataPrimeiroAlvara;
    }

    @Generated
    public String getCodigoPrancha() {
        return this.codigoPrancha;
    }

    @Generated
    public BigDecimal getAreaAcrescimoOrDecrescimo() {
        return this.areaAcrescimoOrDecrescimo;
    }

    @Generated
    public List<DocumentoCertidaoItemDTO> getDocumentoCertidaoItens() {
        return this.documentoCertidaoItens;
    }

    @Generated
    public byte[] getCabecalho() {
        return this.cabecalho;
    }

    @Generated
    public byte[] getRodape() {
        return this.rodape;
    }

    @Generated
    public BigDecimal getAreaTotalConstruida() {
        return this.areaTotalConstruida;
    }

    @Generated
    public Long getSolicitacaoAlvara() {
        return this.solicitacaoAlvara;
    }

    @Generated
    public void setRequerenteNome(String requerenteNome) {
        this.requerenteNome = requerenteNome;
    }

    @Generated
    public void setRequerenteCpfCnpj(String requerenteCpfCnpj) {
        this.requerenteCpfCnpj = requerenteCpfCnpj;
    }

    @Generated
    public void setTipoPessoaRequerente(TipoPessoa tipoPessoaRequerente) {
        this.tipoPessoaRequerente = tipoPessoaRequerente;
    }

    @Generated
    public void setIdProcesso(Long idProcesso) {
        this.idProcesso = idProcesso;
    }

    @Generated
    public void setExercicioProcesso(Long exercicioProcesso) {
        this.exercicioProcesso = exercicioProcesso;
    }

    @Generated
    public void setCadastroGeral(CadastroGeral cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setIdTipoDocumento(Long idTipoDocumento) {
        this.idTipoDocumento = idTipoDocumento;
    }

    @Generated
    public void setIdFinalidade(Long idFinalidade) {
        this.idFinalidade = idFinalidade;
    }

    @Generated
    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setWeb(Boolean web) {
        this.web = web;
    }

    @Generated
    public void setCertidaoEspecial(Boolean certidaoEspecial) {
        this.certidaoEspecial = certidaoEspecial;
    }

    @Generated
    public void setIdSequenciaItbi(Long idSequenciaItbi) {
        this.idSequenciaItbi = idSequenciaItbi;
    }

    @Generated
    public void setDadosProjeto(FiltroProjetoDTO dadosProjeto) {
        this.dadosProjeto = dadosProjeto;
    }

    @Generated
    public void setProcessoSei(String processoSei) {
        this.processoSei = processoSei;
    }

    @Generated
    public void setCodigoPgd(String codigoPgd) {
        this.codigoPgd = codigoPgd;
    }

    @Generated
    public void setDataEmissao(LocalDate dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Generated
    public void setNumeroPrimeiroAlvara(String numeroPrimeiroAlvara) {
        this.numeroPrimeiroAlvara = numeroPrimeiroAlvara;
    }

    @Generated
    public void setAnoEmissaoAlvara(String anoEmissaoAlvara) {
        this.anoEmissaoAlvara = anoEmissaoAlvara;
    }

    @Generated
    public void setDataPrimeiroAlvara(LocalDate dataPrimeiroAlvara) {
        this.dataPrimeiroAlvara = dataPrimeiroAlvara;
    }

    @Generated
    public void setCodigoPrancha(String codigoPrancha) {
        this.codigoPrancha = codigoPrancha;
    }

    @Generated
    public void setAreaAcrescimoOrDecrescimo(BigDecimal areaAcrescimoOrDecrescimo) {
        this.areaAcrescimoOrDecrescimo = areaAcrescimoOrDecrescimo;
    }

    @Generated
    public void setDocumentoCertidaoItens(List<DocumentoCertidaoItemDTO> documentoCertidaoItens) {
        this.documentoCertidaoItens = documentoCertidaoItens;
    }

    @Generated
    public void setCabecalho(byte[] cabecalho) {
        this.cabecalho = cabecalho;
    }

    @Generated
    public void setRodape(byte[] rodape) {
        this.rodape = rodape;
    }

    @Generated
    public void setAreaTotalConstruida(BigDecimal areaTotalConstruida) {
        this.areaTotalConstruida = areaTotalConstruida;
    }

    @Generated
    public void setSolicitacaoAlvara(Long solicitacaoAlvara) {
        this.solicitacaoAlvara = solicitacaoAlvara;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeracaoDocumentoDTO)) {
            return false;
        }
        GeracaoDocumentoDTO other = (GeracaoDocumentoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idProcesso = this.getIdProcesso();
        Long other$idProcesso = other.getIdProcesso();
        if (this$idProcesso == null ? other$idProcesso != null : !((Object)this$idProcesso).equals(other$idProcesso)) {
            return false;
        }
        Long this$exercicioProcesso = this.getExercicioProcesso();
        Long other$exercicioProcesso = other.getExercicioProcesso();
        if (this$exercicioProcesso == null ? other$exercicioProcesso != null : !((Object)this$exercicioProcesso).equals(other$exercicioProcesso)) {
            return false;
        }
        Long this$idTipoDocumento = this.getIdTipoDocumento();
        Long other$idTipoDocumento = other.getIdTipoDocumento();
        if (this$idTipoDocumento == null ? other$idTipoDocumento != null : !((Object)this$idTipoDocumento).equals(other$idTipoDocumento)) {
            return false;
        }
        Long this$idFinalidade = this.getIdFinalidade();
        Long other$idFinalidade = other.getIdFinalidade();
        if (this$idFinalidade == null ? other$idFinalidade != null : !((Object)this$idFinalidade).equals(other$idFinalidade)) {
            return false;
        }
        Boolean this$web = this.getWeb();
        Boolean other$web = other.getWeb();
        if (this$web == null ? other$web != null : !((Object)this$web).equals(other$web)) {
            return false;
        }
        Boolean this$certidaoEspecial = this.getCertidaoEspecial();
        Boolean other$certidaoEspecial = other.getCertidaoEspecial();
        if (this$certidaoEspecial == null ? other$certidaoEspecial != null : !((Object)this$certidaoEspecial).equals(other$certidaoEspecial)) {
            return false;
        }
        Long this$idSequenciaItbi = this.getIdSequenciaItbi();
        Long other$idSequenciaItbi = other.getIdSequenciaItbi();
        if (this$idSequenciaItbi == null ? other$idSequenciaItbi != null : !((Object)this$idSequenciaItbi).equals(other$idSequenciaItbi)) {
            return false;
        }
        Long this$solicitacaoAlvara = this.getSolicitacaoAlvara();
        Long other$solicitacaoAlvara = other.getSolicitacaoAlvara();
        if (this$solicitacaoAlvara == null ? other$solicitacaoAlvara != null : !((Object)this$solicitacaoAlvara).equals(other$solicitacaoAlvara)) {
            return false;
        }
        String this$requerenteNome = this.getRequerenteNome();
        String other$requerenteNome = other.getRequerenteNome();
        if (this$requerenteNome == null ? other$requerenteNome != null : !this$requerenteNome.equals(other$requerenteNome)) {
            return false;
        }
        String this$requerenteCpfCnpj = this.getRequerenteCpfCnpj();
        String other$requerenteCpfCnpj = other.getRequerenteCpfCnpj();
        if (this$requerenteCpfCnpj == null ? other$requerenteCpfCnpj != null : !this$requerenteCpfCnpj.equals(other$requerenteCpfCnpj)) {
            return false;
        }
        TipoPessoa this$tipoPessoaRequerente = this.getTipoPessoaRequerente();
        TipoPessoa other$tipoPessoaRequerente = other.getTipoPessoaRequerente();
        if (this$tipoPessoaRequerente == null ? other$tipoPessoaRequerente != null : !this$tipoPessoaRequerente.equals(other$tipoPessoaRequerente)) {
            return false;
        }
        CadastroGeral this$cadastroGeral = this.getCadastroGeral();
        CadastroGeral other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        Pessoa this$pessoa = this.getPessoa();
        Pessoa other$pessoa = other.getPessoa();
        if (this$pessoa == null ? other$pessoa != null : !this$pessoa.equals(other$pessoa)) {
            return false;
        }
        String this$observacao = this.getObservacao();
        String other$observacao = other.getObservacao();
        if (this$observacao == null ? other$observacao != null : !this$observacao.equals(other$observacao)) {
            return false;
        }
        String this$usuario = this.getUsuario();
        String other$usuario = other.getUsuario();
        if (this$usuario == null ? other$usuario != null : !this$usuario.equals(other$usuario)) {
            return false;
        }
        FiltroProjetoDTO this$dadosProjeto = this.getDadosProjeto();
        FiltroProjetoDTO other$dadosProjeto = other.getDadosProjeto();
        if (this$dadosProjeto == null ? other$dadosProjeto != null : !this$dadosProjeto.equals(other$dadosProjeto)) {
            return false;
        }
        String this$processoSei = this.getProcessoSei();
        String other$processoSei = other.getProcessoSei();
        if (this$processoSei == null ? other$processoSei != null : !this$processoSei.equals(other$processoSei)) {
            return false;
        }
        String this$codigoPgd = this.getCodigoPgd();
        String other$codigoPgd = other.getCodigoPgd();
        if (this$codigoPgd == null ? other$codigoPgd != null : !this$codigoPgd.equals(other$codigoPgd)) {
            return false;
        }
        LocalDate this$dataEmissao = this.getDataEmissao();
        LocalDate other$dataEmissao = other.getDataEmissao();
        if (this$dataEmissao == null ? other$dataEmissao != null : !((Object)this$dataEmissao).equals(other$dataEmissao)) {
            return false;
        }
        String this$numeroPrimeiroAlvara = this.getNumeroPrimeiroAlvara();
        String other$numeroPrimeiroAlvara = other.getNumeroPrimeiroAlvara();
        if (this$numeroPrimeiroAlvara == null ? other$numeroPrimeiroAlvara != null : !this$numeroPrimeiroAlvara.equals(other$numeroPrimeiroAlvara)) {
            return false;
        }
        String this$anoEmissaoAlvara = this.getAnoEmissaoAlvara();
        String other$anoEmissaoAlvara = other.getAnoEmissaoAlvara();
        if (this$anoEmissaoAlvara == null ? other$anoEmissaoAlvara != null : !this$anoEmissaoAlvara.equals(other$anoEmissaoAlvara)) {
            return false;
        }
        LocalDate this$dataPrimeiroAlvara = this.getDataPrimeiroAlvara();
        LocalDate other$dataPrimeiroAlvara = other.getDataPrimeiroAlvara();
        if (this$dataPrimeiroAlvara == null ? other$dataPrimeiroAlvara != null : !((Object)this$dataPrimeiroAlvara).equals(other$dataPrimeiroAlvara)) {
            return false;
        }
        String this$codigoPrancha = this.getCodigoPrancha();
        String other$codigoPrancha = other.getCodigoPrancha();
        if (this$codigoPrancha == null ? other$codigoPrancha != null : !this$codigoPrancha.equals(other$codigoPrancha)) {
            return false;
        }
        BigDecimal this$areaAcrescimoOrDecrescimo = this.getAreaAcrescimoOrDecrescimo();
        BigDecimal other$areaAcrescimoOrDecrescimo = other.getAreaAcrescimoOrDecrescimo();
        if (this$areaAcrescimoOrDecrescimo == null ? other$areaAcrescimoOrDecrescimo != null : !((Object)this$areaAcrescimoOrDecrescimo).equals(other$areaAcrescimoOrDecrescimo)) {
            return false;
        }
        List this$documentoCertidaoItens = this.getDocumentoCertidaoItens();
        List other$documentoCertidaoItens = other.getDocumentoCertidaoItens();
        if (this$documentoCertidaoItens == null ? other$documentoCertidaoItens != null : !((Object)this$documentoCertidaoItens).equals(other$documentoCertidaoItens)) {
            return false;
        }
        if (!Arrays.equals(this.getCabecalho(), other.getCabecalho())) {
            return false;
        }
        if (!Arrays.equals(this.getRodape(), other.getRodape())) {
            return false;
        }
        BigDecimal this$areaTotalConstruida = this.getAreaTotalConstruida();
        BigDecimal other$areaTotalConstruida = other.getAreaTotalConstruida();
        return !(this$areaTotalConstruida == null ? other$areaTotalConstruida != null : !((Object)this$areaTotalConstruida).equals(other$areaTotalConstruida));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GeracaoDocumentoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idProcesso = this.getIdProcesso();
        result = result * 59 + ($idProcesso == null ? 43 : ((Object)$idProcesso).hashCode());
        Long $exercicioProcesso = this.getExercicioProcesso();
        result = result * 59 + ($exercicioProcesso == null ? 43 : ((Object)$exercicioProcesso).hashCode());
        Long $idTipoDocumento = this.getIdTipoDocumento();
        result = result * 59 + ($idTipoDocumento == null ? 43 : ((Object)$idTipoDocumento).hashCode());
        Long $idFinalidade = this.getIdFinalidade();
        result = result * 59 + ($idFinalidade == null ? 43 : ((Object)$idFinalidade).hashCode());
        Boolean $web = this.getWeb();
        result = result * 59 + ($web == null ? 43 : ((Object)$web).hashCode());
        Boolean $certidaoEspecial = this.getCertidaoEspecial();
        result = result * 59 + ($certidaoEspecial == null ? 43 : ((Object)$certidaoEspecial).hashCode());
        Long $idSequenciaItbi = this.getIdSequenciaItbi();
        result = result * 59 + ($idSequenciaItbi == null ? 43 : ((Object)$idSequenciaItbi).hashCode());
        Long $solicitacaoAlvara = this.getSolicitacaoAlvara();
        result = result * 59 + ($solicitacaoAlvara == null ? 43 : ((Object)$solicitacaoAlvara).hashCode());
        String $requerenteNome = this.getRequerenteNome();
        result = result * 59 + ($requerenteNome == null ? 43 : $requerenteNome.hashCode());
        String $requerenteCpfCnpj = this.getRequerenteCpfCnpj();
        result = result * 59 + ($requerenteCpfCnpj == null ? 43 : $requerenteCpfCnpj.hashCode());
        TipoPessoa $tipoPessoaRequerente = this.getTipoPessoaRequerente();
        result = result * 59 + ($tipoPessoaRequerente == null ? 43 : $tipoPessoaRequerente.hashCode());
        CadastroGeral $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        Pessoa $pessoa = this.getPessoa();
        result = result * 59 + ($pessoa == null ? 43 : $pessoa.hashCode());
        String $observacao = this.getObservacao();
        result = result * 59 + ($observacao == null ? 43 : $observacao.hashCode());
        String $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : $usuario.hashCode());
        FiltroProjetoDTO $dadosProjeto = this.getDadosProjeto();
        result = result * 59 + ($dadosProjeto == null ? 43 : $dadosProjeto.hashCode());
        String $processoSei = this.getProcessoSei();
        result = result * 59 + ($processoSei == null ? 43 : $processoSei.hashCode());
        String $codigoPgd = this.getCodigoPgd();
        result = result * 59 + ($codigoPgd == null ? 43 : $codigoPgd.hashCode());
        LocalDate $dataEmissao = this.getDataEmissao();
        result = result * 59 + ($dataEmissao == null ? 43 : ((Object)$dataEmissao).hashCode());
        String $numeroPrimeiroAlvara = this.getNumeroPrimeiroAlvara();
        result = result * 59 + ($numeroPrimeiroAlvara == null ? 43 : $numeroPrimeiroAlvara.hashCode());
        String $anoEmissaoAlvara = this.getAnoEmissaoAlvara();
        result = result * 59 + ($anoEmissaoAlvara == null ? 43 : $anoEmissaoAlvara.hashCode());
        LocalDate $dataPrimeiroAlvara = this.getDataPrimeiroAlvara();
        result = result * 59 + ($dataPrimeiroAlvara == null ? 43 : ((Object)$dataPrimeiroAlvara).hashCode());
        String $codigoPrancha = this.getCodigoPrancha();
        result = result * 59 + ($codigoPrancha == null ? 43 : $codigoPrancha.hashCode());
        BigDecimal $areaAcrescimoOrDecrescimo = this.getAreaAcrescimoOrDecrescimo();
        result = result * 59 + ($areaAcrescimoOrDecrescimo == null ? 43 : ((Object)$areaAcrescimoOrDecrescimo).hashCode());
        List $documentoCertidaoItens = this.getDocumentoCertidaoItens();
        result = result * 59 + ($documentoCertidaoItens == null ? 43 : ((Object)$documentoCertidaoItens).hashCode());
        result = result * 59 + Arrays.hashCode(this.getCabecalho());
        result = result * 59 + Arrays.hashCode(this.getRodape());
        BigDecimal $areaTotalConstruida = this.getAreaTotalConstruida();
        result = result * 59 + ($areaTotalConstruida == null ? 43 : ((Object)$areaTotalConstruida).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GeracaoDocumentoDTO(requerenteNome=" + this.getRequerenteNome() + ", requerenteCpfCnpj=" + this.getRequerenteCpfCnpj() + ", tipoPessoaRequerente=" + String.valueOf(this.getTipoPessoaRequerente()) + ", idProcesso=" + this.getIdProcesso() + ", exercicioProcesso=" + this.getExercicioProcesso() + ", cadastroGeral=" + String.valueOf(this.getCadastroGeral()) + ", idTipoDocumento=" + this.getIdTipoDocumento() + ", idFinalidade=" + this.getIdFinalidade() + ", pessoa=" + String.valueOf(this.getPessoa()) + ", observacao=" + this.getObservacao() + ", usuario=" + this.getUsuario() + ", web=" + this.getWeb() + ", certidaoEspecial=" + this.getCertidaoEspecial() + ", idSequenciaItbi=" + this.getIdSequenciaItbi() + ", dadosProjeto=" + String.valueOf(this.getDadosProjeto()) + ", processoSei=" + this.getProcessoSei() + ", codigoPgd=" + this.getCodigoPgd() + ", dataEmissao=" + String.valueOf(this.getDataEmissao()) + ", numeroPrimeiroAlvara=" + this.getNumeroPrimeiroAlvara() + ", anoEmissaoAlvara=" + this.getAnoEmissaoAlvara() + ", dataPrimeiroAlvara=" + String.valueOf(this.getDataPrimeiroAlvara()) + ", codigoPrancha=" + this.getCodigoPrancha() + ", areaAcrescimoOrDecrescimo=" + String.valueOf(this.getAreaAcrescimoOrDecrescimo()) + ", documentoCertidaoItens=" + String.valueOf(this.getDocumentoCertidaoItens()) + ", cabecalho=" + Arrays.toString(this.getCabecalho()) + ", rodape=" + Arrays.toString(this.getRodape()) + ", areaTotalConstruida=" + String.valueOf(this.getAreaTotalConstruida()) + ", solicitacaoAlvara=" + this.getSolicitacaoAlvara() + ")";
    }
}

