/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.dto.FiltroMultiValueBase;
import br.com.elotech.tributos.util.MultiValueFilter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class FiltroMultiValueBase {
    private Map<String, String> fields = new HashMap();
    private Map<String, String> mandatoryFields = new HashMap();
    private Map<String, String> mappedFields;
    private boolean useMandatoryFields = false;
    private boolean forgetMandatoryFieldsAfterUse = false;

    public String buildFiltersForNativeSQL() {
        this.loadMappedFields();
        this.validateUsesMandatoryFields();
        Map fields = this.useMandatoryFields ? this.getMandatoryFields() : this.fields;
        String response = this.buildWhereFiltersForNativeSQLByFields(fields);
        if (this.forgetMandatoryFieldsAfterUse) {
            this.forgetMandatoryFields();
        }
        return response;
    }

    public FiltroMultiValueBase useMandatoryFields() {
        this.useMandatoryFields = true;
        return this;
    }

    public void forgetMandatoryFields() {
        this.useMandatoryFields = false;
        this.mandatoryFields = Map.of();
    }

    public void forgetMandatoryFieldsAfterUse() {
        this.forgetMandatoryFieldsAfterUse = true;
    }

    public FiltroMultiValueBase withMandatoryFields(Map<String, String> mandatoryFields) {
        this.mandatoryFields = mandatoryFields;
        return this;
    }

    private void validateUsesMandatoryFields() {
        if (this.useMandatoryFields && this.mandatoryFields.isEmpty()) {
            throw FiltroMultiValueBaseException.mandatoryFieldsIsEmpty();
        }
    }

    private String buildWhereFiltersForNativeSQLByFields(Map<String, String> fields) {
        this.validateNonMappedFields(fields);
        return fields.entrySet().stream().map(arg_0 -> this.generateFilters(arg_0)).filter(StringUtils::isNotEmpty).collect(Collectors.joining(" AND "));
    }

    private String generateFilters(Map.Entry<String, String> entry) {
        return MultiValueFilter.generateFilters((String)entry.getValue(), (String)this.getMappedFieldValue(entry.getKey()));
    }

    private void validateNonMappedFields(Map<String, String> input) {
        List nonImplementedFields = input.keySet().stream().filter(arg_0 -> this.isANonImplementedField(arg_0)).collect(Collectors.toList());
        if (!nonImplementedFields.isEmpty()) {
            String message = String.join((CharSequence)", ", nonImplementedFields);
            throw FiltroMultiValueBaseException.nonMappedFilters((String)message);
        }
    }

    private boolean isImplementedField(String field) {
        return this.mappedFields.containsKey(field);
    }

    private boolean isANonImplementedField(String field) {
        return !this.isImplementedField(field);
    }

    private String getMappedFieldValue(String field) {
        return (String)this.mappedFields.get(field);
    }

    private void loadMappedFields() {
        this.mappedFields = this.getMappedFields();
    }

    protected abstract Map<String, String> getMappedFields();

    @Generated
    public FiltroMultiValueBase() {
    }

    @Generated
    public Map<String, String> getFields() {
        return this.fields;
    }

    @Generated
    public Map<String, String> getMandatoryFields() {
        return this.mandatoryFields;
    }

    @Generated
    public boolean isUseMandatoryFields() {
        return this.useMandatoryFields;
    }

    @Generated
    public boolean isForgetMandatoryFieldsAfterUse() {
        return this.forgetMandatoryFieldsAfterUse;
    }

    @Generated
    public void setFields(Map<String, String> fields) {
        this.fields = fields;
    }

    @Generated
    public void setMandatoryFields(Map<String, String> mandatoryFields) {
        this.mandatoryFields = mandatoryFields;
    }

    @Generated
    public void setMappedFields(Map<String, String> mappedFields) {
        this.mappedFields = mappedFields;
    }

    @Generated
    public void setUseMandatoryFields(boolean useMandatoryFields) {
        this.useMandatoryFields = useMandatoryFields;
    }

    @Generated
    public void setForgetMandatoryFieldsAfterUse(boolean forgetMandatoryFieldsAfterUse) {
        this.forgetMandatoryFieldsAfterUse = forgetMandatoryFieldsAfterUse;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiltroMultiValueBase)) {
            return false;
        }
        FiltroMultiValueBase other = (FiltroMultiValueBase)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isUseMandatoryFields() != other.isUseMandatoryFields()) {
            return false;
        }
        if (this.isForgetMandatoryFieldsAfterUse() != other.isForgetMandatoryFieldsAfterUse()) {
            return false;
        }
        Map this$fields = this.getFields();
        Map other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        Map this$mandatoryFields = this.getMandatoryFields();
        Map other$mandatoryFields = other.getMandatoryFields();
        if (this$mandatoryFields == null ? other$mandatoryFields != null : !((Object)this$mandatoryFields).equals(other$mandatoryFields)) {
            return false;
        }
        Map this$mappedFields = this.getMappedFields();
        Map other$mappedFields = other.getMappedFields();
        return !(this$mappedFields == null ? other$mappedFields != null : !((Object)this$mappedFields).equals(other$mappedFields));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FiltroMultiValueBase;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseMandatoryFields() ? 79 : 97);
        result = result * 59 + (this.isForgetMandatoryFieldsAfterUse() ? 79 : 97);
        Map $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        Map $mandatoryFields = this.getMandatoryFields();
        result = result * 59 + ($mandatoryFields == null ? 43 : ((Object)$mandatoryFields).hashCode());
        Map $mappedFields = this.getMappedFields();
        result = result * 59 + ($mappedFields == null ? 43 : ((Object)$mappedFields).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FiltroMultiValueBase(fields=" + String.valueOf(this.getFields()) + ", mandatoryFields=" + String.valueOf(this.getMandatoryFields()) + ", mappedFields=" + String.valueOf(this.getMappedFields()) + ", useMandatoryFields=" + this.isUseMandatoryFields() + ", forgetMandatoryFieldsAfterUse=" + this.isForgetMandatoryFieldsAfterUse() + ")";
    }
}

