/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.SituacaoParcela;
import br.com.elotech.tributos.domain.SituacaoVencimentoEnum;
import br.com.elotech.tributos.domain.TipoExtratoDebitoEnum;
import br.com.elotech.tributos.domain.TipoSituacaoParcela;
import br.com.elotech.tributos.dto.CadastroGeralResumidoDTO;
import br.com.elotech.tributos.util.MultiValueFilter;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

public class FiltroExtratoDebitoDTO {
    private List<CadastroGeralResumidoDTO> cadastros = new ArrayList();
    private Boolean todosCadastros = Boolean.FALSE;
    private TipoExtratoDebitoEnum filtroCard;
    private LocalDate dataLancamentoInicial;
    private LocalDate dataLancamentoFinal;
    private LocalDate dataVencimentoInicial;
    private LocalDate dataVencimentoFinal;
    private Long situacaoLegal;
    private List<SituacaoParcela> situacaoParcela = new ArrayList();
    private String ano;
    private String divida;
    private String subDivida;
    private String parcela;
    private String numeroCda;
    private String exercicioCda;
    private SituacaoVencimentoEnum situacaoVencimento;
    private Boolean visualizaDebitosNaoConstituidos = Boolean.FALSE;
    private Long idDebito;
    private Long idParcelamento;
    private Boolean detalhado = Boolean.FALSE;
    @NotNull
    private LocalDate dataReferencia;
    private LocalDate dataPagamento;
    private List<TipoSituacaoParcela> tipoSituacaoParcelas = new ArrayList();

    public String buildFilter() {
        ArrayList<String> filtros = new ArrayList<String>();
        String filtroCadastros = this.cadastros.stream().map(cadastro -> String.format("(td.tipocadastro = %d and td.cadastrogeral = %d)", cadastro.getTipoCadastro().getValue(), cadastro.getCadastroGeral())).collect(Collectors.joining(" or "));
        filtros.add(String.format("(%s)", filtroCadastros));
        if (Objects.nonNull(this.filtroCard) && !TipoExtratoDebitoEnum.TODOS.equals((Object)this.filtroCard)) {
            filtros.add(this.filtroCard.getFiltro());
        }
        if (Objects.nonNull(this.dataLancamentoInicial)) {
            filtros.add("tdp.datalancamento >= :DATALANCAMENTOINICIAL");
        }
        if (Objects.nonNull(this.dataLancamentoFinal)) {
            filtros.add("tdp.datalancamento <= :DATALANCAMENTOFINAL");
        }
        if (Objects.nonNull(this.dataVencimentoInicial)) {
            filtros.add("tdp.datavencimento >= :DATAVENCIMENTOINICIAL");
        }
        if (Objects.nonNull(this.dataVencimentoFinal)) {
            filtros.add("tdp.datavencimento <= :DATAVENCIMENTOFINAL");
        }
        if (Objects.nonNull(this.situacaoLegal)) {
            filtros.add(String.format("tdp.situacaolegal = %s", this.situacaoLegal));
        }
        if (Objects.nonNull(this.situacaoParcela) && !this.situacaoParcela.isEmpty()) {
            String filtroSituacaoParcelas = this.situacaoParcela.stream().map(cadastro -> String.format("(tsp.situacaoparcela = %d )", cadastro.getId())).collect(Collectors.joining(" or "));
            filtros.add(String.format("(%s)", filtroSituacaoParcelas));
        }
        if (StringUtils.isNotBlank((CharSequence)this.ano)) {
            filtros.add(MultiValueFilter.generateFilters((String)this.ano, (String)"td.exercicio"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.divida)) {
            filtros.add(MultiValueFilter.generateFilters((String)this.divida, (String)"td.guiarecolhimento"));
        }
        if (SituacaoVencimentoEnum.VENCIDOS.equals((Object)this.situacaoVencimento)) {
            filtros.add("tdp.datavencimento < :DATAATUAL");
        }
        if (SituacaoVencimentoEnum.A_VENCER.equals((Object)this.situacaoVencimento)) {
            filtros.add("tdp.datavencimento >= :DATAATUAL");
        }
        if (StringUtils.isNotBlank((CharSequence)this.subDivida)) {
            filtros.add(MultiValueFilter.generateFilters((String)this.subDivida, (String)"td.subdivida"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.parcela)) {
            filtros.add(MultiValueFilter.generateFilters((String)this.parcela, (String)"tdp.parcela"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.numeroCda)) {
            filtros.add(MultiValueFilter.generateFilters((String)this.numeroCda, (String)"cda.numerocertidao"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.exercicioCda)) {
            filtros.add(MultiValueFilter.generateFilters((String)this.exercicioCda, (String)"cda.exerciciocertidao"));
        }
        if (this.visualizaDebitosNaoConstituidos.booleanValue()) {
            filtros.add("( td.constituido = 'S' or ( td.constituido = 'N' and tdp.datavencimento >= :DATAATUAL ))");
        } else {
            filtros.add("td.constituido = 'S'");
        }
        if (Objects.nonNull(this.idDebito)) {
            filtros.add("td.iddebito = :IDDEBITO");
        }
        if (Objects.nonNull(this.idParcelamento)) {
            filtros.add("td.idparcelamento = :IDPARCELAMENTO");
        }
        if (Objects.nonNull(this.dataReferencia)) {
            filtros.add("td.datalancamento <= :DATAATUAL");
        }
        if (Objects.nonNull(this.dataPagamento)) {
            filtros.add("tp.datapagamento >= :DATAATUAL");
        }
        if (Objects.nonNull(this.tipoSituacaoParcelas) && !this.tipoSituacaoParcelas.isEmpty()) {
            String filtroTipoSituacaoParcelas = this.tipoSituacaoParcelas.stream().map(tipoSituacaoParcela -> String.format("(tsp.tiposituacaoparcela = %d )", tipoSituacaoParcela.getValue())).collect(Collectors.joining(" or "));
            filtros.add(String.format("(%s)", filtroTipoSituacaoParcelas));
        }
        return String.join((CharSequence)" and ", filtros);
    }

    public boolean isDetalhado() {
        return Boolean.TRUE.equals(this.detalhado);
    }

    public FiltroExtratoDebitoDTO clone() {
        try {
            FiltroExtratoDebitoDTO clone = new FiltroExtratoDebitoDTO();
            BeanUtils.copyProperties((Object)this, (Object)clone);
            return clone;
        }
        catch (Exception ex) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel clonar o FiltroExtratoDebitoDTO");
        }
    }

    @Generated
    public FiltroExtratoDebitoDTO() {
    }

    @Generated
    public List<CadastroGeralResumidoDTO> getCadastros() {
        return this.cadastros;
    }

    @Generated
    public Boolean getTodosCadastros() {
        return this.todosCadastros;
    }

    @Generated
    public TipoExtratoDebitoEnum getFiltroCard() {
        return this.filtroCard;
    }

    @Generated
    public LocalDate getDataLancamentoInicial() {
        return this.dataLancamentoInicial;
    }

    @Generated
    public LocalDate getDataLancamentoFinal() {
        return this.dataLancamentoFinal;
    }

    @Generated
    public LocalDate getDataVencimentoInicial() {
        return this.dataVencimentoInicial;
    }

    @Generated
    public LocalDate getDataVencimentoFinal() {
        return this.dataVencimentoFinal;
    }

    @Generated
    public Long getSituacaoLegal() {
        return this.situacaoLegal;
    }

    @Generated
    public List<SituacaoParcela> getSituacaoParcela() {
        return this.situacaoParcela;
    }

    @Generated
    public String getAno() {
        return this.ano;
    }

    @Generated
    public String getDivida() {
        return this.divida;
    }

    @Generated
    public String getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public String getParcela() {
        return this.parcela;
    }

    @Generated
    public String getNumeroCda() {
        return this.numeroCda;
    }

    @Generated
    public String getExercicioCda() {
        return this.exercicioCda;
    }

    @Generated
    public SituacaoVencimentoEnum getSituacaoVencimento() {
        return this.situacaoVencimento;
    }

    @Generated
    public Boolean getVisualizaDebitosNaoConstituidos() {
        return this.visualizaDebitosNaoConstituidos;
    }

    @Generated
    public Long getIdDebito() {
        return this.idDebito;
    }

    @Generated
    public Long getIdParcelamento() {
        return this.idParcelamento;
    }

    @Generated
    public Boolean getDetalhado() {
        return this.detalhado;
    }

    @Generated
    public LocalDate getDataReferencia() {
        return this.dataReferencia;
    }

    @Generated
    public LocalDate getDataPagamento() {
        return this.dataPagamento;
    }

    @Generated
    public List<TipoSituacaoParcela> getTipoSituacaoParcelas() {
        return this.tipoSituacaoParcelas;
    }

    @Generated
    public void setCadastros(List<CadastroGeralResumidoDTO> cadastros) {
        this.cadastros = cadastros;
    }

    @Generated
    public void setTodosCadastros(Boolean todosCadastros) {
        this.todosCadastros = todosCadastros;
    }

    @Generated
    public void setFiltroCard(TipoExtratoDebitoEnum filtroCard) {
        this.filtroCard = filtroCard;
    }

    @Generated
    public void setDataLancamentoInicial(LocalDate dataLancamentoInicial) {
        this.dataLancamentoInicial = dataLancamentoInicial;
    }

    @Generated
    public void setDataLancamentoFinal(LocalDate dataLancamentoFinal) {
        this.dataLancamentoFinal = dataLancamentoFinal;
    }

    @Generated
    public void setDataVencimentoInicial(LocalDate dataVencimentoInicial) {
        this.dataVencimentoInicial = dataVencimentoInicial;
    }

    @Generated
    public void setDataVencimentoFinal(LocalDate dataVencimentoFinal) {
        this.dataVencimentoFinal = dataVencimentoFinal;
    }

    @Generated
    public void setSituacaoLegal(Long situacaoLegal) {
        this.situacaoLegal = situacaoLegal;
    }

    @Generated
    public void setSituacaoParcela(List<SituacaoParcela> situacaoParcela) {
        this.situacaoParcela = situacaoParcela;
    }

    @Generated
    public void setAno(String ano) {
        this.ano = ano;
    }

    @Generated
    public void setDivida(String divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(String subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setParcela(String parcela) {
        this.parcela = parcela;
    }

    @Generated
    public void setNumeroCda(String numeroCda) {
        this.numeroCda = numeroCda;
    }

    @Generated
    public void setExercicioCda(String exercicioCda) {
        this.exercicioCda = exercicioCda;
    }

    @Generated
    public void setSituacaoVencimento(SituacaoVencimentoEnum situacaoVencimento) {
        this.situacaoVencimento = situacaoVencimento;
    }

    @Generated
    public void setVisualizaDebitosNaoConstituidos(Boolean visualizaDebitosNaoConstituidos) {
        this.visualizaDebitosNaoConstituidos = visualizaDebitosNaoConstituidos;
    }

    @Generated
    public void setIdDebito(Long idDebito) {
        this.idDebito = idDebito;
    }

    @Generated
    public void setIdParcelamento(Long idParcelamento) {
        this.idParcelamento = idParcelamento;
    }

    @Generated
    public void setDetalhado(Boolean detalhado) {
        this.detalhado = detalhado;
    }

    @Generated
    public void setDataReferencia(LocalDate dataReferencia) {
        this.dataReferencia = dataReferencia;
    }

    @Generated
    public void setDataPagamento(LocalDate dataPagamento) {
        this.dataPagamento = dataPagamento;
    }

    @Generated
    public void setTipoSituacaoParcelas(List<TipoSituacaoParcela> tipoSituacaoParcelas) {
        this.tipoSituacaoParcelas = tipoSituacaoParcelas;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiltroExtratoDebitoDTO)) {
            return false;
        }
        FiltroExtratoDebitoDTO other = (FiltroExtratoDebitoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$todosCadastros = this.getTodosCadastros();
        Boolean other$todosCadastros = other.getTodosCadastros();
        if (this$todosCadastros == null ? other$todosCadastros != null : !((Object)this$todosCadastros).equals(other$todosCadastros)) {
            return false;
        }
        Long this$situacaoLegal = this.getSituacaoLegal();
        Long other$situacaoLegal = other.getSituacaoLegal();
        if (this$situacaoLegal == null ? other$situacaoLegal != null : !((Object)this$situacaoLegal).equals(other$situacaoLegal)) {
            return false;
        }
        Boolean this$visualizaDebitosNaoConstituidos = this.getVisualizaDebitosNaoConstituidos();
        Boolean other$visualizaDebitosNaoConstituidos = other.getVisualizaDebitosNaoConstituidos();
        if (this$visualizaDebitosNaoConstituidos == null ? other$visualizaDebitosNaoConstituidos != null : !((Object)this$visualizaDebitosNaoConstituidos).equals(other$visualizaDebitosNaoConstituidos)) {
            return false;
        }
        Long this$idDebito = this.getIdDebito();
        Long other$idDebito = other.getIdDebito();
        if (this$idDebito == null ? other$idDebito != null : !((Object)this$idDebito).equals(other$idDebito)) {
            return false;
        }
        Long this$idParcelamento = this.getIdParcelamento();
        Long other$idParcelamento = other.getIdParcelamento();
        if (this$idParcelamento == null ? other$idParcelamento != null : !((Object)this$idParcelamento).equals(other$idParcelamento)) {
            return false;
        }
        Boolean this$detalhado = this.getDetalhado();
        Boolean other$detalhado = other.getDetalhado();
        if (this$detalhado == null ? other$detalhado != null : !((Object)this$detalhado).equals(other$detalhado)) {
            return false;
        }
        List this$cadastros = this.getCadastros();
        List other$cadastros = other.getCadastros();
        if (this$cadastros == null ? other$cadastros != null : !((Object)this$cadastros).equals(other$cadastros)) {
            return false;
        }
        TipoExtratoDebitoEnum this$filtroCard = this.getFiltroCard();
        TipoExtratoDebitoEnum other$filtroCard = other.getFiltroCard();
        if (this$filtroCard == null ? other$filtroCard != null : !this$filtroCard.equals(other$filtroCard)) {
            return false;
        }
        LocalDate this$dataLancamentoInicial = this.getDataLancamentoInicial();
        LocalDate other$dataLancamentoInicial = other.getDataLancamentoInicial();
        if (this$dataLancamentoInicial == null ? other$dataLancamentoInicial != null : !((Object)this$dataLancamentoInicial).equals(other$dataLancamentoInicial)) {
            return false;
        }
        LocalDate this$dataLancamentoFinal = this.getDataLancamentoFinal();
        LocalDate other$dataLancamentoFinal = other.getDataLancamentoFinal();
        if (this$dataLancamentoFinal == null ? other$dataLancamentoFinal != null : !((Object)this$dataLancamentoFinal).equals(other$dataLancamentoFinal)) {
            return false;
        }
        LocalDate this$dataVencimentoInicial = this.getDataVencimentoInicial();
        LocalDate other$dataVencimentoInicial = other.getDataVencimentoInicial();
        if (this$dataVencimentoInicial == null ? other$dataVencimentoInicial != null : !((Object)this$dataVencimentoInicial).equals(other$dataVencimentoInicial)) {
            return false;
        }
        LocalDate this$dataVencimentoFinal = this.getDataVencimentoFinal();
        LocalDate other$dataVencimentoFinal = other.getDataVencimentoFinal();
        if (this$dataVencimentoFinal == null ? other$dataVencimentoFinal != null : !((Object)this$dataVencimentoFinal).equals(other$dataVencimentoFinal)) {
            return false;
        }
        List this$situacaoParcela = this.getSituacaoParcela();
        List other$situacaoParcela = other.getSituacaoParcela();
        if (this$situacaoParcela == null ? other$situacaoParcela != null : !((Object)this$situacaoParcela).equals(other$situacaoParcela)) {
            return false;
        }
        String this$ano = this.getAno();
        String other$ano = other.getAno();
        if (this$ano == null ? other$ano != null : !this$ano.equals(other$ano)) {
            return false;
        }
        String this$divida = this.getDivida();
        String other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !this$divida.equals(other$divida)) {
            return false;
        }
        String this$subDivida = this.getSubDivida();
        String other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !this$subDivida.equals(other$subDivida)) {
            return false;
        }
        String this$parcela = this.getParcela();
        String other$parcela = other.getParcela();
        if (this$parcela == null ? other$parcela != null : !this$parcela.equals(other$parcela)) {
            return false;
        }
        String this$numeroCda = this.getNumeroCda();
        String other$numeroCda = other.getNumeroCda();
        if (this$numeroCda == null ? other$numeroCda != null : !this$numeroCda.equals(other$numeroCda)) {
            return false;
        }
        String this$exercicioCda = this.getExercicioCda();
        String other$exercicioCda = other.getExercicioCda();
        if (this$exercicioCda == null ? other$exercicioCda != null : !this$exercicioCda.equals(other$exercicioCda)) {
            return false;
        }
        SituacaoVencimentoEnum this$situacaoVencimento = this.getSituacaoVencimento();
        SituacaoVencimentoEnum other$situacaoVencimento = other.getSituacaoVencimento();
        if (this$situacaoVencimento == null ? other$situacaoVencimento != null : !this$situacaoVencimento.equals(other$situacaoVencimento)) {
            return false;
        }
        LocalDate this$dataReferencia = this.getDataReferencia();
        LocalDate other$dataReferencia = other.getDataReferencia();
        if (this$dataReferencia == null ? other$dataReferencia != null : !((Object)this$dataReferencia).equals(other$dataReferencia)) {
            return false;
        }
        LocalDate this$dataPagamento = this.getDataPagamento();
        LocalDate other$dataPagamento = other.getDataPagamento();
        if (this$dataPagamento == null ? other$dataPagamento != null : !((Object)this$dataPagamento).equals(other$dataPagamento)) {
            return false;
        }
        List this$tipoSituacaoParcelas = this.getTipoSituacaoParcelas();
        List other$tipoSituacaoParcelas = other.getTipoSituacaoParcelas();
        return !(this$tipoSituacaoParcelas == null ? other$tipoSituacaoParcelas != null : !((Object)this$tipoSituacaoParcelas).equals(other$tipoSituacaoParcelas));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FiltroExtratoDebitoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $todosCadastros = this.getTodosCadastros();
        result = result * 59 + ($todosCadastros == null ? 43 : ((Object)$todosCadastros).hashCode());
        Long $situacaoLegal = this.getSituacaoLegal();
        result = result * 59 + ($situacaoLegal == null ? 43 : ((Object)$situacaoLegal).hashCode());
        Boolean $visualizaDebitosNaoConstituidos = this.getVisualizaDebitosNaoConstituidos();
        result = result * 59 + ($visualizaDebitosNaoConstituidos == null ? 43 : ((Object)$visualizaDebitosNaoConstituidos).hashCode());
        Long $idDebito = this.getIdDebito();
        result = result * 59 + ($idDebito == null ? 43 : ((Object)$idDebito).hashCode());
        Long $idParcelamento = this.getIdParcelamento();
        result = result * 59 + ($idParcelamento == null ? 43 : ((Object)$idParcelamento).hashCode());
        Boolean $detalhado = this.getDetalhado();
        result = result * 59 + ($detalhado == null ? 43 : ((Object)$detalhado).hashCode());
        List $cadastros = this.getCadastros();
        result = result * 59 + ($cadastros == null ? 43 : ((Object)$cadastros).hashCode());
        TipoExtratoDebitoEnum $filtroCard = this.getFiltroCard();
        result = result * 59 + ($filtroCard == null ? 43 : $filtroCard.hashCode());
        LocalDate $dataLancamentoInicial = this.getDataLancamentoInicial();
        result = result * 59 + ($dataLancamentoInicial == null ? 43 : ((Object)$dataLancamentoInicial).hashCode());
        LocalDate $dataLancamentoFinal = this.getDataLancamentoFinal();
        result = result * 59 + ($dataLancamentoFinal == null ? 43 : ((Object)$dataLancamentoFinal).hashCode());
        LocalDate $dataVencimentoInicial = this.getDataVencimentoInicial();
        result = result * 59 + ($dataVencimentoInicial == null ? 43 : ((Object)$dataVencimentoInicial).hashCode());
        LocalDate $dataVencimentoFinal = this.getDataVencimentoFinal();
        result = result * 59 + ($dataVencimentoFinal == null ? 43 : ((Object)$dataVencimentoFinal).hashCode());
        List $situacaoParcela = this.getSituacaoParcela();
        result = result * 59 + ($situacaoParcela == null ? 43 : ((Object)$situacaoParcela).hashCode());
        String $ano = this.getAno();
        result = result * 59 + ($ano == null ? 43 : $ano.hashCode());
        String $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : $divida.hashCode());
        String $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : $subDivida.hashCode());
        String $parcela = this.getParcela();
        result = result * 59 + ($parcela == null ? 43 : $parcela.hashCode());
        String $numeroCda = this.getNumeroCda();
        result = result * 59 + ($numeroCda == null ? 43 : $numeroCda.hashCode());
        String $exercicioCda = this.getExercicioCda();
        result = result * 59 + ($exercicioCda == null ? 43 : $exercicioCda.hashCode());
        SituacaoVencimentoEnum $situacaoVencimento = this.getSituacaoVencimento();
        result = result * 59 + ($situacaoVencimento == null ? 43 : $situacaoVencimento.hashCode());
        LocalDate $dataReferencia = this.getDataReferencia();
        result = result * 59 + ($dataReferencia == null ? 43 : ((Object)$dataReferencia).hashCode());
        LocalDate $dataPagamento = this.getDataPagamento();
        result = result * 59 + ($dataPagamento == null ? 43 : ((Object)$dataPagamento).hashCode());
        List $tipoSituacaoParcelas = this.getTipoSituacaoParcelas();
        result = result * 59 + ($tipoSituacaoParcelas == null ? 43 : ((Object)$tipoSituacaoParcelas).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FiltroExtratoDebitoDTO(cadastros=" + String.valueOf(this.getCadastros()) + ", todosCadastros=" + this.getTodosCadastros() + ", filtroCard=" + String.valueOf(this.getFiltroCard()) + ", dataLancamentoInicial=" + String.valueOf(this.getDataLancamentoInicial()) + ", dataLancamentoFinal=" + String.valueOf(this.getDataLancamentoFinal()) + ", dataVencimentoInicial=" + String.valueOf(this.getDataVencimentoInicial()) + ", dataVencimentoFinal=" + String.valueOf(this.getDataVencimentoFinal()) + ", situacaoLegal=" + this.getSituacaoLegal() + ", situacaoParcela=" + String.valueOf(this.getSituacaoParcela()) + ", ano=" + this.getAno() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ", parcela=" + this.getParcela() + ", numeroCda=" + this.getNumeroCda() + ", exercicioCda=" + this.getExercicioCda() + ", situacaoVencimento=" + String.valueOf(this.getSituacaoVencimento()) + ", visualizaDebitosNaoConstituidos=" + this.getVisualizaDebitosNaoConstituidos() + ", idDebito=" + this.getIdDebito() + ", idParcelamento=" + this.getIdParcelamento() + ", detalhado=" + this.getDetalhado() + ", dataReferencia=" + String.valueOf(this.getDataReferencia()) + ", dataPagamento=" + String.valueOf(this.getDataPagamento()) + ", tipoSituacaoParcelas=" + String.valueOf(this.getTipoSituacaoParcelas()) + ")";
    }
}

