/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.SituacaoVencimentoEnum;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.util.MultiValueFilter;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class FiltroDebitoPorContribuinteDTO {
    private String cadastroGeral;
    private LocalDate dataVencimentoInicial;
    private LocalDate dataVencimentoFinal;
    private String situacaoLegal;
    private String situacaoParcela;
    private String divida;
    private String exercicio;
    private SituacaoVencimentoEnum situacaoVencimento;
    private String subDivida;
    private String parcela;
    private TipoCadastro tipoCadastro;

    public String buildFilter() {
        ArrayList<String> filtros = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)this.cadastroGeral)) {
            filtros.add(MultiValueFilter.generateFilters((String)this.cadastroGeral, (String)"td.cadastrogeral"));
        }
        if (Objects.nonNull(this.dataVencimentoInicial)) {
            filtros.add("tdp.datavencimento >= :datavencimentoinicial");
        }
        if (Objects.nonNull(this.dataVencimentoFinal)) {
            filtros.add("tdp.datavencimento <= :datavencimentofinal");
        }
        if (StringUtils.isNotBlank((CharSequence)this.situacaoLegal)) {
            filtros.add(String.format("tdp.situacaolegal = %s", this.situacaoLegal));
        }
        if (StringUtils.isNotBlank((CharSequence)this.situacaoParcela)) {
            filtros.add(String.format("tsp.situacaoparcela = %s", this.situacaoParcela));
        }
        if (StringUtils.isNotBlank((CharSequence)this.exercicio)) {
            filtros.add(MultiValueFilter.generateFilters((String)this.exercicio, (String)"td.exercicio"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.subDivida)) {
            filtros.add(MultiValueFilter.generateFilters((String)this.subDivida, (String)"td.subdivida"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.divida)) {
            filtros.add(MultiValueFilter.generateFilters((String)this.divida, (String)"td.guiarecolhimento"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.parcela)) {
            filtros.add(MultiValueFilter.generateFilters((String)this.parcela, (String)"tdp.parcela"));
        }
        if (SituacaoVencimentoEnum.VENCIDOS.equals((Object)this.situacaoVencimento)) {
            filtros.add("tdp.datavencimento < :DATAATUAL");
        }
        if (SituacaoVencimentoEnum.A_VENCER.equals((Object)this.situacaoVencimento)) {
            filtros.add("tdp.datavencimento >= :DATAATUAL");
        }
        if (Objects.nonNull(this.tipoCadastro)) {
            filtros.add(String.format("td.tipocadastro = %d", this.tipoCadastro.getValue()));
        }
        return String.join((CharSequence)" and ", filtros);
    }

    @Generated
    public FiltroDebitoPorContribuinteDTO() {
    }

    @Generated
    public String getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public LocalDate getDataVencimentoInicial() {
        return this.dataVencimentoInicial;
    }

    @Generated
    public LocalDate getDataVencimentoFinal() {
        return this.dataVencimentoFinal;
    }

    @Generated
    public String getSituacaoLegal() {
        return this.situacaoLegal;
    }

    @Generated
    public String getSituacaoParcela() {
        return this.situacaoParcela;
    }

    @Generated
    public String getDivida() {
        return this.divida;
    }

    @Generated
    public String getExercicio() {
        return this.exercicio;
    }

    @Generated
    public SituacaoVencimentoEnum getSituacaoVencimento() {
        return this.situacaoVencimento;
    }

    @Generated
    public String getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public String getParcela() {
        return this.parcela;
    }

    @Generated
    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(String cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setDataVencimentoInicial(LocalDate dataVencimentoInicial) {
        this.dataVencimentoInicial = dataVencimentoInicial;
    }

    @Generated
    public void setDataVencimentoFinal(LocalDate dataVencimentoFinal) {
        this.dataVencimentoFinal = dataVencimentoFinal;
    }

    @Generated
    public void setSituacaoLegal(String situacaoLegal) {
        this.situacaoLegal = situacaoLegal;
    }

    @Generated
    public void setSituacaoParcela(String situacaoParcela) {
        this.situacaoParcela = situacaoParcela;
    }

    @Generated
    public void setDivida(String divida) {
        this.divida = divida;
    }

    @Generated
    public void setExercicio(String exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setSituacaoVencimento(SituacaoVencimentoEnum situacaoVencimento) {
        this.situacaoVencimento = situacaoVencimento;
    }

    @Generated
    public void setSubDivida(String subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setParcela(String parcela) {
        this.parcela = parcela;
    }

    @Generated
    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiltroDebitoPorContribuinteDTO)) {
            return false;
        }
        FiltroDebitoPorContribuinteDTO other = (FiltroDebitoPorContribuinteDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$cadastroGeral = this.getCadastroGeral();
        String other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        LocalDate this$dataVencimentoInicial = this.getDataVencimentoInicial();
        LocalDate other$dataVencimentoInicial = other.getDataVencimentoInicial();
        if (this$dataVencimentoInicial == null ? other$dataVencimentoInicial != null : !((Object)this$dataVencimentoInicial).equals(other$dataVencimentoInicial)) {
            return false;
        }
        LocalDate this$dataVencimentoFinal = this.getDataVencimentoFinal();
        LocalDate other$dataVencimentoFinal = other.getDataVencimentoFinal();
        if (this$dataVencimentoFinal == null ? other$dataVencimentoFinal != null : !((Object)this$dataVencimentoFinal).equals(other$dataVencimentoFinal)) {
            return false;
        }
        String this$situacaoLegal = this.getSituacaoLegal();
        String other$situacaoLegal = other.getSituacaoLegal();
        if (this$situacaoLegal == null ? other$situacaoLegal != null : !this$situacaoLegal.equals(other$situacaoLegal)) {
            return false;
        }
        String this$situacaoParcela = this.getSituacaoParcela();
        String other$situacaoParcela = other.getSituacaoParcela();
        if (this$situacaoParcela == null ? other$situacaoParcela != null : !this$situacaoParcela.equals(other$situacaoParcela)) {
            return false;
        }
        String this$divida = this.getDivida();
        String other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !this$divida.equals(other$divida)) {
            return false;
        }
        String this$exercicio = this.getExercicio();
        String other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !this$exercicio.equals(other$exercicio)) {
            return false;
        }
        SituacaoVencimentoEnum this$situacaoVencimento = this.getSituacaoVencimento();
        SituacaoVencimentoEnum other$situacaoVencimento = other.getSituacaoVencimento();
        if (this$situacaoVencimento == null ? other$situacaoVencimento != null : !this$situacaoVencimento.equals(other$situacaoVencimento)) {
            return false;
        }
        String this$subDivida = this.getSubDivida();
        String other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !this$subDivida.equals(other$subDivida)) {
            return false;
        }
        String this$parcela = this.getParcela();
        String other$parcela = other.getParcela();
        if (this$parcela == null ? other$parcela != null : !this$parcela.equals(other$parcela)) {
            return false;
        }
        TipoCadastro this$tipoCadastro = this.getTipoCadastro();
        TipoCadastro other$tipoCadastro = other.getTipoCadastro();
        return !(this$tipoCadastro == null ? other$tipoCadastro != null : !this$tipoCadastro.equals(other$tipoCadastro));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FiltroDebitoPorContribuinteDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        LocalDate $dataVencimentoInicial = this.getDataVencimentoInicial();
        result = result * 59 + ($dataVencimentoInicial == null ? 43 : ((Object)$dataVencimentoInicial).hashCode());
        LocalDate $dataVencimentoFinal = this.getDataVencimentoFinal();
        result = result * 59 + ($dataVencimentoFinal == null ? 43 : ((Object)$dataVencimentoFinal).hashCode());
        String $situacaoLegal = this.getSituacaoLegal();
        result = result * 59 + ($situacaoLegal == null ? 43 : $situacaoLegal.hashCode());
        String $situacaoParcela = this.getSituacaoParcela();
        result = result * 59 + ($situacaoParcela == null ? 43 : $situacaoParcela.hashCode());
        String $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : $divida.hashCode());
        String $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : $exercicio.hashCode());
        SituacaoVencimentoEnum $situacaoVencimento = this.getSituacaoVencimento();
        result = result * 59 + ($situacaoVencimento == null ? 43 : $situacaoVencimento.hashCode());
        String $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : $subDivida.hashCode());
        String $parcela = this.getParcela();
        result = result * 59 + ($parcela == null ? 43 : $parcela.hashCode());
        TipoCadastro $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : $tipoCadastro.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FiltroDebitoPorContribuinteDTO(cadastroGeral=" + this.getCadastroGeral() + ", dataVencimentoInicial=" + String.valueOf(this.getDataVencimentoInicial()) + ", dataVencimentoFinal=" + String.valueOf(this.getDataVencimentoFinal()) + ", situacaoLegal=" + this.getSituacaoLegal() + ", situacaoParcela=" + this.getSituacaoParcela() + ", divida=" + this.getDivida() + ", exercicio=" + this.getExercicio() + ", situacaoVencimento=" + String.valueOf(this.getSituacaoVencimento()) + ", subDivida=" + this.getSubDivida() + ", parcela=" + this.getParcela() + ", tipoCadastro=" + String.valueOf(this.getTipoCadastro()) + ")";
    }
}

