/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.util.MultiValueFilter;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class FiltroCreditoContribuinteDTO {
    @NotNull
    @Caption(value="Entidade")
    private Long entidade;
    private String exercicio;
    private String credito;
    private String lote;
    private String exercicioLote;
    private Long tipoCadastro;
    private String cadastroGeral;
    private String exercicioDebito;
    private String divida;
    private String subDivida;
    private LocalDate dataMovimento;
    private LocalDate dataPagamento;
    private Long contaBancaria;
    private static final String AND = " and ";

    public String buildFiltroDebito() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" select itens  from CreditoContribuinteItem itens  join itens.debitoParcelaTributo debitoParcelaTributo  where itens.creditoContribuinte = credito ");
        if (Objects.nonNull(this.tipoCadastro)) {
            stringBuilder.append(AND).append(String.format("debitoParcelaTributo.tipoCadastro = %d", this.tipoCadastro));
        }
        if (StringUtils.isNotBlank((CharSequence)this.cadastroGeral)) {
            stringBuilder.append(AND).append(MultiValueFilter.generateFilters((String)this.cadastroGeral, (String)"debitoParcelaTributo.cadastroGeral"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.exercicioDebito)) {
            stringBuilder.append(AND).append(MultiValueFilter.generateFilters((String)this.exercicioDebito, (String)"debitoParcelaTributo.exercicio"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.divida)) {
            stringBuilder.append(AND).append(MultiValueFilter.generateFilters((String)this.divida, (String)"debitoParcelaTributo.divida"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.subDivida)) {
            stringBuilder.append(AND).append(MultiValueFilter.generateFilters((String)this.subDivida, (String)"debitoParcelaTributo.subDivida"));
        }
        return stringBuilder.toString();
    }

    private Boolean hasFiltroDebito() {
        return Objects.nonNull(this.exercicioDebito) || Objects.nonNull(this.tipoCadastro) || Objects.nonNull(this.cadastroGeral) || Objects.nonNull(this.divida) || Objects.nonNull(this.subDivida);
    }

    private Boolean hasFiltroDatas() {
        return Objects.nonNull(this.dataMovimento) || Objects.nonNull(this.dataPagamento);
    }

    private String buildFiltroDatas() {
        StringBuilder stringBuilder = new StringBuilder();
        if (Objects.nonNull(this.dataMovimento)) {
            stringBuilder.append(AND).append("credito.dataMovimento = :dataMovimento");
        }
        if (Objects.nonNull(this.dataPagamento)) {
            stringBuilder.append(AND).append("credito.dataPagamento = :dataPagamento");
        }
        return stringBuilder.toString();
    }

    public String buildFiltro() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format(" credito.id.entidade = %d", this.entidade));
        if (StringUtils.isNotBlank((CharSequence)this.exercicio)) {
            stringBuilder.append(AND).append(MultiValueFilter.generateFilters((String)this.exercicio, (String)"credito.id.exercicio"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.credito)) {
            stringBuilder.append(AND).append(MultiValueFilter.generateFilters((String)this.credito, (String)"credito.id.creditoContribuinte"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.lote)) {
            stringBuilder.append(AND).append(MultiValueFilter.generateFilters((String)this.lote, (String)"credito.lote.id.lote"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.exercicioLote)) {
            stringBuilder.append(AND).append(MultiValueFilter.generateFilters((String)this.exercicioLote, (String)"credito.lote.id.exercicio"));
        }
        if (Objects.nonNull(this.contaBancaria)) {
            stringBuilder.append(AND).append(String.format("contaBancaria.id = %d", this.contaBancaria));
        }
        if (this.hasFiltroDatas().booleanValue()) {
            stringBuilder.append(this.buildFiltroDatas());
        }
        if (this.hasFiltroDebito().booleanValue()) {
            stringBuilder.append(AND).append(" exists ( ").append(this.buildFiltroDebito()).append(" ) ");
        }
        return stringBuilder.toString();
    }

    public Map<String, LocalDate> getFiltroDatas() {
        HashMap<String, LocalDate> filtros = new HashMap<String, LocalDate>();
        if (Objects.nonNull(this.dataMovimento)) {
            filtros.put("dataMovimento", this.dataMovimento);
        }
        if (Objects.nonNull(this.dataPagamento)) {
            filtros.put("dataPagamento", this.dataPagamento);
        }
        return filtros;
    }

    @Generated
    public FiltroCreditoContribuinteDTO() {
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public String getExercicio() {
        return this.exercicio;
    }

    @Generated
    public String getCredito() {
        return this.credito;
    }

    @Generated
    public String getLote() {
        return this.lote;
    }

    @Generated
    public String getExercicioLote() {
        return this.exercicioLote;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public String getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getExercicioDebito() {
        return this.exercicioDebito;
    }

    @Generated
    public String getDivida() {
        return this.divida;
    }

    @Generated
    public String getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public LocalDate getDataMovimento() {
        return this.dataMovimento;
    }

    @Generated
    public LocalDate getDataPagamento() {
        return this.dataPagamento;
    }

    @Generated
    public Long getContaBancaria() {
        return this.contaBancaria;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(String exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setCredito(String credito) {
        this.credito = credito;
    }

    @Generated
    public void setLote(String lote) {
        this.lote = lote;
    }

    @Generated
    public void setExercicioLote(String exercicioLote) {
        this.exercicioLote = exercicioLote;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(String cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setExercicioDebito(String exercicioDebito) {
        this.exercicioDebito = exercicioDebito;
    }

    @Generated
    public void setDivida(String divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(String subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setDataMovimento(LocalDate dataMovimento) {
        this.dataMovimento = dataMovimento;
    }

    @Generated
    public void setDataPagamento(LocalDate dataPagamento) {
        this.dataPagamento = dataPagamento;
    }

    @Generated
    public void setContaBancaria(Long contaBancaria) {
        this.contaBancaria = contaBancaria;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiltroCreditoContribuinteDTO)) {
            return false;
        }
        FiltroCreditoContribuinteDTO other = (FiltroCreditoContribuinteDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$contaBancaria = this.getContaBancaria();
        Long other$contaBancaria = other.getContaBancaria();
        if (this$contaBancaria == null ? other$contaBancaria != null : !((Object)this$contaBancaria).equals(other$contaBancaria)) {
            return false;
        }
        String this$exercicio = this.getExercicio();
        String other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !this$exercicio.equals(other$exercicio)) {
            return false;
        }
        String this$credito = this.getCredito();
        String other$credito = other.getCredito();
        if (this$credito == null ? other$credito != null : !this$credito.equals(other$credito)) {
            return false;
        }
        String this$lote = this.getLote();
        String other$lote = other.getLote();
        if (this$lote == null ? other$lote != null : !this$lote.equals(other$lote)) {
            return false;
        }
        String this$exercicioLote = this.getExercicioLote();
        String other$exercicioLote = other.getExercicioLote();
        if (this$exercicioLote == null ? other$exercicioLote != null : !this$exercicioLote.equals(other$exercicioLote)) {
            return false;
        }
        String this$cadastroGeral = this.getCadastroGeral();
        String other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        String this$exercicioDebito = this.getExercicioDebito();
        String other$exercicioDebito = other.getExercicioDebito();
        if (this$exercicioDebito == null ? other$exercicioDebito != null : !this$exercicioDebito.equals(other$exercicioDebito)) {
            return false;
        }
        String this$divida = this.getDivida();
        String other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !this$divida.equals(other$divida)) {
            return false;
        }
        String this$subDivida = this.getSubDivida();
        String other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !this$subDivida.equals(other$subDivida)) {
            return false;
        }
        LocalDate this$dataMovimento = this.getDataMovimento();
        LocalDate other$dataMovimento = other.getDataMovimento();
        if (this$dataMovimento == null ? other$dataMovimento != null : !((Object)this$dataMovimento).equals(other$dataMovimento)) {
            return false;
        }
        LocalDate this$dataPagamento = this.getDataPagamento();
        LocalDate other$dataPagamento = other.getDataPagamento();
        return !(this$dataPagamento == null ? other$dataPagamento != null : !((Object)this$dataPagamento).equals(other$dataPagamento));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FiltroCreditoContribuinteDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $contaBancaria = this.getContaBancaria();
        result = result * 59 + ($contaBancaria == null ? 43 : ((Object)$contaBancaria).hashCode());
        String $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : $exercicio.hashCode());
        String $credito = this.getCredito();
        result = result * 59 + ($credito == null ? 43 : $credito.hashCode());
        String $lote = this.getLote();
        result = result * 59 + ($lote == null ? 43 : $lote.hashCode());
        String $exercicioLote = this.getExercicioLote();
        result = result * 59 + ($exercicioLote == null ? 43 : $exercicioLote.hashCode());
        String $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        String $exercicioDebito = this.getExercicioDebito();
        result = result * 59 + ($exercicioDebito == null ? 43 : $exercicioDebito.hashCode());
        String $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : $divida.hashCode());
        String $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : $subDivida.hashCode());
        LocalDate $dataMovimento = this.getDataMovimento();
        result = result * 59 + ($dataMovimento == null ? 43 : ((Object)$dataMovimento).hashCode());
        LocalDate $dataPagamento = this.getDataPagamento();
        result = result * 59 + ($dataPagamento == null ? 43 : ((Object)$dataPagamento).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FiltroCreditoContribuinteDTO(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", credito=" + this.getCredito() + ", lote=" + this.getLote() + ", exercicioLote=" + this.getExercicioLote() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", exercicioDebito=" + this.getExercicioDebito() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ", dataMovimento=" + String.valueOf(this.getDataMovimento()) + ", dataPagamento=" + String.valueOf(this.getDataPagamento()) + ", contaBancaria=" + this.getContaBancaria() + ")";
    }
}

