/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.enums.negociacaodebito.TipoNegociacao;
import br.com.elotech.tributos.util.MultiValueFilter;
import java.time.LocalDate;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.format.annotation.DateTimeFormat;

public class FiltroConsultaDebitoPagamentoNegociado {
    @NotNull
    private TipoCadastro tipoCadastro;
    @NotNull
    private String cadastroGeral;
    @NotNull
    @DateTimeFormat(pattern="yyyy-MM-dd")
    private LocalDate dataReferencia;
    private String exercicio;
    private String divida;
    private String subDivida;
    private String parcela;
    @DateTimeFormat(pattern="yyyy-MM-dd")
    private LocalDate dataVencimentoInicial;
    @DateTimeFormat(pattern="yyyy-MM-dd")
    private LocalDate dataVencimentoFinal;
    private String anoCDA;
    private String numeroCDA;
    private Long situacaoLegal;
    private Long exercicioFormaPagamento;
    private String anoContrato;
    private String numeroContrato;
    private TipoNegociacao tipoNegociacao;
    private static final String AND = " and ";

    private String addAnd(String clause) {
        return AND + clause;
    }

    public String buildWhere() {
        StringBuilder clause = new StringBuilder();
        this.appendCadastroGeral(clause);
        this.appendTipoCadastro(clause);
        this.appendSituacaoLegal(clause);
        this.appendExercicio(clause);
        this.appendDivida(clause);
        this.appendSubDivida(clause);
        this.appendParcela(clause);
        this.appendDataVencimentoInicial(clause);
        this.appendDataVencimentoFinal(clause);
        this.appendNumeroAnoCda(clause);
        this.appendNumeroAnoContrato(clause);
        return clause.toString();
    }

    private void appendNumeroAnoContrato(StringBuilder clause) {
        if (TipoNegociacao.JUDICIAL.equals((Object)this.tipoNegociacao)) {
            this.appendAnoContrato(clause);
            this.appendNumeroContrato(clause);
            return;
        }
        clause.append(this.addAnd("td.parcelado = 'N'"));
        clause.append(this.addAnd("td.reparcelado = 'N'"));
    }

    private void appendAnoContrato(StringBuilder clause) {
        if (StringUtils.isNotBlank((CharSequence)this.anoContrato)) {
            clause.append(this.addAnd(MultiValueFilter.generateFilters((String)this.anoContrato, (String)"tp.anocontrato")));
        }
    }

    private void appendNumeroContrato(StringBuilder clause) {
        if (StringUtils.isNotBlank((CharSequence)this.numeroContrato)) {
            clause.append(this.addAnd(MultiValueFilter.generateFilters((String)this.numeroContrato, (String)"tp.numerocontrato")));
        }
    }

    private void appendNumeroAnoCda(StringBuilder clause) {
        if (StringUtils.isNotBlank((CharSequence)this.anoCDA) && StringUtils.isNotBlank((CharSequence)this.numeroCDA)) {
            clause.append(String.format(" AND EXISTS ( SELECT 1 FROM tribdocumentoitemdividaativa tdida WHERE tdida.entidade = tdpr.entidade AND tdida.exerciciodebito = tdpr.exercicio AND tdida.tipocadastro = tdpr.tipocadastro AND tdida.cadastrogeral = tdpr.cadastrogeral AND tdida.guiarecolhimento = tdpr.guiarecolhimento AND tdida.subdivida = tdpr.subdivida AND tdida.parcela = tdpr.parcela AND tdida.receita = tdpr.receita AND tdida.exercicio = %s AND tdida.tipodocumento = 26 AND tdida.documento = %s)", this.anoCDA, this.numeroCDA));
        }
    }

    private void appendDataVencimentoFinal(StringBuilder clause) {
        if (Objects.nonNull(this.dataVencimentoFinal)) {
            clause.append(this.addAnd("tdp.datavencimento <= :DATAVENCIMENTOFINAL"));
        }
    }

    private void appendDataVencimentoInicial(StringBuilder clause) {
        if (Objects.nonNull(this.dataVencimentoInicial)) {
            clause.append(this.addAnd("tdp.datavencimento >= :DATAVENCIMENTOINICIAL"));
        }
    }

    private void appendParcela(StringBuilder clause) {
        if (StringUtils.isNotBlank((CharSequence)this.parcela)) {
            clause.append(this.addAnd(MultiValueFilter.generateFilters((String)this.parcela, (String)"tdp.parcela")));
        }
    }

    private void appendSubDivida(StringBuilder clause) {
        if (StringUtils.isNotBlank((CharSequence)this.subDivida)) {
            clause.append(this.addAnd(MultiValueFilter.generateFilters((String)this.subDivida, (String)"tdp.subdivida")));
        }
    }

    private void appendDivida(StringBuilder clause) {
        if (StringUtils.isNotBlank((CharSequence)this.divida)) {
            clause.append(this.addAnd(MultiValueFilter.generateFilters((String)this.divida, (String)"tdp.guiarecolhimento")));
        }
    }

    private void appendExercicio(StringBuilder clause) {
        if (StringUtils.isNotBlank((CharSequence)this.exercicio)) {
            clause.append(this.addAnd(MultiValueFilter.generateFilters((String)this.exercicio, (String)"tdp.exercicio")));
        }
    }

    private void appendSituacaoLegal(StringBuilder clause) {
        if (Objects.nonNull(this.situacaoLegal)) {
            clause.append(this.addAnd(String.format("tdp.situacaolegal = %d", this.situacaoLegal)));
        }
    }

    private void appendTipoCadastro(StringBuilder clause) {
        clause.append(this.addAnd(String.format("tdp.tipocadastro = %d", this.tipoCadastro.getValue())));
    }

    private void appendCadastroGeral(StringBuilder clause) {
        clause.append(this.addAnd(MultiValueFilter.generateFilters((String)this.cadastroGeral, (String)"tdp.cadastrogeral")));
    }

    @Generated
    public FiltroConsultaDebitoPagamentoNegociado() {
    }

    @Generated
    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public String getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public LocalDate getDataReferencia() {
        return this.dataReferencia;
    }

    @Generated
    public String getExercicio() {
        return this.exercicio;
    }

    @Generated
    public String getDivida() {
        return this.divida;
    }

    @Generated
    public String getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public String getParcela() {
        return this.parcela;
    }

    @Generated
    public LocalDate getDataVencimentoInicial() {
        return this.dataVencimentoInicial;
    }

    @Generated
    public LocalDate getDataVencimentoFinal() {
        return this.dataVencimentoFinal;
    }

    @Generated
    public String getAnoCDA() {
        return this.anoCDA;
    }

    @Generated
    public String getNumeroCDA() {
        return this.numeroCDA;
    }

    @Generated
    public Long getSituacaoLegal() {
        return this.situacaoLegal;
    }

    @Generated
    public Long getExercicioFormaPagamento() {
        return this.exercicioFormaPagamento;
    }

    @Generated
    public String getAnoContrato() {
        return this.anoContrato;
    }

    @Generated
    public String getNumeroContrato() {
        return this.numeroContrato;
    }

    @Generated
    public TipoNegociacao getTipoNegociacao() {
        return this.tipoNegociacao;
    }

    @Generated
    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(String cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setDataReferencia(LocalDate dataReferencia) {
        this.dataReferencia = dataReferencia;
    }

    @Generated
    public void setExercicio(String exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setDivida(String divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(String subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setParcela(String parcela) {
        this.parcela = parcela;
    }

    @Generated
    public void setDataVencimentoInicial(LocalDate dataVencimentoInicial) {
        this.dataVencimentoInicial = dataVencimentoInicial;
    }

    @Generated
    public void setDataVencimentoFinal(LocalDate dataVencimentoFinal) {
        this.dataVencimentoFinal = dataVencimentoFinal;
    }

    @Generated
    public void setAnoCDA(String anoCDA) {
        this.anoCDA = anoCDA;
    }

    @Generated
    public void setNumeroCDA(String numeroCDA) {
        this.numeroCDA = numeroCDA;
    }

    @Generated
    public void setSituacaoLegal(Long situacaoLegal) {
        this.situacaoLegal = situacaoLegal;
    }

    @Generated
    public void setExercicioFormaPagamento(Long exercicioFormaPagamento) {
        this.exercicioFormaPagamento = exercicioFormaPagamento;
    }

    @Generated
    public void setAnoContrato(String anoContrato) {
        this.anoContrato = anoContrato;
    }

    @Generated
    public void setNumeroContrato(String numeroContrato) {
        this.numeroContrato = numeroContrato;
    }

    @Generated
    public void setTipoNegociacao(TipoNegociacao tipoNegociacao) {
        this.tipoNegociacao = tipoNegociacao;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiltroConsultaDebitoPagamentoNegociado)) {
            return false;
        }
        FiltroConsultaDebitoPagamentoNegociado other = (FiltroConsultaDebitoPagamentoNegociado)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$situacaoLegal = this.getSituacaoLegal();
        Long other$situacaoLegal = other.getSituacaoLegal();
        if (this$situacaoLegal == null ? other$situacaoLegal != null : !((Object)this$situacaoLegal).equals(other$situacaoLegal)) {
            return false;
        }
        Long this$exercicioFormaPagamento = this.getExercicioFormaPagamento();
        Long other$exercicioFormaPagamento = other.getExercicioFormaPagamento();
        if (this$exercicioFormaPagamento == null ? other$exercicioFormaPagamento != null : !((Object)this$exercicioFormaPagamento).equals(other$exercicioFormaPagamento)) {
            return false;
        }
        TipoCadastro this$tipoCadastro = this.getTipoCadastro();
        TipoCadastro other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !this$tipoCadastro.equals(other$tipoCadastro)) {
            return false;
        }
        String this$cadastroGeral = this.getCadastroGeral();
        String other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        LocalDate this$dataReferencia = this.getDataReferencia();
        LocalDate other$dataReferencia = other.getDataReferencia();
        if (this$dataReferencia == null ? other$dataReferencia != null : !((Object)this$dataReferencia).equals(other$dataReferencia)) {
            return false;
        }
        String this$exercicio = this.getExercicio();
        String other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !this$exercicio.equals(other$exercicio)) {
            return false;
        }
        String this$divida = this.getDivida();
        String other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !this$divida.equals(other$divida)) {
            return false;
        }
        String this$subDivida = this.getSubDivida();
        String other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !this$subDivida.equals(other$subDivida)) {
            return false;
        }
        String this$parcela = this.getParcela();
        String other$parcela = other.getParcela();
        if (this$parcela == null ? other$parcela != null : !this$parcela.equals(other$parcela)) {
            return false;
        }
        LocalDate this$dataVencimentoInicial = this.getDataVencimentoInicial();
        LocalDate other$dataVencimentoInicial = other.getDataVencimentoInicial();
        if (this$dataVencimentoInicial == null ? other$dataVencimentoInicial != null : !((Object)this$dataVencimentoInicial).equals(other$dataVencimentoInicial)) {
            return false;
        }
        LocalDate this$dataVencimentoFinal = this.getDataVencimentoFinal();
        LocalDate other$dataVencimentoFinal = other.getDataVencimentoFinal();
        if (this$dataVencimentoFinal == null ? other$dataVencimentoFinal != null : !((Object)this$dataVencimentoFinal).equals(other$dataVencimentoFinal)) {
            return false;
        }
        String this$anoCDA = this.getAnoCDA();
        String other$anoCDA = other.getAnoCDA();
        if (this$anoCDA == null ? other$anoCDA != null : !this$anoCDA.equals(other$anoCDA)) {
            return false;
        }
        String this$numeroCDA = this.getNumeroCDA();
        String other$numeroCDA = other.getNumeroCDA();
        if (this$numeroCDA == null ? other$numeroCDA != null : !this$numeroCDA.equals(other$numeroCDA)) {
            return false;
        }
        String this$anoContrato = this.getAnoContrato();
        String other$anoContrato = other.getAnoContrato();
        if (this$anoContrato == null ? other$anoContrato != null : !this$anoContrato.equals(other$anoContrato)) {
            return false;
        }
        String this$numeroContrato = this.getNumeroContrato();
        String other$numeroContrato = other.getNumeroContrato();
        if (this$numeroContrato == null ? other$numeroContrato != null : !this$numeroContrato.equals(other$numeroContrato)) {
            return false;
        }
        TipoNegociacao this$tipoNegociacao = this.getTipoNegociacao();
        TipoNegociacao other$tipoNegociacao = other.getTipoNegociacao();
        return !(this$tipoNegociacao == null ? other$tipoNegociacao != null : !this$tipoNegociacao.equals(other$tipoNegociacao));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FiltroConsultaDebitoPagamentoNegociado;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $situacaoLegal = this.getSituacaoLegal();
        result = result * 59 + ($situacaoLegal == null ? 43 : ((Object)$situacaoLegal).hashCode());
        Long $exercicioFormaPagamento = this.getExercicioFormaPagamento();
        result = result * 59 + ($exercicioFormaPagamento == null ? 43 : ((Object)$exercicioFormaPagamento).hashCode());
        TipoCadastro $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : $tipoCadastro.hashCode());
        String $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        LocalDate $dataReferencia = this.getDataReferencia();
        result = result * 59 + ($dataReferencia == null ? 43 : ((Object)$dataReferencia).hashCode());
        String $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : $exercicio.hashCode());
        String $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : $divida.hashCode());
        String $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : $subDivida.hashCode());
        String $parcela = this.getParcela();
        result = result * 59 + ($parcela == null ? 43 : $parcela.hashCode());
        LocalDate $dataVencimentoInicial = this.getDataVencimentoInicial();
        result = result * 59 + ($dataVencimentoInicial == null ? 43 : ((Object)$dataVencimentoInicial).hashCode());
        LocalDate $dataVencimentoFinal = this.getDataVencimentoFinal();
        result = result * 59 + ($dataVencimentoFinal == null ? 43 : ((Object)$dataVencimentoFinal).hashCode());
        String $anoCDA = this.getAnoCDA();
        result = result * 59 + ($anoCDA == null ? 43 : $anoCDA.hashCode());
        String $numeroCDA = this.getNumeroCDA();
        result = result * 59 + ($numeroCDA == null ? 43 : $numeroCDA.hashCode());
        String $anoContrato = this.getAnoContrato();
        result = result * 59 + ($anoContrato == null ? 43 : $anoContrato.hashCode());
        String $numeroContrato = this.getNumeroContrato();
        result = result * 59 + ($numeroContrato == null ? 43 : $numeroContrato.hashCode());
        TipoNegociacao $tipoNegociacao = this.getTipoNegociacao();
        result = result * 59 + ($tipoNegociacao == null ? 43 : $tipoNegociacao.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FiltroConsultaDebitoPagamentoNegociado(tipoCadastro=" + String.valueOf(this.getTipoCadastro()) + ", cadastroGeral=" + this.getCadastroGeral() + ", dataReferencia=" + String.valueOf(this.getDataReferencia()) + ", exercicio=" + this.getExercicio() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ", parcela=" + this.getParcela() + ", dataVencimentoInicial=" + String.valueOf(this.getDataVencimentoInicial()) + ", dataVencimentoFinal=" + String.valueOf(this.getDataVencimentoFinal()) + ", anoCDA=" + this.getAnoCDA() + ", numeroCDA=" + this.getNumeroCDA() + ", situacaoLegal=" + this.getSituacaoLegal() + ", exercicioFormaPagamento=" + this.getExercicioFormaPagamento() + ", anoContrato=" + this.getAnoContrato() + ", numeroContrato=" + this.getNumeroContrato() + ", tipoNegociacao=" + String.valueOf(this.getTipoNegociacao()) + ")";
    }
}

