/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.ConsultaDebitoTipoAgrupamento;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.dto.TributoDTO;
import br.com.elotech.tributos.dto.cadastro.DistritoDTO;
import br.com.elotech.tributos.dto.cadastro.SetorDTO;
import br.com.elotech.tributos.dto.cadastro.SetorQuadraDTO;
import br.com.elotech.tributos.dto.enums.TipoFiltroBoolean;
import br.com.elotech.tributos.util.DateUtils;
import br.com.elotech.tributos.util.MultiValueFilter;
import br.com.elotech.tributos.util.debito.ConsultaDebitoUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class FiltroConsultaDebitoDTO {
    private Long entidade;
    private Pessoa pessoa;
    private List<TipoCadastro> tiposCadastros;
    private String cadastroGeral;
    private String anoDebito;
    private String divida;
    private String subDivida;
    private LocalDate dataLancamentoInicial;
    private LocalDate dataLancamentoFinal;
    private LocalDate dataVencimentoInicial;
    private LocalDate dataVencimentoFinal;
    private LocalDate dataInscricaoDividaAtivaInicial;
    private LocalDate dataInscricaoDividaAtivaFinal;
    private Boolean noExercicio = Boolean.FALSE;
    private Boolean dividaAtiva = Boolean.FALSE;
    private Boolean juizo = Boolean.FALSE;
    private Long tipoSituacaoParcela;
    private Boolean somenteParcelasEmAberto = Boolean.FALSE;
    private Boolean calcularAcrescimos = Boolean.FALSE;
    private LocalDate dataReferencia;
    private Long qtdParcelasVencidas;
    private BigDecimal valorMinimo = BigDecimal.ZERO;
    private BigDecimal valorMaximo = BigDecimal.ZERO;
    private Cidade cidade;
    private Bairro bairro;
    private Logradouro logradouro;
    private String complemento;
    private String numero;
    private String pessoaRange;
    private String parcela;
    private TipoFiltroBoolean parcelado = TipoFiltroBoolean.TODOS;
    private TipoFiltroBoolean reparcelado = TipoFiltroBoolean.TODOS;
    private Long debitosProtestados;
    private String anoBase;
    private List<TributoDTO> tributos;
    private List<DistritoDTO> distritos;
    private List<SetorDTO> zonas;
    private List<SetorQuadraDTO> quadras;
    private List<String> lotesImobiliarios;
    private List<String> lotesRurais;
    private String anoCda;
    private String cda;
    private String anoParcelamento;
    private String parcelamento;
    @NotNull
    private ConsultaDebitoTipoAgrupamento tipoAgrupamento;
    private static final String DEFAULT_WHERE = " WHERE TD.CONSTITUIDO = 'S' AND TDPR.VALOR <> 0 ";
    private static final String SQL_ANO_BASE = "EXISTS ( SELECT 1 FROM TRIBDEBITOPARCELA TDP1  INNER JOIN TRIBSITUACAOPARCELA TSP1   ON TDP1.SITUACAODEBITO = TSP1.SITUACAOPARCELA INNER JOIN TRIBTIPOSITUACAOPARCELA TTSP1   ON TSP1.TIPOSITUACAOPARCELA = TTSP1.TIPOSITUACAOPARCELA WHERE TDP1.ENTIDADE = TD.ENTIDADE ";
    private static final Long COM_PROTESTO = 2L;
    private static final Long SEM_PROTESTO = 3L;

    private String addAND(String clausula) {
        return " AND " + clausula;
    }

    public String generateWhere(Long idDebito) {
        StringBuilder where = new StringBuilder(this.generateWhere());
        this.appendIdDebito(idDebito, where);
        return where.toString();
    }

    public String generateWhereWithCte() {
        StringBuilder where = new StringBuilder(this.generateWhere());
        this.appendCte(where);
        return where.toString();
    }

    public String generateWhere() {
        StringBuilder where = new StringBuilder(DEFAULT_WHERE);
        if (Boolean.TRUE.equals(this.calcularAcrescimos) && Objects.isNull(this.dataReferencia)) {
            throw new EloValidationException("A data da refer\u00eancia \u00e9 obrigat\u00f3ria para calcular o acr\u00e9scimo.");
        }
        this.appendEntidade(where);
        this.appendTipoPessoa(where);
        this.appendPessoa(where);
        this.appendPessoaWithMultiValue(where);
        this.appendTipoCadastro(where);
        this.appendCadastroGeral(where);
        this.appendAnoDebito(where);
        this.appendDivida(where);
        this.appendSubDivida(where);
        this.appendParcela(where);
        this.appendTributos(where);
        this.appendDataLancamentoInicial(where);
        this.appendDataLancamentoFinal(where);
        this.appendDataVencimentoInicial(where);
        this.appendDataVencimentoFinal(where);
        this.appendDataInscricaoDividaAtivaInicial(where);
        this.appendDataInscricaoDividaAtivaFinal(where);
        this.appendSituacaoParcela(where);
        this.appendSomenteParcelaEmAberto(where);
        this.appendParcelado(where);
        this.appendReparcelado(where);
        this.appendCidade(where);
        this.appendBairro(where);
        this.appendLogradouro(where);
        this.appendComplemento(where);
        this.appendNumero(where);
        this.appendSituacaoLegal(where);
        this.appendProtesto(where);
        this.appendAnoBase(where);
        this.appendDistritos(where);
        this.appendZonas(where);
        this.appendQuadras(where);
        this.appendLotesImobiliarios(where);
        this.appendLotesRurais(where);
        this.appendAnoCda(where);
        this.appendCda(where);
        this.appendAnoParcelamento(where);
        this.appendParcelamento(where);
        return where.toString();
    }

    public String generateJoins() {
        StringBuilder joins = new StringBuilder();
        this.appendJoinReceita(joins, Boolean.FALSE.booleanValue());
        this.appendJoinParcelamento(joins);
        this.appendJoinCda(joins);
        this.appendJoinCadastro(joins);
        return joins.toString();
    }

    public String generateJoins(boolean shouldJoinReceita) {
        StringBuilder joins = new StringBuilder();
        this.appendJoinReceita(joins, shouldJoinReceita);
        this.appendJoinParcelamento(joins);
        this.appendJoinCda(joins);
        this.appendJoinCadastro(joins);
        return joins.toString();
    }

    private void appendJoinReceita(StringBuilder joins, boolean shouldJoinReceita) {
        if (shouldJoinReceita || ConsultaDebitoTipoAgrupamento.DETALHADO.equals((Object)this.tipoAgrupamento) || ConsultaDebitoTipoAgrupamento.ANO_DIVIDA.equals((Object)this.tipoAgrupamento) || ConsultaDebitoTipoAgrupamento.SITUACAO_LEGAL_TIPO_TRIBUTO.equals((Object)this.tipoAgrupamento) || Objects.nonNull(this.tributos) && !this.tributos.isEmpty()) {
            joins.append("LEFT OUTER JOIN TRIBRECEITA RECEITA ON\n    TDPR.ENTIDADE = RECEITA.ENTIDADE AND\n    TDPR.EXERCICIO = RECEITA.EXERCICIO AND\n    TDPR.RECEITA = RECEITA.RECEITA\nLEFT OUTER JOIN TRIBRECEITATIPO RECEITATIPO ON\n    RECEITA.TIPORECEITA = RECEITATIPO.TIPORECEITA\n");
        }
    }

    private void appendJoinParcelamento(StringBuilder joins) {
        if (StringUtils.isNotBlank((CharSequence)this.parcelamento) || StringUtils.isNotBlank((CharSequence)this.anoParcelamento)) {
            joins.append("LEFT OUTER JOIN TRIBPARCELAMENTO PARCELAMENTO ON\n\tTD.IDPARCELAMENTO = PARCELAMENTO.IDPARCELAMENTO\n");
        }
    }

    private void appendJoinCda(StringBuilder joins) {
        if (StringUtils.isNotBlank((CharSequence)this.cda) || StringUtils.isNotBlank((CharSequence)this.anoCda)) {
            joins.append("LEFT OUTER JOIN TRIBDOCUMENTOITEMDIVIDAATIVA TDIDA ON\n\tTDPR.ENTIDADE = TDIDA.ENTIDADE AND\n\tTDPR.EXERCICIO = TDIDA.EXERCICIODEBITO AND\n\tTDPR.TIPOCADASTRO = TDIDA.TIPOCADASTRO AND\n\tTDPR.CADASTROGERAL = TDIDA.CADASTROGERAL AND\n\tTDPR.GUIARECOLHIMENTO =TDIDA.GUIARECOLHIMENTO AND\n\tTDPR.SUBDIVIDA = TDIDA.SUBDIVIDA AND\n\tTDPR.PARCELA = TDIDA.PARCELA AND\n    TDPR.RECEITA = TDIDA.RECEITA\nLEFT OUTER JOIN TRIBDOCUMENTO CDA ON\n\tTDIDA.ENTIDADE = CDA.ENTIDADE AND\n\tTDIDA.EXERCICIO = CDA.EXERCICIO AND\n\tTDIDA.DOCUMENTO = CDA.DOCUMENTO AND\n\tTDIDA.TIPODOCUMENTO = CDA.TIPODOCUMENTO AND\n\tCOALESCE(CDA.CANCELADO, 'N') = 'N'\n");
        }
    }

    private void appendJoinCadastro(StringBuilder joins) {
        if (ConsultaDebitoTipoAgrupamento.RESUMIDO.equals((Object)this.tipoAgrupamento) || Objects.nonNull(this.distritos) && !this.distritos.isEmpty() || Objects.nonNull(this.zonas) && !this.zonas.isEmpty() || Objects.nonNull(this.quadras) && !this.quadras.isEmpty() || Objects.nonNull(this.lotesImobiliarios) && !this.lotesImobiliarios.isEmpty() || Objects.nonNull(this.lotesRurais) && !this.lotesRurais.isEmpty()) {
            joins.append("LEFT OUTER JOIN TRIBCADASTROIMOBILIARIO TCI ON\n\tTCG.TIPOCADASTRO = TCI.TIPOCADASTRO AND\n\tTCG.CADASTROGERAL = TCI.CADASTROGERAL\nLEFT JOIN TRIBSETOR SETORIMOBILIARIO ON\n\tTCI.TRIBSETOR_IDKEY = SETORIMOBILIARIO.IDKEY\nLEFT OUTER JOIN TRIBCADASTRORURAL TCR ON\n\tTCG.TIPOCADASTRO = TCR.TIPOCADASTRO AND\n\tTCG.CADASTROGERAL = TCR.CADASTROGERAL\nLEFT JOIN TRIBSETOR SETORRURAL ON\n\tTCR.TRIBSETOR_IDKEY = SETORRURAL.IDKEY\n");
        }
    }

    private void appendCte(StringBuilder where) {
        if (this.utilizaCte()) {
            String cteWhere = ConsultaDebitoUtils.getConsultaCteWhere((ConsultaDebitoTipoAgrupamento)this.tipoAgrupamento);
            String cte = String.format("EXISTS (SELECT 1 FROM CTE %s)", cteWhere);
            where.append(this.addAND(cte));
        }
    }

    private void appendIdDebito(Long idDebito, StringBuilder where) {
        if (Objects.nonNull(idDebito)) {
            where.append(this.addAND(String.format("TD.IDDEBITO = %d", idDebito)));
        }
    }

    private void appendParcelamento(StringBuilder where) {
        if (StringUtils.isNotBlank((CharSequence)this.parcelamento)) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.parcelamento, (String)"PARCELAMENTO.NUMEROCONTRATO")));
        }
    }

    private void appendAnoParcelamento(StringBuilder where) {
        if (StringUtils.isNotBlank((CharSequence)this.anoParcelamento)) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.anoParcelamento, (String)"PARCELAMENTO.ANOCONTRATO")));
        }
    }

    private void appendCda(StringBuilder where) {
        if (StringUtils.isNotBlank((CharSequence)this.cda)) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.cda, (String)"CDA.DOCUMENTO")));
        }
    }

    private void appendAnoCda(StringBuilder where) {
        if (StringUtils.isNotBlank((CharSequence)this.anoCda)) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.anoCda, (String)"CDA.EXERCICIO")));
        }
    }

    private void appendLotesRurais(StringBuilder where) {
        if (Objects.nonNull(this.lotesRurais) && !this.lotesRurais.isEmpty()) {
            where.append(this.addAND(String.format("CASE WHEN TCG.TIPOCADASTRO = 3 THEN %s ELSE TRUE END", this.getLotesCaseRural())));
        }
    }

    private String getLotesCaseRural() {
        return String.format("(TCR.LOTE IN (%s))", this.lotesRurais.stream().map(l -> String.format("'%s'", l)).collect(Collectors.joining(", ")));
    }

    private void appendLotesImobiliarios(StringBuilder where) {
        if (Objects.nonNull(this.lotesImobiliarios) && !this.lotesImobiliarios.isEmpty()) {
            where.append(this.addAND(String.format("CASE WHEN TCG.TIPOCADASTRO = 1 THEN %s ELSE TRUE END", this.getLotesCaseImobiliario())));
        }
    }

    private String getLotesCaseImobiliario() {
        return String.format("(TCI.LOTE_INSCRICAOCADASTRAL IN (%s))", this.lotesImobiliarios.stream().map(l -> String.format("'%s'", l)).collect(Collectors.joining(", ")));
    }

    private void appendQuadras(StringBuilder where) {
        if (Objects.nonNull(this.quadras) && !this.quadras.isEmpty()) {
            where.append(this.addAND(String.format("CASE WHEN TCG.TIPOCADASTRO = 1 THEN %s ELSE TRUE END", this.getQuadrasCaseImobiliario())));
        }
    }

    private String getQuadrasCaseImobiliario() {
        return String.format("(TCI.QUADRA_INSCRICAOCADASTRAL IN (%s))", this.quadras.stream().map(q -> String.format("'%s'", q.getQuadra())).collect(Collectors.joining(", ")));
    }

    private void appendZonas(StringBuilder where) {
        if (Objects.nonNull(this.zonas) && !this.zonas.isEmpty()) {
            where.append(this.addAND(String.format("CASE WHEN TCG.TIPOCADASTRO = 1 THEN %s ELSE %s END", this.getZonasCaseImobiliario(), this.getZonasCaseRural())));
        }
    }

    private String getZonasCaseImobiliario() {
        return String.format("(TCI.TRIBSETOR_IDKEY IN (%s))", this.zonas.stream().map(z -> String.valueOf(z.getId())).collect(Collectors.joining(", ")));
    }

    private String getZonasCaseRural() {
        return String.format("(TCR.TRIBSETOR_IDKEY IN (%s))", this.zonas.stream().map(z -> String.valueOf(z.getId())).collect(Collectors.joining(", ")));
    }

    private void appendDistritos(StringBuilder where) {
        if (Objects.nonNull(this.distritos) && !this.distritos.isEmpty()) {
            where.append(this.addAND(String.format("CASE WHEN TCG.TIPOCADASTRO = 1 THEN %s ELSE %s END", this.getDistritosCaseImobiliario(), this.getDistritosCaseRural())));
        }
    }

    private String getDistritosCaseImobiliario() {
        return String.format("(TCI.DISTRITO_INSCRICAOCADASTRAL IN (%s))", this.distritos.stream().map(d -> String.format("'%s'", d.getDistrito())).collect(Collectors.joining(", ")));
    }

    private String getDistritosCaseRural() {
        return String.format("(TCR.DISTRITO IN (%s))", this.distritos.stream().map(d -> String.format("'%s'", d.getDistrito())).collect(Collectors.joining(", ")));
    }

    private void appendEntidade(StringBuilder where) {
        if (Objects.nonNull(this.entidade)) {
            where.append(this.addAND(String.format("TD.ENTIDADE = %d", this.entidade)));
        }
    }

    private void appendAnoBase(StringBuilder where) {
        if (StringUtils.isNotBlank((CharSequence)this.anoBase)) {
            where.append(this.addAND(SQL_ANO_BASE));
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.anoBase, (String)"TDP1.EXERCICIO")));
            where.append(this.addAND("TDP1.TIPOCADASTRO = TD.TIPOCADASTRO"));
            where.append(this.addAND("TDP1.CADASTROGERAL = TD.CADASTROGERAL"));
            if (StringUtils.isNotBlank((CharSequence)this.divida)) {
                where.append(this.addAND(MultiValueFilter.generateFilters((String)this.divida, (String)"TDP1.GUIARECOLHIMENTO")));
            }
            where.append(this.addAND("TTSP1.TIPO = 'A'"));
            if (Boolean.TRUE.equals(this.noExercicio) || Boolean.TRUE.equals(this.dividaAtiva) || Boolean.TRUE.equals(this.juizo)) {
                where.append(this.addAND(this.buildFiltroSituacaoLegal("TDP1")));
            }
            where.append(")");
        }
    }

    private void appendProtesto(StringBuilder where) {
        if (Objects.nonNull(this.debitosProtestados)) {
            if (COM_PROTESTO.equals(this.debitosProtestados)) {
                where.append(this.addAND("(TDP.IDPROTESTO > 0)"));
            } else if (SEM_PROTESTO.equals(this.debitosProtestados)) {
                where.append(this.addAND("(TDP.IDPROTESTO IS NULL)"));
            }
        }
    }

    private void appendSituacaoLegal(StringBuilder where) {
        if (Boolean.TRUE.equals(this.noExercicio) || Boolean.TRUE.equals(this.dividaAtiva) || Boolean.TRUE.equals(this.juizo)) {
            where.append(this.addAND(this.buildFiltroSituacaoLegal("TDP")));
        }
    }

    private void appendNumero(StringBuilder where) {
        if (StringUtils.isNotBlank((CharSequence)this.numero)) {
            where.append(this.addAND(String.format("TCG.NUMERO = '%s'", this.numero)));
        }
    }

    private void appendComplemento(StringBuilder where) {
        if (StringUtils.isNotBlank((CharSequence)this.complemento)) {
            where.append(this.addAND(String.format("TCG.COMPLEMENTO = '%s'", this.complemento)));
        }
    }

    private void appendLogradouro(StringBuilder where) {
        if (Objects.nonNull(this.logradouro)) {
            where.append(this.addAND(String.format("TCG.LOGRADOURO = %d", this.logradouro.getLogradouro())));
        }
    }

    private void appendBairro(StringBuilder where) {
        if (Objects.nonNull(this.bairro)) {
            where.append(this.addAND(String.format("TCG.BAIRRO = %d", this.bairro.getBairro())));
        }
    }

    private void appendCidade(StringBuilder where) {
        if (Objects.nonNull(this.cidade)) {
            where.append(this.addAND(String.format("TCG.CIDADE = %d", this.cidade.getId())));
        }
    }

    private void appendReparcelado(StringBuilder where) {
        if (Objects.nonNull(this.reparcelado) && !TipoFiltroBoolean.TODOS.equals((Object)this.reparcelado)) {
            where.append(this.addAND(String.format("TD.REPARCELADO = '%s'", this.reparcelado.getValue())));
        }
    }

    private void appendParcelado(StringBuilder where) {
        if (Objects.nonNull(this.parcelado) && !TipoFiltroBoolean.TODOS.equals((Object)this.parcelado)) {
            where.append(this.addAND(String.format("TD.PARCELADO = '%s'", this.parcelado.getValue())));
        }
    }

    private void appendSomenteParcelaEmAberto(StringBuilder where) {
        if (Boolean.TRUE.equals(this.somenteParcelasEmAberto)) {
            where.append(this.addAND("TTSP.TIPO = 'A'"));
        }
    }

    private void appendSituacaoParcela(StringBuilder where) {
        if (Objects.nonNull(this.tipoSituacaoParcela)) {
            where.append(this.addAND(String.format("TTSP.TIPOSITUACAOPARCELA = %d", this.tipoSituacaoParcela)));
        }
    }

    private void appendDataInscricaoDividaAtivaFinal(StringBuilder where) {
        if (Objects.nonNull(this.dataInscricaoDividaAtivaFinal)) {
            where.append(this.addAND(String.format("TDP.DATADIVIDAATIVA <= '%s'", DateUtils.localDateToString((LocalDate)this.dataInscricaoDividaAtivaFinal))));
        }
    }

    private void appendDataInscricaoDividaAtivaInicial(StringBuilder where) {
        if (Objects.nonNull(this.dataInscricaoDividaAtivaInicial)) {
            where.append(this.addAND(String.format("TDP.DATADIVIDAATIVA >= '%s'", DateUtils.localDateToString((LocalDate)this.dataInscricaoDividaAtivaInicial))));
        }
    }

    private void appendDataVencimentoFinal(StringBuilder where) {
        if (Objects.nonNull(this.dataVencimentoFinal)) {
            where.append(this.addAND(String.format("TDP.DATAVENCIMENTO <= '%s'", DateUtils.localDateToString((LocalDate)this.dataVencimentoFinal))));
        }
    }

    private void appendDataVencimentoInicial(StringBuilder where) {
        if (Objects.nonNull(this.dataVencimentoInicial)) {
            where.append(this.addAND(String.format("TDP.DATAVENCIMENTO >= '%s'", DateUtils.localDateToString((LocalDate)this.dataVencimentoInicial))));
        }
    }

    private void appendDataLancamentoFinal(StringBuilder where) {
        if (Objects.nonNull(this.dataLancamentoFinal)) {
            where.append(this.addAND(String.format("TD.DATALANCAMENTO <= '%s'", DateUtils.localDateToString((LocalDate)this.dataLancamentoFinal))));
        }
    }

    private void appendDataLancamentoInicial(StringBuilder where) {
        if (Objects.nonNull(this.dataLancamentoInicial)) {
            where.append(this.addAND(String.format("TD.DATALANCAMENTO >= '%s'", DateUtils.localDateToString((LocalDate)this.dataLancamentoInicial))));
        }
    }

    private void appendTributos(StringBuilder where) {
        if (Objects.nonNull(this.tributos) && !this.tributos.isEmpty()) {
            where.append(this.addAND(String.format("RECEITA.RECEITA IN (%s)", this.tributos.stream().map(t -> String.format("'%s'", t.getTributo())).collect(Collectors.joining(", ")))));
        }
    }

    private void appendParcela(StringBuilder where) {
        if (StringUtils.isNotBlank((CharSequence)this.parcela)) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.parcela, (String)"TDP.PARCELA")));
        }
    }

    private void appendSubDivida(StringBuilder where) {
        if (StringUtils.isNotBlank((CharSequence)this.subDivida)) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.subDivida, (String)"TD.SUBDIVIDA")));
        }
    }

    private void appendDivida(StringBuilder where) {
        if (StringUtils.isNotBlank((CharSequence)this.divida)) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.divida, (String)"TD.GUIARECOLHIMENTO")));
        }
    }

    private void appendAnoDebito(StringBuilder where) {
        if (StringUtils.isNotBlank((CharSequence)this.anoDebito)) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.anoDebito, (String)"TD.EXERCICIO")));
        }
    }

    private void appendCadastroGeral(StringBuilder where) {
        if (StringUtils.isNotBlank((CharSequence)this.cadastroGeral)) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.cadastroGeral, (String)"TD.CADASTROGERAL")));
        }
    }

    private void appendTipoCadastro(StringBuilder where) {
        if (Objects.nonNull(this.tiposCadastros) && !this.tiposCadastros.isEmpty()) {
            where.append(this.addAND(String.format("TD.TIPOCADASTRO IN (%s)", this.tiposCadastros.stream().map(TipoCadastro::getValue).map(String::valueOf).collect(Collectors.joining(", ")))));
        }
    }

    private void appendPessoaWithMultiValue(StringBuilder where) {
        if (StringUtils.isNotBlank((CharSequence)this.pessoaRange)) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.pessoaRange, (String)"P.PESSOA")));
        }
    }

    private void appendPessoa(StringBuilder where) {
        if (Objects.nonNull(this.pessoa)) {
            where.append(this.addAND(String.format("P.PESSOA = %d", this.pessoa.getId())));
        }
    }

    private void appendTipoPessoa(StringBuilder where) {
        if (ConsultaDebitoTipoAgrupamento.SALDO_ANALITICO_CONTRIBUINTE_PRIMEIRA_CARGA.equals((Object)this.tipoAgrupamento)) {
            where.append(this.addAND(String.format("P.TIPOPESSOA = '%s'", TipoPessoa.JURIDICA.getValue())));
        }
    }

    private String buildFiltroSituacaoLegal(String tableAlias) {
        StringBuilder situacaoLegal = new StringBuilder();
        situacaoLegal.append(tableAlias).append(".SITUACAOLEGAL IN (");
        this.appendNoExercicio(situacaoLegal);
        this.appendDividaAtiva(situacaoLegal);
        this.appendJuizo(situacaoLegal);
        if (situacaoLegal.toString().endsWith(", ")) {
            situacaoLegal.append(")");
            return situacaoLegal.toString().replace(", )", ")");
        }
        situacaoLegal.append(")");
        return situacaoLegal.toString();
    }

    private void appendJuizo(StringBuilder situacaoLegal) {
        if (Boolean.TRUE.equals(this.juizo)) {
            situacaoLegal.append(SituacaoLegal.JUIZO.getValue().toString());
        }
    }

    private void appendDividaAtiva(StringBuilder situacaoLegal) {
        if (Boolean.TRUE.equals(this.dividaAtiva)) {
            situacaoLegal.append(SituacaoLegal.DIVIDA_ATIVA.getValue().toString()).append(", ");
        }
    }

    private void appendNoExercicio(StringBuilder situacaoLegal) {
        if (Boolean.TRUE.equals(this.noExercicio)) {
            situacaoLegal.append(SituacaoLegal.NO_EXERCICIO.getValue().toString()).append(", ");
        }
    }

    public String buildGroupBy() {
        return " GROUP BY IDDEBITO";
    }

    public String buildCteGroupBy() {
        String groupBy = ConsultaDebitoUtils.getConsultaGroupBy((ConsultaDebitoTipoAgrupamento)this.tipoAgrupamento);
        return String.format(" %s %s ", groupBy, this.buildHaving());
    }

    public String buildCte(String fromTemplate) {
        String select = ConsultaDebitoUtils.getConsultaCteSelect((ConsultaDebitoTipoAgrupamento)this.tipoAgrupamento);
        String query = String.format(fromTemplate, select, this.generateJoins(), this.generateWhere(), this.buildCteGroupBy());
        return String.format(" WITH CTE AS ( %s ) ", query);
    }

    public boolean utilizaCte() {
        return this.utilizaValorMinimo() || this.utilizaValorMaximo() || this.utilizaQtdParcelasVencidas();
    }

    public String buildHaving() {
        StringBuilder having = new StringBuilder();
        this.appendHavingQtdParcelasVencidas(having);
        this.appendHavingValorMinimo(having);
        this.appendHavingValorMaximo(having);
        return having.toString();
    }

    private void appendHavingValorMaximo(StringBuilder having) {
        if (this.utilizaValorMaximo()) {
            this.addHavingCondition(having, " SUM(TDPR.VALOR) <= %s ", this.valorMaximo.toString());
        }
    }

    private void appendHavingValorMinimo(StringBuilder having) {
        if (this.utilizaValorMinimo()) {
            this.addHavingCondition(having, " SUM(TDPR.VALOR) >= %s ", this.valorMinimo.toString());
        }
    }

    private void appendHavingQtdParcelasVencidas(StringBuilder having) {
        if (this.utilizaQtdParcelasVencidas()) {
            this.addHavingCondition(having, " COUNT(CASE WHEN TDP.datavencimento > CURRENT_DATE THEN 1 END) = %s ", this.qtdParcelasVencidas.toString());
        }
    }

    private void addHavingCondition(StringBuilder having, String conditionTemplate, String value) {
        if (!having.isEmpty()) {
            having.append(" AND ");
        } else {
            having.append("HAVING ");
        }
        having.append(String.format(conditionTemplate, value));
    }

    private boolean utilizaValorMinimo() {
        return Objects.nonNull(this.valorMinimo) && BigDecimal.ZERO.compareTo(this.valorMinimo) < 0;
    }

    private boolean utilizaValorMaximo() {
        return Objects.nonNull(this.valorMaximo) && BigDecimal.ZERO.compareTo(this.valorMaximo) < 0;
    }

    private boolean utilizaQtdParcelasVencidas() {
        return Objects.nonNull(this.qtdParcelasVencidas) && this.qtdParcelasVencidas > 0L;
    }

    @Generated
    public FiltroConsultaDebitoDTO() {
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    @Generated
    public List<TipoCadastro> getTiposCadastros() {
        return this.tiposCadastros;
    }

    @Generated
    public String getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getAnoDebito() {
        return this.anoDebito;
    }

    @Generated
    public String getDivida() {
        return this.divida;
    }

    @Generated
    public String getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public LocalDate getDataLancamentoInicial() {
        return this.dataLancamentoInicial;
    }

    @Generated
    public LocalDate getDataLancamentoFinal() {
        return this.dataLancamentoFinal;
    }

    @Generated
    public LocalDate getDataVencimentoInicial() {
        return this.dataVencimentoInicial;
    }

    @Generated
    public LocalDate getDataVencimentoFinal() {
        return this.dataVencimentoFinal;
    }

    @Generated
    public LocalDate getDataInscricaoDividaAtivaInicial() {
        return this.dataInscricaoDividaAtivaInicial;
    }

    @Generated
    public LocalDate getDataInscricaoDividaAtivaFinal() {
        return this.dataInscricaoDividaAtivaFinal;
    }

    @Generated
    public Boolean getNoExercicio() {
        return this.noExercicio;
    }

    @Generated
    public Boolean getDividaAtiva() {
        return this.dividaAtiva;
    }

    @Generated
    public Boolean getJuizo() {
        return this.juizo;
    }

    @Generated
    public Long getTipoSituacaoParcela() {
        return this.tipoSituacaoParcela;
    }

    @Generated
    public Boolean getSomenteParcelasEmAberto() {
        return this.somenteParcelasEmAberto;
    }

    @Generated
    public Boolean getCalcularAcrescimos() {
        return this.calcularAcrescimos;
    }

    @Generated
    public LocalDate getDataReferencia() {
        return this.dataReferencia;
    }

    @Generated
    public Long getQtdParcelasVencidas() {
        return this.qtdParcelasVencidas;
    }

    @Generated
    public BigDecimal getValorMinimo() {
        return this.valorMinimo;
    }

    @Generated
    public BigDecimal getValorMaximo() {
        return this.valorMaximo;
    }

    @Generated
    public Cidade getCidade() {
        return this.cidade;
    }

    @Generated
    public Bairro getBairro() {
        return this.bairro;
    }

    @Generated
    public Logradouro getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public String getComplemento() {
        return this.complemento;
    }

    @Generated
    public String getNumero() {
        return this.numero;
    }

    @Generated
    public String getPessoaRange() {
        return this.pessoaRange;
    }

    @Generated
    public String getParcela() {
        return this.parcela;
    }

    @Generated
    public TipoFiltroBoolean getParcelado() {
        return this.parcelado;
    }

    @Generated
    public TipoFiltroBoolean getReparcelado() {
        return this.reparcelado;
    }

    @Generated
    public Long getDebitosProtestados() {
        return this.debitosProtestados;
    }

    @Generated
    public String getAnoBase() {
        return this.anoBase;
    }

    @Generated
    public List<TributoDTO> getTributos() {
        return this.tributos;
    }

    @Generated
    public List<DistritoDTO> getDistritos() {
        return this.distritos;
    }

    @Generated
    public List<SetorDTO> getZonas() {
        return this.zonas;
    }

    @Generated
    public List<SetorQuadraDTO> getQuadras() {
        return this.quadras;
    }

    @Generated
    public List<String> getLotesImobiliarios() {
        return this.lotesImobiliarios;
    }

    @Generated
    public List<String> getLotesRurais() {
        return this.lotesRurais;
    }

    @Generated
    public String getAnoCda() {
        return this.anoCda;
    }

    @Generated
    public String getCda() {
        return this.cda;
    }

    @Generated
    public String getAnoParcelamento() {
        return this.anoParcelamento;
    }

    @Generated
    public String getParcelamento() {
        return this.parcelamento;
    }

    @Generated
    public ConsultaDebitoTipoAgrupamento getTipoAgrupamento() {
        return this.tipoAgrupamento;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setTiposCadastros(List<TipoCadastro> tiposCadastros) {
        this.tiposCadastros = tiposCadastros;
    }

    @Generated
    public void setCadastroGeral(String cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setAnoDebito(String anoDebito) {
        this.anoDebito = anoDebito;
    }

    @Generated
    public void setDivida(String divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(String subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setDataLancamentoInicial(LocalDate dataLancamentoInicial) {
        this.dataLancamentoInicial = dataLancamentoInicial;
    }

    @Generated
    public void setDataLancamentoFinal(LocalDate dataLancamentoFinal) {
        this.dataLancamentoFinal = dataLancamentoFinal;
    }

    @Generated
    public void setDataVencimentoInicial(LocalDate dataVencimentoInicial) {
        this.dataVencimentoInicial = dataVencimentoInicial;
    }

    @Generated
    public void setDataVencimentoFinal(LocalDate dataVencimentoFinal) {
        this.dataVencimentoFinal = dataVencimentoFinal;
    }

    @Generated
    public void setDataInscricaoDividaAtivaInicial(LocalDate dataInscricaoDividaAtivaInicial) {
        this.dataInscricaoDividaAtivaInicial = dataInscricaoDividaAtivaInicial;
    }

    @Generated
    public void setDataInscricaoDividaAtivaFinal(LocalDate dataInscricaoDividaAtivaFinal) {
        this.dataInscricaoDividaAtivaFinal = dataInscricaoDividaAtivaFinal;
    }

    @Generated
    public void setNoExercicio(Boolean noExercicio) {
        this.noExercicio = noExercicio;
    }

    @Generated
    public void setDividaAtiva(Boolean dividaAtiva) {
        this.dividaAtiva = dividaAtiva;
    }

    @Generated
    public void setJuizo(Boolean juizo) {
        this.juizo = juizo;
    }

    @Generated
    public void setTipoSituacaoParcela(Long tipoSituacaoParcela) {
        this.tipoSituacaoParcela = tipoSituacaoParcela;
    }

    @Generated
    public void setSomenteParcelasEmAberto(Boolean somenteParcelasEmAberto) {
        this.somenteParcelasEmAberto = somenteParcelasEmAberto;
    }

    @Generated
    public void setCalcularAcrescimos(Boolean calcularAcrescimos) {
        this.calcularAcrescimos = calcularAcrescimos;
    }

    @Generated
    public void setDataReferencia(LocalDate dataReferencia) {
        this.dataReferencia = dataReferencia;
    }

    @Generated
    public void setQtdParcelasVencidas(Long qtdParcelasVencidas) {
        this.qtdParcelasVencidas = qtdParcelasVencidas;
    }

    @Generated
    public void setValorMinimo(BigDecimal valorMinimo) {
        this.valorMinimo = valorMinimo;
    }

    @Generated
    public void setValorMaximo(BigDecimal valorMaximo) {
        this.valorMaximo = valorMaximo;
    }

    @Generated
    public void setCidade(Cidade cidade) {
        this.cidade = cidade;
    }

    @Generated
    public void setBairro(Bairro bairro) {
        this.bairro = bairro;
    }

    @Generated
    public void setLogradouro(Logradouro logradouro) {
        this.logradouro = logradouro;
    }

    @Generated
    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    @Generated
    public void setNumero(String numero) {
        this.numero = numero;
    }

    @Generated
    public void setPessoaRange(String pessoaRange) {
        this.pessoaRange = pessoaRange;
    }

    @Generated
    public void setParcela(String parcela) {
        this.parcela = parcela;
    }

    @Generated
    public void setParcelado(TipoFiltroBoolean parcelado) {
        this.parcelado = parcelado;
    }

    @Generated
    public void setReparcelado(TipoFiltroBoolean reparcelado) {
        this.reparcelado = reparcelado;
    }

    @Generated
    public void setDebitosProtestados(Long debitosProtestados) {
        this.debitosProtestados = debitosProtestados;
    }

    @Generated
    public void setAnoBase(String anoBase) {
        this.anoBase = anoBase;
    }

    @Generated
    public void setTributos(List<TributoDTO> tributos) {
        this.tributos = tributos;
    }

    @Generated
    public void setDistritos(List<DistritoDTO> distritos) {
        this.distritos = distritos;
    }

    @Generated
    public void setZonas(List<SetorDTO> zonas) {
        this.zonas = zonas;
    }

    @Generated
    public void setQuadras(List<SetorQuadraDTO> quadras) {
        this.quadras = quadras;
    }

    @Generated
    public void setLotesImobiliarios(List<String> lotesImobiliarios) {
        this.lotesImobiliarios = lotesImobiliarios;
    }

    @Generated
    public void setLotesRurais(List<String> lotesRurais) {
        this.lotesRurais = lotesRurais;
    }

    @Generated
    public void setAnoCda(String anoCda) {
        this.anoCda = anoCda;
    }

    @Generated
    public void setCda(String cda) {
        this.cda = cda;
    }

    @Generated
    public void setAnoParcelamento(String anoParcelamento) {
        this.anoParcelamento = anoParcelamento;
    }

    @Generated
    public void setParcelamento(String parcelamento) {
        this.parcelamento = parcelamento;
    }

    @Generated
    public void setTipoAgrupamento(ConsultaDebitoTipoAgrupamento tipoAgrupamento) {
        this.tipoAgrupamento = tipoAgrupamento;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiltroConsultaDebitoDTO)) {
            return false;
        }
        FiltroConsultaDebitoDTO other = (FiltroConsultaDebitoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Boolean this$noExercicio = this.getNoExercicio();
        Boolean other$noExercicio = other.getNoExercicio();
        if (this$noExercicio == null ? other$noExercicio != null : !((Object)this$noExercicio).equals(other$noExercicio)) {
            return false;
        }
        Boolean this$dividaAtiva = this.getDividaAtiva();
        Boolean other$dividaAtiva = other.getDividaAtiva();
        if (this$dividaAtiva == null ? other$dividaAtiva != null : !((Object)this$dividaAtiva).equals(other$dividaAtiva)) {
            return false;
        }
        Boolean this$juizo = this.getJuizo();
        Boolean other$juizo = other.getJuizo();
        if (this$juizo == null ? other$juizo != null : !((Object)this$juizo).equals(other$juizo)) {
            return false;
        }
        Long this$tipoSituacaoParcela = this.getTipoSituacaoParcela();
        Long other$tipoSituacaoParcela = other.getTipoSituacaoParcela();
        if (this$tipoSituacaoParcela == null ? other$tipoSituacaoParcela != null : !((Object)this$tipoSituacaoParcela).equals(other$tipoSituacaoParcela)) {
            return false;
        }
        Boolean this$somenteParcelasEmAberto = this.getSomenteParcelasEmAberto();
        Boolean other$somenteParcelasEmAberto = other.getSomenteParcelasEmAberto();
        if (this$somenteParcelasEmAberto == null ? other$somenteParcelasEmAberto != null : !((Object)this$somenteParcelasEmAberto).equals(other$somenteParcelasEmAberto)) {
            return false;
        }
        Boolean this$calcularAcrescimos = this.getCalcularAcrescimos();
        Boolean other$calcularAcrescimos = other.getCalcularAcrescimos();
        if (this$calcularAcrescimos == null ? other$calcularAcrescimos != null : !((Object)this$calcularAcrescimos).equals(other$calcularAcrescimos)) {
            return false;
        }
        Long this$qtdParcelasVencidas = this.getQtdParcelasVencidas();
        Long other$qtdParcelasVencidas = other.getQtdParcelasVencidas();
        if (this$qtdParcelasVencidas == null ? other$qtdParcelasVencidas != null : !((Object)this$qtdParcelasVencidas).equals(other$qtdParcelasVencidas)) {
            return false;
        }
        Long this$debitosProtestados = this.getDebitosProtestados();
        Long other$debitosProtestados = other.getDebitosProtestados();
        if (this$debitosProtestados == null ? other$debitosProtestados != null : !((Object)this$debitosProtestados).equals(other$debitosProtestados)) {
            return false;
        }
        Pessoa this$pessoa = this.getPessoa();
        Pessoa other$pessoa = other.getPessoa();
        if (this$pessoa == null ? other$pessoa != null : !this$pessoa.equals(other$pessoa)) {
            return false;
        }
        List this$tiposCadastros = this.getTiposCadastros();
        List other$tiposCadastros = other.getTiposCadastros();
        if (this$tiposCadastros == null ? other$tiposCadastros != null : !((Object)this$tiposCadastros).equals(other$tiposCadastros)) {
            return false;
        }
        String this$cadastroGeral = this.getCadastroGeral();
        String other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        String this$anoDebito = this.getAnoDebito();
        String other$anoDebito = other.getAnoDebito();
        if (this$anoDebito == null ? other$anoDebito != null : !this$anoDebito.equals(other$anoDebito)) {
            return false;
        }
        String this$divida = this.getDivida();
        String other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !this$divida.equals(other$divida)) {
            return false;
        }
        String this$subDivida = this.getSubDivida();
        String other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !this$subDivida.equals(other$subDivida)) {
            return false;
        }
        LocalDate this$dataLancamentoInicial = this.getDataLancamentoInicial();
        LocalDate other$dataLancamentoInicial = other.getDataLancamentoInicial();
        if (this$dataLancamentoInicial == null ? other$dataLancamentoInicial != null : !((Object)this$dataLancamentoInicial).equals(other$dataLancamentoInicial)) {
            return false;
        }
        LocalDate this$dataLancamentoFinal = this.getDataLancamentoFinal();
        LocalDate other$dataLancamentoFinal = other.getDataLancamentoFinal();
        if (this$dataLancamentoFinal == null ? other$dataLancamentoFinal != null : !((Object)this$dataLancamentoFinal).equals(other$dataLancamentoFinal)) {
            return false;
        }
        LocalDate this$dataVencimentoInicial = this.getDataVencimentoInicial();
        LocalDate other$dataVencimentoInicial = other.getDataVencimentoInicial();
        if (this$dataVencimentoInicial == null ? other$dataVencimentoInicial != null : !((Object)this$dataVencimentoInicial).equals(other$dataVencimentoInicial)) {
            return false;
        }
        LocalDate this$dataVencimentoFinal = this.getDataVencimentoFinal();
        LocalDate other$dataVencimentoFinal = other.getDataVencimentoFinal();
        if (this$dataVencimentoFinal == null ? other$dataVencimentoFinal != null : !((Object)this$dataVencimentoFinal).equals(other$dataVencimentoFinal)) {
            return false;
        }
        LocalDate this$dataInscricaoDividaAtivaInicial = this.getDataInscricaoDividaAtivaInicial();
        LocalDate other$dataInscricaoDividaAtivaInicial = other.getDataInscricaoDividaAtivaInicial();
        if (this$dataInscricaoDividaAtivaInicial == null ? other$dataInscricaoDividaAtivaInicial != null : !((Object)this$dataInscricaoDividaAtivaInicial).equals(other$dataInscricaoDividaAtivaInicial)) {
            return false;
        }
        LocalDate this$dataInscricaoDividaAtivaFinal = this.getDataInscricaoDividaAtivaFinal();
        LocalDate other$dataInscricaoDividaAtivaFinal = other.getDataInscricaoDividaAtivaFinal();
        if (this$dataInscricaoDividaAtivaFinal == null ? other$dataInscricaoDividaAtivaFinal != null : !((Object)this$dataInscricaoDividaAtivaFinal).equals(other$dataInscricaoDividaAtivaFinal)) {
            return false;
        }
        LocalDate this$dataReferencia = this.getDataReferencia();
        LocalDate other$dataReferencia = other.getDataReferencia();
        if (this$dataReferencia == null ? other$dataReferencia != null : !((Object)this$dataReferencia).equals(other$dataReferencia)) {
            return false;
        }
        BigDecimal this$valorMinimo = this.getValorMinimo();
        BigDecimal other$valorMinimo = other.getValorMinimo();
        if (this$valorMinimo == null ? other$valorMinimo != null : !((Object)this$valorMinimo).equals(other$valorMinimo)) {
            return false;
        }
        BigDecimal this$valorMaximo = this.getValorMaximo();
        BigDecimal other$valorMaximo = other.getValorMaximo();
        if (this$valorMaximo == null ? other$valorMaximo != null : !((Object)this$valorMaximo).equals(other$valorMaximo)) {
            return false;
        }
        Cidade this$cidade = this.getCidade();
        Cidade other$cidade = other.getCidade();
        if (this$cidade == null ? other$cidade != null : !this$cidade.equals(other$cidade)) {
            return false;
        }
        Bairro this$bairro = this.getBairro();
        Bairro other$bairro = other.getBairro();
        if (this$bairro == null ? other$bairro != null : !this$bairro.equals(other$bairro)) {
            return false;
        }
        Logradouro this$logradouro = this.getLogradouro();
        Logradouro other$logradouro = other.getLogradouro();
        if (this$logradouro == null ? other$logradouro != null : !this$logradouro.equals(other$logradouro)) {
            return false;
        }
        String this$complemento = this.getComplemento();
        String other$complemento = other.getComplemento();
        if (this$complemento == null ? other$complemento != null : !this$complemento.equals(other$complemento)) {
            return false;
        }
        String this$numero = this.getNumero();
        String other$numero = other.getNumero();
        if (this$numero == null ? other$numero != null : !this$numero.equals(other$numero)) {
            return false;
        }
        String this$pessoaRange = this.getPessoaRange();
        String other$pessoaRange = other.getPessoaRange();
        if (this$pessoaRange == null ? other$pessoaRange != null : !this$pessoaRange.equals(other$pessoaRange)) {
            return false;
        }
        String this$parcela = this.getParcela();
        String other$parcela = other.getParcela();
        if (this$parcela == null ? other$parcela != null : !this$parcela.equals(other$parcela)) {
            return false;
        }
        TipoFiltroBoolean this$parcelado = this.getParcelado();
        TipoFiltroBoolean other$parcelado = other.getParcelado();
        if (this$parcelado == null ? other$parcelado != null : !this$parcelado.equals(other$parcelado)) {
            return false;
        }
        TipoFiltroBoolean this$reparcelado = this.getReparcelado();
        TipoFiltroBoolean other$reparcelado = other.getReparcelado();
        if (this$reparcelado == null ? other$reparcelado != null : !this$reparcelado.equals(other$reparcelado)) {
            return false;
        }
        String this$anoBase = this.getAnoBase();
        String other$anoBase = other.getAnoBase();
        if (this$anoBase == null ? other$anoBase != null : !this$anoBase.equals(other$anoBase)) {
            return false;
        }
        List this$tributos = this.getTributos();
        List other$tributos = other.getTributos();
        if (this$tributos == null ? other$tributos != null : !((Object)this$tributos).equals(other$tributos)) {
            return false;
        }
        List this$distritos = this.getDistritos();
        List other$distritos = other.getDistritos();
        if (this$distritos == null ? other$distritos != null : !((Object)this$distritos).equals(other$distritos)) {
            return false;
        }
        List this$zonas = this.getZonas();
        List other$zonas = other.getZonas();
        if (this$zonas == null ? other$zonas != null : !((Object)this$zonas).equals(other$zonas)) {
            return false;
        }
        List this$quadras = this.getQuadras();
        List other$quadras = other.getQuadras();
        if (this$quadras == null ? other$quadras != null : !((Object)this$quadras).equals(other$quadras)) {
            return false;
        }
        List this$lotesImobiliarios = this.getLotesImobiliarios();
        List other$lotesImobiliarios = other.getLotesImobiliarios();
        if (this$lotesImobiliarios == null ? other$lotesImobiliarios != null : !((Object)this$lotesImobiliarios).equals(other$lotesImobiliarios)) {
            return false;
        }
        List this$lotesRurais = this.getLotesRurais();
        List other$lotesRurais = other.getLotesRurais();
        if (this$lotesRurais == null ? other$lotesRurais != null : !((Object)this$lotesRurais).equals(other$lotesRurais)) {
            return false;
        }
        String this$anoCda = this.getAnoCda();
        String other$anoCda = other.getAnoCda();
        if (this$anoCda == null ? other$anoCda != null : !this$anoCda.equals(other$anoCda)) {
            return false;
        }
        String this$cda = this.getCda();
        String other$cda = other.getCda();
        if (this$cda == null ? other$cda != null : !this$cda.equals(other$cda)) {
            return false;
        }
        String this$anoParcelamento = this.getAnoParcelamento();
        String other$anoParcelamento = other.getAnoParcelamento();
        if (this$anoParcelamento == null ? other$anoParcelamento != null : !this$anoParcelamento.equals(other$anoParcelamento)) {
            return false;
        }
        String this$parcelamento = this.getParcelamento();
        String other$parcelamento = other.getParcelamento();
        if (this$parcelamento == null ? other$parcelamento != null : !this$parcelamento.equals(other$parcelamento)) {
            return false;
        }
        ConsultaDebitoTipoAgrupamento this$tipoAgrupamento = this.getTipoAgrupamento();
        ConsultaDebitoTipoAgrupamento other$tipoAgrupamento = other.getTipoAgrupamento();
        return !(this$tipoAgrupamento == null ? other$tipoAgrupamento != null : !this$tipoAgrupamento.equals(other$tipoAgrupamento));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FiltroConsultaDebitoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Boolean $noExercicio = this.getNoExercicio();
        result = result * 59 + ($noExercicio == null ? 43 : ((Object)$noExercicio).hashCode());
        Boolean $dividaAtiva = this.getDividaAtiva();
        result = result * 59 + ($dividaAtiva == null ? 43 : ((Object)$dividaAtiva).hashCode());
        Boolean $juizo = this.getJuizo();
        result = result * 59 + ($juizo == null ? 43 : ((Object)$juizo).hashCode());
        Long $tipoSituacaoParcela = this.getTipoSituacaoParcela();
        result = result * 59 + ($tipoSituacaoParcela == null ? 43 : ((Object)$tipoSituacaoParcela).hashCode());
        Boolean $somenteParcelasEmAberto = this.getSomenteParcelasEmAberto();
        result = result * 59 + ($somenteParcelasEmAberto == null ? 43 : ((Object)$somenteParcelasEmAberto).hashCode());
        Boolean $calcularAcrescimos = this.getCalcularAcrescimos();
        result = result * 59 + ($calcularAcrescimos == null ? 43 : ((Object)$calcularAcrescimos).hashCode());
        Long $qtdParcelasVencidas = this.getQtdParcelasVencidas();
        result = result * 59 + ($qtdParcelasVencidas == null ? 43 : ((Object)$qtdParcelasVencidas).hashCode());
        Long $debitosProtestados = this.getDebitosProtestados();
        result = result * 59 + ($debitosProtestados == null ? 43 : ((Object)$debitosProtestados).hashCode());
        Pessoa $pessoa = this.getPessoa();
        result = result * 59 + ($pessoa == null ? 43 : $pessoa.hashCode());
        List $tiposCadastros = this.getTiposCadastros();
        result = result * 59 + ($tiposCadastros == null ? 43 : ((Object)$tiposCadastros).hashCode());
        String $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        String $anoDebito = this.getAnoDebito();
        result = result * 59 + ($anoDebito == null ? 43 : $anoDebito.hashCode());
        String $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : $divida.hashCode());
        String $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : $subDivida.hashCode());
        LocalDate $dataLancamentoInicial = this.getDataLancamentoInicial();
        result = result * 59 + ($dataLancamentoInicial == null ? 43 : ((Object)$dataLancamentoInicial).hashCode());
        LocalDate $dataLancamentoFinal = this.getDataLancamentoFinal();
        result = result * 59 + ($dataLancamentoFinal == null ? 43 : ((Object)$dataLancamentoFinal).hashCode());
        LocalDate $dataVencimentoInicial = this.getDataVencimentoInicial();
        result = result * 59 + ($dataVencimentoInicial == null ? 43 : ((Object)$dataVencimentoInicial).hashCode());
        LocalDate $dataVencimentoFinal = this.getDataVencimentoFinal();
        result = result * 59 + ($dataVencimentoFinal == null ? 43 : ((Object)$dataVencimentoFinal).hashCode());
        LocalDate $dataInscricaoDividaAtivaInicial = this.getDataInscricaoDividaAtivaInicial();
        result = result * 59 + ($dataInscricaoDividaAtivaInicial == null ? 43 : ((Object)$dataInscricaoDividaAtivaInicial).hashCode());
        LocalDate $dataInscricaoDividaAtivaFinal = this.getDataInscricaoDividaAtivaFinal();
        result = result * 59 + ($dataInscricaoDividaAtivaFinal == null ? 43 : ((Object)$dataInscricaoDividaAtivaFinal).hashCode());
        LocalDate $dataReferencia = this.getDataReferencia();
        result = result * 59 + ($dataReferencia == null ? 43 : ((Object)$dataReferencia).hashCode());
        BigDecimal $valorMinimo = this.getValorMinimo();
        result = result * 59 + ($valorMinimo == null ? 43 : ((Object)$valorMinimo).hashCode());
        BigDecimal $valorMaximo = this.getValorMaximo();
        result = result * 59 + ($valorMaximo == null ? 43 : ((Object)$valorMaximo).hashCode());
        Cidade $cidade = this.getCidade();
        result = result * 59 + ($cidade == null ? 43 : $cidade.hashCode());
        Bairro $bairro = this.getBairro();
        result = result * 59 + ($bairro == null ? 43 : $bairro.hashCode());
        Logradouro $logradouro = this.getLogradouro();
        result = result * 59 + ($logradouro == null ? 43 : $logradouro.hashCode());
        String $complemento = this.getComplemento();
        result = result * 59 + ($complemento == null ? 43 : $complemento.hashCode());
        String $numero = this.getNumero();
        result = result * 59 + ($numero == null ? 43 : $numero.hashCode());
        String $pessoaRange = this.getPessoaRange();
        result = result * 59 + ($pessoaRange == null ? 43 : $pessoaRange.hashCode());
        String $parcela = this.getParcela();
        result = result * 59 + ($parcela == null ? 43 : $parcela.hashCode());
        TipoFiltroBoolean $parcelado = this.getParcelado();
        result = result * 59 + ($parcelado == null ? 43 : $parcelado.hashCode());
        TipoFiltroBoolean $reparcelado = this.getReparcelado();
        result = result * 59 + ($reparcelado == null ? 43 : $reparcelado.hashCode());
        String $anoBase = this.getAnoBase();
        result = result * 59 + ($anoBase == null ? 43 : $anoBase.hashCode());
        List $tributos = this.getTributos();
        result = result * 59 + ($tributos == null ? 43 : ((Object)$tributos).hashCode());
        List $distritos = this.getDistritos();
        result = result * 59 + ($distritos == null ? 43 : ((Object)$distritos).hashCode());
        List $zonas = this.getZonas();
        result = result * 59 + ($zonas == null ? 43 : ((Object)$zonas).hashCode());
        List $quadras = this.getQuadras();
        result = result * 59 + ($quadras == null ? 43 : ((Object)$quadras).hashCode());
        List $lotesImobiliarios = this.getLotesImobiliarios();
        result = result * 59 + ($lotesImobiliarios == null ? 43 : ((Object)$lotesImobiliarios).hashCode());
        List $lotesRurais = this.getLotesRurais();
        result = result * 59 + ($lotesRurais == null ? 43 : ((Object)$lotesRurais).hashCode());
        String $anoCda = this.getAnoCda();
        result = result * 59 + ($anoCda == null ? 43 : $anoCda.hashCode());
        String $cda = this.getCda();
        result = result * 59 + ($cda == null ? 43 : $cda.hashCode());
        String $anoParcelamento = this.getAnoParcelamento();
        result = result * 59 + ($anoParcelamento == null ? 43 : $anoParcelamento.hashCode());
        String $parcelamento = this.getParcelamento();
        result = result * 59 + ($parcelamento == null ? 43 : $parcelamento.hashCode());
        ConsultaDebitoTipoAgrupamento $tipoAgrupamento = this.getTipoAgrupamento();
        result = result * 59 + ($tipoAgrupamento == null ? 43 : $tipoAgrupamento.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FiltroConsultaDebitoDTO(entidade=" + this.getEntidade() + ", pessoa=" + String.valueOf(this.getPessoa()) + ", tiposCadastros=" + String.valueOf(this.getTiposCadastros()) + ", cadastroGeral=" + this.getCadastroGeral() + ", anoDebito=" + this.getAnoDebito() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ", dataLancamentoInicial=" + String.valueOf(this.getDataLancamentoInicial()) + ", dataLancamentoFinal=" + String.valueOf(this.getDataLancamentoFinal()) + ", dataVencimentoInicial=" + String.valueOf(this.getDataVencimentoInicial()) + ", dataVencimentoFinal=" + String.valueOf(this.getDataVencimentoFinal()) + ", dataInscricaoDividaAtivaInicial=" + String.valueOf(this.getDataInscricaoDividaAtivaInicial()) + ", dataInscricaoDividaAtivaFinal=" + String.valueOf(this.getDataInscricaoDividaAtivaFinal()) + ", noExercicio=" + this.getNoExercicio() + ", dividaAtiva=" + this.getDividaAtiva() + ", juizo=" + this.getJuizo() + ", tipoSituacaoParcela=" + this.getTipoSituacaoParcela() + ", somenteParcelasEmAberto=" + this.getSomenteParcelasEmAberto() + ", calcularAcrescimos=" + this.getCalcularAcrescimos() + ", dataReferencia=" + String.valueOf(this.getDataReferencia()) + ", qtdParcelasVencidas=" + this.getQtdParcelasVencidas() + ", valorMinimo=" + String.valueOf(this.getValorMinimo()) + ", valorMaximo=" + String.valueOf(this.getValorMaximo()) + ", cidade=" + String.valueOf(this.getCidade()) + ", bairro=" + String.valueOf(this.getBairro()) + ", logradouro=" + String.valueOf(this.getLogradouro()) + ", complemento=" + this.getComplemento() + ", numero=" + this.getNumero() + ", pessoaRange=" + this.getPessoaRange() + ", parcela=" + this.getParcela() + ", parcelado=" + String.valueOf(this.getParcelado()) + ", reparcelado=" + String.valueOf(this.getReparcelado()) + ", debitosProtestados=" + this.getDebitosProtestados() + ", anoBase=" + this.getAnoBase() + ", tributos=" + String.valueOf(this.getTributos()) + ", distritos=" + String.valueOf(this.getDistritos()) + ", zonas=" + String.valueOf(this.getZonas()) + ", quadras=" + String.valueOf(this.getQuadras()) + ", lotesImobiliarios=" + String.valueOf(this.getLotesImobiliarios()) + ", lotesRurais=" + String.valueOf(this.getLotesRurais()) + ", anoCda=" + this.getAnoCda() + ", cda=" + this.getCda() + ", anoParcelamento=" + this.getAnoParcelamento() + ", parcelamento=" + this.getParcelamento() + ", tipoAgrupamento=" + String.valueOf(this.getTipoAgrupamento()) + ")";
    }
}

