/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.util.MultiValueFilter;
import java.io.Serializable;
import java.util.Objects;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class FiltroConsultaCarneDTO
implements Serializable {
    @Min(message="Informe um n\u00famero de entidade v\u00e1lido", value=1L)
    @NotNull(message="C\u00f3digo da Entidade \u00e9 obrigat\u00f3rio")
    private @Min(message="Informe um n\u00famero de entidade v\u00e1lido", value=1L) @NotNull(message="C\u00f3digo da Entidade \u00e9 obrigat\u00f3rio") Long entidade;
    private String carne;
    private String exercicioCarne;
    private String codigoBarras;
    private Long tipoCadastro;
    private String cadastroGeral;
    private String cpfCnpj;
    private String nome;
    private String exercicioDebito;
    private String divida;
    private String subDivida;

    private String addAND(String clausula) {
        return " and " + clausula;
    }

    public String buildFiltro() {
        StringBuilder filtro = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.carne)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.carne, (String)"tc.carne")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.exercicioCarne)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.exercicioCarne, (String)"tc.exercicio")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.codigoBarras)) {
            filtro.append(this.addAND(String.format("tc.codigobarras='%s'", this.codigoBarras)));
        }
        if (Objects.nonNull(this.tipoCadastro)) {
            filtro.append(this.addAND(String.format("tc.tipocadastro=%d", this.tipoCadastro)));
        }
        if (StringUtils.isNotBlank((CharSequence)this.cadastroGeral)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.cadastroGeral, (String)"tc.cadastrogeral")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.cpfCnpj)) {
            filtro.append(this.addAND(String.format("p.cnpj_cpf='%s'", this.cpfCnpj)));
        }
        if (StringUtils.isNotBlank((CharSequence)this.nome)) {
            filtro.append(this.addAND("lower(p.nome) like '%filtro%'".replace("filtro", this.nome.toLowerCase())));
        }
        if (StringUtils.isNotBlank((CharSequence)this.exercicioDebito)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.exercicioDebito, (String)"boleto.exerciciodebito")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.divida)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.divida, (String)"boleto.guiarecolhimento")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.subDivida)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.subDivida, (String)"boleto.subdivida")));
        }
        return filtro.toString();
    }

    @Generated
    public FiltroConsultaCarneDTO() {
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public String getCarne() {
        return this.carne;
    }

    @Generated
    public String getExercicioCarne() {
        return this.exercicioCarne;
    }

    @Generated
    public String getCodigoBarras() {
        return this.codigoBarras;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public String getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getCpfCnpj() {
        return this.cpfCnpj;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public String getExercicioDebito() {
        return this.exercicioDebito;
    }

    @Generated
    public String getDivida() {
        return this.divida;
    }

    @Generated
    public String getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setCarne(String carne) {
        this.carne = carne;
    }

    @Generated
    public void setExercicioCarne(String exercicioCarne) {
        this.exercicioCarne = exercicioCarne;
    }

    @Generated
    public void setCodigoBarras(String codigoBarras) {
        this.codigoBarras = codigoBarras;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(String cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setCpfCnpj(String cpfCnpj) {
        this.cpfCnpj = cpfCnpj;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setExercicioDebito(String exercicioDebito) {
        this.exercicioDebito = exercicioDebito;
    }

    @Generated
    public void setDivida(String divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(String subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiltroConsultaCarneDTO)) {
            return false;
        }
        FiltroConsultaCarneDTO other = (FiltroConsultaCarneDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        String this$carne = this.getCarne();
        String other$carne = other.getCarne();
        if (this$carne == null ? other$carne != null : !this$carne.equals(other$carne)) {
            return false;
        }
        String this$exercicioCarne = this.getExercicioCarne();
        String other$exercicioCarne = other.getExercicioCarne();
        if (this$exercicioCarne == null ? other$exercicioCarne != null : !this$exercicioCarne.equals(other$exercicioCarne)) {
            return false;
        }
        String this$codigoBarras = this.getCodigoBarras();
        String other$codigoBarras = other.getCodigoBarras();
        if (this$codigoBarras == null ? other$codigoBarras != null : !this$codigoBarras.equals(other$codigoBarras)) {
            return false;
        }
        String this$cadastroGeral = this.getCadastroGeral();
        String other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        String this$cpfCnpj = this.getCpfCnpj();
        String other$cpfCnpj = other.getCpfCnpj();
        if (this$cpfCnpj == null ? other$cpfCnpj != null : !this$cpfCnpj.equals(other$cpfCnpj)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        String this$exercicioDebito = this.getExercicioDebito();
        String other$exercicioDebito = other.getExercicioDebito();
        if (this$exercicioDebito == null ? other$exercicioDebito != null : !this$exercicioDebito.equals(other$exercicioDebito)) {
            return false;
        }
        String this$divida = this.getDivida();
        String other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !this$divida.equals(other$divida)) {
            return false;
        }
        String this$subDivida = this.getSubDivida();
        String other$subDivida = other.getSubDivida();
        return !(this$subDivida == null ? other$subDivida != null : !this$subDivida.equals(other$subDivida));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FiltroConsultaCarneDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        String $carne = this.getCarne();
        result = result * 59 + ($carne == null ? 43 : $carne.hashCode());
        String $exercicioCarne = this.getExercicioCarne();
        result = result * 59 + ($exercicioCarne == null ? 43 : $exercicioCarne.hashCode());
        String $codigoBarras = this.getCodigoBarras();
        result = result * 59 + ($codigoBarras == null ? 43 : $codigoBarras.hashCode());
        String $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        String $cpfCnpj = this.getCpfCnpj();
        result = result * 59 + ($cpfCnpj == null ? 43 : $cpfCnpj.hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        String $exercicioDebito = this.getExercicioDebito();
        result = result * 59 + ($exercicioDebito == null ? 43 : $exercicioDebito.hashCode());
        String $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : $divida.hashCode());
        String $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : $subDivida.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FiltroConsultaCarneDTO(entidade=" + this.getEntidade() + ", carne=" + this.getCarne() + ", exercicioCarne=" + this.getExercicioCarne() + ", codigoBarras=" + this.getCodigoBarras() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", cpfCnpj=" + this.getCpfCnpj() + ", nome=" + this.getNome() + ", exercicioDebito=" + this.getExercicioDebito() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ")";
    }
}

