/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.ContaBancaria;
import br.com.elotech.tributos.domain.TipoTributo;
import br.com.elotech.tributos.util.MultiValueFilter;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class FiltroArrecadacaoPorTributoDTO {
    @NotNull(message="\u00c9 obrigat\u00f3rio o preenchimento da Data In\u00edcio.")
    private @NotNull(message="\u00c9 obrigat\u00f3rio o preenchimento da Data In\u00edcio.") LocalDate dataInicio;
    @NotNull(message="\u00c9 obrigat\u00f3rio o preenchimento da Data Fim.")
    private @NotNull(message="\u00c9 obrigat\u00f3rio o preenchimento da Data Fim.") LocalDate dataFim;
    private Long tipoCadastro;
    private String cadastroGeral;
    private String anoDivida;
    private String divida;
    private String subDivida;
    private TipoTributo tipoTributo;
    private ContaBancaria contaBancaria;
    private Map<String, Object> receita;

    public String getSearch() {
        String sigla = "";
        if (this.receita != null && !this.receita.isEmpty()) {
            sigla = String.valueOf(this.receita.get("key"));
        }
        Object search = "dataInicio: " + this.dataInicio.format(DateTimeFormatter.ofPattern("dd/MM/yyyy")) + " dataFim: " + this.dataFim.format(DateTimeFormatter.ofPattern("dd/MM/yyyy")) + " contaBancaria: " + (String)Optional.ofNullable(this.contaBancaria).map(ContaBancaria::getDescricao).orElse(null) + " tipoCadastro: " + this.tipoCadastro + " cadastroGeral: " + this.cadastroGeral + " anoDivida: " + this.anoDivida + " divida: " + this.divida + " subDivida: " + this.subDivida + " receita: " + sigla + " tipoTributo: " + (String)Optional.ofNullable(this.tipoTributo).map(TipoTributo::getDescricao).orElse(null);
        search = ((String)search).replace("null", "");
        return search;
    }

    private String addAND(String clausula) {
        return " AND " + clausula;
    }

    public String getWhereClausule() {
        StringBuilder where = new StringBuilder();
        if (Objects.nonNull(this.tipoCadastro)) {
            where.append(this.addAND(String.format("DEBITOPARCELARECEITA.TIPOCADASTRO = %d", this.tipoCadastro)));
        }
        if (StringUtils.isNotBlank((CharSequence)this.cadastroGeral)) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.cadastroGeral, (String)"DEBITOPARCELARECEITA.CADASTROGERAL")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.anoDivida)) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.anoDivida, (String)"DEBITOPARCELARECEITA.EXERCICIO")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.divida)) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.divida, (String)"DEBITOPARCELARECEITA.GUIARECOLHIMENTO")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.subDivida)) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.subDivida, (String)"DEBITOPARCELARECEITA.SUBDIVIDA")));
        }
        if (Objects.nonNull(this.tipoTributo)) {
            where.append(this.addAND(String.format("RECEITA.TIPORECEITA = %d", this.tipoTributo.getId())));
        }
        if (Objects.nonNull(this.contaBancaria)) {
            where.append(this.addAND(String.format("CONTABANCARIA.CONTABANCARIA = %d", this.contaBancaria.getContaBancaria())));
        }
        if (this.receita != null && !this.receita.isEmpty()) {
            where.append(this.addAND(String.format("RECEITA.RECEITA = '%s'", String.valueOf(this.receita.get("key")).replace("'", "''"))));
        }
        return where.toString();
    }

    public void validaDatas() {
        if (this.dataInicio.isAfter(this.dataFim)) {
            throw new EloValidationException("Intervalo de datas inv\u00e1lido, favor corrija para prosseguir.");
        }
    }

    @Generated
    public FiltroArrecadacaoPorTributoDTO() {
    }

    @Generated
    public LocalDate getDataInicio() {
        return this.dataInicio;
    }

    @Generated
    public LocalDate getDataFim() {
        return this.dataFim;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public String getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getAnoDivida() {
        return this.anoDivida;
    }

    @Generated
    public String getDivida() {
        return this.divida;
    }

    @Generated
    public String getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public TipoTributo getTipoTributo() {
        return this.tipoTributo;
    }

    @Generated
    public ContaBancaria getContaBancaria() {
        return this.contaBancaria;
    }

    @Generated
    public Map<String, Object> getReceita() {
        return this.receita;
    }

    @Generated
    public void setDataInicio(LocalDate dataInicio) {
        this.dataInicio = dataInicio;
    }

    @Generated
    public void setDataFim(LocalDate dataFim) {
        this.dataFim = dataFim;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(String cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setAnoDivida(String anoDivida) {
        this.anoDivida = anoDivida;
    }

    @Generated
    public void setDivida(String divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(String subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setTipoTributo(TipoTributo tipoTributo) {
        this.tipoTributo = tipoTributo;
    }

    @Generated
    public void setContaBancaria(ContaBancaria contaBancaria) {
        this.contaBancaria = contaBancaria;
    }

    @Generated
    public void setReceita(Map<String, Object> receita) {
        this.receita = receita;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiltroArrecadacaoPorTributoDTO)) {
            return false;
        }
        FiltroArrecadacaoPorTributoDTO other = (FiltroArrecadacaoPorTributoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        LocalDate this$dataInicio = this.getDataInicio();
        LocalDate other$dataInicio = other.getDataInicio();
        if (this$dataInicio == null ? other$dataInicio != null : !((Object)this$dataInicio).equals(other$dataInicio)) {
            return false;
        }
        LocalDate this$dataFim = this.getDataFim();
        LocalDate other$dataFim = other.getDataFim();
        if (this$dataFim == null ? other$dataFim != null : !((Object)this$dataFim).equals(other$dataFim)) {
            return false;
        }
        String this$cadastroGeral = this.getCadastroGeral();
        String other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        String this$anoDivida = this.getAnoDivida();
        String other$anoDivida = other.getAnoDivida();
        if (this$anoDivida == null ? other$anoDivida != null : !this$anoDivida.equals(other$anoDivida)) {
            return false;
        }
        String this$divida = this.getDivida();
        String other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !this$divida.equals(other$divida)) {
            return false;
        }
        String this$subDivida = this.getSubDivida();
        String other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !this$subDivida.equals(other$subDivida)) {
            return false;
        }
        TipoTributo this$tipoTributo = this.getTipoTributo();
        TipoTributo other$tipoTributo = other.getTipoTributo();
        if (this$tipoTributo == null ? other$tipoTributo != null : !this$tipoTributo.equals(other$tipoTributo)) {
            return false;
        }
        ContaBancaria this$contaBancaria = this.getContaBancaria();
        ContaBancaria other$contaBancaria = other.getContaBancaria();
        if (this$contaBancaria == null ? other$contaBancaria != null : !this$contaBancaria.equals(other$contaBancaria)) {
            return false;
        }
        Map this$receita = this.getReceita();
        Map other$receita = other.getReceita();
        return !(this$receita == null ? other$receita != null : !((Object)this$receita).equals(other$receita));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FiltroArrecadacaoPorTributoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        LocalDate $dataInicio = this.getDataInicio();
        result = result * 59 + ($dataInicio == null ? 43 : ((Object)$dataInicio).hashCode());
        LocalDate $dataFim = this.getDataFim();
        result = result * 59 + ($dataFim == null ? 43 : ((Object)$dataFim).hashCode());
        String $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        String $anoDivida = this.getAnoDivida();
        result = result * 59 + ($anoDivida == null ? 43 : $anoDivida.hashCode());
        String $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : $divida.hashCode());
        String $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : $subDivida.hashCode());
        TipoTributo $tipoTributo = this.getTipoTributo();
        result = result * 59 + ($tipoTributo == null ? 43 : $tipoTributo.hashCode());
        ContaBancaria $contaBancaria = this.getContaBancaria();
        result = result * 59 + ($contaBancaria == null ? 43 : $contaBancaria.hashCode());
        Map $receita = this.getReceita();
        result = result * 59 + ($receita == null ? 43 : ((Object)$receita).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FiltroArrecadacaoPorTributoDTO(dataInicio=" + String.valueOf(this.getDataInicio()) + ", dataFim=" + String.valueOf(this.getDataFim()) + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", anoDivida=" + this.getAnoDivida() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ", tipoTributo=" + String.valueOf(this.getTipoTributo()) + ", contaBancaria=" + String.valueOf(this.getContaBancaria()) + ", receita=" + String.valueOf(this.getReceita()) + ")";
    }
}

