/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.DocumentoTexto;
import br.com.elotech.tributos.domain.DocumentoTextoId;
import br.com.elotech.tributos.util.FileUtils;
import java.time.LocalDate;
import lombok.Generated;

public class DocumentoTextoDTO {
    private Long entidade;
    private Long exercicio;
    private Long tipoDocumento;
    private Long sequencia;
    private String descricao;
    private String cabecalho;
    private String rodape;
    private Boolean padrao;
    private String observacao;
    private LocalDate periodoInicial;
    private LocalDate periodoFinal;

    public static DocumentoTexto toEntity(DocumentoTextoDTO dto, Long tipoDocumentoIdPai) {
        if (dto == null) {
            return null;
        }
        DocumentoTexto entity = new DocumentoTexto();
        DocumentoTextoId id = new DocumentoTextoId();
        id.setEntidade(dto.getEntidade());
        id.setExercicio(dto.getExercicio());
        id.setTipoDocumento(tipoDocumentoIdPai != null ? tipoDocumentoIdPai : dto.getTipoDocumento());
        id.setSequencia(dto.getSequencia());
        entity.setId(id);
        entity.setDescricao(dto.getDescricao());
        entity.setCabecalho(FileUtils.safeTextToBytes((String)dto.getCabecalho()));
        entity.setRodape(FileUtils.safeTextToBytes((String)dto.getRodape()));
        entity.setPadrao(Boolean.valueOf(Boolean.TRUE.equals(dto.getPadrao())));
        entity.setObservacao(dto.getObservacao());
        entity.setPeriodoInicial(dto.getPeriodoInicial());
        entity.setPeriodoFinal(dto.getPeriodoFinal());
        return entity;
    }

    public static DocumentoTextoDTO from(DocumentoTexto entity) {
        if (entity == null) {
            return null;
        }
        DocumentoTextoDTO dto = new DocumentoTextoDTO();
        if (entity.getId() != null) {
            dto.setEntidade(entity.getId().getEntidade());
            dto.setExercicio(entity.getId().getExercicio());
            dto.setTipoDocumento(entity.getId().getTipoDocumento());
            dto.setSequencia(entity.getId().getSequencia());
        }
        dto.setDescricao(entity.getDescricao());
        dto.setCabecalho(entity.getCabecalho() != null ? FileUtils.bytesToText((byte[])entity.getCabecalho()) : "");
        dto.setRodape(entity.getRodape() != null ? FileUtils.bytesToText((byte[])entity.getRodape()) : "");
        dto.setPadrao(Boolean.valueOf(Boolean.TRUE.equals(entity.getPadrao())));
        dto.setObservacao(entity.getObservacao());
        dto.setPeriodoInicial(entity.getPeriodoInicial());
        dto.setPeriodoFinal(entity.getPeriodoFinal());
        return dto;
    }

    @Generated
    public DocumentoTextoDTO() {
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getTipoDocumento() {
        return this.tipoDocumento;
    }

    @Generated
    public Long getSequencia() {
        return this.sequencia;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public String getCabecalho() {
        return this.cabecalho;
    }

    @Generated
    public String getRodape() {
        return this.rodape;
    }

    @Generated
    public Boolean getPadrao() {
        return this.padrao;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public LocalDate getPeriodoInicial() {
        return this.periodoInicial;
    }

    @Generated
    public LocalDate getPeriodoFinal() {
        return this.periodoFinal;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTipoDocumento(Long tipoDocumento) {
        this.tipoDocumento = tipoDocumento;
    }

    @Generated
    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setCabecalho(String cabecalho) {
        this.cabecalho = cabecalho;
    }

    @Generated
    public void setRodape(String rodape) {
        this.rodape = rodape;
    }

    @Generated
    public void setPadrao(Boolean padrao) {
        this.padrao = padrao;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setPeriodoInicial(LocalDate periodoInicial) {
        this.periodoInicial = periodoInicial;
    }

    @Generated
    public void setPeriodoFinal(LocalDate periodoFinal) {
        this.periodoFinal = periodoFinal;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentoTextoDTO)) {
            return false;
        }
        DocumentoTextoDTO other = (DocumentoTextoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$tipoDocumento = this.getTipoDocumento();
        Long other$tipoDocumento = other.getTipoDocumento();
        if (this$tipoDocumento == null ? other$tipoDocumento != null : !((Object)this$tipoDocumento).equals(other$tipoDocumento)) {
            return false;
        }
        Long this$sequencia = this.getSequencia();
        Long other$sequencia = other.getSequencia();
        if (this$sequencia == null ? other$sequencia != null : !((Object)this$sequencia).equals(other$sequencia)) {
            return false;
        }
        Boolean this$padrao = this.getPadrao();
        Boolean other$padrao = other.getPadrao();
        if (this$padrao == null ? other$padrao != null : !((Object)this$padrao).equals(other$padrao)) {
            return false;
        }
        String this$descricao = this.getDescricao();
        String other$descricao = other.getDescricao();
        if (this$descricao == null ? other$descricao != null : !this$descricao.equals(other$descricao)) {
            return false;
        }
        String this$cabecalho = this.getCabecalho();
        String other$cabecalho = other.getCabecalho();
        if (this$cabecalho == null ? other$cabecalho != null : !this$cabecalho.equals(other$cabecalho)) {
            return false;
        }
        String this$rodape = this.getRodape();
        String other$rodape = other.getRodape();
        if (this$rodape == null ? other$rodape != null : !this$rodape.equals(other$rodape)) {
            return false;
        }
        String this$observacao = this.getObservacao();
        String other$observacao = other.getObservacao();
        if (this$observacao == null ? other$observacao != null : !this$observacao.equals(other$observacao)) {
            return false;
        }
        LocalDate this$periodoInicial = this.getPeriodoInicial();
        LocalDate other$periodoInicial = other.getPeriodoInicial();
        if (this$periodoInicial == null ? other$periodoInicial != null : !((Object)this$periodoInicial).equals(other$periodoInicial)) {
            return false;
        }
        LocalDate this$periodoFinal = this.getPeriodoFinal();
        LocalDate other$periodoFinal = other.getPeriodoFinal();
        return !(this$periodoFinal == null ? other$periodoFinal != null : !((Object)this$periodoFinal).equals(other$periodoFinal));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DocumentoTextoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $tipoDocumento = this.getTipoDocumento();
        result = result * 59 + ($tipoDocumento == null ? 43 : ((Object)$tipoDocumento).hashCode());
        Long $sequencia = this.getSequencia();
        result = result * 59 + ($sequencia == null ? 43 : ((Object)$sequencia).hashCode());
        Boolean $padrao = this.getPadrao();
        result = result * 59 + ($padrao == null ? 43 : ((Object)$padrao).hashCode());
        String $descricao = this.getDescricao();
        result = result * 59 + ($descricao == null ? 43 : $descricao.hashCode());
        String $cabecalho = this.getCabecalho();
        result = result * 59 + ($cabecalho == null ? 43 : $cabecalho.hashCode());
        String $rodape = this.getRodape();
        result = result * 59 + ($rodape == null ? 43 : $rodape.hashCode());
        String $observacao = this.getObservacao();
        result = result * 59 + ($observacao == null ? 43 : $observacao.hashCode());
        LocalDate $periodoInicial = this.getPeriodoInicial();
        result = result * 59 + ($periodoInicial == null ? 43 : ((Object)$periodoInicial).hashCode());
        LocalDate $periodoFinal = this.getPeriodoFinal();
        result = result * 59 + ($periodoFinal == null ? 43 : ((Object)$periodoFinal).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DocumentoTextoDTO(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", tipoDocumento=" + this.getTipoDocumento() + ", sequencia=" + this.getSequencia() + ", descricao=" + this.getDescricao() + ", cabecalho=" + this.getCabecalho() + ", rodape=" + this.getRodape() + ", padrao=" + this.getPadrao() + ", observacao=" + this.getObservacao() + ", periodoInicial=" + String.valueOf(this.getPeriodoInicial()) + ", periodoFinal=" + String.valueOf(this.getPeriodoFinal()) + ")";
    }
}

