/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.DebitoParcelaId;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.DocumentoHistoricoSituacao;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoDocumentoEnum;
import br.com.elotech.tributos.dto.CadastroImobiliarioLocalizacaoDTO;
import br.com.elotech.tributos.dto.CertidaoDividaAtivaDebitoHonorarioDTO;
import br.com.elotech.tributos.dto.DocumentoArquivoUnicoDTO;
import br.com.elotech.tributos.dto.DocumentoDividaAtivaDTO;
import br.com.elotech.tributos.dto.DocumentoItemPeticaoDTO;
import br.com.elotech.tributos.dto.DocumentoPessoasDTO;
import br.com.elotech.tributos.dto.EnvioPeticaoDTO;
import br.com.elotech.tributos.dto.PessoaDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class DocumentoDTO {
    private Long id;
    private Long idCadastro;
    private TipoCadastro tipoCadastro;
    private Long cadastroGeral;
    private BigDecimal valorVenalInformado;
    private String nomeRequerente;
    private String cpfRequerente;
    private TipoPessoa tipoPessoaRequerente;
    private Long exercicio;
    private Long tipoDocumento;
    private String descricaoTipoDocumento;
    private Long documento;
    private String url;
    private String codigoValidacao;
    private String usuario;
    private String cpfCnpj;
    private Boolean geraDocumentoCentral;
    private LocalDate dataEmissao;
    private LocalDate dataValidade;
    private String finalidade;
    private String subTipo;
    private String subTipoDescricao;
    private Long idProcesso;
    private Long exercicioProcesso;
    private String pessoaNome;
    private PessoaDTO pessoa;
    private Long codigoPessoa;
    private String tipoPessoa;
    private String situacaoDescricao;
    private Long situacaoId;
    private String tipoLogradouro;
    private Long logradouroId;
    private String logradouro;
    private String enderecoNumero;
    private Long bairroId;
    private String bairro;
    private Long cep;
    private String cidade;
    private String unidadeFederacao;
    private String complemento;
    private CadastroImobiliarioLocalizacaoDTO cadastroImobiliarioLocalizacaoDTO;
    private List<DocumentoPessoasDTO> documentoPessoasDTO = new ArrayList();
    private List<DocumentoDividaAtivaDTO> documentoDividaAtivaDTO = new ArrayList();
    private List<DocumentoItemPeticaoDTO> documentosItensPeticaoDTO = new ArrayList();
    private Boolean cancelado;
    private LocalDate dataCancelamento;
    private String usuarioCancelamento;
    private String observacaoCancelamento;
    private List<DocumentoHistoricoSituacao> listaHistoricoSituacao;
    private String modulo;
    private String tipoRelatorio;
    private Long relatorio;
    private String observacao;
    private Boolean exclusaoLogica;
    private EnvioPeticaoDTO envioPeticaoDTO;
    private Boolean enviadoProcuradoria;
    private LocalDateTime dataEnvioProcuradoria;
    private DocumentoArquivoUnicoDTO documentoArquivoUnicoDTO;
    private LocalDateTime dataArquivoUnificadoGerado;
    private UUID idLaudo;
    private String urlArquivoAssinado;
    private Boolean substituido = Boolean.FALSE;
    private Boolean editado = Boolean.FALSE;
    private String processoSei;
    private Boolean armazenarComoPdf;
    private Boolean habilitaEdicao;
    private Boolean maisDeUmLayout;
    private String codigoPgd;
    private String numeroPrimeiroAlvara;
    private String anoEmissaoAlvara;
    private String codigoPrancha;
    private Long numeroProjeto;
    private Long exercicioProjeto;
    private BigDecimal areaAcrescimoOrDecrescimo;
    private LocalDate dataPrimeiroAlvara;
    private List<CertidaoDividaAtivaDebitoHonorarioDTO> certidaoDividaAtivaDebitoHonorarioDTO = new ArrayList();
    private String numeroPaf;
    private String processoJudicial;

    public static DocumentoDTO fromWithDocumentoItemDividaAtivas(Documento documento) {
        DocumentoDTO documentoDTO = DocumentoDTO.from((Documento)documento);
        if (TipoDocumentoEnum.CERTIDAO_DIVIDA_ATIVA.getCodigo().equals(documento.getTipoDocumento())) {
            documentoDTO.setDocumentoDividaAtivaDTO(documento.getDocumentoItemDividaAtivas().stream().map(DocumentoDividaAtivaDTO::from).collect(Collectors.toList()));
        }
        return documentoDTO;
    }

    public static DocumentoDTO from(Documento documento) {
        DocumentoDTO documentoDTO = new DocumentoDTO();
        documentoDTO.setId(documento.getId());
        documentoDTO.setExercicio(documento.getExercicio());
        documentoDTO.setDocumento(documento.getDocumento());
        documentoDTO.setNomeRequerente(documento.getRequerente());
        documentoDTO.setCpfRequerente(documento.getCpfRequerente());
        documentoDTO.setTipoPessoaRequerente(documento.getTipoPessoaRequerente());
        documentoDTO.setCodigoValidacao(documento.getCodigoValidacao());
        documentoDTO.setUsuario(documento.getUsuario());
        documentoDTO.setCpfCnpj(documento.getCnpjCpf());
        documentoDTO.setDataEmissao(documento.getDataEmissao());
        documentoDTO.setDataValidade(documento.getDataValidade());
        documentoDTO.setSubTipo(documento.getSubTipo());
        documentoDTO.setIdProcesso(documento.getIdProcesso());
        documentoDTO.setExercicioProcesso(documento.getExercicioProcesso());
        documentoDTO.setCancelado(documento.getCancelado());
        documentoDTO.setDataCancelamento(documento.getDataCancelamento());
        documentoDTO.setUsuarioCancelamento(documento.getUsuarioCancelamento());
        documentoDTO.setObservacaoCancelamento(documento.getObservacaoCancelamento());
        documentoDTO.setListaHistoricoSituacao(documento.getDocumentoHistoricoSituacoes());
        documentoDTO.setObservacao(documento.getObservacao());
        documentoDTO.setDataEnvioProcuradoria(documento.getDataEnvioProcuradoria());
        documentoDTO.setDataArquivoUnificadoGerado(documento.getDataArquivoUnificadoGerado());
        documentoDTO.setSubstituido(documento.getSubstituido());
        documentoDTO.setProcessoSei(documento.getProcessoSei());
        documentoDTO.setCodigoPgd(documento.getCodigoPgd());
        documentoDTO.setNumeroPrimeiroAlvara(documento.getNumeroPrimeiroAlvara());
        documentoDTO.setAnoEmissaoAlvara(documento.getAnoEmissaoAlvara());
        documentoDTO.setDataPrimeiroAlvara(documento.getDataPrimeiroAlvara());
        documentoDTO.setCodigoPrancha(documento.getCodigoPrancha());
        documentoDTO.setNumeroProjeto(documento.getNumeroProjeto());
        documentoDTO.setExercicioProjeto(documento.getExercicioProjeto());
        documentoDTO.setAreaAcrescimoOrDecrescimo(documento.getAreaAcrescimoOrDecrescimo());
        documentoDTO.setNumeroPaf(documento.getNumeroPaf());
        documentoDTO.setProcessoJudicial(documento.getProcessoJudicial());
        Optional.ofNullable(documento.getSituacao()).ifPresent(situacaoDocumento -> {
            documentoDTO.setSituacaoDescricao(situacaoDocumento.getDescricao());
            documentoDTO.setSituacaoId(situacaoDocumento.getId());
        });
        Optional.ofNullable(documento.getPessoa()).ifPresent(pessoa -> {
            documentoDTO.setPessoaNome(pessoa.getNome());
            documentoDTO.setCodigoPessoa(pessoa.getId());
            documentoDTO.setTipoPessoa(Objects.nonNull(pessoa.getTipoPessoa()) ? pessoa.getTipoPessoa().getValue() : null);
            documentoDTO.setPessoa(PessoaDTO.builder().nome(pessoa.getNome()).tipoPessoa((String)Optional.ofNullable(pessoa.getTipoPessoa()).map(TipoPessoa::getValue).orElse(null)).cnpjCpf(pessoa.getCnpjCpf()).build());
        });
        Optional.ofNullable(documento.getDocumentoFinalidade()).ifPresent(finalidade -> documentoDTO.setFinalidade(finalidade.getDescricao()));
        Optional.ofNullable(documento.getDocumentoTipo()).ifPresent(tipo -> {
            documentoDTO.setTipoDocumento(tipo.getId());
            documentoDTO.setDescricaoTipoDocumento(tipo.getDescricao());
            documentoDTO.setGeraDocumentoCentral(tipo.getGeraDocumentoCentral());
            if (Objects.nonNull(tipo.getRelatorio())) {
                documentoDTO.setModulo(tipo.getRelatorio().getId().getModulo());
                documentoDTO.setTipoRelatorio(tipo.getRelatorio().getId().getTipoRelatorio().getTipo());
                documentoDTO.setRelatorio(Long.valueOf(tipo.getRelatorio().getId().getRelatorio().longValue()));
            }
            documentoDTO.setArmazenarComoPdf(tipo.getArmazenarComoPdf());
            documentoDTO.setHabilitaEdicao(tipo.getHabilitaEdicao());
            documentoDTO.setMaisDeUmLayout(tipo.getMaisDeUmLayout());
        });
        Optional.ofNullable(documento.getCadastroGeral()).ifPresent(cadastro -> {
            documentoDTO.setIdCadastro(cadastro.getId());
            documentoDTO.setTipoCadastro(cadastro.getTipoCadastro());
            documentoDTO.setCadastroGeral(cadastro.getCadastroGeral());
            documentoDTO.setEnderecoNumero(cadastro.getNumero());
            documentoDTO.setCep(cadastro.getCep());
            documentoDTO.setComplemento(cadastro.getComplemento());
            Optional.ofNullable(documento.getCadastroGeral().getBairro()).ifPresent(bairro -> {
                documentoDTO.setBairroId(bairro.getId());
                documentoDTO.setBairro(bairro.getDescricao());
            });
            Optional.ofNullable(documento.getCadastroGeral().getLogradouro()).ifPresent(logradouro -> {
                documentoDTO.setLogradouroId(logradouro.getId());
                documentoDTO.setLogradouro(logradouro.getDescricao());
            });
            Optional.ofNullable(documento.getCadastroGeral().getCidade()).ifPresent(cidade -> {
                documentoDTO.setCidade(cidade.getDescricao());
                documentoDTO.setUnidadeFederacao(cidade.getUnidadeFederacao());
            });
            documentoDTO.setExclusaoLogica(cadastro.getExclusaoLogica());
            if (Objects.nonNull(documento.getCadastroGeral().getLogradouro())) {
                Optional.ofNullable(documento.getCadastroGeral().getLogradouro().getTipoLogradouro()).ifPresent(tipoLogradouro -> documentoDTO.setTipoLogradouro(tipoLogradouro.getDescricao()));
            }
        });
        Optional.ofNullable(documento.getDocumentoPessoas()).ifPresent(docPessoas -> documentoDTO.setDocumentoPessoasDTO(docPessoas.stream().map(DocumentoPessoasDTO::from).collect(Collectors.toList())));
        Optional.ofNullable(documentoDTO.getTipoDocumento()).ifPresent(tipoDocumento -> documentoDTO.setSubTipoDescricao(documento.getSubTipoDescricao()));
        Optional.ofNullable(documento.getEnviadoProcuradoria()).ifPresent(enviadoProc -> documentoDTO.setEnviadoProcuradoria(documento.getEnviadoProcuradoria()));
        documentoDTO.setDocumentoArquivoUnicoDTO(DocumentoArquivoUnicoDTO.from((Documento)documento));
        Optional.ofNullable(documento.getUrlArquivoAssinado()).ifPresent(arg_0 -> documentoDTO.setUrlArquivoAssinado(arg_0));
        return documentoDTO;
    }

    public static DocumentoDTO from(Documento documento, String urlImpressao) {
        DocumentoDTO dto = new DocumentoDTO();
        dto.id = documento.getId();
        Optional.ofNullable(documento.getCadastroGeral()).ifPresent(cadastroGeral -> {
            dto.setCadastroGeral(cadastroGeral.getCadastroGeral());
            dto.setExclusaoLogica(cadastroGeral.getExclusaoLogica());
        });
        dto.exercicio = documento.getExercicio();
        Optional.ofNullable(documento.getDocumentoTipo()).ifPresent(tipoDocumento -> dto.setTipoDocumento(tipoDocumento.getId()));
        dto.documento = documento.getDocumento();
        dto.codigoValidacao = documento.getCodigoValidacao();
        dto.url = urlImpressao;
        dto.processoSei = documento.getProcessoSei();
        dto.codigoPgd = documento.getCodigoPgd();
        dto.numeroPrimeiroAlvara = documento.getNumeroPrimeiroAlvara();
        dto.anoEmissaoAlvara = documento.getAnoEmissaoAlvara();
        dto.dataPrimeiroAlvara = documento.getDataPrimeiroAlvara();
        dto.codigoPrancha = documento.getCodigoPrancha();
        dto.numeroProjeto = documento.getNumeroProjeto();
        dto.exercicioProjeto = documento.getExercicioProjeto();
        dto.areaAcrescimoOrDecrescimo = documento.getAreaAcrescimoOrDecrescimo();
        dto.processoJudicial = documento.getProcessoJudicial();
        return dto;
    }

    public List<DocumentoDividaAtivaDTO> agruparDocumentosDividaAtivaPorParcela(Long entidade) {
        Map documentosDividaAtivaAgrupadoPorParcela = this.getDocumentoDividaAtivaDTO().stream().collect(Collectors.groupingBy(documentoDividaAtiva -> DebitoParcelaId.builder().entidade(entidade).exercicio(documentoDividaAtiva.getExercicioDebito()).tipoCadastro(this.getTipoCadastro().getValue()).cadastroGeral(this.getCadastroGeral()).divida(documentoDividaAtiva.getDivida()).subDivida(documentoDividaAtiva.getSubDivida()).parcela(documentoDividaAtiva.getParcela()).build(), Collectors.toList()));
        ArrayList documentosDividaAtivaAgrupado = new ArrayList();
        documentosDividaAtivaAgrupadoPorParcela.forEach((key, cdaList) -> {
            DocumentoDividaAtivaDTO cda = (DocumentoDividaAtivaDTO)cdaList.stream().reduce((acumulator, item) -> {
                acumulator.setValor(acumulator.getValor().add(item.getValor()));
                acumulator.setValorJuros(acumulator.getValorJuros().add(item.getValorJuros()));
                acumulator.setValorMulta(acumulator.getValorMulta().add(item.getValorMulta()));
                acumulator.setValorCorrecao(acumulator.getValorCorrecao().add(item.getValorCorrecao()));
                acumulator.setValorTotal(acumulator.getValorTotal().add(item.getValorTotal()));
                return acumulator;
            }).orElseThrow(() -> new EloValidationException("Erro ao agrupar parcelas"));
            documentosDividaAtivaAgrupado.add(cda);
        });
        Comparator<DocumentoDividaAtivaDTO> comparator = Comparator.comparing(DocumentoDividaAtivaDTO::getExercicioDebito).thenComparing(DocumentoDividaAtivaDTO::getDivida).thenComparing(DocumentoDividaAtivaDTO::getSubDivida).thenComparing(DocumentoDividaAtivaDTO::getParcela);
        return documentosDividaAtivaAgrupado.stream().sorted(comparator).collect(Collectors.toList());
    }

    @Generated
    public DocumentoDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getIdCadastro() {
        return this.idCadastro;
    }

    @Generated
    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public BigDecimal getValorVenalInformado() {
        return this.valorVenalInformado;
    }

    @Generated
    public String getNomeRequerente() {
        return this.nomeRequerente;
    }

    @Generated
    public String getCpfRequerente() {
        return this.cpfRequerente;
    }

    @Generated
    public TipoPessoa getTipoPessoaRequerente() {
        return this.tipoPessoaRequerente;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getTipoDocumento() {
        return this.tipoDocumento;
    }

    @Generated
    public String getDescricaoTipoDocumento() {
        return this.descricaoTipoDocumento;
    }

    @Generated
    public Long getDocumento() {
        return this.documento;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getCodigoValidacao() {
        return this.codigoValidacao;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public String getCpfCnpj() {
        return this.cpfCnpj;
    }

    @Generated
    public Boolean getGeraDocumentoCentral() {
        return this.geraDocumentoCentral;
    }

    @Generated
    public LocalDate getDataEmissao() {
        return this.dataEmissao;
    }

    @Generated
    public LocalDate getDataValidade() {
        return this.dataValidade;
    }

    @Generated
    public String getFinalidade() {
        return this.finalidade;
    }

    @Generated
    public String getSubTipo() {
        return this.subTipo;
    }

    @Generated
    public String getSubTipoDescricao() {
        return this.subTipoDescricao;
    }

    @Generated
    public Long getIdProcesso() {
        return this.idProcesso;
    }

    @Generated
    public Long getExercicioProcesso() {
        return this.exercicioProcesso;
    }

    @Generated
    public String getPessoaNome() {
        return this.pessoaNome;
    }

    @Generated
    public PessoaDTO getPessoa() {
        return this.pessoa;
    }

    @Generated
    public Long getCodigoPessoa() {
        return this.codigoPessoa;
    }

    @Generated
    public String getTipoPessoa() {
        return this.tipoPessoa;
    }

    @Generated
    public String getSituacaoDescricao() {
        return this.situacaoDescricao;
    }

    @Generated
    public Long getSituacaoId() {
        return this.situacaoId;
    }

    @Generated
    public String getTipoLogradouro() {
        return this.tipoLogradouro;
    }

    @Generated
    public Long getLogradouroId() {
        return this.logradouroId;
    }

    @Generated
    public String getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public String getEnderecoNumero() {
        return this.enderecoNumero;
    }

    @Generated
    public Long getBairroId() {
        return this.bairroId;
    }

    @Generated
    public String getBairro() {
        return this.bairro;
    }

    @Generated
    public Long getCep() {
        return this.cep;
    }

    @Generated
    public String getCidade() {
        return this.cidade;
    }

    @Generated
    public String getUnidadeFederacao() {
        return this.unidadeFederacao;
    }

    @Generated
    public String getComplemento() {
        return this.complemento;
    }

    @Generated
    public CadastroImobiliarioLocalizacaoDTO getCadastroImobiliarioLocalizacaoDTO() {
        return this.cadastroImobiliarioLocalizacaoDTO;
    }

    @Generated
    public List<DocumentoPessoasDTO> getDocumentoPessoasDTO() {
        return this.documentoPessoasDTO;
    }

    @Generated
    public List<DocumentoDividaAtivaDTO> getDocumentoDividaAtivaDTO() {
        return this.documentoDividaAtivaDTO;
    }

    @Generated
    public List<DocumentoItemPeticaoDTO> getDocumentosItensPeticaoDTO() {
        return this.documentosItensPeticaoDTO;
    }

    @Generated
    public Boolean getCancelado() {
        return this.cancelado;
    }

    @Generated
    public LocalDate getDataCancelamento() {
        return this.dataCancelamento;
    }

    @Generated
    public String getUsuarioCancelamento() {
        return this.usuarioCancelamento;
    }

    @Generated
    public String getObservacaoCancelamento() {
        return this.observacaoCancelamento;
    }

    @Generated
    public List<DocumentoHistoricoSituacao> getListaHistoricoSituacao() {
        return this.listaHistoricoSituacao;
    }

    @Generated
    public String getModulo() {
        return this.modulo;
    }

    @Generated
    public String getTipoRelatorio() {
        return this.tipoRelatorio;
    }

    @Generated
    public Long getRelatorio() {
        return this.relatorio;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public Boolean getExclusaoLogica() {
        return this.exclusaoLogica;
    }

    @Generated
    public EnvioPeticaoDTO getEnvioPeticaoDTO() {
        return this.envioPeticaoDTO;
    }

    @Generated
    public Boolean getEnviadoProcuradoria() {
        return this.enviadoProcuradoria;
    }

    @Generated
    public LocalDateTime getDataEnvioProcuradoria() {
        return this.dataEnvioProcuradoria;
    }

    @Generated
    public DocumentoArquivoUnicoDTO getDocumentoArquivoUnicoDTO() {
        return this.documentoArquivoUnicoDTO;
    }

    @Generated
    public LocalDateTime getDataArquivoUnificadoGerado() {
        return this.dataArquivoUnificadoGerado;
    }

    @Generated
    public UUID getIdLaudo() {
        return this.idLaudo;
    }

    @Generated
    public String getUrlArquivoAssinado() {
        return this.urlArquivoAssinado;
    }

    @Generated
    public Boolean getSubstituido() {
        return this.substituido;
    }

    @Generated
    public Boolean getEditado() {
        return this.editado;
    }

    @Generated
    public String getProcessoSei() {
        return this.processoSei;
    }

    @Generated
    public Boolean getArmazenarComoPdf() {
        return this.armazenarComoPdf;
    }

    @Generated
    public Boolean getHabilitaEdicao() {
        return this.habilitaEdicao;
    }

    @Generated
    public Boolean getMaisDeUmLayout() {
        return this.maisDeUmLayout;
    }

    @Generated
    public String getCodigoPgd() {
        return this.codigoPgd;
    }

    @Generated
    public String getNumeroPrimeiroAlvara() {
        return this.numeroPrimeiroAlvara;
    }

    @Generated
    public String getAnoEmissaoAlvara() {
        return this.anoEmissaoAlvara;
    }

    @Generated
    public String getCodigoPrancha() {
        return this.codigoPrancha;
    }

    @Generated
    public Long getNumeroProjeto() {
        return this.numeroProjeto;
    }

    @Generated
    public Long getExercicioProjeto() {
        return this.exercicioProjeto;
    }

    @Generated
    public BigDecimal getAreaAcrescimoOrDecrescimo() {
        return this.areaAcrescimoOrDecrescimo;
    }

    @Generated
    public LocalDate getDataPrimeiroAlvara() {
        return this.dataPrimeiroAlvara;
    }

    @Generated
    public List<CertidaoDividaAtivaDebitoHonorarioDTO> getCertidaoDividaAtivaDebitoHonorarioDTO() {
        return this.certidaoDividaAtivaDebitoHonorarioDTO;
    }

    @Generated
    public String getNumeroPaf() {
        return this.numeroPaf;
    }

    @Generated
    public String getProcessoJudicial() {
        return this.processoJudicial;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setIdCadastro(Long idCadastro) {
        this.idCadastro = idCadastro;
    }

    @Generated
    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setValorVenalInformado(BigDecimal valorVenalInformado) {
        this.valorVenalInformado = valorVenalInformado;
    }

    @Generated
    public void setNomeRequerente(String nomeRequerente) {
        this.nomeRequerente = nomeRequerente;
    }

    @Generated
    public void setCpfRequerente(String cpfRequerente) {
        this.cpfRequerente = cpfRequerente;
    }

    @Generated
    public void setTipoPessoaRequerente(TipoPessoa tipoPessoaRequerente) {
        this.tipoPessoaRequerente = tipoPessoaRequerente;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTipoDocumento(Long tipoDocumento) {
        this.tipoDocumento = tipoDocumento;
    }

    @Generated
    public void setDescricaoTipoDocumento(String descricaoTipoDocumento) {
        this.descricaoTipoDocumento = descricaoTipoDocumento;
    }

    @Generated
    public void setDocumento(Long documento) {
        this.documento = documento;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setCodigoValidacao(String codigoValidacao) {
        this.codigoValidacao = codigoValidacao;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setCpfCnpj(String cpfCnpj) {
        this.cpfCnpj = cpfCnpj;
    }

    @Generated
    public void setGeraDocumentoCentral(Boolean geraDocumentoCentral) {
        this.geraDocumentoCentral = geraDocumentoCentral;
    }

    @Generated
    public void setDataEmissao(LocalDate dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Generated
    public void setDataValidade(LocalDate dataValidade) {
        this.dataValidade = dataValidade;
    }

    @Generated
    public void setFinalidade(String finalidade) {
        this.finalidade = finalidade;
    }

    @Generated
    public void setSubTipo(String subTipo) {
        this.subTipo = subTipo;
    }

    @Generated
    public void setSubTipoDescricao(String subTipoDescricao) {
        this.subTipoDescricao = subTipoDescricao;
    }

    @Generated
    public void setIdProcesso(Long idProcesso) {
        this.idProcesso = idProcesso;
    }

    @Generated
    public void setExercicioProcesso(Long exercicioProcesso) {
        this.exercicioProcesso = exercicioProcesso;
    }

    @Generated
    public void setPessoaNome(String pessoaNome) {
        this.pessoaNome = pessoaNome;
    }

    @Generated
    public void setPessoa(PessoaDTO pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setCodigoPessoa(Long codigoPessoa) {
        this.codigoPessoa = codigoPessoa;
    }

    @Generated
    public void setTipoPessoa(String tipoPessoa) {
        this.tipoPessoa = tipoPessoa;
    }

    @Generated
    public void setSituacaoDescricao(String situacaoDescricao) {
        this.situacaoDescricao = situacaoDescricao;
    }

    @Generated
    public void setSituacaoId(Long situacaoId) {
        this.situacaoId = situacaoId;
    }

    @Generated
    public void setTipoLogradouro(String tipoLogradouro) {
        this.tipoLogradouro = tipoLogradouro;
    }

    @Generated
    public void setLogradouroId(Long logradouroId) {
        this.logradouroId = logradouroId;
    }

    @Generated
    public void setLogradouro(String logradouro) {
        this.logradouro = logradouro;
    }

    @Generated
    public void setEnderecoNumero(String enderecoNumero) {
        this.enderecoNumero = enderecoNumero;
    }

    @Generated
    public void setBairroId(Long bairroId) {
        this.bairroId = bairroId;
    }

    @Generated
    public void setBairro(String bairro) {
        this.bairro = bairro;
    }

    @Generated
    public void setCep(Long cep) {
        this.cep = cep;
    }

    @Generated
    public void setCidade(String cidade) {
        this.cidade = cidade;
    }

    @Generated
    public void setUnidadeFederacao(String unidadeFederacao) {
        this.unidadeFederacao = unidadeFederacao;
    }

    @Generated
    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    @Generated
    public void setCadastroImobiliarioLocalizacaoDTO(CadastroImobiliarioLocalizacaoDTO cadastroImobiliarioLocalizacaoDTO) {
        this.cadastroImobiliarioLocalizacaoDTO = cadastroImobiliarioLocalizacaoDTO;
    }

    @Generated
    public void setDocumentoPessoasDTO(List<DocumentoPessoasDTO> documentoPessoasDTO) {
        this.documentoPessoasDTO = documentoPessoasDTO;
    }

    @Generated
    public void setDocumentoDividaAtivaDTO(List<DocumentoDividaAtivaDTO> documentoDividaAtivaDTO) {
        this.documentoDividaAtivaDTO = documentoDividaAtivaDTO;
    }

    @Generated
    public void setDocumentosItensPeticaoDTO(List<DocumentoItemPeticaoDTO> documentosItensPeticaoDTO) {
        this.documentosItensPeticaoDTO = documentosItensPeticaoDTO;
    }

    @Generated
    public void setCancelado(Boolean cancelado) {
        this.cancelado = cancelado;
    }

    @Generated
    public void setDataCancelamento(LocalDate dataCancelamento) {
        this.dataCancelamento = dataCancelamento;
    }

    @Generated
    public void setUsuarioCancelamento(String usuarioCancelamento) {
        this.usuarioCancelamento = usuarioCancelamento;
    }

    @Generated
    public void setObservacaoCancelamento(String observacaoCancelamento) {
        this.observacaoCancelamento = observacaoCancelamento;
    }

    @Generated
    public void setListaHistoricoSituacao(List<DocumentoHistoricoSituacao> listaHistoricoSituacao) {
        this.listaHistoricoSituacao = listaHistoricoSituacao;
    }

    @Generated
    public void setModulo(String modulo) {
        this.modulo = modulo;
    }

    @Generated
    public void setTipoRelatorio(String tipoRelatorio) {
        this.tipoRelatorio = tipoRelatorio;
    }

    @Generated
    public void setRelatorio(Long relatorio) {
        this.relatorio = relatorio;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setExclusaoLogica(Boolean exclusaoLogica) {
        this.exclusaoLogica = exclusaoLogica;
    }

    @Generated
    public void setEnvioPeticaoDTO(EnvioPeticaoDTO envioPeticaoDTO) {
        this.envioPeticaoDTO = envioPeticaoDTO;
    }

    @Generated
    public void setEnviadoProcuradoria(Boolean enviadoProcuradoria) {
        this.enviadoProcuradoria = enviadoProcuradoria;
    }

    @Generated
    public void setDataEnvioProcuradoria(LocalDateTime dataEnvioProcuradoria) {
        this.dataEnvioProcuradoria = dataEnvioProcuradoria;
    }

    @Generated
    public void setDocumentoArquivoUnicoDTO(DocumentoArquivoUnicoDTO documentoArquivoUnicoDTO) {
        this.documentoArquivoUnicoDTO = documentoArquivoUnicoDTO;
    }

    @Generated
    public void setDataArquivoUnificadoGerado(LocalDateTime dataArquivoUnificadoGerado) {
        this.dataArquivoUnificadoGerado = dataArquivoUnificadoGerado;
    }

    @Generated
    public void setIdLaudo(UUID idLaudo) {
        this.idLaudo = idLaudo;
    }

    @Generated
    public void setUrlArquivoAssinado(String urlArquivoAssinado) {
        this.urlArquivoAssinado = urlArquivoAssinado;
    }

    @Generated
    public void setSubstituido(Boolean substituido) {
        this.substituido = substituido;
    }

    @Generated
    public void setEditado(Boolean editado) {
        this.editado = editado;
    }

    @Generated
    public void setProcessoSei(String processoSei) {
        this.processoSei = processoSei;
    }

    @Generated
    public void setArmazenarComoPdf(Boolean armazenarComoPdf) {
        this.armazenarComoPdf = armazenarComoPdf;
    }

    @Generated
    public void setHabilitaEdicao(Boolean habilitaEdicao) {
        this.habilitaEdicao = habilitaEdicao;
    }

    @Generated
    public void setMaisDeUmLayout(Boolean maisDeUmLayout) {
        this.maisDeUmLayout = maisDeUmLayout;
    }

    @Generated
    public void setCodigoPgd(String codigoPgd) {
        this.codigoPgd = codigoPgd;
    }

    @Generated
    public void setNumeroPrimeiroAlvara(String numeroPrimeiroAlvara) {
        this.numeroPrimeiroAlvara = numeroPrimeiroAlvara;
    }

    @Generated
    public void setAnoEmissaoAlvara(String anoEmissaoAlvara) {
        this.anoEmissaoAlvara = anoEmissaoAlvara;
    }

    @Generated
    public void setCodigoPrancha(String codigoPrancha) {
        this.codigoPrancha = codigoPrancha;
    }

    @Generated
    public void setNumeroProjeto(Long numeroProjeto) {
        this.numeroProjeto = numeroProjeto;
    }

    @Generated
    public void setExercicioProjeto(Long exercicioProjeto) {
        this.exercicioProjeto = exercicioProjeto;
    }

    @Generated
    public void setAreaAcrescimoOrDecrescimo(BigDecimal areaAcrescimoOrDecrescimo) {
        this.areaAcrescimoOrDecrescimo = areaAcrescimoOrDecrescimo;
    }

    @Generated
    public void setDataPrimeiroAlvara(LocalDate dataPrimeiroAlvara) {
        this.dataPrimeiroAlvara = dataPrimeiroAlvara;
    }

    @Generated
    public void setCertidaoDividaAtivaDebitoHonorarioDTO(List<CertidaoDividaAtivaDebitoHonorarioDTO> certidaoDividaAtivaDebitoHonorarioDTO) {
        this.certidaoDividaAtivaDebitoHonorarioDTO = certidaoDividaAtivaDebitoHonorarioDTO;
    }

    @Generated
    public void setNumeroPaf(String numeroPaf) {
        this.numeroPaf = numeroPaf;
    }

    @Generated
    public void setProcessoJudicial(String processoJudicial) {
        this.processoJudicial = processoJudicial;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentoDTO)) {
            return false;
        }
        DocumentoDTO other = (DocumentoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$idCadastro = this.getIdCadastro();
        Long other$idCadastro = other.getIdCadastro();
        if (this$idCadastro == null ? other$idCadastro != null : !((Object)this$idCadastro).equals(other$idCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$tipoDocumento = this.getTipoDocumento();
        Long other$tipoDocumento = other.getTipoDocumento();
        if (this$tipoDocumento == null ? other$tipoDocumento != null : !((Object)this$tipoDocumento).equals(other$tipoDocumento)) {
            return false;
        }
        Long this$documento = this.getDocumento();
        Long other$documento = other.getDocumento();
        if (this$documento == null ? other$documento != null : !((Object)this$documento).equals(other$documento)) {
            return false;
        }
        Boolean this$geraDocumentoCentral = this.getGeraDocumentoCentral();
        Boolean other$geraDocumentoCentral = other.getGeraDocumentoCentral();
        if (this$geraDocumentoCentral == null ? other$geraDocumentoCentral != null : !((Object)this$geraDocumentoCentral).equals(other$geraDocumentoCentral)) {
            return false;
        }
        Long this$idProcesso = this.getIdProcesso();
        Long other$idProcesso = other.getIdProcesso();
        if (this$idProcesso == null ? other$idProcesso != null : !((Object)this$idProcesso).equals(other$idProcesso)) {
            return false;
        }
        Long this$exercicioProcesso = this.getExercicioProcesso();
        Long other$exercicioProcesso = other.getExercicioProcesso();
        if (this$exercicioProcesso == null ? other$exercicioProcesso != null : !((Object)this$exercicioProcesso).equals(other$exercicioProcesso)) {
            return false;
        }
        Long this$codigoPessoa = this.getCodigoPessoa();
        Long other$codigoPessoa = other.getCodigoPessoa();
        if (this$codigoPessoa == null ? other$codigoPessoa != null : !((Object)this$codigoPessoa).equals(other$codigoPessoa)) {
            return false;
        }
        Long this$situacaoId = this.getSituacaoId();
        Long other$situacaoId = other.getSituacaoId();
        if (this$situacaoId == null ? other$situacaoId != null : !((Object)this$situacaoId).equals(other$situacaoId)) {
            return false;
        }
        Long this$logradouroId = this.getLogradouroId();
        Long other$logradouroId = other.getLogradouroId();
        if (this$logradouroId == null ? other$logradouroId != null : !((Object)this$logradouroId).equals(other$logradouroId)) {
            return false;
        }
        Long this$bairroId = this.getBairroId();
        Long other$bairroId = other.getBairroId();
        if (this$bairroId == null ? other$bairroId != null : !((Object)this$bairroId).equals(other$bairroId)) {
            return false;
        }
        Long this$cep = this.getCep();
        Long other$cep = other.getCep();
        if (this$cep == null ? other$cep != null : !((Object)this$cep).equals(other$cep)) {
            return false;
        }
        Boolean this$cancelado = this.getCancelado();
        Boolean other$cancelado = other.getCancelado();
        if (this$cancelado == null ? other$cancelado != null : !((Object)this$cancelado).equals(other$cancelado)) {
            return false;
        }
        Long this$relatorio = this.getRelatorio();
        Long other$relatorio = other.getRelatorio();
        if (this$relatorio == null ? other$relatorio != null : !((Object)this$relatorio).equals(other$relatorio)) {
            return false;
        }
        Boolean this$exclusaoLogica = this.getExclusaoLogica();
        Boolean other$exclusaoLogica = other.getExclusaoLogica();
        if (this$exclusaoLogica == null ? other$exclusaoLogica != null : !((Object)this$exclusaoLogica).equals(other$exclusaoLogica)) {
            return false;
        }
        Boolean this$enviadoProcuradoria = this.getEnviadoProcuradoria();
        Boolean other$enviadoProcuradoria = other.getEnviadoProcuradoria();
        if (this$enviadoProcuradoria == null ? other$enviadoProcuradoria != null : !((Object)this$enviadoProcuradoria).equals(other$enviadoProcuradoria)) {
            return false;
        }
        Boolean this$substituido = this.getSubstituido();
        Boolean other$substituido = other.getSubstituido();
        if (this$substituido == null ? other$substituido != null : !((Object)this$substituido).equals(other$substituido)) {
            return false;
        }
        Boolean this$editado = this.getEditado();
        Boolean other$editado = other.getEditado();
        if (this$editado == null ? other$editado != null : !((Object)this$editado).equals(other$editado)) {
            return false;
        }
        Boolean this$armazenarComoPdf = this.getArmazenarComoPdf();
        Boolean other$armazenarComoPdf = other.getArmazenarComoPdf();
        if (this$armazenarComoPdf == null ? other$armazenarComoPdf != null : !((Object)this$armazenarComoPdf).equals(other$armazenarComoPdf)) {
            return false;
        }
        Boolean this$habilitaEdicao = this.getHabilitaEdicao();
        Boolean other$habilitaEdicao = other.getHabilitaEdicao();
        if (this$habilitaEdicao == null ? other$habilitaEdicao != null : !((Object)this$habilitaEdicao).equals(other$habilitaEdicao)) {
            return false;
        }
        Boolean this$maisDeUmLayout = this.getMaisDeUmLayout();
        Boolean other$maisDeUmLayout = other.getMaisDeUmLayout();
        if (this$maisDeUmLayout == null ? other$maisDeUmLayout != null : !((Object)this$maisDeUmLayout).equals(other$maisDeUmLayout)) {
            return false;
        }
        Long this$numeroProjeto = this.getNumeroProjeto();
        Long other$numeroProjeto = other.getNumeroProjeto();
        if (this$numeroProjeto == null ? other$numeroProjeto != null : !((Object)this$numeroProjeto).equals(other$numeroProjeto)) {
            return false;
        }
        Long this$exercicioProjeto = this.getExercicioProjeto();
        Long other$exercicioProjeto = other.getExercicioProjeto();
        if (this$exercicioProjeto == null ? other$exercicioProjeto != null : !((Object)this$exercicioProjeto).equals(other$exercicioProjeto)) {
            return false;
        }
        TipoCadastro this$tipoCadastro = this.getTipoCadastro();
        TipoCadastro other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !this$tipoCadastro.equals(other$tipoCadastro)) {
            return false;
        }
        BigDecimal this$valorVenalInformado = this.getValorVenalInformado();
        BigDecimal other$valorVenalInformado = other.getValorVenalInformado();
        if (this$valorVenalInformado == null ? other$valorVenalInformado != null : !((Object)this$valorVenalInformado).equals(other$valorVenalInformado)) {
            return false;
        }
        String this$nomeRequerente = this.getNomeRequerente();
        String other$nomeRequerente = other.getNomeRequerente();
        if (this$nomeRequerente == null ? other$nomeRequerente != null : !this$nomeRequerente.equals(other$nomeRequerente)) {
            return false;
        }
        String this$cpfRequerente = this.getCpfRequerente();
        String other$cpfRequerente = other.getCpfRequerente();
        if (this$cpfRequerente == null ? other$cpfRequerente != null : !this$cpfRequerente.equals(other$cpfRequerente)) {
            return false;
        }
        TipoPessoa this$tipoPessoaRequerente = this.getTipoPessoaRequerente();
        TipoPessoa other$tipoPessoaRequerente = other.getTipoPessoaRequerente();
        if (this$tipoPessoaRequerente == null ? other$tipoPessoaRequerente != null : !this$tipoPessoaRequerente.equals(other$tipoPessoaRequerente)) {
            return false;
        }
        String this$descricaoTipoDocumento = this.getDescricaoTipoDocumento();
        String other$descricaoTipoDocumento = other.getDescricaoTipoDocumento();
        if (this$descricaoTipoDocumento == null ? other$descricaoTipoDocumento != null : !this$descricaoTipoDocumento.equals(other$descricaoTipoDocumento)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$codigoValidacao = this.getCodigoValidacao();
        String other$codigoValidacao = other.getCodigoValidacao();
        if (this$codigoValidacao == null ? other$codigoValidacao != null : !this$codigoValidacao.equals(other$codigoValidacao)) {
            return false;
        }
        String this$usuario = this.getUsuario();
        String other$usuario = other.getUsuario();
        if (this$usuario == null ? other$usuario != null : !this$usuario.equals(other$usuario)) {
            return false;
        }
        String this$cpfCnpj = this.getCpfCnpj();
        String other$cpfCnpj = other.getCpfCnpj();
        if (this$cpfCnpj == null ? other$cpfCnpj != null : !this$cpfCnpj.equals(other$cpfCnpj)) {
            return false;
        }
        LocalDate this$dataEmissao = this.getDataEmissao();
        LocalDate other$dataEmissao = other.getDataEmissao();
        if (this$dataEmissao == null ? other$dataEmissao != null : !((Object)this$dataEmissao).equals(other$dataEmissao)) {
            return false;
        }
        LocalDate this$dataValidade = this.getDataValidade();
        LocalDate other$dataValidade = other.getDataValidade();
        if (this$dataValidade == null ? other$dataValidade != null : !((Object)this$dataValidade).equals(other$dataValidade)) {
            return false;
        }
        String this$finalidade = this.getFinalidade();
        String other$finalidade = other.getFinalidade();
        if (this$finalidade == null ? other$finalidade != null : !this$finalidade.equals(other$finalidade)) {
            return false;
        }
        String this$subTipo = this.getSubTipo();
        String other$subTipo = other.getSubTipo();
        if (this$subTipo == null ? other$subTipo != null : !this$subTipo.equals(other$subTipo)) {
            return false;
        }
        String this$subTipoDescricao = this.getSubTipoDescricao();
        String other$subTipoDescricao = other.getSubTipoDescricao();
        if (this$subTipoDescricao == null ? other$subTipoDescricao != null : !this$subTipoDescricao.equals(other$subTipoDescricao)) {
            return false;
        }
        String this$pessoaNome = this.getPessoaNome();
        String other$pessoaNome = other.getPessoaNome();
        if (this$pessoaNome == null ? other$pessoaNome != null : !this$pessoaNome.equals(other$pessoaNome)) {
            return false;
        }
        PessoaDTO this$pessoa = this.getPessoa();
        PessoaDTO other$pessoa = other.getPessoa();
        if (this$pessoa == null ? other$pessoa != null : !this$pessoa.equals(other$pessoa)) {
            return false;
        }
        String this$tipoPessoa = this.getTipoPessoa();
        String other$tipoPessoa = other.getTipoPessoa();
        if (this$tipoPessoa == null ? other$tipoPessoa != null : !this$tipoPessoa.equals(other$tipoPessoa)) {
            return false;
        }
        String this$situacaoDescricao = this.getSituacaoDescricao();
        String other$situacaoDescricao = other.getSituacaoDescricao();
        if (this$situacaoDescricao == null ? other$situacaoDescricao != null : !this$situacaoDescricao.equals(other$situacaoDescricao)) {
            return false;
        }
        String this$tipoLogradouro = this.getTipoLogradouro();
        String other$tipoLogradouro = other.getTipoLogradouro();
        if (this$tipoLogradouro == null ? other$tipoLogradouro != null : !this$tipoLogradouro.equals(other$tipoLogradouro)) {
            return false;
        }
        String this$logradouro = this.getLogradouro();
        String other$logradouro = other.getLogradouro();
        if (this$logradouro == null ? other$logradouro != null : !this$logradouro.equals(other$logradouro)) {
            return false;
        }
        String this$enderecoNumero = this.getEnderecoNumero();
        String other$enderecoNumero = other.getEnderecoNumero();
        if (this$enderecoNumero == null ? other$enderecoNumero != null : !this$enderecoNumero.equals(other$enderecoNumero)) {
            return false;
        }
        String this$bairro = this.getBairro();
        String other$bairro = other.getBairro();
        if (this$bairro == null ? other$bairro != null : !this$bairro.equals(other$bairro)) {
            return false;
        }
        String this$cidade = this.getCidade();
        String other$cidade = other.getCidade();
        if (this$cidade == null ? other$cidade != null : !this$cidade.equals(other$cidade)) {
            return false;
        }
        String this$unidadeFederacao = this.getUnidadeFederacao();
        String other$unidadeFederacao = other.getUnidadeFederacao();
        if (this$unidadeFederacao == null ? other$unidadeFederacao != null : !this$unidadeFederacao.equals(other$unidadeFederacao)) {
            return false;
        }
        String this$complemento = this.getComplemento();
        String other$complemento = other.getComplemento();
        if (this$complemento == null ? other$complemento != null : !this$complemento.equals(other$complemento)) {
            return false;
        }
        CadastroImobiliarioLocalizacaoDTO this$cadastroImobiliarioLocalizacaoDTO = this.getCadastroImobiliarioLocalizacaoDTO();
        CadastroImobiliarioLocalizacaoDTO other$cadastroImobiliarioLocalizacaoDTO = other.getCadastroImobiliarioLocalizacaoDTO();
        if (this$cadastroImobiliarioLocalizacaoDTO == null ? other$cadastroImobiliarioLocalizacaoDTO != null : !this$cadastroImobiliarioLocalizacaoDTO.equals(other$cadastroImobiliarioLocalizacaoDTO)) {
            return false;
        }
        List this$documentoPessoasDTO = this.getDocumentoPessoasDTO();
        List other$documentoPessoasDTO = other.getDocumentoPessoasDTO();
        if (this$documentoPessoasDTO == null ? other$documentoPessoasDTO != null : !((Object)this$documentoPessoasDTO).equals(other$documentoPessoasDTO)) {
            return false;
        }
        List this$documentoDividaAtivaDTO = this.getDocumentoDividaAtivaDTO();
        List other$documentoDividaAtivaDTO = other.getDocumentoDividaAtivaDTO();
        if (this$documentoDividaAtivaDTO == null ? other$documentoDividaAtivaDTO != null : !((Object)this$documentoDividaAtivaDTO).equals(other$documentoDividaAtivaDTO)) {
            return false;
        }
        List this$documentosItensPeticaoDTO = this.getDocumentosItensPeticaoDTO();
        List other$documentosItensPeticaoDTO = other.getDocumentosItensPeticaoDTO();
        if (this$documentosItensPeticaoDTO == null ? other$documentosItensPeticaoDTO != null : !((Object)this$documentosItensPeticaoDTO).equals(other$documentosItensPeticaoDTO)) {
            return false;
        }
        LocalDate this$dataCancelamento = this.getDataCancelamento();
        LocalDate other$dataCancelamento = other.getDataCancelamento();
        if (this$dataCancelamento == null ? other$dataCancelamento != null : !((Object)this$dataCancelamento).equals(other$dataCancelamento)) {
            return false;
        }
        String this$usuarioCancelamento = this.getUsuarioCancelamento();
        String other$usuarioCancelamento = other.getUsuarioCancelamento();
        if (this$usuarioCancelamento == null ? other$usuarioCancelamento != null : !this$usuarioCancelamento.equals(other$usuarioCancelamento)) {
            return false;
        }
        String this$observacaoCancelamento = this.getObservacaoCancelamento();
        String other$observacaoCancelamento = other.getObservacaoCancelamento();
        if (this$observacaoCancelamento == null ? other$observacaoCancelamento != null : !this$observacaoCancelamento.equals(other$observacaoCancelamento)) {
            return false;
        }
        List this$listaHistoricoSituacao = this.getListaHistoricoSituacao();
        List other$listaHistoricoSituacao = other.getListaHistoricoSituacao();
        if (this$listaHistoricoSituacao == null ? other$listaHistoricoSituacao != null : !((Object)this$listaHistoricoSituacao).equals(other$listaHistoricoSituacao)) {
            return false;
        }
        String this$modulo = this.getModulo();
        String other$modulo = other.getModulo();
        if (this$modulo == null ? other$modulo != null : !this$modulo.equals(other$modulo)) {
            return false;
        }
        String this$tipoRelatorio = this.getTipoRelatorio();
        String other$tipoRelatorio = other.getTipoRelatorio();
        if (this$tipoRelatorio == null ? other$tipoRelatorio != null : !this$tipoRelatorio.equals(other$tipoRelatorio)) {
            return false;
        }
        String this$observacao = this.getObservacao();
        String other$observacao = other.getObservacao();
        if (this$observacao == null ? other$observacao != null : !this$observacao.equals(other$observacao)) {
            return false;
        }
        EnvioPeticaoDTO this$envioPeticaoDTO = this.getEnvioPeticaoDTO();
        EnvioPeticaoDTO other$envioPeticaoDTO = other.getEnvioPeticaoDTO();
        if (this$envioPeticaoDTO == null ? other$envioPeticaoDTO != null : !this$envioPeticaoDTO.equals(other$envioPeticaoDTO)) {
            return false;
        }
        LocalDateTime this$dataEnvioProcuradoria = this.getDataEnvioProcuradoria();
        LocalDateTime other$dataEnvioProcuradoria = other.getDataEnvioProcuradoria();
        if (this$dataEnvioProcuradoria == null ? other$dataEnvioProcuradoria != null : !((Object)this$dataEnvioProcuradoria).equals(other$dataEnvioProcuradoria)) {
            return false;
        }
        DocumentoArquivoUnicoDTO this$documentoArquivoUnicoDTO = this.getDocumentoArquivoUnicoDTO();
        DocumentoArquivoUnicoDTO other$documentoArquivoUnicoDTO = other.getDocumentoArquivoUnicoDTO();
        if (this$documentoArquivoUnicoDTO == null ? other$documentoArquivoUnicoDTO != null : !this$documentoArquivoUnicoDTO.equals(other$documentoArquivoUnicoDTO)) {
            return false;
        }
        LocalDateTime this$dataArquivoUnificadoGerado = this.getDataArquivoUnificadoGerado();
        LocalDateTime other$dataArquivoUnificadoGerado = other.getDataArquivoUnificadoGerado();
        if (this$dataArquivoUnificadoGerado == null ? other$dataArquivoUnificadoGerado != null : !((Object)this$dataArquivoUnificadoGerado).equals(other$dataArquivoUnificadoGerado)) {
            return false;
        }
        UUID this$idLaudo = this.getIdLaudo();
        UUID other$idLaudo = other.getIdLaudo();
        if (this$idLaudo == null ? other$idLaudo != null : !((Object)this$idLaudo).equals(other$idLaudo)) {
            return false;
        }
        String this$urlArquivoAssinado = this.getUrlArquivoAssinado();
        String other$urlArquivoAssinado = other.getUrlArquivoAssinado();
        if (this$urlArquivoAssinado == null ? other$urlArquivoAssinado != null : !this$urlArquivoAssinado.equals(other$urlArquivoAssinado)) {
            return false;
        }
        String this$processoSei = this.getProcessoSei();
        String other$processoSei = other.getProcessoSei();
        if (this$processoSei == null ? other$processoSei != null : !this$processoSei.equals(other$processoSei)) {
            return false;
        }
        String this$codigoPgd = this.getCodigoPgd();
        String other$codigoPgd = other.getCodigoPgd();
        if (this$codigoPgd == null ? other$codigoPgd != null : !this$codigoPgd.equals(other$codigoPgd)) {
            return false;
        }
        String this$numeroPrimeiroAlvara = this.getNumeroPrimeiroAlvara();
        String other$numeroPrimeiroAlvara = other.getNumeroPrimeiroAlvara();
        if (this$numeroPrimeiroAlvara == null ? other$numeroPrimeiroAlvara != null : !this$numeroPrimeiroAlvara.equals(other$numeroPrimeiroAlvara)) {
            return false;
        }
        String this$anoEmissaoAlvara = this.getAnoEmissaoAlvara();
        String other$anoEmissaoAlvara = other.getAnoEmissaoAlvara();
        if (this$anoEmissaoAlvara == null ? other$anoEmissaoAlvara != null : !this$anoEmissaoAlvara.equals(other$anoEmissaoAlvara)) {
            return false;
        }
        String this$codigoPrancha = this.getCodigoPrancha();
        String other$codigoPrancha = other.getCodigoPrancha();
        if (this$codigoPrancha == null ? other$codigoPrancha != null : !this$codigoPrancha.equals(other$codigoPrancha)) {
            return false;
        }
        BigDecimal this$areaAcrescimoOrDecrescimo = this.getAreaAcrescimoOrDecrescimo();
        BigDecimal other$areaAcrescimoOrDecrescimo = other.getAreaAcrescimoOrDecrescimo();
        if (this$areaAcrescimoOrDecrescimo == null ? other$areaAcrescimoOrDecrescimo != null : !((Object)this$areaAcrescimoOrDecrescimo).equals(other$areaAcrescimoOrDecrescimo)) {
            return false;
        }
        LocalDate this$dataPrimeiroAlvara = this.getDataPrimeiroAlvara();
        LocalDate other$dataPrimeiroAlvara = other.getDataPrimeiroAlvara();
        if (this$dataPrimeiroAlvara == null ? other$dataPrimeiroAlvara != null : !((Object)this$dataPrimeiroAlvara).equals(other$dataPrimeiroAlvara)) {
            return false;
        }
        List this$certidaoDividaAtivaDebitoHonorarioDTO = this.getCertidaoDividaAtivaDebitoHonorarioDTO();
        List other$certidaoDividaAtivaDebitoHonorarioDTO = other.getCertidaoDividaAtivaDebitoHonorarioDTO();
        if (this$certidaoDividaAtivaDebitoHonorarioDTO == null ? other$certidaoDividaAtivaDebitoHonorarioDTO != null : !((Object)this$certidaoDividaAtivaDebitoHonorarioDTO).equals(other$certidaoDividaAtivaDebitoHonorarioDTO)) {
            return false;
        }
        String this$numeroPaf = this.getNumeroPaf();
        String other$numeroPaf = other.getNumeroPaf();
        if (this$numeroPaf == null ? other$numeroPaf != null : !this$numeroPaf.equals(other$numeroPaf)) {
            return false;
        }
        String this$processoJudicial = this.getProcessoJudicial();
        String other$processoJudicial = other.getProcessoJudicial();
        return !(this$processoJudicial == null ? other$processoJudicial != null : !this$processoJudicial.equals(other$processoJudicial));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DocumentoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $idCadastro = this.getIdCadastro();
        result = result * 59 + ($idCadastro == null ? 43 : ((Object)$idCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $tipoDocumento = this.getTipoDocumento();
        result = result * 59 + ($tipoDocumento == null ? 43 : ((Object)$tipoDocumento).hashCode());
        Long $documento = this.getDocumento();
        result = result * 59 + ($documento == null ? 43 : ((Object)$documento).hashCode());
        Boolean $geraDocumentoCentral = this.getGeraDocumentoCentral();
        result = result * 59 + ($geraDocumentoCentral == null ? 43 : ((Object)$geraDocumentoCentral).hashCode());
        Long $idProcesso = this.getIdProcesso();
        result = result * 59 + ($idProcesso == null ? 43 : ((Object)$idProcesso).hashCode());
        Long $exercicioProcesso = this.getExercicioProcesso();
        result = result * 59 + ($exercicioProcesso == null ? 43 : ((Object)$exercicioProcesso).hashCode());
        Long $codigoPessoa = this.getCodigoPessoa();
        result = result * 59 + ($codigoPessoa == null ? 43 : ((Object)$codigoPessoa).hashCode());
        Long $situacaoId = this.getSituacaoId();
        result = result * 59 + ($situacaoId == null ? 43 : ((Object)$situacaoId).hashCode());
        Long $logradouroId = this.getLogradouroId();
        result = result * 59 + ($logradouroId == null ? 43 : ((Object)$logradouroId).hashCode());
        Long $bairroId = this.getBairroId();
        result = result * 59 + ($bairroId == null ? 43 : ((Object)$bairroId).hashCode());
        Long $cep = this.getCep();
        result = result * 59 + ($cep == null ? 43 : ((Object)$cep).hashCode());
        Boolean $cancelado = this.getCancelado();
        result = result * 59 + ($cancelado == null ? 43 : ((Object)$cancelado).hashCode());
        Long $relatorio = this.getRelatorio();
        result = result * 59 + ($relatorio == null ? 43 : ((Object)$relatorio).hashCode());
        Boolean $exclusaoLogica = this.getExclusaoLogica();
        result = result * 59 + ($exclusaoLogica == null ? 43 : ((Object)$exclusaoLogica).hashCode());
        Boolean $enviadoProcuradoria = this.getEnviadoProcuradoria();
        result = result * 59 + ($enviadoProcuradoria == null ? 43 : ((Object)$enviadoProcuradoria).hashCode());
        Boolean $substituido = this.getSubstituido();
        result = result * 59 + ($substituido == null ? 43 : ((Object)$substituido).hashCode());
        Boolean $editado = this.getEditado();
        result = result * 59 + ($editado == null ? 43 : ((Object)$editado).hashCode());
        Boolean $armazenarComoPdf = this.getArmazenarComoPdf();
        result = result * 59 + ($armazenarComoPdf == null ? 43 : ((Object)$armazenarComoPdf).hashCode());
        Boolean $habilitaEdicao = this.getHabilitaEdicao();
        result = result * 59 + ($habilitaEdicao == null ? 43 : ((Object)$habilitaEdicao).hashCode());
        Boolean $maisDeUmLayout = this.getMaisDeUmLayout();
        result = result * 59 + ($maisDeUmLayout == null ? 43 : ((Object)$maisDeUmLayout).hashCode());
        Long $numeroProjeto = this.getNumeroProjeto();
        result = result * 59 + ($numeroProjeto == null ? 43 : ((Object)$numeroProjeto).hashCode());
        Long $exercicioProjeto = this.getExercicioProjeto();
        result = result * 59 + ($exercicioProjeto == null ? 43 : ((Object)$exercicioProjeto).hashCode());
        TipoCadastro $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : $tipoCadastro.hashCode());
        BigDecimal $valorVenalInformado = this.getValorVenalInformado();
        result = result * 59 + ($valorVenalInformado == null ? 43 : ((Object)$valorVenalInformado).hashCode());
        String $nomeRequerente = this.getNomeRequerente();
        result = result * 59 + ($nomeRequerente == null ? 43 : $nomeRequerente.hashCode());
        String $cpfRequerente = this.getCpfRequerente();
        result = result * 59 + ($cpfRequerente == null ? 43 : $cpfRequerente.hashCode());
        TipoPessoa $tipoPessoaRequerente = this.getTipoPessoaRequerente();
        result = result * 59 + ($tipoPessoaRequerente == null ? 43 : $tipoPessoaRequerente.hashCode());
        String $descricaoTipoDocumento = this.getDescricaoTipoDocumento();
        result = result * 59 + ($descricaoTipoDocumento == null ? 43 : $descricaoTipoDocumento.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $codigoValidacao = this.getCodigoValidacao();
        result = result * 59 + ($codigoValidacao == null ? 43 : $codigoValidacao.hashCode());
        String $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : $usuario.hashCode());
        String $cpfCnpj = this.getCpfCnpj();
        result = result * 59 + ($cpfCnpj == null ? 43 : $cpfCnpj.hashCode());
        LocalDate $dataEmissao = this.getDataEmissao();
        result = result * 59 + ($dataEmissao == null ? 43 : ((Object)$dataEmissao).hashCode());
        LocalDate $dataValidade = this.getDataValidade();
        result = result * 59 + ($dataValidade == null ? 43 : ((Object)$dataValidade).hashCode());
        String $finalidade = this.getFinalidade();
        result = result * 59 + ($finalidade == null ? 43 : $finalidade.hashCode());
        String $subTipo = this.getSubTipo();
        result = result * 59 + ($subTipo == null ? 43 : $subTipo.hashCode());
        String $subTipoDescricao = this.getSubTipoDescricao();
        result = result * 59 + ($subTipoDescricao == null ? 43 : $subTipoDescricao.hashCode());
        String $pessoaNome = this.getPessoaNome();
        result = result * 59 + ($pessoaNome == null ? 43 : $pessoaNome.hashCode());
        PessoaDTO $pessoa = this.getPessoa();
        result = result * 59 + ($pessoa == null ? 43 : $pessoa.hashCode());
        String $tipoPessoa = this.getTipoPessoa();
        result = result * 59 + ($tipoPessoa == null ? 43 : $tipoPessoa.hashCode());
        String $situacaoDescricao = this.getSituacaoDescricao();
        result = result * 59 + ($situacaoDescricao == null ? 43 : $situacaoDescricao.hashCode());
        String $tipoLogradouro = this.getTipoLogradouro();
        result = result * 59 + ($tipoLogradouro == null ? 43 : $tipoLogradouro.hashCode());
        String $logradouro = this.getLogradouro();
        result = result * 59 + ($logradouro == null ? 43 : $logradouro.hashCode());
        String $enderecoNumero = this.getEnderecoNumero();
        result = result * 59 + ($enderecoNumero == null ? 43 : $enderecoNumero.hashCode());
        String $bairro = this.getBairro();
        result = result * 59 + ($bairro == null ? 43 : $bairro.hashCode());
        String $cidade = this.getCidade();
        result = result * 59 + ($cidade == null ? 43 : $cidade.hashCode());
        String $unidadeFederacao = this.getUnidadeFederacao();
        result = result * 59 + ($unidadeFederacao == null ? 43 : $unidadeFederacao.hashCode());
        String $complemento = this.getComplemento();
        result = result * 59 + ($complemento == null ? 43 : $complemento.hashCode());
        CadastroImobiliarioLocalizacaoDTO $cadastroImobiliarioLocalizacaoDTO = this.getCadastroImobiliarioLocalizacaoDTO();
        result = result * 59 + ($cadastroImobiliarioLocalizacaoDTO == null ? 43 : $cadastroImobiliarioLocalizacaoDTO.hashCode());
        List $documentoPessoasDTO = this.getDocumentoPessoasDTO();
        result = result * 59 + ($documentoPessoasDTO == null ? 43 : ((Object)$documentoPessoasDTO).hashCode());
        List $documentoDividaAtivaDTO = this.getDocumentoDividaAtivaDTO();
        result = result * 59 + ($documentoDividaAtivaDTO == null ? 43 : ((Object)$documentoDividaAtivaDTO).hashCode());
        List $documentosItensPeticaoDTO = this.getDocumentosItensPeticaoDTO();
        result = result * 59 + ($documentosItensPeticaoDTO == null ? 43 : ((Object)$documentosItensPeticaoDTO).hashCode());
        LocalDate $dataCancelamento = this.getDataCancelamento();
        result = result * 59 + ($dataCancelamento == null ? 43 : ((Object)$dataCancelamento).hashCode());
        String $usuarioCancelamento = this.getUsuarioCancelamento();
        result = result * 59 + ($usuarioCancelamento == null ? 43 : $usuarioCancelamento.hashCode());
        String $observacaoCancelamento = this.getObservacaoCancelamento();
        result = result * 59 + ($observacaoCancelamento == null ? 43 : $observacaoCancelamento.hashCode());
        List $listaHistoricoSituacao = this.getListaHistoricoSituacao();
        result = result * 59 + ($listaHistoricoSituacao == null ? 43 : ((Object)$listaHistoricoSituacao).hashCode());
        String $modulo = this.getModulo();
        result = result * 59 + ($modulo == null ? 43 : $modulo.hashCode());
        String $tipoRelatorio = this.getTipoRelatorio();
        result = result * 59 + ($tipoRelatorio == null ? 43 : $tipoRelatorio.hashCode());
        String $observacao = this.getObservacao();
        result = result * 59 + ($observacao == null ? 43 : $observacao.hashCode());
        EnvioPeticaoDTO $envioPeticaoDTO = this.getEnvioPeticaoDTO();
        result = result * 59 + ($envioPeticaoDTO == null ? 43 : $envioPeticaoDTO.hashCode());
        LocalDateTime $dataEnvioProcuradoria = this.getDataEnvioProcuradoria();
        result = result * 59 + ($dataEnvioProcuradoria == null ? 43 : ((Object)$dataEnvioProcuradoria).hashCode());
        DocumentoArquivoUnicoDTO $documentoArquivoUnicoDTO = this.getDocumentoArquivoUnicoDTO();
        result = result * 59 + ($documentoArquivoUnicoDTO == null ? 43 : $documentoArquivoUnicoDTO.hashCode());
        LocalDateTime $dataArquivoUnificadoGerado = this.getDataArquivoUnificadoGerado();
        result = result * 59 + ($dataArquivoUnificadoGerado == null ? 43 : ((Object)$dataArquivoUnificadoGerado).hashCode());
        UUID $idLaudo = this.getIdLaudo();
        result = result * 59 + ($idLaudo == null ? 43 : ((Object)$idLaudo).hashCode());
        String $urlArquivoAssinado = this.getUrlArquivoAssinado();
        result = result * 59 + ($urlArquivoAssinado == null ? 43 : $urlArquivoAssinado.hashCode());
        String $processoSei = this.getProcessoSei();
        result = result * 59 + ($processoSei == null ? 43 : $processoSei.hashCode());
        String $codigoPgd = this.getCodigoPgd();
        result = result * 59 + ($codigoPgd == null ? 43 : $codigoPgd.hashCode());
        String $numeroPrimeiroAlvara = this.getNumeroPrimeiroAlvara();
        result = result * 59 + ($numeroPrimeiroAlvara == null ? 43 : $numeroPrimeiroAlvara.hashCode());
        String $anoEmissaoAlvara = this.getAnoEmissaoAlvara();
        result = result * 59 + ($anoEmissaoAlvara == null ? 43 : $anoEmissaoAlvara.hashCode());
        String $codigoPrancha = this.getCodigoPrancha();
        result = result * 59 + ($codigoPrancha == null ? 43 : $codigoPrancha.hashCode());
        BigDecimal $areaAcrescimoOrDecrescimo = this.getAreaAcrescimoOrDecrescimo();
        result = result * 59 + ($areaAcrescimoOrDecrescimo == null ? 43 : ((Object)$areaAcrescimoOrDecrescimo).hashCode());
        LocalDate $dataPrimeiroAlvara = this.getDataPrimeiroAlvara();
        result = result * 59 + ($dataPrimeiroAlvara == null ? 43 : ((Object)$dataPrimeiroAlvara).hashCode());
        List $certidaoDividaAtivaDebitoHonorarioDTO = this.getCertidaoDividaAtivaDebitoHonorarioDTO();
        result = result * 59 + ($certidaoDividaAtivaDebitoHonorarioDTO == null ? 43 : ((Object)$certidaoDividaAtivaDebitoHonorarioDTO).hashCode());
        String $numeroPaf = this.getNumeroPaf();
        result = result * 59 + ($numeroPaf == null ? 43 : $numeroPaf.hashCode());
        String $processoJudicial = this.getProcessoJudicial();
        result = result * 59 + ($processoJudicial == null ? 43 : $processoJudicial.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DocumentoDTO(id=" + this.getId() + ", idCadastro=" + this.getIdCadastro() + ", tipoCadastro=" + String.valueOf(this.getTipoCadastro()) + ", cadastroGeral=" + this.getCadastroGeral() + ", valorVenalInformado=" + String.valueOf(this.getValorVenalInformado()) + ", nomeRequerente=" + this.getNomeRequerente() + ", cpfRequerente=" + this.getCpfRequerente() + ", tipoPessoaRequerente=" + String.valueOf(this.getTipoPessoaRequerente()) + ", exercicio=" + this.getExercicio() + ", tipoDocumento=" + this.getTipoDocumento() + ", descricaoTipoDocumento=" + this.getDescricaoTipoDocumento() + ", documento=" + this.getDocumento() + ", url=" + this.getUrl() + ", codigoValidacao=" + this.getCodigoValidacao() + ", usuario=" + this.getUsuario() + ", cpfCnpj=" + this.getCpfCnpj() + ", geraDocumentoCentral=" + this.getGeraDocumentoCentral() + ", dataEmissao=" + String.valueOf(this.getDataEmissao()) + ", dataValidade=" + String.valueOf(this.getDataValidade()) + ", finalidade=" + this.getFinalidade() + ", subTipo=" + this.getSubTipo() + ", subTipoDescricao=" + this.getSubTipoDescricao() + ", idProcesso=" + this.getIdProcesso() + ", exercicioProcesso=" + this.getExercicioProcesso() + ", pessoaNome=" + this.getPessoaNome() + ", pessoa=" + String.valueOf(this.getPessoa()) + ", codigoPessoa=" + this.getCodigoPessoa() + ", tipoPessoa=" + this.getTipoPessoa() + ", situacaoDescricao=" + this.getSituacaoDescricao() + ", situacaoId=" + this.getSituacaoId() + ", tipoLogradouro=" + this.getTipoLogradouro() + ", logradouroId=" + this.getLogradouroId() + ", logradouro=" + this.getLogradouro() + ", enderecoNumero=" + this.getEnderecoNumero() + ", bairroId=" + this.getBairroId() + ", bairro=" + this.getBairro() + ", cep=" + this.getCep() + ", cidade=" + this.getCidade() + ", unidadeFederacao=" + this.getUnidadeFederacao() + ", complemento=" + this.getComplemento() + ", cadastroImobiliarioLocalizacaoDTO=" + String.valueOf(this.getCadastroImobiliarioLocalizacaoDTO()) + ", documentoPessoasDTO=" + String.valueOf(this.getDocumentoPessoasDTO()) + ", documentoDividaAtivaDTO=" + String.valueOf(this.getDocumentoDividaAtivaDTO()) + ", documentosItensPeticaoDTO=" + String.valueOf(this.getDocumentosItensPeticaoDTO()) + ", cancelado=" + this.getCancelado() + ", dataCancelamento=" + String.valueOf(this.getDataCancelamento()) + ", usuarioCancelamento=" + this.getUsuarioCancelamento() + ", observacaoCancelamento=" + this.getObservacaoCancelamento() + ", listaHistoricoSituacao=" + String.valueOf(this.getListaHistoricoSituacao()) + ", modulo=" + this.getModulo() + ", tipoRelatorio=" + this.getTipoRelatorio() + ", relatorio=" + this.getRelatorio() + ", observacao=" + this.getObservacao() + ", exclusaoLogica=" + this.getExclusaoLogica() + ", envioPeticaoDTO=" + String.valueOf(this.getEnvioPeticaoDTO()) + ", enviadoProcuradoria=" + this.getEnviadoProcuradoria() + ", dataEnvioProcuradoria=" + String.valueOf(this.getDataEnvioProcuradoria()) + ", documentoArquivoUnicoDTO=" + String.valueOf(this.getDocumentoArquivoUnicoDTO()) + ", dataArquivoUnificadoGerado=" + String.valueOf(this.getDataArquivoUnificadoGerado()) + ", idLaudo=" + String.valueOf(this.getIdLaudo()) + ", urlArquivoAssinado=" + this.getUrlArquivoAssinado() + ", substituido=" + this.getSubstituido() + ", editado=" + this.getEditado() + ", processoSei=" + this.getProcessoSei() + ", armazenarComoPdf=" + this.getArmazenarComoPdf() + ", habilitaEdicao=" + this.getHabilitaEdicao() + ", maisDeUmLayout=" + this.getMaisDeUmLayout() + ", codigoPgd=" + this.getCodigoPgd() + ", numeroPrimeiroAlvara=" + this.getNumeroPrimeiroAlvara() + ", anoEmissaoAlvara=" + this.getAnoEmissaoAlvara() + ", codigoPrancha=" + this.getCodigoPrancha() + ", numeroProjeto=" + this.getNumeroProjeto() + ", exercicioProjeto=" + this.getExercicioProjeto() + ", areaAcrescimoOrDecrescimo=" + String.valueOf(this.getAreaAcrescimoOrDecrescimo()) + ", dataPrimeiroAlvara=" + String.valueOf(this.getDataPrimeiroAlvara()) + ", certidaoDividaAtivaDebitoHonorarioDTO=" + String.valueOf(this.getCertidaoDividaAtivaDebitoHonorarioDTO()) + ", numeroPaf=" + this.getNumeroPaf() + ", processoJudicial=" + this.getProcessoJudicial() + ")";
    }
}

