/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoParcela;
import java.math.BigDecimal;
import lombok.Generated;

public class DebitoParcelaDTO {
    private Long idDebito;
    private Long exercicio;
    private Long divida;
    private Long subdivida;
    private Long parcela;
    private Long idDebitoParcela;
    private BigDecimal valor;

    public static DebitoParcelaDTO convertBoleto(DebitoParcela debitoParcela, Long idDebito) {
        DebitoParcelaDTO debitoParcelaDTO = new DebitoParcelaDTO();
        debitoParcelaDTO.setIdDebito(idDebito);
        debitoParcelaDTO.setParcela(debitoParcela.getId().getParcela());
        return debitoParcelaDTO;
    }

    public static DebitoParcelaDTO fromUltimaParcelaDebito(Debito debito) {
        DebitoParcelaDTO debitoParcelaDTO = new DebitoParcelaDTO();
        debitoParcelaDTO.setIdDebito(debito.getId());
        debitoParcelaDTO.setParcela(debito.getNumeroParcela());
        return debitoParcelaDTO;
    }

    public static DebitoParcelaDTO from(Long idDebito, Long parcela) {
        DebitoParcelaDTO debitoParcelaDTO = new DebitoParcelaDTO();
        debitoParcelaDTO.setIdDebito(idDebito);
        debitoParcelaDTO.setParcela(parcela);
        return debitoParcelaDTO;
    }

    public static DebitoParcelaDTO from(DebitoParcela debitoParcela) {
        DebitoParcelaDTO debitoParcelaDTO = new DebitoParcelaDTO();
        debitoParcelaDTO.setIdDebitoParcela(debitoParcela.getIdDebitoParcela());
        debitoParcelaDTO.setExercicio(debitoParcela.getId().getExercicio());
        debitoParcelaDTO.setDivida(debitoParcela.getId().getDivida());
        debitoParcelaDTO.setSubdivida(debitoParcela.getId().getSubDivida());
        debitoParcelaDTO.setParcela(debitoParcela.getId().getParcela());
        debitoParcelaDTO.setValor(debitoParcela.getValorCalculado());
        return debitoParcelaDTO;
    }

    @Generated
    public DebitoParcelaDTO() {
    }

    @Generated
    public Long getIdDebito() {
        return this.idDebito;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getDivida() {
        return this.divida;
    }

    @Generated
    public Long getSubdivida() {
        return this.subdivida;
    }

    @Generated
    public Long getParcela() {
        return this.parcela;
    }

    @Generated
    public Long getIdDebitoParcela() {
        return this.idDebitoParcela;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public void setIdDebito(Long idDebito) {
        this.idDebito = idDebito;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setDivida(Long divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubdivida(Long subdivida) {
        this.subdivida = subdivida;
    }

    @Generated
    public void setParcela(Long parcela) {
        this.parcela = parcela;
    }

    @Generated
    public void setIdDebitoParcela(Long idDebitoParcela) {
        this.idDebitoParcela = idDebitoParcela;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebitoParcelaDTO)) {
            return false;
        }
        DebitoParcelaDTO other = (DebitoParcelaDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idDebito = this.getIdDebito();
        Long other$idDebito = other.getIdDebito();
        if (this$idDebito == null ? other$idDebito != null : !((Object)this$idDebito).equals(other$idDebito)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$divida = this.getDivida();
        Long other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !((Object)this$divida).equals(other$divida)) {
            return false;
        }
        Long this$subdivida = this.getSubdivida();
        Long other$subdivida = other.getSubdivida();
        if (this$subdivida == null ? other$subdivida != null : !((Object)this$subdivida).equals(other$subdivida)) {
            return false;
        }
        Long this$parcela = this.getParcela();
        Long other$parcela = other.getParcela();
        if (this$parcela == null ? other$parcela != null : !((Object)this$parcela).equals(other$parcela)) {
            return false;
        }
        Long this$idDebitoParcela = this.getIdDebitoParcela();
        Long other$idDebitoParcela = other.getIdDebitoParcela();
        if (this$idDebitoParcela == null ? other$idDebitoParcela != null : !((Object)this$idDebitoParcela).equals(other$idDebitoParcela)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        return !(this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DebitoParcelaDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idDebito = this.getIdDebito();
        result = result * 59 + ($idDebito == null ? 43 : ((Object)$idDebito).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : ((Object)$divida).hashCode());
        Long $subdivida = this.getSubdivida();
        result = result * 59 + ($subdivida == null ? 43 : ((Object)$subdivida).hashCode());
        Long $parcela = this.getParcela();
        result = result * 59 + ($parcela == null ? 43 : ((Object)$parcela).hashCode());
        Long $idDebitoParcela = this.getIdDebitoParcela();
        result = result * 59 + ($idDebitoParcela == null ? 43 : ((Object)$idDebitoParcela).hashCode());
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DebitoParcelaDTO(idDebito=" + this.getIdDebito() + ", exercicio=" + this.getExercicio() + ", divida=" + this.getDivida() + ", subdivida=" + this.getSubdivida() + ", parcela=" + this.getParcela() + ", idDebitoParcela=" + this.getIdDebitoParcela() + ", valor=" + String.valueOf(this.getValor()) + ")";
    }
}

