/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.dto.AgrupamentoTributosDTO;
import br.com.elotech.tributos.dto.StatusPagamentoNegociado;
import br.com.elotech.tributos.dto.acrescimo.CalculaAcrescimoBaseDTO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public class DebitoPagamentoNegociadoDTO
extends CalculaAcrescimoBaseDTO
implements Cloneable {
    private BigDecimal valorAbatido = BigDecimal.ZERO;
    private BigDecimal valorRestante;
    private BigDecimal valorRestanteComAcrescimos;
    private StatusPagamentoNegociado status;
    private Long idDebitoParcelaReceita;
    private BigDecimal valorNovoDebito;
    private List<AgrupamentoTributosDTO> tributosAgrupados = new ArrayList();

    public <T extends CalculaAcrescimoBaseDTO> T add(T dto) {
        if (this.tributosAgrupados.isEmpty()) {
            this.tributosAgrupados.add(this.getBuild(this));
        }
        if (dto instanceof DebitoPagamentoNegociadoDTO) {
            this.tributosAgrupados.add(this.getBuild((DebitoPagamentoNegociadoDTO)dto));
        }
        return (T)super.internalAdd(dto);
    }

    private AgrupamentoTributosDTO getBuild(DebitoPagamentoNegociadoDTO dto) {
        return AgrupamentoTributosDTO.builder().idDebitoParcelaTributo(dto.getIdDebitoParcelaReceita()).valorPrincipal(dto.getValorPrincipal()).valorDescontoPrincipal(dto.getValorDescontoPrincipal()).valorCorrecao(dto.getValorCorrecao()).valorDescontoCorrecao(dto.getValorDescontoCorrecao()).valorJuros(dto.getValorJuros()).valorDescontoJuros(dto.getValorDescontoJuros()).valorMulta(dto.getValorMulta()).valorDescontoMulta(dto.getValorDescontoMulta()).valorDescontoJurosFinan(dto.getValorDescontoJurosFinan()).tributo(dto.getTributo()).build();
    }

    public DebitoPagamentoNegociadoDTO clone() {
        try {
            DebitoPagamentoNegociadoDTO clone = (DebitoPagamentoNegociadoDTO)super.clone();
            List tributosAgrupadosClone = clone.getTributosAgrupados().stream().map(element -> element.clone()).collect(Collectors.toList());
            clone.setTributosAgrupados(tributosAgrupadosClone);
            return clone;
        }
        catch (Exception ex) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel clonar o DebitoPagamentoNegociadoDTO");
        }
    }

    public BigDecimal getTotalNovoDebito() {
        return this.tributosAgrupados.isEmpty() ? this.valorNovoDebito : this.tributosAgrupados.stream().map(agrupamentoTributosDTO -> Optional.ofNullable(agrupamentoTributosDTO.getValorNovoDebito()).orElse(BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public BigDecimal getPercentualPrincipal() {
        return this.getValorTotal().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : this.getValorPrincipal().divide(this.getValorTotal(), 10, RoundingMode.HALF_EVEN);
    }

    public BigDecimal getPercentualBaixaParcial() {
        if (StatusPagamentoNegociado.TOTAL.equals((Object)this.getStatus())) {
            return BigDecimal.ONE;
        }
        return this.getValorTotal().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : this.getValorAbatido().divide(this.getValorTotal(), 10, RoundingMode.HALF_EVEN);
    }

    @Generated
    public DebitoPagamentoNegociadoDTO() {
    }

    @Generated
    public BigDecimal getValorAbatido() {
        return this.valorAbatido;
    }

    @Generated
    public BigDecimal getValorRestante() {
        return this.valorRestante;
    }

    @Generated
    public BigDecimal getValorRestanteComAcrescimos() {
        return this.valorRestanteComAcrescimos;
    }

    @Generated
    public StatusPagamentoNegociado getStatus() {
        return this.status;
    }

    @Generated
    public Long getIdDebitoParcelaReceita() {
        return this.idDebitoParcelaReceita;
    }

    @Generated
    public BigDecimal getValorNovoDebito() {
        return this.valorNovoDebito;
    }

    @Generated
    public List<AgrupamentoTributosDTO> getTributosAgrupados() {
        return this.tributosAgrupados;
    }

    @Generated
    public void setValorAbatido(BigDecimal valorAbatido) {
        this.valorAbatido = valorAbatido;
    }

    @Generated
    public void setValorRestante(BigDecimal valorRestante) {
        this.valorRestante = valorRestante;
    }

    @Generated
    public void setValorRestanteComAcrescimos(BigDecimal valorRestanteComAcrescimos) {
        this.valorRestanteComAcrescimos = valorRestanteComAcrescimos;
    }

    @Generated
    public void setStatus(StatusPagamentoNegociado status) {
        this.status = status;
    }

    @Generated
    public void setIdDebitoParcelaReceita(Long idDebitoParcelaReceita) {
        this.idDebitoParcelaReceita = idDebitoParcelaReceita;
    }

    @Generated
    public void setValorNovoDebito(BigDecimal valorNovoDebito) {
        this.valorNovoDebito = valorNovoDebito;
    }

    @Generated
    public void setTributosAgrupados(List<AgrupamentoTributosDTO> tributosAgrupados) {
        this.tributosAgrupados = tributosAgrupados;
    }

    @Generated
    public String toString() {
        return "DebitoPagamentoNegociadoDTO(valorAbatido=" + String.valueOf(this.getValorAbatido()) + ", valorRestante=" + String.valueOf(this.getValorRestante()) + ", valorRestanteComAcrescimos=" + String.valueOf(this.getValorRestanteComAcrescimos()) + ", status=" + String.valueOf(this.getStatus()) + ", idDebitoParcelaReceita=" + this.getIdDebitoParcelaReceita() + ", valorNovoDebito=" + String.valueOf(this.getValorNovoDebito()) + ", tributosAgrupados=" + String.valueOf(this.getTributosAgrupados()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebitoPagamentoNegociadoDTO)) {
            return false;
        }
        DebitoPagamentoNegociadoDTO other = (DebitoPagamentoNegociadoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idDebitoParcelaReceita = this.getIdDebitoParcelaReceita();
        Long other$idDebitoParcelaReceita = other.getIdDebitoParcelaReceita();
        if (this$idDebitoParcelaReceita == null ? other$idDebitoParcelaReceita != null : !((Object)this$idDebitoParcelaReceita).equals(other$idDebitoParcelaReceita)) {
            return false;
        }
        BigDecimal this$valorAbatido = this.getValorAbatido();
        BigDecimal other$valorAbatido = other.getValorAbatido();
        if (this$valorAbatido == null ? other$valorAbatido != null : !((Object)this$valorAbatido).equals(other$valorAbatido)) {
            return false;
        }
        BigDecimal this$valorRestante = this.getValorRestante();
        BigDecimal other$valorRestante = other.getValorRestante();
        if (this$valorRestante == null ? other$valorRestante != null : !((Object)this$valorRestante).equals(other$valorRestante)) {
            return false;
        }
        BigDecimal this$valorRestanteComAcrescimos = this.getValorRestanteComAcrescimos();
        BigDecimal other$valorRestanteComAcrescimos = other.getValorRestanteComAcrescimos();
        if (this$valorRestanteComAcrescimos == null ? other$valorRestanteComAcrescimos != null : !((Object)this$valorRestanteComAcrescimos).equals(other$valorRestanteComAcrescimos)) {
            return false;
        }
        StatusPagamentoNegociado this$status = this.getStatus();
        StatusPagamentoNegociado other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        BigDecimal this$valorNovoDebito = this.getValorNovoDebito();
        BigDecimal other$valorNovoDebito = other.getValorNovoDebito();
        if (this$valorNovoDebito == null ? other$valorNovoDebito != null : !((Object)this$valorNovoDebito).equals(other$valorNovoDebito)) {
            return false;
        }
        List this$tributosAgrupados = this.getTributosAgrupados();
        List other$tributosAgrupados = other.getTributosAgrupados();
        return !(this$tributosAgrupados == null ? other$tributosAgrupados != null : !((Object)this$tributosAgrupados).equals(other$tributosAgrupados));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DebitoPagamentoNegociadoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idDebitoParcelaReceita = this.getIdDebitoParcelaReceita();
        result = result * 59 + ($idDebitoParcelaReceita == null ? 43 : ((Object)$idDebitoParcelaReceita).hashCode());
        BigDecimal $valorAbatido = this.getValorAbatido();
        result = result * 59 + ($valorAbatido == null ? 43 : ((Object)$valorAbatido).hashCode());
        BigDecimal $valorRestante = this.getValorRestante();
        result = result * 59 + ($valorRestante == null ? 43 : ((Object)$valorRestante).hashCode());
        BigDecimal $valorRestanteComAcrescimos = this.getValorRestanteComAcrescimos();
        result = result * 59 + ($valorRestanteComAcrescimos == null ? 43 : ((Object)$valorRestanteComAcrescimos).hashCode());
        StatusPagamentoNegociado $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        BigDecimal $valorNovoDebito = this.getValorNovoDebito();
        result = result * 59 + ($valorNovoDebito == null ? 43 : ((Object)$valorNovoDebito).hashCode());
        List $tributosAgrupados = this.getTributosAgrupados();
        result = result * 59 + ($tributosAgrupados == null ? 43 : ((Object)$tributosAgrupados).hashCode());
        return result;
    }
}

