/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoProcesso;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.FormaCorrecao;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.projeto.TipoProjeto;
import br.com.elotech.tributos.dto.DebitoManualDTO;
import br.com.elotech.tributos.dto.DebitoManualObservacaoDTO;
import br.com.elotech.tributos.dto.DebitoManualParcelaDTO;
import br.com.elotech.tributos.dto.DebitoManualTributoDTO;
import br.com.elotech.tributos.dto.DebitoProjetoManualDTO;
import br.com.elotech.tributos.dto.GerarDebitoRequestDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class DebitoManualDTO {
    @NotNull(message="Exerc\u00edcio \u00e9 obrigat\u00f3rio")
    private @NotNull(message="Exerc\u00edcio \u00e9 obrigat\u00f3rio") Long exercicio;
    @NotNull(message="Tipo cadastro \u00e9 obrigat\u00f3rio")
    private @NotNull(message="Tipo cadastro \u00e9 obrigat\u00f3rio") TipoCadastro tipoCadastro;
    @NotNull(message="Cadastro \u00e9 obrigat\u00f3rio")
    private @NotNull(message="Cadastro \u00e9 obrigat\u00f3rio") Long cadastroGeral;
    @NotNull(message="D\u00edvida \u00e9 obrigat\u00f3ria")
    private @NotNull(message="D\u00edvida \u00e9 obrigat\u00f3ria") Long divida;
    @NotNull(message="Subdivida \u00e9 obrigat\u00f3ria")
    private @NotNull(message="Subdivida \u00e9 obrigat\u00f3ria") Long subDivida;
    @NotNull(message="Data de lan\u00e7amento \u00e9 obrigat\u00f3ria")
    private @NotNull(message="Data de lan\u00e7amento \u00e9 obrigat\u00f3ria") LocalDate dataLancamento;
    private LocalDate dataInclusao;
    @NotNull(message="Forma de corre\u00e7\u00e3o \u00e9 obrigat\u00f3ria")
    private @NotNull(message="Forma de corre\u00e7\u00e3o \u00e9 obrigat\u00f3ria") Long formaCorrecao;
    private String tipoDebito;
    private Long exercicioProcesso;
    private Long processo;
    private String programa;
    private Boolean validaPermissaoDivida;
    private Boolean constituiDebito;
    private String observacao;
    private String usuario;
    private BigDecimal percentualEntrada;
    private BigDecimal valorDescontoAuto;
    @NotEmpty(message="Informe ao menos uma parcela")
    private @NotEmpty(message="Informe ao menos uma parcela") List<DebitoManualParcelaDTO> parcelas;
    @NotEmpty(message="Informe ao menos um tributo")
    private @NotEmpty(message="Informe ao menos um tributo") List<DebitoManualTributoDTO> tributos;
    private List<DebitoManualObservacaoDTO> observacoes;

    public boolean constituiDebito() {
        return Boolean.TRUE.equals(this.constituiDebito);
    }

    public static DebitoManualDTO getDebitoNaoValidaPermissaoDivida() {
        DebitoManualDTO debitoManualDTO = new DebitoManualDTO();
        debitoManualDTO.setValidaPermissaoDivida(Boolean.FALSE);
        return debitoManualDTO;
    }

    public Debito toEntity(Long entidade, String usuario) {
        Debito debito = new Debito();
        debito.setEntidade(entidade);
        debito.setDataLancamento(this.getDataLancamento());
        debito.setDataInclusao(Optional.ofNullable(this.getDataInclusao()).orElse(LocalDate.now()));
        debito.setExercicio(this.getExercicio());
        if (Objects.nonNull(this.getTipoCadastro())) {
            debito.setTipoCadastro(this.getTipoCadastro().getValue());
        }
        debito.setCadastroGeralId(this.getCadastroGeral());
        debito.setGuiaRecolhimento(this.getDivida());
        debito.setSubDivida(this.getSubDivida());
        debito.setUsuario(usuario);
        debito.setDescontoLei2004(this.getValorDescontoAuto());
        if (Objects.nonNull(this.observacao)) {
            debito.setObservacao(this.observacao);
        }
        if (StringUtils.isBlank((String)this.getPrograma())) {
            debito.setPrograma("DebitoManual");
        } else {
            debito.setPrograma(this.programa);
        }
        if (Objects.nonNull(this.getProcesso())) {
            debito.getProcessos().add(DebitoProcesso.of((Long)this.getExercicioProcesso(), (Long)this.getProcesso(), (String)"Processo informado durante gera\u00e7\u00e3o de d\u00e9bito manual."));
        }
        if (Objects.nonNull(this.getTributos())) {
            this.getTributos().stream().map(DebitoManualTributoDTO::toEntity).forEach(debito.getTributos()::add);
        }
        if (Objects.nonNull(this.getParcelas())) {
            this.getParcelas().stream().map(parcela -> parcela.toEntity(usuario, debito.getDataLancamento())).forEach(debito.getParcelas()::add);
        }
        if (Objects.nonNull(this.getObservacoes())) {
            this.getObservacoes().stream().map(observacao -> observacao.toEntity(usuario)).forEach(debito.getObservacoes()::add);
        }
        return debito;
    }

    public static DebitoManualDTO from(GerarDebitoRequestDTO debito, Divida divida, Long subdivida, FormaCorrecao formaCorrecao) {
        DebitoManualDTO debitoManualDTO = new DebitoManualDTO();
        debitoManualDTO.setExercicio(debito.getExercicio());
        debitoManualDTO.setTipoCadastro(TipoCadastro.fromValue((Long)debito.getTipoCadastro()));
        debitoManualDTO.setCadastroGeral(debito.getCadastroGeral());
        debitoManualDTO.setDivida(divida.getDivida());
        debitoManualDTO.setSubDivida(subdivida);
        debitoManualDTO.setDataLancamento(debito.getDataLancamento());
        debitoManualDTO.setFormaCorrecao(formaCorrecao.getId());
        debitoManualDTO.setPrograma(debito.getTelaOrigemDebito());
        debitoManualDTO.setObservacao(debito.getObservacao());
        debitoManualDTO.setValidaPermissaoDivida(Boolean.FALSE);
        debitoManualDTO.setConstituiDebito(debito.getConstituiDebito());
        debitoManualDTO.getObservacoes().addAll(Optional.ofNullable(debito.getObservacoes()).orElse(Collections.emptyList()).stream().map(DebitoManualObservacaoDTO::of).toList());
        return debitoManualDTO;
    }

    public static DebitoManualDTO from(DebitoProjetoManualDTO debitoProjetoManualDTO, List<DebitoManualParcelaDTO> parcelaDTOS, List<DebitoManualTributoDTO> tributoDTOS, DebitoManualObservacaoDTO debitoManualObservacaoDTO, LocalDate dataAtual, TipoProjeto tipoProjeto) {
        DebitoManualDTO debitoManualDTO = new DebitoManualDTO();
        debitoManualDTO.setExercicio(debitoProjetoManualDTO.getExercicio());
        debitoManualDTO.setTipoCadastro(debitoProjetoManualDTO.getTipoCadastro());
        debitoManualDTO.setCadastroGeral(debitoProjetoManualDTO.getCadastroGeral());
        debitoManualDTO.setDivida(debitoProjetoManualDTO.getDivida());
        debitoManualDTO.setDataInclusao(dataAtual);
        debitoManualDTO.setDataLancamento(dataAtual);
        debitoManualDTO.setParcelas(parcelaDTOS);
        debitoManualDTO.setTributos(tributoDTOS);
        debitoManualDTO.getObservacoes().add(debitoManualObservacaoDTO);
        debitoManualDTO.setPercentualEntrada(Objects.nonNull(tipoProjeto) ? tipoProjeto.getPercentualDeEntrada() : BigDecimal.ZERO);
        return debitoManualDTO;
    }

    @Generated
    private static Boolean $default$validaPermissaoDivida() {
        return Boolean.TRUE;
    }

    @Generated
    private static Boolean $default$constituiDebito() {
        return Boolean.FALSE;
    }

    @Generated
    private static BigDecimal $default$valorDescontoAuto() {
        return BigDecimal.ZERO;
    }

    @Generated
    private static List<DebitoManualParcelaDTO> $default$parcelas() {
        return new ArrayList<DebitoManualParcelaDTO>();
    }

    @Generated
    private static List<DebitoManualTributoDTO> $default$tributos() {
        return new ArrayList<DebitoManualTributoDTO>();
    }

    @Generated
    private static List<DebitoManualObservacaoDTO> $default$observacoes() {
        return new ArrayList<DebitoManualObservacaoDTO>();
    }

    @Generated
    public static DebitoManualDTOBuilder builder() {
        return new DebitoManualDTOBuilder();
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getDivida() {
        return this.divida;
    }

    @Generated
    public Long getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public LocalDate getDataLancamento() {
        return this.dataLancamento;
    }

    @Generated
    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    @Generated
    public Long getFormaCorrecao() {
        return this.formaCorrecao;
    }

    @Generated
    public String getTipoDebito() {
        return this.tipoDebito;
    }

    @Generated
    public Long getExercicioProcesso() {
        return this.exercicioProcesso;
    }

    @Generated
    public Long getProcesso() {
        return this.processo;
    }

    @Generated
    public String getPrograma() {
        return this.programa;
    }

    @Generated
    public Boolean getValidaPermissaoDivida() {
        return this.validaPermissaoDivida;
    }

    @Generated
    public Boolean getConstituiDebito() {
        return this.constituiDebito;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public BigDecimal getPercentualEntrada() {
        return this.percentualEntrada;
    }

    @Generated
    public BigDecimal getValorDescontoAuto() {
        return this.valorDescontoAuto;
    }

    @Generated
    public List<DebitoManualParcelaDTO> getParcelas() {
        return this.parcelas;
    }

    @Generated
    public List<DebitoManualTributoDTO> getTributos() {
        return this.tributos;
    }

    @Generated
    public List<DebitoManualObservacaoDTO> getObservacoes() {
        return this.observacoes;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setDivida(Long divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(Long subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setDataLancamento(LocalDate dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    @Generated
    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    @Generated
    public void setFormaCorrecao(Long formaCorrecao) {
        this.formaCorrecao = formaCorrecao;
    }

    @Generated
    public void setTipoDebito(String tipoDebito) {
        this.tipoDebito = tipoDebito;
    }

    @Generated
    public void setExercicioProcesso(Long exercicioProcesso) {
        this.exercicioProcesso = exercicioProcesso;
    }

    @Generated
    public void setProcesso(Long processo) {
        this.processo = processo;
    }

    @Generated
    public void setPrograma(String programa) {
        this.programa = programa;
    }

    @Generated
    public void setValidaPermissaoDivida(Boolean validaPermissaoDivida) {
        this.validaPermissaoDivida = validaPermissaoDivida;
    }

    @Generated
    public void setConstituiDebito(Boolean constituiDebito) {
        this.constituiDebito = constituiDebito;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setPercentualEntrada(BigDecimal percentualEntrada) {
        this.percentualEntrada = percentualEntrada;
    }

    @Generated
    public void setValorDescontoAuto(BigDecimal valorDescontoAuto) {
        this.valorDescontoAuto = valorDescontoAuto;
    }

    @Generated
    public void setParcelas(List<DebitoManualParcelaDTO> parcelas) {
        this.parcelas = parcelas;
    }

    @Generated
    public void setTributos(List<DebitoManualTributoDTO> tributos) {
        this.tributos = tributos;
    }

    @Generated
    public void setObservacoes(List<DebitoManualObservacaoDTO> observacoes) {
        this.observacoes = observacoes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebitoManualDTO)) {
            return false;
        }
        DebitoManualDTO other = (DebitoManualDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$divida = this.getDivida();
        Long other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !((Object)this$divida).equals(other$divida)) {
            return false;
        }
        Long this$subDivida = this.getSubDivida();
        Long other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !((Object)this$subDivida).equals(other$subDivida)) {
            return false;
        }
        Long this$formaCorrecao = this.getFormaCorrecao();
        Long other$formaCorrecao = other.getFormaCorrecao();
        if (this$formaCorrecao == null ? other$formaCorrecao != null : !((Object)this$formaCorrecao).equals(other$formaCorrecao)) {
            return false;
        }
        Long this$exercicioProcesso = this.getExercicioProcesso();
        Long other$exercicioProcesso = other.getExercicioProcesso();
        if (this$exercicioProcesso == null ? other$exercicioProcesso != null : !((Object)this$exercicioProcesso).equals(other$exercicioProcesso)) {
            return false;
        }
        Long this$processo = this.getProcesso();
        Long other$processo = other.getProcesso();
        if (this$processo == null ? other$processo != null : !((Object)this$processo).equals(other$processo)) {
            return false;
        }
        Boolean this$validaPermissaoDivida = this.getValidaPermissaoDivida();
        Boolean other$validaPermissaoDivida = other.getValidaPermissaoDivida();
        if (this$validaPermissaoDivida == null ? other$validaPermissaoDivida != null : !((Object)this$validaPermissaoDivida).equals(other$validaPermissaoDivida)) {
            return false;
        }
        Boolean this$constituiDebito = this.getConstituiDebito();
        Boolean other$constituiDebito = other.getConstituiDebito();
        if (this$constituiDebito == null ? other$constituiDebito != null : !((Object)this$constituiDebito).equals(other$constituiDebito)) {
            return false;
        }
        TipoCadastro this$tipoCadastro = this.getTipoCadastro();
        TipoCadastro other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !this$tipoCadastro.equals(other$tipoCadastro)) {
            return false;
        }
        LocalDate this$dataLancamento = this.getDataLancamento();
        LocalDate other$dataLancamento = other.getDataLancamento();
        if (this$dataLancamento == null ? other$dataLancamento != null : !((Object)this$dataLancamento).equals(other$dataLancamento)) {
            return false;
        }
        LocalDate this$dataInclusao = this.getDataInclusao();
        LocalDate other$dataInclusao = other.getDataInclusao();
        if (this$dataInclusao == null ? other$dataInclusao != null : !((Object)this$dataInclusao).equals(other$dataInclusao)) {
            return false;
        }
        String this$tipoDebito = this.getTipoDebito();
        String other$tipoDebito = other.getTipoDebito();
        if (this$tipoDebito == null ? other$tipoDebito != null : !this$tipoDebito.equals(other$tipoDebito)) {
            return false;
        }
        String this$programa = this.getPrograma();
        String other$programa = other.getPrograma();
        if (this$programa == null ? other$programa != null : !this$programa.equals(other$programa)) {
            return false;
        }
        String this$observacao = this.getObservacao();
        String other$observacao = other.getObservacao();
        if (this$observacao == null ? other$observacao != null : !this$observacao.equals(other$observacao)) {
            return false;
        }
        String this$usuario = this.getUsuario();
        String other$usuario = other.getUsuario();
        if (this$usuario == null ? other$usuario != null : !this$usuario.equals(other$usuario)) {
            return false;
        }
        BigDecimal this$percentualEntrada = this.getPercentualEntrada();
        BigDecimal other$percentualEntrada = other.getPercentualEntrada();
        if (this$percentualEntrada == null ? other$percentualEntrada != null : !((Object)this$percentualEntrada).equals(other$percentualEntrada)) {
            return false;
        }
        BigDecimal this$valorDescontoAuto = this.getValorDescontoAuto();
        BigDecimal other$valorDescontoAuto = other.getValorDescontoAuto();
        if (this$valorDescontoAuto == null ? other$valorDescontoAuto != null : !((Object)this$valorDescontoAuto).equals(other$valorDescontoAuto)) {
            return false;
        }
        List this$parcelas = this.getParcelas();
        List other$parcelas = other.getParcelas();
        if (this$parcelas == null ? other$parcelas != null : !((Object)this$parcelas).equals(other$parcelas)) {
            return false;
        }
        List this$tributos = this.getTributos();
        List other$tributos = other.getTributos();
        if (this$tributos == null ? other$tributos != null : !((Object)this$tributos).equals(other$tributos)) {
            return false;
        }
        List this$observacoes = this.getObservacoes();
        List other$observacoes = other.getObservacoes();
        return !(this$observacoes == null ? other$observacoes != null : !((Object)this$observacoes).equals(other$observacoes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DebitoManualDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : ((Object)$divida).hashCode());
        Long $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : ((Object)$subDivida).hashCode());
        Long $formaCorrecao = this.getFormaCorrecao();
        result = result * 59 + ($formaCorrecao == null ? 43 : ((Object)$formaCorrecao).hashCode());
        Long $exercicioProcesso = this.getExercicioProcesso();
        result = result * 59 + ($exercicioProcesso == null ? 43 : ((Object)$exercicioProcesso).hashCode());
        Long $processo = this.getProcesso();
        result = result * 59 + ($processo == null ? 43 : ((Object)$processo).hashCode());
        Boolean $validaPermissaoDivida = this.getValidaPermissaoDivida();
        result = result * 59 + ($validaPermissaoDivida == null ? 43 : ((Object)$validaPermissaoDivida).hashCode());
        Boolean $constituiDebito = this.getConstituiDebito();
        result = result * 59 + ($constituiDebito == null ? 43 : ((Object)$constituiDebito).hashCode());
        TipoCadastro $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : $tipoCadastro.hashCode());
        LocalDate $dataLancamento = this.getDataLancamento();
        result = result * 59 + ($dataLancamento == null ? 43 : ((Object)$dataLancamento).hashCode());
        LocalDate $dataInclusao = this.getDataInclusao();
        result = result * 59 + ($dataInclusao == null ? 43 : ((Object)$dataInclusao).hashCode());
        String $tipoDebito = this.getTipoDebito();
        result = result * 59 + ($tipoDebito == null ? 43 : $tipoDebito.hashCode());
        String $programa = this.getPrograma();
        result = result * 59 + ($programa == null ? 43 : $programa.hashCode());
        String $observacao = this.getObservacao();
        result = result * 59 + ($observacao == null ? 43 : $observacao.hashCode());
        String $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : $usuario.hashCode());
        BigDecimal $percentualEntrada = this.getPercentualEntrada();
        result = result * 59 + ($percentualEntrada == null ? 43 : ((Object)$percentualEntrada).hashCode());
        BigDecimal $valorDescontoAuto = this.getValorDescontoAuto();
        result = result * 59 + ($valorDescontoAuto == null ? 43 : ((Object)$valorDescontoAuto).hashCode());
        List $parcelas = this.getParcelas();
        result = result * 59 + ($parcelas == null ? 43 : ((Object)$parcelas).hashCode());
        List $tributos = this.getTributos();
        result = result * 59 + ($tributos == null ? 43 : ((Object)$tributos).hashCode());
        List $observacoes = this.getObservacoes();
        result = result * 59 + ($observacoes == null ? 43 : ((Object)$observacoes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DebitoManualDTO(exercicio=" + this.getExercicio() + ", tipoCadastro=" + String.valueOf(this.getTipoCadastro()) + ", cadastroGeral=" + this.getCadastroGeral() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ", dataLancamento=" + String.valueOf(this.getDataLancamento()) + ", dataInclusao=" + String.valueOf(this.getDataInclusao()) + ", formaCorrecao=" + this.getFormaCorrecao() + ", tipoDebito=" + this.getTipoDebito() + ", exercicioProcesso=" + this.getExercicioProcesso() + ", processo=" + this.getProcesso() + ", programa=" + this.getPrograma() + ", validaPermissaoDivida=" + this.getValidaPermissaoDivida() + ", constituiDebito=" + this.getConstituiDebito() + ", observacao=" + this.getObservacao() + ", usuario=" + this.getUsuario() + ", percentualEntrada=" + String.valueOf(this.getPercentualEntrada()) + ", valorDescontoAuto=" + String.valueOf(this.getValorDescontoAuto()) + ", parcelas=" + String.valueOf(this.getParcelas()) + ", tributos=" + String.valueOf(this.getTributos()) + ", observacoes=" + String.valueOf(this.getObservacoes()) + ")";
    }

    @Generated
    public DebitoManualDTO() {
        this.validaPermissaoDivida = DebitoManualDTO.$default$validaPermissaoDivida();
        this.constituiDebito = DebitoManualDTO.$default$constituiDebito();
        this.valorDescontoAuto = DebitoManualDTO.$default$valorDescontoAuto();
        this.parcelas = DebitoManualDTO.$default$parcelas();
        this.tributos = DebitoManualDTO.$default$tributos();
        this.observacoes = DebitoManualDTO.$default$observacoes();
    }

    @Generated
    public DebitoManualDTO(Long exercicio, TipoCadastro tipoCadastro, Long cadastroGeral, Long divida, Long subDivida, LocalDate dataLancamento, LocalDate dataInclusao, Long formaCorrecao, String tipoDebito, Long exercicioProcesso, Long processo, String programa, Boolean validaPermissaoDivida, Boolean constituiDebito, String observacao, String usuario, BigDecimal percentualEntrada, BigDecimal valorDescontoAuto, List<DebitoManualParcelaDTO> parcelas, List<DebitoManualTributoDTO> tributos, List<DebitoManualObservacaoDTO> observacoes) {
        this.exercicio = exercicio;
        this.tipoCadastro = tipoCadastro;
        this.cadastroGeral = cadastroGeral;
        this.divida = divida;
        this.subDivida = subDivida;
        this.dataLancamento = dataLancamento;
        this.dataInclusao = dataInclusao;
        this.formaCorrecao = formaCorrecao;
        this.tipoDebito = tipoDebito;
        this.exercicioProcesso = exercicioProcesso;
        this.processo = processo;
        this.programa = programa;
        this.validaPermissaoDivida = validaPermissaoDivida;
        this.constituiDebito = constituiDebito;
        this.observacao = observacao;
        this.usuario = usuario;
        this.percentualEntrada = percentualEntrada;
        this.valorDescontoAuto = valorDescontoAuto;
        this.parcelas = parcelas;
        this.tributos = tributos;
        this.observacoes = observacoes;
    }
}

