/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.dto.DebitoPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.GerarDebitoResponseDTO;
import lombok.Generated;

public class DebitoIdDTO {
    private Long idDebito;
    private Long entidade;
    private Long exercicio;
    private Long tipoCadastro;
    private Long cadastroGeral;
    private Long divida;
    private Long subDivida;
    private Long idParcelamento;

    public static DebitoIdDTO of(Long idDebito, Long entidade, Long exercicio, Long tipoCadastro, Long cadastroGeral, Long divida, Long subDivida) {
        DebitoIdDTO debitoIdDTO = new DebitoIdDTO();
        debitoIdDTO.setIdDebito(idDebito);
        debitoIdDTO.setEntidade(entidade);
        debitoIdDTO.setExercicio(exercicio);
        debitoIdDTO.setTipoCadastro(tipoCadastro);
        debitoIdDTO.setCadastroGeral(cadastroGeral);
        debitoIdDTO.setDivida(divida);
        debitoIdDTO.setSubDivida(subDivida);
        return debitoIdDTO;
    }

    public static DebitoIdDTO from(Debito debito) {
        DebitoIdDTO debitoIdDTO = new DebitoIdDTO();
        debitoIdDTO.setIdDebito(debito.getId());
        debitoIdDTO.setEntidade(debito.getEntidade());
        debitoIdDTO.setExercicio(debito.getExercicio());
        debitoIdDTO.setTipoCadastro(debito.getTipoCadastro());
        debitoIdDTO.setCadastroGeral(debito.getCadastroGeralId());
        debitoIdDTO.setDivida(debito.getGuiaRecolhimento());
        debitoIdDTO.setSubDivida(debito.getSubDivida());
        return debitoIdDTO;
    }

    public static DebitoIdDTO from(DebitoParcela parcela) {
        DebitoIdDTO debitoIdDTO = new DebitoIdDTO();
        debitoIdDTO.setIdDebito(parcela.getDebito().getId());
        debitoIdDTO.setEntidade(parcela.getId().getEntidade());
        debitoIdDTO.setExercicio(parcela.getId().getExercicio());
        debitoIdDTO.setTipoCadastro(parcela.getId().getTipoCadastro());
        debitoIdDTO.setCadastroGeral(parcela.getId().getCadastroGeral());
        debitoIdDTO.setDivida(parcela.getId().getDivida());
        debitoIdDTO.setSubDivida(parcela.getId().getSubDivida());
        return debitoIdDTO;
    }

    public static DebitoIdDTO from(GerarDebitoResponseDTO dto) {
        DebitoIdDTO debitoIdDTO = new DebitoIdDTO();
        debitoIdDTO.setIdDebito(dto.getIdDebito());
        debitoIdDTO.setEntidade(dto.getEntidade());
        debitoIdDTO.setExercicio(dto.getExercicio());
        debitoIdDTO.setTipoCadastro(dto.getTipoCadastro());
        debitoIdDTO.setCadastroGeral(dto.getCadastroGeral());
        debitoIdDTO.setDivida(dto.getGuiaRecolhimento());
        debitoIdDTO.setSubDivida(dto.getSubDivida());
        return debitoIdDTO;
    }

    public static DebitoIdDTO from(DebitoPagamentoNegociadoDTO dto) {
        DebitoIdDTO debitoIdDTO = new DebitoIdDTO();
        debitoIdDTO.setIdDebito(dto.getIdDebito());
        debitoIdDTO.setEntidade(dto.getEntidade());
        debitoIdDTO.setExercicio(dto.getExercicio());
        debitoIdDTO.setTipoCadastro(dto.getTipoCadastro());
        debitoIdDTO.setCadastroGeral(dto.getCadastroGeral());
        debitoIdDTO.setDivida(dto.getDivida());
        debitoIdDTO.setSubDivida(dto.getSubDivida());
        return debitoIdDTO;
    }

    @Generated
    public DebitoIdDTO() {
    }

    @Generated
    public Long getIdDebito() {
        return this.idDebito;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getDivida() {
        return this.divida;
    }

    @Generated
    public Long getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public Long getIdParcelamento() {
        return this.idParcelamento;
    }

    @Generated
    public void setIdDebito(Long idDebito) {
        this.idDebito = idDebito;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setDivida(Long divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(Long subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setIdParcelamento(Long idParcelamento) {
        this.idParcelamento = idParcelamento;
    }

    @Generated
    public String toString() {
        return "DebitoIdDTO(idDebito=" + this.getIdDebito() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ", idParcelamento=" + this.getIdParcelamento() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebitoIdDTO)) {
            return false;
        }
        DebitoIdDTO other = (DebitoIdDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idDebito = this.getIdDebito();
        Long other$idDebito = other.getIdDebito();
        return !(this$idDebito == null ? other$idDebito != null : !((Object)this$idDebito).equals(other$idDebito));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DebitoIdDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idDebito = this.getIdDebito();
        result = result * 59 + ($idDebito == null ? 43 : ((Object)$idDebito).hashCode());
        return result;
    }
}

