/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.TipoSituacaoParcela;
import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebitoItem;
import br.com.elotech.tributos.dto.DebitoDTO;
import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.dto.acrescimo.CalculaAcrescimoBaseDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoDebitoParcelasDTO;
import br.com.elotech.tributos.util.SituacaoDebitoUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public class DebitoEmAbertoDTO
extends CalculaAcrescimoBaseDTO {
    private String descricaoDivida;
    private Long idDebitoParcelaReceita;
    private Boolean emiteBoleto;
    private String situacaoDebitoSigla;
    private String noProcessoComumUnica;
    private Long numeroParcelamento;
    private Long exercicioParcelamento;
    private Long idCertidao;
    private Long numeroCertidao;
    private Long exercicioCertidao;
    private Boolean constituido;
    private String identificadorCadastro;
    private Boolean oriundoEstornoContrato;
    private Long cartorio;
    private Boolean porContribuinte;
    private Boolean passivelRefis = Boolean.FALSE;
    private Boolean superSimples;
    private LocalDate dataLimiteVencimentoBoleto;

    public static DebitoEmAbertoDTO fromDebitoDto(DebitoDTO debitoDTO) {
        DebitoEmAbertoDTO dto = new DebitoEmAbertoDTO();
        dto.idDebito = debitoDTO.getIdDebito();
        dto.entidade = (long)debitoDTO.getEntidade();
        dto.exercicio = (long)debitoDTO.getExercicio();
        dto.divida = (long)debitoDTO.getGuiaRecolhimento();
        dto.descricaoDivida = debitoDTO.getDescricaoGuia();
        dto.subDivida = (long)debitoDTO.getSubDivida();
        dto.parcela = debitoDTO.getParcela();
        dto.tipoCadastro = (long)debitoDTO.getTipoCadastro();
        dto.cadastroGeral = (long)debitoDTO.getCadastroGeral();
        dto.dataLancamento = debitoDTO.getDataLancamento();
        dto.dataVencimento = debitoDTO.getVencimento();
        dto.emiteBoleto = debitoDTO.getEmiteBloqueto();
        dto.situacaoLegal = debitoDTO.getSituacaoLegal();
        dto.situacaoDebitoDescricao = "";
        dto.valorJuros = debitoDTO.getValorJuros();
        dto.valorMulta = debitoDTO.getValorMulta();
        dto.valorCorrecao = debitoDTO.getValorCorrecao();
        dto.valorPrincipal = debitoDTO.getValorPrincipal();
        dto.valorOriginalDebito = debitoDTO.getValor();
        dto.valorDescontoJuros = debitoDTO.getValorDescontoJuros();
        dto.valorDescontoMulta = debitoDTO.getValorDescontoMulta();
        dto.valorDescontoCorrecao = debitoDTO.getValorDescontoCorrecao();
        dto.valorDescontoPrincipal = debitoDTO.getValorDescontoPrincipal();
        dto.valorHonorario = debitoDTO.getValorHonorario();
        dto.idParcelamento = debitoDTO.getIdParcelamento();
        dto.numeroParcelamento = debitoDTO.getNumeroContrato();
        Optional.ofNullable(debitoDTO.getAnoContrato()).map(Long::valueOf).ifPresent(arg_0 -> dto.setExercicioParcelamento(arg_0));
        dto.descontoParcelamento = debitoDTO.getDescontoParcelamento();
        dto.descontoMultaParcelamento = debitoDTO.getDescontoMultaParcelamento();
        dto.descontoJurosParcelamento = debitoDTO.getDescontoJurosParcelamento();
        dto.descontoJurosFinanParcelamento = debitoDTO.getDescontoJurosFinanParcelamento();
        return dto;
    }

    public static DebitoEmAbertoDTO fromCancelamentoItem(CancelamentoDebitoItem cancelamentoDebitoItem) {
        DebitoParcelaTributo debitoParcelaTributo = cancelamentoDebitoItem.getId().getDebitoParcelaTributo();
        DebitoParcela debitoParcela = debitoParcelaTributo.getDebitoParcela();
        Debito debito = debitoParcela.getDebito();
        DebitoEmAbertoDTO dto = new DebitoEmAbertoDTO();
        dto.setEntidade(debito.getEntidade());
        dto.setExercicio(debito.getExercicio());
        dto.setTipoCadastro(debito.getTipoCadastro());
        dto.setCadastroGeral(debito.getCadastroGeralId());
        dto.setDivida(debito.getGuiaRecolhimento());
        dto.setSubDivida(debito.getSubDivida());
        dto.setParcela(debitoParcela.getId().getParcela());
        dto.setFormaCorrecao(debito.getFormaCorrecao().getId());
        dto.setDataLancamento(debitoParcela.getDataLancamento());
        dto.setDataVencimento(debitoParcela.getDataVencimento());
        dto.setDataCorrecaoIgpm(debito.getDataCorrecaoIgpm());
        dto.setDataPrimeiraParcela(debito.getDataPrimeiraParcela());
        dto.setSituacaoLegal(debitoParcela.getSituacaoLegal().getCodigo());
        dto.setParcelado(Boolean.valueOf(Objects.nonNull(debito.getIdParcelamento()) && debito.getIdParcelamento() > 0L));
        dto.setReparcelado(Boolean.valueOf(Objects.nonNull(debito.getIdReparcelamento()) && debito.getIdReparcelamento() > 0L));
        dto.setTributo(debitoParcelaTributo.getTributo());
        dto.setClassificacaoTributo(debitoParcelaTributo.getTributoEntity().getClassificacao().getValue());
        dto.setClassificacaoTipoTributo(Long.valueOf(debitoParcelaTributo.getTributoEntity().getTipoTributo().getClassificacaoTipoTributo().getValue()));
        dto.setIdDebitoParcelaReceita(debitoParcelaTributo.getId());
        dto.setValorPrincipal(cancelamentoDebitoItem.getValor());
        dto.setTipoSituacaoParcela(TipoSituacaoParcela.ABERTO.getValue());
        return dto;
    }

    public static List<DebitoEmAbertoDTO> from(List<ParcelamentoDebitoParcelasDTO> parcelasParcelamento, Long exercicio) {
        ArrayList<DebitoEmAbertoDTO> dtos = new ArrayList<DebitoEmAbertoDTO>();
        for (ParcelamentoDebitoParcelasDTO parcela : parcelasParcelamento) {
            DebitoEmAbertoDTO dto = new DebitoEmAbertoDTO();
            dto.setTipoSituacaoParcela(parcela.getTiposituacaoparcela());
            dto.entidade = parcela.getEntidade();
            dto.exercicio = exercicio;
            dto.parcela = parcela.getParcela();
            dto.tipoCadastro = parcela.getTipoCadastro();
            dto.cadastroGeral = parcela.getCadastroGeral();
            dto.dataVencimento = parcela.getDataVencimento();
            dto.emiteBoleto = Boolean.TRUE;
            dto.situacaoDebitoDescricao = "";
            dto.valorJuros = parcela.getValorJuros();
            dto.valorMulta = parcela.getValorMulta();
            dto.valorCorrecao = parcela.getValorCorrecao();
            dto.valorPrincipal = parcela.getValorTotal();
            dto.valorOriginalDebito = parcela.getValor();
            dtos.add(dto);
        }
        return dtos;
    }

    public BigDecimal getValorTotalDesconto() {
        return this.getValorDescontoPrincipal().add(this.getValorDescontoJuros()).add(this.getValorDescontoMulta()).add(this.getValorDescontoCorrecao()).add(this.getValorDescontoJurosFinan());
    }

    public Boolean getVencido() {
        return Optional.ofNullable(this.dataVencimento).map(arg_0 -> this.isExpired(arg_0)).orElse(false);
    }

    private Boolean isExpired(LocalDate dataVencimento) {
        return LocalDate.now().isAfter(dataVencimento);
    }

    public String getSituacaoSigla() {
        return SituacaoDebitoUtils.getSiglaSituacao((String)this.situacaoDebitoSigla, (SituacaoLegal)SituacaoLegal.fromValue((Integer)this.situacaoLegal), (Boolean)this.parcelado, (Boolean)this.reparcelado, (Boolean)this.getProtestado());
    }

    public Boolean isAjuizadoEletronicamente() {
        return Optional.ofNullable(this.noProcessoComumUnica).map(numeroProcesso -> !numeroProcesso.isEmpty()).orElse(false);
    }

    public <T extends CalculaAcrescimoBaseDTO> T add(T dto) {
        if (dto instanceof DebitoEmAbertoDTO) {
            DebitoEmAbertoDTO debitoEmAberto = (DebitoEmAbertoDTO)dto;
            Optional.ofNullable(debitoEmAberto.getIdCertidao()).ifPresent(arg_0 -> this.setIdCertidao(arg_0));
            Optional.ofNullable(debitoEmAberto.getNumeroCertidao()).ifPresent(arg_0 -> this.setNumeroCertidao(arg_0));
            Optional.ofNullable(debitoEmAberto.getExercicioCertidao()).ifPresent(arg_0 -> this.setExercicioCertidao(arg_0));
            this.passivelRefis = Boolean.TRUE.equals(this.passivelRefis) || Boolean.TRUE.equals(debitoEmAberto.getPassivelRefis());
        }
        return (T)super.internalAdd(dto);
    }

    public boolean isCompetenciaVencimentoEntre(LocalDate dataInicial, LocalDate dataFinal) {
        if (Objects.isNull(this.dataVencimento)) {
            return false;
        }
        int anoVencimento = this.dataVencimento.getYear();
        int mesVencimento = this.dataVencimento.getMonth().getValue();
        int anoInicial = dataInicial.getYear();
        int mesInicial = dataInicial.getMonth().getValue();
        int anoFinal = dataFinal.getYear();
        int mesFinal = dataFinal.getMonth().getValue();
        return anoVencimento >= anoInicial && mesVencimento >= mesInicial && anoVencimento <= anoFinal && mesVencimento <= mesFinal;
    }

    public boolean hasDataLimiteParaGeracaoBoleto() {
        return this.dataLimiteVencimentoBoleto != null;
    }

    @Generated
    public DebitoEmAbertoDTO() {
    }

    @Generated
    public String getDescricaoDivida() {
        return this.descricaoDivida;
    }

    @Generated
    public Long getIdDebitoParcelaReceita() {
        return this.idDebitoParcelaReceita;
    }

    @Generated
    public Boolean getEmiteBoleto() {
        return this.emiteBoleto;
    }

    @Generated
    public String getSituacaoDebitoSigla() {
        return this.situacaoDebitoSigla;
    }

    @Generated
    public String getNoProcessoComumUnica() {
        return this.noProcessoComumUnica;
    }

    @Generated
    public Long getNumeroParcelamento() {
        return this.numeroParcelamento;
    }

    @Generated
    public Long getExercicioParcelamento() {
        return this.exercicioParcelamento;
    }

    @Generated
    public Long getIdCertidao() {
        return this.idCertidao;
    }

    @Generated
    public Long getNumeroCertidao() {
        return this.numeroCertidao;
    }

    @Generated
    public Long getExercicioCertidao() {
        return this.exercicioCertidao;
    }

    @Generated
    public Boolean getConstituido() {
        return this.constituido;
    }

    @Generated
    public String getIdentificadorCadastro() {
        return this.identificadorCadastro;
    }

    @Generated
    public Boolean getOriundoEstornoContrato() {
        return this.oriundoEstornoContrato;
    }

    @Generated
    public Long getCartorio() {
        return this.cartorio;
    }

    @Generated
    public Boolean getPorContribuinte() {
        return this.porContribuinte;
    }

    @Generated
    public Boolean getPassivelRefis() {
        return this.passivelRefis;
    }

    @Generated
    public Boolean getSuperSimples() {
        return this.superSimples;
    }

    @Generated
    public LocalDate getDataLimiteVencimentoBoleto() {
        return this.dataLimiteVencimentoBoleto;
    }

    @Generated
    public void setDescricaoDivida(String descricaoDivida) {
        this.descricaoDivida = descricaoDivida;
    }

    @Generated
    public void setIdDebitoParcelaReceita(Long idDebitoParcelaReceita) {
        this.idDebitoParcelaReceita = idDebitoParcelaReceita;
    }

    @Generated
    public void setEmiteBoleto(Boolean emiteBoleto) {
        this.emiteBoleto = emiteBoleto;
    }

    @Generated
    public void setSituacaoDebitoSigla(String situacaoDebitoSigla) {
        this.situacaoDebitoSigla = situacaoDebitoSigla;
    }

    @Generated
    public void setNoProcessoComumUnica(String noProcessoComumUnica) {
        this.noProcessoComumUnica = noProcessoComumUnica;
    }

    @Generated
    public void setNumeroParcelamento(Long numeroParcelamento) {
        this.numeroParcelamento = numeroParcelamento;
    }

    @Generated
    public void setExercicioParcelamento(Long exercicioParcelamento) {
        this.exercicioParcelamento = exercicioParcelamento;
    }

    @Generated
    public void setIdCertidao(Long idCertidao) {
        this.idCertidao = idCertidao;
    }

    @Generated
    public void setNumeroCertidao(Long numeroCertidao) {
        this.numeroCertidao = numeroCertidao;
    }

    @Generated
    public void setExercicioCertidao(Long exercicioCertidao) {
        this.exercicioCertidao = exercicioCertidao;
    }

    @Generated
    public void setConstituido(Boolean constituido) {
        this.constituido = constituido;
    }

    @Generated
    public void setIdentificadorCadastro(String identificadorCadastro) {
        this.identificadorCadastro = identificadorCadastro;
    }

    @Generated
    public void setOriundoEstornoContrato(Boolean oriundoEstornoContrato) {
        this.oriundoEstornoContrato = oriundoEstornoContrato;
    }

    @Generated
    public void setCartorio(Long cartorio) {
        this.cartorio = cartorio;
    }

    @Generated
    public void setPorContribuinte(Boolean porContribuinte) {
        this.porContribuinte = porContribuinte;
    }

    @Generated
    public void setPassivelRefis(Boolean passivelRefis) {
        this.passivelRefis = passivelRefis;
    }

    @Generated
    public void setSuperSimples(Boolean superSimples) {
        this.superSimples = superSimples;
    }

    @Generated
    public void setDataLimiteVencimentoBoleto(LocalDate dataLimiteVencimentoBoleto) {
        this.dataLimiteVencimentoBoleto = dataLimiteVencimentoBoleto;
    }

    @Generated
    public String toString() {
        return "DebitoEmAbertoDTO(descricaoDivida=" + this.getDescricaoDivida() + ", idDebitoParcelaReceita=" + this.getIdDebitoParcelaReceita() + ", emiteBoleto=" + this.getEmiteBoleto() + ", situacaoDebitoSigla=" + this.getSituacaoDebitoSigla() + ", noProcessoComumUnica=" + this.getNoProcessoComumUnica() + ", numeroParcelamento=" + this.getNumeroParcelamento() + ", exercicioParcelamento=" + this.getExercicioParcelamento() + ", idCertidao=" + this.getIdCertidao() + ", numeroCertidao=" + this.getNumeroCertidao() + ", exercicioCertidao=" + this.getExercicioCertidao() + ", constituido=" + this.getConstituido() + ", identificadorCadastro=" + this.getIdentificadorCadastro() + ", oriundoEstornoContrato=" + this.getOriundoEstornoContrato() + ", cartorio=" + this.getCartorio() + ", porContribuinte=" + this.getPorContribuinte() + ", passivelRefis=" + this.getPassivelRefis() + ", superSimples=" + this.getSuperSimples() + ", dataLimiteVencimentoBoleto=" + String.valueOf(this.getDataLimiteVencimentoBoleto()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebitoEmAbertoDTO)) {
            return false;
        }
        DebitoEmAbertoDTO other = (DebitoEmAbertoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$idDebitoParcelaReceita = this.getIdDebitoParcelaReceita();
        Long other$idDebitoParcelaReceita = other.getIdDebitoParcelaReceita();
        if (this$idDebitoParcelaReceita == null ? other$idDebitoParcelaReceita != null : !((Object)this$idDebitoParcelaReceita).equals(other$idDebitoParcelaReceita)) {
            return false;
        }
        Boolean this$emiteBoleto = this.getEmiteBoleto();
        Boolean other$emiteBoleto = other.getEmiteBoleto();
        if (this$emiteBoleto == null ? other$emiteBoleto != null : !((Object)this$emiteBoleto).equals(other$emiteBoleto)) {
            return false;
        }
        Long this$numeroParcelamento = this.getNumeroParcelamento();
        Long other$numeroParcelamento = other.getNumeroParcelamento();
        if (this$numeroParcelamento == null ? other$numeroParcelamento != null : !((Object)this$numeroParcelamento).equals(other$numeroParcelamento)) {
            return false;
        }
        Long this$exercicioParcelamento = this.getExercicioParcelamento();
        Long other$exercicioParcelamento = other.getExercicioParcelamento();
        if (this$exercicioParcelamento == null ? other$exercicioParcelamento != null : !((Object)this$exercicioParcelamento).equals(other$exercicioParcelamento)) {
            return false;
        }
        Long this$idCertidao = this.getIdCertidao();
        Long other$idCertidao = other.getIdCertidao();
        if (this$idCertidao == null ? other$idCertidao != null : !((Object)this$idCertidao).equals(other$idCertidao)) {
            return false;
        }
        Long this$numeroCertidao = this.getNumeroCertidao();
        Long other$numeroCertidao = other.getNumeroCertidao();
        if (this$numeroCertidao == null ? other$numeroCertidao != null : !((Object)this$numeroCertidao).equals(other$numeroCertidao)) {
            return false;
        }
        Long this$exercicioCertidao = this.getExercicioCertidao();
        Long other$exercicioCertidao = other.getExercicioCertidao();
        if (this$exercicioCertidao == null ? other$exercicioCertidao != null : !((Object)this$exercicioCertidao).equals(other$exercicioCertidao)) {
            return false;
        }
        Boolean this$constituido = this.getConstituido();
        Boolean other$constituido = other.getConstituido();
        if (this$constituido == null ? other$constituido != null : !((Object)this$constituido).equals(other$constituido)) {
            return false;
        }
        Boolean this$oriundoEstornoContrato = this.getOriundoEstornoContrato();
        Boolean other$oriundoEstornoContrato = other.getOriundoEstornoContrato();
        if (this$oriundoEstornoContrato == null ? other$oriundoEstornoContrato != null : !((Object)this$oriundoEstornoContrato).equals(other$oriundoEstornoContrato)) {
            return false;
        }
        Long this$cartorio = this.getCartorio();
        Long other$cartorio = other.getCartorio();
        if (this$cartorio == null ? other$cartorio != null : !((Object)this$cartorio).equals(other$cartorio)) {
            return false;
        }
        Boolean this$porContribuinte = this.getPorContribuinte();
        Boolean other$porContribuinte = other.getPorContribuinte();
        if (this$porContribuinte == null ? other$porContribuinte != null : !((Object)this$porContribuinte).equals(other$porContribuinte)) {
            return false;
        }
        Boolean this$passivelRefis = this.getPassivelRefis();
        Boolean other$passivelRefis = other.getPassivelRefis();
        if (this$passivelRefis == null ? other$passivelRefis != null : !((Object)this$passivelRefis).equals(other$passivelRefis)) {
            return false;
        }
        Boolean this$superSimples = this.getSuperSimples();
        Boolean other$superSimples = other.getSuperSimples();
        if (this$superSimples == null ? other$superSimples != null : !((Object)this$superSimples).equals(other$superSimples)) {
            return false;
        }
        String this$descricaoDivida = this.getDescricaoDivida();
        String other$descricaoDivida = other.getDescricaoDivida();
        if (this$descricaoDivida == null ? other$descricaoDivida != null : !this$descricaoDivida.equals(other$descricaoDivida)) {
            return false;
        }
        String this$situacaoDebitoSigla = this.getSituacaoDebitoSigla();
        String other$situacaoDebitoSigla = other.getSituacaoDebitoSigla();
        if (this$situacaoDebitoSigla == null ? other$situacaoDebitoSigla != null : !this$situacaoDebitoSigla.equals(other$situacaoDebitoSigla)) {
            return false;
        }
        String this$noProcessoComumUnica = this.getNoProcessoComumUnica();
        String other$noProcessoComumUnica = other.getNoProcessoComumUnica();
        if (this$noProcessoComumUnica == null ? other$noProcessoComumUnica != null : !this$noProcessoComumUnica.equals(other$noProcessoComumUnica)) {
            return false;
        }
        String this$identificadorCadastro = this.getIdentificadorCadastro();
        String other$identificadorCadastro = other.getIdentificadorCadastro();
        if (this$identificadorCadastro == null ? other$identificadorCadastro != null : !this$identificadorCadastro.equals(other$identificadorCadastro)) {
            return false;
        }
        LocalDate this$dataLimiteVencimentoBoleto = this.getDataLimiteVencimentoBoleto();
        LocalDate other$dataLimiteVencimentoBoleto = other.getDataLimiteVencimentoBoleto();
        return !(this$dataLimiteVencimentoBoleto == null ? other$dataLimiteVencimentoBoleto != null : !((Object)this$dataLimiteVencimentoBoleto).equals(other$dataLimiteVencimentoBoleto));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DebitoEmAbertoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $idDebitoParcelaReceita = this.getIdDebitoParcelaReceita();
        result = result * 59 + ($idDebitoParcelaReceita == null ? 43 : ((Object)$idDebitoParcelaReceita).hashCode());
        Boolean $emiteBoleto = this.getEmiteBoleto();
        result = result * 59 + ($emiteBoleto == null ? 43 : ((Object)$emiteBoleto).hashCode());
        Long $numeroParcelamento = this.getNumeroParcelamento();
        result = result * 59 + ($numeroParcelamento == null ? 43 : ((Object)$numeroParcelamento).hashCode());
        Long $exercicioParcelamento = this.getExercicioParcelamento();
        result = result * 59 + ($exercicioParcelamento == null ? 43 : ((Object)$exercicioParcelamento).hashCode());
        Long $idCertidao = this.getIdCertidao();
        result = result * 59 + ($idCertidao == null ? 43 : ((Object)$idCertidao).hashCode());
        Long $numeroCertidao = this.getNumeroCertidao();
        result = result * 59 + ($numeroCertidao == null ? 43 : ((Object)$numeroCertidao).hashCode());
        Long $exercicioCertidao = this.getExercicioCertidao();
        result = result * 59 + ($exercicioCertidao == null ? 43 : ((Object)$exercicioCertidao).hashCode());
        Boolean $constituido = this.getConstituido();
        result = result * 59 + ($constituido == null ? 43 : ((Object)$constituido).hashCode());
        Boolean $oriundoEstornoContrato = this.getOriundoEstornoContrato();
        result = result * 59 + ($oriundoEstornoContrato == null ? 43 : ((Object)$oriundoEstornoContrato).hashCode());
        Long $cartorio = this.getCartorio();
        result = result * 59 + ($cartorio == null ? 43 : ((Object)$cartorio).hashCode());
        Boolean $porContribuinte = this.getPorContribuinte();
        result = result * 59 + ($porContribuinte == null ? 43 : ((Object)$porContribuinte).hashCode());
        Boolean $passivelRefis = this.getPassivelRefis();
        result = result * 59 + ($passivelRefis == null ? 43 : ((Object)$passivelRefis).hashCode());
        Boolean $superSimples = this.getSuperSimples();
        result = result * 59 + ($superSimples == null ? 43 : ((Object)$superSimples).hashCode());
        String $descricaoDivida = this.getDescricaoDivida();
        result = result * 59 + ($descricaoDivida == null ? 43 : $descricaoDivida.hashCode());
        String $situacaoDebitoSigla = this.getSituacaoDebitoSigla();
        result = result * 59 + ($situacaoDebitoSigla == null ? 43 : $situacaoDebitoSigla.hashCode());
        String $noProcessoComumUnica = this.getNoProcessoComumUnica();
        result = result * 59 + ($noProcessoComumUnica == null ? 43 : $noProcessoComumUnica.hashCode());
        String $identificadorCadastro = this.getIdentificadorCadastro();
        result = result * 59 + ($identificadorCadastro == null ? 43 : $identificadorCadastro.hashCode());
        LocalDate $dataLimiteVencimentoBoleto = this.getDataLimiteVencimentoBoleto();
        result = result * 59 + ($dataLimiteVencimentoBoleto == null ? 43 : ((Object)$dataLimiteVencimentoBoleto).hashCode());
        return result;
    }
}

