/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.fluent.dataset.DatasetRecord;
import br.com.elotech.tributos.domain.DocumentoPessoa;
import br.com.elotech.tributos.domain.protesto.Protesto;
import br.com.elotech.tributos.dto.CertidaoProtestoDTO;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.stream.Collectors;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class CertidaoProtestoDTO
implements DatasetRecord,
Serializable {
    private static final long serialVersionUID = 1L;
    private Long numeroProtesto;
    private Long anoProtesto;
    private Long numeroDocumento;
    private Long anoDocumento;
    private String dataEmissaoProtestoFormatada;
    private String pessoasTexto;
    private String dataEmissaoCertidaoFormatada;
    private String cidadeEmissao;

    public static CertidaoProtestoDTO from(Protesto protesto, String cidadeEmissao) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd 'de' MMMM 'de' yyyy", new Locale("pt", "BR"));
        String pessoasTexto = protesto.getDocumento().getDocumentoPessoas().stream().map(CertidaoProtestoDTO::formatarPessoa).collect(Collectors.joining(", "));
        return CertidaoProtestoDTO.builder().numeroProtesto(protesto.getProtesto()).anoProtesto(protesto.getExercicio()).numeroDocumento(protesto.getDocumento().getDocumento()).anoDocumento(protesto.getDocumento().getExercicio()).dataEmissaoProtestoFormatada(protesto.getDataEmissao() != null ? protesto.getDataEmissao().format(formatter) : "").pessoasTexto(pessoasTexto).dataEmissaoCertidaoFormatada(LocalDate.now().format(formatter)).cidadeEmissao(cidadeEmissao).build();
    }

    private static String formatarPessoa(DocumentoPessoa documentoPessoa) {
        String nome = documentoPessoa.getPessoa().getNome();
        String cpfCnpj = documentoPessoa.getPessoa().getCnpjCpf();
        if (TipoPessoa.FISICA.equals((Object)documentoPessoa.getPessoa().getTipoPessoa())) {
            return String.format("%s \u2013 CPF n\u00ba %s", nome, cpfCnpj);
        }
        return String.format("%s \u2013 CNPJ n\u00ba %s", nome, cpfCnpj);
    }

    @Generated
    public static CertidaoProtestoDTOBuilder builder() {
        return new CertidaoProtestoDTOBuilder();
    }

    @Generated
    public Long getNumeroProtesto() {
        return this.numeroProtesto;
    }

    @Generated
    public Long getAnoProtesto() {
        return this.anoProtesto;
    }

    @Generated
    public Long getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Generated
    public Long getAnoDocumento() {
        return this.anoDocumento;
    }

    @Generated
    public String getDataEmissaoProtestoFormatada() {
        return this.dataEmissaoProtestoFormatada;
    }

    @Generated
    public String getPessoasTexto() {
        return this.pessoasTexto;
    }

    @Generated
    public String getDataEmissaoCertidaoFormatada() {
        return this.dataEmissaoCertidaoFormatada;
    }

    @Generated
    public String getCidadeEmissao() {
        return this.cidadeEmissao;
    }

    @Generated
    public void setNumeroProtesto(Long numeroProtesto) {
        this.numeroProtesto = numeroProtesto;
    }

    @Generated
    public void setAnoProtesto(Long anoProtesto) {
        this.anoProtesto = anoProtesto;
    }

    @Generated
    public void setNumeroDocumento(Long numeroDocumento) {
        this.numeroDocumento = numeroDocumento;
    }

    @Generated
    public void setAnoDocumento(Long anoDocumento) {
        this.anoDocumento = anoDocumento;
    }

    @Generated
    public void setDataEmissaoProtestoFormatada(String dataEmissaoProtestoFormatada) {
        this.dataEmissaoProtestoFormatada = dataEmissaoProtestoFormatada;
    }

    @Generated
    public void setPessoasTexto(String pessoasTexto) {
        this.pessoasTexto = pessoasTexto;
    }

    @Generated
    public void setDataEmissaoCertidaoFormatada(String dataEmissaoCertidaoFormatada) {
        this.dataEmissaoCertidaoFormatada = dataEmissaoCertidaoFormatada;
    }

    @Generated
    public void setCidadeEmissao(String cidadeEmissao) {
        this.cidadeEmissao = cidadeEmissao;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CertidaoProtestoDTO)) {
            return false;
        }
        CertidaoProtestoDTO other = (CertidaoProtestoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$numeroProtesto = this.getNumeroProtesto();
        Long other$numeroProtesto = other.getNumeroProtesto();
        if (this$numeroProtesto == null ? other$numeroProtesto != null : !((Object)this$numeroProtesto).equals(other$numeroProtesto)) {
            return false;
        }
        Long this$anoProtesto = this.getAnoProtesto();
        Long other$anoProtesto = other.getAnoProtesto();
        if (this$anoProtesto == null ? other$anoProtesto != null : !((Object)this$anoProtesto).equals(other$anoProtesto)) {
            return false;
        }
        Long this$numeroDocumento = this.getNumeroDocumento();
        Long other$numeroDocumento = other.getNumeroDocumento();
        if (this$numeroDocumento == null ? other$numeroDocumento != null : !((Object)this$numeroDocumento).equals(other$numeroDocumento)) {
            return false;
        }
        Long this$anoDocumento = this.getAnoDocumento();
        Long other$anoDocumento = other.getAnoDocumento();
        if (this$anoDocumento == null ? other$anoDocumento != null : !((Object)this$anoDocumento).equals(other$anoDocumento)) {
            return false;
        }
        String this$dataEmissaoProtestoFormatada = this.getDataEmissaoProtestoFormatada();
        String other$dataEmissaoProtestoFormatada = other.getDataEmissaoProtestoFormatada();
        if (this$dataEmissaoProtestoFormatada == null ? other$dataEmissaoProtestoFormatada != null : !this$dataEmissaoProtestoFormatada.equals(other$dataEmissaoProtestoFormatada)) {
            return false;
        }
        String this$pessoasTexto = this.getPessoasTexto();
        String other$pessoasTexto = other.getPessoasTexto();
        if (this$pessoasTexto == null ? other$pessoasTexto != null : !this$pessoasTexto.equals(other$pessoasTexto)) {
            return false;
        }
        String this$dataEmissaoCertidaoFormatada = this.getDataEmissaoCertidaoFormatada();
        String other$dataEmissaoCertidaoFormatada = other.getDataEmissaoCertidaoFormatada();
        if (this$dataEmissaoCertidaoFormatada == null ? other$dataEmissaoCertidaoFormatada != null : !this$dataEmissaoCertidaoFormatada.equals(other$dataEmissaoCertidaoFormatada)) {
            return false;
        }
        String this$cidadeEmissao = this.getCidadeEmissao();
        String other$cidadeEmissao = other.getCidadeEmissao();
        return !(this$cidadeEmissao == null ? other$cidadeEmissao != null : !this$cidadeEmissao.equals(other$cidadeEmissao));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CertidaoProtestoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $numeroProtesto = this.getNumeroProtesto();
        result = result * 59 + ($numeroProtesto == null ? 43 : ((Object)$numeroProtesto).hashCode());
        Long $anoProtesto = this.getAnoProtesto();
        result = result * 59 + ($anoProtesto == null ? 43 : ((Object)$anoProtesto).hashCode());
        Long $numeroDocumento = this.getNumeroDocumento();
        result = result * 59 + ($numeroDocumento == null ? 43 : ((Object)$numeroDocumento).hashCode());
        Long $anoDocumento = this.getAnoDocumento();
        result = result * 59 + ($anoDocumento == null ? 43 : ((Object)$anoDocumento).hashCode());
        String $dataEmissaoProtestoFormatada = this.getDataEmissaoProtestoFormatada();
        result = result * 59 + ($dataEmissaoProtestoFormatada == null ? 43 : $dataEmissaoProtestoFormatada.hashCode());
        String $pessoasTexto = this.getPessoasTexto();
        result = result * 59 + ($pessoasTexto == null ? 43 : $pessoasTexto.hashCode());
        String $dataEmissaoCertidaoFormatada = this.getDataEmissaoCertidaoFormatada();
        result = result * 59 + ($dataEmissaoCertidaoFormatada == null ? 43 : $dataEmissaoCertidaoFormatada.hashCode());
        String $cidadeEmissao = this.getCidadeEmissao();
        result = result * 59 + ($cidadeEmissao == null ? 43 : $cidadeEmissao.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CertidaoProtestoDTO(numeroProtesto=" + this.getNumeroProtesto() + ", anoProtesto=" + this.getAnoProtesto() + ", numeroDocumento=" + this.getNumeroDocumento() + ", anoDocumento=" + this.getAnoDocumento() + ", dataEmissaoProtestoFormatada=" + this.getDataEmissaoProtestoFormatada() + ", pessoasTexto=" + this.getPessoasTexto() + ", dataEmissaoCertidaoFormatada=" + this.getDataEmissaoCertidaoFormatada() + ", cidadeEmissao=" + this.getCidadeEmissao() + ")";
    }

    @Generated
    public CertidaoProtestoDTO() {
    }

    @Generated
    public CertidaoProtestoDTO(Long numeroProtesto, Long anoProtesto, Long numeroDocumento, Long anoDocumento, String dataEmissaoProtestoFormatada, String pessoasTexto, String dataEmissaoCertidaoFormatada, String cidadeEmissao) {
        this.numeroProtesto = numeroProtesto;
        this.anoProtesto = anoProtesto;
        this.numeroDocumento = numeroDocumento;
        this.anoDocumento = anoDocumento;
        this.dataEmissaoProtestoFormatada = dataEmissaoProtestoFormatada;
        this.pessoasTexto = pessoasTexto;
        this.dataEmissaoCertidaoFormatada = dataEmissaoCertidaoFormatada;
        this.cidadeEmissao = cidadeEmissao;
    }
}

