/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.SituacaoMobiliario;
import br.com.elotech.tributos.domain.TipoSituacaoMobiliario;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import java.util.Optional;
import lombok.Generated;

public class CadastroMobiliarioRowDTO {
    private Long idCadastro;
    private Long cadastroGeral;
    private String cnpjCpf;
    private String pessoaNome;
    private String pessoaNomeFantasia;
    private String enderecoCompleto;
    private String situacaoAtual;
    private Long categoriaSituacaoAtual;

    public static CadastroMobiliarioRowDTO from(CadastroGeral cadastroGeral) {
        CadastroMobiliarioRowDTO dto = new CadastroMobiliarioRowDTO();
        dto.setIdCadastro(cadastroGeral.getId());
        dto.setCadastroGeral(cadastroGeral.getCadastroGeral());
        Optional.ofNullable(cadastroGeral.getPessoa()).ifPresent(pessoa -> {
            dto.setCnpjCpf(pessoa.getCnpjCpf());
            dto.setPessoaNome(pessoa.getNome());
            dto.setPessoaNomeFantasia(pessoa.getNomeFantasia());
        });
        Optional.ofNullable(cadastroGeral.getEnderecoFormatado()).ifPresent(arg_0 -> dto.setEnderecoCompleto(arg_0));
        if (cadastroGeral instanceof CadastroMobiliario) {
            CadastroMobiliario cadastroMobiliario = (CadastroMobiliario)cadastroGeral;
            Optional.ofNullable(cadastroMobiliario.getSituacaoAtual()).map(SituacaoMobiliario::getDescricao).ifPresent(arg_0 -> dto.setSituacaoAtual(arg_0));
            Optional.ofNullable(cadastroMobiliario.getSituacaoAtual()).map(SituacaoMobiliario::getTipoSituacaoMobiliario).map(TipoSituacaoMobiliario::getId).ifPresent(arg_0 -> dto.setCategoriaSituacaoAtual(arg_0));
        }
        return dto;
    }

    @Generated
    public CadastroMobiliarioRowDTO() {
    }

    @Generated
    public Long getIdCadastro() {
        return this.idCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getCnpjCpf() {
        return this.cnpjCpf;
    }

    @Generated
    public String getPessoaNome() {
        return this.pessoaNome;
    }

    @Generated
    public String getPessoaNomeFantasia() {
        return this.pessoaNomeFantasia;
    }

    @Generated
    public String getEnderecoCompleto() {
        return this.enderecoCompleto;
    }

    @Generated
    public String getSituacaoAtual() {
        return this.situacaoAtual;
    }

    @Generated
    public Long getCategoriaSituacaoAtual() {
        return this.categoriaSituacaoAtual;
    }

    @Generated
    public void setIdCadastro(Long idCadastro) {
        this.idCadastro = idCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setCnpjCpf(String cnpjCpf) {
        this.cnpjCpf = cnpjCpf;
    }

    @Generated
    public void setPessoaNome(String pessoaNome) {
        this.pessoaNome = pessoaNome;
    }

    @Generated
    public void setPessoaNomeFantasia(String pessoaNomeFantasia) {
        this.pessoaNomeFantasia = pessoaNomeFantasia;
    }

    @Generated
    public void setEnderecoCompleto(String enderecoCompleto) {
        this.enderecoCompleto = enderecoCompleto;
    }

    @Generated
    public void setSituacaoAtual(String situacaoAtual) {
        this.situacaoAtual = situacaoAtual;
    }

    @Generated
    public void setCategoriaSituacaoAtual(Long categoriaSituacaoAtual) {
        this.categoriaSituacaoAtual = categoriaSituacaoAtual;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroMobiliarioRowDTO)) {
            return false;
        }
        CadastroMobiliarioRowDTO other = (CadastroMobiliarioRowDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idCadastro = this.getIdCadastro();
        Long other$idCadastro = other.getIdCadastro();
        if (this$idCadastro == null ? other$idCadastro != null : !((Object)this$idCadastro).equals(other$idCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$categoriaSituacaoAtual = this.getCategoriaSituacaoAtual();
        Long other$categoriaSituacaoAtual = other.getCategoriaSituacaoAtual();
        if (this$categoriaSituacaoAtual == null ? other$categoriaSituacaoAtual != null : !((Object)this$categoriaSituacaoAtual).equals(other$categoriaSituacaoAtual)) {
            return false;
        }
        String this$cnpjCpf = this.getCnpjCpf();
        String other$cnpjCpf = other.getCnpjCpf();
        if (this$cnpjCpf == null ? other$cnpjCpf != null : !this$cnpjCpf.equals(other$cnpjCpf)) {
            return false;
        }
        String this$pessoaNome = this.getPessoaNome();
        String other$pessoaNome = other.getPessoaNome();
        if (this$pessoaNome == null ? other$pessoaNome != null : !this$pessoaNome.equals(other$pessoaNome)) {
            return false;
        }
        String this$pessoaNomeFantasia = this.getPessoaNomeFantasia();
        String other$pessoaNomeFantasia = other.getPessoaNomeFantasia();
        if (this$pessoaNomeFantasia == null ? other$pessoaNomeFantasia != null : !this$pessoaNomeFantasia.equals(other$pessoaNomeFantasia)) {
            return false;
        }
        String this$enderecoCompleto = this.getEnderecoCompleto();
        String other$enderecoCompleto = other.getEnderecoCompleto();
        if (this$enderecoCompleto == null ? other$enderecoCompleto != null : !this$enderecoCompleto.equals(other$enderecoCompleto)) {
            return false;
        }
        String this$situacaoAtual = this.getSituacaoAtual();
        String other$situacaoAtual = other.getSituacaoAtual();
        return !(this$situacaoAtual == null ? other$situacaoAtual != null : !this$situacaoAtual.equals(other$situacaoAtual));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroMobiliarioRowDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idCadastro = this.getIdCadastro();
        result = result * 59 + ($idCadastro == null ? 43 : ((Object)$idCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $categoriaSituacaoAtual = this.getCategoriaSituacaoAtual();
        result = result * 59 + ($categoriaSituacaoAtual == null ? 43 : ((Object)$categoriaSituacaoAtual).hashCode());
        String $cnpjCpf = this.getCnpjCpf();
        result = result * 59 + ($cnpjCpf == null ? 43 : $cnpjCpf.hashCode());
        String $pessoaNome = this.getPessoaNome();
        result = result * 59 + ($pessoaNome == null ? 43 : $pessoaNome.hashCode());
        String $pessoaNomeFantasia = this.getPessoaNomeFantasia();
        result = result * 59 + ($pessoaNomeFantasia == null ? 43 : $pessoaNomeFantasia.hashCode());
        String $enderecoCompleto = this.getEnderecoCompleto();
        result = result * 59 + ($enderecoCompleto == null ? 43 : $enderecoCompleto.hashCode());
        String $situacaoAtual = this.getSituacaoAtual();
        result = result * 59 + ($situacaoAtual == null ? 43 : $situacaoAtual.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CadastroMobiliarioRowDTO(idCadastro=" + this.getIdCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", cnpjCpf=" + this.getCnpjCpf() + ", pessoaNome=" + this.getPessoaNome() + ", pessoaNomeFantasia=" + this.getPessoaNomeFantasia() + ", enderecoCompleto=" + this.getEnderecoCompleto() + ", situacaoAtual=" + this.getSituacaoAtual() + ", categoriaSituacaoAtual=" + this.getCategoriaSituacaoAtual() + ")";
    }
}

