/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.BoletoDebito;
import br.com.elotech.tributos.domain.BoletoDebitoID;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public class BoletoRowResumoDTO
implements Serializable {
    private Long id;
    private Long entidade;
    private Long exercicio;
    private Long boleto;
    private String identificacao;
    private String tipoBoleto;
    private String siglaTipoBoleto;
    private Long parcela;
    private LocalDate dataEmissao;
    private LocalDate dataVencimento;
    private String nossoNumero;
    private Boolean possuiPix;
    private Boolean pago;
    private BigDecimal valorTotal = BigDecimal.ZERO;

    public static BoletoRowResumoDTO from(Bloqueto bloqueto) {
        return Optional.ofNullable(bloqueto).map(boleto -> {
            BoletoRowResumoDTO boletoDTO = new BoletoRowResumoDTO();
            boletoDTO.setId(boleto.getId());
            boletoDTO.setEntidade(boleto.getEntidade());
            boletoDTO.setExercicio(boleto.getExercicioBloqueto());
            boletoDTO.setBoleto(boleto.getBloqueto());
            boletoDTO.setIdentificacao(String.format("%d/%d", boletoDTO.getBoleto(), boletoDTO.getExercicio()));
            Optional.ofNullable(boleto.getTipoBloqueto()).ifPresent(tipo -> {
                boletoDTO.setTipoBoleto(String.format("%s - %s", tipo.getValue(), tipo.getDescricao()));
                boletoDTO.setSiglaTipoBoleto(tipo.getValue());
            });
            Optional.ofNullable(boleto.getDebitos()).ifPresent(debitos -> {
                Long parcela = debitos.stream().findFirst().map(BoletoDebito::getId).map(BoletoDebitoID::getDebitoParcelaTributo).map(DebitoParcelaTributo::getParcela).orElse(null);
                boletoDTO.setParcela(parcela);
            });
            boletoDTO.setDataEmissao(bloqueto.getDataEmissao());
            boletoDTO.setDataVencimento(bloqueto.getDataVencimento());
            boletoDTO.setNossoNumero(bloqueto.getNossoNumero());
            boletoDTO.setPossuiPix(Boolean.valueOf(Objects.nonNull(bloqueto.getTxidPix())));
            boletoDTO.setPago(bloqueto.getPago());
            boletoDTO.setValorTotal(bloqueto.getValorBloqueto());
            return boletoDTO;
        }).orElse(null);
    }

    @Generated
    public BoletoRowResumoDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getBoleto() {
        return this.boleto;
    }

    @Generated
    public String getIdentificacao() {
        return this.identificacao;
    }

    @Generated
    public String getTipoBoleto() {
        return this.tipoBoleto;
    }

    @Generated
    public String getSiglaTipoBoleto() {
        return this.siglaTipoBoleto;
    }

    @Generated
    public Long getParcela() {
        return this.parcela;
    }

    @Generated
    public LocalDate getDataEmissao() {
        return this.dataEmissao;
    }

    @Generated
    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public String getNossoNumero() {
        return this.nossoNumero;
    }

    @Generated
    public Boolean getPossuiPix() {
        return this.possuiPix;
    }

    @Generated
    public Boolean getPago() {
        return this.pago;
    }

    @Generated
    public BigDecimal getValorTotal() {
        return this.valorTotal;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setBoleto(Long boleto) {
        this.boleto = boleto;
    }

    @Generated
    public void setIdentificacao(String identificacao) {
        this.identificacao = identificacao;
    }

    @Generated
    public void setTipoBoleto(String tipoBoleto) {
        this.tipoBoleto = tipoBoleto;
    }

    @Generated
    public void setSiglaTipoBoleto(String siglaTipoBoleto) {
        this.siglaTipoBoleto = siglaTipoBoleto;
    }

    @Generated
    public void setParcela(Long parcela) {
        this.parcela = parcela;
    }

    @Generated
    public void setDataEmissao(LocalDate dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Generated
    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Generated
    public void setNossoNumero(String nossoNumero) {
        this.nossoNumero = nossoNumero;
    }

    @Generated
    public void setPossuiPix(Boolean possuiPix) {
        this.possuiPix = possuiPix;
    }

    @Generated
    public void setPago(Boolean pago) {
        this.pago = pago;
    }

    @Generated
    public void setValorTotal(BigDecimal valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BoletoRowResumoDTO)) {
            return false;
        }
        BoletoRowResumoDTO other = (BoletoRowResumoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$boleto = this.getBoleto();
        Long other$boleto = other.getBoleto();
        if (this$boleto == null ? other$boleto != null : !((Object)this$boleto).equals(other$boleto)) {
            return false;
        }
        Long this$parcela = this.getParcela();
        Long other$parcela = other.getParcela();
        if (this$parcela == null ? other$parcela != null : !((Object)this$parcela).equals(other$parcela)) {
            return false;
        }
        Boolean this$possuiPix = this.getPossuiPix();
        Boolean other$possuiPix = other.getPossuiPix();
        if (this$possuiPix == null ? other$possuiPix != null : !((Object)this$possuiPix).equals(other$possuiPix)) {
            return false;
        }
        Boolean this$pago = this.getPago();
        Boolean other$pago = other.getPago();
        if (this$pago == null ? other$pago != null : !((Object)this$pago).equals(other$pago)) {
            return false;
        }
        String this$identificacao = this.getIdentificacao();
        String other$identificacao = other.getIdentificacao();
        if (this$identificacao == null ? other$identificacao != null : !this$identificacao.equals(other$identificacao)) {
            return false;
        }
        String this$tipoBoleto = this.getTipoBoleto();
        String other$tipoBoleto = other.getTipoBoleto();
        if (this$tipoBoleto == null ? other$tipoBoleto != null : !this$tipoBoleto.equals(other$tipoBoleto)) {
            return false;
        }
        String this$siglaTipoBoleto = this.getSiglaTipoBoleto();
        String other$siglaTipoBoleto = other.getSiglaTipoBoleto();
        if (this$siglaTipoBoleto == null ? other$siglaTipoBoleto != null : !this$siglaTipoBoleto.equals(other$siglaTipoBoleto)) {
            return false;
        }
        LocalDate this$dataEmissao = this.getDataEmissao();
        LocalDate other$dataEmissao = other.getDataEmissao();
        if (this$dataEmissao == null ? other$dataEmissao != null : !((Object)this$dataEmissao).equals(other$dataEmissao)) {
            return false;
        }
        LocalDate this$dataVencimento = this.getDataVencimento();
        LocalDate other$dataVencimento = other.getDataVencimento();
        if (this$dataVencimento == null ? other$dataVencimento != null : !((Object)this$dataVencimento).equals(other$dataVencimento)) {
            return false;
        }
        String this$nossoNumero = this.getNossoNumero();
        String other$nossoNumero = other.getNossoNumero();
        if (this$nossoNumero == null ? other$nossoNumero != null : !this$nossoNumero.equals(other$nossoNumero)) {
            return false;
        }
        BigDecimal this$valorTotal = this.getValorTotal();
        BigDecimal other$valorTotal = other.getValorTotal();
        return !(this$valorTotal == null ? other$valorTotal != null : !((Object)this$valorTotal).equals(other$valorTotal));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BoletoRowResumoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $boleto = this.getBoleto();
        result = result * 59 + ($boleto == null ? 43 : ((Object)$boleto).hashCode());
        Long $parcela = this.getParcela();
        result = result * 59 + ($parcela == null ? 43 : ((Object)$parcela).hashCode());
        Boolean $possuiPix = this.getPossuiPix();
        result = result * 59 + ($possuiPix == null ? 43 : ((Object)$possuiPix).hashCode());
        Boolean $pago = this.getPago();
        result = result * 59 + ($pago == null ? 43 : ((Object)$pago).hashCode());
        String $identificacao = this.getIdentificacao();
        result = result * 59 + ($identificacao == null ? 43 : $identificacao.hashCode());
        String $tipoBoleto = this.getTipoBoleto();
        result = result * 59 + ($tipoBoleto == null ? 43 : $tipoBoleto.hashCode());
        String $siglaTipoBoleto = this.getSiglaTipoBoleto();
        result = result * 59 + ($siglaTipoBoleto == null ? 43 : $siglaTipoBoleto.hashCode());
        LocalDate $dataEmissao = this.getDataEmissao();
        result = result * 59 + ($dataEmissao == null ? 43 : ((Object)$dataEmissao).hashCode());
        LocalDate $dataVencimento = this.getDataVencimento();
        result = result * 59 + ($dataVencimento == null ? 43 : ((Object)$dataVencimento).hashCode());
        String $nossoNumero = this.getNossoNumero();
        result = result * 59 + ($nossoNumero == null ? 43 : $nossoNumero.hashCode());
        BigDecimal $valorTotal = this.getValorTotal();
        result = result * 59 + ($valorTotal == null ? 43 : ((Object)$valorTotal).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BoletoRowResumoDTO(id=" + this.getId() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", boleto=" + this.getBoleto() + ", identificacao=" + this.getIdentificacao() + ", tipoBoleto=" + this.getTipoBoleto() + ", siglaTipoBoleto=" + this.getSiglaTipoBoleto() + ", parcela=" + this.getParcela() + ", dataEmissao=" + String.valueOf(this.getDataEmissao()) + ", dataVencimento=" + String.valueOf(this.getDataVencimento()) + ", nossoNumero=" + this.getNossoNumero() + ", possuiPix=" + this.getPossuiPix() + ", pago=" + this.getPago() + ", valorTotal=" + String.valueOf(this.getValorTotal()) + ")";
    }
}

