/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.core.exception.EloValidationException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public class ArrecadacaoPorDadosCadastraisFiltros {
    private LocalDate dataPagamentoInicial;
    private LocalDate dataPagamentoFinal;
    private LocalDate dataCreditoInicial;
    private LocalDate dataCreditoFinal;
    private Long lotePagamento;
    private Long tipoTributo;
    private Long tributo;
    private Long divida;
    private Long banco;
    private Long contribuinte;
    private Long tipoCadastro;
    private Long cadastroGeral;
    private String setor;
    private String quadra;
    private String lote;
    private Long logradouro;
    private Long bairro;

    public void validaDatas() {
        if (Objects.nonNull(this.dataPagamentoInicial) && Objects.nonNull(this.dataPagamentoFinal) && this.dataPagamentoInicial.isAfter(this.dataPagamentoFinal)) {
            throw new EloValidationException("Intervalo de datas de pagamento inv\u00e1lido, favor corrija para prosseguir.");
        }
        if (Objects.nonNull(this.dataCreditoInicial) && Objects.nonNull(this.dataCreditoFinal) && this.dataCreditoInicial.isAfter(this.dataCreditoFinal)) {
            throw new EloValidationException("Intervalo de datas de Cr\u00e9dito inv\u00e1lido, favor corrija para prosseguir.");
        }
    }

    public String getWhereClausesWithValues() {
        ArrayList whereClauses = new ArrayList();
        Optional.ofNullable(this.dataPagamentoInicial).ifPresent(dataPagamentoInicial -> whereClauses.add(String.format("tp.datapagamento >= '%s'", dataPagamentoInicial)));
        Optional.ofNullable(this.dataPagamentoFinal).ifPresent(dataPagamentoFinal -> whereClauses.add(String.format("tp.datapagamento <= '%s'", dataPagamentoFinal)));
        Optional.ofNullable(this.dataCreditoInicial).ifPresent(dataCreditoInicial -> whereClauses.add(String.format("tp.datalancamento >= '%s'", dataCreditoInicial)));
        Optional.ofNullable(this.dataCreditoFinal).ifPresent(dataCreditoFinal -> whereClauses.add(String.format("tp.datalancamento <= '%s'", dataCreditoFinal)));
        Optional.ofNullable(this.lotePagamento).ifPresent(lotePagamento -> whereClauses.add(String.format("tp.lote = %s", lotePagamento)));
        Optional.ofNullable(this.cadastroGeral).ifPresent(cadastroGeral -> whereClauses.add(String.format("tcg.cadastrogeral = %s", cadastroGeral)));
        Optional.ofNullable(this.contribuinte).ifPresent(contribuinte -> whereClauses.add(String.format("pessoa.pessoa = %s", contribuinte)));
        Optional.ofNullable(this.tipoCadastro).ifPresent(tipoCadastro -> whereClauses.add(String.format("tcg.tipocadastro = %s", tipoCadastro)));
        Optional.ofNullable(this.tipoTributo).ifPresent(tipoTributo -> whereClauses.add(String.format("tr.tiporeceita = %s", tipoTributo)));
        Optional.ofNullable(this.logradouro).ifPresent(logradouro -> whereClauses.add(String.format("tcg.logradouro = %s", logradouro)));
        Optional.ofNullable(this.tributo).ifPresent(tributo -> whereClauses.add(String.format("tr.id = %s", tributo)));
        Optional.ofNullable(this.bairro).ifPresent(bairro -> whereClauses.add(String.format("bairro.bairro = %s", bairro)));
        Optional.ofNullable(this.divida).ifPresent(divida -> whereClauses.add(String.format("tdpr.guiarecolhimento = %s", divida)));
        Optional.ofNullable(this.quadra).ifPresent(quadra -> whereClauses.add(String.format("tribsetorquadra.quadra = '%s'", quadra)));
        Optional.ofNullable(this.banco).ifPresent(banco -> whereClauses.add(String.format("cb.banco = %s", banco)));
        Optional.ofNullable(this.setor).ifPresent(setor -> whereClauses.add(String.format("tribsetor.setor = '%s'", setor)));
        Optional.ofNullable(this.lote).ifPresent(lote -> whereClauses.add(String.format("tci.lote_inscricaocadastral = '%s'", lote)));
        return String.join((CharSequence)" \n AND ", whereClauses);
    }

    @Generated
    public ArrecadacaoPorDadosCadastraisFiltros() {
    }

    @Generated
    public LocalDate getDataPagamentoInicial() {
        return this.dataPagamentoInicial;
    }

    @Generated
    public LocalDate getDataPagamentoFinal() {
        return this.dataPagamentoFinal;
    }

    @Generated
    public LocalDate getDataCreditoInicial() {
        return this.dataCreditoInicial;
    }

    @Generated
    public LocalDate getDataCreditoFinal() {
        return this.dataCreditoFinal;
    }

    @Generated
    public Long getLotePagamento() {
        return this.lotePagamento;
    }

    @Generated
    public Long getTipoTributo() {
        return this.tipoTributo;
    }

    @Generated
    public Long getTributo() {
        return this.tributo;
    }

    @Generated
    public Long getDivida() {
        return this.divida;
    }

    @Generated
    public Long getBanco() {
        return this.banco;
    }

    @Generated
    public Long getContribuinte() {
        return this.contribuinte;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getSetor() {
        return this.setor;
    }

    @Generated
    public String getQuadra() {
        return this.quadra;
    }

    @Generated
    public String getLote() {
        return this.lote;
    }

    @Generated
    public Long getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public Long getBairro() {
        return this.bairro;
    }

    @Generated
    public void setDataPagamentoInicial(LocalDate dataPagamentoInicial) {
        this.dataPagamentoInicial = dataPagamentoInicial;
    }

    @Generated
    public void setDataPagamentoFinal(LocalDate dataPagamentoFinal) {
        this.dataPagamentoFinal = dataPagamentoFinal;
    }

    @Generated
    public void setDataCreditoInicial(LocalDate dataCreditoInicial) {
        this.dataCreditoInicial = dataCreditoInicial;
    }

    @Generated
    public void setDataCreditoFinal(LocalDate dataCreditoFinal) {
        this.dataCreditoFinal = dataCreditoFinal;
    }

    @Generated
    public void setLotePagamento(Long lotePagamento) {
        this.lotePagamento = lotePagamento;
    }

    @Generated
    public void setTipoTributo(Long tipoTributo) {
        this.tipoTributo = tipoTributo;
    }

    @Generated
    public void setTributo(Long tributo) {
        this.tributo = tributo;
    }

    @Generated
    public void setDivida(Long divida) {
        this.divida = divida;
    }

    @Generated
    public void setBanco(Long banco) {
        this.banco = banco;
    }

    @Generated
    public void setContribuinte(Long contribuinte) {
        this.contribuinte = contribuinte;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setSetor(String setor) {
        this.setor = setor;
    }

    @Generated
    public void setQuadra(String quadra) {
        this.quadra = quadra;
    }

    @Generated
    public void setLote(String lote) {
        this.lote = lote;
    }

    @Generated
    public void setLogradouro(Long logradouro) {
        this.logradouro = logradouro;
    }

    @Generated
    public void setBairro(Long bairro) {
        this.bairro = bairro;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArrecadacaoPorDadosCadastraisFiltros)) {
            return false;
        }
        ArrecadacaoPorDadosCadastraisFiltros other = (ArrecadacaoPorDadosCadastraisFiltros)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$lotePagamento = this.getLotePagamento();
        Long other$lotePagamento = other.getLotePagamento();
        if (this$lotePagamento == null ? other$lotePagamento != null : !((Object)this$lotePagamento).equals(other$lotePagamento)) {
            return false;
        }
        Long this$tipoTributo = this.getTipoTributo();
        Long other$tipoTributo = other.getTipoTributo();
        if (this$tipoTributo == null ? other$tipoTributo != null : !((Object)this$tipoTributo).equals(other$tipoTributo)) {
            return false;
        }
        Long this$tributo = this.getTributo();
        Long other$tributo = other.getTributo();
        if (this$tributo == null ? other$tributo != null : !((Object)this$tributo).equals(other$tributo)) {
            return false;
        }
        Long this$divida = this.getDivida();
        Long other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !((Object)this$divida).equals(other$divida)) {
            return false;
        }
        Long this$banco = this.getBanco();
        Long other$banco = other.getBanco();
        if (this$banco == null ? other$banco != null : !((Object)this$banco).equals(other$banco)) {
            return false;
        }
        Long this$contribuinte = this.getContribuinte();
        Long other$contribuinte = other.getContribuinte();
        if (this$contribuinte == null ? other$contribuinte != null : !((Object)this$contribuinte).equals(other$contribuinte)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$logradouro = this.getLogradouro();
        Long other$logradouro = other.getLogradouro();
        if (this$logradouro == null ? other$logradouro != null : !((Object)this$logradouro).equals(other$logradouro)) {
            return false;
        }
        Long this$bairro = this.getBairro();
        Long other$bairro = other.getBairro();
        if (this$bairro == null ? other$bairro != null : !((Object)this$bairro).equals(other$bairro)) {
            return false;
        }
        LocalDate this$dataPagamentoInicial = this.getDataPagamentoInicial();
        LocalDate other$dataPagamentoInicial = other.getDataPagamentoInicial();
        if (this$dataPagamentoInicial == null ? other$dataPagamentoInicial != null : !((Object)this$dataPagamentoInicial).equals(other$dataPagamentoInicial)) {
            return false;
        }
        LocalDate this$dataPagamentoFinal = this.getDataPagamentoFinal();
        LocalDate other$dataPagamentoFinal = other.getDataPagamentoFinal();
        if (this$dataPagamentoFinal == null ? other$dataPagamentoFinal != null : !((Object)this$dataPagamentoFinal).equals(other$dataPagamentoFinal)) {
            return false;
        }
        LocalDate this$dataCreditoInicial = this.getDataCreditoInicial();
        LocalDate other$dataCreditoInicial = other.getDataCreditoInicial();
        if (this$dataCreditoInicial == null ? other$dataCreditoInicial != null : !((Object)this$dataCreditoInicial).equals(other$dataCreditoInicial)) {
            return false;
        }
        LocalDate this$dataCreditoFinal = this.getDataCreditoFinal();
        LocalDate other$dataCreditoFinal = other.getDataCreditoFinal();
        if (this$dataCreditoFinal == null ? other$dataCreditoFinal != null : !((Object)this$dataCreditoFinal).equals(other$dataCreditoFinal)) {
            return false;
        }
        String this$setor = this.getSetor();
        String other$setor = other.getSetor();
        if (this$setor == null ? other$setor != null : !this$setor.equals(other$setor)) {
            return false;
        }
        String this$quadra = this.getQuadra();
        String other$quadra = other.getQuadra();
        if (this$quadra == null ? other$quadra != null : !this$quadra.equals(other$quadra)) {
            return false;
        }
        String this$lote = this.getLote();
        String other$lote = other.getLote();
        return !(this$lote == null ? other$lote != null : !this$lote.equals(other$lote));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ArrecadacaoPorDadosCadastraisFiltros;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $lotePagamento = this.getLotePagamento();
        result = result * 59 + ($lotePagamento == null ? 43 : ((Object)$lotePagamento).hashCode());
        Long $tipoTributo = this.getTipoTributo();
        result = result * 59 + ($tipoTributo == null ? 43 : ((Object)$tipoTributo).hashCode());
        Long $tributo = this.getTributo();
        result = result * 59 + ($tributo == null ? 43 : ((Object)$tributo).hashCode());
        Long $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : ((Object)$divida).hashCode());
        Long $banco = this.getBanco();
        result = result * 59 + ($banco == null ? 43 : ((Object)$banco).hashCode());
        Long $contribuinte = this.getContribuinte();
        result = result * 59 + ($contribuinte == null ? 43 : ((Object)$contribuinte).hashCode());
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $logradouro = this.getLogradouro();
        result = result * 59 + ($logradouro == null ? 43 : ((Object)$logradouro).hashCode());
        Long $bairro = this.getBairro();
        result = result * 59 + ($bairro == null ? 43 : ((Object)$bairro).hashCode());
        LocalDate $dataPagamentoInicial = this.getDataPagamentoInicial();
        result = result * 59 + ($dataPagamentoInicial == null ? 43 : ((Object)$dataPagamentoInicial).hashCode());
        LocalDate $dataPagamentoFinal = this.getDataPagamentoFinal();
        result = result * 59 + ($dataPagamentoFinal == null ? 43 : ((Object)$dataPagamentoFinal).hashCode());
        LocalDate $dataCreditoInicial = this.getDataCreditoInicial();
        result = result * 59 + ($dataCreditoInicial == null ? 43 : ((Object)$dataCreditoInicial).hashCode());
        LocalDate $dataCreditoFinal = this.getDataCreditoFinal();
        result = result * 59 + ($dataCreditoFinal == null ? 43 : ((Object)$dataCreditoFinal).hashCode());
        String $setor = this.getSetor();
        result = result * 59 + ($setor == null ? 43 : $setor.hashCode());
        String $quadra = this.getQuadra();
        result = result * 59 + ($quadra == null ? 43 : $quadra.hashCode());
        String $lote = this.getLote();
        result = result * 59 + ($lote == null ? 43 : $lote.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ArrecadacaoPorDadosCadastraisFiltros(dataPagamentoInicial=" + String.valueOf(this.getDataPagamentoInicial()) + ", dataPagamentoFinal=" + String.valueOf(this.getDataPagamentoFinal()) + ", dataCreditoInicial=" + String.valueOf(this.getDataCreditoInicial()) + ", dataCreditoFinal=" + String.valueOf(this.getDataCreditoFinal()) + ", lotePagamento=" + this.getLotePagamento() + ", tipoTributo=" + this.getTipoTributo() + ", tributo=" + this.getTributo() + ", divida=" + this.getDivida() + ", banco=" + this.getBanco() + ", contribuinte=" + this.getContribuinte() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", setor=" + this.getSetor() + ", quadra=" + this.getQuadra() + ", lote=" + this.getLote() + ", logradouro=" + this.getLogradouro() + ", bairro=" + this.getBairro() + ")";
    }
}

