/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.transferenciadebito;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.parcelamento.Parcelamento;
import br.com.elotech.tributos.domain.transferenciadebito.TransferenciaDebito;
import br.com.elotech.tributos.domain.transferenciadebito.TransferenciaDebitoItem;
import br.com.elotech.tributos.domain.transferenciadebito.id.TransferenciaDebitoItemId;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="tribtransferenciadebitoitem")
public class TransferenciaDebitoItem
implements EloEntity<TransferenciaDebitoItemId> {
    @EmbeddedId
    private TransferenciaDebitoItemId id;
    @JsonIgnore
    @MetaModelIgnore
    @MapsId(value="idtransferencia")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idtransferencia", referencedColumnName="idtransferencia")
    private TransferenciaDebito transferenciaDebito;
    @MapsId(value="iddebitoorigem")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="iddebitoorigem", referencedColumnName="iddebito")
    private Debito debitoOrigem;
    @MapsId(value="iddebitodestino")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="iddebitodestino", referencedColumnName="iddebito")
    private Debito debitoDestino;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idparcelamento", referencedColumnName="idparcelamento")
    private Parcelamento parcelamento;

    public static TransferenciaDebitoItem from(TransferenciaDebito transferenciaDebito, Debito debitoOrigem, Debito debitoDestino) {
        TransferenciaDebitoItem transferenciaDebitoItem = new TransferenciaDebitoItem();
        transferenciaDebitoItem.setId(TransferenciaDebitoItemId.from((Long)transferenciaDebito.getId(), (Long)debitoOrigem.getId(), (Long)debitoDestino.getId()));
        transferenciaDebitoItem.setTransferenciaDebito(transferenciaDebito);
        transferenciaDebitoItem.setDebitoOrigem(debitoOrigem);
        transferenciaDebitoItem.setDebitoDestino(debitoDestino);
        return transferenciaDebitoItem;
    }

    public List<DebitoParcela> getParcelasDebitoOrigem() {
        return this.debitoOrigem.getParcelas().stream().filter(parcelaOrigem -> this.debitoDestino.getParcelas().stream().anyMatch(parcelaDestino -> Objects.equals(parcelaDestino.getId().getEntidade(), parcelaOrigem.getId().getEntidade()) && Objects.equals(parcelaDestino.getId().getExercicio(), parcelaOrigem.getId().getExercicio()) && Objects.equals(parcelaDestino.getId().getDivida(), parcelaOrigem.getId().getDivida()) && Objects.equals(parcelaDestino.getId().getParcela(), parcelaOrigem.getId().getParcela()))).collect(Collectors.toList());
    }

    public BigDecimal getValorTotalParcelasDebitoOrigem() {
        return this.getParcelasDebitoOrigem().stream().map(DebitoParcela::getValorTotal).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public BigDecimal getValorTotalParcelasDebitoDestino() {
        return this.debitoDestino.getParcelas().stream().map(DebitoParcela::getValorTotal).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @Generated
    public static TransferenciaDebitoItemBuilder builder() {
        return new TransferenciaDebitoItemBuilder();
    }

    @Generated
    public TransferenciaDebitoItemId getId() {
        return this.id;
    }

    @Generated
    public TransferenciaDebito getTransferenciaDebito() {
        return this.transferenciaDebito;
    }

    @Generated
    public Debito getDebitoOrigem() {
        return this.debitoOrigem;
    }

    @Generated
    public Debito getDebitoDestino() {
        return this.debitoDestino;
    }

    @Generated
    public Parcelamento getParcelamento() {
        return this.parcelamento;
    }

    @Generated
    public void setId(TransferenciaDebitoItemId id) {
        this.id = id;
    }

    @JsonIgnore
    @Generated
    public void setTransferenciaDebito(TransferenciaDebito transferenciaDebito) {
        this.transferenciaDebito = transferenciaDebito;
    }

    @Generated
    public void setDebitoOrigem(Debito debitoOrigem) {
        this.debitoOrigem = debitoOrigem;
    }

    @Generated
    public void setDebitoDestino(Debito debitoDestino) {
        this.debitoDestino = debitoDestino;
    }

    @Generated
    public void setParcelamento(Parcelamento parcelamento) {
        this.parcelamento = parcelamento;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransferenciaDebitoItem)) {
            return false;
        }
        TransferenciaDebitoItem other = (TransferenciaDebitoItem)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        TransferenciaDebitoItemId this$id = this.getId();
        TransferenciaDebitoItemId other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        TransferenciaDebito this$transferenciaDebito = this.getTransferenciaDebito();
        TransferenciaDebito other$transferenciaDebito = other.getTransferenciaDebito();
        if (this$transferenciaDebito == null ? other$transferenciaDebito != null : !this$transferenciaDebito.equals(other$transferenciaDebito)) {
            return false;
        }
        Debito this$debitoOrigem = this.getDebitoOrigem();
        Debito other$debitoOrigem = other.getDebitoOrigem();
        if (this$debitoOrigem == null ? other$debitoOrigem != null : !this$debitoOrigem.equals(other$debitoOrigem)) {
            return false;
        }
        Debito this$debitoDestino = this.getDebitoDestino();
        Debito other$debitoDestino = other.getDebitoDestino();
        if (this$debitoDestino == null ? other$debitoDestino != null : !this$debitoDestino.equals(other$debitoDestino)) {
            return false;
        }
        Parcelamento this$parcelamento = this.getParcelamento();
        Parcelamento other$parcelamento = other.getParcelamento();
        return !(this$parcelamento == null ? other$parcelamento != null : !this$parcelamento.equals(other$parcelamento));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TransferenciaDebitoItem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TransferenciaDebitoItemId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        TransferenciaDebito $transferenciaDebito = this.getTransferenciaDebito();
        result = result * 59 + ($transferenciaDebito == null ? 43 : $transferenciaDebito.hashCode());
        Debito $debitoOrigem = this.getDebitoOrigem();
        result = result * 59 + ($debitoOrigem == null ? 43 : $debitoOrigem.hashCode());
        Debito $debitoDestino = this.getDebitoDestino();
        result = result * 59 + ($debitoDestino == null ? 43 : $debitoDestino.hashCode());
        Parcelamento $parcelamento = this.getParcelamento();
        result = result * 59 + ($parcelamento == null ? 43 : $parcelamento.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TransferenciaDebitoItem(id=" + String.valueOf(this.getId()) + ", transferenciaDebito=" + String.valueOf(this.getTransferenciaDebito()) + ", debitoOrigem=" + String.valueOf(this.getDebitoOrigem()) + ", debitoDestino=" + String.valueOf(this.getDebitoDestino()) + ", parcelamento=" + String.valueOf(this.getParcelamento()) + ")";
    }

    @Generated
    public TransferenciaDebitoItem() {
    }

    @Generated
    public TransferenciaDebitoItem(TransferenciaDebitoItemId id, TransferenciaDebito transferenciaDebito, Debito debitoOrigem, Debito debitoDestino, Parcelamento parcelamento) {
        this.id = id;
        this.transferenciaDebito = transferenciaDebito;
        this.debitoOrigem = debitoOrigem;
        this.debitoDestino = debitoDestino;
        this.parcelamento = parcelamento;
    }
}

