/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.tarefaassincrona;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaExecucao;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaParametro;
import br.com.elotech.tributos.domain.tarefaassincrona.TipoTarefaAssincrona;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lombok.Generated;

@Table(name="tarefaassincrona")
@Entity
public class TarefaAssincrona
implements EloEntity<Long> {
    @Id
    @EloSequence(sequenceName="seq_tarefaassincrona")
    private Long id;
    @Enumerated(value=EnumType.STRING)
    private TipoTarefaAssincrona tipo;
    @OneToMany(mappedBy="tarefaAssincrona", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<TarefaAssincronaExecucao> execucoes = new ArrayList();
    @OneToMany(mappedBy="tarefaAssincrona", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<TarefaAssincronaParametro> parametros = new ArrayList();

    public void addExecucao(TarefaAssincronaExecucao execucao) {
        this.execucoes.add(execucao);
        execucao.setTarefaAssincrona(this);
    }

    public void addParametro(TarefaAssincronaParametro parametro) {
        this.parametros.add(parametro);
        parametro.setTarefaAssincrona(this);
    }

    public Long getLastExecucaoId() {
        return this.execucoes.stream().map(TarefaAssincronaExecucao::getId).max(Long::compareTo).orElse(null);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TarefaAssincrona)) {
            return false;
        }
        TarefaAssincrona other = (TarefaAssincrona)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TarefaAssincrona;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public TarefaAssincrona() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public TipoTarefaAssincrona getTipo() {
        return this.tipo;
    }

    @Generated
    public List<TarefaAssincronaExecucao> getExecucoes() {
        return this.execucoes;
    }

    @Generated
    public List<TarefaAssincronaParametro> getParametros() {
        return this.parametros;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTipo(TipoTarefaAssincrona tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setExecucoes(List<TarefaAssincronaExecucao> execucoes) {
        this.execucoes = execucoes;
    }

    @Generated
    public void setParametros(List<TarefaAssincronaParametro> parametros) {
        this.parametros = parametros;
    }

    @Generated
    public String toString() {
        return "TarefaAssincrona(id=" + this.getId() + ", tipo=" + String.valueOf(this.getTipo()) + ", execucoes=" + String.valueOf(this.getExecucoes()) + ", parametros=" + String.valueOf(this.getParametros()) + ")";
    }
}

