/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.simam;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.converter.ClassificacaoTipoTributoConverter;
import br.com.elotech.tributos.converter.TipoNaturezaCreditoConverter;
import br.com.elotech.tributos.converter.TipoOperacaoCreditoConverter;
import br.com.elotech.tributos.domain.simam.LancamentoCreditoTributo;
import br.com.elotech.tributos.dto.ClassificacaoTipoTributo;
import br.com.elotech.tributos.dto.TipoNaturezaCredito;
import br.com.elotech.tributos.dto.TipoOperacaoCredito;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.Formula;
import org.hibernate.envers.NotAudited;

@Entity
@Table(name="tcelanccredito")
public class LancamentoCredito
implements EloEntity<Long> {
    @Id
    @Column(name="idtcelanccredito")
    @EloSequence(applyOnMerge=true, sequenceName="s_lancamentocredito_id")
    private Long id;
    private Long nrCredito;
    private Long nrAnoCredito;
    @Column(name="idtiponaturezacredito")
    @Convert(converter=TipoNaturezaCreditoConverter.class)
    private TipoNaturezaCredito tipoNaturezaCredito;
    @Column(name="idtipocredito")
    @Convert(converter=ClassificacaoTipoTributoConverter.class)
    private ClassificacaoTipoTributo tipoCredito;
    @Column(name="idtipooperacaocredito")
    @Convert(converter=TipoOperacaoCreditoConverter.class)
    private TipoOperacaoCredito tipoOperacaoCredito;
    @Column(name="dtlancamento")
    private LocalDate dataLancamento = LocalDate.now();
    @Column(name="vllancamento")
    private BigDecimal valorLancamento = BigDecimal.ZERO;
    @NotAudited
    @OneToMany(mappedBy="id.lancamentoCredito", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<LancamentoCreditoTributo> lancamentoCreditoTributos = new ArrayList();
    @Formula(value="(select case when sum(1) > 0 then 1 else 2 end from triberrosimportacaosimam te  where te.identificadorarquivo = 'LANCAMENTO_CREDITO'  and te.idregistro = idtcelanccredito )")
    private Long hasErros;
    private Long nrMesBase;
    private Long nrAnoBase;
    private Long cdControleLeiAto;

    public Boolean getHasErros() {
        return this.hasErros != null && this.hasErros.equals(1L);
    }

    @Generated
    public LancamentoCredito() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getNrCredito() {
        return this.nrCredito;
    }

    @Generated
    public Long getNrAnoCredito() {
        return this.nrAnoCredito;
    }

    @Generated
    public TipoNaturezaCredito getTipoNaturezaCredito() {
        return this.tipoNaturezaCredito;
    }

    @Generated
    public ClassificacaoTipoTributo getTipoCredito() {
        return this.tipoCredito;
    }

    @Generated
    public TipoOperacaoCredito getTipoOperacaoCredito() {
        return this.tipoOperacaoCredito;
    }

    @Generated
    public LocalDate getDataLancamento() {
        return this.dataLancamento;
    }

    @Generated
    public BigDecimal getValorLancamento() {
        return this.valorLancamento;
    }

    @Generated
    public List<LancamentoCreditoTributo> getLancamentoCreditoTributos() {
        return this.lancamentoCreditoTributos;
    }

    @Generated
    public Long getNrMesBase() {
        return this.nrMesBase;
    }

    @Generated
    public Long getNrAnoBase() {
        return this.nrAnoBase;
    }

    @Generated
    public Long getCdControleLeiAto() {
        return this.cdControleLeiAto;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setNrCredito(Long nrCredito) {
        this.nrCredito = nrCredito;
    }

    @Generated
    public void setNrAnoCredito(Long nrAnoCredito) {
        this.nrAnoCredito = nrAnoCredito;
    }

    @Generated
    public void setTipoNaturezaCredito(TipoNaturezaCredito tipoNaturezaCredito) {
        this.tipoNaturezaCredito = tipoNaturezaCredito;
    }

    @Generated
    public void setTipoCredito(ClassificacaoTipoTributo tipoCredito) {
        this.tipoCredito = tipoCredito;
    }

    @Generated
    public void setTipoOperacaoCredito(TipoOperacaoCredito tipoOperacaoCredito) {
        this.tipoOperacaoCredito = tipoOperacaoCredito;
    }

    @Generated
    public void setDataLancamento(LocalDate dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    @Generated
    public void setValorLancamento(BigDecimal valorLancamento) {
        this.valorLancamento = valorLancamento;
    }

    @Generated
    public void setLancamentoCreditoTributos(List<LancamentoCreditoTributo> lancamentoCreditoTributos) {
        this.lancamentoCreditoTributos = lancamentoCreditoTributos;
    }

    @Generated
    public void setHasErros(Long hasErros) {
        this.hasErros = hasErros;
    }

    @Generated
    public void setNrMesBase(Long nrMesBase) {
        this.nrMesBase = nrMesBase;
    }

    @Generated
    public void setNrAnoBase(Long nrAnoBase) {
        this.nrAnoBase = nrAnoBase;
    }

    @Generated
    public void setCdControleLeiAto(Long cdControleLeiAto) {
        this.cdControleLeiAto = cdControleLeiAto;
    }

    @Generated
    public String toString() {
        return "LancamentoCredito(id=" + this.getId() + ", nrCredito=" + this.getNrCredito() + ", nrAnoCredito=" + this.getNrAnoCredito() + ", tipoNaturezaCredito=" + String.valueOf(this.getTipoNaturezaCredito()) + ", tipoCredito=" + String.valueOf(this.getTipoCredito()) + ", tipoOperacaoCredito=" + String.valueOf(this.getTipoOperacaoCredito()) + ", dataLancamento=" + String.valueOf(this.getDataLancamento()) + ", valorLancamento=" + String.valueOf(this.getValorLancamento()) + ", lancamentoCreditoTributos=" + String.valueOf(this.getLancamentoCreditoTributos()) + ", hasErros=" + this.getHasErros() + ", nrMesBase=" + this.getNrMesBase() + ", nrAnoBase=" + this.getNrAnoBase() + ", cdControleLeiAto=" + this.getCdControleLeiAto() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LancamentoCredito)) {
            return false;
        }
        LancamentoCredito other = (LancamentoCredito)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LancamentoCredito;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

