/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.sanepar;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.Tributo;
import br.com.elotech.tributos.enums.sanepar.TipoBaixaSanepar;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;

@Entity
@Table(name="tribbaixamanualsaneparconfig", uniqueConstraints={@UniqueConstraint(columnNames={"entidade", "exercicio"})})
public class SaneparConfiguracao
implements EloEntity<Long> {
    @Id
    @EloSequence(applyOnMerge=true, sequenceName="s05BaixaManualSaneparConfig")
    private Long id;
    @NotNull
    private Long entidade;
    @NotNull
    private Long exercicio;
    @ManyToOne
    @JoinColumn(name="convenio")
    private Convenio convenio;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(formula=@JoinFormula(value="exercicio", referencedColumnName="exercicio")), @JoinColumnOrFormula(column=@JoinColumn(name="a_guiarecolhimento", referencedColumnName="guiarecolhimento"))})
    private Divida dividaArrecadacao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(formula=@JoinFormula(value="exercicio", referencedColumnName="exercicio")), @JoinColumnOrFormula(column=@JoinColumn(name="a_receita", referencedColumnName="receita"))})
    private Tributo tributoArrecadacao;
    @ManyToOne
    @JoinColumn(name="a_formapag", referencedColumnName="formaPagamento")
    private FormaPagamento formaPagamentoArrecadacao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(formula=@JoinFormula(value="exercicio", referencedColumnName="exercicio")), @JoinColumnOrFormula(column=@JoinColumn(name="m_guiarecolhimento", referencedColumnName="guiarecolhimento"))})
    private Divida dividaMulta;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(formula=@JoinFormula(value="exercicio", referencedColumnName="exercicio")), @JoinColumnOrFormula(column=@JoinColumn(name="m_receita", referencedColumnName="receita"))})
    private Tributo tributoMulta;
    @ManyToOne
    @JoinColumn(name="m_formapag", referencedColumnName="formaPagamento")
    private FormaPagamento formaPagamentoMulta;

    public Divida getDivida(TipoBaixaSanepar tipoBaixaSanepar) {
        if (tipoBaixaSanepar.equals((Object)TipoBaixaSanepar.ARRECADACAO)) {
            return this.getDividaArrecadacao();
        }
        return this.getDividaMulta();
    }

    public Tributo getTributo(TipoBaixaSanepar tipoBaixaSanepar) {
        if (tipoBaixaSanepar.equals((Object)TipoBaixaSanepar.ARRECADACAO)) {
            return this.getTributoArrecadacao();
        }
        return this.getTributoMulta();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Convenio getConvenio() {
        return this.convenio;
    }

    @Generated
    public Divida getDividaArrecadacao() {
        return this.dividaArrecadacao;
    }

    @Generated
    public Tributo getTributoArrecadacao() {
        return this.tributoArrecadacao;
    }

    @Generated
    public FormaPagamento getFormaPagamentoArrecadacao() {
        return this.formaPagamentoArrecadacao;
    }

    @Generated
    public Divida getDividaMulta() {
        return this.dividaMulta;
    }

    @Generated
    public Tributo getTributoMulta() {
        return this.tributoMulta;
    }

    @Generated
    public FormaPagamento getFormaPagamentoMulta() {
        return this.formaPagamentoMulta;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setConvenio(Convenio convenio) {
        this.convenio = convenio;
    }

    @Generated
    public void setDividaArrecadacao(Divida dividaArrecadacao) {
        this.dividaArrecadacao = dividaArrecadacao;
    }

    @Generated
    public void setTributoArrecadacao(Tributo tributoArrecadacao) {
        this.tributoArrecadacao = tributoArrecadacao;
    }

    @Generated
    public void setFormaPagamentoArrecadacao(FormaPagamento formaPagamentoArrecadacao) {
        this.formaPagamentoArrecadacao = formaPagamentoArrecadacao;
    }

    @Generated
    public void setDividaMulta(Divida dividaMulta) {
        this.dividaMulta = dividaMulta;
    }

    @Generated
    public void setTributoMulta(Tributo tributoMulta) {
        this.tributoMulta = tributoMulta;
    }

    @Generated
    public void setFormaPagamentoMulta(FormaPagamento formaPagamentoMulta) {
        this.formaPagamentoMulta = formaPagamentoMulta;
    }

    @Generated
    public String toString() {
        return "SaneparConfiguracao(id=" + this.getId() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", convenio=" + String.valueOf(this.getConvenio()) + ", dividaArrecadacao=" + String.valueOf(this.getDividaArrecadacao()) + ", tributoArrecadacao=" + String.valueOf(this.getTributoArrecadacao()) + ", formaPagamentoArrecadacao=" + String.valueOf(this.getFormaPagamentoArrecadacao()) + ", dividaMulta=" + String.valueOf(this.getDividaMulta()) + ", tributoMulta=" + String.valueOf(this.getTributoMulta()) + ", formaPagamentoMulta=" + String.valueOf(this.getFormaPagamentoMulta()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SaneparConfiguracao)) {
            return false;
        }
        SaneparConfiguracao other = (SaneparConfiguracao)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SaneparConfiguracao;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public SaneparConfiguracao() {
    }
}

