/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.rocada;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.rocada.RocadaCadastro;
import br.com.elotech.tributos.domain.rocada.RocadaId;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="tribrocada")
public class Rocada
implements EloEntity<RocadaId>,
Serializable {
    @EmbeddedId
    private RocadaId id;
    private LocalDate dataLancamento;
    private LocalDate dataVencimento;
    private String usuario;
    private Long exercicioComunicado;
    private Long idComunicado;
    @Length(max=20, message="Tamanho m\u00e1ximo do processo SEI \u00e9 de 20")
    private @Length(max=20, message="Tamanho m\u00e1ximo do processo SEI \u00e9 de 20") String processoSei;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean debitoGerado = Boolean.FALSE;
    @OneToMany(mappedBy="rocada", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<RocadaCadastro> cadastros = new ArrayList();

    @Generated
    public Rocada() {
    }

    @Generated
    public RocadaId getId() {
        return this.id;
    }

    @Generated
    public LocalDate getDataLancamento() {
        return this.dataLancamento;
    }

    @Generated
    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public Long getExercicioComunicado() {
        return this.exercicioComunicado;
    }

    @Generated
    public Long getIdComunicado() {
        return this.idComunicado;
    }

    @Generated
    public String getProcessoSei() {
        return this.processoSei;
    }

    @Generated
    public Boolean getDebitoGerado() {
        return this.debitoGerado;
    }

    @Generated
    public List<RocadaCadastro> getCadastros() {
        return this.cadastros;
    }

    @Generated
    public void setId(RocadaId id) {
        this.id = id;
    }

    @Generated
    public void setDataLancamento(LocalDate dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    @Generated
    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setExercicioComunicado(Long exercicioComunicado) {
        this.exercicioComunicado = exercicioComunicado;
    }

    @Generated
    public void setIdComunicado(Long idComunicado) {
        this.idComunicado = idComunicado;
    }

    @Generated
    public void setProcessoSei(String processoSei) {
        this.processoSei = processoSei;
    }

    @Generated
    public void setDebitoGerado(Boolean debitoGerado) {
        this.debitoGerado = debitoGerado;
    }

    @Generated
    public void setCadastros(List<RocadaCadastro> cadastros) {
        this.cadastros = cadastros;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Rocada)) {
            return false;
        }
        Rocada other = (Rocada)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        RocadaId this$id = this.getId();
        RocadaId other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Rocada;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RocadaId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Rocada(id=" + String.valueOf(this.getId()) + ")";
    }
}

